"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sentry_protos.snuba.v1.attribute_conditional_aggregation_pb2
import sentry_protos.snuba.v1.formula_pb2
import sentry_protos.snuba.v1.request_common_pb2
import sentry_protos.snuba.v1.trace_item_attribute_pb2
import sentry_protos.snuba.v1.trace_item_filter_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class TimeSeriesRequest(google.protobuf.message.Message):
    """This is a request to the TimeSeries endpoint,
    it is used to do a timeseries aggregation of a given attribute
    across traces.

    ex: avg(span.duration) group by db.system
    this (conceptually) will return a 2d graph where y-axis is avg(span.duration),
    x-axis is time, and there is a separate line/function on the graph for each db.system value
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    META_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    AGGREGATIONS_FIELD_NUMBER: builtins.int
    EXPRESSIONS_FIELD_NUMBER: builtins.int
    GRANULARITY_SECS_FIELD_NUMBER: builtins.int
    GROUP_BY_FIELD_NUMBER: builtins.int
    TRACE_FILTERS_FIELD_NUMBER: builtins.int
    granularity_secs: builtins.int
    """the level of detail in the timeseries graph,
    low granularity is very detailed, high is less detail.
    ex: if granularity is 1s you will have a data point every 1s,
        if its 1m you have a data point every 1m
    tip: for performance, if the query is is over a large time period you should
     have high granularity
    """
    @property
    def meta(self) -> sentry_protos.snuba.v1.request_common_pb2.RequestMeta:
        """metadata about the request
        used to filter time range, organization, project, etc.
        """

    @property
    def filter(self) -> sentry_protos.snuba.v1.trace_item_filter_pb2.TraceItemFilter:
        """filters out spans (TraceItems) that dont meet the criteria
        ex: avg(span.duration) where span.environment = 'production'
        """

    @property
    def aggregations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[sentry_protos.snuba.v1.trace_item_attribute_pb2.AttributeAggregation]:
        """deprecated, please use expressions instead"""

    @property
    def expressions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Expression]:
        """the actual aggregation to compute ex: avg(span.duration) or avg(span.duration) / sum(span.duration)"""

    @property
    def group_by(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[sentry_protos.snuba.v1.trace_item_attribute_pb2.AttributeKey]:
        """attribute key to group by
        ex: span.environment might give 3 timeseries lines,
            one for prod, one for dev etc
        """

    @property
    def trace_filters(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[sentry_protos.snuba.v1.request_common_pb2.TraceItemFilterWithType]:
        """A list of filters applied to each item type provided. These filters will be applied on a trace level to find traces
        that contain each of the provided items with matching conditions. The overall request will then only apply on those traces.
        If specified, the endpoint will only consider traces that match all the filters.
        ex: Find the number of spans in traces containing a span with op = 'db' that also contain errors with message = 'timeout'
        """

    def __init__(
        self,
        *,
        meta: sentry_protos.snuba.v1.request_common_pb2.RequestMeta | None = ...,
        filter: sentry_protos.snuba.v1.trace_item_filter_pb2.TraceItemFilter | None = ...,
        aggregations: collections.abc.Iterable[sentry_protos.snuba.v1.trace_item_attribute_pb2.AttributeAggregation] | None = ...,
        expressions: collections.abc.Iterable[global___Expression] | None = ...,
        granularity_secs: builtins.int = ...,
        group_by: collections.abc.Iterable[sentry_protos.snuba.v1.trace_item_attribute_pb2.AttributeKey] | None = ...,
        trace_filters: collections.abc.Iterable[sentry_protos.snuba.v1.request_common_pb2.TraceItemFilterWithType] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["filter", b"filter", "meta", b"meta"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["aggregations", b"aggregations", "expressions", b"expressions", "filter", b"filter", "granularity_secs", b"granularity_secs", "group_by", b"group_by", "meta", b"meta", "trace_filters", b"trace_filters"]) -> None: ...

global___TimeSeriesRequest = TimeSeriesRequest

@typing.final
class Expression(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class BinaryFormula(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class _Op:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _OpEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Expression.BinaryFormula._Op.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            OP_UNSPECIFIED: Expression.BinaryFormula._Op.ValueType  # 0
            OP_DIVIDE: Expression.BinaryFormula._Op.ValueType  # 1
            OP_MULTIPLY: Expression.BinaryFormula._Op.ValueType  # 2
            OP_ADD: Expression.BinaryFormula._Op.ValueType  # 3
            OP_SUBTRACT: Expression.BinaryFormula._Op.ValueType  # 4

        class Op(_Op, metaclass=_OpEnumTypeWrapper): ...
        OP_UNSPECIFIED: Expression.BinaryFormula.Op.ValueType  # 0
        OP_DIVIDE: Expression.BinaryFormula.Op.ValueType  # 1
        OP_MULTIPLY: Expression.BinaryFormula.Op.ValueType  # 2
        OP_ADD: Expression.BinaryFormula.Op.ValueType  # 3
        OP_SUBTRACT: Expression.BinaryFormula.Op.ValueType  # 4

        OP_FIELD_NUMBER: builtins.int
        LEFT_FIELD_NUMBER: builtins.int
        RIGHT_FIELD_NUMBER: builtins.int
        DEFAULT_VALUE_DOUBLE_FIELD_NUMBER: builtins.int
        DEFAULT_VALUE_INT64_FIELD_NUMBER: builtins.int
        op: global___Expression.BinaryFormula.Op.ValueType
        default_value_double: builtins.float
        default_value_int64: builtins.int
        @property
        def left(self) -> global___Expression: ...
        @property
        def right(self) -> global___Expression: ...
        def __init__(
            self,
            *,
            op: global___Expression.BinaryFormula.Op.ValueType = ...,
            left: global___Expression | None = ...,
            right: global___Expression | None = ...,
            default_value_double: builtins.float = ...,
            default_value_int64: builtins.int = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["default_value", b"default_value", "default_value_double", b"default_value_double", "default_value_int64", b"default_value_int64", "left", b"left", "right", b"right"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["default_value", b"default_value", "default_value_double", b"default_value_double", "default_value_int64", b"default_value_int64", "left", b"left", "op", b"op", "right", b"right"]) -> None: ...
        def WhichOneof(self, oneof_group: typing.Literal["default_value", b"default_value"]) -> typing.Literal["default_value_double", "default_value_int64"] | None: ...

    AGGREGATION_FIELD_NUMBER: builtins.int
    FORMULA_FIELD_NUMBER: builtins.int
    CONDITIONAL_AGGREGATION_FIELD_NUMBER: builtins.int
    LITERAL_FIELD_NUMBER: builtins.int
    LABEL_FIELD_NUMBER: builtins.int
    label: builtins.str
    @property
    def aggregation(self) -> sentry_protos.snuba.v1.trace_item_attribute_pb2.AttributeAggregation: ...
    @property
    def formula(self) -> global___Expression.BinaryFormula: ...
    @property
    def conditional_aggregation(self) -> sentry_protos.snuba.v1.attribute_conditional_aggregation_pb2.AttributeConditionalAggregation: ...
    @property
    def literal(self) -> sentry_protos.snuba.v1.formula_pb2.Literal: ...
    def __init__(
        self,
        *,
        aggregation: sentry_protos.snuba.v1.trace_item_attribute_pb2.AttributeAggregation | None = ...,
        formula: global___Expression.BinaryFormula | None = ...,
        conditional_aggregation: sentry_protos.snuba.v1.attribute_conditional_aggregation_pb2.AttributeConditionalAggregation | None = ...,
        literal: sentry_protos.snuba.v1.formula_pb2.Literal | None = ...,
        label: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["aggregation", b"aggregation", "conditional_aggregation", b"conditional_aggregation", "expression", b"expression", "formula", b"formula", "literal", b"literal"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["aggregation", b"aggregation", "conditional_aggregation", b"conditional_aggregation", "expression", b"expression", "formula", b"formula", "label", b"label", "literal", b"literal"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["expression", b"expression"]) -> typing.Literal["aggregation", "formula", "conditional_aggregation", "literal"] | None: ...

global___Expression = Expression

@typing.final
class DataPoint(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATA_FIELD_NUMBER: builtins.int
    DATA_PRESENT_FIELD_NUMBER: builtins.int
    AVG_SAMPLING_RATE_FIELD_NUMBER: builtins.int
    IS_RELIABLE_FIELD_NUMBER: builtins.int
    RELIABILITY_FIELD_NUMBER: builtins.int
    SAMPLE_COUNT_FIELD_NUMBER: builtins.int
    data: builtins.float
    data_present: builtins.bool
    """false if this datapoint is empty, true otherwise.
    optional, if not set assume true.
    used for sparse time series
    """
    avg_sampling_rate: builtins.float
    """only set for extrapolated data points, 0 otherwise
    the extrapolated avg sampling rate for this data point
    """
    is_reliable: builtins.bool
    """deprecated"""
    reliability: sentry_protos.snuba.v1.trace_item_attribute_pb2.Reliability.ValueType
    """the reliability of the data value based on math based on confidence intervals and sample size"""
    sample_count: builtins.int
    """the sample count for this data point"""
    def __init__(
        self,
        *,
        data: builtins.float = ...,
        data_present: builtins.bool = ...,
        avg_sampling_rate: builtins.float = ...,
        is_reliable: builtins.bool = ...,
        reliability: sentry_protos.snuba.v1.trace_item_attribute_pb2.Reliability.ValueType = ...,
        sample_count: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["avg_sampling_rate", b"avg_sampling_rate", "data", b"data", "data_present", b"data_present", "is_reliable", b"is_reliable", "reliability", b"reliability", "sample_count", b"sample_count"]) -> None: ...

global___DataPoint = DataPoint

@typing.final
class TimeSeries(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class GroupByAttributesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    LABEL_FIELD_NUMBER: builtins.int
    GROUP_BY_ATTRIBUTES_FIELD_NUMBER: builtins.int
    BUCKETS_FIELD_NUMBER: builtins.int
    DATA_POINTS_FIELD_NUMBER: builtins.int
    NUM_EVENTS_FIELD_NUMBER: builtins.int
    AVG_SAMPLING_RATE_FIELD_NUMBER: builtins.int
    label: builtins.str
    num_events: builtins.int
    """number of events used to calculate this timeseries"""
    avg_sampling_rate: builtins.float
    """deprecated"""
    @property
    def group_by_attributes(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """the names and values of the attribute keys which
        were in the group by
        """

    @property
    def buckets(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.timestamp_pb2.Timestamp]:
        """time bucket for each data point in the timeseries"""

    @property
    def data_points(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___DataPoint]: ...
    def __init__(
        self,
        *,
        label: builtins.str = ...,
        group_by_attributes: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        buckets: collections.abc.Iterable[google.protobuf.timestamp_pb2.Timestamp] | None = ...,
        data_points: collections.abc.Iterable[global___DataPoint] | None = ...,
        num_events: builtins.int = ...,
        avg_sampling_rate: builtins.float = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["avg_sampling_rate", b"avg_sampling_rate", "buckets", b"buckets", "data_points", b"data_points", "group_by_attributes", b"group_by_attributes", "label", b"label", "num_events", b"num_events"]) -> None: ...

global___TimeSeries = TimeSeries

@typing.final
class TimeSeriesResponse(google.protobuf.message.Message):
    """This is the response from the TimeSeries endpoint,
    it is the counterpart of TimeSeriesRequest
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESULT_TIMESERIES_FIELD_NUMBER: builtins.int
    META_FIELD_NUMBER: builtins.int
    @property
    def result_timeseries(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___TimeSeries]: ...
    @property
    def meta(self) -> sentry_protos.snuba.v1.request_common_pb2.ResponseMeta: ...
    def __init__(
        self,
        *,
        result_timeseries: collections.abc.Iterable[global___TimeSeries] | None = ...,
        meta: sentry_protos.snuba.v1.request_common_pb2.ResponseMeta | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["meta", b"meta"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["meta", b"meta", "result_timeseries", b"result_timeseries"]) -> None: ...

global___TimeSeriesResponse = TimeSeriesResponse
