# Contributing

Contributions to Ward are encouraged and very welcome!

You can install Ward for local development using `flit install -s`.

Contributions can come in many forms: documentation enhancements, features, bug fixes, creating issues, and participating in the community.

If you're interested in helping out, you might find some inspiration in [Issues](https://github.com/darrenburns/ward/issues). If you have an idea, but don't see it there, don't hesitate to create a new issue.

Before submitting a pull request, please make sure the enhancement or bugfix you've made has been discussed. 

This will ensure no work is duplicated, and that a general approach has been agreed.

Please also take time to review the [Code of Conduct](https://github.com/darrenburns/ward/blob/master/.github/CODE_OF_CONDUCT.md). Anyone who violates the code of conduct may be barred from contributing.

## Pull request guidelines

When creating a PR:

* Code is formatted using `make format`
* Ensure `README.md` is updated if necessary.
* Tests written cover new code, and running `ward` results in a pass.

If something is missing from this guide (it probably is), please let me know by creating an issue or a pull request.
