from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import DataType
from pyspark.sql.types import IntegerType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class VisionPrescription_DispenseSchema:
    """
    An authorization for the supply of glasses and/or contact lenses to a patient.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
    ) -> Union[StructType, DataType]:
        """
        An authorization for the supply of glasses and/or contact lenses to a patient.


        product: Identifies the type of vision correction product which is required for the
            patient.

        eye: The eye for which the lens applies.

        sphere: Lens power measured in diopters (0.25 units).

        cylinder: Power adjustment for astigmatism measured in diopters (0.25 units).

        axis: Adjustment for astigmatism measured in integer degrees.

        prism: Amount of prism to compensate for eye alignment in fractional units.

        base: The relative base, or reference lens edge, for the prism.

        add: Power adjustment for multifocal lenses measured in diopters (0.25 units).

        power: Contact lens power measured in diopters (0.25 units).

        backCurve: Back curvature measured in millimeters.

        diameter: Contact lens diameter measured in millimeters.

        duration: The recommended maximum wear period for the lens.

        color: Special color or pattern.

        brand: Brand recommendations or restrictions.

        note: Notes for special requirements such as coatings and lens materials.

        """
        from spark_fhir_schemas.stu3.complex_types.codeableconcept import (
            CodeableConceptSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.quantity import QuantitySchema
        from spark_fhir_schemas.stu3.complex_types.annotation import AnnotationSchema

        if (
            max_recursion_limit
            and nesting_list.count("VisionPrescription_Dispense") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["VisionPrescription_Dispense"]
        schema = StructType(
            [
                # Identifies the type of vision correction product which is required for the
                # patient.
                StructField(
                    "product",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The eye for which the lens applies.
                StructField("eye", StringType(), True),
                # Lens power measured in diopters (0.25 units).
                StructField("sphere", IntegerType(), True),
                # Power adjustment for astigmatism measured in diopters (0.25 units).
                StructField("cylinder", IntegerType(), True),
                # Adjustment for astigmatism measured in integer degrees.
                StructField("axis", IntegerType(), True),
                # Amount of prism to compensate for eye alignment in fractional units.
                StructField("prism", IntegerType(), True),
                # The relative base, or reference lens edge, for the prism.
                StructField("base", StringType(), True),
                # Power adjustment for multifocal lenses measured in diopters (0.25 units).
                StructField("add", IntegerType(), True),
                # Contact lens power measured in diopters (0.25 units).
                StructField("power", IntegerType(), True),
                # Back curvature measured in millimeters.
                StructField("backCurve", IntegerType(), True),
                # Contact lens diameter measured in millimeters.
                StructField("diameter", IntegerType(), True),
                # The recommended maximum wear period for the lens.
                StructField(
                    "duration",
                    QuantitySchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Special color or pattern.
                StructField("color", StringType(), True),
                # Brand recommendations or restrictions.
                StructField("brand", StringType(), True),
                # Notes for special requirements such as coatings and lens materials.
                StructField(
                    "note",
                    ArrayType(
                        AnnotationSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
