from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import BooleanType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class ValueSet_ComposeSchema:
    """
    A value set specifies a set of codes drawn from one or more code systems.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
    ) -> Union[StructType, DataType]:
        """
        A value set specifies a set of codes drawn from one or more code systems.


        lockedDate: If a locked date is defined, then the Content Logical Definition must be
            evaluated using the current version as of the locked date for referenced code
            system(s) and value set instances where ValueSet.compose.include.version is
            not defined.

        inactive: Whether inactive codes - codes that are not approved for current use - are in
            the value set. If inactive = true, inactive codes are to be included in the
            expansion, if inactive = false, the inactive codes will not be included in the
            expansion. If absent, the behavior is determined by the implementation, or by
            the applicable ExpansionProfile (but generally, inactive codes would be
            expected to be included).

        include: Include one or more codes from a code system or other value set(s).

        exclude: Exclude one or more codes from the value set based on code system filters
            and/or other value sets.

        """
        from spark_fhir_schemas.stu3.complex_types.valueset_include import (
            ValueSet_IncludeSchema,
        )

        if (
            max_recursion_limit
            and nesting_list.count("ValueSet_Compose") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["ValueSet_Compose"]
        schema = StructType(
            [
                # If a locked date is defined, then the Content Logical Definition must be
                # evaluated using the current version as of the locked date for referenced code
                # system(s) and value set instances where ValueSet.compose.include.version is
                # not defined.
                StructField("lockedDate", StringType(), True),
                # Whether inactive codes - codes that are not approved for current use - are in
                # the value set. If inactive = true, inactive codes are to be included in the
                # expansion, if inactive = false, the inactive codes will not be included in the
                # expansion. If absent, the behavior is determined by the implementation, or by
                # the applicable ExpansionProfile (but generally, inactive codes would be
                # expected to be included).
                StructField("inactive", BooleanType(), True),
                # Include one or more codes from a code system or other value set(s).
                StructField(
                    "include",
                    ArrayType(
                        ValueSet_IncludeSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # Exclude one or more codes from the value set based on code system filters
                # and/or other value sets.
                StructField(
                    "exclude",
                    ArrayType(
                        ValueSet_IncludeSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
