from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import DataType
from pyspark.sql.types import IntegerType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class Sequence_VariantSchema:
    """
    Raw data describing a biological sequence.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
    ) -> Union[StructType, DataType]:
        """
        Raw data describing a biological sequence.


        start: Start position of the variant on the  reference sequence.If the coordinate
            system is either 0-based or 1-based, then start position is inclusive.

        end: End position of the variant on the reference sequence.If the coordinate system
            is 0-based then end is is exclusive and does not include the last position. If
            the coordinate system is 1-base, then end is inclusive and includes the last
            position.

        observedAllele: An allele is one of a set of coexisting sequence variants of a gene ([SO:00010
            23](http://www.sequenceontology.org/browser/current_svn/term/SO:0001023)).
            Nucleotide(s)/amino acids from start position of sequence to stop position of
            sequence on the positive (+) strand of the observed  sequence. When the
            sequence  type is DNA, it should be the sequence on the positive (+) strand.
            This will lay in the range between variant.start and variant.end.

        referenceAllele: An allele is one of a set of coexisting sequence variants of a gene ([SO:00010
            23](http://www.sequenceontology.org/browser/current_svn/term/SO:0001023)).
            Nucleotide(s)/amino acids from start position of sequence to stop position of
            sequence on the positive (+) strand of the reference sequence. When the
            sequence  type is DNA, it should be the sequence on the positive (+) strand.
            This will lay in the range between variant.start and variant.end.

        cigar: Extended CIGAR string for aligning the sequence with reference bases. See
            detailed documentation [here](http://support.illumina.com/help/SequencingAnaly
            sisWorkflow/Content/Vault/Informatics/Sequencing_Analysis/CASAVA/swSEQ_mCA_Ext
            endedCIGARFormat.htm).

        variantPointer: A pointer to an Observation containing variant information.

        """
        from spark_fhir_schemas.stu3.complex_types.reference import ReferenceSchema

        if (
            max_recursion_limit
            and nesting_list.count("Sequence_Variant") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["Sequence_Variant"]
        schema = StructType(
            [
                # Start position of the variant on the  reference sequence.If the coordinate
                # system is either 0-based or 1-based, then start position is inclusive.
                StructField("start", IntegerType(), True),
                # End position of the variant on the reference sequence.If the coordinate system
                # is 0-based then end is is exclusive and does not include the last position. If
                # the coordinate system is 1-base, then end is inclusive and includes the last
                # position.
                StructField("end", IntegerType(), True),
                # An allele is one of a set of coexisting sequence variants of a gene ([SO:00010
                # 23](http://www.sequenceontology.org/browser/current_svn/term/SO:0001023)).
                # Nucleotide(s)/amino acids from start position of sequence to stop position of
                # sequence on the positive (+) strand of the observed  sequence. When the
                # sequence  type is DNA, it should be the sequence on the positive (+) strand.
                # This will lay in the range between variant.start and variant.end.
                StructField("observedAllele", StringType(), True),
                # An allele is one of a set of coexisting sequence variants of a gene ([SO:00010
                # 23](http://www.sequenceontology.org/browser/current_svn/term/SO:0001023)).
                # Nucleotide(s)/amino acids from start position of sequence to stop position of
                # sequence on the positive (+) strand of the reference sequence. When the
                # sequence  type is DNA, it should be the sequence on the positive (+) strand.
                # This will lay in the range between variant.start and variant.end.
                StructField("referenceAllele", StringType(), True),
                # Extended CIGAR string for aligning the sequence with reference bases. See
                # detailed documentation [here](http://support.illumina.com/help/SequencingAnaly
                # sisWorkflow/Content/Vault/Informatics/Sequencing_Analysis/CASAVA/swSEQ_mCA_Ext
                # endedCIGARFormat.htm).
                StructField("cigar", StringType(), True),
                # A pointer to an Observation containing variant information.
                StructField(
                    "variantPointer",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
