from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class RiskAssessmentSchema:
    """
    An assessment of the likely outcome(s) for a patient or other subject as well
    as the likelihood of each outcome.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
    ) -> Union[StructType, DataType]:
        """
        An assessment of the likely outcome(s) for a patient or other subject as well
        as the likelihood of each outcome.


        resourceType: This is a RiskAssessment resource

        identifier: Business identifier assigned to the risk assessment.

        basedOn: A reference to the request that is fulfilled by this risk assessment.

        parent: A reference to a resource that this risk assessment is part of, such as a
            Procedure.

        status: The status of the RiskAssessment, using the same statuses as an Observation.

        method: The algorithm, process or mechanism used to evaluate the risk.

        code: The type of the risk assessment performed.

        subject: The patient or group the risk assessment applies to.

        context: The encounter where the assessment was performed.

        occurrenceDateTime: The date (and possibly time) the risk assessment was performed.

        occurrencePeriod: The date (and possibly time) the risk assessment was performed.

        condition: For assessments or prognosis specific to a particular condition, indicates the
            condition being assessed.

        performer: The provider or software application that performed the assessment.

        reasonCodeableConcept: The reason the risk assessment was performed.

        reasonReference: The reason the risk assessment was performed.

        basis: Indicates the source data considered as part of the assessment (FamilyHistory,
            Observations, Procedures, Conditions, etc.).

        prediction: Describes the expected outcome for the subject.

        mitigation: A description of the steps that might be taken to reduce the identified
            risk(s).

        comment: Additional comments about the risk assessment.

        """
        from spark_fhir_schemas.stu3.complex_types.identifier import IdentifierSchema
        from spark_fhir_schemas.stu3.complex_types.reference import ReferenceSchema
        from spark_fhir_schemas.stu3.complex_types.codeableconcept import (
            CodeableConceptSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.period import PeriodSchema
        from spark_fhir_schemas.stu3.complex_types.riskassessment_prediction import (
            RiskAssessment_PredictionSchema,
        )

        if (
            max_recursion_limit
            and nesting_list.count("RiskAssessment") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["RiskAssessment"]
        schema = StructType(
            [
                # This is a RiskAssessment resource
                StructField("resourceType", StringType(), True),
                # Business identifier assigned to the risk assessment.
                StructField(
                    "identifier",
                    IdentifierSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # A reference to the request that is fulfilled by this risk assessment.
                StructField(
                    "basedOn",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # A reference to a resource that this risk assessment is part of, such as a
                # Procedure.
                StructField(
                    "parent",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The status of the RiskAssessment, using the same statuses as an Observation.
                StructField("status", StringType(), True),
                # The algorithm, process or mechanism used to evaluate the risk.
                StructField(
                    "method",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The type of the risk assessment performed.
                StructField(
                    "code",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The patient or group the risk assessment applies to.
                StructField(
                    "subject",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The encounter where the assessment was performed.
                StructField(
                    "context",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The date (and possibly time) the risk assessment was performed.
                StructField("occurrenceDateTime", StringType(), True),
                # The date (and possibly time) the risk assessment was performed.
                StructField(
                    "occurrencePeriod",
                    PeriodSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # For assessments or prognosis specific to a particular condition, indicates the
                # condition being assessed.
                StructField(
                    "condition",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The provider or software application that performed the assessment.
                StructField(
                    "performer",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The reason the risk assessment was performed.
                StructField(
                    "reasonCodeableConcept",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The reason the risk assessment was performed.
                StructField(
                    "reasonReference",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Indicates the source data considered as part of the assessment (FamilyHistory,
                # Observations, Procedures, Conditions, etc.).
                StructField(
                    "basis",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # Describes the expected outcome for the subject.
                StructField(
                    "prediction",
                    ArrayType(
                        RiskAssessment_PredictionSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # A description of the steps that might be taken to reduce the identified
                # risk(s).
                StructField("mitigation", StringType(), True),
                # Additional comments about the risk assessment.
                StructField("comment", StringType(), True),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
