from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import DataType
from pyspark.sql.types import IntegerType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class MedicationRequest_DispenseRequestSchema:
    """
    An order or request for both supply of the medication and the instructions for
    administration of the medication to a patient. The resource is called
    "MedicationRequest" rather than "MedicationPrescription" or "MedicationOrder"
    to generalize the use across inpatient and outpatient settings, including care
    plans, etc., and to harmonize with workflow patterns.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
    ) -> Union[StructType, DataType]:
        """
        An order or request for both supply of the medication and the instructions for
        administration of the medication to a patient. The resource is called
        "MedicationRequest" rather than "MedicationPrescription" or "MedicationOrder"
        to generalize the use across inpatient and outpatient settings, including care
        plans, etc., and to harmonize with workflow patterns.


        validityPeriod: This indicates the validity period of a prescription (stale dating the
            Prescription).

        numberOfRepeatsAllowed: An integer indicating the number of times, in addition to the original
            dispense, (aka refills or repeats) that the patient can receive the prescribed
            medication. Usage Notes: This integer does not include the original order
            dispense. This means that if an order indicates dispense 30 tablets plus "3
            repeats", then the order can be dispensed a total of 4 times and the patient
            can receive a total of 120 tablets.

        quantity: The amount that is to be dispensed for one fill.

        expectedSupplyDuration: Identifies the period time over which the supplied product is expected to be
            used, or the length of time the dispense is expected to last.

        performer: Indicates the intended dispensing Organization specified by the prescriber.

        """
        from spark_fhir_schemas.stu3.complex_types.period import PeriodSchema
        from spark_fhir_schemas.stu3.complex_types.quantity import QuantitySchema
        from spark_fhir_schemas.stu3.complex_types.duration import DurationSchema
        from spark_fhir_schemas.stu3.complex_types.reference import ReferenceSchema

        if (
            max_recursion_limit
            and nesting_list.count("MedicationRequest_DispenseRequest")
            >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + [
            "MedicationRequest_DispenseRequest"
        ]
        schema = StructType(
            [
                # This indicates the validity period of a prescription (stale dating the
                # Prescription).
                StructField(
                    "validityPeriod",
                    PeriodSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # An integer indicating the number of times, in addition to the original
                # dispense, (aka refills or repeats) that the patient can receive the prescribed
                # medication. Usage Notes: This integer does not include the original order
                # dispense. This means that if an order indicates dispense 30 tablets plus "3
                # repeats", then the order can be dispensed a total of 4 times and the patient
                # can receive a total of 120 tablets.
                StructField("numberOfRepeatsAllowed", IntegerType(), True),
                # The amount that is to be dispensed for one fill.
                StructField(
                    "quantity",
                    QuantitySchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Identifies the period time over which the supplied product is expected to be
                # used, or the length of time the dispense is expected to last.
                StructField(
                    "expectedSupplyDuration",
                    DurationSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Indicates the intended dispensing Organization specified by the prescriber.
                StructField(
                    "performer",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
