from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import DataType
from pyspark.sql.types import IntegerType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class ImmunizationRecommendation_RecommendationSchema:
    """
    A patient's point-in-time immunization and recommendation (i.e. forecasting a
    patient's immunization eligibility according to a published schedule) with
    optional supporting justification.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
    ) -> Union[StructType, DataType]:
        """
        A patient's point-in-time immunization and recommendation (i.e. forecasting a
        patient's immunization eligibility according to a published schedule) with
        optional supporting justification.


        date: The date the immunization recommendation was created.

        vaccineCode: Vaccine that pertains to the recommendation.

        targetDisease: The targeted disease for the recommendation.

        doseNumber: The next recommended dose number (e.g. dose 2 is the next recommended dose).

        forecastStatus: Vaccine administration status.

        dateCriterion: Vaccine date recommendations.  For example, earliest date to administer,
            latest date to administer, etc.

        protocol: Contains information about the protocol under which the vaccine was
            administered.

        supportingImmunization: Immunization event history that supports the status and recommendation.

        supportingPatientInformation: Patient Information that supports the status and recommendation.  This
            includes patient observations, adverse reactions and allergy/intolerance
            information.

        """
        from spark_fhir_schemas.stu3.complex_types.codeableconcept import (
            CodeableConceptSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.immunizationrecommendation_datecriterion import (
            ImmunizationRecommendation_DateCriterionSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.immunizationrecommendation_protocol import (
            ImmunizationRecommendation_ProtocolSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.reference import ReferenceSchema

        if (
            max_recursion_limit
            and nesting_list.count("ImmunizationRecommendation_Recommendation")
            >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + [
            "ImmunizationRecommendation_Recommendation"
        ]
        schema = StructType(
            [
                # The date the immunization recommendation was created.
                StructField("date", StringType(), True),
                # Vaccine that pertains to the recommendation.
                StructField(
                    "vaccineCode",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The targeted disease for the recommendation.
                StructField(
                    "targetDisease",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The next recommended dose number (e.g. dose 2 is the next recommended dose).
                StructField("doseNumber", IntegerType(), True),
                # Vaccine administration status.
                StructField(
                    "forecastStatus",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Vaccine date recommendations.  For example, earliest date to administer,
                # latest date to administer, etc.
                StructField(
                    "dateCriterion",
                    ArrayType(
                        ImmunizationRecommendation_DateCriterionSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # Contains information about the protocol under which the vaccine was
                # administered.
                StructField(
                    "protocol",
                    ImmunizationRecommendation_ProtocolSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Immunization event history that supports the status and recommendation.
                StructField(
                    "supportingImmunization",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # Patient Information that supports the status and recommendation.  This
                # includes patient observations, adverse reactions and allergy/intolerance
                # information.
                StructField(
                    "supportingPatientInformation",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
