from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class EndpointSchema:
    """
    The technical details of an endpoint that can be used for electronic services,
    such as for web services providing XDS.b or a REST endpoint for another FHIR
    server. This may include any security context information.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
    ) -> Union[StructType, DataType]:
        """
        The technical details of an endpoint that can be used for electronic services,
        such as for web services providing XDS.b or a REST endpoint for another FHIR
        server. This may include any security context information.


        resourceType: This is a Endpoint resource

        identifier: Identifier for the organization that is used to identify the endpoint across
            multiple disparate systems.

        status: active | suspended | error | off | test.

        connectionType: A coded value that represents the technical details of the usage of this
            endpoint, such as what WSDLs should be used in what way. (e.g.
            XDS.b/DICOM/cds-hook).

        name: A friendly name that this endpoint can be referred to with.

        managingOrganization: The organization that manages this endpoint (even if technically another
            organisation is hosting this in the cloud, it is the organisation associated
            with the data).

        contact: Contact details for a human to contact about the subscription. The primary use
            of this for system administrator troubleshooting.

        period: The interval during which the endpoint is expected to be operational.

        payloadType: The payload type describes the acceptable content that can be communicated on
            the endpoint.

        payloadMimeType: The mime type to send the payload in - e.g. application/fhir+xml,
            application/fhir+json. If the mime type is not specified, then the sender
            could send any content (including no content depending on the connectionType).

        address: The uri that describes the actual end-point to connect to.

        header: Additional headers / information to send as part of the notification.

        """
        from spark_fhir_schemas.stu3.complex_types.identifier import IdentifierSchema
        from spark_fhir_schemas.stu3.complex_types.coding import CodingSchema
        from spark_fhir_schemas.stu3.complex_types.reference import ReferenceSchema
        from spark_fhir_schemas.stu3.complex_types.contactpoint import (
            ContactPointSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.period import PeriodSchema
        from spark_fhir_schemas.stu3.complex_types.codeableconcept import (
            CodeableConceptSchema,
        )

        if (
            max_recursion_limit
            and nesting_list.count("Endpoint") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["Endpoint"]
        schema = StructType(
            [
                # This is a Endpoint resource
                StructField("resourceType", StringType(), True),
                # Identifier for the organization that is used to identify the endpoint across
                # multiple disparate systems.
                StructField(
                    "identifier",
                    ArrayType(
                        IdentifierSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # active | suspended | error | off | test.
                StructField("status", StringType(), True),
                # A coded value that represents the technical details of the usage of this
                # endpoint, such as what WSDLs should be used in what way. (e.g.
                # XDS.b/DICOM/cds-hook).
                StructField(
                    "connectionType",
                    CodingSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # A friendly name that this endpoint can be referred to with.
                StructField("name", StringType(), True),
                # The organization that manages this endpoint (even if technically another
                # organisation is hosting this in the cloud, it is the organisation associated
                # with the data).
                StructField(
                    "managingOrganization",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Contact details for a human to contact about the subscription. The primary use
                # of this for system administrator troubleshooting.
                StructField(
                    "contact",
                    ArrayType(
                        ContactPointSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # The interval during which the endpoint is expected to be operational.
                StructField(
                    "period",
                    PeriodSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The payload type describes the acceptable content that can be communicated on
                # the endpoint.
                StructField(
                    "payloadType",
                    ArrayType(
                        CodeableConceptSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # The mime type to send the payload in - e.g. application/fhir+xml,
                # application/fhir+json. If the mime type is not specified, then the sender
                # could send any content (including no content depending on the connectionType).
                # The uri that describes the actual end-point to connect to.
                StructField("address", StringType(), True),
                # Additional headers / information to send as part of the notification.
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
