from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class DeviceComponentSchema:
    """
    The characteristics, operational status and capabilities of a medical-related
    component of a medical device.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
    ) -> Union[StructType, DataType]:
        """
        The characteristics, operational status and capabilities of a medical-related
        component of a medical device.


        resourceType: This is a DeviceComponent resource

        identifier: The locally assigned unique identification by the software. For example:
            handle ID.

        type: The component type as defined in the object-oriented or metric nomenclature
            partition.

        lastSystemChange: The timestamp for the most recent system change which includes device
            configuration or setting change.

        source: The link to the source Device that contains administrative device information
            such as manufacture, serial number, etc.

        parent: The link to the parent resource. For example: Channel is linked to its VMD
            parent.

        operationalStatus: The current operational status of the device. For example: On, Off, Standby,
            etc.

        parameterGroup: The parameter group supported by the current device component that is based on
            some nomenclature, e.g. cardiovascular.

        measurementPrinciple: The physical principle of the measurement. For example: thermal, chemical,
            acoustical, etc.

        productionSpecification: The production specification such as component revision, serial number, etc.

        languageCode: The language code for the human-readable text string produced by the device.
            This language code will follow the IETF language tag. Example: en-US.

        """
        from spark_fhir_schemas.stu3.complex_types.identifier import IdentifierSchema
        from spark_fhir_schemas.stu3.complex_types.codeableconcept import (
            CodeableConceptSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.reference import ReferenceSchema
        from spark_fhir_schemas.stu3.complex_types.devicecomponent_productionspecification import (
            DeviceComponent_ProductionSpecificationSchema,
        )

        if (
            max_recursion_limit
            and nesting_list.count("DeviceComponent") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["DeviceComponent"]
        schema = StructType(
            [
                # This is a DeviceComponent resource
                StructField("resourceType", StringType(), True),
                # The locally assigned unique identification by the software. For example:
                # handle ID.
                StructField(
                    "identifier",
                    IdentifierSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The component type as defined in the object-oriented or metric nomenclature
                # partition.
                StructField(
                    "type",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The timestamp for the most recent system change which includes device
                # configuration or setting change.
                StructField("lastSystemChange", StringType(), True),
                # The link to the source Device that contains administrative device information
                # such as manufacture, serial number, etc.
                StructField(
                    "source",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The link to the parent resource. For example: Channel is linked to its VMD
                # parent.
                StructField(
                    "parent",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The current operational status of the device. For example: On, Off, Standby,
                # etc.
                StructField(
                    "operationalStatus",
                    ArrayType(
                        CodeableConceptSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # The parameter group supported by the current device component that is based on
                # some nomenclature, e.g. cardiovascular.
                StructField(
                    "parameterGroup",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The physical principle of the measurement. For example: thermal, chemical,
                # acoustical, etc.
                StructField("measurementPrinciple", StringType(), True),
                # The production specification such as component revision, serial number, etc.
                StructField(
                    "productionSpecification",
                    ArrayType(
                        DeviceComponent_ProductionSpecificationSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # The language code for the human-readable text string produced by the device.
                # This language code will follow the IETF language tag. Example: en-US.
                StructField(
                    "languageCode",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
