from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import BooleanType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class ConditionSchema:
    """
    A clinical condition, problem, diagnosis, or other event, situation, issue, or
    clinical concept that has risen to a level of concern.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
    ) -> Union[StructType, DataType]:
        """
        A clinical condition, problem, diagnosis, or other event, situation, issue, or
        clinical concept that has risen to a level of concern.


        resourceType: This is a Condition resource

        identifier: This records identifiers associated with this condition that are defined by
            business processes and/or used to refer to it when a direct URL reference to
            the resource itself is not appropriate (e.g. in CDA documents, or in written /
            printed documentation).

        clinicalStatus: The clinical status of the condition.

        verificationStatus: The verification status to support the clinical status of the condition.

        category: A category assigned to the condition.

        severity: A subjective assessment of the severity of the condition as evaluated by the
            clinician.

        code: Identification of the condition, problem or diagnosis.

        bodySite: The anatomical location where this condition manifests itself.

        subject: Indicates the patient or group who the condition record is associated with.

        context: Encounter during which the condition was first asserted.

        onsetDateTime: Estimated or actual date or date-time  the condition began, in the opinion of
            the clinician.

        onsetAge: Estimated or actual date or date-time  the condition began, in the opinion of
            the clinician.

        onsetPeriod: Estimated or actual date or date-time  the condition began, in the opinion of
            the clinician.

        onsetRange: Estimated or actual date or date-time  the condition began, in the opinion of
            the clinician.

        onsetString: Estimated or actual date or date-time  the condition began, in the opinion of
            the clinician.

        abatementDateTime: The date or estimated date that the condition resolved or went into remission.
            This is called "abatement" because of the many overloaded connotations
            associated with "remission" or "resolution" - Conditions are never really
            resolved, but they can abate.

        abatementAge: The date or estimated date that the condition resolved or went into remission.
            This is called "abatement" because of the many overloaded connotations
            associated with "remission" or "resolution" - Conditions are never really
            resolved, but they can abate.

        abatementBoolean: The date or estimated date that the condition resolved or went into remission.
            This is called "abatement" because of the many overloaded connotations
            associated with "remission" or "resolution" - Conditions are never really
            resolved, but they can abate.

        abatementPeriod: The date or estimated date that the condition resolved or went into remission.
            This is called "abatement" because of the many overloaded connotations
            associated with "remission" or "resolution" - Conditions are never really
            resolved, but they can abate.

        abatementRange: The date or estimated date that the condition resolved or went into remission.
            This is called "abatement" because of the many overloaded connotations
            associated with "remission" or "resolution" - Conditions are never really
            resolved, but they can abate.

        abatementString: The date or estimated date that the condition resolved or went into remission.
            This is called "abatement" because of the many overloaded connotations
            associated with "remission" or "resolution" - Conditions are never really
            resolved, but they can abate.

        assertedDate: The date on which the existance of the Condition was first asserted or
            acknowledged.

        asserter: Individual who is making the condition statement.

        stage: Clinical stage or grade of a condition. May include formal severity
            assessments.

        evidence: Supporting Evidence / manifestations that are the basis on which this
            condition is suspected or confirmed.

        note: Additional information about the Condition. This is a general notes/comments
            entry  for description of the Condition, its diagnosis and prognosis.

        """
        from spark_fhir_schemas.stu3.complex_types.identifier import IdentifierSchema
        from spark_fhir_schemas.stu3.complex_types.codeableconcept import (
            CodeableConceptSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.reference import ReferenceSchema
        from spark_fhir_schemas.stu3.complex_types.age import AgeSchema
        from spark_fhir_schemas.stu3.complex_types.period import PeriodSchema
        from spark_fhir_schemas.stu3.complex_types.range import RangeSchema
        from spark_fhir_schemas.stu3.complex_types.condition_stage import (
            Condition_StageSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.condition_evidence import (
            Condition_EvidenceSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.annotation import AnnotationSchema

        if (
            max_recursion_limit
            and nesting_list.count("Condition") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["Condition"]
        schema = StructType(
            [
                # This is a Condition resource
                StructField("resourceType", StringType(), True),
                # This records identifiers associated with this condition that are defined by
                # business processes and/or used to refer to it when a direct URL reference to
                # the resource itself is not appropriate (e.g. in CDA documents, or in written /
                # printed documentation).
                StructField(
                    "identifier",
                    ArrayType(
                        IdentifierSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # The clinical status of the condition.
                StructField("clinicalStatus", StringType(), True),
                # The verification status to support the clinical status of the condition.
                StructField("verificationStatus", StringType(), True),
                # A category assigned to the condition.
                StructField(
                    "category",
                    ArrayType(
                        CodeableConceptSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # A subjective assessment of the severity of the condition as evaluated by the
                # clinician.
                StructField(
                    "severity",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Identification of the condition, problem or diagnosis.
                StructField(
                    "code",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The anatomical location where this condition manifests itself.
                StructField(
                    "bodySite",
                    ArrayType(
                        CodeableConceptSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # Indicates the patient or group who the condition record is associated with.
                StructField(
                    "subject",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Encounter during which the condition was first asserted.
                StructField(
                    "context",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Estimated or actual date or date-time  the condition began, in the opinion of
                # the clinician.
                StructField("onsetDateTime", StringType(), True),
                # Estimated or actual date or date-time  the condition began, in the opinion of
                # the clinician.
                StructField(
                    "onsetAge",
                    AgeSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Estimated or actual date or date-time  the condition began, in the opinion of
                # the clinician.
                StructField(
                    "onsetPeriod",
                    PeriodSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Estimated or actual date or date-time  the condition began, in the opinion of
                # the clinician.
                StructField(
                    "onsetRange",
                    RangeSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Estimated or actual date or date-time  the condition began, in the opinion of
                # the clinician.
                StructField("onsetString", StringType(), True),
                # The date or estimated date that the condition resolved or went into remission.
                # This is called "abatement" because of the many overloaded connotations
                # associated with "remission" or "resolution" - Conditions are never really
                # resolved, but they can abate.
                StructField("abatementDateTime", StringType(), True),
                # The date or estimated date that the condition resolved or went into remission.
                # This is called "abatement" because of the many overloaded connotations
                # associated with "remission" or "resolution" - Conditions are never really
                # resolved, but they can abate.
                StructField(
                    "abatementAge",
                    AgeSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The date or estimated date that the condition resolved or went into remission.
                # This is called "abatement" because of the many overloaded connotations
                # associated with "remission" or "resolution" - Conditions are never really
                # resolved, but they can abate.
                StructField("abatementBoolean", BooleanType(), True),
                # The date or estimated date that the condition resolved or went into remission.
                # This is called "abatement" because of the many overloaded connotations
                # associated with "remission" or "resolution" - Conditions are never really
                # resolved, but they can abate.
                StructField(
                    "abatementPeriod",
                    PeriodSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The date or estimated date that the condition resolved or went into remission.
                # This is called "abatement" because of the many overloaded connotations
                # associated with "remission" or "resolution" - Conditions are never really
                # resolved, but they can abate.
                StructField(
                    "abatementRange",
                    RangeSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The date or estimated date that the condition resolved or went into remission.
                # This is called "abatement" because of the many overloaded connotations
                # associated with "remission" or "resolution" - Conditions are never really
                # resolved, but they can abate.
                StructField("abatementString", StringType(), True),
                # The date on which the existance of the Condition was first asserted or
                # acknowledged.
                StructField("assertedDate", StringType(), True),
                # Individual who is making the condition statement.
                StructField(
                    "asserter",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Clinical stage or grade of a condition. May include formal severity
                # assessments.
                StructField(
                    "stage",
                    Condition_StageSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Supporting Evidence / manifestations that are the basis on which this
                # condition is suspected or confirmed.
                StructField(
                    "evidence",
                    ArrayType(
                        Condition_EvidenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # Additional information about the Condition. This is a general notes/comments
                # entry  for description of the Condition, its diagnosis and prognosis.
                StructField(
                    "note",
                    ArrayType(
                        AnnotationSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
