from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import BooleanType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class CarePlan_DetailSchema:
    """
    Describes the intention of how one or more practitioners intend to deliver
    care for a particular patient, group or community for a period of time,
    possibly limited to care for a specific condition or set of conditions.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
    ) -> Union[StructType, DataType]:
        """
        Describes the intention of how one or more practitioners intend to deliver
        care for a particular patient, group or community for a period of time,
        possibly limited to care for a specific condition or set of conditions.


        category: High-level categorization of the type of activity in a care plan.

        definition: Identifies the protocol, questionnaire, guideline or other specification the
            planned activity should be conducted in accordance with.

        code: Detailed description of the type of planned activity; e.g. What lab test, what
            procedure, what kind of encounter.

        reasonCode: Provides the rationale that drove the inclusion of this particular activity as
            part of the plan or the reason why the activity was prohibited.

        reasonReference: Provides the health condition(s) that drove the inclusion of this particular
            activity as part of the plan.

        goal: Internal reference that identifies the goals that this activity is intended to
            contribute towards meeting.

        status: Identifies what progress is being made for the specific activity.

        statusReason: Provides reason why the activity isn't yet started, is on hold, was cancelled,
            etc.

        prohibited: If true, indicates that the described activity is one that must NOT be engaged
            in when following the plan.  If false, indicates that the described activity
            is one that should be engaged in when following the plan.

        scheduledTiming: The period, timing or frequency upon which the described activity is to occur.

        scheduledPeriod: The period, timing or frequency upon which the described activity is to occur.

        scheduledString: The period, timing or frequency upon which the described activity is to occur.

        location: Identifies the facility where the activity will occur; e.g. home, hospital,
            specific clinic, etc.

        performer: Identifies who's expected to be involved in the activity.

        productCodeableConcept: Identifies the food, drug or other product to be consumed or supplied in the
            activity.

        productReference: Identifies the food, drug or other product to be consumed or supplied in the
            activity.

        dailyAmount: Identifies the quantity expected to be consumed in a given day.

        quantity: Identifies the quantity expected to be supplied, administered or consumed by
            the subject.

        description: This provides a textual description of constraints on the intended activity
            occurrence, including relation to other activities.  It may also include
            objectives, pre-conditions and end-conditions.  Finally, it may convey
            specifics about the activity such as body site, method, route, etc.

        """
        from spark_fhir_schemas.stu3.complex_types.codeableconcept import (
            CodeableConceptSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.reference import ReferenceSchema
        from spark_fhir_schemas.stu3.complex_types.timing import TimingSchema
        from spark_fhir_schemas.stu3.complex_types.period import PeriodSchema
        from spark_fhir_schemas.stu3.complex_types.quantity import QuantitySchema

        if (
            max_recursion_limit
            and nesting_list.count("CarePlan_Detail") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["CarePlan_Detail"]
        schema = StructType(
            [
                # High-level categorization of the type of activity in a care plan.
                StructField(
                    "category",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Identifies the protocol, questionnaire, guideline or other specification the
                # planned activity should be conducted in accordance with.
                StructField(
                    "definition",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Detailed description of the type of planned activity; e.g. What lab test, what
                # procedure, what kind of encounter.
                StructField(
                    "code",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Provides the rationale that drove the inclusion of this particular activity as
                # part of the plan or the reason why the activity was prohibited.
                StructField(
                    "reasonCode",
                    ArrayType(
                        CodeableConceptSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # Provides the health condition(s) that drove the inclusion of this particular
                # activity as part of the plan.
                StructField(
                    "reasonReference",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # Internal reference that identifies the goals that this activity is intended to
                # contribute towards meeting.
                StructField(
                    "goal",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # Identifies what progress is being made for the specific activity.
                StructField("status", StringType(), True),
                # Provides reason why the activity isn't yet started, is on hold, was cancelled,
                # etc.
                StructField("statusReason", StringType(), True),
                # If true, indicates that the described activity is one that must NOT be engaged
                # in when following the plan.  If false, indicates that the described activity
                # is one that should be engaged in when following the plan.
                StructField("prohibited", BooleanType(), True),
                # The period, timing or frequency upon which the described activity is to occur.
                StructField(
                    "scheduledTiming",
                    TimingSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The period, timing or frequency upon which the described activity is to occur.
                StructField(
                    "scheduledPeriod",
                    PeriodSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The period, timing or frequency upon which the described activity is to occur.
                StructField("scheduledString", StringType(), True),
                # Identifies the facility where the activity will occur; e.g. home, hospital,
                # specific clinic, etc.
                StructField(
                    "location",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Identifies who's expected to be involved in the activity.
                StructField(
                    "performer",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # Identifies the food, drug or other product to be consumed or supplied in the
                # activity.
                StructField(
                    "productCodeableConcept",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Identifies the food, drug or other product to be consumed or supplied in the
                # activity.
                StructField(
                    "productReference",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Identifies the quantity expected to be consumed in a given day.
                StructField(
                    "dailyAmount",
                    QuantitySchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Identifies the quantity expected to be supplied, administered or consumed by
                # the subject.
                StructField(
                    "quantity",
                    QuantitySchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # This provides a textual description of constraints on the intended activity
                # occurrence, including relation to other activities.  It may also include
                # objectives, pre-conditions and end-conditions.  Finally, it may convey
                # specifics about the activity such as body site, method, route, etc.
                StructField("description", StringType(), True),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
