from typing import Union, List, Optional

from pyspark.sql.types import (
    StructType,
    StructField,
    StringType,
    ArrayType,
    BooleanType,
    DataType,
)


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class ImplementationGuide_ResourceSchema:
    """
    A set of rules of how a particular interoperability or standards problem is
    solved - typically through the use of FHIR resources. This resource is used to
    gather all the parts of an implementation guide into a logical whole and to
    publish a computable definition of all the parts.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
    ) -> Union[StructType, DataType]:
        """
        A set of rules of how a particular interoperability or standards problem is
        solved - typically through the use of FHIR resources. This resource is used to
        gather all the parts of an implementation guide into a logical whole and to
        publish a computable definition of all the parts.


        id: Unique id for the element within a resource (for internal references). This
            may be any string value that does not contain spaces.

        extension: May be used to represent additional information that is not part of the basic
            definition of the element. To make the use of extensions safe and manageable,
            there is a strict set of governance  applied to the definition and use of
            extensions. Though any implementer can define an extension, there is a set of
            requirements that SHALL be met as part of the definition of the extension.

        reference: Where this resource is found.

        fhirVersion: Indicates the FHIR Version(s) this artifact is intended to apply to. If no
            versions are specified, the resource is assumed to apply to all the versions
            stated in ImplementationGuide.fhirVersion.

        name: A human assigned name for the resource. All resources SHOULD have a name, but
            the name may be extracted from the resource (e.g. ValueSet.name).

        description: A description of the reason that a resource has been included in the
            implementation guide.

        exampleBoolean: If true or a reference, indicates the resource is an example instance.  If a
            reference is present, indicates that the example is an example of the
            specified profile.

        exampleCanonical: If true or a reference, indicates the resource is an example instance.  If a
            reference is present, indicates that the example is an example of the
            specified profile.

        groupingId: Reference to the id of the grouping this resource appears in.

        """
        from spark_fhir_schemas.r4.complex_types.extension import ExtensionSchema
        from spark_fhir_schemas.r4.complex_types.reference import ReferenceSchema
        from spark_fhir_schemas.r4.simple_types.id import idSchema

        if (
            max_recursion_limit
            and nesting_list.count("ImplementationGuide_Resource")
            >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["ImplementationGuide_Resource"]
        schema = StructType(
            [
                # Unique id for the element within a resource (for internal references). This
                # may be any string value that does not contain spaces.
                StructField("id", StringType(), True),
                # May be used to represent additional information that is not part of the basic
                # definition of the element. To make the use of extensions safe and manageable,
                # there is a strict set of governance  applied to the definition and use of
                # extensions. Though any implementer can define an extension, there is a set of
                # requirements that SHALL be met as part of the definition of the extension.
                StructField(
                    "extension",
                    ArrayType(
                        ExtensionSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # Where this resource is found.
                StructField(
                    "reference",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Indicates the FHIR Version(s) this artifact is intended to apply to. If no
                # versions are specified, the resource is assumed to apply to all the versions
                # stated in ImplementationGuide.fhirVersion.
                # A human assigned name for the resource. All resources SHOULD have a name, but
                # the name may be extracted from the resource (e.g. ValueSet.name).
                StructField("name", StringType(), True),
                # A description of the reason that a resource has been included in the
                # implementation guide.
                StructField("description", StringType(), True),
                # If true or a reference, indicates the resource is an example instance.  If a
                # reference is present, indicates that the example is an example of the
                # specified profile.
                StructField("exampleBoolean", BooleanType(), True),
                # If true or a reference, indicates the resource is an example instance.  If a
                # reference is present, indicates that the example is an example of the
                # specified profile.
                StructField("exampleCanonical", StringType(), True),
                # Reference to the id of the grouping this resource appears in.
                StructField(
                    "groupingId",
                    idSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
