
module fifo_1slot #(
    parameter WIDTH = 0
) (
    input clk,
    input rstn,
    input i_valid,
    output i_ready,
    input [WIDTH-1:0] din,
    output o_valid,
    input o_ready,
    output [WIDTH-1:0] dout
);

    reg [WIDTH-1:0] buffer;
    reg buffer_full;
    
    assign i_ready = !buffer_full || o_ready;
    assign o_valid = buffer_full;
    assign dout = buffer;
    
    always_ff @(posedge clk) begin
        
        if (!buffer_full) begin
            buffer <= din;
            if (i_valid) begin
                buffer_full <= 1'b1;
            end
        end else begin
            if (o_ready) begin
                buffer <= din;
            end
            if (!i_valid && o_ready) begin
                buffer_full <= 1'b0;
            end
        end
        
        if (!rstn) begin
            buffer_full <= 1'b0;
        end
    end

endmodule
