package PicosConfig;

    localparam MAX_ARGS_PER_TASK = 15;
    localparam MAX_DEPS_PER_TASK = 8;
    localparam MAX_COPIES_PER_TASK = 15;

    localparam ARGS_BITS = $clog2(MAX_ARGS_PER_TASK+1);
    localparam COPS_BITS = $clog2(MAX_COPIES_PER_TASK+1);
    localparam DEPS_BITS = $clog2(MAX_DEPS_PER_TASK);

    localparam NUM_DCTS = 1; //only 1, 2 and 4 are valid

    localparam TM_SIZE = 128;
    localparam TM_SIZE_BITS = $clog2(TM_SIZE);

    localparam DM_SIZE = 512;
    localparam DM_SIZE_BITS = $clog2(DM_SIZE);

    localparam VM_SIZE = 512;
    localparam VM_SIZE_BITS = $clog2(VM_SIZE);
    localparam GLOB_VM_SIZE_BITS = VM_SIZE_BITS + $clog2(NUM_DCTS);

    localparam PICOS_ID_TRS_ID_L = 4;
    localparam PICOS_ID_NUM_DEPS_L = PICOS_ID_TRS_ID_L+TM_SIZE_BITS;

    localparam DM_DS = "BINTREE"; //BINTREE or LINKEDLIST
    localparam DM_HASH = "P_PEARSON"; //P_PEARSON or XOR

    localparam HASH_T_SIZE = 64;  //For P_PEARSON hash use only 64. Always has to be <= DM_SIZE
    localparam HASH_T_BITS = $clog2(HASH_T_SIZE);
    localparam GLOB_HASH_T_BITS = $clog2(HASH_T_SIZE) + $clog2(NUM_DCTS);

    localparam DBG = 0;

endpackage
