"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiGatewayToSqs = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const defaults = require("@aws-solutions-constructs/core");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const constructs_1 = require("constructs");
const cdk = require("aws-cdk-lib");
/**
 * @summary The ApiGatewayToSqs class.
 */
class ApiGatewayToSqs extends constructs_1.Construct {
    /**
     * @summary Constructs a new instance of the ApiGatewayToSqs class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {ApiGatewayToSqsProps} props - user provided props for the construct.
     * @since 0.8.0
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.defaultCreateRequestTemplate = 'Action=SendMessage&MessageBody=$util.urlEncode(\"$input.body\")';
        this.defaultReadRequestTemplate = 'Action=ReceiveMessage';
        this.defaultDeleteRequestTemplate = "Action=DeleteMessage&ReceiptHandle=$util.urlEncode($input.params('receiptHandle'))";
        defaults.CheckProps(props);
        if ((props.createRequestTemplate || props.additionalCreateRequestTemplates || props.createIntegrationResponses)
            && props.allowCreateOperation !== true) {
            throw new Error(`The 'allowCreateOperation' property must be set to true when setting any of the following: ` +
                `'createRequestTemplate', 'additionalCreateRequestTemplates', 'createIntegrationResponses'`);
        }
        if ((props.readRequestTemplate || props.additionalReadRequestTemplates || props.readIntegrationResponses)
            && props.allowReadOperation === false) {
            throw new Error(`The 'allowReadOperation' property must be set to true or undefined when setting any of the following: ` +
                `'readRequestTemplate', 'additionalReadRequestTemplates', 'readIntegrationResponses'`);
        }
        if ((props.deleteRequestTemplate || props.additionalDeleteRequestTemplates || props.deleteIntegrationResponses)
            && props.allowDeleteOperation !== true) {
            throw new Error(`The 'allowDeleteOperation' property must be set to true when setting any of the following: ` +
                `'deleteRequestTemplate', 'additionalDeleteRequestTemplates', 'deleteIntegrationResponses'`);
        }
        // Setup the dead letter queue, if applicable
        this.deadLetterQueue = defaults.buildDeadLetterQueue(this, {
            existingQueueObj: props.existingQueueObj,
            deployDeadLetterQueue: props.deployDeadLetterQueue,
            deadLetterQueueProps: props.deadLetterQueueProps,
            maxReceiveCount: props.maxReceiveCount
        });
        // Setup the queue
        const buildQueueResponse = defaults.buildQueue(this, 'queue', {
            existingQueueObj: props.existingQueueObj,
            queueProps: props.queueProps,
            deadLetterQueue: this.deadLetterQueue,
            enableEncryptionWithCustomerManagedKey: props.enableEncryptionWithCustomerManagedKey,
            encryptionKey: props.encryptionKey,
            encryptionKeyProps: props.encryptionKeyProps
        });
        this.sqsQueue = buildQueueResponse.queue;
        // Setup the API Gateway
        const globalRestApiResponse = defaults.GlobalRestApi(this, props.apiGatewayProps, props.logGroupProps);
        this.apiGateway = globalRestApiResponse.api;
        this.apiGatewayCloudWatchRole = globalRestApiResponse.role;
        this.apiGatewayLogGroup = globalRestApiResponse.logGroup;
        // Setup the API Gateway role
        this.apiGatewayRole = new iam.Role(this, 'api-gateway-role', {
            assumedBy: new iam.ServicePrincipal('apigateway.amazonaws.com')
        });
        // Setup the API Gateway resource
        const apiGatewayResource = this.apiGateway.root.addResource('message');
        // Create
        const createRequestTemplate = props.createRequestTemplate ?? this.defaultCreateRequestTemplate;
        if (props.allowCreateOperation && props.allowCreateOperation === true) {
            this.addActionToPolicy("sqs:SendMessage");
            defaults.addProxyMethodToApiResource({
                service: "sqs",
                path: `${cdk.Aws.ACCOUNT_ID}/${this.sqsQueue.queueName}`,
                apiGatewayRole: this.apiGatewayRole,
                apiMethod: "POST",
                apiResource: this.apiGateway.root,
                requestTemplate: createRequestTemplate,
                additionalRequestTemplates: props.additionalCreateRequestTemplates,
                contentType: "'application/x-www-form-urlencoded'",
                integrationResponses: props.createIntegrationResponses
            });
        }
        // Read
        const readRequestTemplate = props.readRequestTemplate ?? this.defaultReadRequestTemplate;
        if (props.allowReadOperation === undefined || props.allowReadOperation === true) {
            this.addActionToPolicy("sqs:ReceiveMessage");
            defaults.addProxyMethodToApiResource({
                service: "sqs",
                path: `${cdk.Aws.ACCOUNT_ID}/${this.sqsQueue.queueName}`,
                apiGatewayRole: this.apiGatewayRole,
                apiMethod: "GET",
                apiResource: this.apiGateway.root,
                requestTemplate: readRequestTemplate,
                additionalRequestTemplates: props.additionalReadRequestTemplates,
                contentType: "'application/x-www-form-urlencoded'",
                integrationResponses: props.readIntegrationResponses
            });
        }
        // Delete
        const deleteRequestTemplate = props.deleteRequestTemplate ?? this.defaultDeleteRequestTemplate;
        if (props.allowDeleteOperation && props.allowDeleteOperation === true) {
            this.addActionToPolicy("sqs:DeleteMessage");
            defaults.addProxyMethodToApiResource({
                service: "sqs",
                path: `${cdk.Aws.ACCOUNT_ID}/${this.sqsQueue.queueName}`,
                apiGatewayRole: this.apiGatewayRole,
                apiMethod: "DELETE",
                apiResource: apiGatewayResource,
                requestTemplate: deleteRequestTemplate,
                additionalRequestTemplates: props.additionalDeleteRequestTemplates,
                contentType: "'application/x-www-form-urlencoded'",
                integrationResponses: props.deleteIntegrationResponses
            });
        }
    }
    addActionToPolicy(action) {
        this.apiGatewayRole.addToPolicy(new iam.PolicyStatement({
            resources: [
                this.sqsQueue.queueArn
            ],
            actions: [`${action}`]
        }));
    }
}
exports.ApiGatewayToSqs = ApiGatewayToSqs;
_a = JSII_RTTI_SYMBOL_1;
ApiGatewayToSqs[_a] = { fqn: "@aws-solutions-constructs/aws-apigateway-sqs.ApiGatewayToSqs", version: "2.39.0" };
//# sourceMappingURL=data:application/json;base64,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