import datetime
from typing import Any, Dict, List, Type, TypeVar, Union

import attr
from dateutil.parser import isoparse

from ..types import UNSET, OSIDBModel, Unset

T = TypeVar("T", bound="ExploitsApiV1StatusRetrieveResponse200")


@attr.s(auto_attribs=True)
class ExploitsApiV1StatusRetrieveResponse200(OSIDBModel):
    """ """

    dt: Union[Unset, datetime.datetime] = UNSET
    env: Union[Unset, str] = UNSET
    exploits_count: Union[Unset, int] = UNSET
    exploits_count_relevant: Union[Unset, int] = UNSET
    last_exploit: Union[Unset, int] = UNSET
    revision: Union[Unset, str] = UNSET
    version: Union[Unset, str] = UNSET
    additional_properties: Dict[str, Any] = attr.ib(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        dt: Union[Unset, str] = UNSET
        if not isinstance(self.dt, Unset):
            dt = self.dt.isoformat()

        env = self.env
        exploits_count = self.exploits_count
        exploits_count_relevant = self.exploits_count_relevant
        last_exploit = self.last_exploit
        revision = self.revision
        version = self.version

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        if dt is not UNSET:
            field_dict["dt"] = dt
        if env is not UNSET:
            field_dict["env"] = env
        if exploits_count is not UNSET:
            field_dict["exploits_count"] = exploits_count
        if exploits_count_relevant is not UNSET:
            field_dict["exploits_count_relevant"] = exploits_count_relevant
        if last_exploit is not UNSET:
            field_dict["last_exploit"] = last_exploit
        if revision is not UNSET:
            field_dict["revision"] = revision
        if version is not UNSET:
            field_dict["version"] = version

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        _dt = d.pop("dt", UNSET)
        dt: Union[Unset, datetime.datetime]
        if isinstance(_dt, Unset):
            dt = UNSET
        else:
            dt = isoparse(_dt)

        env = d.pop("env", UNSET)

        exploits_count = d.pop("exploits_count", UNSET)

        exploits_count_relevant = d.pop("exploits_count_relevant", UNSET)

        last_exploit = d.pop("last_exploit", UNSET)

        revision = d.pop("revision", UNSET)

        version = d.pop("version", UNSET)

        exploits_api_v1_status_retrieve_response_200 = cls(
            dt=dt,
            env=env,
            exploits_count=exploits_count,
            exploits_count_relevant=exploits_count_relevant,
            last_exploit=last_exploit,
            revision=revision,
            version=version,
        )

        exploits_api_v1_status_retrieve_response_200.additional_properties = d
        return exploits_api_v1_status_retrieve_response_200

    @staticmethod
    def get_fields():
        return {
            "dt": datetime.datetime,
            "env": str,
            "exploits_count": int,
            "exploits_count_relevant": int,
            "last_exploit": int,
            "revision": str,
            "version": str,
        }

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
