// Generated by CoffeeScript 1.5.0
(function() {
  var module;

  module = angular.module('h2o.directives');

  module.directive("slider", function() {
    return {
      restrict: "E",
      template: "<div class=\"slider\"></div>",
      replace: true,
      link: function(scope, element, attrs) {
        var dragSliderArgs, hasTooltip, jqElement, jqHandleElement, slider, theTooltip, tooltipValue, updateSlider;
        tooltipValue = function(value) {
          return scope[attrs.tooltipValue](value);
        };
        jqElement = $(element);
        hasTooltip = attrs.tooltipValue != null;
        theTooltip = null;
        dragSliderArgs = {
          animate: true,
          min: 0,
          max: 0,
          value: 0,
          step: 1,
          change: function(event, ui) {
            var newOffset;
            newOffset = ui.value;
            if (newOffset === scope[attrs.offset]) {
              return;
            }
            return scope.$apply(function() {
              scope[attrs.offset] = newOffset;
              return scope[attrs.rsChange]();
            });
          }
        };
        if (hasTooltip) {
          $.extend(dragSliderArgs, {
            start: function(event, ui) {
              return jqHandleElement.tooltipster("show");
            },
            slide: function(event, ui) {
              jqHandleElement.tooltipster("update", tooltipValue(ui.value));
              return jqHandleElement.tooltipster("reposition");
            },
            stop: function(event, ui) {
              return jqHandleElement.tooltipster("hide");
            }
          });
        }
        slider = jqElement.dragslider(dragSliderArgs);
        jqHandleElement = $(jqElement.find("a"));
        if (hasTooltip) {
          jqHandleElement.tooltipster({
            delay: 0,
            speed: 100,
            updateAnimation: false,
            trigger: "custom",
            content: tooltipValue(0)
          });
        }
        updateSlider = function() {
          return slider.dragslider({
            min: scope[attrs.from],
            max: scope[attrs.to],
            value: scope[attrs.offset],
            disabled: scope[attrs.disabled]
          });
        };
        scope.$watch(attrs.from, updateSlider);
        scope.$watch(attrs.to, updateSlider);
        scope.$watch(attrs.offset, updateSlider);
        return scope.$watch(attrs.disabled, updateSlider);
      }
    };
  });

}).call(this);
