#!/usr/bin/env python
from forcebalance.molecule import *
from forcebalance.nifty import _exec

#Gather CBS energy and gradient calculation outputs and make 
#separate molecule objects
_exec("find . -name 'cbs.psi4out' | xargs cat > cbs_total.psi4out")
mol_cbs = Molecule("cbs_total.psi4out", ftype="psi4out")
_exec("find . -name 'grad.psi4out' | xargs cat > grad_total.psi4out")
mol_grad = Molecule("grad_total.psi4out", ftype="psi4out")

#Set the QM energies from the CBS calculations to the gradient energies
mol_grad.qm_energies = mol_cbs.qm_energies

#Write qdata.txt file
mol_grad.write("qdata.txt", ftype="qdata")
