# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, TYPE_CHECKING, Union

import msrest.serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    import __init__ as _models


class AccountEncryption(msrest.serialization.Model):
    """Encryption settings.

    :ivar key_source: Encryption Key Source. Possible values are: 'Microsoft.NetApp'.
    :vartype key_source: str
    """

    _attribute_map = {
        'key_source': {'key': 'keySource', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_source: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword key_source: Encryption Key Source. Possible values are: 'Microsoft.NetApp'.
        :paramtype key_source: str
        """
        super(AccountEncryption, self).__init__(**kwargs)
        self.key_source = key_source


class ActiveDirectory(msrest.serialization.Model):
    """Active Directory.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar active_directory_id: Id of the Active Directory.
    :vartype active_directory_id: str
    :ivar username: Username of Active Directory domain administrator.
    :vartype username: str
    :ivar password: Plain text password of Active Directory domain administrator, value is masked
     in the response.
    :vartype password: str
    :ivar domain: Name of the Active Directory domain.
    :vartype domain: str
    :ivar dns: Comma separated list of DNS server IP addresses (IPv4 only) for the Active Directory
     domain.
    :vartype dns: str
    :ivar status: Status of the Active Directory. Known values are: "Created", "InUse", "Deleted",
     "Error", "Updating".
    :vartype status: str or ~azure.mgmt.netapp.models.ActiveDirectoryStatus
    :ivar status_details: Any details in regards to the Status of the Active Directory.
    :vartype status_details: str
    :ivar smb_server_name: NetBIOS name of the SMB server. This name will be registered as a
     computer account in the AD and used to mount volumes.
    :vartype smb_server_name: str
    :ivar organizational_unit: The Organizational Unit (OU) within the Windows Active Directory.
    :vartype organizational_unit: str
    :ivar site: The Active Directory site the service will limit Domain Controller discovery to.
    :vartype site: str
    :ivar backup_operators: Users to be added to the Built-in Backup Operator active directory
     group. A list of unique usernames without domain specifier.
    :vartype backup_operators: list[str]
    :ivar administrators: Users to be added to the Built-in Administrators active directory group.
     A list of unique usernames without domain specifier.
    :vartype administrators: list[str]
    :ivar kdc_ip: kdc server IP addresses for the active directory machine. This optional parameter
     is used only while creating kerberos volume.
    :vartype kdc_ip: str
    :ivar ad_name: Name of the active directory machine. This optional parameter is used only while
     creating kerberos volume.
    :vartype ad_name: str
    :ivar server_root_ca_certificate: When LDAP over SSL/TLS is enabled, the LDAP client is
     required to have base64 encoded Active Directory Certificate Service's self-signed root CA
     certificate, this optional parameter is used only for dual protocol with LDAP user-mapping
     volumes.
    :vartype server_root_ca_certificate: str
    :ivar aes_encryption: If enabled, AES encryption will be enabled for SMB communication.
    :vartype aes_encryption: bool
    :ivar ldap_signing: Specifies whether or not the LDAP traffic needs to be signed.
    :vartype ldap_signing: bool
    :ivar security_operators: Domain Users in the Active directory to be given SeSecurityPrivilege
     privilege (Needed for SMB Continuously available shares for SQL). A list of unique usernames
     without domain specifier.
    :vartype security_operators: list[str]
    :ivar ldap_over_tls: Specifies whether or not the LDAP traffic needs to be secured via TLS.
    :vartype ldap_over_tls: bool
    :ivar allow_local_nfs_users_with_ldap: If enabled, NFS client local users can also (in addition
     to LDAP users) access the NFS volumes.
    :vartype allow_local_nfs_users_with_ldap: bool
    :ivar encrypt_dc_connections: If enabled, Traffic between the SMB server to Domain Controller
     (DC) will be encrypted.
    :vartype encrypt_dc_connections: bool
    :ivar ldap_search_scope: LDAP Search scope options.
    :vartype ldap_search_scope: ~azure.mgmt.netapp.models.LdapSearchScopeOpt
    """

    _validation = {
        'dns': {'pattern': r'^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)((, ?)(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?))*$'},
        'status': {'readonly': True},
        'status_details': {'readonly': True},
        'kdc_ip': {'pattern': r'^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)((, ?)(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?))*$'},
        'ad_name': {'max_length': 64, 'min_length': 1},
        'server_root_ca_certificate': {'max_length': 10240, 'min_length': 1},
    }

    _attribute_map = {
        'active_directory_id': {'key': 'activeDirectoryId', 'type': 'str'},
        'username': {'key': 'username', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'domain': {'key': 'domain', 'type': 'str'},
        'dns': {'key': 'dns', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'status_details': {'key': 'statusDetails', 'type': 'str'},
        'smb_server_name': {'key': 'smbServerName', 'type': 'str'},
        'organizational_unit': {'key': 'organizationalUnit', 'type': 'str'},
        'site': {'key': 'site', 'type': 'str'},
        'backup_operators': {'key': 'backupOperators', 'type': '[str]'},
        'administrators': {'key': 'administrators', 'type': '[str]'},
        'kdc_ip': {'key': 'kdcIP', 'type': 'str'},
        'ad_name': {'key': 'adName', 'type': 'str'},
        'server_root_ca_certificate': {'key': 'serverRootCACertificate', 'type': 'str'},
        'aes_encryption': {'key': 'aesEncryption', 'type': 'bool'},
        'ldap_signing': {'key': 'ldapSigning', 'type': 'bool'},
        'security_operators': {'key': 'securityOperators', 'type': '[str]'},
        'ldap_over_tls': {'key': 'ldapOverTLS', 'type': 'bool'},
        'allow_local_nfs_users_with_ldap': {'key': 'allowLocalNfsUsersWithLdap', 'type': 'bool'},
        'encrypt_dc_connections': {'key': 'encryptDCConnections', 'type': 'bool'},
        'ldap_search_scope': {'key': 'ldapSearchScope', 'type': 'LdapSearchScopeOpt'},
    }

    def __init__(
        self,
        *,
        active_directory_id: Optional[str] = None,
        username: Optional[str] = None,
        password: Optional[str] = None,
        domain: Optional[str] = None,
        dns: Optional[str] = None,
        smb_server_name: Optional[str] = None,
        organizational_unit: Optional[str] = "CN=Computers",
        site: Optional[str] = None,
        backup_operators: Optional[List[str]] = None,
        administrators: Optional[List[str]] = None,
        kdc_ip: Optional[str] = None,
        ad_name: Optional[str] = None,
        server_root_ca_certificate: Optional[str] = None,
        aes_encryption: Optional[bool] = None,
        ldap_signing: Optional[bool] = None,
        security_operators: Optional[List[str]] = None,
        ldap_over_tls: Optional[bool] = None,
        allow_local_nfs_users_with_ldap: Optional[bool] = None,
        encrypt_dc_connections: Optional[bool] = None,
        ldap_search_scope: Optional["_models.LdapSearchScopeOpt"] = None,
        **kwargs
    ):
        """
        :keyword active_directory_id: Id of the Active Directory.
        :paramtype active_directory_id: str
        :keyword username: Username of Active Directory domain administrator.
        :paramtype username: str
        :keyword password: Plain text password of Active Directory domain administrator, value is
         masked in the response.
        :paramtype password: str
        :keyword domain: Name of the Active Directory domain.
        :paramtype domain: str
        :keyword dns: Comma separated list of DNS server IP addresses (IPv4 only) for the Active
         Directory domain.
        :paramtype dns: str
        :keyword smb_server_name: NetBIOS name of the SMB server. This name will be registered as a
         computer account in the AD and used to mount volumes.
        :paramtype smb_server_name: str
        :keyword organizational_unit: The Organizational Unit (OU) within the Windows Active Directory.
        :paramtype organizational_unit: str
        :keyword site: The Active Directory site the service will limit Domain Controller discovery to.
        :paramtype site: str
        :keyword backup_operators: Users to be added to the Built-in Backup Operator active directory
         group. A list of unique usernames without domain specifier.
        :paramtype backup_operators: list[str]
        :keyword administrators: Users to be added to the Built-in Administrators active directory
         group. A list of unique usernames without domain specifier.
        :paramtype administrators: list[str]
        :keyword kdc_ip: kdc server IP addresses for the active directory machine. This optional
         parameter is used only while creating kerberos volume.
        :paramtype kdc_ip: str
        :keyword ad_name: Name of the active directory machine. This optional parameter is used only
         while creating kerberos volume.
        :paramtype ad_name: str
        :keyword server_root_ca_certificate: When LDAP over SSL/TLS is enabled, the LDAP client is
         required to have base64 encoded Active Directory Certificate Service's self-signed root CA
         certificate, this optional parameter is used only for dual protocol with LDAP user-mapping
         volumes.
        :paramtype server_root_ca_certificate: str
        :keyword aes_encryption: If enabled, AES encryption will be enabled for SMB communication.
        :paramtype aes_encryption: bool
        :keyword ldap_signing: Specifies whether or not the LDAP traffic needs to be signed.
        :paramtype ldap_signing: bool
        :keyword security_operators: Domain Users in the Active directory to be given
         SeSecurityPrivilege privilege (Needed for SMB Continuously available shares for SQL). A list of
         unique usernames without domain specifier.
        :paramtype security_operators: list[str]
        :keyword ldap_over_tls: Specifies whether or not the LDAP traffic needs to be secured via TLS.
        :paramtype ldap_over_tls: bool
        :keyword allow_local_nfs_users_with_ldap: If enabled, NFS client local users can also (in
         addition to LDAP users) access the NFS volumes.
        :paramtype allow_local_nfs_users_with_ldap: bool
        :keyword encrypt_dc_connections: If enabled, Traffic between the SMB server to Domain
         Controller (DC) will be encrypted.
        :paramtype encrypt_dc_connections: bool
        :keyword ldap_search_scope: LDAP Search scope options.
        :paramtype ldap_search_scope: ~azure.mgmt.netapp.models.LdapSearchScopeOpt
        """
        super(ActiveDirectory, self).__init__(**kwargs)
        self.active_directory_id = active_directory_id
        self.username = username
        self.password = password
        self.domain = domain
        self.dns = dns
        self.status = None
        self.status_details = None
        self.smb_server_name = smb_server_name
        self.organizational_unit = organizational_unit
        self.site = site
        self.backup_operators = backup_operators
        self.administrators = administrators
        self.kdc_ip = kdc_ip
        self.ad_name = ad_name
        self.server_root_ca_certificate = server_root_ca_certificate
        self.aes_encryption = aes_encryption
        self.ldap_signing = ldap_signing
        self.security_operators = security_operators
        self.ldap_over_tls = ldap_over_tls
        self.allow_local_nfs_users_with_ldap = allow_local_nfs_users_with_ldap
        self.encrypt_dc_connections = encrypt_dc_connections
        self.ldap_search_scope = ldap_search_scope


class AuthorizeRequest(msrest.serialization.Model):
    """Authorize request.

    :ivar remote_volume_resource_id: Resource id of the remote volume.
    :vartype remote_volume_resource_id: str
    """

    _attribute_map = {
        'remote_volume_resource_id': {'key': 'remoteVolumeResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        remote_volume_resource_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword remote_volume_resource_id: Resource id of the remote volume.
        :paramtype remote_volume_resource_id: str
        """
        super(AuthorizeRequest, self).__init__(**kwargs)
        self.remote_volume_resource_id = remote_volume_resource_id


class Backup(msrest.serialization.Model):
    """Backup of a Volume.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar location: Required. Resource location.
    :vartype location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar backup_id: UUID v4 used to identify the Backup.
    :vartype backup_id: str
    :ivar creation_date: The creation date of the backup.
    :vartype creation_date: ~datetime.datetime
    :ivar provisioning_state: Azure lifecycle management.
    :vartype provisioning_state: str
    :ivar size: Size of backup.
    :vartype size: long
    :ivar label: Label for backup.
    :vartype label: str
    :ivar backup_type: Type of backup Manual or Scheduled. Known values are: "Manual", "Scheduled".
    :vartype backup_type: str or ~azure.mgmt.netapp.models.BackupType
    :ivar failure_reason: Failure reason.
    :vartype failure_reason: str
    :ivar volume_name: Volume name.
    :vartype volume_name: str
    :ivar use_existing_snapshot: Manual backup an already existing snapshot. This will always be
     false for scheduled backups and true/false for manual backups.
    :vartype use_existing_snapshot: bool
    """

    _validation = {
        'location': {'required': True},
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'backup_id': {'readonly': True, 'max_length': 36, 'min_length': 36, 'pattern': r'^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$'},
        'creation_date': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'size': {'readonly': True},
        'backup_type': {'readonly': True},
        'failure_reason': {'readonly': True},
        'volume_name': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'backup_id': {'key': 'properties.backupId', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'size': {'key': 'properties.size', 'type': 'long'},
        'label': {'key': 'properties.label', 'type': 'str'},
        'backup_type': {'key': 'properties.backupType', 'type': 'str'},
        'failure_reason': {'key': 'properties.failureReason', 'type': 'str'},
        'volume_name': {'key': 'properties.volumeName', 'type': 'str'},
        'use_existing_snapshot': {'key': 'properties.useExistingSnapshot', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        location: str,
        label: Optional[str] = None,
        use_existing_snapshot: Optional[bool] = False,
        **kwargs
    ):
        """
        :keyword location: Required. Resource location.
        :paramtype location: str
        :keyword label: Label for backup.
        :paramtype label: str
        :keyword use_existing_snapshot: Manual backup an already existing snapshot. This will always be
         false for scheduled backups and true/false for manual backups.
        :paramtype use_existing_snapshot: bool
        """
        super(Backup, self).__init__(**kwargs)
        self.location = location
        self.id = None
        self.name = None
        self.type = None
        self.backup_id = None
        self.creation_date = None
        self.provisioning_state = None
        self.size = None
        self.label = label
        self.backup_type = None
        self.failure_reason = None
        self.volume_name = None
        self.use_existing_snapshot = use_existing_snapshot


class BackupPatch(msrest.serialization.Model):
    """Backup patch.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar backup_id: UUID v4 used to identify the Backup.
    :vartype backup_id: str
    :ivar creation_date: The creation date of the backup.
    :vartype creation_date: ~datetime.datetime
    :ivar provisioning_state: Azure lifecycle management.
    :vartype provisioning_state: str
    :ivar size: Size of backup.
    :vartype size: long
    :ivar label: Label for backup.
    :vartype label: str
    :ivar backup_type: Type of backup Manual or Scheduled. Known values are: "Manual", "Scheduled".
    :vartype backup_type: str or ~azure.mgmt.netapp.models.BackupType
    :ivar failure_reason: Failure reason.
    :vartype failure_reason: str
    :ivar volume_name: Volume name.
    :vartype volume_name: str
    :ivar use_existing_snapshot: Manual backup an already existing snapshot. This will always be
     false for scheduled backups and true/false for manual backups.
    :vartype use_existing_snapshot: bool
    """

    _validation = {
        'backup_id': {'readonly': True, 'max_length': 36, 'min_length': 36, 'pattern': r'^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$'},
        'creation_date': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'size': {'readonly': True},
        'backup_type': {'readonly': True},
        'failure_reason': {'readonly': True},
        'volume_name': {'readonly': True},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'backup_id': {'key': 'properties.backupId', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'size': {'key': 'properties.size', 'type': 'long'},
        'label': {'key': 'properties.label', 'type': 'str'},
        'backup_type': {'key': 'properties.backupType', 'type': 'str'},
        'failure_reason': {'key': 'properties.failureReason', 'type': 'str'},
        'volume_name': {'key': 'properties.volumeName', 'type': 'str'},
        'use_existing_snapshot': {'key': 'properties.useExistingSnapshot', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        label: Optional[str] = None,
        use_existing_snapshot: Optional[bool] = False,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword label: Label for backup.
        :paramtype label: str
        :keyword use_existing_snapshot: Manual backup an already existing snapshot. This will always be
         false for scheduled backups and true/false for manual backups.
        :paramtype use_existing_snapshot: bool
        """
        super(BackupPatch, self).__init__(**kwargs)
        self.tags = tags
        self.backup_id = None
        self.creation_date = None
        self.provisioning_state = None
        self.size = None
        self.label = label
        self.backup_type = None
        self.failure_reason = None
        self.volume_name = None
        self.use_existing_snapshot = use_existing_snapshot


class BackupPoliciesList(msrest.serialization.Model):
    """List of Backup Policies.

    :ivar value: A list of backup policies.
    :vartype value: list[~azure.mgmt.netapp.models.BackupPolicy]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[BackupPolicy]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.BackupPolicy"]] = None,
        **kwargs
    ):
        """
        :keyword value: A list of backup policies.
        :paramtype value: list[~azure.mgmt.netapp.models.BackupPolicy]
        """
        super(BackupPoliciesList, self).__init__(**kwargs)
        self.value = value


class Resource(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.netapp.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.netapp.models.SystemData
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        """
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = tags
        self.location = location


class BackupPolicy(TrackedResource):
    """Backup policy information.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.netapp.models.SystemData
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar backup_policy_id: Backup Policy Resource ID.
    :vartype backup_policy_id: str
    :ivar provisioning_state: Azure lifecycle management.
    :vartype provisioning_state: str
    :ivar daily_backups_to_keep: Daily backups count to keep.
    :vartype daily_backups_to_keep: int
    :ivar weekly_backups_to_keep: Weekly backups count to keep.
    :vartype weekly_backups_to_keep: int
    :ivar monthly_backups_to_keep: Monthly backups count to keep.
    :vartype monthly_backups_to_keep: int
    :ivar volumes_assigned: Volumes using current backup policy.
    :vartype volumes_assigned: int
    :ivar enabled: The property to decide policy is enabled or not.
    :vartype enabled: bool
    :ivar volume_backups: A list of volumes assigned to this policy.
    :vartype volume_backups: list[~azure.mgmt.netapp.models.VolumeBackups]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
        'etag': {'readonly': True},
        'backup_policy_id': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'volumes_assigned': {'readonly': True},
        'volume_backups': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'backup_policy_id': {'key': 'properties.backupPolicyId', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'daily_backups_to_keep': {'key': 'properties.dailyBackupsToKeep', 'type': 'int'},
        'weekly_backups_to_keep': {'key': 'properties.weeklyBackupsToKeep', 'type': 'int'},
        'monthly_backups_to_keep': {'key': 'properties.monthlyBackupsToKeep', 'type': 'int'},
        'volumes_assigned': {'key': 'properties.volumesAssigned', 'type': 'int'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'volume_backups': {'key': 'properties.volumeBackups', 'type': '[VolumeBackups]'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        daily_backups_to_keep: Optional[int] = None,
        weekly_backups_to_keep: Optional[int] = None,
        monthly_backups_to_keep: Optional[int] = None,
        enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        :keyword daily_backups_to_keep: Daily backups count to keep.
        :paramtype daily_backups_to_keep: int
        :keyword weekly_backups_to_keep: Weekly backups count to keep.
        :paramtype weekly_backups_to_keep: int
        :keyword monthly_backups_to_keep: Monthly backups count to keep.
        :paramtype monthly_backups_to_keep: int
        :keyword enabled: The property to decide policy is enabled or not.
        :paramtype enabled: bool
        """
        super(BackupPolicy, self).__init__(tags=tags, location=location, **kwargs)
        self.etag = None
        self.backup_policy_id = None
        self.provisioning_state = None
        self.daily_backups_to_keep = daily_backups_to_keep
        self.weekly_backups_to_keep = weekly_backups_to_keep
        self.monthly_backups_to_keep = monthly_backups_to_keep
        self.volumes_assigned = None
        self.enabled = enabled
        self.volume_backups = None


class BackupPolicyDetails(msrest.serialization.Model):
    """Backup policy properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location: Resource location.
    :vartype location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar backup_policy_id: Backup Policy Resource ID.
    :vartype backup_policy_id: str
    :ivar provisioning_state: Azure lifecycle management.
    :vartype provisioning_state: str
    :ivar daily_backups_to_keep: Daily backups count to keep.
    :vartype daily_backups_to_keep: int
    :ivar weekly_backups_to_keep: Weekly backups count to keep.
    :vartype weekly_backups_to_keep: int
    :ivar monthly_backups_to_keep: Monthly backups count to keep.
    :vartype monthly_backups_to_keep: int
    :ivar volumes_assigned: Volumes using current backup policy.
    :vartype volumes_assigned: int
    :ivar enabled: The property to decide policy is enabled or not.
    :vartype enabled: bool
    :ivar volume_backups: A list of volumes assigned to this policy.
    :vartype volume_backups: list[~azure.mgmt.netapp.models.VolumeBackups]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'backup_policy_id': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'volumes_assigned': {'readonly': True},
        'volume_backups': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'backup_policy_id': {'key': 'properties.backupPolicyId', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'daily_backups_to_keep': {'key': 'properties.dailyBackupsToKeep', 'type': 'int'},
        'weekly_backups_to_keep': {'key': 'properties.weeklyBackupsToKeep', 'type': 'int'},
        'monthly_backups_to_keep': {'key': 'properties.monthlyBackupsToKeep', 'type': 'int'},
        'volumes_assigned': {'key': 'properties.volumesAssigned', 'type': 'int'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'volume_backups': {'key': 'properties.volumeBackups', 'type': '[VolumeBackups]'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        daily_backups_to_keep: Optional[int] = None,
        weekly_backups_to_keep: Optional[int] = None,
        monthly_backups_to_keep: Optional[int] = None,
        enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword daily_backups_to_keep: Daily backups count to keep.
        :paramtype daily_backups_to_keep: int
        :keyword weekly_backups_to_keep: Weekly backups count to keep.
        :paramtype weekly_backups_to_keep: int
        :keyword monthly_backups_to_keep: Monthly backups count to keep.
        :paramtype monthly_backups_to_keep: int
        :keyword enabled: The property to decide policy is enabled or not.
        :paramtype enabled: bool
        """
        super(BackupPolicyDetails, self).__init__(**kwargs)
        self.location = location
        self.id = None
        self.name = None
        self.type = None
        self.tags = tags
        self.backup_policy_id = None
        self.provisioning_state = None
        self.daily_backups_to_keep = daily_backups_to_keep
        self.weekly_backups_to_keep = weekly_backups_to_keep
        self.monthly_backups_to_keep = monthly_backups_to_keep
        self.volumes_assigned = None
        self.enabled = enabled
        self.volume_backups = None


class BackupPolicyPatch(msrest.serialization.Model):
    """Backup policy Details for create and update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location: Resource location.
    :vartype location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar backup_policy_id: Backup Policy Resource ID.
    :vartype backup_policy_id: str
    :ivar provisioning_state: Azure lifecycle management.
    :vartype provisioning_state: str
    :ivar daily_backups_to_keep: Daily backups count to keep.
    :vartype daily_backups_to_keep: int
    :ivar weekly_backups_to_keep: Weekly backups count to keep.
    :vartype weekly_backups_to_keep: int
    :ivar monthly_backups_to_keep: Monthly backups count to keep.
    :vartype monthly_backups_to_keep: int
    :ivar volumes_assigned: Volumes using current backup policy.
    :vartype volumes_assigned: int
    :ivar enabled: The property to decide policy is enabled or not.
    :vartype enabled: bool
    :ivar volume_backups: A list of volumes assigned to this policy.
    :vartype volume_backups: list[~azure.mgmt.netapp.models.VolumeBackups]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'backup_policy_id': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'volumes_assigned': {'readonly': True},
        'volume_backups': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'backup_policy_id': {'key': 'properties.backupPolicyId', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'daily_backups_to_keep': {'key': 'properties.dailyBackupsToKeep', 'type': 'int'},
        'weekly_backups_to_keep': {'key': 'properties.weeklyBackupsToKeep', 'type': 'int'},
        'monthly_backups_to_keep': {'key': 'properties.monthlyBackupsToKeep', 'type': 'int'},
        'volumes_assigned': {'key': 'properties.volumesAssigned', 'type': 'int'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'volume_backups': {'key': 'properties.volumeBackups', 'type': '[VolumeBackups]'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        daily_backups_to_keep: Optional[int] = None,
        weekly_backups_to_keep: Optional[int] = None,
        monthly_backups_to_keep: Optional[int] = None,
        enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword daily_backups_to_keep: Daily backups count to keep.
        :paramtype daily_backups_to_keep: int
        :keyword weekly_backups_to_keep: Weekly backups count to keep.
        :paramtype weekly_backups_to_keep: int
        :keyword monthly_backups_to_keep: Monthly backups count to keep.
        :paramtype monthly_backups_to_keep: int
        :keyword enabled: The property to decide policy is enabled or not.
        :paramtype enabled: bool
        """
        super(BackupPolicyPatch, self).__init__(**kwargs)
        self.location = location
        self.id = None
        self.name = None
        self.type = None
        self.tags = tags
        self.backup_policy_id = None
        self.provisioning_state = None
        self.daily_backups_to_keep = daily_backups_to_keep
        self.weekly_backups_to_keep = weekly_backups_to_keep
        self.monthly_backups_to_keep = monthly_backups_to_keep
        self.volumes_assigned = None
        self.enabled = enabled
        self.volume_backups = None


class BackupsList(msrest.serialization.Model):
    """List of Backups.

    :ivar value: A list of Backups.
    :vartype value: list[~azure.mgmt.netapp.models.Backup]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Backup]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.Backup"]] = None,
        **kwargs
    ):
        """
        :keyword value: A list of Backups.
        :paramtype value: list[~azure.mgmt.netapp.models.Backup]
        """
        super(BackupsList, self).__init__(**kwargs)
        self.value = value


class BackupStatus(msrest.serialization.Model):
    """Backup status.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar healthy: Backup health status.
    :vartype healthy: bool
    :ivar relationship_status: Status of the backup mirror relationship. Known values are: "Idle",
     "Transferring".
    :vartype relationship_status: str or ~azure.mgmt.netapp.models.RelationshipStatus
    :ivar mirror_state: The status of the backup. Known values are: "Uninitialized", "Mirrored",
     "Broken".
    :vartype mirror_state: str or ~azure.mgmt.netapp.models.MirrorState
    :ivar unhealthy_reason: Reason for the unhealthy backup relationship.
    :vartype unhealthy_reason: str
    :ivar error_message: Displays error message if the backup is in an error state.
    :vartype error_message: str
    :ivar last_transfer_size: Displays the last transfer size.
    :vartype last_transfer_size: long
    :ivar last_transfer_type: Displays the last transfer type.
    :vartype last_transfer_type: str
    :ivar total_transfer_bytes: Displays the total bytes transferred.
    :vartype total_transfer_bytes: long
    """

    _validation = {
        'healthy': {'readonly': True},
        'relationship_status': {'readonly': True},
        'mirror_state': {'readonly': True},
        'unhealthy_reason': {'readonly': True},
        'error_message': {'readonly': True},
        'last_transfer_size': {'readonly': True},
        'last_transfer_type': {'readonly': True},
        'total_transfer_bytes': {'readonly': True},
    }

    _attribute_map = {
        'healthy': {'key': 'healthy', 'type': 'bool'},
        'relationship_status': {'key': 'relationshipStatus', 'type': 'str'},
        'mirror_state': {'key': 'mirrorState', 'type': 'str'},
        'unhealthy_reason': {'key': 'unhealthyReason', 'type': 'str'},
        'error_message': {'key': 'errorMessage', 'type': 'str'},
        'last_transfer_size': {'key': 'lastTransferSize', 'type': 'long'},
        'last_transfer_type': {'key': 'lastTransferType', 'type': 'str'},
        'total_transfer_bytes': {'key': 'totalTransferBytes', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(BackupStatus, self).__init__(**kwargs)
        self.healthy = None
        self.relationship_status = None
        self.mirror_state = None
        self.unhealthy_reason = None
        self.error_message = None
        self.last_transfer_size = None
        self.last_transfer_type = None
        self.total_transfer_bytes = None


class BreakReplicationRequest(msrest.serialization.Model):
    """Break replication request.

    :ivar force_break_replication: If replication is in status transferring and you want to force
     break the replication, set to true.
    :vartype force_break_replication: bool
    """

    _attribute_map = {
        'force_break_replication': {'key': 'forceBreakReplication', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        force_break_replication: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword force_break_replication: If replication is in status transferring and you want to
         force break the replication, set to true.
        :paramtype force_break_replication: bool
        """
        super(BreakReplicationRequest, self).__init__(**kwargs)
        self.force_break_replication = force_break_replication


class CapacityPool(TrackedResource):
    """Capacity pool resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.netapp.models.SystemData
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar pool_id: UUID v4 used to identify the Pool.
    :vartype pool_id: str
    :ivar size: Required. Provisioned size of the pool (in bytes). Allowed values are in 1TiB
     chunks (value must be multiply of 4398046511104).
    :vartype size: long
    :ivar service_level: Required. The service level of the file system. Known values are:
     "Standard", "Premium", "Ultra", "StandardZRS". Default value: "Premium".
    :vartype service_level: str or ~azure.mgmt.netapp.models.ServiceLevel
    :ivar provisioning_state: Azure lifecycle management.
    :vartype provisioning_state: str
    :ivar total_throughput_mibps: Total throughput of pool in MiB/s.
    :vartype total_throughput_mibps: float
    :ivar utilized_throughput_mibps: Utilized throughput of pool in MiB/s.
    :vartype utilized_throughput_mibps: float
    :ivar qos_type: The qos type of the pool. Known values are: "Auto", "Manual".
    :vartype qos_type: str or ~azure.mgmt.netapp.models.QosType
    :ivar cool_access: If enabled (true) the pool can contain cool Access enabled volumes.
    :vartype cool_access: bool
    :ivar encryption_type: Encryption type of the capacity pool, set encryption type for data at
     rest for this pool and all volumes in it. This value can only be set when creating new pool.
     Known values are: "Single", "Double". Default value: "Single".
    :vartype encryption_type: str or ~azure.mgmt.netapp.models.EncryptionType
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
        'etag': {'readonly': True},
        'pool_id': {'readonly': True, 'max_length': 36, 'min_length': 36, 'pattern': r'^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$'},
        'size': {'required': True},
        'service_level': {'required': True},
        'provisioning_state': {'readonly': True},
        'total_throughput_mibps': {'readonly': True},
        'utilized_throughput_mibps': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'pool_id': {'key': 'properties.poolId', 'type': 'str'},
        'size': {'key': 'properties.size', 'type': 'long'},
        'service_level': {'key': 'properties.serviceLevel', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'total_throughput_mibps': {'key': 'properties.totalThroughputMibps', 'type': 'float'},
        'utilized_throughput_mibps': {'key': 'properties.utilizedThroughputMibps', 'type': 'float'},
        'qos_type': {'key': 'properties.qosType', 'type': 'str'},
        'cool_access': {'key': 'properties.coolAccess', 'type': 'bool'},
        'encryption_type': {'key': 'properties.encryptionType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        size: int = 4398046511104,
        service_level: Union[str, "_models.ServiceLevel"] = "Premium",
        tags: Optional[Dict[str, str]] = None,
        qos_type: Optional[Union[str, "_models.QosType"]] = None,
        cool_access: Optional[bool] = False,
        encryption_type: Optional[Union[str, "_models.EncryptionType"]] = "Single",
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        :keyword size: Required. Provisioned size of the pool (in bytes). Allowed values are in 1TiB
         chunks (value must be multiply of 4398046511104).
        :paramtype size: long
        :keyword service_level: Required. The service level of the file system. Known values are:
         "Standard", "Premium", "Ultra", "StandardZRS". Default value: "Premium".
        :paramtype service_level: str or ~azure.mgmt.netapp.models.ServiceLevel
        :keyword qos_type: The qos type of the pool. Known values are: "Auto", "Manual".
        :paramtype qos_type: str or ~azure.mgmt.netapp.models.QosType
        :keyword cool_access: If enabled (true) the pool can contain cool Access enabled volumes.
        :paramtype cool_access: bool
        :keyword encryption_type: Encryption type of the capacity pool, set encryption type for data at
         rest for this pool and all volumes in it. This value can only be set when creating new pool.
         Known values are: "Single", "Double". Default value: "Single".
        :paramtype encryption_type: str or ~azure.mgmt.netapp.models.EncryptionType
        """
        super(CapacityPool, self).__init__(tags=tags, location=location, **kwargs)
        self.etag = None
        self.pool_id = None
        self.size = size
        self.service_level = service_level
        self.provisioning_state = None
        self.total_throughput_mibps = None
        self.utilized_throughput_mibps = None
        self.qos_type = qos_type
        self.cool_access = cool_access
        self.encryption_type = encryption_type


class CapacityPoolList(msrest.serialization.Model):
    """List of capacity pool resources.

    :ivar value: List of Capacity pools.
    :vartype value: list[~azure.mgmt.netapp.models.CapacityPool]
    :ivar next_link: URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CapacityPool]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.CapacityPool"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: List of Capacity pools.
        :paramtype value: list[~azure.mgmt.netapp.models.CapacityPool]
        :keyword next_link: URL to get the next set of results.
        :paramtype next_link: str
        """
        super(CapacityPoolList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class CapacityPoolPatch(msrest.serialization.Model):
    """Capacity pool patch resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location: Resource location.
    :vartype location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar size: Provisioned size of the pool (in bytes). Allowed values are in 1TiB chunks (value
     must be multiply of 4398046511104).
    :vartype size: long
    :ivar qos_type: The qos type of the pool. Known values are: "Auto", "Manual".
    :vartype qos_type: str or ~azure.mgmt.netapp.models.QosType
    :ivar cool_access: If enabled (true) the pool can contain cool Access enabled volumes.
    :vartype cool_access: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'size': {'key': 'properties.size', 'type': 'long'},
        'qos_type': {'key': 'properties.qosType', 'type': 'str'},
        'cool_access': {'key': 'properties.coolAccess', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        size: Optional[int] = 4398046511104,
        qos_type: Optional[Union[str, "_models.QosType"]] = None,
        cool_access: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword size: Provisioned size of the pool (in bytes). Allowed values are in 1TiB chunks
         (value must be multiply of 4398046511104).
        :paramtype size: long
        :keyword qos_type: The qos type of the pool. Known values are: "Auto", "Manual".
        :paramtype qos_type: str or ~azure.mgmt.netapp.models.QosType
        :keyword cool_access: If enabled (true) the pool can contain cool Access enabled volumes.
        :paramtype cool_access: bool
        """
        super(CapacityPoolPatch, self).__init__(**kwargs)
        self.location = location
        self.id = None
        self.name = None
        self.type = None
        self.tags = tags
        self.size = size
        self.qos_type = qos_type
        self.cool_access = cool_access


class CheckAvailabilityResponse(msrest.serialization.Model):
    """Information regarding availability of a resource.

    :ivar is_available: :code:`<code>true</code>` indicates name is valid and available.
     :code:`<code>false</code>` indicates the name is invalid, unavailable, or both.
    :vartype is_available: bool
    :ivar reason: :code:`<code>Invalid</code>` indicates the name provided does not match Azure App
     Service naming requirements. :code:`<code>AlreadyExists</code>` indicates that the name is
     already in use and is therefore unavailable. Known values are: "Invalid", "AlreadyExists".
    :vartype reason: str or ~azure.mgmt.netapp.models.InAvailabilityReasonType
    :ivar message: If reason == invalid, provide the user with the reason why the given name is
     invalid, and provide the resource naming requirements so that the user can select a valid name.
     If reason == AlreadyExists, explain that resource name is already in use, and direct them to
     select a different name.
    :vartype message: str
    """

    _attribute_map = {
        'is_available': {'key': 'isAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        is_available: Optional[bool] = None,
        reason: Optional[Union[str, "_models.InAvailabilityReasonType"]] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword is_available: :code:`<code>true</code>` indicates name is valid and available.
         :code:`<code>false</code>` indicates the name is invalid, unavailable, or both.
        :paramtype is_available: bool
        :keyword reason: :code:`<code>Invalid</code>` indicates the name provided does not match Azure
         App Service naming requirements. :code:`<code>AlreadyExists</code>` indicates that the name is
         already in use and is therefore unavailable. Known values are: "Invalid", "AlreadyExists".
        :paramtype reason: str or ~azure.mgmt.netapp.models.InAvailabilityReasonType
        :keyword message: If reason == invalid, provide the user with the reason why the given name is
         invalid, and provide the resource naming requirements so that the user can select a valid name.
         If reason == AlreadyExists, explain that resource name is already in use, and direct them to
         select a different name.
        :paramtype message: str
        """
        super(CheckAvailabilityResponse, self).__init__(**kwargs)
        self.is_available = is_available
        self.reason = reason
        self.message = message


class CloudErrorBody(msrest.serialization.Model):
    """An error response from the service.

    :ivar code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :vartype code: str
    :ivar message: A message describing the error, intended to be suitable for display in a user
     interface.
    :vartype message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword code: An identifier for the error. Codes are invariant and are intended to be consumed
         programmatically.
        :paramtype code: str
        :keyword message: A message describing the error, intended to be suitable for display in a user
         interface.
        :paramtype message: str
        """
        super(CloudErrorBody, self).__init__(**kwargs)
        self.code = code
        self.message = message


class DailySchedule(msrest.serialization.Model):
    """Daily Schedule properties.

    :ivar snapshots_to_keep: Daily snapshot count to keep.
    :vartype snapshots_to_keep: int
    :ivar hour: Indicates which hour in UTC timezone a snapshot should be taken.
    :vartype hour: int
    :ivar minute: Indicates which minute snapshot should be taken.
    :vartype minute: int
    :ivar used_bytes: Resource size in bytes, current storage usage for the volume in bytes.
    :vartype used_bytes: long
    """

    _attribute_map = {
        'snapshots_to_keep': {'key': 'snapshotsToKeep', 'type': 'int'},
        'hour': {'key': 'hour', 'type': 'int'},
        'minute': {'key': 'minute', 'type': 'int'},
        'used_bytes': {'key': 'usedBytes', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        snapshots_to_keep: Optional[int] = None,
        hour: Optional[int] = None,
        minute: Optional[int] = None,
        used_bytes: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword snapshots_to_keep: Daily snapshot count to keep.
        :paramtype snapshots_to_keep: int
        :keyword hour: Indicates which hour in UTC timezone a snapshot should be taken.
        :paramtype hour: int
        :keyword minute: Indicates which minute snapshot should be taken.
        :paramtype minute: int
        :keyword used_bytes: Resource size in bytes, current storage usage for the volume in bytes.
        :paramtype used_bytes: long
        """
        super(DailySchedule, self).__init__(**kwargs)
        self.snapshots_to_keep = snapshots_to_keep
        self.hour = hour
        self.minute = minute
        self.used_bytes = used_bytes


class Dimension(msrest.serialization.Model):
    """Dimension of blobs, possibly be blob type or access tier.

    :ivar name: Display name of dimension.
    :vartype name: str
    :ivar display_name: Display name of dimension.
    :vartype display_name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Display name of dimension.
        :paramtype name: str
        :keyword display_name: Display name of dimension.
        :paramtype display_name: str
        """
        super(Dimension, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name


class ExportPolicyRule(msrest.serialization.Model):
    """Volume Export Policy Rule.

    :ivar rule_index: Order index.
    :vartype rule_index: int
    :ivar unix_read_only: Read only access.
    :vartype unix_read_only: bool
    :ivar unix_read_write: Read and write access.
    :vartype unix_read_write: bool
    :ivar kerberos5_read_only: Kerberos5 Read only access. To be use with swagger version
     2020-05-01 or later.
    :vartype kerberos5_read_only: bool
    :ivar kerberos5_read_write: Kerberos5 Read and write access. To be use with swagger version
     2020-05-01 or later.
    :vartype kerberos5_read_write: bool
    :ivar kerberos5_i_read_only: Kerberos5i Read only access. To be use with swagger version
     2020-05-01 or later.
    :vartype kerberos5_i_read_only: bool
    :ivar kerberos5_i_read_write: Kerberos5i Read and write access. To be use with swagger version
     2020-05-01 or later.
    :vartype kerberos5_i_read_write: bool
    :ivar kerberos5_p_read_only: Kerberos5p Read only access. To be use with swagger version
     2020-05-01 or later.
    :vartype kerberos5_p_read_only: bool
    :ivar kerberos5_p_read_write: Kerberos5p Read and write access. To be use with swagger version
     2020-05-01 or later.
    :vartype kerberos5_p_read_write: bool
    :ivar cifs: Allows CIFS protocol.
    :vartype cifs: bool
    :ivar nfsv3: Allows NFSv3 protocol. Enable only for NFSv3 type volumes.
    :vartype nfsv3: bool
    :ivar nfsv41: Allows NFSv4.1 protocol. Enable only for NFSv4.1 type volumes.
    :vartype nfsv41: bool
    :ivar allowed_clients: Client ingress specification as comma separated string with IPv4 CIDRs,
     IPv4 host addresses and host names.
    :vartype allowed_clients: str
    :ivar has_root_access: Has root access to volume.
    :vartype has_root_access: bool
    :ivar chown_mode: This parameter specifies who is authorized to change the ownership of a file.
     restricted - Only root user can change the ownership of the file. unrestricted - Non-root users
     can change ownership of files that they own. Known values are: "Restricted", "Unrestricted".
     Default value: "Restricted".
    :vartype chown_mode: str or ~azure.mgmt.netapp.models.ChownMode
    """

    _attribute_map = {
        'rule_index': {'key': 'ruleIndex', 'type': 'int'},
        'unix_read_only': {'key': 'unixReadOnly', 'type': 'bool'},
        'unix_read_write': {'key': 'unixReadWrite', 'type': 'bool'},
        'kerberos5_read_only': {'key': 'kerberos5ReadOnly', 'type': 'bool'},
        'kerberos5_read_write': {'key': 'kerberos5ReadWrite', 'type': 'bool'},
        'kerberos5_i_read_only': {'key': 'kerberos5iReadOnly', 'type': 'bool'},
        'kerberos5_i_read_write': {'key': 'kerberos5iReadWrite', 'type': 'bool'},
        'kerberos5_p_read_only': {'key': 'kerberos5pReadOnly', 'type': 'bool'},
        'kerberos5_p_read_write': {'key': 'kerberos5pReadWrite', 'type': 'bool'},
        'cifs': {'key': 'cifs', 'type': 'bool'},
        'nfsv3': {'key': 'nfsv3', 'type': 'bool'},
        'nfsv41': {'key': 'nfsv41', 'type': 'bool'},
        'allowed_clients': {'key': 'allowedClients', 'type': 'str'},
        'has_root_access': {'key': 'hasRootAccess', 'type': 'bool'},
        'chown_mode': {'key': 'chownMode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        rule_index: Optional[int] = None,
        unix_read_only: Optional[bool] = None,
        unix_read_write: Optional[bool] = None,
        kerberos5_read_only: Optional[bool] = False,
        kerberos5_read_write: Optional[bool] = False,
        kerberos5_i_read_only: Optional[bool] = False,
        kerberos5_i_read_write: Optional[bool] = False,
        kerberos5_p_read_only: Optional[bool] = False,
        kerberos5_p_read_write: Optional[bool] = False,
        cifs: Optional[bool] = None,
        nfsv3: Optional[bool] = None,
        nfsv41: Optional[bool] = None,
        allowed_clients: Optional[str] = None,
        has_root_access: Optional[bool] = True,
        chown_mode: Optional[Union[str, "_models.ChownMode"]] = "Restricted",
        **kwargs
    ):
        """
        :keyword rule_index: Order index.
        :paramtype rule_index: int
        :keyword unix_read_only: Read only access.
        :paramtype unix_read_only: bool
        :keyword unix_read_write: Read and write access.
        :paramtype unix_read_write: bool
        :keyword kerberos5_read_only: Kerberos5 Read only access. To be use with swagger version
         2020-05-01 or later.
        :paramtype kerberos5_read_only: bool
        :keyword kerberos5_read_write: Kerberos5 Read and write access. To be use with swagger version
         2020-05-01 or later.
        :paramtype kerberos5_read_write: bool
        :keyword kerberos5_i_read_only: Kerberos5i Read only access. To be use with swagger version
         2020-05-01 or later.
        :paramtype kerberos5_i_read_only: bool
        :keyword kerberos5_i_read_write: Kerberos5i Read and write access. To be use with swagger
         version 2020-05-01 or later.
        :paramtype kerberos5_i_read_write: bool
        :keyword kerberos5_p_read_only: Kerberos5p Read only access. To be use with swagger version
         2020-05-01 or later.
        :paramtype kerberos5_p_read_only: bool
        :keyword kerberos5_p_read_write: Kerberos5p Read and write access. To be use with swagger
         version 2020-05-01 or later.
        :paramtype kerberos5_p_read_write: bool
        :keyword cifs: Allows CIFS protocol.
        :paramtype cifs: bool
        :keyword nfsv3: Allows NFSv3 protocol. Enable only for NFSv3 type volumes.
        :paramtype nfsv3: bool
        :keyword nfsv41: Allows NFSv4.1 protocol. Enable only for NFSv4.1 type volumes.
        :paramtype nfsv41: bool
        :keyword allowed_clients: Client ingress specification as comma separated string with IPv4
         CIDRs, IPv4 host addresses and host names.
        :paramtype allowed_clients: str
        :keyword has_root_access: Has root access to volume.
        :paramtype has_root_access: bool
        :keyword chown_mode: This parameter specifies who is authorized to change the ownership of a
         file. restricted - Only root user can change the ownership of the file. unrestricted - Non-root
         users can change ownership of files that they own. Known values are: "Restricted",
         "Unrestricted". Default value: "Restricted".
        :paramtype chown_mode: str or ~azure.mgmt.netapp.models.ChownMode
        """
        super(ExportPolicyRule, self).__init__(**kwargs)
        self.rule_index = rule_index
        self.unix_read_only = unix_read_only
        self.unix_read_write = unix_read_write
        self.kerberos5_read_only = kerberos5_read_only
        self.kerberos5_read_write = kerberos5_read_write
        self.kerberos5_i_read_only = kerberos5_i_read_only
        self.kerberos5_i_read_write = kerberos5_i_read_write
        self.kerberos5_p_read_only = kerberos5_p_read_only
        self.kerberos5_p_read_write = kerberos5_p_read_write
        self.cifs = cifs
        self.nfsv3 = nfsv3
        self.nfsv41 = nfsv41
        self.allowed_clients = allowed_clients
        self.has_root_access = has_root_access
        self.chown_mode = chown_mode


class FilePathAvailabilityRequest(msrest.serialization.Model):
    """File path availability request content - availability is based on the name and the subnetId.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. File path to verify.
    :vartype name: str
    :ivar subnet_id: Required. The Azure Resource URI for a delegated subnet. Must have the
     delegation Microsoft.NetApp/volumes.
    :vartype subnet_id: str
    """

    _validation = {
        'name': {'required': True},
        'subnet_id': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'subnet_id': {'key': 'subnetId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        subnet_id: str,
        **kwargs
    ):
        """
        :keyword name: Required. File path to verify.
        :paramtype name: str
        :keyword subnet_id: Required. The Azure Resource URI for a delegated subnet. Must have the
         delegation Microsoft.NetApp/volumes.
        :paramtype subnet_id: str
        """
        super(FilePathAvailabilityRequest, self).__init__(**kwargs)
        self.name = name
        self.subnet_id = subnet_id


class HourlySchedule(msrest.serialization.Model):
    """Hourly Schedule properties.

    :ivar snapshots_to_keep: Hourly snapshot count to keep.
    :vartype snapshots_to_keep: int
    :ivar minute: Indicates which minute snapshot should be taken.
    :vartype minute: int
    :ivar used_bytes: Resource size in bytes, current storage usage for the volume in bytes.
    :vartype used_bytes: long
    """

    _attribute_map = {
        'snapshots_to_keep': {'key': 'snapshotsToKeep', 'type': 'int'},
        'minute': {'key': 'minute', 'type': 'int'},
        'used_bytes': {'key': 'usedBytes', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        snapshots_to_keep: Optional[int] = None,
        minute: Optional[int] = None,
        used_bytes: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword snapshots_to_keep: Hourly snapshot count to keep.
        :paramtype snapshots_to_keep: int
        :keyword minute: Indicates which minute snapshot should be taken.
        :paramtype minute: int
        :keyword used_bytes: Resource size in bytes, current storage usage for the volume in bytes.
        :paramtype used_bytes: long
        """
        super(HourlySchedule, self).__init__(**kwargs)
        self.snapshots_to_keep = snapshots_to_keep
        self.minute = minute
        self.used_bytes = used_bytes


class LdapSearchScopeOpt(msrest.serialization.Model):
    """LDAP search scope.

    :ivar user_dn: This specifies the user DN, which overrides the base DN for user lookups.
    :vartype user_dn: str
    :ivar group_dn: This specifies the group DN, which overrides the base DN for group lookups.
    :vartype group_dn: str
    :ivar group_membership_filter: This specifies the custom LDAP search filter to be used when
     looking up group membership from LDAP server.
    :vartype group_membership_filter: str
    """

    _validation = {
        'user_dn': {'max_length': 255, 'min_length': 0},
        'group_dn': {'max_length': 255, 'min_length': 0},
        'group_membership_filter': {'max_length': 255, 'min_length': 0},
    }

    _attribute_map = {
        'user_dn': {'key': 'userDN', 'type': 'str'},
        'group_dn': {'key': 'groupDN', 'type': 'str'},
        'group_membership_filter': {'key': 'groupMembershipFilter', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        user_dn: Optional[str] = None,
        group_dn: Optional[str] = None,
        group_membership_filter: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword user_dn: This specifies the user DN, which overrides the base DN for user lookups.
        :paramtype user_dn: str
        :keyword group_dn: This specifies the group DN, which overrides the base DN for group lookups.
        :paramtype group_dn: str
        :keyword group_membership_filter: This specifies the custom LDAP search filter to be used when
         looking up group membership from LDAP server.
        :paramtype group_membership_filter: str
        """
        super(LdapSearchScopeOpt, self).__init__(**kwargs)
        self.user_dn = user_dn
        self.group_dn = group_dn
        self.group_membership_filter = group_membership_filter


class ListReplications(msrest.serialization.Model):
    """List Replications.

    :ivar value: A list of replications.
    :vartype value: list[~azure.mgmt.netapp.models.Replication]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Replication]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.Replication"]] = None,
        **kwargs
    ):
        """
        :keyword value: A list of replications.
        :paramtype value: list[~azure.mgmt.netapp.models.Replication]
        """
        super(ListReplications, self).__init__(**kwargs)
        self.value = value


class LogSpecification(msrest.serialization.Model):
    """Log Definition of a single resource metric.

    :ivar name: Name of log specification.
    :vartype name: str
    :ivar display_name: Display name of log specification.
    :vartype display_name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Name of log specification.
        :paramtype name: str
        :keyword display_name: Display name of log specification.
        :paramtype display_name: str
        """
        super(LogSpecification, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name


class MetricSpecification(msrest.serialization.Model):
    """Metric specification of operation.

    :ivar name: Name of metric specification.
    :vartype name: str
    :ivar display_name: Display name of metric specification.
    :vartype display_name: str
    :ivar display_description: Display description of metric specification.
    :vartype display_description: str
    :ivar unit: Unit could be Bytes or Count.
    :vartype unit: str
    :ivar supported_aggregation_types: Support metric aggregation type.
    :vartype supported_aggregation_types: list[str or
     ~azure.mgmt.netapp.models.MetricAggregationType]
    :ivar supported_time_grain_types: The supported time grain types for the metrics.
    :vartype supported_time_grain_types: list[str]
    :ivar internal_metric_name: The internal metric name.
    :vartype internal_metric_name: str
    :ivar enable_regional_mdm_account: Whether or not the service is using regional MDM accounts.
    :vartype enable_regional_mdm_account: bool
    :ivar source_mdm_account: The source MDM account.
    :vartype source_mdm_account: str
    :ivar source_mdm_namespace: The source MDM namespace.
    :vartype source_mdm_namespace: str
    :ivar dimensions: Dimensions of blobs, including blob type and access tier.
    :vartype dimensions: list[~azure.mgmt.netapp.models.Dimension]
    :ivar aggregation_type: Aggregation type could be Average.
    :vartype aggregation_type: str
    :ivar fill_gap_with_zero: The property to decide fill gap with zero or not.
    :vartype fill_gap_with_zero: bool
    :ivar category: The category this metric specification belong to, could be Capacity.
    :vartype category: str
    :ivar resource_id_dimension_name_override: Account Resource Id.
    :vartype resource_id_dimension_name_override: str
    :ivar is_internal: Whether the metric is internal.
    :vartype is_internal: bool
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'display_description': {'key': 'displayDescription', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'supported_aggregation_types': {'key': 'supportedAggregationTypes', 'type': '[str]'},
        'supported_time_grain_types': {'key': 'supportedTimeGrainTypes', 'type': '[str]'},
        'internal_metric_name': {'key': 'internalMetricName', 'type': 'str'},
        'enable_regional_mdm_account': {'key': 'enableRegionalMdmAccount', 'type': 'bool'},
        'source_mdm_account': {'key': 'sourceMdmAccount', 'type': 'str'},
        'source_mdm_namespace': {'key': 'sourceMdmNamespace', 'type': 'str'},
        'dimensions': {'key': 'dimensions', 'type': '[Dimension]'},
        'aggregation_type': {'key': 'aggregationType', 'type': 'str'},
        'fill_gap_with_zero': {'key': 'fillGapWithZero', 'type': 'bool'},
        'category': {'key': 'category', 'type': 'str'},
        'resource_id_dimension_name_override': {'key': 'resourceIdDimensionNameOverride', 'type': 'str'},
        'is_internal': {'key': 'isInternal', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        display_description: Optional[str] = None,
        unit: Optional[str] = None,
        supported_aggregation_types: Optional[List[Union[str, "_models.MetricAggregationType"]]] = None,
        supported_time_grain_types: Optional[List[str]] = None,
        internal_metric_name: Optional[str] = None,
        enable_regional_mdm_account: Optional[bool] = None,
        source_mdm_account: Optional[str] = None,
        source_mdm_namespace: Optional[str] = None,
        dimensions: Optional[List["_models.Dimension"]] = None,
        aggregation_type: Optional[str] = None,
        fill_gap_with_zero: Optional[bool] = None,
        category: Optional[str] = None,
        resource_id_dimension_name_override: Optional[str] = None,
        is_internal: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword name: Name of metric specification.
        :paramtype name: str
        :keyword display_name: Display name of metric specification.
        :paramtype display_name: str
        :keyword display_description: Display description of metric specification.
        :paramtype display_description: str
        :keyword unit: Unit could be Bytes or Count.
        :paramtype unit: str
        :keyword supported_aggregation_types: Support metric aggregation type.
        :paramtype supported_aggregation_types: list[str or
         ~azure.mgmt.netapp.models.MetricAggregationType]
        :keyword supported_time_grain_types: The supported time grain types for the metrics.
        :paramtype supported_time_grain_types: list[str]
        :keyword internal_metric_name: The internal metric name.
        :paramtype internal_metric_name: str
        :keyword enable_regional_mdm_account: Whether or not the service is using regional MDM
         accounts.
        :paramtype enable_regional_mdm_account: bool
        :keyword source_mdm_account: The source MDM account.
        :paramtype source_mdm_account: str
        :keyword source_mdm_namespace: The source MDM namespace.
        :paramtype source_mdm_namespace: str
        :keyword dimensions: Dimensions of blobs, including blob type and access tier.
        :paramtype dimensions: list[~azure.mgmt.netapp.models.Dimension]
        :keyword aggregation_type: Aggregation type could be Average.
        :paramtype aggregation_type: str
        :keyword fill_gap_with_zero: The property to decide fill gap with zero or not.
        :paramtype fill_gap_with_zero: bool
        :keyword category: The category this metric specification belong to, could be Capacity.
        :paramtype category: str
        :keyword resource_id_dimension_name_override: Account Resource Id.
        :paramtype resource_id_dimension_name_override: str
        :keyword is_internal: Whether the metric is internal.
        :paramtype is_internal: bool
        """
        super(MetricSpecification, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.display_description = display_description
        self.unit = unit
        self.supported_aggregation_types = supported_aggregation_types
        self.supported_time_grain_types = supported_time_grain_types
        self.internal_metric_name = internal_metric_name
        self.enable_regional_mdm_account = enable_regional_mdm_account
        self.source_mdm_account = source_mdm_account
        self.source_mdm_namespace = source_mdm_namespace
        self.dimensions = dimensions
        self.aggregation_type = aggregation_type
        self.fill_gap_with_zero = fill_gap_with_zero
        self.category = category
        self.resource_id_dimension_name_override = resource_id_dimension_name_override
        self.is_internal = is_internal


class MonthlySchedule(msrest.serialization.Model):
    """Monthly Schedule properties.

    :ivar snapshots_to_keep: Monthly snapshot count to keep.
    :vartype snapshots_to_keep: int
    :ivar days_of_month: Indicates which days of the month snapshot should be taken. A comma
     delimited string.
    :vartype days_of_month: str
    :ivar hour: Indicates which hour in UTC timezone a snapshot should be taken.
    :vartype hour: int
    :ivar minute: Indicates which minute snapshot should be taken.
    :vartype minute: int
    :ivar used_bytes: Resource size in bytes, current storage usage for the volume in bytes.
    :vartype used_bytes: long
    """

    _attribute_map = {
        'snapshots_to_keep': {'key': 'snapshotsToKeep', 'type': 'int'},
        'days_of_month': {'key': 'daysOfMonth', 'type': 'str'},
        'hour': {'key': 'hour', 'type': 'int'},
        'minute': {'key': 'minute', 'type': 'int'},
        'used_bytes': {'key': 'usedBytes', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        snapshots_to_keep: Optional[int] = None,
        days_of_month: Optional[str] = None,
        hour: Optional[int] = None,
        minute: Optional[int] = None,
        used_bytes: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword snapshots_to_keep: Monthly snapshot count to keep.
        :paramtype snapshots_to_keep: int
        :keyword days_of_month: Indicates which days of the month snapshot should be taken. A comma
         delimited string.
        :paramtype days_of_month: str
        :keyword hour: Indicates which hour in UTC timezone a snapshot should be taken.
        :paramtype hour: int
        :keyword minute: Indicates which minute snapshot should be taken.
        :paramtype minute: int
        :keyword used_bytes: Resource size in bytes, current storage usage for the volume in bytes.
        :paramtype used_bytes: long
        """
        super(MonthlySchedule, self).__init__(**kwargs)
        self.snapshots_to_keep = snapshots_to_keep
        self.days_of_month = days_of_month
        self.hour = hour
        self.minute = minute
        self.used_bytes = used_bytes


class MountTarget(msrest.serialization.Model):
    """Mount Target.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar location: Required. Resource location.
    :vartype location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar mount_target_id: UUID v4 used to identify the MountTarget.
    :vartype mount_target_id: str
    :ivar file_system_id: Required. UUID v4 used to identify the MountTarget.
    :vartype file_system_id: str
    :ivar ip_address: The mount target's IPv4 address.
    :vartype ip_address: str
    :ivar smb_server_fqdn: The SMB server's Fully Qualified Domain Name, FQDN.
    :vartype smb_server_fqdn: str
    """

    _validation = {
        'location': {'required': True},
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'mount_target_id': {'readonly': True, 'max_length': 36, 'min_length': 36, 'pattern': r'^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$'},
        'file_system_id': {'required': True, 'max_length': 36, 'min_length': 36, 'pattern': r'^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$'},
        'ip_address': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'mount_target_id': {'key': 'properties.mountTargetId', 'type': 'str'},
        'file_system_id': {'key': 'properties.fileSystemId', 'type': 'str'},
        'ip_address': {'key': 'properties.ipAddress', 'type': 'str'},
        'smb_server_fqdn': {'key': 'properties.smbServerFqdn', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        file_system_id: str,
        tags: Optional[Dict[str, str]] = None,
        smb_server_fqdn: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword location: Required. Resource location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword file_system_id: Required. UUID v4 used to identify the MountTarget.
        :paramtype file_system_id: str
        :keyword smb_server_fqdn: The SMB server's Fully Qualified Domain Name, FQDN.
        :paramtype smb_server_fqdn: str
        """
        super(MountTarget, self).__init__(**kwargs)
        self.location = location
        self.id = None
        self.name = None
        self.type = None
        self.tags = tags
        self.mount_target_id = None
        self.file_system_id = file_system_id
        self.ip_address = None
        self.smb_server_fqdn = smb_server_fqdn


class MountTargetProperties(msrest.serialization.Model):
    """Mount target properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar mount_target_id: UUID v4 used to identify the MountTarget.
    :vartype mount_target_id: str
    :ivar file_system_id: Required. UUID v4 used to identify the MountTarget.
    :vartype file_system_id: str
    :ivar ip_address: The mount target's IPv4 address.
    :vartype ip_address: str
    :ivar smb_server_fqdn: The SMB server's Fully Qualified Domain Name, FQDN.
    :vartype smb_server_fqdn: str
    """

    _validation = {
        'mount_target_id': {'readonly': True, 'max_length': 36, 'min_length': 36, 'pattern': r'^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$'},
        'file_system_id': {'required': True, 'max_length': 36, 'min_length': 36, 'pattern': r'^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$'},
        'ip_address': {'readonly': True},
    }

    _attribute_map = {
        'mount_target_id': {'key': 'mountTargetId', 'type': 'str'},
        'file_system_id': {'key': 'fileSystemId', 'type': 'str'},
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
        'smb_server_fqdn': {'key': 'smbServerFqdn', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        file_system_id: str,
        smb_server_fqdn: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword file_system_id: Required. UUID v4 used to identify the MountTarget.
        :paramtype file_system_id: str
        :keyword smb_server_fqdn: The SMB server's Fully Qualified Domain Name, FQDN.
        :paramtype smb_server_fqdn: str
        """
        super(MountTargetProperties, self).__init__(**kwargs)
        self.mount_target_id = None
        self.file_system_id = file_system_id
        self.ip_address = None
        self.smb_server_fqdn = smb_server_fqdn


class NetAppAccount(TrackedResource):
    """NetApp account resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.netapp.models.SystemData
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar provisioning_state: Azure lifecycle management.
    :vartype provisioning_state: str
    :ivar active_directories: Active Directories.
    :vartype active_directories: list[~azure.mgmt.netapp.models.ActiveDirectory]
    :ivar encryption: Encryption settings.
    :vartype encryption: ~azure.mgmt.netapp.models.AccountEncryption
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
        'etag': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'active_directories': {'key': 'properties.activeDirectories', 'type': '[ActiveDirectory]'},
        'encryption': {'key': 'properties.encryption', 'type': 'AccountEncryption'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        active_directories: Optional[List["_models.ActiveDirectory"]] = None,
        encryption: Optional["_models.AccountEncryption"] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        :keyword active_directories: Active Directories.
        :paramtype active_directories: list[~azure.mgmt.netapp.models.ActiveDirectory]
        :keyword encryption: Encryption settings.
        :paramtype encryption: ~azure.mgmt.netapp.models.AccountEncryption
        """
        super(NetAppAccount, self).__init__(tags=tags, location=location, **kwargs)
        self.etag = None
        self.provisioning_state = None
        self.active_directories = active_directories
        self.encryption = encryption


class NetAppAccountList(msrest.serialization.Model):
    """List of NetApp account resources.

    :ivar value: Multiple NetApp accounts.
    :vartype value: list[~azure.mgmt.netapp.models.NetAppAccount]
    :ivar next_link: URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[NetAppAccount]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.NetAppAccount"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Multiple NetApp accounts.
        :paramtype value: list[~azure.mgmt.netapp.models.NetAppAccount]
        :keyword next_link: URL to get the next set of results.
        :paramtype next_link: str
        """
        super(NetAppAccountList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NetAppAccountPatch(msrest.serialization.Model):
    """NetApp account patch resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location: Resource location.
    :vartype location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar provisioning_state: Azure lifecycle management.
    :vartype provisioning_state: str
    :ivar active_directories: Active Directories.
    :vartype active_directories: list[~azure.mgmt.netapp.models.ActiveDirectory]
    :ivar encryption: Encryption settings.
    :vartype encryption: ~azure.mgmt.netapp.models.AccountEncryption
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'active_directories': {'key': 'properties.activeDirectories', 'type': '[ActiveDirectory]'},
        'encryption': {'key': 'properties.encryption', 'type': 'AccountEncryption'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        active_directories: Optional[List["_models.ActiveDirectory"]] = None,
        encryption: Optional["_models.AccountEncryption"] = None,
        **kwargs
    ):
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword active_directories: Active Directories.
        :paramtype active_directories: list[~azure.mgmt.netapp.models.ActiveDirectory]
        :keyword encryption: Encryption settings.
        :paramtype encryption: ~azure.mgmt.netapp.models.AccountEncryption
        """
        super(NetAppAccountPatch, self).__init__(**kwargs)
        self.location = location
        self.id = None
        self.name = None
        self.type = None
        self.tags = tags
        self.provisioning_state = None
        self.active_directories = active_directories
        self.encryption = encryption


class Operation(msrest.serialization.Model):
    """Microsoft.NetApp REST API operation definition.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: Display metadata associated with the operation.
    :vartype display: ~azure.mgmt.netapp.models.OperationDisplay
    :ivar origin: The origin of operations.
    :vartype origin: str
    :ivar service_specification: One property of operation, include metric specifications.
    :vartype service_specification: ~azure.mgmt.netapp.models.ServiceSpecification
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'service_specification': {'key': 'properties.serviceSpecification', 'type': 'ServiceSpecification'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["_models.OperationDisplay"] = None,
        origin: Optional[str] = None,
        service_specification: Optional["_models.ServiceSpecification"] = None,
        **kwargs
    ):
        """
        :keyword name: Operation name: {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword display: Display metadata associated with the operation.
        :paramtype display: ~azure.mgmt.netapp.models.OperationDisplay
        :keyword origin: The origin of operations.
        :paramtype origin: str
        :keyword service_specification: One property of operation, include metric specifications.
        :paramtype service_specification: ~azure.mgmt.netapp.models.ServiceSpecification
        """
        super(Operation, self).__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin
        self.service_specification = service_specification


class OperationDisplay(msrest.serialization.Model):
    """Display metadata associated with the operation.

    :ivar provider: Service provider: Microsoft NetApp.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed etc.
    :vartype resource: str
    :ivar operation: Type of operation: get, read, delete, etc.
    :vartype operation: str
    :ivar description: Operation description.
    :vartype description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword provider: Service provider: Microsoft NetApp.
        :paramtype provider: str
        :keyword resource: Resource on which the operation is performed etc.
        :paramtype resource: str
        :keyword operation: Type of operation: get, read, delete, etc.
        :paramtype operation: str
        :keyword description: Operation description.
        :paramtype description: str
        """
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationListResult(msrest.serialization.Model):
    """Result of the request to list Cloud Volume operations. It contains a list of operations and a URL link to get the next set of results.

    :ivar value: List of Storage operations supported by the Storage resource provider.
    :vartype value: list[~azure.mgmt.netapp.models.Operation]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.Operation"]] = None,
        **kwargs
    ):
        """
        :keyword value: List of Storage operations supported by the Storage resource provider.
        :paramtype value: list[~azure.mgmt.netapp.models.Operation]
        """
        super(OperationListResult, self).__init__(**kwargs)
        self.value = value


class PlacementKeyValuePairs(msrest.serialization.Model):
    """Application specific parameters for the placement of volumes in the volume group.

    All required parameters must be populated in order to send to Azure.

    :ivar key: Required. Key for an application specific parameter for the placement of volumes in
     the volume group.
    :vartype key: str
    :ivar value: Required. Value for an application specific parameter for the placement of volumes
     in the volume group.
    :vartype value: str
    """

    _validation = {
        'key': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key: str,
        value: str,
        **kwargs
    ):
        """
        :keyword key: Required. Key for an application specific parameter for the placement of volumes
         in the volume group.
        :paramtype key: str
        :keyword value: Required. Value for an application specific parameter for the placement of
         volumes in the volume group.
        :paramtype value: str
        """
        super(PlacementKeyValuePairs, self).__init__(**kwargs)
        self.key = key
        self.value = value


class PoolChangeRequest(msrest.serialization.Model):
    """Pool change request.

    All required parameters must be populated in order to send to Azure.

    :ivar new_pool_resource_id: Required. Resource id of the pool to move volume to.
    :vartype new_pool_resource_id: str
    """

    _validation = {
        'new_pool_resource_id': {'required': True},
    }

    _attribute_map = {
        'new_pool_resource_id': {'key': 'newPoolResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        new_pool_resource_id: str,
        **kwargs
    ):
        """
        :keyword new_pool_resource_id: Required. Resource id of the pool to move volume to.
        :paramtype new_pool_resource_id: str
        """
        super(PoolChangeRequest, self).__init__(**kwargs)
        self.new_pool_resource_id = new_pool_resource_id


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.netapp.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ProxyResource, self).__init__(**kwargs)


class QuotaAvailabilityRequest(msrest.serialization.Model):
    """Quota availability request content.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. Name of the resource to verify.
    :vartype name: str
    :ivar type: Required. Resource type used for verification. Known values are:
     "Microsoft.NetApp/netAppAccounts", "Microsoft.NetApp/netAppAccounts/capacityPools",
     "Microsoft.NetApp/netAppAccounts/capacityPools/volumes",
     "Microsoft.NetApp/netAppAccounts/capacityPools/volumes/snapshots".
    :vartype type: str or ~azure.mgmt.netapp.models.CheckQuotaNameResourceTypes
    :ivar resource_group: Required. Resource group name.
    :vartype resource_group: str
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'resource_group': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        type: Union[str, "_models.CheckQuotaNameResourceTypes"],
        resource_group: str,
        **kwargs
    ):
        """
        :keyword name: Required. Name of the resource to verify.
        :paramtype name: str
        :keyword type: Required. Resource type used for verification. Known values are:
         "Microsoft.NetApp/netAppAccounts", "Microsoft.NetApp/netAppAccounts/capacityPools",
         "Microsoft.NetApp/netAppAccounts/capacityPools/volumes",
         "Microsoft.NetApp/netAppAccounts/capacityPools/volumes/snapshots".
        :paramtype type: str or ~azure.mgmt.netapp.models.CheckQuotaNameResourceTypes
        :keyword resource_group: Required. Resource group name.
        :paramtype resource_group: str
        """
        super(QuotaAvailabilityRequest, self).__init__(**kwargs)
        self.name = name
        self.type = type
        self.resource_group = resource_group


class ReestablishReplicationRequest(msrest.serialization.Model):
    """Re-establish request object supplied in the body of the operation.

    :ivar source_volume_id: Resource id of the source volume for the replication.
    :vartype source_volume_id: str
    """

    _attribute_map = {
        'source_volume_id': {'key': 'sourceVolumeId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source_volume_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword source_volume_id: Resource id of the source volume for the replication.
        :paramtype source_volume_id: str
        """
        super(ReestablishReplicationRequest, self).__init__(**kwargs)
        self.source_volume_id = source_volume_id


class Replication(msrest.serialization.Model):
    """Replication properties.

    All required parameters must be populated in order to send to Azure.

    :ivar endpoint_type: Indicates whether the local volume is the source or destination for the
     Volume Replication. Known values are: "src", "dst".
    :vartype endpoint_type: str or ~azure.mgmt.netapp.models.EndpointType
    :ivar replication_schedule: Schedule. Known values are: "_10minutely", "hourly", "daily".
    :vartype replication_schedule: str or ~azure.mgmt.netapp.models.ReplicationSchedule
    :ivar remote_volume_resource_id: Required. The resource ID of the remote volume.
    :vartype remote_volume_resource_id: str
    :ivar remote_volume_region: The remote region for the other end of the Volume Replication.
    :vartype remote_volume_region: str
    """

    _validation = {
        'remote_volume_resource_id': {'required': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
        'replication_schedule': {'key': 'replicationSchedule', 'type': 'str'},
        'remote_volume_resource_id': {'key': 'remoteVolumeResourceId', 'type': 'str'},
        'remote_volume_region': {'key': 'remoteVolumeRegion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        remote_volume_resource_id: str,
        endpoint_type: Optional[Union[str, "_models.EndpointType"]] = None,
        replication_schedule: Optional[Union[str, "_models.ReplicationSchedule"]] = None,
        remote_volume_region: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword endpoint_type: Indicates whether the local volume is the source or destination for the
         Volume Replication. Known values are: "src", "dst".
        :paramtype endpoint_type: str or ~azure.mgmt.netapp.models.EndpointType
        :keyword replication_schedule: Schedule. Known values are: "_10minutely", "hourly", "daily".
        :paramtype replication_schedule: str or ~azure.mgmt.netapp.models.ReplicationSchedule
        :keyword remote_volume_resource_id: Required. The resource ID of the remote volume.
        :paramtype remote_volume_resource_id: str
        :keyword remote_volume_region: The remote region for the other end of the Volume Replication.
        :paramtype remote_volume_region: str
        """
        super(Replication, self).__init__(**kwargs)
        self.endpoint_type = endpoint_type
        self.replication_schedule = replication_schedule
        self.remote_volume_resource_id = remote_volume_resource_id
        self.remote_volume_region = remote_volume_region


class ReplicationObject(msrest.serialization.Model):
    """Replication properties.

    All required parameters must be populated in order to send to Azure.

    :ivar replication_id: Id.
    :vartype replication_id: str
    :ivar endpoint_type: Indicates whether the local volume is the source or destination for the
     Volume Replication. Known values are: "src", "dst".
    :vartype endpoint_type: str or ~azure.mgmt.netapp.models.EndpointType
    :ivar replication_schedule: Schedule. Known values are: "_10minutely", "hourly", "daily".
    :vartype replication_schedule: str or ~azure.mgmt.netapp.models.ReplicationSchedule
    :ivar remote_volume_resource_id: Required. The resource ID of the remote volume.
    :vartype remote_volume_resource_id: str
    :ivar remote_volume_region: The remote region for the other end of the Volume Replication.
    :vartype remote_volume_region: str
    """

    _validation = {
        'remote_volume_resource_id': {'required': True},
    }

    _attribute_map = {
        'replication_id': {'key': 'replicationId', 'type': 'str'},
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
        'replication_schedule': {'key': 'replicationSchedule', 'type': 'str'},
        'remote_volume_resource_id': {'key': 'remoteVolumeResourceId', 'type': 'str'},
        'remote_volume_region': {'key': 'remoteVolumeRegion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        remote_volume_resource_id: str,
        replication_id: Optional[str] = None,
        endpoint_type: Optional[Union[str, "_models.EndpointType"]] = None,
        replication_schedule: Optional[Union[str, "_models.ReplicationSchedule"]] = None,
        remote_volume_region: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword replication_id: Id.
        :paramtype replication_id: str
        :keyword endpoint_type: Indicates whether the local volume is the source or destination for the
         Volume Replication. Known values are: "src", "dst".
        :paramtype endpoint_type: str or ~azure.mgmt.netapp.models.EndpointType
        :keyword replication_schedule: Schedule. Known values are: "_10minutely", "hourly", "daily".
        :paramtype replication_schedule: str or ~azure.mgmt.netapp.models.ReplicationSchedule
        :keyword remote_volume_resource_id: Required. The resource ID of the remote volume.
        :paramtype remote_volume_resource_id: str
        :keyword remote_volume_region: The remote region for the other end of the Volume Replication.
        :paramtype remote_volume_region: str
        """
        super(ReplicationObject, self).__init__(**kwargs)
        self.replication_id = replication_id
        self.endpoint_type = endpoint_type
        self.replication_schedule = replication_schedule
        self.remote_volume_resource_id = remote_volume_resource_id
        self.remote_volume_region = remote_volume_region


class ReplicationStatus(msrest.serialization.Model):
    """Replication status.

    :ivar healthy: Replication health check.
    :vartype healthy: bool
    :ivar relationship_status: Status of the mirror relationship. Known values are: "Idle",
     "Transferring".
    :vartype relationship_status: str or ~azure.mgmt.netapp.models.RelationshipStatus
    :ivar mirror_state: The status of the replication. Known values are: "Uninitialized",
     "Mirrored", "Broken".
    :vartype mirror_state: str or ~azure.mgmt.netapp.models.MirrorState
    :ivar total_progress: The progress of the replication.
    :vartype total_progress: str
    :ivar error_message: Displays error message if the replication is in an error state.
    :vartype error_message: str
    """

    _attribute_map = {
        'healthy': {'key': 'healthy', 'type': 'bool'},
        'relationship_status': {'key': 'relationshipStatus', 'type': 'str'},
        'mirror_state': {'key': 'mirrorState', 'type': 'str'},
        'total_progress': {'key': 'totalProgress', 'type': 'str'},
        'error_message': {'key': 'errorMessage', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        healthy: Optional[bool] = None,
        relationship_status: Optional[Union[str, "_models.RelationshipStatus"]] = None,
        mirror_state: Optional[Union[str, "_models.MirrorState"]] = None,
        total_progress: Optional[str] = None,
        error_message: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword healthy: Replication health check.
        :paramtype healthy: bool
        :keyword relationship_status: Status of the mirror relationship. Known values are: "Idle",
         "Transferring".
        :paramtype relationship_status: str or ~azure.mgmt.netapp.models.RelationshipStatus
        :keyword mirror_state: The status of the replication. Known values are: "Uninitialized",
         "Mirrored", "Broken".
        :paramtype mirror_state: str or ~azure.mgmt.netapp.models.MirrorState
        :keyword total_progress: The progress of the replication.
        :paramtype total_progress: str
        :keyword error_message: Displays error message if the replication is in an error state.
        :paramtype error_message: str
        """
        super(ReplicationStatus, self).__init__(**kwargs)
        self.healthy = healthy
        self.relationship_status = relationship_status
        self.mirror_state = mirror_state
        self.total_progress = total_progress
        self.error_message = error_message


class ResourceIdentity(msrest.serialization.Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: Object id of the identity resource.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id of the resource.
    :vartype tenant_id: str
    :ivar type: Type of Identity. Supported values are: 'None', 'SystemAssigned'.
    :vartype type: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword type: Type of Identity. Supported values are: 'None', 'SystemAssigned'.
        :paramtype type: str
        """
        super(ResourceIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type


class ResourceNameAvailabilityRequest(msrest.serialization.Model):
    """Resource name availability request content.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. Resource name to verify.
    :vartype name: str
    :ivar type: Required. Resource type used for verification. Known values are:
     "Microsoft.NetApp/netAppAccounts", "Microsoft.NetApp/netAppAccounts/capacityPools",
     "Microsoft.NetApp/netAppAccounts/capacityPools/volumes",
     "Microsoft.NetApp/netAppAccounts/capacityPools/volumes/snapshots".
    :vartype type: str or ~azure.mgmt.netapp.models.CheckNameResourceTypes
    :ivar resource_group: Required. Resource group name.
    :vartype resource_group: str
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'resource_group': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        type: Union[str, "_models.CheckNameResourceTypes"],
        resource_group: str,
        **kwargs
    ):
        """
        :keyword name: Required. Resource name to verify.
        :paramtype name: str
        :keyword type: Required. Resource type used for verification. Known values are:
         "Microsoft.NetApp/netAppAccounts", "Microsoft.NetApp/netAppAccounts/capacityPools",
         "Microsoft.NetApp/netAppAccounts/capacityPools/volumes",
         "Microsoft.NetApp/netAppAccounts/capacityPools/volumes/snapshots".
        :paramtype type: str or ~azure.mgmt.netapp.models.CheckNameResourceTypes
        :keyword resource_group: Required. Resource group name.
        :paramtype resource_group: str
        """
        super(ResourceNameAvailabilityRequest, self).__init__(**kwargs)
        self.name = name
        self.type = type
        self.resource_group = resource_group


class RestoreStatus(msrest.serialization.Model):
    """Restore status.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar healthy: Restore health status.
    :vartype healthy: bool
    :ivar relationship_status: Status of the restore SnapMirror relationship. Known values are:
     "Idle", "Transferring".
    :vartype relationship_status: str or ~azure.mgmt.netapp.models.RelationshipStatus
    :ivar mirror_state: The status of the restore. Known values are: "Uninitialized", "Mirrored",
     "Broken".
    :vartype mirror_state: str or ~azure.mgmt.netapp.models.MirrorState
    :ivar unhealthy_reason: Reason for the unhealthy restore relationship.
    :vartype unhealthy_reason: str
    :ivar error_message: Displays error message if the restore is in an error state.
    :vartype error_message: str
    :ivar total_transfer_bytes: Displays the total bytes transferred.
    :vartype total_transfer_bytes: long
    """

    _validation = {
        'healthy': {'readonly': True},
        'relationship_status': {'readonly': True},
        'mirror_state': {'readonly': True},
        'unhealthy_reason': {'readonly': True},
        'error_message': {'readonly': True},
        'total_transfer_bytes': {'readonly': True},
    }

    _attribute_map = {
        'healthy': {'key': 'healthy', 'type': 'bool'},
        'relationship_status': {'key': 'relationshipStatus', 'type': 'str'},
        'mirror_state': {'key': 'mirrorState', 'type': 'str'},
        'unhealthy_reason': {'key': 'unhealthyReason', 'type': 'str'},
        'error_message': {'key': 'errorMessage', 'type': 'str'},
        'total_transfer_bytes': {'key': 'totalTransferBytes', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(RestoreStatus, self).__init__(**kwargs)
        self.healthy = None
        self.relationship_status = None
        self.mirror_state = None
        self.unhealthy_reason = None
        self.error_message = None
        self.total_transfer_bytes = None


class ServiceSpecification(msrest.serialization.Model):
    """One property of operation, include metric specifications.

    :ivar metric_specifications: Metric specifications of operation.
    :vartype metric_specifications: list[~azure.mgmt.netapp.models.MetricSpecification]
    :ivar log_specifications: Log specification of operation.
    :vartype log_specifications: list[~azure.mgmt.netapp.models.LogSpecification]
    """

    _attribute_map = {
        'metric_specifications': {'key': 'metricSpecifications', 'type': '[MetricSpecification]'},
        'log_specifications': {'key': 'logSpecifications', 'type': '[LogSpecification]'},
    }

    def __init__(
        self,
        *,
        metric_specifications: Optional[List["_models.MetricSpecification"]] = None,
        log_specifications: Optional[List["_models.LogSpecification"]] = None,
        **kwargs
    ):
        """
        :keyword metric_specifications: Metric specifications of operation.
        :paramtype metric_specifications: list[~azure.mgmt.netapp.models.MetricSpecification]
        :keyword log_specifications: Log specification of operation.
        :paramtype log_specifications: list[~azure.mgmt.netapp.models.LogSpecification]
        """
        super(ServiceSpecification, self).__init__(**kwargs)
        self.metric_specifications = metric_specifications
        self.log_specifications = log_specifications


class Snapshot(msrest.serialization.Model):
    """Snapshot of a Volume.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar location: Required. Resource location.
    :vartype location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar snapshot_id: UUID v4 used to identify the Snapshot.
    :vartype snapshot_id: str
    :ivar created: The creation date of the snapshot.
    :vartype created: ~datetime.datetime
    :ivar provisioning_state: Azure lifecycle management.
    :vartype provisioning_state: str
    """

    _validation = {
        'location': {'required': True},
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'snapshot_id': {'readonly': True, 'max_length': 36, 'min_length': 36, 'pattern': r'^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$'},
        'created': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'snapshot_id': {'key': 'properties.snapshotId', 'type': 'str'},
        'created': {'key': 'properties.created', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        **kwargs
    ):
        """
        :keyword location: Required. Resource location.
        :paramtype location: str
        """
        super(Snapshot, self).__init__(**kwargs)
        self.location = location
        self.id = None
        self.name = None
        self.type = None
        self.snapshot_id = None
        self.created = None
        self.provisioning_state = None


class SnapshotPoliciesList(msrest.serialization.Model):
    """List of Snapshot Policies.

    :ivar value: A list of snapshot policies.
    :vartype value: list[~azure.mgmt.netapp.models.SnapshotPolicy]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SnapshotPolicy]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.SnapshotPolicy"]] = None,
        **kwargs
    ):
        """
        :keyword value: A list of snapshot policies.
        :paramtype value: list[~azure.mgmt.netapp.models.SnapshotPolicy]
        """
        super(SnapshotPoliciesList, self).__init__(**kwargs)
        self.value = value


class SnapshotPolicy(TrackedResource):
    """Snapshot policy information.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.netapp.models.SystemData
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar hourly_schedule: Schedule for hourly snapshots.
    :vartype hourly_schedule: ~azure.mgmt.netapp.models.HourlySchedule
    :ivar daily_schedule: Schedule for daily snapshots.
    :vartype daily_schedule: ~azure.mgmt.netapp.models.DailySchedule
    :ivar weekly_schedule: Schedule for weekly snapshots.
    :vartype weekly_schedule: ~azure.mgmt.netapp.models.WeeklySchedule
    :ivar monthly_schedule: Schedule for monthly snapshots.
    :vartype monthly_schedule: ~azure.mgmt.netapp.models.MonthlySchedule
    :ivar enabled: The property to decide policy is enabled or not.
    :vartype enabled: bool
    :ivar provisioning_state: Azure lifecycle management.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
        'etag': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'hourly_schedule': {'key': 'properties.hourlySchedule', 'type': 'HourlySchedule'},
        'daily_schedule': {'key': 'properties.dailySchedule', 'type': 'DailySchedule'},
        'weekly_schedule': {'key': 'properties.weeklySchedule', 'type': 'WeeklySchedule'},
        'monthly_schedule': {'key': 'properties.monthlySchedule', 'type': 'MonthlySchedule'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        hourly_schedule: Optional["_models.HourlySchedule"] = None,
        daily_schedule: Optional["_models.DailySchedule"] = None,
        weekly_schedule: Optional["_models.WeeklySchedule"] = None,
        monthly_schedule: Optional["_models.MonthlySchedule"] = None,
        enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        :keyword hourly_schedule: Schedule for hourly snapshots.
        :paramtype hourly_schedule: ~azure.mgmt.netapp.models.HourlySchedule
        :keyword daily_schedule: Schedule for daily snapshots.
        :paramtype daily_schedule: ~azure.mgmt.netapp.models.DailySchedule
        :keyword weekly_schedule: Schedule for weekly snapshots.
        :paramtype weekly_schedule: ~azure.mgmt.netapp.models.WeeklySchedule
        :keyword monthly_schedule: Schedule for monthly snapshots.
        :paramtype monthly_schedule: ~azure.mgmt.netapp.models.MonthlySchedule
        :keyword enabled: The property to decide policy is enabled or not.
        :paramtype enabled: bool
        """
        super(SnapshotPolicy, self).__init__(tags=tags, location=location, **kwargs)
        self.etag = None
        self.hourly_schedule = hourly_schedule
        self.daily_schedule = daily_schedule
        self.weekly_schedule = weekly_schedule
        self.monthly_schedule = monthly_schedule
        self.enabled = enabled
        self.provisioning_state = None


class SnapshotPolicyDetails(msrest.serialization.Model):
    """Snapshot policy properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location: Resource location.
    :vartype location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar hourly_schedule: Schedule for hourly snapshots.
    :vartype hourly_schedule: ~azure.mgmt.netapp.models.HourlySchedule
    :ivar daily_schedule: Schedule for daily snapshots.
    :vartype daily_schedule: ~azure.mgmt.netapp.models.DailySchedule
    :ivar weekly_schedule: Schedule for weekly snapshots.
    :vartype weekly_schedule: ~azure.mgmt.netapp.models.WeeklySchedule
    :ivar monthly_schedule: Schedule for monthly snapshots.
    :vartype monthly_schedule: ~azure.mgmt.netapp.models.MonthlySchedule
    :ivar enabled: The property to decide policy is enabled or not.
    :vartype enabled: bool
    :ivar provisioning_state: Azure lifecycle management.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'hourly_schedule': {'key': 'properties.hourlySchedule', 'type': 'HourlySchedule'},
        'daily_schedule': {'key': 'properties.dailySchedule', 'type': 'DailySchedule'},
        'weekly_schedule': {'key': 'properties.weeklySchedule', 'type': 'WeeklySchedule'},
        'monthly_schedule': {'key': 'properties.monthlySchedule', 'type': 'MonthlySchedule'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        hourly_schedule: Optional["_models.HourlySchedule"] = None,
        daily_schedule: Optional["_models.DailySchedule"] = None,
        weekly_schedule: Optional["_models.WeeklySchedule"] = None,
        monthly_schedule: Optional["_models.MonthlySchedule"] = None,
        enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword hourly_schedule: Schedule for hourly snapshots.
        :paramtype hourly_schedule: ~azure.mgmt.netapp.models.HourlySchedule
        :keyword daily_schedule: Schedule for daily snapshots.
        :paramtype daily_schedule: ~azure.mgmt.netapp.models.DailySchedule
        :keyword weekly_schedule: Schedule for weekly snapshots.
        :paramtype weekly_schedule: ~azure.mgmt.netapp.models.WeeklySchedule
        :keyword monthly_schedule: Schedule for monthly snapshots.
        :paramtype monthly_schedule: ~azure.mgmt.netapp.models.MonthlySchedule
        :keyword enabled: The property to decide policy is enabled or not.
        :paramtype enabled: bool
        """
        super(SnapshotPolicyDetails, self).__init__(**kwargs)
        self.location = location
        self.id = None
        self.name = None
        self.type = None
        self.tags = tags
        self.hourly_schedule = hourly_schedule
        self.daily_schedule = daily_schedule
        self.weekly_schedule = weekly_schedule
        self.monthly_schedule = monthly_schedule
        self.enabled = enabled
        self.provisioning_state = None


class SnapshotPolicyPatch(msrest.serialization.Model):
    """Snapshot policy Details for create and update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location: Resource location.
    :vartype location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar hourly_schedule: Schedule for hourly snapshots.
    :vartype hourly_schedule: ~azure.mgmt.netapp.models.HourlySchedule
    :ivar daily_schedule: Schedule for daily snapshots.
    :vartype daily_schedule: ~azure.mgmt.netapp.models.DailySchedule
    :ivar weekly_schedule: Schedule for weekly snapshots.
    :vartype weekly_schedule: ~azure.mgmt.netapp.models.WeeklySchedule
    :ivar monthly_schedule: Schedule for monthly snapshots.
    :vartype monthly_schedule: ~azure.mgmt.netapp.models.MonthlySchedule
    :ivar enabled: The property to decide policy is enabled or not.
    :vartype enabled: bool
    :ivar provisioning_state: Azure lifecycle management.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'hourly_schedule': {'key': 'properties.hourlySchedule', 'type': 'HourlySchedule'},
        'daily_schedule': {'key': 'properties.dailySchedule', 'type': 'DailySchedule'},
        'weekly_schedule': {'key': 'properties.weeklySchedule', 'type': 'WeeklySchedule'},
        'monthly_schedule': {'key': 'properties.monthlySchedule', 'type': 'MonthlySchedule'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        hourly_schedule: Optional["_models.HourlySchedule"] = None,
        daily_schedule: Optional["_models.DailySchedule"] = None,
        weekly_schedule: Optional["_models.WeeklySchedule"] = None,
        monthly_schedule: Optional["_models.MonthlySchedule"] = None,
        enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword hourly_schedule: Schedule for hourly snapshots.
        :paramtype hourly_schedule: ~azure.mgmt.netapp.models.HourlySchedule
        :keyword daily_schedule: Schedule for daily snapshots.
        :paramtype daily_schedule: ~azure.mgmt.netapp.models.DailySchedule
        :keyword weekly_schedule: Schedule for weekly snapshots.
        :paramtype weekly_schedule: ~azure.mgmt.netapp.models.WeeklySchedule
        :keyword monthly_schedule: Schedule for monthly snapshots.
        :paramtype monthly_schedule: ~azure.mgmt.netapp.models.MonthlySchedule
        :keyword enabled: The property to decide policy is enabled or not.
        :paramtype enabled: bool
        """
        super(SnapshotPolicyPatch, self).__init__(**kwargs)
        self.location = location
        self.id = None
        self.name = None
        self.type = None
        self.tags = tags
        self.hourly_schedule = hourly_schedule
        self.daily_schedule = daily_schedule
        self.weekly_schedule = weekly_schedule
        self.monthly_schedule = monthly_schedule
        self.enabled = enabled
        self.provisioning_state = None


class SnapshotPolicyVolumeList(msrest.serialization.Model):
    """Volumes associated with snapshot policy.

    :ivar value: List of volumes.
    :vartype value: list[~azure.mgmt.netapp.models.Volume]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Volume]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.Volume"]] = None,
        **kwargs
    ):
        """
        :keyword value: List of volumes.
        :paramtype value: list[~azure.mgmt.netapp.models.Volume]
        """
        super(SnapshotPolicyVolumeList, self).__init__(**kwargs)
        self.value = value


class SnapshotRestoreFiles(msrest.serialization.Model):
    """Restore payload for Single File Snapshot Restore.

    All required parameters must be populated in order to send to Azure.

    :ivar file_paths: Required. List of files to be restored.
    :vartype file_paths: list[str]
    :ivar destination_path: Destination folder where the files will be restored.
    :vartype destination_path: str
    """

    _validation = {
        'file_paths': {'required': True, 'max_items': 10, 'min_items': 1},
    }

    _attribute_map = {
        'file_paths': {'key': 'filePaths', 'type': '[str]'},
        'destination_path': {'key': 'destinationPath', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        file_paths: List[str],
        destination_path: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword file_paths: Required. List of files to be restored.
        :paramtype file_paths: list[str]
        :keyword destination_path: Destination folder where the files will be restored.
        :paramtype destination_path: str
        """
        super(SnapshotRestoreFiles, self).__init__(**kwargs)
        self.file_paths = file_paths
        self.destination_path = destination_path


class SnapshotsList(msrest.serialization.Model):
    """List of Snapshots.

    :ivar value: A list of Snapshots.
    :vartype value: list[~azure.mgmt.netapp.models.Snapshot]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Snapshot]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.Snapshot"]] = None,
        **kwargs
    ):
        """
        :keyword value: A list of Snapshots.
        :paramtype value: list[~azure.mgmt.netapp.models.Snapshot]
        """
        super(SnapshotsList, self).__init__(**kwargs)
        self.value = value


class SubscriptionQuotaItem(ProxyResource):
    """Information regarding Subscription Quota Item.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.netapp.models.SystemData
    :ivar current: The current quota value.
    :vartype current: int
    :ivar default: The default quota value.
    :vartype default: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'current': {'readonly': True},
        'default': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'current': {'key': 'properties.current', 'type': 'int'},
        'default': {'key': 'properties.default', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(SubscriptionQuotaItem, self).__init__(**kwargs)
        self.current = None
        self.default = None


class SubscriptionQuotaItemList(msrest.serialization.Model):
    """List of Subscription Quota Items.

    :ivar value: A list of SubscriptionQuotaItems.
    :vartype value: list[~azure.mgmt.netapp.models.SubscriptionQuotaItem]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SubscriptionQuotaItem]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.SubscriptionQuotaItem"]] = None,
        **kwargs
    ):
        """
        :keyword value: A list of SubscriptionQuotaItems.
        :paramtype value: list[~azure.mgmt.netapp.models.SubscriptionQuotaItem]
        """
        super(SubscriptionQuotaItemList, self).__init__(**kwargs)
        self.value = value


class SubvolumeInfo(ProxyResource):
    """Subvolume Information properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.netapp.models.SystemData
    :ivar path: Path to the subvolume.
    :vartype path: str
    :ivar size: Truncate subvolume to the provided size in bytes.
    :vartype size: long
    :ivar parent_path: parent path to the subvolume.
    :vartype parent_path: str
    :ivar provisioning_state: Azure lifecycle management.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'path': {'key': 'properties.path', 'type': 'str'},
        'size': {'key': 'properties.size', 'type': 'long'},
        'parent_path': {'key': 'properties.parentPath', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        path: Optional[str] = None,
        size: Optional[int] = None,
        parent_path: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword path: Path to the subvolume.
        :paramtype path: str
        :keyword size: Truncate subvolume to the provided size in bytes.
        :paramtype size: long
        :keyword parent_path: parent path to the subvolume.
        :paramtype parent_path: str
        """
        super(SubvolumeInfo, self).__init__(**kwargs)
        self.path = path
        self.size = size
        self.parent_path = parent_path
        self.provisioning_state = None


class SubvolumeModel(msrest.serialization.Model):
    """Result of the post subvolume and action is to get metadata of the subvolume.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar path: Path to the subvolume.
    :vartype path: str
    :ivar parent_path: Path to the parent subvolume.
    :vartype parent_path: str
    :ivar size: Size of subvolume.
    :vartype size: long
    :ivar bytes_used: Bytes used.
    :vartype bytes_used: long
    :ivar permissions: Permissions of the subvolume.
    :vartype permissions: str
    :ivar creation_time_stamp: Creation time and date.
    :vartype creation_time_stamp: ~datetime.datetime
    :ivar accessed_time_stamp: Most recent access time and date.
    :vartype accessed_time_stamp: ~datetime.datetime
    :ivar modified_time_stamp: Most recent modification time and date.
    :vartype modified_time_stamp: ~datetime.datetime
    :ivar changed_time_stamp: Most recent change time and date.
    :vartype changed_time_stamp: ~datetime.datetime
    :ivar provisioning_state: Azure lifecycle management.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'path': {'key': 'properties.path', 'type': 'str'},
        'parent_path': {'key': 'properties.parentPath', 'type': 'str'},
        'size': {'key': 'properties.size', 'type': 'long'},
        'bytes_used': {'key': 'properties.bytesUsed', 'type': 'long'},
        'permissions': {'key': 'properties.permissions', 'type': 'str'},
        'creation_time_stamp': {'key': 'properties.creationTimeStamp', 'type': 'iso-8601'},
        'accessed_time_stamp': {'key': 'properties.accessedTimeStamp', 'type': 'iso-8601'},
        'modified_time_stamp': {'key': 'properties.modifiedTimeStamp', 'type': 'iso-8601'},
        'changed_time_stamp': {'key': 'properties.changedTimeStamp', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        path: Optional[str] = None,
        parent_path: Optional[str] = None,
        size: Optional[int] = None,
        bytes_used: Optional[int] = None,
        permissions: Optional[str] = None,
        creation_time_stamp: Optional[datetime.datetime] = None,
        accessed_time_stamp: Optional[datetime.datetime] = None,
        modified_time_stamp: Optional[datetime.datetime] = None,
        changed_time_stamp: Optional[datetime.datetime] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword path: Path to the subvolume.
        :paramtype path: str
        :keyword parent_path: Path to the parent subvolume.
        :paramtype parent_path: str
        :keyword size: Size of subvolume.
        :paramtype size: long
        :keyword bytes_used: Bytes used.
        :paramtype bytes_used: long
        :keyword permissions: Permissions of the subvolume.
        :paramtype permissions: str
        :keyword creation_time_stamp: Creation time and date.
        :paramtype creation_time_stamp: ~datetime.datetime
        :keyword accessed_time_stamp: Most recent access time and date.
        :paramtype accessed_time_stamp: ~datetime.datetime
        :keyword modified_time_stamp: Most recent modification time and date.
        :paramtype modified_time_stamp: ~datetime.datetime
        :keyword changed_time_stamp: Most recent change time and date.
        :paramtype changed_time_stamp: ~datetime.datetime
        :keyword provisioning_state: Azure lifecycle management.
        :paramtype provisioning_state: str
        """
        super(SubvolumeModel, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.path = path
        self.parent_path = parent_path
        self.size = size
        self.bytes_used = bytes_used
        self.permissions = permissions
        self.creation_time_stamp = creation_time_stamp
        self.accessed_time_stamp = accessed_time_stamp
        self.modified_time_stamp = modified_time_stamp
        self.changed_time_stamp = changed_time_stamp
        self.provisioning_state = provisioning_state


class SubvolumePatchRequest(msrest.serialization.Model):
    """Subvolume Patch Request properties.

    :ivar size: Truncate subvolume to the provided size in bytes.
    :vartype size: long
    :ivar path: path to the subvolume.
    :vartype path: str
    """

    _attribute_map = {
        'size': {'key': 'properties.size', 'type': 'long'},
        'path': {'key': 'properties.path', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        size: Optional[int] = None,
        path: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword size: Truncate subvolume to the provided size in bytes.
        :paramtype size: long
        :keyword path: path to the subvolume.
        :paramtype path: str
        """
        super(SubvolumePatchRequest, self).__init__(**kwargs)
        self.size = size
        self.path = path


class SubvolumesList(msrest.serialization.Model):
    """List of Subvolumes.

    :ivar value: A list of Subvolumes.
    :vartype value: list[~azure.mgmt.netapp.models.SubvolumeInfo]
    :ivar next_link: URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SubvolumeInfo]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.SubvolumeInfo"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: A list of Subvolumes.
        :paramtype value: list[~azure.mgmt.netapp.models.SubvolumeInfo]
        :keyword next_link: URL to get the next set of results.
        :paramtype next_link: str
        """
        super(SubvolumesList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", "Key".
    :vartype created_by_type: str or ~azure.mgmt.netapp.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.netapp.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", "Key".
        :paramtype created_by_type: str or ~azure.mgmt.netapp.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.netapp.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super(SystemData, self).__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class Vault(msrest.serialization.Model):
    """Vault information.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar location: Required. Resource location.
    :vartype location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar vault_name: Vault Name.
    :vartype vault_name: str
    """

    _validation = {
        'location': {'required': True},
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'vault_name': {'key': 'properties.vaultName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        vault_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword location: Required. Resource location.
        :paramtype location: str
        :keyword vault_name: Vault Name.
        :paramtype vault_name: str
        """
        super(Vault, self).__init__(**kwargs)
        self.location = location
        self.id = None
        self.name = None
        self.type = None
        self.vault_name = vault_name


class VaultList(msrest.serialization.Model):
    """List of Vaults.

    :ivar value: A list of vaults.
    :vartype value: list[~azure.mgmt.netapp.models.Vault]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Vault]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.Vault"]] = None,
        **kwargs
    ):
        """
        :keyword value: A list of vaults.
        :paramtype value: list[~azure.mgmt.netapp.models.Vault]
        """
        super(VaultList, self).__init__(**kwargs)
        self.value = value


class Volume(TrackedResource):
    """Volume resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.netapp.models.SystemData
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar zones: Availability Zone.
    :vartype zones: list[str]
    :ivar file_system_id: Unique FileSystem Identifier.
    :vartype file_system_id: str
    :ivar creation_token: Required. A unique file path for the volume. Used when creating mount
     targets.
    :vartype creation_token: str
    :ivar service_level: The service level of the file system. Known values are: "Standard",
     "Premium", "Ultra", "StandardZRS". Default value: "Premium".
    :vartype service_level: str or ~azure.mgmt.netapp.models.ServiceLevel
    :ivar usage_threshold: Required. Maximum storage quota allowed for a file system in bytes. This
     is a soft quota used for alerting only. Minimum size is 100 GiB. Upper limit is 100TiB.
     Specified in bytes.
    :vartype usage_threshold: long
    :ivar export_policy: Set of export policy rules.
    :vartype export_policy: ~azure.mgmt.netapp.models.VolumePropertiesExportPolicy
    :ivar protocol_types: Set of protocol types, default NFSv3, CIFS for SMB protocol.
    :vartype protocol_types: list[str]
    :ivar provisioning_state: Azure lifecycle management.
    :vartype provisioning_state: str
    :ivar snapshot_id: UUID v4 or resource identifier used to identify the Snapshot.
    :vartype snapshot_id: str
    :ivar backup_id: UUID v4 or resource identifier used to identify the Backup.
    :vartype backup_id: str
    :ivar baremetal_tenant_id: Unique Baremetal Tenant Identifier.
    :vartype baremetal_tenant_id: str
    :ivar subnet_id: Required. The Azure Resource URI for a delegated subnet. Must have the
     delegation Microsoft.NetApp/volumes.
    :vartype subnet_id: str
    :ivar network_features: Basic network, or Standard features available to the volume. Known
     values are: "Basic", "Standard". Default value: "Basic".
    :vartype network_features: str or ~azure.mgmt.netapp.models.NetworkFeatures
    :ivar network_sibling_set_id: Network Sibling Set ID for the the group of volumes sharing
     networking resources.
    :vartype network_sibling_set_id: str
    :ivar storage_to_network_proximity: Provides storage to network proximity information for the
     volume. Known values are: "Default", "T1", "T2".
    :vartype storage_to_network_proximity: str or
     ~azure.mgmt.netapp.models.VolumeStorageToNetworkProximity
    :ivar mount_targets: List of mount targets.
    :vartype mount_targets: list[~azure.mgmt.netapp.models.MountTargetProperties]
    :ivar volume_type: What type of volume is this. For destination volumes in Cross Region
     Replication, set type to DataProtection.
    :vartype volume_type: str
    :ivar data_protection: DataProtection type volumes include an object containing details of the
     replication.
    :vartype data_protection: ~azure.mgmt.netapp.models.VolumePropertiesDataProtection
    :ivar is_restoring: Restoring.
    :vartype is_restoring: bool
    :ivar snapshot_directory_visible: If enabled (true) the volume will contain a read-only
     snapshot directory which provides access to each of the volume's snapshots (default to true).
    :vartype snapshot_directory_visible: bool
    :ivar kerberos_enabled: Describe if a volume is KerberosEnabled. To be use with swagger version
     2020-05-01 or later.
    :vartype kerberos_enabled: bool
    :ivar security_style: The security style of volume, default unix, defaults to ntfs for dual
     protocol or CIFS protocol. Known values are: "ntfs", "unix". Default value: "unix".
    :vartype security_style: str or ~azure.mgmt.netapp.models.SecurityStyle
    :ivar smb_encryption: Enables encryption for in-flight smb3 data. Only applicable for
     SMB/DualProtocol volume. To be used with swagger version 2020-08-01 or later.
    :vartype smb_encryption: bool
    :ivar smb_continuously_available: Enables continuously available share property for smb volume.
     Only applicable for SMB volume.
    :vartype smb_continuously_available: bool
    :ivar throughput_mibps: Maximum throughput in MiB/s that can be achieved by this volume and
     this will be accepted as input only for manual qosType volume.
    :vartype throughput_mibps: float
    :ivar encryption_key_source: Source of key used to encrypt data in volume. Applicable if NetApp
     account has encryption.keySource = 'Microsoft.KeyVault'. Possible values (case-insensitive)
     are: 'Microsoft.NetApp, Microsoft.KeyVault'. Known values are: "Microsoft.NetApp",
     "Microsoft.KeyVault". Default value: "Microsoft.NetApp".
    :vartype encryption_key_source: str or ~azure.mgmt.netapp.models.EncryptionKeySource
    :ivar key_vault_private_endpoint_resource_id: The resource ID of private endpoint for KeyVault.
     It must reside in the same VNET as the volume. Only applicable if encryptionKeySource =
     'Microsoft.KeyVault'.
    :vartype key_vault_private_endpoint_resource_id: str
    :ivar ldap_enabled: Specifies whether LDAP is enabled or not for a given NFS volume.
    :vartype ldap_enabled: bool
    :ivar cool_access: Specifies whether Cool Access(tiering) is enabled for the volume.
    :vartype cool_access: bool
    :ivar coolness_period: Specifies the number of days after which data that is not accessed by
     clients will be tiered.
    :vartype coolness_period: int
    :ivar unix_permissions: UNIX permissions for NFS volume accepted in octal 4 digit format. First
     digit selects the set user ID(4), set group ID (2) and sticky (1) attributes. Second digit
     selects permission for the owner of the file: read (4), write (2) and execute (1). Third
     selects permissions for other users in the same group. the fourth for other users not in the
     group. 0755 - gives read/write/execute permissions to owner and read/execute to group and other
     users.
    :vartype unix_permissions: str
    :ivar clone_progress: When a volume is being restored from another volume's snapshot, will show
     the percentage completion of this cloning process. When this value is empty/null there is no
     cloning process currently happening on this volume. This value will update every 5 minutes
     during cloning.
    :vartype clone_progress: int
    :ivar avs_data_store: Specifies whether the volume is enabled for Azure VMware Solution (AVS)
     datastore purpose. Known values are: "Enabled", "Disabled". Default value: "Disabled".
    :vartype avs_data_store: str or ~azure.mgmt.netapp.models.AvsDataStore
    :ivar is_default_quota_enabled: Specifies if default quota is enabled for the volume.
    :vartype is_default_quota_enabled: bool
    :ivar default_user_quota_in_ki_bs: Default user quota for volume in KiBs. If
     isDefaultQuotaEnabled is set, the minimum value of 4 KiBs applies .
    :vartype default_user_quota_in_ki_bs: long
    :ivar default_group_quota_in_ki_bs: Default group quota for volume in KiBs. If
     isDefaultQuotaEnabled is set, the minimum value of 4 KiBs applies.
    :vartype default_group_quota_in_ki_bs: long
    :ivar maximum_number_of_files: Maximum number of files allowed. Needs a service request in
     order to be changed. Only allowed to be changed if volume quota is more than 4TiB.
    :vartype maximum_number_of_files: long
    :ivar volume_group_name: Volume Group Name.
    :vartype volume_group_name: str
    :ivar capacity_pool_resource_id: Pool Resource Id used in case of creating a volume through
     volume group.
    :vartype capacity_pool_resource_id: str
    :ivar proximity_placement_group: Proximity placement group associated with the volume.
    :vartype proximity_placement_group: str
    :ivar t2_network: T2 network information.
    :vartype t2_network: str
    :ivar volume_spec_name: Volume spec name is the application specific designation or identifier
     for the particular volume in a volume group for e.g. data, log.
    :vartype volume_spec_name: str
    :ivar encrypted: Specifies if the volume is encrypted or not. Only available on volumes created
     or updated after 2022-01-01.
    :vartype encrypted: bool
    :ivar placement_rules: Application specific placement rules for the particular volume.
    :vartype placement_rules: list[~azure.mgmt.netapp.models.PlacementKeyValuePairs]
    :ivar enable_subvolumes: Flag indicating whether subvolume operations are enabled on the
     volume. Known values are: "Enabled", "Disabled". Default value: "Disabled".
    :vartype enable_subvolumes: str or ~azure.mgmt.netapp.models.EnableSubvolumes
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
        'etag': {'readonly': True},
        'file_system_id': {'readonly': True, 'max_length': 36, 'min_length': 36, 'pattern': r'^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$'},
        'creation_token': {'required': True, 'max_length': 80, 'min_length': 1, 'pattern': r'^[a-zA-Z][a-zA-Z0-9\-]{0,79}$'},
        'usage_threshold': {'required': True, 'maximum': 109951162777600, 'minimum': 107374182400},
        'provisioning_state': {'readonly': True},
        'snapshot_id': {'max_length': 36, 'min_length': 36, 'pattern': r'^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}|(\\?([^\/]*[\/])*)([^\/]+)$'},
        'backup_id': {'max_length': 36, 'min_length': 36, 'pattern': r'^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}|(\\?([^\/]*[\/])*)([^\/]+)$'},
        'baremetal_tenant_id': {'readonly': True},
        'subnet_id': {'required': True},
        'network_sibling_set_id': {'readonly': True, 'max_length': 36, 'min_length': 36, 'pattern': r'^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$'},
        'storage_to_network_proximity': {'readonly': True},
        'mount_targets': {'readonly': True},
        'coolness_period': {'maximum': 63, 'minimum': 7},
        'unix_permissions': {'max_length': 4, 'min_length': 4},
        'clone_progress': {'readonly': True},
        'maximum_number_of_files': {'readonly': True},
        'volume_group_name': {'readonly': True},
        't2_network': {'readonly': True},
        'encrypted': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'zones': {'key': 'zones', 'type': '[str]'},
        'file_system_id': {'key': 'properties.fileSystemId', 'type': 'str'},
        'creation_token': {'key': 'properties.creationToken', 'type': 'str'},
        'service_level': {'key': 'properties.serviceLevel', 'type': 'str'},
        'usage_threshold': {'key': 'properties.usageThreshold', 'type': 'long'},
        'export_policy': {'key': 'properties.exportPolicy', 'type': 'VolumePropertiesExportPolicy'},
        'protocol_types': {'key': 'properties.protocolTypes', 'type': '[str]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'snapshot_id': {'key': 'properties.snapshotId', 'type': 'str'},
        'backup_id': {'key': 'properties.backupId', 'type': 'str'},
        'baremetal_tenant_id': {'key': 'properties.baremetalTenantId', 'type': 'str'},
        'subnet_id': {'key': 'properties.subnetId', 'type': 'str'},
        'network_features': {'key': 'properties.networkFeatures', 'type': 'str'},
        'network_sibling_set_id': {'key': 'properties.networkSiblingSetId', 'type': 'str'},
        'storage_to_network_proximity': {'key': 'properties.storageToNetworkProximity', 'type': 'str'},
        'mount_targets': {'key': 'properties.mountTargets', 'type': '[MountTargetProperties]'},
        'volume_type': {'key': 'properties.volumeType', 'type': 'str'},
        'data_protection': {'key': 'properties.dataProtection', 'type': 'VolumePropertiesDataProtection'},
        'is_restoring': {'key': 'properties.isRestoring', 'type': 'bool'},
        'snapshot_directory_visible': {'key': 'properties.snapshotDirectoryVisible', 'type': 'bool'},
        'kerberos_enabled': {'key': 'properties.kerberosEnabled', 'type': 'bool'},
        'security_style': {'key': 'properties.securityStyle', 'type': 'str'},
        'smb_encryption': {'key': 'properties.smbEncryption', 'type': 'bool'},
        'smb_continuously_available': {'key': 'properties.smbContinuouslyAvailable', 'type': 'bool'},
        'throughput_mibps': {'key': 'properties.throughputMibps', 'type': 'float'},
        'encryption_key_source': {'key': 'properties.encryptionKeySource', 'type': 'str'},
        'key_vault_private_endpoint_resource_id': {'key': 'properties.keyVaultPrivateEndpointResourceId', 'type': 'str'},
        'ldap_enabled': {'key': 'properties.ldapEnabled', 'type': 'bool'},
        'cool_access': {'key': 'properties.coolAccess', 'type': 'bool'},
        'coolness_period': {'key': 'properties.coolnessPeriod', 'type': 'int'},
        'unix_permissions': {'key': 'properties.unixPermissions', 'type': 'str'},
        'clone_progress': {'key': 'properties.cloneProgress', 'type': 'int'},
        'avs_data_store': {'key': 'properties.avsDataStore', 'type': 'str'},
        'is_default_quota_enabled': {'key': 'properties.isDefaultQuotaEnabled', 'type': 'bool'},
        'default_user_quota_in_ki_bs': {'key': 'properties.defaultUserQuotaInKiBs', 'type': 'long'},
        'default_group_quota_in_ki_bs': {'key': 'properties.defaultGroupQuotaInKiBs', 'type': 'long'},
        'maximum_number_of_files': {'key': 'properties.maximumNumberOfFiles', 'type': 'long'},
        'volume_group_name': {'key': 'properties.volumeGroupName', 'type': 'str'},
        'capacity_pool_resource_id': {'key': 'properties.capacityPoolResourceId', 'type': 'str'},
        'proximity_placement_group': {'key': 'properties.proximityPlacementGroup', 'type': 'str'},
        't2_network': {'key': 'properties.t2Network', 'type': 'str'},
        'volume_spec_name': {'key': 'properties.volumeSpecName', 'type': 'str'},
        'encrypted': {'key': 'properties.encrypted', 'type': 'bool'},
        'placement_rules': {'key': 'properties.placementRules', 'type': '[PlacementKeyValuePairs]'},
        'enable_subvolumes': {'key': 'properties.enableSubvolumes', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        creation_token: str,
        usage_threshold: int = 107374182400,
        subnet_id: str,
        tags: Optional[Dict[str, str]] = None,
        zones: Optional[List[str]] = None,
        service_level: Optional[Union[str, "_models.ServiceLevel"]] = "Premium",
        export_policy: Optional["_models.VolumePropertiesExportPolicy"] = None,
        protocol_types: Optional[List[str]] = None,
        snapshot_id: Optional[str] = None,
        backup_id: Optional[str] = None,
        network_features: Optional[Union[str, "_models.NetworkFeatures"]] = "Basic",
        volume_type: Optional[str] = None,
        data_protection: Optional["_models.VolumePropertiesDataProtection"] = None,
        is_restoring: Optional[bool] = None,
        snapshot_directory_visible: Optional[bool] = True,
        kerberos_enabled: Optional[bool] = False,
        security_style: Optional[Union[str, "_models.SecurityStyle"]] = "unix",
        smb_encryption: Optional[bool] = False,
        smb_continuously_available: Optional[bool] = False,
        throughput_mibps: Optional[float] = None,
        encryption_key_source: Optional[Union[str, "_models.EncryptionKeySource"]] = "Microsoft.NetApp",
        key_vault_private_endpoint_resource_id: Optional[str] = None,
        ldap_enabled: Optional[bool] = False,
        cool_access: Optional[bool] = False,
        coolness_period: Optional[int] = None,
        unix_permissions: Optional[str] = "0770",
        avs_data_store: Optional[Union[str, "_models.AvsDataStore"]] = "Disabled",
        is_default_quota_enabled: Optional[bool] = False,
        default_user_quota_in_ki_bs: Optional[int] = 0,
        default_group_quota_in_ki_bs: Optional[int] = 0,
        capacity_pool_resource_id: Optional[str] = None,
        proximity_placement_group: Optional[str] = None,
        volume_spec_name: Optional[str] = None,
        placement_rules: Optional[List["_models.PlacementKeyValuePairs"]] = None,
        enable_subvolumes: Optional[Union[str, "_models.EnableSubvolumes"]] = "Disabled",
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        :keyword zones: Availability Zone.
        :paramtype zones: list[str]
        :keyword creation_token: Required. A unique file path for the volume. Used when creating mount
         targets.
        :paramtype creation_token: str
        :keyword service_level: The service level of the file system. Known values are: "Standard",
         "Premium", "Ultra", "StandardZRS". Default value: "Premium".
        :paramtype service_level: str or ~azure.mgmt.netapp.models.ServiceLevel
        :keyword usage_threshold: Required. Maximum storage quota allowed for a file system in bytes.
         This is a soft quota used for alerting only. Minimum size is 100 GiB. Upper limit is 100TiB.
         Specified in bytes.
        :paramtype usage_threshold: long
        :keyword export_policy: Set of export policy rules.
        :paramtype export_policy: ~azure.mgmt.netapp.models.VolumePropertiesExportPolicy
        :keyword protocol_types: Set of protocol types, default NFSv3, CIFS for SMB protocol.
        :paramtype protocol_types: list[str]
        :keyword snapshot_id: UUID v4 or resource identifier used to identify the Snapshot.
        :paramtype snapshot_id: str
        :keyword backup_id: UUID v4 or resource identifier used to identify the Backup.
        :paramtype backup_id: str
        :keyword subnet_id: Required. The Azure Resource URI for a delegated subnet. Must have the
         delegation Microsoft.NetApp/volumes.
        :paramtype subnet_id: str
        :keyword network_features: Basic network, or Standard features available to the volume. Known
         values are: "Basic", "Standard". Default value: "Basic".
        :paramtype network_features: str or ~azure.mgmt.netapp.models.NetworkFeatures
        :keyword volume_type: What type of volume is this. For destination volumes in Cross Region
         Replication, set type to DataProtection.
        :paramtype volume_type: str
        :keyword data_protection: DataProtection type volumes include an object containing details of
         the replication.
        :paramtype data_protection: ~azure.mgmt.netapp.models.VolumePropertiesDataProtection
        :keyword is_restoring: Restoring.
        :paramtype is_restoring: bool
        :keyword snapshot_directory_visible: If enabled (true) the volume will contain a read-only
         snapshot directory which provides access to each of the volume's snapshots (default to true).
        :paramtype snapshot_directory_visible: bool
        :keyword kerberos_enabled: Describe if a volume is KerberosEnabled. To be use with swagger
         version 2020-05-01 or later.
        :paramtype kerberos_enabled: bool
        :keyword security_style: The security style of volume, default unix, defaults to ntfs for dual
         protocol or CIFS protocol. Known values are: "ntfs", "unix". Default value: "unix".
        :paramtype security_style: str or ~azure.mgmt.netapp.models.SecurityStyle
        :keyword smb_encryption: Enables encryption for in-flight smb3 data. Only applicable for
         SMB/DualProtocol volume. To be used with swagger version 2020-08-01 or later.
        :paramtype smb_encryption: bool
        :keyword smb_continuously_available: Enables continuously available share property for smb
         volume. Only applicable for SMB volume.
        :paramtype smb_continuously_available: bool
        :keyword throughput_mibps: Maximum throughput in MiB/s that can be achieved by this volume and
         this will be accepted as input only for manual qosType volume.
        :paramtype throughput_mibps: float
        :keyword encryption_key_source: Source of key used to encrypt data in volume. Applicable if
         NetApp account has encryption.keySource = 'Microsoft.KeyVault'. Possible values
         (case-insensitive) are: 'Microsoft.NetApp, Microsoft.KeyVault'. Known values are:
         "Microsoft.NetApp", "Microsoft.KeyVault". Default value: "Microsoft.NetApp".
        :paramtype encryption_key_source: str or ~azure.mgmt.netapp.models.EncryptionKeySource
        :keyword key_vault_private_endpoint_resource_id: The resource ID of private endpoint for
         KeyVault. It must reside in the same VNET as the volume. Only applicable if encryptionKeySource
         = 'Microsoft.KeyVault'.
        :paramtype key_vault_private_endpoint_resource_id: str
        :keyword ldap_enabled: Specifies whether LDAP is enabled or not for a given NFS volume.
        :paramtype ldap_enabled: bool
        :keyword cool_access: Specifies whether Cool Access(tiering) is enabled for the volume.
        :paramtype cool_access: bool
        :keyword coolness_period: Specifies the number of days after which data that is not accessed by
         clients will be tiered.
        :paramtype coolness_period: int
        :keyword unix_permissions: UNIX permissions for NFS volume accepted in octal 4 digit format.
         First digit selects the set user ID(4), set group ID (2) and sticky (1) attributes. Second
         digit selects permission for the owner of the file: read (4), write (2) and execute (1). Third
         selects permissions for other users in the same group. the fourth for other users not in the
         group. 0755 - gives read/write/execute permissions to owner and read/execute to group and other
         users.
        :paramtype unix_permissions: str
        :keyword avs_data_store: Specifies whether the volume is enabled for Azure VMware Solution
         (AVS) datastore purpose. Known values are: "Enabled", "Disabled". Default value: "Disabled".
        :paramtype avs_data_store: str or ~azure.mgmt.netapp.models.AvsDataStore
        :keyword is_default_quota_enabled: Specifies if default quota is enabled for the volume.
        :paramtype is_default_quota_enabled: bool
        :keyword default_user_quota_in_ki_bs: Default user quota for volume in KiBs. If
         isDefaultQuotaEnabled is set, the minimum value of 4 KiBs applies .
        :paramtype default_user_quota_in_ki_bs: long
        :keyword default_group_quota_in_ki_bs: Default group quota for volume in KiBs. If
         isDefaultQuotaEnabled is set, the minimum value of 4 KiBs applies.
        :paramtype default_group_quota_in_ki_bs: long
        :keyword capacity_pool_resource_id: Pool Resource Id used in case of creating a volume through
         volume group.
        :paramtype capacity_pool_resource_id: str
        :keyword proximity_placement_group: Proximity placement group associated with the volume.
        :paramtype proximity_placement_group: str
        :keyword volume_spec_name: Volume spec name is the application specific designation or
         identifier for the particular volume in a volume group for e.g. data, log.
        :paramtype volume_spec_name: str
        :keyword placement_rules: Application specific placement rules for the particular volume.
        :paramtype placement_rules: list[~azure.mgmt.netapp.models.PlacementKeyValuePairs]
        :keyword enable_subvolumes: Flag indicating whether subvolume operations are enabled on the
         volume. Known values are: "Enabled", "Disabled". Default value: "Disabled".
        :paramtype enable_subvolumes: str or ~azure.mgmt.netapp.models.EnableSubvolumes
        """
        super(Volume, self).__init__(tags=tags, location=location, **kwargs)
        self.etag = None
        self.zones = zones
        self.file_system_id = None
        self.creation_token = creation_token
        self.service_level = service_level
        self.usage_threshold = usage_threshold
        self.export_policy = export_policy
        self.protocol_types = protocol_types
        self.provisioning_state = None
        self.snapshot_id = snapshot_id
        self.backup_id = backup_id
        self.baremetal_tenant_id = None
        self.subnet_id = subnet_id
        self.network_features = network_features
        self.network_sibling_set_id = None
        self.storage_to_network_proximity = None
        self.mount_targets = None
        self.volume_type = volume_type
        self.data_protection = data_protection
        self.is_restoring = is_restoring
        self.snapshot_directory_visible = snapshot_directory_visible
        self.kerberos_enabled = kerberos_enabled
        self.security_style = security_style
        self.smb_encryption = smb_encryption
        self.smb_continuously_available = smb_continuously_available
        self.throughput_mibps = throughput_mibps
        self.encryption_key_source = encryption_key_source
        self.key_vault_private_endpoint_resource_id = key_vault_private_endpoint_resource_id
        self.ldap_enabled = ldap_enabled
        self.cool_access = cool_access
        self.coolness_period = coolness_period
        self.unix_permissions = unix_permissions
        self.clone_progress = None
        self.avs_data_store = avs_data_store
        self.is_default_quota_enabled = is_default_quota_enabled
        self.default_user_quota_in_ki_bs = default_user_quota_in_ki_bs
        self.default_group_quota_in_ki_bs = default_group_quota_in_ki_bs
        self.maximum_number_of_files = None
        self.volume_group_name = None
        self.capacity_pool_resource_id = capacity_pool_resource_id
        self.proximity_placement_group = proximity_placement_group
        self.t2_network = None
        self.volume_spec_name = volume_spec_name
        self.encrypted = None
        self.placement_rules = placement_rules
        self.enable_subvolumes = enable_subvolumes


class VolumeBackupProperties(msrest.serialization.Model):
    """Volume Backup Properties.

    :ivar backup_policy_id: Backup Policy Resource ID.
    :vartype backup_policy_id: str
    :ivar policy_enforced: Policy Enforced.
    :vartype policy_enforced: bool
    :ivar vault_id: Vault Resource ID.
    :vartype vault_id: str
    :ivar backup_enabled: Backup Enabled.
    :vartype backup_enabled: bool
    """

    _attribute_map = {
        'backup_policy_id': {'key': 'backupPolicyId', 'type': 'str'},
        'policy_enforced': {'key': 'policyEnforced', 'type': 'bool'},
        'vault_id': {'key': 'vaultId', 'type': 'str'},
        'backup_enabled': {'key': 'backupEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        backup_policy_id: Optional[str] = None,
        policy_enforced: Optional[bool] = None,
        vault_id: Optional[str] = None,
        backup_enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword backup_policy_id: Backup Policy Resource ID.
        :paramtype backup_policy_id: str
        :keyword policy_enforced: Policy Enforced.
        :paramtype policy_enforced: bool
        :keyword vault_id: Vault Resource ID.
        :paramtype vault_id: str
        :keyword backup_enabled: Backup Enabled.
        :paramtype backup_enabled: bool
        """
        super(VolumeBackupProperties, self).__init__(**kwargs)
        self.backup_policy_id = backup_policy_id
        self.policy_enforced = policy_enforced
        self.vault_id = vault_id
        self.backup_enabled = backup_enabled


class VolumeBackups(msrest.serialization.Model):
    """Volume details using the backup policy.

    :ivar volume_name: Volume name.
    :vartype volume_name: str
    :ivar backups_count: Total count of backups for volume.
    :vartype backups_count: int
    :ivar policy_enabled: Policy enabled.
    :vartype policy_enabled: bool
    """

    _attribute_map = {
        'volume_name': {'key': 'volumeName', 'type': 'str'},
        'backups_count': {'key': 'backupsCount', 'type': 'int'},
        'policy_enabled': {'key': 'policyEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        volume_name: Optional[str] = None,
        backups_count: Optional[int] = None,
        policy_enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword volume_name: Volume name.
        :paramtype volume_name: str
        :keyword backups_count: Total count of backups for volume.
        :paramtype backups_count: int
        :keyword policy_enabled: Policy enabled.
        :paramtype policy_enabled: bool
        """
        super(VolumeBackups, self).__init__(**kwargs)
        self.volume_name = volume_name
        self.backups_count = backups_count
        self.policy_enabled = policy_enabled


class VolumeGroup(msrest.serialization.Model):
    """Volume group resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location: Resource location.
    :vartype location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar provisioning_state: Azure lifecycle management.
    :vartype provisioning_state: str
    :ivar group_meta_data: Volume group details.
    :vartype group_meta_data: ~azure.mgmt.netapp.models.VolumeGroupMetaData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'group_meta_data': {'key': 'properties.groupMetaData', 'type': 'VolumeGroupMetaData'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        group_meta_data: Optional["_models.VolumeGroupMetaData"] = None,
        **kwargs
    ):
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword group_meta_data: Volume group details.
        :paramtype group_meta_data: ~azure.mgmt.netapp.models.VolumeGroupMetaData
        """
        super(VolumeGroup, self).__init__(**kwargs)
        self.location = location
        self.id = None
        self.name = None
        self.type = None
        self.provisioning_state = None
        self.group_meta_data = group_meta_data


class VolumeGroupDetails(msrest.serialization.Model):
    """Volume group resource for create.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location: Resource location.
    :vartype location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar provisioning_state: Azure lifecycle management.
    :vartype provisioning_state: str
    :ivar group_meta_data: Volume group details.
    :vartype group_meta_data: ~azure.mgmt.netapp.models.VolumeGroupMetaData
    :ivar volumes: List of volumes from group.
    :vartype volumes: list[~azure.mgmt.netapp.models.VolumeGroupVolumeProperties]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'group_meta_data': {'key': 'properties.groupMetaData', 'type': 'VolumeGroupMetaData'},
        'volumes': {'key': 'properties.volumes', 'type': '[VolumeGroupVolumeProperties]'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        group_meta_data: Optional["_models.VolumeGroupMetaData"] = None,
        volumes: Optional[List["_models.VolumeGroupVolumeProperties"]] = None,
        **kwargs
    ):
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword group_meta_data: Volume group details.
        :paramtype group_meta_data: ~azure.mgmt.netapp.models.VolumeGroupMetaData
        :keyword volumes: List of volumes from group.
        :paramtype volumes: list[~azure.mgmt.netapp.models.VolumeGroupVolumeProperties]
        """
        super(VolumeGroupDetails, self).__init__(**kwargs)
        self.location = location
        self.id = None
        self.name = None
        self.type = None
        self.provisioning_state = None
        self.group_meta_data = group_meta_data
        self.volumes = volumes


class VolumeGroupList(msrest.serialization.Model):
    """List of volume group resources.

    :ivar value: List of volume Groups.
    :vartype value: list[~azure.mgmt.netapp.models.VolumeGroup]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VolumeGroup]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.VolumeGroup"]] = None,
        **kwargs
    ):
        """
        :keyword value: List of volume Groups.
        :paramtype value: list[~azure.mgmt.netapp.models.VolumeGroup]
        """
        super(VolumeGroupList, self).__init__(**kwargs)
        self.value = value


class VolumeGroupMetaData(msrest.serialization.Model):
    """Volume group properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar group_description: Group Description.
    :vartype group_description: str
    :ivar application_type: Application Type. Known values are: "SAP-HANA".
    :vartype application_type: str or ~azure.mgmt.netapp.models.ApplicationType
    :ivar application_identifier: Application specific identifier.
    :vartype application_identifier: str
    :ivar global_placement_rules: Application specific placement rules for the volume group.
    :vartype global_placement_rules: list[~azure.mgmt.netapp.models.PlacementKeyValuePairs]
    :ivar deployment_spec_id: Application specific identifier of deployment rules for the volume
     group.
    :vartype deployment_spec_id: str
    :ivar volumes_count: Number of volumes in volume group.
    :vartype volumes_count: long
    """

    _validation = {
        'volumes_count': {'readonly': True},
    }

    _attribute_map = {
        'group_description': {'key': 'groupDescription', 'type': 'str'},
        'application_type': {'key': 'applicationType', 'type': 'str'},
        'application_identifier': {'key': 'applicationIdentifier', 'type': 'str'},
        'global_placement_rules': {'key': 'globalPlacementRules', 'type': '[PlacementKeyValuePairs]'},
        'deployment_spec_id': {'key': 'deploymentSpecId', 'type': 'str'},
        'volumes_count': {'key': 'volumesCount', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        group_description: Optional[str] = None,
        application_type: Optional[Union[str, "_models.ApplicationType"]] = None,
        application_identifier: Optional[str] = None,
        global_placement_rules: Optional[List["_models.PlacementKeyValuePairs"]] = None,
        deployment_spec_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword group_description: Group Description.
        :paramtype group_description: str
        :keyword application_type: Application Type. Known values are: "SAP-HANA".
        :paramtype application_type: str or ~azure.mgmt.netapp.models.ApplicationType
        :keyword application_identifier: Application specific identifier.
        :paramtype application_identifier: str
        :keyword global_placement_rules: Application specific placement rules for the volume group.
        :paramtype global_placement_rules: list[~azure.mgmt.netapp.models.PlacementKeyValuePairs]
        :keyword deployment_spec_id: Application specific identifier of deployment rules for the volume
         group.
        :paramtype deployment_spec_id: str
        """
        super(VolumeGroupMetaData, self).__init__(**kwargs)
        self.group_description = group_description
        self.application_type = application_type
        self.application_identifier = application_identifier
        self.global_placement_rules = global_placement_rules
        self.deployment_spec_id = deployment_spec_id
        self.volumes_count = None


class VolumeGroupVolumeProperties(msrest.serialization.Model):
    """Volume resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar file_system_id: Unique FileSystem Identifier.
    :vartype file_system_id: str
    :ivar creation_token: Required. A unique file path for the volume. Used when creating mount
     targets.
    :vartype creation_token: str
    :ivar service_level: The service level of the file system. Known values are: "Standard",
     "Premium", "Ultra", "StandardZRS". Default value: "Premium".
    :vartype service_level: str or ~azure.mgmt.netapp.models.ServiceLevel
    :ivar usage_threshold: Required. Maximum storage quota allowed for a file system in bytes. This
     is a soft quota used for alerting only. Minimum size is 100 GiB. Upper limit is 100TiB.
     Specified in bytes.
    :vartype usage_threshold: long
    :ivar export_policy: Set of export policy rules.
    :vartype export_policy: ~azure.mgmt.netapp.models.VolumePropertiesExportPolicy
    :ivar protocol_types: Set of protocol types, default NFSv3, CIFS for SMB protocol.
    :vartype protocol_types: list[str]
    :ivar provisioning_state: Azure lifecycle management.
    :vartype provisioning_state: str
    :ivar snapshot_id: UUID v4 or resource identifier used to identify the Snapshot.
    :vartype snapshot_id: str
    :ivar backup_id: UUID v4 or resource identifier used to identify the Backup.
    :vartype backup_id: str
    :ivar baremetal_tenant_id: Unique Baremetal Tenant Identifier.
    :vartype baremetal_tenant_id: str
    :ivar subnet_id: Required. The Azure Resource URI for a delegated subnet. Must have the
     delegation Microsoft.NetApp/volumes.
    :vartype subnet_id: str
    :ivar network_features: Basic network, or Standard features available to the volume. Known
     values are: "Basic", "Standard". Default value: "Basic".
    :vartype network_features: str or ~azure.mgmt.netapp.models.NetworkFeatures
    :ivar network_sibling_set_id: Network Sibling Set ID for the the group of volumes sharing
     networking resources.
    :vartype network_sibling_set_id: str
    :ivar storage_to_network_proximity: Provides storage to network proximity information for the
     volume. Known values are: "Default", "T1", "T2".
    :vartype storage_to_network_proximity: str or
     ~azure.mgmt.netapp.models.VolumeStorageToNetworkProximity
    :ivar mount_targets: List of mount targets.
    :vartype mount_targets: list[~azure.mgmt.netapp.models.MountTargetProperties]
    :ivar volume_type: What type of volume is this. For destination volumes in Cross Region
     Replication, set type to DataProtection.
    :vartype volume_type: str
    :ivar data_protection: DataProtection type volumes include an object containing details of the
     replication.
    :vartype data_protection: ~azure.mgmt.netapp.models.VolumePropertiesDataProtection
    :ivar is_restoring: Restoring.
    :vartype is_restoring: bool
    :ivar snapshot_directory_visible: If enabled (true) the volume will contain a read-only
     snapshot directory which provides access to each of the volume's snapshots (default to true).
    :vartype snapshot_directory_visible: bool
    :ivar kerberos_enabled: Describe if a volume is KerberosEnabled. To be use with swagger version
     2020-05-01 or later.
    :vartype kerberos_enabled: bool
    :ivar security_style: The security style of volume, default unix, defaults to ntfs for dual
     protocol or CIFS protocol. Known values are: "ntfs", "unix". Default value: "unix".
    :vartype security_style: str or ~azure.mgmt.netapp.models.SecurityStyle
    :ivar smb_encryption: Enables encryption for in-flight smb3 data. Only applicable for
     SMB/DualProtocol volume. To be used with swagger version 2020-08-01 or later.
    :vartype smb_encryption: bool
    :ivar smb_continuously_available: Enables continuously available share property for smb volume.
     Only applicable for SMB volume.
    :vartype smb_continuously_available: bool
    :ivar throughput_mibps: Maximum throughput in MiB/s that can be achieved by this volume and
     this will be accepted as input only for manual qosType volume.
    :vartype throughput_mibps: float
    :ivar encryption_key_source: Source of key used to encrypt data in volume. Applicable if NetApp
     account has encryption.keySource = 'Microsoft.KeyVault'. Possible values (case-insensitive)
     are: 'Microsoft.NetApp, Microsoft.KeyVault'. Known values are: "Microsoft.NetApp",
     "Microsoft.KeyVault". Default value: "Microsoft.NetApp".
    :vartype encryption_key_source: str or ~azure.mgmt.netapp.models.EncryptionKeySource
    :ivar key_vault_private_endpoint_resource_id: The resource ID of private endpoint for KeyVault.
     It must reside in the same VNET as the volume. Only applicable if encryptionKeySource =
     'Microsoft.KeyVault'.
    :vartype key_vault_private_endpoint_resource_id: str
    :ivar ldap_enabled: Specifies whether LDAP is enabled or not for a given NFS volume.
    :vartype ldap_enabled: bool
    :ivar cool_access: Specifies whether Cool Access(tiering) is enabled for the volume.
    :vartype cool_access: bool
    :ivar coolness_period: Specifies the number of days after which data that is not accessed by
     clients will be tiered.
    :vartype coolness_period: int
    :ivar unix_permissions: UNIX permissions for NFS volume accepted in octal 4 digit format. First
     digit selects the set user ID(4), set group ID (2) and sticky (1) attributes. Second digit
     selects permission for the owner of the file: read (4), write (2) and execute (1). Third
     selects permissions for other users in the same group. the fourth for other users not in the
     group. 0755 - gives read/write/execute permissions to owner and read/execute to group and other
     users.
    :vartype unix_permissions: str
    :ivar clone_progress: When a volume is being restored from another volume's snapshot, will show
     the percentage completion of this cloning process. When this value is empty/null there is no
     cloning process currently happening on this volume. This value will update every 5 minutes
     during cloning.
    :vartype clone_progress: int
    :ivar avs_data_store: Specifies whether the volume is enabled for Azure VMware Solution (AVS)
     datastore purpose. Known values are: "Enabled", "Disabled". Default value: "Disabled".
    :vartype avs_data_store: str or ~azure.mgmt.netapp.models.AvsDataStore
    :ivar is_default_quota_enabled: Specifies if default quota is enabled for the volume.
    :vartype is_default_quota_enabled: bool
    :ivar default_user_quota_in_ki_bs: Default user quota for volume in KiBs. If
     isDefaultQuotaEnabled is set, the minimum value of 4 KiBs applies .
    :vartype default_user_quota_in_ki_bs: long
    :ivar default_group_quota_in_ki_bs: Default group quota for volume in KiBs. If
     isDefaultQuotaEnabled is set, the minimum value of 4 KiBs applies.
    :vartype default_group_quota_in_ki_bs: long
    :ivar maximum_number_of_files: Maximum number of files allowed. Needs a service request in
     order to be changed. Only allowed to be changed if volume quota is more than 4TiB.
    :vartype maximum_number_of_files: long
    :ivar volume_group_name: Volume Group Name.
    :vartype volume_group_name: str
    :ivar capacity_pool_resource_id: Pool Resource Id used in case of creating a volume through
     volume group.
    :vartype capacity_pool_resource_id: str
    :ivar proximity_placement_group: Proximity placement group associated with the volume.
    :vartype proximity_placement_group: str
    :ivar t2_network: T2 network information.
    :vartype t2_network: str
    :ivar volume_spec_name: Volume spec name is the application specific designation or identifier
     for the particular volume in a volume group for e.g. data, log.
    :vartype volume_spec_name: str
    :ivar encrypted: Specifies if the volume is encrypted or not. Only available on volumes created
     or updated after 2022-01-01.
    :vartype encrypted: bool
    :ivar placement_rules: Application specific placement rules for the particular volume.
    :vartype placement_rules: list[~azure.mgmt.netapp.models.PlacementKeyValuePairs]
    :ivar enable_subvolumes: Flag indicating whether subvolume operations are enabled on the
     volume. Known values are: "Enabled", "Disabled". Default value: "Disabled".
    :vartype enable_subvolumes: str or ~azure.mgmt.netapp.models.EnableSubvolumes
    """

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
        'file_system_id': {'readonly': True, 'max_length': 36, 'min_length': 36, 'pattern': r'^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$'},
        'creation_token': {'required': True, 'max_length': 80, 'min_length': 1, 'pattern': r'^[a-zA-Z][a-zA-Z0-9\-]{0,79}$'},
        'usage_threshold': {'required': True, 'maximum': 109951162777600, 'minimum': 107374182400},
        'provisioning_state': {'readonly': True},
        'snapshot_id': {'max_length': 36, 'min_length': 36, 'pattern': r'^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}|(\\?([^\/]*[\/])*)([^\/]+)$'},
        'backup_id': {'max_length': 36, 'min_length': 36, 'pattern': r'^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}|(\\?([^\/]*[\/])*)([^\/]+)$'},
        'baremetal_tenant_id': {'readonly': True},
        'subnet_id': {'required': True},
        'network_sibling_set_id': {'readonly': True, 'max_length': 36, 'min_length': 36, 'pattern': r'^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$'},
        'storage_to_network_proximity': {'readonly': True},
        'mount_targets': {'readonly': True},
        'coolness_period': {'maximum': 63, 'minimum': 7},
        'unix_permissions': {'max_length': 4, 'min_length': 4},
        'clone_progress': {'readonly': True},
        'maximum_number_of_files': {'readonly': True},
        'volume_group_name': {'readonly': True},
        't2_network': {'readonly': True},
        'encrypted': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'file_system_id': {'key': 'properties.fileSystemId', 'type': 'str'},
        'creation_token': {'key': 'properties.creationToken', 'type': 'str'},
        'service_level': {'key': 'properties.serviceLevel', 'type': 'str'},
        'usage_threshold': {'key': 'properties.usageThreshold', 'type': 'long'},
        'export_policy': {'key': 'properties.exportPolicy', 'type': 'VolumePropertiesExportPolicy'},
        'protocol_types': {'key': 'properties.protocolTypes', 'type': '[str]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'snapshot_id': {'key': 'properties.snapshotId', 'type': 'str'},
        'backup_id': {'key': 'properties.backupId', 'type': 'str'},
        'baremetal_tenant_id': {'key': 'properties.baremetalTenantId', 'type': 'str'},
        'subnet_id': {'key': 'properties.subnetId', 'type': 'str'},
        'network_features': {'key': 'properties.networkFeatures', 'type': 'str'},
        'network_sibling_set_id': {'key': 'properties.networkSiblingSetId', 'type': 'str'},
        'storage_to_network_proximity': {'key': 'properties.storageToNetworkProximity', 'type': 'str'},
        'mount_targets': {'key': 'properties.mountTargets', 'type': '[MountTargetProperties]'},
        'volume_type': {'key': 'properties.volumeType', 'type': 'str'},
        'data_protection': {'key': 'properties.dataProtection', 'type': 'VolumePropertiesDataProtection'},
        'is_restoring': {'key': 'properties.isRestoring', 'type': 'bool'},
        'snapshot_directory_visible': {'key': 'properties.snapshotDirectoryVisible', 'type': 'bool'},
        'kerberos_enabled': {'key': 'properties.kerberosEnabled', 'type': 'bool'},
        'security_style': {'key': 'properties.securityStyle', 'type': 'str'},
        'smb_encryption': {'key': 'properties.smbEncryption', 'type': 'bool'},
        'smb_continuously_available': {'key': 'properties.smbContinuouslyAvailable', 'type': 'bool'},
        'throughput_mibps': {'key': 'properties.throughputMibps', 'type': 'float'},
        'encryption_key_source': {'key': 'properties.encryptionKeySource', 'type': 'str'},
        'key_vault_private_endpoint_resource_id': {'key': 'properties.keyVaultPrivateEndpointResourceId', 'type': 'str'},
        'ldap_enabled': {'key': 'properties.ldapEnabled', 'type': 'bool'},
        'cool_access': {'key': 'properties.coolAccess', 'type': 'bool'},
        'coolness_period': {'key': 'properties.coolnessPeriod', 'type': 'int'},
        'unix_permissions': {'key': 'properties.unixPermissions', 'type': 'str'},
        'clone_progress': {'key': 'properties.cloneProgress', 'type': 'int'},
        'avs_data_store': {'key': 'properties.avsDataStore', 'type': 'str'},
        'is_default_quota_enabled': {'key': 'properties.isDefaultQuotaEnabled', 'type': 'bool'},
        'default_user_quota_in_ki_bs': {'key': 'properties.defaultUserQuotaInKiBs', 'type': 'long'},
        'default_group_quota_in_ki_bs': {'key': 'properties.defaultGroupQuotaInKiBs', 'type': 'long'},
        'maximum_number_of_files': {'key': 'properties.maximumNumberOfFiles', 'type': 'long'},
        'volume_group_name': {'key': 'properties.volumeGroupName', 'type': 'str'},
        'capacity_pool_resource_id': {'key': 'properties.capacityPoolResourceId', 'type': 'str'},
        'proximity_placement_group': {'key': 'properties.proximityPlacementGroup', 'type': 'str'},
        't2_network': {'key': 'properties.t2Network', 'type': 'str'},
        'volume_spec_name': {'key': 'properties.volumeSpecName', 'type': 'str'},
        'encrypted': {'key': 'properties.encrypted', 'type': 'bool'},
        'placement_rules': {'key': 'properties.placementRules', 'type': '[PlacementKeyValuePairs]'},
        'enable_subvolumes': {'key': 'properties.enableSubvolumes', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        creation_token: str,
        usage_threshold: int = 107374182400,
        subnet_id: str,
        name: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        service_level: Optional[Union[str, "_models.ServiceLevel"]] = "Premium",
        export_policy: Optional["_models.VolumePropertiesExportPolicy"] = None,
        protocol_types: Optional[List[str]] = None,
        snapshot_id: Optional[str] = None,
        backup_id: Optional[str] = None,
        network_features: Optional[Union[str, "_models.NetworkFeatures"]] = "Basic",
        volume_type: Optional[str] = None,
        data_protection: Optional["_models.VolumePropertiesDataProtection"] = None,
        is_restoring: Optional[bool] = None,
        snapshot_directory_visible: Optional[bool] = True,
        kerberos_enabled: Optional[bool] = False,
        security_style: Optional[Union[str, "_models.SecurityStyle"]] = "unix",
        smb_encryption: Optional[bool] = False,
        smb_continuously_available: Optional[bool] = False,
        throughput_mibps: Optional[float] = None,
        encryption_key_source: Optional[Union[str, "_models.EncryptionKeySource"]] = "Microsoft.NetApp",
        key_vault_private_endpoint_resource_id: Optional[str] = None,
        ldap_enabled: Optional[bool] = False,
        cool_access: Optional[bool] = False,
        coolness_period: Optional[int] = None,
        unix_permissions: Optional[str] = "0770",
        avs_data_store: Optional[Union[str, "_models.AvsDataStore"]] = "Disabled",
        is_default_quota_enabled: Optional[bool] = False,
        default_user_quota_in_ki_bs: Optional[int] = 0,
        default_group_quota_in_ki_bs: Optional[int] = 0,
        capacity_pool_resource_id: Optional[str] = None,
        proximity_placement_group: Optional[str] = None,
        volume_spec_name: Optional[str] = None,
        placement_rules: Optional[List["_models.PlacementKeyValuePairs"]] = None,
        enable_subvolumes: Optional[Union[str, "_models.EnableSubvolumes"]] = "Disabled",
        **kwargs
    ):
        """
        :keyword name: Resource name.
        :paramtype name: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword creation_token: Required. A unique file path for the volume. Used when creating mount
         targets.
        :paramtype creation_token: str
        :keyword service_level: The service level of the file system. Known values are: "Standard",
         "Premium", "Ultra", "StandardZRS". Default value: "Premium".
        :paramtype service_level: str or ~azure.mgmt.netapp.models.ServiceLevel
        :keyword usage_threshold: Required. Maximum storage quota allowed for a file system in bytes.
         This is a soft quota used for alerting only. Minimum size is 100 GiB. Upper limit is 100TiB.
         Specified in bytes.
        :paramtype usage_threshold: long
        :keyword export_policy: Set of export policy rules.
        :paramtype export_policy: ~azure.mgmt.netapp.models.VolumePropertiesExportPolicy
        :keyword protocol_types: Set of protocol types, default NFSv3, CIFS for SMB protocol.
        :paramtype protocol_types: list[str]
        :keyword snapshot_id: UUID v4 or resource identifier used to identify the Snapshot.
        :paramtype snapshot_id: str
        :keyword backup_id: UUID v4 or resource identifier used to identify the Backup.
        :paramtype backup_id: str
        :keyword subnet_id: Required. The Azure Resource URI for a delegated subnet. Must have the
         delegation Microsoft.NetApp/volumes.
        :paramtype subnet_id: str
        :keyword network_features: Basic network, or Standard features available to the volume. Known
         values are: "Basic", "Standard". Default value: "Basic".
        :paramtype network_features: str or ~azure.mgmt.netapp.models.NetworkFeatures
        :keyword volume_type: What type of volume is this. For destination volumes in Cross Region
         Replication, set type to DataProtection.
        :paramtype volume_type: str
        :keyword data_protection: DataProtection type volumes include an object containing details of
         the replication.
        :paramtype data_protection: ~azure.mgmt.netapp.models.VolumePropertiesDataProtection
        :keyword is_restoring: Restoring.
        :paramtype is_restoring: bool
        :keyword snapshot_directory_visible: If enabled (true) the volume will contain a read-only
         snapshot directory which provides access to each of the volume's snapshots (default to true).
        :paramtype snapshot_directory_visible: bool
        :keyword kerberos_enabled: Describe if a volume is KerberosEnabled. To be use with swagger
         version 2020-05-01 or later.
        :paramtype kerberos_enabled: bool
        :keyword security_style: The security style of volume, default unix, defaults to ntfs for dual
         protocol or CIFS protocol. Known values are: "ntfs", "unix". Default value: "unix".
        :paramtype security_style: str or ~azure.mgmt.netapp.models.SecurityStyle
        :keyword smb_encryption: Enables encryption for in-flight smb3 data. Only applicable for
         SMB/DualProtocol volume. To be used with swagger version 2020-08-01 or later.
        :paramtype smb_encryption: bool
        :keyword smb_continuously_available: Enables continuously available share property for smb
         volume. Only applicable for SMB volume.
        :paramtype smb_continuously_available: bool
        :keyword throughput_mibps: Maximum throughput in MiB/s that can be achieved by this volume and
         this will be accepted as input only for manual qosType volume.
        :paramtype throughput_mibps: float
        :keyword encryption_key_source: Source of key used to encrypt data in volume. Applicable if
         NetApp account has encryption.keySource = 'Microsoft.KeyVault'. Possible values
         (case-insensitive) are: 'Microsoft.NetApp, Microsoft.KeyVault'. Known values are:
         "Microsoft.NetApp", "Microsoft.KeyVault". Default value: "Microsoft.NetApp".
        :paramtype encryption_key_source: str or ~azure.mgmt.netapp.models.EncryptionKeySource
        :keyword key_vault_private_endpoint_resource_id: The resource ID of private endpoint for
         KeyVault. It must reside in the same VNET as the volume. Only applicable if encryptionKeySource
         = 'Microsoft.KeyVault'.
        :paramtype key_vault_private_endpoint_resource_id: str
        :keyword ldap_enabled: Specifies whether LDAP is enabled or not for a given NFS volume.
        :paramtype ldap_enabled: bool
        :keyword cool_access: Specifies whether Cool Access(tiering) is enabled for the volume.
        :paramtype cool_access: bool
        :keyword coolness_period: Specifies the number of days after which data that is not accessed by
         clients will be tiered.
        :paramtype coolness_period: int
        :keyword unix_permissions: UNIX permissions for NFS volume accepted in octal 4 digit format.
         First digit selects the set user ID(4), set group ID (2) and sticky (1) attributes. Second
         digit selects permission for the owner of the file: read (4), write (2) and execute (1). Third
         selects permissions for other users in the same group. the fourth for other users not in the
         group. 0755 - gives read/write/execute permissions to owner and read/execute to group and other
         users.
        :paramtype unix_permissions: str
        :keyword avs_data_store: Specifies whether the volume is enabled for Azure VMware Solution
         (AVS) datastore purpose. Known values are: "Enabled", "Disabled". Default value: "Disabled".
        :paramtype avs_data_store: str or ~azure.mgmt.netapp.models.AvsDataStore
        :keyword is_default_quota_enabled: Specifies if default quota is enabled for the volume.
        :paramtype is_default_quota_enabled: bool
        :keyword default_user_quota_in_ki_bs: Default user quota for volume in KiBs. If
         isDefaultQuotaEnabled is set, the minimum value of 4 KiBs applies .
        :paramtype default_user_quota_in_ki_bs: long
        :keyword default_group_quota_in_ki_bs: Default group quota for volume in KiBs. If
         isDefaultQuotaEnabled is set, the minimum value of 4 KiBs applies.
        :paramtype default_group_quota_in_ki_bs: long
        :keyword capacity_pool_resource_id: Pool Resource Id used in case of creating a volume through
         volume group.
        :paramtype capacity_pool_resource_id: str
        :keyword proximity_placement_group: Proximity placement group associated with the volume.
        :paramtype proximity_placement_group: str
        :keyword volume_spec_name: Volume spec name is the application specific designation or
         identifier for the particular volume in a volume group for e.g. data, log.
        :paramtype volume_spec_name: str
        :keyword placement_rules: Application specific placement rules for the particular volume.
        :paramtype placement_rules: list[~azure.mgmt.netapp.models.PlacementKeyValuePairs]
        :keyword enable_subvolumes: Flag indicating whether subvolume operations are enabled on the
         volume. Known values are: "Enabled", "Disabled". Default value: "Disabled".
        :paramtype enable_subvolumes: str or ~azure.mgmt.netapp.models.EnableSubvolumes
        """
        super(VolumeGroupVolumeProperties, self).__init__(**kwargs)
        self.id = None
        self.name = name
        self.type = None
        self.tags = tags
        self.file_system_id = None
        self.creation_token = creation_token
        self.service_level = service_level
        self.usage_threshold = usage_threshold
        self.export_policy = export_policy
        self.protocol_types = protocol_types
        self.provisioning_state = None
        self.snapshot_id = snapshot_id
        self.backup_id = backup_id
        self.baremetal_tenant_id = None
        self.subnet_id = subnet_id
        self.network_features = network_features
        self.network_sibling_set_id = None
        self.storage_to_network_proximity = None
        self.mount_targets = None
        self.volume_type = volume_type
        self.data_protection = data_protection
        self.is_restoring = is_restoring
        self.snapshot_directory_visible = snapshot_directory_visible
        self.kerberos_enabled = kerberos_enabled
        self.security_style = security_style
        self.smb_encryption = smb_encryption
        self.smb_continuously_available = smb_continuously_available
        self.throughput_mibps = throughput_mibps
        self.encryption_key_source = encryption_key_source
        self.key_vault_private_endpoint_resource_id = key_vault_private_endpoint_resource_id
        self.ldap_enabled = ldap_enabled
        self.cool_access = cool_access
        self.coolness_period = coolness_period
        self.unix_permissions = unix_permissions
        self.clone_progress = None
        self.avs_data_store = avs_data_store
        self.is_default_quota_enabled = is_default_quota_enabled
        self.default_user_quota_in_ki_bs = default_user_quota_in_ki_bs
        self.default_group_quota_in_ki_bs = default_group_quota_in_ki_bs
        self.maximum_number_of_files = None
        self.volume_group_name = None
        self.capacity_pool_resource_id = capacity_pool_resource_id
        self.proximity_placement_group = proximity_placement_group
        self.t2_network = None
        self.volume_spec_name = volume_spec_name
        self.encrypted = None
        self.placement_rules = placement_rules
        self.enable_subvolumes = enable_subvolumes


class VolumeList(msrest.serialization.Model):
    """List of volume resources.

    :ivar value: List of volumes.
    :vartype value: list[~azure.mgmt.netapp.models.Volume]
    :ivar next_link: URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Volume]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.Volume"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: List of volumes.
        :paramtype value: list[~azure.mgmt.netapp.models.Volume]
        :keyword next_link: URL to get the next set of results.
        :paramtype next_link: str
        """
        super(VolumeList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VolumePatch(msrest.serialization.Model):
    """Volume patch resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location: Resource location.
    :vartype location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar service_level: The service level of the file system. Known values are: "Standard",
     "Premium", "Ultra", "StandardZRS". Default value: "Premium".
    :vartype service_level: str or ~azure.mgmt.netapp.models.ServiceLevel
    :ivar usage_threshold: Maximum storage quota allowed for a file system in bytes. This is a soft
     quota used for alerting only. Minimum size is 100 GiB. Upper limit is 100TiB. Specified in
     bytes.
    :vartype usage_threshold: long
    :ivar export_policy: Set of export policy rules.
    :vartype export_policy: ~azure.mgmt.netapp.models.VolumePatchPropertiesExportPolicy
    :ivar throughput_mibps: Maximum throughput in Mibps that can be achieved by this volume and
     this will be accepted as input only for manual qosType volume.
    :vartype throughput_mibps: float
    :ivar data_protection: DataProtection type volumes include an object containing details of the
     replication.
    :vartype data_protection: ~azure.mgmt.netapp.models.VolumePatchPropertiesDataProtection
    :ivar is_default_quota_enabled: Specifies if default quota is enabled for the volume.
    :vartype is_default_quota_enabled: bool
    :ivar default_user_quota_in_ki_bs: Default user quota for volume in KiBs. If
     isDefaultQuotaEnabled is set, the minimum value of 4 KiBs applies .
    :vartype default_user_quota_in_ki_bs: long
    :ivar default_group_quota_in_ki_bs: Default group quota for volume in KiBs. If
     isDefaultQuotaEnabled is set, the minimum value of 4 KiBs applies.
    :vartype default_group_quota_in_ki_bs: long
    :ivar unix_permissions: UNIX permissions for NFS volume accepted in octal 4 digit format. First
     digit selects the set user ID(4), set group ID (2) and sticky (1) attributes. Second digit
     selects permission for the owner of the file: read (4), write (2) and execute (1). Third
     selects permissions for other users in the same group. the fourth for other users not in the
     group. 0755 - gives read/write/execute permissions to owner and read/execute to group and other
     users.
    :vartype unix_permissions: str
    :ivar cool_access: Specifies whether Cool Access(tiering) is enabled for the volume.
    :vartype cool_access: bool
    :ivar coolness_period: Specifies the number of days after which data that is not accessed by
     clients will be tiered.
    :vartype coolness_period: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'usage_threshold': {'maximum': 109951162777600, 'minimum': 107374182400},
        'unix_permissions': {'max_length': 4, 'min_length': 4},
        'coolness_period': {'maximum': 63, 'minimum': 7},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'service_level': {'key': 'properties.serviceLevel', 'type': 'str'},
        'usage_threshold': {'key': 'properties.usageThreshold', 'type': 'long'},
        'export_policy': {'key': 'properties.exportPolicy', 'type': 'VolumePatchPropertiesExportPolicy'},
        'throughput_mibps': {'key': 'properties.throughputMibps', 'type': 'float'},
        'data_protection': {'key': 'properties.dataProtection', 'type': 'VolumePatchPropertiesDataProtection'},
        'is_default_quota_enabled': {'key': 'properties.isDefaultQuotaEnabled', 'type': 'bool'},
        'default_user_quota_in_ki_bs': {'key': 'properties.defaultUserQuotaInKiBs', 'type': 'long'},
        'default_group_quota_in_ki_bs': {'key': 'properties.defaultGroupQuotaInKiBs', 'type': 'long'},
        'unix_permissions': {'key': 'properties.unixPermissions', 'type': 'str'},
        'cool_access': {'key': 'properties.coolAccess', 'type': 'bool'},
        'coolness_period': {'key': 'properties.coolnessPeriod', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        service_level: Optional[Union[str, "_models.ServiceLevel"]] = "Premium",
        usage_threshold: Optional[int] = 107374182400,
        export_policy: Optional["_models.VolumePatchPropertiesExportPolicy"] = None,
        throughput_mibps: Optional[float] = None,
        data_protection: Optional["_models.VolumePatchPropertiesDataProtection"] = None,
        is_default_quota_enabled: Optional[bool] = False,
        default_user_quota_in_ki_bs: Optional[int] = 0,
        default_group_quota_in_ki_bs: Optional[int] = 0,
        unix_permissions: Optional[str] = None,
        cool_access: Optional[bool] = None,
        coolness_period: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword service_level: The service level of the file system. Known values are: "Standard",
         "Premium", "Ultra", "StandardZRS". Default value: "Premium".
        :paramtype service_level: str or ~azure.mgmt.netapp.models.ServiceLevel
        :keyword usage_threshold: Maximum storage quota allowed for a file system in bytes. This is a
         soft quota used for alerting only. Minimum size is 100 GiB. Upper limit is 100TiB. Specified in
         bytes.
        :paramtype usage_threshold: long
        :keyword export_policy: Set of export policy rules.
        :paramtype export_policy: ~azure.mgmt.netapp.models.VolumePatchPropertiesExportPolicy
        :keyword throughput_mibps: Maximum throughput in Mibps that can be achieved by this volume and
         this will be accepted as input only for manual qosType volume.
        :paramtype throughput_mibps: float
        :keyword data_protection: DataProtection type volumes include an object containing details of
         the replication.
        :paramtype data_protection: ~azure.mgmt.netapp.models.VolumePatchPropertiesDataProtection
        :keyword is_default_quota_enabled: Specifies if default quota is enabled for the volume.
        :paramtype is_default_quota_enabled: bool
        :keyword default_user_quota_in_ki_bs: Default user quota for volume in KiBs. If
         isDefaultQuotaEnabled is set, the minimum value of 4 KiBs applies .
        :paramtype default_user_quota_in_ki_bs: long
        :keyword default_group_quota_in_ki_bs: Default group quota for volume in KiBs. If
         isDefaultQuotaEnabled is set, the minimum value of 4 KiBs applies.
        :paramtype default_group_quota_in_ki_bs: long
        :keyword unix_permissions: UNIX permissions for NFS volume accepted in octal 4 digit format.
         First digit selects the set user ID(4), set group ID (2) and sticky (1) attributes. Second
         digit selects permission for the owner of the file: read (4), write (2) and execute (1). Third
         selects permissions for other users in the same group. the fourth for other users not in the
         group. 0755 - gives read/write/execute permissions to owner and read/execute to group and other
         users.
        :paramtype unix_permissions: str
        :keyword cool_access: Specifies whether Cool Access(tiering) is enabled for the volume.
        :paramtype cool_access: bool
        :keyword coolness_period: Specifies the number of days after which data that is not accessed by
         clients will be tiered.
        :paramtype coolness_period: int
        """
        super(VolumePatch, self).__init__(**kwargs)
        self.location = location
        self.id = None
        self.name = None
        self.type = None
        self.tags = tags
        self.service_level = service_level
        self.usage_threshold = usage_threshold
        self.export_policy = export_policy
        self.throughput_mibps = throughput_mibps
        self.data_protection = data_protection
        self.is_default_quota_enabled = is_default_quota_enabled
        self.default_user_quota_in_ki_bs = default_user_quota_in_ki_bs
        self.default_group_quota_in_ki_bs = default_group_quota_in_ki_bs
        self.unix_permissions = unix_permissions
        self.cool_access = cool_access
        self.coolness_period = coolness_period


class VolumePatchPropertiesDataProtection(msrest.serialization.Model):
    """DataProtection type volumes include an object containing details of the replication.

    :ivar backup: Backup Properties.
    :vartype backup: ~azure.mgmt.netapp.models.VolumeBackupProperties
    :ivar snapshot: Snapshot properties.
    :vartype snapshot: ~azure.mgmt.netapp.models.VolumeSnapshotProperties
    """

    _attribute_map = {
        'backup': {'key': 'backup', 'type': 'VolumeBackupProperties'},
        'snapshot': {'key': 'snapshot', 'type': 'VolumeSnapshotProperties'},
    }

    def __init__(
        self,
        *,
        backup: Optional["_models.VolumeBackupProperties"] = None,
        snapshot: Optional["_models.VolumeSnapshotProperties"] = None,
        **kwargs
    ):
        """
        :keyword backup: Backup Properties.
        :paramtype backup: ~azure.mgmt.netapp.models.VolumeBackupProperties
        :keyword snapshot: Snapshot properties.
        :paramtype snapshot: ~azure.mgmt.netapp.models.VolumeSnapshotProperties
        """
        super(VolumePatchPropertiesDataProtection, self).__init__(**kwargs)
        self.backup = backup
        self.snapshot = snapshot


class VolumePatchPropertiesExportPolicy(msrest.serialization.Model):
    """Set of export policy rules.

    :ivar rules: Export policy rule.
    :vartype rules: list[~azure.mgmt.netapp.models.ExportPolicyRule]
    """

    _attribute_map = {
        'rules': {'key': 'rules', 'type': '[ExportPolicyRule]'},
    }

    def __init__(
        self,
        *,
        rules: Optional[List["_models.ExportPolicyRule"]] = None,
        **kwargs
    ):
        """
        :keyword rules: Export policy rule.
        :paramtype rules: list[~azure.mgmt.netapp.models.ExportPolicyRule]
        """
        super(VolumePatchPropertiesExportPolicy, self).__init__(**kwargs)
        self.rules = rules


class VolumePropertiesDataProtection(msrest.serialization.Model):
    """DataProtection type volumes include an object containing details of the replication.

    :ivar backup: Backup Properties.
    :vartype backup: ~azure.mgmt.netapp.models.VolumeBackupProperties
    :ivar replication: Replication properties.
    :vartype replication: ~azure.mgmt.netapp.models.ReplicationObject
    :ivar snapshot: Snapshot properties.
    :vartype snapshot: ~azure.mgmt.netapp.models.VolumeSnapshotProperties
    """

    _attribute_map = {
        'backup': {'key': 'backup', 'type': 'VolumeBackupProperties'},
        'replication': {'key': 'replication', 'type': 'ReplicationObject'},
        'snapshot': {'key': 'snapshot', 'type': 'VolumeSnapshotProperties'},
    }

    def __init__(
        self,
        *,
        backup: Optional["_models.VolumeBackupProperties"] = None,
        replication: Optional["_models.ReplicationObject"] = None,
        snapshot: Optional["_models.VolumeSnapshotProperties"] = None,
        **kwargs
    ):
        """
        :keyword backup: Backup Properties.
        :paramtype backup: ~azure.mgmt.netapp.models.VolumeBackupProperties
        :keyword replication: Replication properties.
        :paramtype replication: ~azure.mgmt.netapp.models.ReplicationObject
        :keyword snapshot: Snapshot properties.
        :paramtype snapshot: ~azure.mgmt.netapp.models.VolumeSnapshotProperties
        """
        super(VolumePropertiesDataProtection, self).__init__(**kwargs)
        self.backup = backup
        self.replication = replication
        self.snapshot = snapshot


class VolumePropertiesExportPolicy(msrest.serialization.Model):
    """Set of export policy rules.

    :ivar rules: Export policy rule.
    :vartype rules: list[~azure.mgmt.netapp.models.ExportPolicyRule]
    """

    _attribute_map = {
        'rules': {'key': 'rules', 'type': '[ExportPolicyRule]'},
    }

    def __init__(
        self,
        *,
        rules: Optional[List["_models.ExportPolicyRule"]] = None,
        **kwargs
    ):
        """
        :keyword rules: Export policy rule.
        :paramtype rules: list[~azure.mgmt.netapp.models.ExportPolicyRule]
        """
        super(VolumePropertiesExportPolicy, self).__init__(**kwargs)
        self.rules = rules


class VolumeQuotaRule(TrackedResource):
    """Quota Rule of a Volume.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.netapp.models.SystemData
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    :ivar provisioning_state: Gets the status of the VolumeQuotaRule at the time the operation was
     called. Known values are: "Accepted", "Creating", "Patching", "Deleting", "Moving", "Failed",
     "Succeeded".
    :vartype provisioning_state: str or ~azure.mgmt.netapp.models.ProvisioningState
    :ivar quota_size_in_ki_bs: Size of quota.
    :vartype quota_size_in_ki_bs: long
    :ivar quota_type: Type of quota. Known values are: "DefaultUserQuota", "DefaultGroupQuota",
     "IndividualUserQuota", "IndividualGroupQuota".
    :vartype quota_type: str or ~azure.mgmt.netapp.models.Type
    :ivar quota_target: UserID/GroupID/SID based on the quota target type. UserID and groupID can
     be found by running ‘id’ or ‘getent’ command for the user or group and SID can be found by
     running :code:`<wmic useraccount where name='user-name' get sid>`.
    :vartype quota_target: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'quota_size_in_ki_bs': {'key': 'properties.quotaSizeInKiBs', 'type': 'long'},
        'quota_type': {'key': 'properties.quotaType', 'type': 'str'},
        'quota_target': {'key': 'properties.quotaTarget', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        quota_size_in_ki_bs: Optional[int] = None,
        quota_type: Optional[Union[str, "_models.Type"]] = None,
        quota_target: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        :keyword quota_size_in_ki_bs: Size of quota.
        :paramtype quota_size_in_ki_bs: long
        :keyword quota_type: Type of quota. Known values are: "DefaultUserQuota", "DefaultGroupQuota",
         "IndividualUserQuota", "IndividualGroupQuota".
        :paramtype quota_type: str or ~azure.mgmt.netapp.models.Type
        :keyword quota_target: UserID/GroupID/SID based on the quota target type. UserID and groupID
         can be found by running ‘id’ or ‘getent’ command for the user or group and SID can be found by
         running :code:`<wmic useraccount where name='user-name' get sid>`.
        :paramtype quota_target: str
        """
        super(VolumeQuotaRule, self).__init__(tags=tags, location=location, **kwargs)
        self.provisioning_state = None
        self.quota_size_in_ki_bs = quota_size_in_ki_bs
        self.quota_type = quota_type
        self.quota_target = quota_target


class VolumeQuotaRulePatch(msrest.serialization.Model):
    """Patchable Quota Rule of a Volume.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Gets the status of the VolumeQuotaRule at the time the operation was
     called. Known values are: "Accepted", "Creating", "Patching", "Deleting", "Moving", "Failed",
     "Succeeded".
    :vartype provisioning_state: str or ~azure.mgmt.netapp.models.ProvisioningState
    :ivar quota_size_in_ki_bs: Size of quota.
    :vartype quota_size_in_ki_bs: long
    :ivar quota_type: Type of quota. Known values are: "DefaultUserQuota", "DefaultGroupQuota",
     "IndividualUserQuota", "IndividualGroupQuota".
    :vartype quota_type: str or ~azure.mgmt.netapp.models.Type
    :ivar quota_target: UserID/GroupID/SID based on the quota target type. UserID and groupID can
     be found by running ‘id’ or ‘getent’ command for the user or group and SID can be found by
     running :code:`<wmic useraccount where name='user-name' get sid>`.
    :vartype quota_target: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'quota_size_in_ki_bs': {'key': 'properties.quotaSizeInKiBs', 'type': 'long'},
        'quota_type': {'key': 'properties.quotaType', 'type': 'str'},
        'quota_target': {'key': 'properties.quotaTarget', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        quota_size_in_ki_bs: Optional[int] = None,
        quota_type: Optional[Union[str, "_models.Type"]] = None,
        quota_target: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword quota_size_in_ki_bs: Size of quota.
        :paramtype quota_size_in_ki_bs: long
        :keyword quota_type: Type of quota. Known values are: "DefaultUserQuota", "DefaultGroupQuota",
         "IndividualUserQuota", "IndividualGroupQuota".
        :paramtype quota_type: str or ~azure.mgmt.netapp.models.Type
        :keyword quota_target: UserID/GroupID/SID based on the quota target type. UserID and groupID
         can be found by running ‘id’ or ‘getent’ command for the user or group and SID can be found by
         running :code:`<wmic useraccount where name='user-name' get sid>`.
        :paramtype quota_target: str
        """
        super(VolumeQuotaRulePatch, self).__init__(**kwargs)
        self.provisioning_state = None
        self.quota_size_in_ki_bs = quota_size_in_ki_bs
        self.quota_type = quota_type
        self.quota_target = quota_target


class VolumeQuotaRulesList(msrest.serialization.Model):
    """List of Volume Quota Rules.

    :ivar value: A list of Volume Quota Rules.
    :vartype value: list[~azure.mgmt.netapp.models.VolumeQuotaRule]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VolumeQuotaRule]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.VolumeQuotaRule"]] = None,
        **kwargs
    ):
        """
        :keyword value: A list of Volume Quota Rules.
        :paramtype value: list[~azure.mgmt.netapp.models.VolumeQuotaRule]
        """
        super(VolumeQuotaRulesList, self).__init__(**kwargs)
        self.value = value


class VolumeRelocationProperties(msrest.serialization.Model):
    """Volume relocation properties.

    :ivar old_volume_id: The id of the old volume that is being relocated.
    :vartype old_volume_id: str
    :ivar old_bare_metal_tenant_id: The id of the bare metal tenant owned by the existing volume.
    :vartype old_bare_metal_tenant_id: str
    :ivar relocation_requested: Has relocation been requested for this volume.
    :vartype relocation_requested: bool
    """

    _attribute_map = {
        'old_volume_id': {'key': 'oldVolumeId', 'type': 'str'},
        'old_bare_metal_tenant_id': {'key': 'oldBareMetalTenantId', 'type': 'str'},
        'relocation_requested': {'key': 'relocationRequested', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        old_volume_id: Optional[str] = None,
        old_bare_metal_tenant_id: Optional[str] = None,
        relocation_requested: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword old_volume_id: The id of the old volume that is being relocated.
        :paramtype old_volume_id: str
        :keyword old_bare_metal_tenant_id: The id of the bare metal tenant owned by the existing
         volume.
        :paramtype old_bare_metal_tenant_id: str
        :keyword relocation_requested: Has relocation been requested for this volume.
        :paramtype relocation_requested: bool
        """
        super(VolumeRelocationProperties, self).__init__(**kwargs)
        self.old_volume_id = old_volume_id
        self.old_bare_metal_tenant_id = old_bare_metal_tenant_id
        self.relocation_requested = relocation_requested


class VolumeRevert(msrest.serialization.Model):
    """revert a volume to the snapshot.

    :ivar snapshot_id: Resource id of the snapshot.
    :vartype snapshot_id: str
    """

    _attribute_map = {
        'snapshot_id': {'key': 'snapshotId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        snapshot_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword snapshot_id: Resource id of the snapshot.
        :paramtype snapshot_id: str
        """
        super(VolumeRevert, self).__init__(**kwargs)
        self.snapshot_id = snapshot_id


class VolumeSnapshotProperties(msrest.serialization.Model):
    """Volume Snapshot Properties.

    :ivar snapshot_policy_id: Snapshot Policy ResourceId.
    :vartype snapshot_policy_id: str
    """

    _attribute_map = {
        'snapshot_policy_id': {'key': 'snapshotPolicyId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        snapshot_policy_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword snapshot_policy_id: Snapshot Policy ResourceId.
        :paramtype snapshot_policy_id: str
        """
        super(VolumeSnapshotProperties, self).__init__(**kwargs)
        self.snapshot_policy_id = snapshot_policy_id


class WeeklySchedule(msrest.serialization.Model):
    """Weekly Schedule properties, make a snapshot every week at a specific day or days.

    :ivar snapshots_to_keep: Weekly snapshot count to keep.
    :vartype snapshots_to_keep: int
    :ivar day: Indicates which weekdays snapshot should be taken, accepts a comma separated list of
     week day names in english.
    :vartype day: str
    :ivar hour: Indicates which hour in UTC timezone a snapshot should be taken.
    :vartype hour: int
    :ivar minute: Indicates which minute snapshot should be taken.
    :vartype minute: int
    :ivar used_bytes: Resource size in bytes, current storage usage for the volume in bytes.
    :vartype used_bytes: long
    """

    _attribute_map = {
        'snapshots_to_keep': {'key': 'snapshotsToKeep', 'type': 'int'},
        'day': {'key': 'day', 'type': 'str'},
        'hour': {'key': 'hour', 'type': 'int'},
        'minute': {'key': 'minute', 'type': 'int'},
        'used_bytes': {'key': 'usedBytes', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        snapshots_to_keep: Optional[int] = None,
        day: Optional[str] = None,
        hour: Optional[int] = None,
        minute: Optional[int] = None,
        used_bytes: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword snapshots_to_keep: Weekly snapshot count to keep.
        :paramtype snapshots_to_keep: int
        :keyword day: Indicates which weekdays snapshot should be taken, accepts a comma separated list
         of week day names in english.
        :paramtype day: str
        :keyword hour: Indicates which hour in UTC timezone a snapshot should be taken.
        :paramtype hour: int
        :keyword minute: Indicates which minute snapshot should be taken.
        :paramtype minute: int
        :keyword used_bytes: Resource size in bytes, current storage usage for the volume in bytes.
        :paramtype used_bytes: long
        """
        super(WeeklySchedule, self).__init__(**kwargs)
        self.snapshots_to_keep = snapshots_to_keep
        self.day = day
        self.hour = hour
        self.minute = minute
        self.used_bytes = used_bytes
