# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['discord_markdown_ast_parser']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'discord-markdown-ast-parser',
    'version': '1.0.5',
    'description': 'Markdown Parser for Discord messages that creates an abstract syntax tree',
    'long_description': '# Discord Markdown AST Parser\n#### Markdown Parser for Discord messages that creates an abstract syntax tree\n\nThis package provides a parser that can be used to translate a Discord message into an abstract syntax tree (AST) that represents how the message should be rendered according to Discord\'s markdown rules.\n\n### Example\nCheck the following example on how this parser will translate a Discord message:\n\n![image](https://user-images.githubusercontent.com/1405498/131235730-94ba8100-2b42-492f-9479-bbce80c592f0.png)\n\n```python\n(\n    {\'node_type\': \'ITALIC\',\n     \'children\': (\n      {\'node_type\': \'TEXT\', \'text_content\': \'italic star single\'},\n    )},\n    \n    {\'node_type\': \'TEXT\', \'text_content\': \'\\n\'},\n    \n    {\'node_type\': \'ITALIC\',\n     \'children\': (\n        {\'node_type\': \'TEXT\', \'text_content\': \'italic underscore single\'},\n    )},\n    \n    {\'node_type\': \'TEXT\', \'text_content\': \'\\n\'},\n    \n    {\'node_type\': \'BOLD\',\n     \'children\': (\n        {\'node_type\': \'TEXT\', \'text_content\': \'bold single\'},\n    )},\n    \n    {\'node_type\': \'TEXT\', \'text_content\': \'\\n\'},\n    \n    {\'node_type\': \'UNDERLINE\',\n     \'children\': (\n        {\'node_type\': \'TEXT\', \'text_content\': \'underline single\'},\n    )},\n    \n    {\'node_type\': \'TEXT\', \'text_content\': \'\\n\'},\n    \n    {\'node_type\': \'STRIKETHROUGH\',\n     \'children\': (\n        {\'node_type\': \'TEXT\', \'text_content\': \'strikethrough single\'},\n    )},\n    \n    {\'node_type\': \'TEXT\', \'text_content\': \'\\n\\n\'},\n    \n    {\'node_type\': \'QUOTE_BLOCK\',\n     \'children\': (\n        {\'node_type\': \'TEXT\', \'text_content\': \'quote\\nblock\\n\'},\n    )},\n    \n    {\'node_type\': \'TEXT\', \'text_content\': \'\\n\'},\n    \n    {\'node_type\': \'CODE_INLINE\',\n     \'children\': (\n        {\'node_type\': \'TEXT\', \'text_content\': \'inline code\'},\n    )},\n    \n    {\'node_type\': \'TEXT\', \'text_content\': \'\\n\\n\'},\n    \n    {\'node_type\': \'QUOTE_BLOCK\',\n     \'children\': (\n        {\'node_type\': \'CODE_BLOCK\',\n         \'code_lang\': \'python\',\n         \'children\': (\n            {\'node_type\': \'TEXT\', \n             \'text_content\': \'code\\nblock\\nwith\\npython\\nhighlighting\\n\'},),\n        },\n    )},\n)\n```\n\n### Installation\nYou can install this package from PyPI:\n```\npip install discord-markdown-ast-parser\n```\n\n### Usage\nPass the message\'s content to `parse_to_dict` to get the AST represented as a `dict`.\nAlternatively, use `parse` to get the AST using this package\'s internal `Node` type instead of a string-based `dict`:\n```python\n# string-based dict\nast_dict = parse_to_dict(message_content)\n# tuple of Node objects\nast_tuple_of_nodes = parse(message_content)\n```\n\n### Node Types\nThese are the types of nodes the parser will output:\n```\nTEXT\n- fields: "text_content"\n- Just standard text, no additional formatting\n- No child nodes\n\nITALIC, BOLD, UNDERLINE, STRIKETHROUGH, SPOILER, CODE_INLINE\n- fields: "children"\n- self-explanatory\n\nQUOTE_BLOCK\n- fields: "children"\n- represents a single, uninterrupted code block (no gaps in Discord\'s client)\n- can not contain another quote block (Discord has no nested quotes)\n\nCODE_BLOCK\n- fields: "children", "code_lang"\n- can only contain a single TEXT node, all other markdown syntax inside the code block\n  is ignored\n- may or may not have a language specifier\n- first newline is stripped according to the same rules that the Discord client uses\n\nUSER, ROLE, CHANNEL\n- fields: "discord_id"\n- user, role, or channel mention\n- there is no way to retrieve the user/role/channel name, color or channel type\n  (text/voice/stage) from just the message, so you\'ll have to use the API\n  (or discord.py) to query that\n\nURL_WITH_PREVIEW, URL_WITHOUT_PREVIEW\n- fields: "url"\n- a HTTP URL\n- this is only recognized if the link actually contains "http". this is the same for the\n  Discord client, with the exception that the Discord client also scan for invite links\n  that don\'t start with http, e.g., "discord.gg/pxa"\n- the WITHOUT_PREVIEW variant appears when the message contains the URL in the <URL>\n  form, which causes the Discord client to suppress the preview\n  \nEMOJI_CUSTOM\n- fields: "emoji_name", "emoji_id"\n- you can get the custom emoji\'s image by querying to\n  https://cdn.discordapp.com/emojis/EMOJI_ID.png\n  \nEMOJI_UNICODE_ENCODED\n- fields: "emoji_name"\n- this will appear very rarely. unicode emojis are usually just posted as unicode  \n  characters and thus end up in a TEXT node it is, however, possible to send a message\n  from a bot that uses, e.g., :red_car: instead of the actual red_car unicode emoji.\n  the Discord client will properly translate that to the correct unicode emoji.\n  this package does not do that because Discord has not published the list of names they\n  use for the emojis. so this package will simply relay the emoji\'s name\n```\n\n### Known Issues\nWhile this parser should work in pretty much every realistic scenario, there are some\nvery specific edge cases in which this parser will produce an output that doesn\'t align\nwith how it\'s rendered in the Discord client:\n- `***bold and italic***` will be detected as bold-only with extra stars.\n  This only happens when the italic and bold stars are right next to each other.\n  This does not happen when mixing bold stars with italic underscores.\n- `*italic with whitespace before star closer *`\n  will be detected as italic even though the Discord client won\'t.\n  Note that Discord doesn\'t have this weird requirement for `_underscore italic_`.\n- ``||spoilers around `code segments`||``\n  will be detected as spoilers spanning the code segments, although the Discord the\n  client will only show spoiler bars before and after the code segment, but not on top\n  of it.\n  \n',
    'author': 'Tim Schmidt',
    'author_email': 'w4rum@khorne.faith',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/w4rum/discord-markdown-ast-parser',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
