<div align="center">
  <img src="imgs/r4ven_logo.png"><br>
</div>

-----------------

# r4ven: The companion that holds your grab-bag of utility functions and objects

> Reimplementing utilities folder across multiple Python projects... Nevermore!

-----------------

## What is it?

**r4ven_utils** is all of those of utilities you keep reimplementing across your Python projects, that all got together and decided to live in harmony.

## Main Features
Here are some of the utilities that r4ven keep under it's wings:

  - [**log4me**][log-4-me] - Creation of a logger object specific to the function in which it's called.

   [log-4-me]: r4ven_utils/log4me.py

## Where to get it
The source code is currently hosted on GitHub at:
https://github.com/VictorFantucci/r4ven_utils_dev

Binary installers for the latest released version are available at the [Python
Package Index (PyPI)](https://pypi.org/project/r4ven_utils).
```sh
# or PyPI
pip install r4ven_utils
```

## Dependencies
- [**os**][os-module] - This module provides a portable way of using operating system dependent functionality.
- [**sys**][sys-module] - This module provides access to some variables used or maintained by the interpreter and to functions that interact strongly with the interpreter.
- [**logging**][logging-module]- This module defines functions and classes which implement a flexible event logging system for applications and libraries.

[os-module]: https://docs.python.org/3/library/os.html
[sys-module]: https://docs.python.org/3/library/sys.html
[logging-module]: https://docs.python.org/3/library/logging.htmlhttps://github.com/stub42/pytz

## License
[GPLv3](LICENSE)

## Documentation
All my scripts have very detailed docstrings and comments that make their use intuitive and simple. As the project grows and takes shape I plan to write a  proper documentation for it.

## Background
> "*Once upon a midnight dreary, while I pondered, weak and weary,<br>
Over many a quaint and curious volume of forgotten lore...*"<br>
*Edgar Allan Poe*

This is how I felt every time I needed re-implement utilities folders over and over again through my Python projects... so work on ``r4ven`` started as an idea to gather all the scripts, code and functions that were constantly appearing in the utilities folder of my Python projects.

## Contributing to r4ven

All contributions, bug reports, bug fixes, documentation improvements, enhancements, and ideas are welcome.

If you are simply looking to start working with the r4ven codebase, navigate to the [GitHub "issues" tab](https://github.com/VictorFantucci/r4ven_utils_dev/issues) and start looking through interesting issues.

Or maybe through using r4ven you have an idea of your own or are looking for something in the documentation and thinking ‘this can be improved’...you can do something about it!

Feel free to ask questions through my email which can be found on the main page of my [**Github**](https://github.com/VictorFantucci).
