/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.SkinParameter;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.ugraphic.Shadowable;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGraphicStencil;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class USymbolRectangle
extends USymbol {
    private final SkinParameter skinParameter;

    public USymbolRectangle(SkinParameter skinParameter) {
        this.skinParameter = skinParameter;
    }

    @Override
    public SkinParameter getSkinParameter() {
        return this.skinParameter;
    }

    private void drawRect(UGraphic ug, double width, double height, boolean shadowing, double roundCorner, double diagonalCorner) {
        Shadowable shape;
        URectangle rect = new URectangle(width, height);
        Shadowable shadowable = shape = diagonalCorner > 0.0 ? rect.diagonalCorner(diagonalCorner) : rect.rounded(roundCorner);
        if (shadowing) {
            shape.setDeltaShadow(3.0);
        }
        ug.draw(shape);
    }

    private USymbol.Margin getMargin() {
        return new USymbol.Margin(10.0, 10.0, 10.0, 10.0);
    }

    @Override
    public TextBlock asSmall(TextBlock name, final TextBlock label, final TextBlock stereotype, final SymbolContext symbolContext, final HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                Dimension2D dim = this.calculateDimension(ug.getStringBounder());
                ug = UGraphicStencil.create(ug, dim);
                ug = symbolContext.apply(ug);
                USymbolRectangle.this.drawRect(ug, dim.getWidth(), dim.getHeight(), symbolContext.isShadowing(), symbolContext.getRoundCorner(), symbolContext.getDiagonalCorner());
                USymbol.Margin margin = USymbolRectangle.this.getMargin();
                TextBlock tb = TextBlockUtils.mergeTB(stereotype, label, stereoAlignment);
                tb.drawU(ug.apply(new UTranslate(margin.getX1(), margin.getY1())));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                Dimension2D dimLabel = label.calculateDimension(stringBounder);
                Dimension2D dimStereo = stereotype.calculateDimension(stringBounder);
                return USymbolRectangle.this.getMargin().addDimension(Dimension2DDouble.mergeTB(dimStereo, dimLabel));
            }
        };
    }

    @Override
    public TextBlock asBig(final TextBlock title, final HorizontalAlignment labelAlignment, final TextBlock stereotype, final double width, final double height, final SymbolContext symbolContext, final HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                double posStereoY;
                double posStereoX;
                Dimension2D dim = this.calculateDimension(ug.getStringBounder());
                ug = symbolContext.apply(ug);
                USymbolRectangle.this.drawRect(ug, dim.getWidth(), dim.getHeight(), symbolContext.isShadowing(), symbolContext.getRoundCorner(), 0.0);
                Dimension2D dimStereo = stereotype.calculateDimension(ug.getStringBounder());
                if (stereoAlignment == HorizontalAlignment.RIGHT) {
                    posStereoX = width - dimStereo.getWidth() - USymbolRectangle.this.getMargin().getX1() / 2.0;
                    posStereoY = USymbolRectangle.this.getMargin().getY1() / 2.0;
                } else {
                    posStereoX = (width - dimStereo.getWidth()) / 2.0;
                    posStereoY = 2.0;
                }
                stereotype.drawU(ug.apply(new UTranslate(posStereoX, posStereoY)));
                Dimension2D dimTitle = title.calculateDimension(ug.getStringBounder());
                double posTitle = labelAlignment == HorizontalAlignment.LEFT ? 3.0 : (labelAlignment == HorizontalAlignment.RIGHT ? width - dimTitle.getWidth() - 3.0 : (width - dimTitle.getWidth()) / 2.0);
                title.drawU(ug.apply(new UTranslate(posTitle, 2.0 + dimStereo.getHeight())));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(width, height);
            }
        };
    }
}

