MUTATION = {}
CAMPAIGN_M = {
    "subscribeM": "mutation SubscribeCampaign($id: String!, $uid: String!, $avatarId: String, $fileId: String, $name: String, $gender: Gender, $weight: String, $height: String, $birth: Int, $birthStr: String) {\n  subscribeCampaign(id: $id, uid: $uid, avatarId: $avatarId, fileId: $fileId, name: $name, gender: $gender, weight: $weight, height: $height, birth: $birth, birthStr: $birthStr) {\n    __typename\n    ...SubscribedCampaignFragment\n  }\n}\nfragment SubscribedCampaignFragment on CampaignSubscribed {\n  __typename\n  campaign {\n    __typename\n    id\n  }\n  user {\n    __typename\n    id\n  }\n  avatar {\n    __typename\n    ...FileFragment\n  }\n  profile {\n    __typename\n    ...FileFragment\n  }\n  name\n  subscribedDate\n}\nfragment FileFragment on File {\n  __typename\n  id\n  name\n}",
    "unsubscribeM": "mutation UnsubscribeCampaign($id : String!, $uid : String!) {\n  unsubscribeCampaign(id: $id, uid: $uid)\n}",
    "addAvatarM": "mutation AddAvatar($fileId : String!, $name : String, $listOrder : Int) {\n  addAvatar(fileId: $fileId, name: $name, listOrder: $listOrder) {\n    __typename\n    ...AvatarFragment\n  }\n}\nfragment AvatarFragment on Avatar {\n  __typename\n  id\n  name\n  file {\n    __typename\n    ...FileFragment\n  }\n}\nfragment FileFragment on File {\n  __typename\n  id\n  name\n}",
    "modifyAvatarM": "mutation ModifyAvatar($id: String!, $fileId: String, $name : String, $listOrder : Int) {\n  modifyAvatar(id: $id, fileId: $fileId, name: $name, listOrder: $listOrder)\n}",
    "removeAvatarM": "mutation RemoveAvatar($id: String!) {\n  removeAvatar(id: $id)\n}",
}
FCM_M = {
    "setTokenM": "mutation setFCMToken($clientId: String!, $fcmToken: String!, $manufacturer: String, $brand: String, $model: String, $osVer: String, $userLang: String!, $timeZone: String) {\n  setFCMToken(clientId: $clientId, fcmToken: $fcmToken, terminalType: ANDROID, manufacturer: $manufacturer, brand: $brand, model: $model, osVer: $osVer, userLang: $userLang, timeZone: $timeZone, isAndroid: true)\n}",
}
MYINFO_M = {
    "modifyCampaignUserProfileM": "mutation ModifyCampaignUserProfile($uid: String, $name: String, $avatarId: String, $profileId: String, $userName: String, $userProfileId: String, $birthday: Int, $birthStr: String, $gender: Gender, $height: String, $weight: String) {\n  modifyCampaignUserProfile(uid: $uid, name: $name, avatarId: $avatarId, profileId: $profileId, userName: $userName, userProfileId: $userProfileId, birthday: $birthday, birthStr: $birthStr, gender: $gender, height: $height, weight: $weight)\n}",
    "updateM": "mutation UpdateMyInfo($name: String, $emailAddress: String, $birthday: Int, $birthStr: String, $gender: Gender, $height: String, $weight: String, $profileId: String, $oldPassword: String, $newPassword: String) {\n  updateMyInfo(name: $name, emailAddress: $emailAddress, birthday: $birthday, birthStr: $birthStr, gender: $gender, height: $height, weight: $weight, profileId: $profileId, oldPassword: $oldPassword, newPassword: $newPassword) {\n    __typename\n    ...UserFragment\n  }\n}\nfragment UserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  birth\n  birthStr\n  weight\n  height\n  countryCode\n  emailAddress\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  emailConfirm\n  status\n  file {\n    __typename\n    ...FileFragment\n  }\n  extra\n  xcoin\n  currentStep\n  totalStep\n  create\n  update\n  children {\n    __typename\n    id\n    guardian {\n      __typename\n      ...SimpleUserFragment\n    }\n    ward {\n      __typename\n      ...SimpleUserFragment\n    }\n  }\n}\nfragment FileFragment on File {\n  __typename\n  id\n  name\n}\nfragment SimpleUserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  countryCode\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  file {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  currentStep\n  totalStep\n  contacts {\n    __typename\n    ...ContactsFragment\n  }\n}\nfragment ContactsFragment on Contact {\n  __typename\n  id\n  me {\n    __typename\n    ...ContactorFragment\n  }\n  contacter {\n    __typename\n    ...ContactorFragment\n  }\n  phoneNumber\n  extra\n  listOrder\n  file {\n    __typename\n    ...FileFragment\n  }\n  create\n  update\n}\nfragment ContactorFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  countryCode\n  countryPhoneCode\n  mobilePhoneNumber\n  phoneNumber\n}",
    "upsertCampaignUserProfileM": "mutation UpsertCampaignUserProfile($uid: String!, $name: String, $avatarId: String, $profileId: String, $userName: String, $userProfileId: String, $birthday: Int, $gender: Gender, $height: String, $weight: String) {\n  upsertCampaignUserProfile(uid: $uid, name: $name, avatarId: $avatarId, profileId: $profileId, userName: $userName, userProfileId: $userProfileId, birthday: $birthday, gender: $gender, height: $height, weight: $weight) {\n    __typename\n    ...CampaignUserProfilesFragment\n  }\n}\nfragment CampaignUserProfilesFragment on CampaignUserProfile {\n  __typename\n  id\n  user {\n    __typename\n    ...UserFragment\n  }\n  name\n  avatar {\n    __typename\n    ...AvatarFragment\n  }\n  profile {\n    __typename\n    ...FileFragment\n  }\n  create\n  update\n}\nfragment UserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  birth\n  birthStr\n  weight\n  height\n  countryCode\n  emailAddress\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  emailConfirm\n  status\n  file {\n    __typename\n    ...FileFragment\n  }\n  extra\n  xcoin\n  currentStep\n  totalStep\n  create\n  update\n  children {\n    __typename\n    id\n    guardian {\n      __typename\n      ...SimpleUserFragment\n    }\n    ward {\n      __typename\n      ...SimpleUserFragment\n    }\n  }\n}\nfragment FileFragment on File {\n  __typename\n  id\n  name\n}\nfragment SimpleUserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  countryCode\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  file {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  currentStep\n  totalStep\n  contacts {\n    __typename\n    ...ContactsFragment\n  }\n}\nfragment ContactsFragment on Contact {\n  __typename\n  id\n  me {\n    __typename\n    ...ContactorFragment\n  }\n  contacter {\n    __typename\n    ...ContactorFragment\n  }\n  phoneNumber\n  extra\n  listOrder\n  file {\n    __typename\n    ...FileFragment\n  }\n  create\n  update\n}\nfragment ContactorFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  countryCode\n  countryPhoneCode\n  mobilePhoneNumber\n  phoneNumber\n}\nfragment AvatarFragment on Avatar {\n  __typename\n  id\n  name\n  file {\n    __typename\n    ...FileFragment\n  }\n}",
}
REVIEW_M = {
    "updateUserFeedbackM": "mutation UpdateUserFeedback($uid: String!, $review: String!) {\n  updateUserFeedback(uid: $uid, review: $review) {\n    __typename\n    ...UserFeedbackFragment\n  }\n}\nfragment UserFeedbackFragment on UserReview {\n  __typename\n  id\n  selection\n  review\n  create\n  update\n}",
    "updateUserSelectionM": "mutation UpdateUserSelection($uid: String!, $selection: Int!) {\n  updateUserSelection(uid: $uid, selection: $selection) {\n    __typename\n    ...UserReviewFragment\n  }\n}\nfragment UserReviewFragment on UserReview {\n  __typename\n  id\n  selection\n  review\n  create\n  update\n}",
}
SIGN_M = {
    "expireTokenM": "mutation ExpireToken {\n  expireToken {\n    __typename\n    token\n  }\n}",
    "issueTokenM": "mutation IssueToken($countryPhoneNumber: String!, $phoneNumber: String!, $password: String!, $userLang: String!, $timeZone: String!) {\n  issueToken(countryPhoneNumber: $countryPhoneNumber, phoneNumber: $phoneNumber, password: $password, userLang: $userLang, timeZone: $timeZone) {\n    __typename\n    id\n    token\n    issueDate\n    expireDate\n    user {\n      __typename\n      ...UserFragment\n    }\n    app {\n      __typename\n      ...AppFragment\n    }\n    valid\n    w360 {\n      __typename\n      token\n      secret\n      qid\n    }\n  }\n}\nfragment UserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  birth\n  birthStr\n  weight\n  height\n  countryCode\n  emailAddress\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  emailConfirm\n  status\n  file {\n    __typename\n    ...FileFragment\n  }\n  extra\n  xcoin\n  currentStep\n  totalStep\n  create\n  update\n  children {\n    __typename\n    id\n    guardian {\n      __typename\n      ...SimpleUserFragment\n    }\n    ward {\n      __typename\n      ...SimpleUserFragment\n    }\n  }\n}\nfragment FileFragment on File {\n  __typename\n  id\n  name\n}\nfragment SimpleUserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  countryCode\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  file {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  currentStep\n  totalStep\n  contacts {\n    __typename\n    ...ContactsFragment\n  }\n}\nfragment ContactsFragment on Contact {\n  __typename\n  id\n  me {\n    __typename\n    ...ContactorFragment\n  }\n  contacter {\n    __typename\n    ...ContactorFragment\n  }\n  phoneNumber\n  extra\n  listOrder\n  file {\n    __typename\n    ...FileFragment\n  }\n  create\n  update\n}\nfragment ContactorFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  countryCode\n  countryPhoneCode\n  mobilePhoneNumber\n  phoneNumber\n}\nfragment AppFragment on App {\n  __typename\n  id\n  name\n  packageName\n  apiKey\n  apiSecret\n  terminalType\n  description\n  status\n  versions {\n    __typename\n    ...VersionFragment\n  }\n  create\n  update\n}\nfragment VersionFragment on AppVersion {\n  __typename\n  id\n  version\n  requireUpdate\n  downloadUrl\n  description\n  create\n  update\n}",
    "signUpM": "mutation SignUp($countryPhoneCode: String!, $phoneNumber: String!, $password: String!, $confirmCode: String!, $name: String, $emailAddress: String, $profileId: String, $userLang: String!, $timeZone: String) {\n  signUp(countryPhoneCode: $countryPhoneCode, phoneNumber: $phoneNumber, password: $password, confirmCode: $confirmCode, name: $name, emailAddress: $emailAddress, profileId: $profileId, userLang: $userLang, timeZone: $timeZone) {\n    __typename\n    ...UserFragment\n  }\n}\nfragment UserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  birth\n  birthStr\n  weight\n  height\n  countryCode\n  emailAddress\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  emailConfirm\n  status\n  file {\n    __typename\n    ...FileFragment\n  }\n  extra\n  xcoin\n  currentStep\n  totalStep\n  create\n  update\n  children {\n    __typename\n    id\n    guardian {\n      __typename\n      ...SimpleUserFragment\n    }\n    ward {\n      __typename\n      ...SimpleUserFragment\n    }\n  }\n}\nfragment FileFragment on File {\n  __typename\n  id\n  name\n}\nfragment SimpleUserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  countryCode\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  file {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  currentStep\n  totalStep\n  contacts {\n    __typename\n    ...ContactsFragment\n  }\n}\nfragment ContactsFragment on Contact {\n  __typename\n  id\n  me {\n    __typename\n    ...ContactorFragment\n  }\n  contacter {\n    __typename\n    ...ContactorFragment\n  }\n  phoneNumber\n  extra\n  listOrder\n  file {\n    __typename\n    ...FileFragment\n  }\n  create\n  update\n}\nfragment ContactorFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  countryCode\n  countryPhoneCode\n  mobilePhoneNumber\n  phoneNumber\n}",
}
STEP_M = {
    "addM": "mutation AddStep($stepCount: Int) {\n  addStep(stepCount: $stepCount)\n}",
}
UTILS_M = {
    "issueCodeM": "mutation IssueCode($purpose: VerificationType!, $countryCode: String!, $phoneNumber: String!) {\n  issueCode(purpose: $purpose, countryCode: $countryCode, phoneNumber: $phoneNumber) {\n    __typename\n    registered\n    sent\n    ttl\n  }\n}",
    "resetPasswordM": "mutation ResetPassword($countryPhoneNumber : String!, $phoneNumber : String!, $verifyCode : String!, $password : String!) {\n  resetPassword(countryPhoneNumber: $countryPhoneNumber, phoneNumber: $phoneNumber, verifyCode: $verifyCode, password: $password) {\n    __typename\n    alreadyRegistered\n    resetSuccess\n  }\n}",
}
WATCH_M = {
    "confirmM": "mutation ConfirmWatch($deviceId : String!, $qid : String!) {\n  confirmWatch(deviceId: $deviceId, qid: $qid)\n}",
    "createM": "mutation CreateWatch($countryCode : String!, $phoneNumber: String!, $qrCode : String!, $qrt : String!, $qrc : String!) {\n  createWatch(countryCode: $countryCode, phoneNumber: $phoneNumber, qrCode: $qrCode, qrt: $qrt, qrc: $qrc) {\n    __typename\n    ...WatchFragment\n  }\n}\nfragment WatchFragment on Watch {\n  __typename\n  id\n  group {\n    __typename\n    ...WatchGroupFragment\n  }\n  vendor {\n    __typename\n    ...VendorFragment\n  }\n  user {\n    __typename\n    ...UserFragment\n  }\n  name\n  swKey\n  groupName\n  os\n  osName\n  osVersion\n  brand\n  phoneNumber\n  qrCode\n  countryPhoneCode\n  onlineStatus\n  status\n  activated\n  extra\n  create\n  update\n}\nfragment WatchGroupFragment on WatchGroup {\n  __typename\n  id\n  name\n  status\n  extra\n  description\n  create\n  update\n}\nfragment VendorFragment on Vendor {\n  __typename\n  id\n  name\n  status\n  extra\n  description\n  create\n  update\n}\nfragment UserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  birth\n  birthStr\n  weight\n  height\n  countryCode\n  emailAddress\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  emailConfirm\n  status\n  file {\n    __typename\n    ...FileFragment\n  }\n  extra\n  xcoin\n  currentStep\n  totalStep\n  create\n  update\n  children {\n    __typename\n    id\n    guardian {\n      __typename\n      ...SimpleUserFragment\n    }\n    ward {\n      __typename\n      ...SimpleUserFragment\n    }\n  }\n}\nfragment FileFragment on File {\n  __typename\n  id\n  name\n}\nfragment SimpleUserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  countryCode\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  file {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  currentStep\n  totalStep\n  contacts {\n    __typename\n    ...ContactsFragment\n  }\n}\nfragment ContactsFragment on Contact {\n  __typename\n  id\n  me {\n    __typename\n    ...ContactorFragment\n  }\n  contacter {\n    __typename\n    ...ContactorFragment\n  }\n  phoneNumber\n  extra\n  listOrder\n  file {\n    __typename\n    ...FileFragment\n  }\n  create\n  update\n}\nfragment ContactorFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  countryCode\n  countryPhoneCode\n  mobilePhoneNumber\n  phoneNumber\n}",
    "deleteAlertM": "mutation deleteAlert($rid: String!) {\n  deleteAlert(rid: $rid)\n}",
    "denyM": "mutation DenyWatch($deviceId: String!, $requestId: String!) {\n  denyWatch(deviceId: $deviceId, requestId: $requestId)\n}",
    "modifyAlertM": "mutation modifyAlert($uid: String!, $remind: YesOrNo!) {\n  modifyAlert(uid: $uid, remind: $remind)\n}",
    "rebootM": "mutation reboot($uid : String!) {\n  reboot(uid: $uid)\n}",
    "removeM": "mutation RemoveWatch($uid : String!) {\n  removeWatch(uid: $uid)\n}",
    "resetM": "mutation ResetWatch($uid: String!) {\n  resetWatch(uid: $uid)\n}",
    "setInfoM": "mutation SetWatchInfo($uid: String, $name : String, $qr: String, $phoneNumber : String, $countryCode : String) {\n  setWatchInfo(uid: $uid, name: $name, qr: $qr, phoneNumber: $phoneNumber, countryCode: $countryCode)\n}",
    "shutdownM": "mutation ShutDown($uid: String!) {\n  shutDown(uid: $uid)\n}",
    "updateM": "mutation UpdateWatch($uid : String!, $countryCode : String, $phoneNumber : String) {\n  updateWatch(uid: $uid, countryCode: $countryCode, phoneNumber: $phoneNumber)\n}",
    "addAlarmM": "mutation AddAlarm($uid: String!, $name: String, $occurMin: Int!, $start: Int!, $end: Int, $weekRepeat: String!, $description: String, $extra: JSON, $timeZone: String) {\n  addAlarm(uid: $uid, name: $name, occurMin: $occurMin, start: $start, end: $end, weekRepeat: $weekRepeat, description: $description, extra: $extra, timeZone: $timeZone) {\n    __typename\n    ...WatchAlarmFragment\n  }\n}\nfragment WatchAlarmFragment on WatchAlarm {\n  __typename\n  id\n  vendorName\n  vendorId\n  watch {\n    __typename\n    ...WatchFragment\n  }\n  user {\n    __typename\n    ...UserFragment\n  }\n  name\n  start\n  end\n  weekRepeat\n  occurMin\n  description\n  extra\n  start\n  create\n  update\n  status\n}\nfragment WatchFragment on Watch {\n  __typename\n  id\n  group {\n    __typename\n    ...WatchGroupFragment\n  }\n  vendor {\n    __typename\n    ...VendorFragment\n  }\n  user {\n    __typename\n    ...UserFragment\n  }\n  name\n  swKey\n  groupName\n  os\n  osName\n  osVersion\n  brand\n  phoneNumber\n  qrCode\n  countryPhoneCode\n  onlineStatus\n  status\n  activated\n  extra\n  create\n  update\n}\nfragment WatchGroupFragment on WatchGroup {\n  __typename\n  id\n  name\n  status\n  extra\n  description\n  create\n  update\n}\nfragment VendorFragment on Vendor {\n  __typename\n  id\n  name\n  status\n  extra\n  description\n  create\n  update\n}\nfragment UserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  birth\n  birthStr\n  weight\n  height\n  countryCode\n  emailAddress\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  emailConfirm\n  status\n  file {\n    __typename\n    ...FileFragment\n  }\n  extra\n  xcoin\n  currentStep\n  totalStep\n  create\n  update\n  children {\n    __typename\n    id\n    guardian {\n      __typename\n      ...SimpleUserFragment\n    }\n    ward {\n      __typename\n      ...SimpleUserFragment\n    }\n  }\n}\nfragment FileFragment on File {\n  __typename\n  id\n  name\n}\nfragment SimpleUserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  countryCode\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  file {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  currentStep\n  totalStep\n  contacts {\n    __typename\n    ...ContactsFragment\n  }\n}\nfragment ContactsFragment on Contact {\n  __typename\n  id\n  me {\n    __typename\n    ...ContactorFragment\n  }\n  contacter {\n    __typename\n    ...ContactorFragment\n  }\n  phoneNumber\n  extra\n  listOrder\n  file {\n    __typename\n    ...FileFragment\n  }\n  create\n  update\n}\nfragment ContactorFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  countryCode\n  countryPhoneCode\n  mobilePhoneNumber\n  phoneNumber\n}",
    "modifyAlarmM": "mutation ModifyAlarm($alarmId: String!, $name: String, $occurMin: Int, $start: Int, $end: Int, $weekRepeat: String, $description: String, $status: NormalStatus, $extra: JSON, $timeZone: String) {\n  modifyAlarm(alarmId: $alarmId, name: $name, occurMin: $occurMin, status: $status, end: $end, weekRepeat:     $weekRepeat, description: $description, start: $start, extra: $extra, timeZone: $timeZone)\n}",
    "removeAlarmM": "mutation RemoveAlarm($alarmId : String!) {\n  removeAlarm(alarmId: $alarmId)\n}",
    "deleteChatMessageM": "mutation DeleteChatMessage($uid: String!, $msgId: String!) {\n  deleteMsg(uid: $uid, msgId: $msgId)\n}",
    "sendChatEmoticonM": "mutation SendChatEmoticon($uid : String!, $emoticonId : ChatEmoticonType!) {\n  sendChatEmoticon(uid: $uid, emoticonId: $emoticonId)\n}",
    "sendChatImageM": "mutation SendChatImage($uid: String!, $format: String!, $hash: String!, $hashBody: String!, $tm:String) {\n  sendChatImage(uid: $uid, format: $format, hash: $hash, hashBody: $hashBody, tm: $tm)\n}",
    "sendChatMp3M": "mutation SendChatMp3($uid: String!, $fileName: String!, $duration: Int, $hash: String, $hashBody: String!, $tm: String) {\n  sendChatMp3(uid: $uid, fileName: $fileName, duration: $duration, hash: $hash, hashBody: $hashBody, tm: $tm)\n}",
    "sendChatTextM": "mutation SendChatText($uid : String!, $text : String!) {\n  sendChatText(uid: $uid, text: $text)\n}",
    "sendChatVoiceM": "mutation SendChatVoice($uid : String!, $duration : Int!, $hash:String!, $hashBody:String!, $tm:String) {\n  sendChatVoice(uid: $uid, duration: $duration, hash: $hash, hashBody: $hashBody, tm: $tm)\n}",
    "setReadChatMsgM": "mutation setReadChatMsg($uid: String!, $msgId : String, $id : String) {\n  setReadChatMsg(uid: $uid, msgId: $msgId, id: $id)\n}",
    "addContactM": "mutation AddContact($uid : String!, $contactName : String, $countryPhoneNumber : String, $phoneNumber : String, $fileId : String) {\n  addContact(uid: $uid, contactName: $contactName, countryPhoneNumber: $countryPhoneNumber, phoneNumber: $phoneNumber, fileId: $fileId) {\n    __typename\n    ...ContactFragment\n  }\n}\nfragment ContactFragment on XPContact {\n  __typename\n  id\n  ownUser {\n    __typename\n    ...SimpleUserFragment\n  }\n  name\n  countryPhoneNumber\n  phoneNumber\n  contactUser {\n    __typename\n    ...SimpleUserFragment\n  }\n  extra\n  listOrder\n  file {\n    __typename\n    ...FileFragment\n  }\n  approval\n  guardianType\n  create\n  update\n}\nfragment SimpleUserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  countryCode\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  file {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  currentStep\n  totalStep\n  contacts {\n    __typename\n    ...ContactsFragment\n  }\n}\nfragment FileFragment on File {\n  __typename\n  id\n  name\n}\nfragment ContactsFragment on Contact {\n  __typename\n  id\n  me {\n    __typename\n    ...ContactorFragment\n  }\n  contacter {\n    __typename\n    ...ContactorFragment\n  }\n  phoneNumber\n  extra\n  listOrder\n  file {\n    __typename\n    ...FileFragment\n  }\n  create\n  update\n}\nfragment ContactorFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  countryCode\n  countryPhoneCode\n  mobilePhoneNumber\n  phoneNumber\n}",
    "modifyContactM": "mutation ModifyContact($contactId : String!, $contactName : String, $fileId : String, $isAdmin : Boolean) {\n  modifyContact(contactId: $contactId, contactName: $contactName, fileId: $fileId, isAdmin: $isAdmin)\n}",
    "removeContactM": "mutation RemoveContact($contactId : String!) {\n  removeContact(contactId: $contactId)\n}",
    "addSilentTimeM": "mutation AddSilentTime($uid: String!, $start: Int!, $end: Int!, $weekRepeat: String!, $description: String, $extra: JSON) {\n  addSilentTime(uid: $uid, start: $start, end: $end, weekRepeat: $weekRepeat, description: $description, extra: $extra) {\n    __typename\n    ...SlientModeFragment\n  }\n}\nfragment SlientModeFragment on SilentMode {\n  __typename\n  id\n  vendorName\n  vendorId\n  watch {\n    __typename\n    ...WatchFragment\n  }\n  user {\n    __typename\n    ...UserFragment\n  }\n  start\n  end\n  weekRepeat\n  description\n  extra\n  start\n  create\n  update\n}\nfragment WatchFragment on Watch {\n  __typename\n  id\n  group {\n    __typename\n    ...WatchGroupFragment\n  }\n  vendor {\n    __typename\n    ...VendorFragment\n  }\n  user {\n    __typename\n    ...UserFragment\n  }\n  name\n  swKey\n  groupName\n  os\n  osName\n  osVersion\n  brand\n  phoneNumber\n  qrCode\n  countryPhoneCode\n  onlineStatus\n  status\n  activated\n  extra\n  create\n  update\n}\nfragment WatchGroupFragment on WatchGroup {\n  __typename\n  id\n  name\n  status\n  extra\n  description\n  create\n  update\n}\nfragment VendorFragment on Vendor {\n  __typename\n  id\n  name\n  status\n  extra\n  description\n  create\n  update\n}\nfragment UserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  birth\n  birthStr\n  weight\n  height\n  countryCode\n  emailAddress\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  emailConfirm\n  status\n  file {\n    __typename\n    ...FileFragment\n  }\n  extra\n  xcoin\n  currentStep\n  totalStep\n  create\n  update\n  children {\n    __typename\n    id\n    guardian {\n      __typename\n      ...SimpleUserFragment\n    }\n    ward {\n      __typename\n      ...SimpleUserFragment\n    }\n  }\n}\nfragment FileFragment on File {\n  __typename\n  id\n  name\n}\nfragment SimpleUserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  countryCode\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  file {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  currentStep\n  totalStep\n  contacts {\n    __typename\n    ...ContactsFragment\n  }\n}\nfragment ContactsFragment on Contact {\n  __typename\n  id\n  me {\n    __typename\n    ...ContactorFragment\n  }\n  contacter {\n    __typename\n    ...ContactorFragment\n  }\n  phoneNumber\n  extra\n  listOrder\n  file {\n    __typename\n    ...FileFragment\n  }\n  create\n  update\n}\nfragment ContactorFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  countryCode\n  countryPhoneCode\n  mobilePhoneNumber\n  phoneNumber\n}",
    "modifySilentTimeM": "mutation ModifySilentTime($silentId: String!, $start: Int, $end: Int, $weekRepeat: String, $description: String, $extra: JSON) {\n  modifySilentTime(silentId: $silentId, start: $start, end: $end, weekRepeat: $weekRepeat, description: $description, extra: $extra)\n}",
    "removeSilentTimeM": "mutation RemoveSilentTime($silentId : String!) {\n  removeSilentTime(silentId: $silentId)\n}",
    "setEnableSlientTimeM": "mutation SetEnableSlientTime($silentId : String!, $status: NormalStatus!) {\n  setEnableSilentTime(silentId: $silentId, status: $status)\n}",
    "addSafeZoneM": "mutation AddSafeZone($uid : String!, $groupId: String!, $name : String!, $lat: String!, $lng: String!, $rad: Int!, $address : String!) {\n  addSafeZone(uid: $uid, groupId: $groupId, name: $name, lat: $lat, lng: $lng, rad: $rad, address: $address) {\n    __typename\n    ...SafeZoneFragment\n  }\n}\nfragment SafeZoneFragment on SafeZone {\n  __typename\n  id\n  vendorName\n  vendorId\n  groupName\n  watch {\n    __typename\n    ...WatchFragment\n  }\n  user {\n    __typename\n    ...UserFragment\n  }\n  group {\n    __typename\n    ...SafeZoneGroupFragment\n  }\n  name\n  lat\n  lng\n  rad\n  address\n  description\n  extra\n  create\n  update\n}\nfragment WatchFragment on Watch {\n  __typename\n  id\n  group {\n    __typename\n    ...WatchGroupFragment\n  }\n  vendor {\n    __typename\n    ...VendorFragment\n  }\n  user {\n    __typename\n    ...UserFragment\n  }\n  name\n  swKey\n  groupName\n  os\n  osName\n  osVersion\n  brand\n  phoneNumber\n  qrCode\n  countryPhoneCode\n  onlineStatus\n  status\n  activated\n  extra\n  create\n  update\n}\nfragment WatchGroupFragment on WatchGroup {\n  __typename\n  id\n  name\n  status\n  extra\n  description\n  create\n  update\n}\nfragment VendorFragment on Vendor {\n  __typename\n  id\n  name\n  status\n  extra\n  description\n  create\n  update\n}\nfragment UserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  birth\n  birthStr\n  weight\n  height\n  countryCode\n  emailAddress\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  emailConfirm\n  status\n  file {\n    __typename\n    ...FileFragment\n  }\n  extra\n  xcoin\n  currentStep\n  totalStep\n  create\n  update\n  children {\n    __typename\n    id\n    guardian {\n      __typename\n      ...SimpleUserFragment\n    }\n    ward {\n      __typename\n      ...SimpleUserFragment\n    }\n  }\n}\nfragment FileFragment on File {\n  __typename\n  id\n  name\n}\nfragment SimpleUserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  countryCode\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  file {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  currentStep\n  totalStep\n  contacts {\n    __typename\n    ...ContactsFragment\n  }\n}\nfragment ContactsFragment on Contact {\n  __typename\n  id\n  me {\n    __typename\n    ...ContactorFragment\n  }\n  contacter {\n    __typename\n    ...ContactorFragment\n  }\n  phoneNumber\n  extra\n  listOrder\n  file {\n    __typename\n    ...FileFragment\n  }\n  create\n  update\n}\nfragment ContactorFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  countryCode\n  countryPhoneCode\n  mobilePhoneNumber\n  phoneNumber\n}\nfragment SafeZoneGroupFragment on SafeZoneGroup {\n  __typename\n  id\n  name\n  status\n  description\n  create\n  update\n}",
    "removeSafeZoneM": "mutation RemoveSafeZone($zoneId : String!) {\n  removeSafeZone(zoneId: $zoneId)\n}",
    "addWiFiM": "mutation AddWiFi($uid : String!, $ssid : String!, $name : String, $password : String) {\n  addWiFi(uid: $uid, ssid: $ssid, name: $name, password: $password) {\n    __typename\n    ...WiFiFragment\n  }\n}\nfragment WiFiFragment on WiFi {\n  __typename\n  id\n  name\n  ssid\n  password\n  state\n  create\n  update\n  user {\n    __typename\n    ...UserFragment\n  }\n  watch {\n    __typename\n    ...WatchFragment\n  }\n}\nfragment UserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  birth\n  birthStr\n  weight\n  height\n  countryCode\n  emailAddress\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  emailConfirm\n  status\n  file {\n    __typename\n    ...FileFragment\n  }\n  extra\n  xcoin\n  currentStep\n  totalStep\n  create\n  update\n  children {\n    __typename\n    id\n    guardian {\n      __typename\n      ...SimpleUserFragment\n    }\n    ward {\n      __typename\n      ...SimpleUserFragment\n    }\n  }\n}\nfragment FileFragment on File {\n  __typename\n  id\n  name\n}\nfragment SimpleUserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  countryCode\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  file {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  currentStep\n  totalStep\n  contacts {\n    __typename\n    ...ContactsFragment\n  }\n}\nfragment ContactsFragment on Contact {\n  __typename\n  id\n  me {\n    __typename\n    ...ContactorFragment\n  }\n  contacter {\n    __typename\n    ...ContactorFragment\n  }\n  phoneNumber\n  extra\n  listOrder\n  file {\n    __typename\n    ...FileFragment\n  }\n  create\n  update\n}\nfragment ContactorFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  countryCode\n  countryPhoneCode\n  mobilePhoneNumber\n  phoneNumber\n}\nfragment WatchFragment on Watch {\n  __typename\n  id\n  group {\n    __typename\n    ...WatchGroupFragment\n  }\n  vendor {\n    __typename\n    ...VendorFragment\n  }\n  user {\n    __typename\n    ...UserFragment\n  }\n  name\n  swKey\n  groupName\n  os\n  osName\n  osVersion\n  brand\n  phoneNumber\n  qrCode\n  countryPhoneCode\n  onlineStatus\n  status\n  activated\n  extra\n  create\n  update\n}\nfragment WatchGroupFragment on WatchGroup {\n  __typename\n  id\n  name\n  status\n  extra\n  description\n  create\n  update\n}\nfragment VendorFragment on Vendor {\n  __typename\n  id\n  name\n  status\n  extra\n  description\n  create\n  update\n}",
    "modifyWiFiM": "mutation ModifyWiFi($wifiId : String!, $name : String, $password : String) {\n  modifyWiFi(wifiId: $wifiId, name: $name, password: $password)\n}",
    "removeWiFiM": "mutation RemoveWiFi($wifiId : String!) {\n  removeWiFi(wifiId: $wifiId)\n}",
}
WATCHGROUP_M = {
    "addM": "mutation AddWatchGroup($name: String!, $extra: JSON, $description: String) {\n  addWatchGroup(name: $name, extra: $extra, description: $description) {\n    __typename\n    ...WatchGroupFragment\n  }\n}\nfragment WatchGroupFragment on WatchGroup {\n  __typename\n  id\n  name\n  status\n  extra\n  description\n  create\n  update\n}",
    "modifyM": "mutation ModifyWatchGroup($id: String, $name: String!, $extra: JSON, $description: String, $status: NormalStatus) {\n  modifyWatchGroup(id: $id, name: $name, extra: $extra, description: $description, status: $status)\n}",
    "removeM": "mutation RemoveWatchGroup($id: String) {\n  removeWatchGroup(id: $id)\n}",
}
XCOIN_M = {
    "transferM": "mutation TransferCoin($src: String!, $dest: String!, $coin: Int!) {\n  transferCoin(src: $src, dest: $dest, coin: $coin)\n}",
}
XMOVE_M = {
    "addAlarmReminderM": "mutation AddAlarmReminder($uid: String!, $occurMin: Int!, $start: Int!, $end: Int, $weekRepeat: String!, $threshold: Int!, $hour: Int!, $minute: Int!, $interval: Int!, $extra: JSON) {\n  addAlarmReminder(uid: $uid, occurMin: $occurMin, start: $start, end: $end, weekRepeat: $weekRepeat, threshold: $threshold, hour: $hour, minute: $minute, interval: $interval, extra: $extra) {\n    __typename\n    ...WatchReminderFragment\n  }\n}\nfragment WatchReminderFragment on WatchReminder {\n  __typename\n  id\n  vendorName\n  vendorId\n  watch {\n    __typename\n    ...WatchFragment\n  }\n  user {\n    __typename\n    ...UserFragment\n  }\n  start\n  end\n  weekRepeat\n  occurMin\n  extra\n  start\n  create\n  update\n  status\n}\nfragment WatchFragment on Watch {\n  __typename\n  id\n  group {\n    __typename\n    ...WatchGroupFragment\n  }\n  vendor {\n    __typename\n    ...VendorFragment\n  }\n  user {\n    __typename\n    ...UserFragment\n  }\n  name\n  swKey\n  groupName\n  os\n  osName\n  osVersion\n  brand\n  phoneNumber\n  qrCode\n  countryPhoneCode\n  onlineStatus\n  status\n  activated\n  extra\n  create\n  update\n}\nfragment WatchGroupFragment on WatchGroup {\n  __typename\n  id\n  name\n  status\n  extra\n  description\n  create\n  update\n}\nfragment VendorFragment on Vendor {\n  __typename\n  id\n  name\n  status\n  extra\n  description\n  create\n  update\n}\nfragment UserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  birth\n  birthStr\n  weight\n  height\n  countryCode\n  emailAddress\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  emailConfirm\n  status\n  file {\n    __typename\n    ...FileFragment\n  }\n  extra\n  xcoin\n  currentStep\n  totalStep\n  create\n  update\n  children {\n    __typename\n    id\n    guardian {\n      __typename\n      ...SimpleUserFragment\n    }\n    ward {\n      __typename\n      ...SimpleUserFragment\n    }\n  }\n}\nfragment FileFragment on File {\n  __typename\n  id\n  name\n}\nfragment SimpleUserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  countryCode\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  file {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  currentStep\n  totalStep\n  contacts {\n    __typename\n    ...ContactsFragment\n  }\n}\nfragment ContactsFragment on Contact {\n  __typename\n  id\n  me {\n    __typename\n    ...ContactorFragment\n  }\n  contacter {\n    __typename\n    ...ContactorFragment\n  }\n  phoneNumber\n  extra\n  listOrder\n  file {\n    __typename\n    ...FileFragment\n  }\n  create\n  update\n}\nfragment ContactorFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  countryCode\n  countryPhoneCode\n  mobilePhoneNumber\n  phoneNumber\n}",
    "createBTWatchM": "mutation CreateBTWatch($qrCode : String!, $qrt : String!, $qrc : String!) {\n  createBTWatch(qrCode: $qrCode, qrt: $qrt, qrc: $qrc) {\n    __typename\n    ...WatchBTFragment\n  }\n}\nfragment WatchBTFragment on Watch {\n  __typename\n  id\n  group {\n    __typename\n    ...WatchBTGroupFragment\n  }\n  vendor {\n    __typename\n    ...VendorBTFragment\n  }\n  user {\n    __typename\n    ...UserFragment\n  }\n  name\n  os\n  osName\n  osVersion\n  brand\n  phoneNumber\n  qrCode\n  countryPhoneCode\n  onlineStatus\n  status\n  extra\n  create\n  update\n}\nfragment WatchBTGroupFragment on WatchGroup {\n  __typename\n  id\n  name\n  status\n  extra\n  description\n  create\n  update\n}\nfragment VendorBTFragment on Vendor {\n  __typename\n  id\n  name\n  status\n  extra\n  description\n  create\n  update\n}\nfragment UserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  birth\n  birthStr\n  weight\n  height\n  countryCode\n  emailAddress\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  emailConfirm\n  status\n  file {\n    __typename\n    ...FileFragment\n  }\n  extra\n  xcoin\n  currentStep\n  totalStep\n  create\n  update\n  children {\n    __typename\n    id\n    guardian {\n      __typename\n      ...SimpleUserFragment\n    }\n    ward {\n      __typename\n      ...SimpleUserFragment\n    }\n  }\n}\nfragment FileFragment on File {\n  __typename\n  id\n  name\n}\nfragment SimpleUserFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  gender\n  countryCode\n  countryPhoneCode\n  phoneNumber\n  mobilePhoneNumber\n  file {\n    __typename\n    ...FileFragment\n  }\n  xcoin\n  currentStep\n  totalStep\n  contacts {\n    __typename\n    ...ContactsFragment\n  }\n}\nfragment ContactsFragment on Contact {\n  __typename\n  id\n  me {\n    __typename\n    ...ContactorFragment\n  }\n  contacter {\n    __typename\n    ...ContactorFragment\n  }\n  phoneNumber\n  extra\n  listOrder\n  file {\n    __typename\n    ...FileFragment\n  }\n  create\n  update\n}\nfragment ContactorFragment on User {\n  __typename\n  id\n  userId\n  name\n  nickname\n  countryCode\n  countryPhoneCode\n  mobilePhoneNumber\n  phoneNumber\n}",
    "removeAlarmReminderM": "mutation removeAlarmReminder($reminderId : String!) {\n  removeAlarmReminder(reminderId: $reminderId)\n}",
    "resetBTWatchM": "mutation ResetBTWatch($uid: String!) {\n  resetBTWatch(uid: $uid)\n}",
    "updateAlarmReminderM": "mutation updateAlarmReminder($reminderId: String!, $occurMin: Int, $start: Int, $end: Int, $weekRepeat: String, $threshold: Int, $hour: Int, $minute: Int, $interval: Int, $status: NormalStatus, $extra: JSON) {\n  updateAlarmReminder(reminderId: reminderId, occurMin: $occurMin, start: $start, end: $end, weekRepeat: $weekRepeat, threshold: $threshold, hour: $hour, minute: $minute, interval: $interval, status: $status, extra: $extra)\n}",
}
