# pyxlpora_api

[![PyPI version](https://badge.fury.io/py/pyxplora-api.svg)](https://badge.fury.io/py/pyxplora-api) [![Downloads](https://pepy.tech/badge/pyxplora-api)](https://pepy.tech/project/pyxplora-api) [![Downloads](https://pepy.tech/badge/pyxplora-api/month)](https://pepy.tech/project/pyxplora-api) [![Downloads](https://pepy.tech/badge/pyxplora-api/week)](https://pepy.tech/project/pyxplora-api)

[![GitHub issues](https://img.shields.io/github/issues/Ludy87/pyxplora_api?style=for-the-badge&logo=appveyor)](https://github.com/Ludy87/pyxplora_api/issues)
[![GitHub forks](https://img.shields.io/github/forks/Ludy87/pyxplora_api?style=for-the-badge&logo=appveyor)](https://github.com/Ludy87/pyxplora_api)
[![GitHub stars](https://img.shields.io/github/stars/Ludy87/pyxplora_api?style=for-the-badge&logo=appveyor)](https://github.com/Ludy87/pyxplora_api)
[![GitHub license](https://img.shields.io/github/license/Ludy87/pyxplora_api?style=for-the-badge&logo=appveyor)](https://github.com/Ludy87/pyxplora_api/blob/main/LICENSE)
[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg?style=for-the-badge&logo=appveyor)](https://github.com/psf/black)

Unofficial python library for the Xplora® API

Diese Projekt ist eine Übersetzung von TypeScript zu Python, mit Erweiterungen.
Ein dank geht an @MiGoller mit seinem Projekt [xplora-api.js](https://github.com/MiGoller/xplora-api.js)


# [Sample for beginning](https://github.com/Ludy87/pyxplora_api/tree/main/sample)

# Usage
```python
from pyxplora_api import pyxplora_api as PXA

xplora = PXA.PyXploraApi(countryCode, phoneNummer, password, local, timeZone)
```

---
# Feature
---

```python
# Watch Info
getUserID()
getUserName()
getUserIcon()
getUserXcoin()
getUserCurrentStep()
getUserTotalStep()
getUserCreate()
getUserUpdate()

# Watch Info
id:list = getWatchUserID()
getContacts(watchID=id)
getWatchUserName(watchID=id)
getWatchXcoin(watchID=id)
getWatchCurrentStep(watchID=id)
getWatchTotalStep(watchID=id)
getWatchAlarm(watchID=id)
getWatchBattery(watchID=id)
getWatchIsCharging(watchID=id)
getWatchOnlineStatus(watchID=id)
getWatchUnReadChatMsgCount(watchID=id)
getWatchChats(watchID=id)

# Watch Location Info
getWatchLastLocation(watchID=id, withAsk: bool=False)
getWatchLocateType(watchID=id)
getWatchLocate(watchID=id)
getWatchIsInSafeZone(watchID=id)
getWatchSafeZoneLabel(watchID=id)
getSafeZones(watchID=id)
trackWatchInterval(watchID=id)
askWatchLocate(watchID=id)

# Feature
schoolSilentMode(watchID=id)
setEnableSilentTime(silentId='', watchID=id)
setDisableSilentTime(silentId='', watchID=id)
setAllEnableSilentTime(watchID=id)
setAllDisableSilentTime(watchID=id)

sentText(text='', watchID=id)
shutdown(watchID=id)
reboot(watchID=id)
```

---
# Country Support

| country name | country code |
|--------------|--------------|
| Denmark | 45 |
| Netherlands | 31 |
| United Kingdom | 44 |
| Spain | 34 |
| Germany | 49 |
| Norway | 47 |
| Sweden | 46 |
| Finland | 358 |
| France | 33 |
| Italy | 39 |
| Switzerland | 41 |
| Austria | 43 |

# Functions
---

## Contacts

| sections | mode | type |
|----------|------|------|
| Contacts | read | list |

---
## Login Account

| sections | mode | type |
|----------|------|------|
| UID               | read | str |
| Username          | read | str |
| Icon              | read | str |
| Xcoin             | read | int |
| current Step      | read | int |
| total Step        | read/write | int |
| time of create    | read | str |
| time of update    | read | str |

---
## Watch

| sections | mode | type | comment |
|----------|------|------|---------|
| UID               | read | str |
| Name              | read | str |
| Xcoin             | read | int |
| current Step      | read | int |
| total Step        | read | int |
| Alarms            | read | list |
| Battery           | read | int |
| Charging          | read | bool |
| Online Status     | read | str |
| Unread Msg Count  | read | int | ?BUG? |
| Chats             | read | list | Don't all chats - confused |
| last locate       | read | dict |
| locate Type       | read | str | GPS/WiFi |
| locate now        | read | dict |
| is in Safezone    | read | bool |
| Safezone Lable    | read | str |
| Safezone          | read/write | list |
| track Interval    | read | int |
| ask Watch Locate  | read | bool |
| silents           | read | list | get all/enable/disable - enable all/disable all |
| sendText          | read | bool | sender: logged User |
| shutdown          | read | bool | only admins |
| reboot            | read | bool | only admins |