"""Load models."""

from .core_models import (
    AddressObject,
    AddressObjectGroup,
    FQDN,
    IPRange,
    Policy,
    PolicyRule,
    ServiceObject,
    ServiceObjectGroup,
    UserObject,
    UserObjectGroup,
    Zone,
)
from .through_models import (
    AddressObjectGroupM2M,
    DestAddrGroupM2M,
    DestAddrM2M,
    FQDNIPAddressM2M,
    PolicyRuleM2M,
    PolicyDeviceM2M,
    PolicyDynamicGroupM2M,
    ServiceObjectGroupM2M,
    SrcAddrGroupM2M,
    SrcAddrM2M,
    SrcUserGroupM2M,
    SrcUserM2M,
    SvcGroupM2M,
    SvcM2M,
    UserObjectGroupM2M,
    ZoneInterfaceM2M,
    ZoneVRFM2M,
)

from .capirca_models import (
    CapircaPolicy,
)

__all__ = (
    "AddressObject",
    "AddressObjectGroup",
    "AddressObjectGroupM2M",
    "CapircaPolicy",
    "DestAddrGroupM2M",
    "DestAddrM2M",
    "FQDN",
    "FQDNIPAddressM2M",
    "IPRange",
    "Policy",
    "PolicyDeviceM2M",
    "PolicyDynamicGroupM2M",
    "PolicyRule",
    "PolicyRuleM2M",
    "ServiceObject",
    "ServiceObjectGroup",
    "ServiceObjectGroupM2M",
    "SrcAddrGroupM2M",
    "SrcAddrM2M",
    "SrcUserGroupM2M",
    "SrcUserM2M",
    "SvcGroupM2M",
    "SvcM2M",
    "UserObject",
    "UserObjectGroup",
    "UserObjectGroupM2M",
    "Zone",
    "ZoneInterfaceM2M",
    "ZoneVRFM2M",
)
