import unittest
from sys import path
path.append('../src/')
from secp256k1 import secp256k1, CurvePoint

s = secp256k1()

g = CurvePoint(0x79BE667EF9DCBBAC55A06295CE870B07029BFCDB2DCE28D959F2815B16F81798, 0x483ADA7726A3C4655DA4FBFC0E1108A8FD17B448A68554199C47D08FFB10D4B8)

g2 = CurvePoint(0xC6047F9441ED7D6D3045406E95C07CD85C778E4B8CEF3CA7ABAC09B95C709EE5, 0x1AE168FEA63DC339A3C58419466CEAEEF7F632653266D0E1236431A950CFE52A)

g3 = CurvePoint(0xF9308A019258C31049344F85F89D5229B531C845836F99B08601F113BCE036F9, 0x388F7B0F632DE8140FE337E62A37F3566500A99934C2231B6CB9FD7584B8E672)

g4 = CurvePoint(0xE493DBF1C10D80F3581E4904930B1404CC6C13900EE0758474FA94ABE8C4CD13, 0x51ED993EA0D455B75642E2098EA51448D967AE33BFBDFE40CFE97BDC47739922)

g5 = CurvePoint(0x2F8BDE4D1A07209355B4A7250A5C5128E88B84BDDC619AB7CBA8D569B240EFE4, 0xD8AC222636E5E3D6D4DBA9DDA6C9C426F788271BAB0D6840DCA87D3AA6AC62D6)


class TestEllipticPointDouble(unittest.TestCase):

	def test_double_1(self):
		eGx = int('C6047F9441ED7D6D3045406E95C07CD85C778E4B8CEF3CA7ABAC09B95C709EE5', 16)
		eGy = int('1AE168FEA63DC339A3C58419466CEAEEF7F632653266D0E1236431A950CFE52A', 16)		
		self.assertEqual(eGx, g.double().x)

	def test_double_2(self):
		eGx = int('E493DBF1C10D80F3581E4904930B1404CC6C13900EE0758474FA94ABE8C4CD13', 16)
		eGy = int('51ED993EA0D455B75642E2098EA51448D967AE33BFBDFE40CFE97BDC47739922', 16)
		self.assertEqual(eGx, g2.double().x)

	def test_double_3(self):
		eGx = int('FFF97BD5755EEEA420453A14355235D382F6472F8568A18B2F057A1460297556', 16)
		eGy = int('AE12777AACFBB620F3BE96017F45C560DE80F0F6518FE4A03C870C36B075F297', 16)
		self.assertEqual(eGx, g3.double().x)
	
	def test_double_4(self):
		eGx = int('2F01E5E15CCA351DAFF3843FB70F3C2F0A1BDD05E5AF888A67784EF3E10A2A01', 16)
		eGy = int('5C4DA8A741539949293D082A132D13B4C2E213D6BA5B7617B5DA2CB76CBDE904', 16)
		self.assertEqual(eGx, g4.double().x)
	
	def test_double_5(self):
		eGx = int('A0434D9E47F3C86235477C7B1AE6AE5D3442D49B1943C2B752A68E2A47E247C7', 16)
		eGy = int('893ABA425419BC27A3B6C7E693A24C696F794C2ED877A1593CBEE53B037368D7', 16)
		self.assertEqual(eGx, g5.double().x)


if __name__ == "__main__":
	unittest.main()
