# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel


class QueryIncidentTracingSubNodesCountRequest(TeaModel):
    def __init__(self, vertex_id_and_type_list=None):
        self.vertex_id_and_type_list = vertex_id_and_type_list  # type: list[list[str]]

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryIncidentTracingSubNodesCountRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.vertex_id_and_type_list is not None:
            result['VertexIdAndTypeList'] = self.vertex_id_and_type_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('VertexIdAndTypeList') is not None:
            self.vertex_id_and_type_list = m.get('VertexIdAndTypeList')
        return self


class AddCheckInstanceResultWhiteListRequest(TeaModel):
    def __init__(self, check_group_id=None, check_id=None, instance_ids=None):
        # The ID of the group to which the check item belongs.
        self.check_group_id = check_group_id  # type: str
        # The ID of the check item.
        self.check_id = check_id  # type: long
        # The instance IDs of assets.
        self.instance_ids = instance_ids  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddCheckInstanceResultWhiteListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_group_id is not None:
            result['CheckGroupId'] = self.check_group_id
        if self.check_id is not None:
            result['CheckId'] = self.check_id
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CheckGroupId') is not None:
            self.check_group_id = m.get('CheckGroupId')
        if m.get('CheckId') is not None:
            self.check_id = m.get('CheckId')
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        return self


class AddCheckInstanceResultWhiteListResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        # The adding result.
        self.data = data  # type: dict[str, any]
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddCheckInstanceResultWhiteListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddCheckInstanceResultWhiteListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddCheckInstanceResultWhiteListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddCheckInstanceResultWhiteListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddCheckInstanceResultWhiteListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddCheckResultWhiteListRequest(TeaModel):
    def __init__(self, check_ids=None):
        # The IDs of the check items.
        self.check_ids = check_ids  # type: list[long]

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddCheckResultWhiteListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_ids is not None:
            result['CheckIds'] = self.check_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CheckIds') is not None:
            self.check_ids = m.get('CheckIds')
        return self


class AddCheckResultWhiteListResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        # The data returned.
        self.data = data  # type: dict[str, any]
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddCheckResultWhiteListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddCheckResultWhiteListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddCheckResultWhiteListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddCheckResultWhiteListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddCheckResultWhiteListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddClientUserDefineRuleRequest(TeaModel):
    def __init__(self, action_type=None, cmdline=None, file_path=None, ip=None, md_5list=None, name=None,
                 new_file_path=None, parent_cmdline=None, parent_proc_path=None, platform=None, port=None, port_str=None,
                 proc_path=None, registry_content=None, registry_key=None, type=None):
        # The action of the custom defense rule. Valid values:
        # 
        # *   **0**: allow
        # *   **1**: block
        self.action_type = action_type  # type: int
        # The command line.
        self.cmdline = cmdline  # type: str
        # The file path.
        self.file_path = file_path  # type: str
        # The IP address.
        self.ip = ip  # type: str
        # The hash values of processes.
        self.md_5list = md_5list  # type: str
        # The name of the custom defense rule.
        self.name = name  # type: str
        # The new file path after the file is renamed.
        self.new_file_path = new_file_path  # type: str
        # The parent command line.
        self.parent_cmdline = parent_cmdline  # type: str
        # The path to the parent process.
        self.parent_proc_path = parent_proc_path  # type: str
        # The type of the operating system. Valid values:
        # 
        # *   **windows**: Windows
        # *   **linux**: Linux
        # *   **all**: all types
        self.platform = platform  # type: str
        # The port number. This parameter is deprecated.
        self.port = port  # type: int
        # The port number. Valid values: **1 to 65535**.
        self.port_str = port_str  # type: str
        # The path to the process.
        self.proc_path = proc_path  # type: str
        # The registry value.
        self.registry_content = registry_content  # type: str
        # The registry key.
        self.registry_key = registry_key  # type: str
        # The type of the custom defense rule. Valid values:
        # 
        # *   **1**: Process hash
        # *   **2**: Command line
        # *   **3**: Process Network
        # *   **4**: File Read and Write
        # *   **5**: Operation on Registry
        # *   **6**: Dynamic-link Library Loading
        # *   **7**: File Renaming
        self.type = type  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddClientUserDefineRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action_type is not None:
            result['ActionType'] = self.action_type
        if self.cmdline is not None:
            result['Cmdline'] = self.cmdline
        if self.file_path is not None:
            result['FilePath'] = self.file_path
        if self.ip is not None:
            result['IP'] = self.ip
        if self.md_5list is not None:
            result['Md5List'] = self.md_5list
        if self.name is not None:
            result['Name'] = self.name
        if self.new_file_path is not None:
            result['NewFilePath'] = self.new_file_path
        if self.parent_cmdline is not None:
            result['ParentCmdline'] = self.parent_cmdline
        if self.parent_proc_path is not None:
            result['ParentProcPath'] = self.parent_proc_path
        if self.platform is not None:
            result['Platform'] = self.platform
        if self.port is not None:
            result['Port'] = self.port
        if self.port_str is not None:
            result['PortStr'] = self.port_str
        if self.proc_path is not None:
            result['ProcPath'] = self.proc_path
        if self.registry_content is not None:
            result['RegistryContent'] = self.registry_content
        if self.registry_key is not None:
            result['RegistryKey'] = self.registry_key
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ActionType') is not None:
            self.action_type = m.get('ActionType')
        if m.get('Cmdline') is not None:
            self.cmdline = m.get('Cmdline')
        if m.get('FilePath') is not None:
            self.file_path = m.get('FilePath')
        if m.get('IP') is not None:
            self.ip = m.get('IP')
        if m.get('Md5List') is not None:
            self.md_5list = m.get('Md5List')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NewFilePath') is not None:
            self.new_file_path = m.get('NewFilePath')
        if m.get('ParentCmdline') is not None:
            self.parent_cmdline = m.get('ParentCmdline')
        if m.get('ParentProcPath') is not None:
            self.parent_proc_path = m.get('ParentProcPath')
        if m.get('Platform') is not None:
            self.platform = m.get('Platform')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('PortStr') is not None:
            self.port_str = m.get('PortStr')
        if m.get('ProcPath') is not None:
            self.proc_path = m.get('ProcPath')
        if m.get('RegistryContent') is not None:
            self.registry_content = m.get('RegistryContent')
        if m.get('RegistryKey') is not None:
            self.registry_key = m.get('RegistryKey')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class AddClientUserDefineRuleResponseBodyUserDefineRuleAddResult(TeaModel):
    def __init__(self, id=None, platform=None, switch_id=None):
        # The ID of the rule.
        self.id = id  # type: long
        # The type of the operating system. Valid values:
        # 
        # *   **windows**: Windows
        # *   **linux**: Linux
        # *   **all**: all types
        self.platform = platform  # type: str
        # The switch ID of the custom defense rule.
        self.switch_id = switch_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddClientUserDefineRuleResponseBodyUserDefineRuleAddResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.platform is not None:
            result['Platform'] = self.platform
        if self.switch_id is not None:
            result['SwitchId'] = self.switch_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Platform') is not None:
            self.platform = m.get('Platform')
        if m.get('SwitchId') is not None:
            self.switch_id = m.get('SwitchId')
        return self


class AddClientUserDefineRuleResponseBody(TeaModel):
    def __init__(self, request_id=None, user_define_rule_add_result=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The identifier of the custom defense rule.
        self.user_define_rule_add_result = user_define_rule_add_result  # type: AddClientUserDefineRuleResponseBodyUserDefineRuleAddResult

    def validate(self):
        if self.user_define_rule_add_result:
            self.user_define_rule_add_result.validate()

    def to_map(self):
        _map = super(AddClientUserDefineRuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.user_define_rule_add_result is not None:
            result['UserDefineRuleAddResult'] = self.user_define_rule_add_result.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UserDefineRuleAddResult') is not None:
            temp_model = AddClientUserDefineRuleResponseBodyUserDefineRuleAddResult()
            self.user_define_rule_add_result = temp_model.from_map(m['UserDefineRuleAddResult'])
        return self


class AddClientUserDefineRuleResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddClientUserDefineRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddClientUserDefineRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddClientUserDefineRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddInstallCodeRequest(TeaModel):
    def __init__(self, expired_date=None, group_id=None, only_image=None, os=None, vendor_name=None):
        # The validity period of the installation command. The value is a 13-digit timestamp.
        # 
        # >  The installation command is valid only within the validity period. An expired installation command cannot be used to install the Security Center agent.
        self.expired_date = expired_date  # type: long
        # The ID of the asset group to which the you want to add the asset.
        # 
        # >  You can call the [DescribeAllGroups](~~describeallgroups~~) operation to query the IDs of asset groups.
        self.group_id = group_id  # type: long
        # Specifies whether to create an image. Default value: **false**. Valid values:
        # 
        # *   **false**: does not create an image.
        # *   **true**: creates an image.
        self.only_image = only_image  # type: bool
        # The operating system of the instance. Default value: **linux**. Valid values:
        # 
        # *   **linux**\
        # *   **windows**\
        # *   **windows-2003**\
        self.os = os  # type: str
        # The name of the service provider for the asset. Default value: **ALIYUN**.
        # 
        # >  You can call the [DescribeVendorList](~~DescribeVendorList~~) operation to query the names of service providers.
        self.vendor_name = vendor_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddInstallCodeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expired_date is not None:
            result['ExpiredDate'] = self.expired_date
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.only_image is not None:
            result['OnlyImage'] = self.only_image
        if self.os is not None:
            result['Os'] = self.os
        if self.vendor_name is not None:
            result['VendorName'] = self.vendor_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ExpiredDate') is not None:
            self.expired_date = m.get('ExpiredDate')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('OnlyImage') is not None:
            self.only_image = m.get('OnlyImage')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('VendorName') is not None:
            self.vendor_name = m.get('VendorName')
        return self


class AddInstallCodeResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddInstallCodeResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddInstallCodeResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddInstallCodeResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddInstallCodeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddInstallCodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddPrivateRegistryRequest(TeaModel):
    def __init__(self, domain_name=None, extra_param=None, net_type=None, password=None, protocol_type=None,
                 registry_host_ip=None, registry_region_id=None, registry_type=None, registry_version=None, trans_per_hour=None,
                 user_name=None, vpc_id=None):
        self.domain_name = domain_name  # type: str
        self.extra_param = extra_param  # type: str
        self.net_type = net_type  # type: long
        self.password = password  # type: str
        self.protocol_type = protocol_type  # type: long
        self.registry_host_ip = registry_host_ip  # type: str
        self.registry_region_id = registry_region_id  # type: str
        self.registry_type = registry_type  # type: str
        self.registry_version = registry_version  # type: str
        self.trans_per_hour = trans_per_hour  # type: int
        self.user_name = user_name  # type: str
        self.vpc_id = vpc_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddPrivateRegistryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.extra_param is not None:
            result['ExtraParam'] = self.extra_param
        if self.net_type is not None:
            result['NetType'] = self.net_type
        if self.password is not None:
            result['Password'] = self.password
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.registry_host_ip is not None:
            result['RegistryHostIp'] = self.registry_host_ip
        if self.registry_region_id is not None:
            result['RegistryRegionId'] = self.registry_region_id
        if self.registry_type is not None:
            result['RegistryType'] = self.registry_type
        if self.registry_version is not None:
            result['RegistryVersion'] = self.registry_version
        if self.trans_per_hour is not None:
            result['TransPerHour'] = self.trans_per_hour
        if self.user_name is not None:
            result['UserName'] = self.user_name
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('ExtraParam') is not None:
            self.extra_param = m.get('ExtraParam')
        if m.get('NetType') is not None:
            self.net_type = m.get('NetType')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('RegistryHostIp') is not None:
            self.registry_host_ip = m.get('RegistryHostIp')
        if m.get('RegistryRegionId') is not None:
            self.registry_region_id = m.get('RegistryRegionId')
        if m.get('RegistryType') is not None:
            self.registry_type = m.get('RegistryType')
        if m.get('RegistryVersion') is not None:
            self.registry_version = m.get('RegistryVersion')
        if m.get('TransPerHour') is not None:
            self.trans_per_hour = m.get('TransPerHour')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class AddPrivateRegistryResponseBodyData(TeaModel):
    def __init__(self, ali_uid=None, domain_name=None, id=None, net_type=None, password=None, protocol_type=None,
                 region_id=None, registry_host_ip=None, registry_type=None, registry_version=None, token=None,
                 trans_per_hour=None, user_name=None, vpc_id=None):
        self.ali_uid = ali_uid  # type: long
        self.domain_name = domain_name  # type: str
        self.id = id  # type: long
        self.net_type = net_type  # type: long
        self.password = password  # type: str
        self.protocol_type = protocol_type  # type: long
        self.region_id = region_id  # type: str
        self.registry_host_ip = registry_host_ip  # type: str
        self.registry_type = registry_type  # type: str
        self.registry_version = registry_version  # type: str
        self.token = token  # type: str
        self.trans_per_hour = trans_per_hour  # type: int
        self.user_name = user_name  # type: str
        self.vpc_id = vpc_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddPrivateRegistryResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ali_uid is not None:
            result['AliUid'] = self.ali_uid
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.id is not None:
            result['Id'] = self.id
        if self.net_type is not None:
            result['NetType'] = self.net_type
        if self.password is not None:
            result['Password'] = self.password
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.registry_host_ip is not None:
            result['RegistryHostIp'] = self.registry_host_ip
        if self.registry_type is not None:
            result['RegistryType'] = self.registry_type
        if self.registry_version is not None:
            result['RegistryVersion'] = self.registry_version
        if self.token is not None:
            result['Token'] = self.token
        if self.trans_per_hour is not None:
            result['TransPerHour'] = self.trans_per_hour
        if self.user_name is not None:
            result['UserName'] = self.user_name
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AliUid') is not None:
            self.ali_uid = m.get('AliUid')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('NetType') is not None:
            self.net_type = m.get('NetType')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RegistryHostIp') is not None:
            self.registry_host_ip = m.get('RegistryHostIp')
        if m.get('RegistryType') is not None:
            self.registry_type = m.get('RegistryType')
        if m.get('RegistryVersion') is not None:
            self.registry_version = m.get('RegistryVersion')
        if m.get('Token') is not None:
            self.token = m.get('Token')
        if m.get('TransPerHour') is not None:
            self.trans_per_hour = m.get('TransPerHour')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class AddPrivateRegistryResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: AddPrivateRegistryResponseBodyData
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(AddPrivateRegistryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = AddPrivateRegistryResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddPrivateRegistryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddPrivateRegistryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddPrivateRegistryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddPrivateRegistryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddTagWithUuidRequest(TeaModel):
    def __init__(self, tag_name=None, uuid_list=None):
        # The name of the tag.
        self.tag_name = tag_name  # type: str
        # The UUIDs of the servers. Separate multiple UUIDs with commas (,).
        # 
        # > You can call the [DescribeCloudCenterInstances](~~DescribeCloudCenterInstances~~) operation to query the UUIDs of servers.
        self.uuid_list = uuid_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddTagWithUuidRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_name is not None:
            result['TagName'] = self.tag_name
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagName') is not None:
            self.tag_name = m.get('TagName')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class AddTagWithUuidResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddTagWithUuidResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddTagWithUuidResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddTagWithUuidResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddTagWithUuidResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddTagWithUuidResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddUninstallClientsByUuidsRequest(TeaModel):
    def __init__(self, call_method=None, feedback=None, region=None, source_ip=None, uuids=None):
        # The method name. Default value: init.
        self.call_method = call_method  # type: str
        # The feedback.
        self.feedback = feedback  # type: str
        # The region in which the server resides.
        self.region = region  # type: str
        # The source IP address of the request. You do not need to specify this parameter. It is automatically obtained by the system.
        self.source_ip = source_ip  # type: str
        # The UUID of the server that you want to unbind. Separate multiple UUIDs with commas (,).
        # 
        # >  You can call the [DescribeCloudCenterInstances](~~141932~~) operation to query the UUIDs of servers.
        self.uuids = uuids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddUninstallClientsByUuidsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_method is not None:
            result['CallMethod'] = self.call_method
        if self.feedback is not None:
            result['Feedback'] = self.feedback
        if self.region is not None:
            result['Region'] = self.region
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallMethod') is not None:
            self.call_method = m.get('CallMethod')
        if m.get('Feedback') is not None:
            self.feedback = m.get('Feedback')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        return self


class AddUninstallClientsByUuidsResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddUninstallClientsByUuidsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddUninstallClientsByUuidsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddUninstallClientsByUuidsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddUninstallClientsByUuidsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddUninstallClientsByUuidsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddVpcHoneyPotRequest(TeaModel):
    def __init__(self, vpc_id=None):
        # The ID of the virtual private cloud (VPC) in which you want to create a honeypot.
        # 
        # > You can call the [DescribeVpcList](~~DescribeVpcList~~) operation to obtain the VPC ID. The VPC ID is the value of the InstanceId parameter.
        self.vpc_id = vpc_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddVpcHoneyPotRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class AddVpcHoneyPotResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddVpcHoneyPotResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddVpcHoneyPotResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddVpcHoneyPotResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddVpcHoneyPotResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddVpcHoneyPotResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AdvanceSecurityEventOperationsRequest(TeaModel):
    def __init__(self, event_name=None, event_type=None, resource_owner_id=None, rule_id=None):
        self.event_name = event_name  # type: str
        self.event_type = event_type  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.rule_id = rule_id  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(AdvanceSecurityEventOperationsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_name is not None:
            result['EventName'] = self.event_name
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EventName') is not None:
            self.event_name = m.get('EventName')
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class AdvanceSecurityEventOperationsResponseBodySecurityEventOperationsResponseMarkField(TeaModel):
    def __init__(self, filed_alias_name=None, filed_name=None, mark_mis_type=None, mark_mis_value=None,
                 supported_mis_type=None):
        self.filed_alias_name = filed_alias_name  # type: str
        self.filed_name = filed_name  # type: str
        self.mark_mis_type = mark_mis_type  # type: str
        self.mark_mis_value = mark_mis_value  # type: str
        self.supported_mis_type = supported_mis_type  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(AdvanceSecurityEventOperationsResponseBodySecurityEventOperationsResponseMarkField, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.filed_alias_name is not None:
            result['FiledAliasName'] = self.filed_alias_name
        if self.filed_name is not None:
            result['FiledName'] = self.filed_name
        if self.mark_mis_type is not None:
            result['MarkMisType'] = self.mark_mis_type
        if self.mark_mis_value is not None:
            result['MarkMisValue'] = self.mark_mis_value
        if self.supported_mis_type is not None:
            result['SupportedMisType'] = self.supported_mis_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FiledAliasName') is not None:
            self.filed_alias_name = m.get('FiledAliasName')
        if m.get('FiledName') is not None:
            self.filed_name = m.get('FiledName')
        if m.get('MarkMisType') is not None:
            self.mark_mis_type = m.get('MarkMisType')
        if m.get('MarkMisValue') is not None:
            self.mark_mis_value = m.get('MarkMisValue')
        if m.get('SupportedMisType') is not None:
            self.supported_mis_type = m.get('SupportedMisType')
        return self


class AdvanceSecurityEventOperationsResponseBodySecurityEventOperationsResponseMarkFieldsSource(TeaModel):
    def __init__(self, filed_alias_name=None, filed_name=None, mark_mis_value=None, supported_mis_type=None):
        self.filed_alias_name = filed_alias_name  # type: str
        self.filed_name = filed_name  # type: str
        self.mark_mis_value = mark_mis_value  # type: str
        self.supported_mis_type = supported_mis_type  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(AdvanceSecurityEventOperationsResponseBodySecurityEventOperationsResponseMarkFieldsSource, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.filed_alias_name is not None:
            result['FiledAliasName'] = self.filed_alias_name
        if self.filed_name is not None:
            result['FiledName'] = self.filed_name
        if self.mark_mis_value is not None:
            result['MarkMisValue'] = self.mark_mis_value
        if self.supported_mis_type is not None:
            result['SupportedMisType'] = self.supported_mis_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FiledAliasName') is not None:
            self.filed_alias_name = m.get('FiledAliasName')
        if m.get('FiledName') is not None:
            self.filed_name = m.get('FiledName')
        if m.get('MarkMisValue') is not None:
            self.mark_mis_value = m.get('MarkMisValue')
        if m.get('SupportedMisType') is not None:
            self.supported_mis_type = m.get('SupportedMisType')
        return self


class AdvanceSecurityEventOperationsResponseBodySecurityEventOperationsResponse(TeaModel):
    def __init__(self, mark_field=None, mark_fields_source=None, operation_code=None, operation_params=None,
                 user_can_operate=None):
        self.mark_field = mark_field  # type: list[AdvanceSecurityEventOperationsResponseBodySecurityEventOperationsResponseMarkField]
        self.mark_fields_source = mark_fields_source  # type: list[AdvanceSecurityEventOperationsResponseBodySecurityEventOperationsResponseMarkFieldsSource]
        self.operation_code = operation_code  # type: str
        self.operation_params = operation_params  # type: str
        self.user_can_operate = user_can_operate  # type: bool

    def validate(self):
        if self.mark_field:
            for k in self.mark_field:
                if k:
                    k.validate()
        if self.mark_fields_source:
            for k in self.mark_fields_source:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(AdvanceSecurityEventOperationsResponseBodySecurityEventOperationsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MarkField'] = []
        if self.mark_field is not None:
            for k in self.mark_field:
                result['MarkField'].append(k.to_map() if k else None)
        result['MarkFieldsSource'] = []
        if self.mark_fields_source is not None:
            for k in self.mark_fields_source:
                result['MarkFieldsSource'].append(k.to_map() if k else None)
        if self.operation_code is not None:
            result['OperationCode'] = self.operation_code
        if self.operation_params is not None:
            result['OperationParams'] = self.operation_params
        if self.user_can_operate is not None:
            result['UserCanOperate'] = self.user_can_operate
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.mark_field = []
        if m.get('MarkField') is not None:
            for k in m.get('MarkField'):
                temp_model = AdvanceSecurityEventOperationsResponseBodySecurityEventOperationsResponseMarkField()
                self.mark_field.append(temp_model.from_map(k))
        self.mark_fields_source = []
        if m.get('MarkFieldsSource') is not None:
            for k in m.get('MarkFieldsSource'):
                temp_model = AdvanceSecurityEventOperationsResponseBodySecurityEventOperationsResponseMarkFieldsSource()
                self.mark_fields_source.append(temp_model.from_map(k))
        if m.get('OperationCode') is not None:
            self.operation_code = m.get('OperationCode')
        if m.get('OperationParams') is not None:
            self.operation_params = m.get('OperationParams')
        if m.get('UserCanOperate') is not None:
            self.user_can_operate = m.get('UserCanOperate')
        return self


class AdvanceSecurityEventOperationsResponseBody(TeaModel):
    def __init__(self, request_id=None, security_event_operations_response=None):
        self.request_id = request_id  # type: str
        self.security_event_operations_response = security_event_operations_response  # type: list[AdvanceSecurityEventOperationsResponseBodySecurityEventOperationsResponse]

    def validate(self):
        if self.security_event_operations_response:
            for k in self.security_event_operations_response:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(AdvanceSecurityEventOperationsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['SecurityEventOperationsResponse'] = []
        if self.security_event_operations_response is not None:
            for k in self.security_event_operations_response:
                result['SecurityEventOperationsResponse'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.security_event_operations_response = []
        if m.get('SecurityEventOperationsResponse') is not None:
            for k in m.get('SecurityEventOperationsResponse'):
                temp_model = AdvanceSecurityEventOperationsResponseBodySecurityEventOperationsResponse()
                self.security_event_operations_response.append(temp_model.from_map(k))
        return self


class AdvanceSecurityEventOperationsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AdvanceSecurityEventOperationsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AdvanceSecurityEventOperationsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AdvanceSecurityEventOperationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchOperateCommonOverallConfigRequest(TeaModel):
    def __init__(self, config=None, type_list=None):
        # The status of the feature. Valid values:
        # 
        # *   **on**: enabled
        # *   **off**: disabled
        self.config = config  # type: str
        # The type of the feature in proactive defense. Valid values:
        # 
        # *   **kdump_switch**: Active defense experience optimization
        # *   **threat_detect**: Dynamic adaptive threat detection capability
        # *   **suspicious_aggregation**: Alert Association
        # *   **alidetect**: File Test
        # *   **USER-ENABLE-SWITCH-TYPE\_38857**: Entrance service execution high-risk operation (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE\_50858**: Web service performs high-risk operations (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE\_50859**: Entrance service execution suspicious operation (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE\_50862**: Cloud Assistant Advanced Protection (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE\_50867**: Create malicious files (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE\_50868**: Create suspicious files (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE\_64025**: Ingress service execute command \[enhanced mode] (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE\_51229**: Browser service execution a high-risk operation (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE\_51230**: Entrance service execution suspicious operation (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE\_51232**: System processes execution high-risk operations (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE\_51233**: Java service execution high-risk operations (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE\_51234**: Office components execution high-risk operations (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE\_51235**: Web service performs high-risk operations (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE\_52820**: Create malicious files (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE\_52826**: Entrance service execution high-risk operation (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE\_55251**: Database services execution high-risk operations (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE\_63725**: Ingress service implants suspicious script/binary file (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE\_3277**: Suspicious process startup (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE\_50983**: obfuscated command (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE\_51200**: Command line download and run malicious files (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE\_71131**: Ingress service executes sequence of suspicious behavior (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE\_51225**: Powershell executes high-risk commands (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE\_51226**: Powershell execute suspicious command (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE\_52821**: Suspicious process startup (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE\_57242**: Malicious command execution (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE\_57340**: Command line download and run malicious files (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE\_39659**: Sensitive Registry Key Protection (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE\_52816**: high-risk account manipulation behavior (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE\_54365**: Create service autorun item (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE\_54366**: Create high-risk autorun item (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE\_54367**: Create scheduled task autorun item (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE\_54368**: Create registry autorun item (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE\_54369**: Create WMI autorun item (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE\_50869**: Unauthorized execution of high-risk orders (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE\_53272**: Exploiting Kernel Vulnerabilities to Elevate Privileges (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE\_54395**: Unauthorized reading and writing of sensitive files (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE\_57897**: suspected privilege escalation (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE\_52825**: Unauthorized execution of high-risk orders (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE\_5507**: malicious drivers (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE\_50876**: Against security software (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE\_53168**: process debugging (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE\_54699**: Hijack dynamic link library (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE\_62981**: Bypassing security monitoring (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE\_52815**: Load high-risk drivers (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE\_52823**: Running high-risk ARK tools (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE\_54373**: Against security software (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE\_54374**: Intrusion trace cleanup (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE\_54265**: Hijacking the PAM Module (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE\_54953**: Hashdump Attack (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE\_54383**: MimiKatz Credential Stealing (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE\_54384**: Hashdump Attack (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE\_50861**: Information detection (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE\_52818**: Information detection (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE\_54034**: Intranet scan (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE\_51228**: High-risk lateral penetration tools (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE\_50870**: Rebound Shell (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE\_50873**: WebShell execute command
        # *   **USER-ENABLE-SWITCH-TYPE\_51236**: Rebound Shell (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE\_50877**: Malicious soft communication (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE\_50884**: Suspicious worm script behavior (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE\_50885**: malicious script behavior (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE\_51201**: ransomware (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE\_51202**: Suspected Extortion (Linux)
        # *   **USER-ENABLE-SWITCH-TYPE\_52827**: ransomware (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE\_52828**: Suspected Extortion (Windows)
        # *   **USER-ENABLE-SWITCH-TYPE\_52829**: delete system backup behavior (Windows)
        self.type_list = type_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchOperateCommonOverallConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config is not None:
            result['Config'] = self.config
        if self.type_list is not None:
            result['TypeList'] = self.type_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Config') is not None:
            self.config = m.get('Config')
        if m.get('TypeList') is not None:
            self.type_list = m.get('TypeList')
        return self


class BatchOperateCommonOverallConfigResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchOperateCommonOverallConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class BatchOperateCommonOverallConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchOperateCommonOverallConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchOperateCommonOverallConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchOperateCommonOverallConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BindAuthToMachineRequest(TeaModel):
    def __init__(self, auth_version=None, auto_bind=None, bind=None, bind_all=None, criteria=None, logical_exp=None,
                 un_bind=None):
        # The edition of Security Center. Valid values:
        # 
        # *   **6**: Anti-virus edition
        # *   **5**: Advanced edition
        # *   **3**: Enterprise edition
        # *   **7**: Ultimate edition
        # *   **10**: Value-added Plan edition
        self.auth_version = auth_version  # type: int
        # Specifies whether to automatically bind servers to Security Center. Valid values:
        # 
        # *   **0**: no
        # *   **1**: yes
        self.auto_bind = auto_bind  # type: int
        # The UUIDs of the servers that you want to bind to Security Center.
        # 
        # >  You must specify at least one of the **Bind** and **UnBind** parameters.
        self.bind = bind  # type: list[str]
        # Specifies whether to bind all servers to Security Center. Default value: **false**. Valid values:
        # 
        # *   **true**: yes
        # *   **false**: no
        self.bind_all = bind_all  # type: bool
        # The search conditions that are used to filter servers. The value of this parameter is in the JSON format and is case-sensitive.
        # 
        # >  A search condition can be an instance ID, instance name, virtual private cloud (VPC) ID, region, or public IP address. You can call the [DescribeCriteria](~~DescribeCriteria~~) operation to query the supported search conditions.
        self.criteria = criteria  # type: str
        # The logical relationship among multiple search conditions. Valid values:
        # 
        # *   **OR**: Search conditions are evaluated by using a logical **OR**.
        # *   **AND**: Search conditions are evaluated by using a logical **AND**.
        self.logical_exp = logical_exp  # type: str
        # The UUIDs of the servers that you want to unbind from Security Center.
        # 
        # >  You must specify at least one of the **Bind** and **UnBind** parameters.
        self.un_bind = un_bind  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(BindAuthToMachineRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_version is not None:
            result['AuthVersion'] = self.auth_version
        if self.auto_bind is not None:
            result['AutoBind'] = self.auto_bind
        if self.bind is not None:
            result['Bind'] = self.bind
        if self.bind_all is not None:
            result['BindAll'] = self.bind_all
        if self.criteria is not None:
            result['Criteria'] = self.criteria
        if self.logical_exp is not None:
            result['LogicalExp'] = self.logical_exp
        if self.un_bind is not None:
            result['UnBind'] = self.un_bind
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AuthVersion') is not None:
            self.auth_version = m.get('AuthVersion')
        if m.get('AutoBind') is not None:
            self.auto_bind = m.get('AutoBind')
        if m.get('Bind') is not None:
            self.bind = m.get('Bind')
        if m.get('BindAll') is not None:
            self.bind_all = m.get('BindAll')
        if m.get('Criteria') is not None:
            self.criteria = m.get('Criteria')
        if m.get('LogicalExp') is not None:
            self.logical_exp = m.get('LogicalExp')
        if m.get('UnBind') is not None:
            self.un_bind = m.get('UnBind')
        return self


class BindAuthToMachineResponseBody(TeaModel):
    def __init__(self, bind_count=None, insufficient_core_count=None, insufficient_ecs_count=None, request_id=None,
                 result_code=None, un_bind_count=None):
        # The number of bound servers.
        self.bind_count = bind_count  # type: int
        # The shortage in the quota for cores of servers that can be protected.
        self.insufficient_core_count = insufficient_core_count  # type: int
        # The shortage in the quota for servers that can be protected.
        self.insufficient_ecs_count = insufficient_ecs_count  # type: int
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id  # type: str
        # The status code that indicates the result. Valid values:
        # 
        # *   **0**: The servers are bound to or unbound from Security Center.
        # *   **1**: The values that you specified for the parameters are invalid.
        # *   **2**: The quota for servers that can be protected is insufficient.
        # *   **3**: The quota for cores of servers that can be protected is insufficient.
        self.result_code = result_code  # type: int
        # The number of unbound servers.
        self.un_bind_count = un_bind_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(BindAuthToMachineResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bind_count is not None:
            result['BindCount'] = self.bind_count
        if self.insufficient_core_count is not None:
            result['InsufficientCoreCount'] = self.insufficient_core_count
        if self.insufficient_ecs_count is not None:
            result['InsufficientEcsCount'] = self.insufficient_ecs_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result_code is not None:
            result['ResultCode'] = self.result_code
        if self.un_bind_count is not None:
            result['UnBindCount'] = self.un_bind_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BindCount') is not None:
            self.bind_count = m.get('BindCount')
        if m.get('InsufficientCoreCount') is not None:
            self.insufficient_core_count = m.get('InsufficientCoreCount')
        if m.get('InsufficientEcsCount') is not None:
            self.insufficient_ecs_count = m.get('InsufficientEcsCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResultCode') is not None:
            self.result_code = m.get('ResultCode')
        if m.get('UnBindCount') is not None:
            self.un_bind_count = m.get('UnBindCount')
        return self


class BindAuthToMachineResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BindAuthToMachineResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BindAuthToMachineResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BindAuthToMachineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelOnceTaskRequest(TeaModel):
    def __init__(self, task_id=None):
        self.task_id = task_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelOnceTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class CancelOnceTaskResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelOnceTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CancelOnceTaskResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CancelOnceTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CancelOnceTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelOnceTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ChangeCheckConfigRequest(TeaModel):
    def __init__(self, end_time=None, region_id=None, standard_ids=None, start_time=None):
        # The end time of the check. The value specifies a point in time in a day. The time period that is specified by the start time and end time must be one of the following time periods:
        # 
        # *   **00:00 to 06:00:** If you set the StartTime parameter to 0, you must set the EndTime parameter to 6.
        # *   **06:00 to 12:00**: If you set the StartTime parameter to 6, you must set the EndTime parameter to 12.
        # *   **12:00 to 18:00**: If you set the StartTime parameter to 12, you must set the EndTime parameter to 18.
        # *  **18:00 to 24:00:** If you set the StartTime parameter to 18, you must set the EndTime parameter to 24.
        self.end_time = end_time  # type: int
        # The region ID of the bastion host to query.
        # 
        # >  For more information about the mapping between region IDs and region names, see [Regions and zones](~~40654~~).
        self.region_id = region_id  # type: str
        # An array that consists of the information about the check item.
        self.standard_ids = standard_ids  # type: list[long]
        # The start time of the check. The value specifies a point in time in a day.
        self.start_time = start_time  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ChangeCheckConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.standard_ids is not None:
            result['StandardIds'] = self.standard_ids
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StandardIds') is not None:
            self.standard_ids = m.get('StandardIds')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class ChangeCheckConfigResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ChangeCheckConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ChangeCheckConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ChangeCheckConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ChangeCheckConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ChangeCheckConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ChangeCheckCustomConfigRequestCustomConfigs(TeaModel):
    def __init__(self, name=None, operation=None, value=None):
        self.name = name  # type: str
        self.operation = operation  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ChangeCheckCustomConfigRequestCustomConfigs, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.operation is not None:
            result['Operation'] = self.operation
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Operation') is not None:
            self.operation = m.get('Operation')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ChangeCheckCustomConfigRequest(TeaModel):
    def __init__(self, check_id=None, custom_configs=None, region_id=None):
        self.check_id = check_id  # type: long
        self.custom_configs = custom_configs  # type: list[ChangeCheckCustomConfigRequestCustomConfigs]
        self.region_id = region_id  # type: str

    def validate(self):
        if self.custom_configs:
            for k in self.custom_configs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ChangeCheckCustomConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_id is not None:
            result['CheckId'] = self.check_id
        result['CustomConfigs'] = []
        if self.custom_configs is not None:
            for k in self.custom_configs:
                result['CustomConfigs'].append(k.to_map() if k else None)
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CheckId') is not None:
            self.check_id = m.get('CheckId')
        self.custom_configs = []
        if m.get('CustomConfigs') is not None:
            for k in m.get('CustomConfigs'):
                temp_model = ChangeCheckCustomConfigRequestCustomConfigs()
                self.custom_configs.append(temp_model.from_map(k))
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class ChangeCheckCustomConfigResponseBodyIllegalCustomConfigs(TeaModel):
    def __init__(self, name=None):
        self.name = name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ChangeCheckCustomConfigResponseBodyIllegalCustomConfigs, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class ChangeCheckCustomConfigResponseBody(TeaModel):
    def __init__(self, illegal_custom_configs=None, request_id=None):
        self.illegal_custom_configs = illegal_custom_configs  # type: list[ChangeCheckCustomConfigResponseBodyIllegalCustomConfigs]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.illegal_custom_configs:
            for k in self.illegal_custom_configs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ChangeCheckCustomConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['IllegalCustomConfigs'] = []
        if self.illegal_custom_configs is not None:
            for k in self.illegal_custom_configs:
                result['IllegalCustomConfigs'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.illegal_custom_configs = []
        if m.get('IllegalCustomConfigs') is not None:
            for k in m.get('IllegalCustomConfigs'):
                temp_model = ChangeCheckCustomConfigResponseBodyIllegalCustomConfigs()
                self.illegal_custom_configs.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ChangeCheckCustomConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ChangeCheckCustomConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ChangeCheckCustomConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ChangeCheckCustomConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckQuaraFileIdRequest(TeaModel):
    def __init__(self, quara_file_ids=None, uuid=None):
        # The IDs of quarantined files that you want to check.
        # 
        # >  You can call the [DescribeSuspEventQuaraFiles](~~DescribeSuspEventQuaraFiles~~) operation to query the IDs of quarantined files.
        self.quara_file_ids = quara_file_ids  # type: list[str]
        # The UUID of the server on which you want to check quarantined files.
        # 
        # >  You can call the [DescribeCloudCenterInstances](~~DescribeCloudCenterInstances~~) operation to query the UUIDs of servers.
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckQuaraFileIdRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.quara_file_ids is not None:
            result['QuaraFileIds'] = self.quara_file_ids
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('QuaraFileIds') is not None:
            self.quara_file_ids = m.get('QuaraFileIds')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class CheckQuaraFileIdResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        # Indicates whether the ID of the quarantined file is valid. Valid values:
        # 
        # *   **true**: The ID of the quarantined file is valid.
        # *   **false**: The ID of the quarantined file is invalid.
        self.data = data  # type: bool
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckQuaraFileIdResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CheckQuaraFileIdResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CheckQuaraFileIdResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CheckQuaraFileIdResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CheckQuaraFileIdResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckSecurityEventIdRequest(TeaModel):
    def __init__(self, security_event_ids=None, uuid=None):
        # The IDs of alert events. You can specify up to 100 IDs. If you do not specify this parameter, the value of the response parameter **Data** is **false**. The value false indicates that no alert events are generated on the server.
        # 
        # > You can call the [DescribeAlarmEventList](~~DescribeAlarmEventList~~) operation to query the IDs of alert events.
        self.security_event_ids = security_event_ids  # type: list[str]
        # The UUID of the server.
        # 
        # > You can call the [DescribeCloudCenterInstances](~~DescribeCloudCenterInstances~~) operation to query the UUIDs of servers.
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckSecurityEventIdRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.security_event_ids is not None:
            result['SecurityEventIds'] = self.security_event_ids
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SecurityEventIds') is not None:
            self.security_event_ids = m.get('SecurityEventIds')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class CheckSecurityEventIdResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        # Indicates whether the alert events are generated on the server. Valid values:
        # 
        # *   **true**\
        # *   **false**: no
        self.data = data  # type: bool
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckSecurityEventIdResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CheckSecurityEventIdResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CheckSecurityEventIdResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CheckSecurityEventIdResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CheckSecurityEventIdResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckUserHasEcsRequest(TeaModel):
    def __init__(self, lang=None):
        self.lang = lang  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckUserHasEcsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class CheckUserHasEcsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: bool
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckUserHasEcsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CheckUserHasEcsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CheckUserHasEcsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CheckUserHasEcsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CheckUserHasEcsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ConfirmVirusEventsRequest(TeaModel):
    def __init__(self, operation_all=None, operation_code=None, operation_range=None):
        # Specifies whether to handle all alert events. Valid values:
        # 
        # *   **1**: yes
        # *   **0**: no
        self.operation_all = operation_all  # type: int
        # The operation that you want to perform on the alert events. Valid values:
        # 
        # *   **default**: performs in-depth detection and removal
        # *   **ignore**: ignores the alert event
        # *   **advance\_mark\_mis_info**: adds the alert events to the whitelist
        # *   **manual_handled**: marks the alert events as manually handled
        self.operation_code = operation_code  # type: str
        # The server on which you want to perform the alert events.
        self.operation_range = operation_range  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ConfirmVirusEventsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.operation_all is not None:
            result['OperationAll'] = self.operation_all
        if self.operation_code is not None:
            result['OperationCode'] = self.operation_code
        if self.operation_range is not None:
            result['OperationRange'] = self.operation_range
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OperationAll') is not None:
            self.operation_all = m.get('OperationAll')
        if m.get('OperationCode') is not None:
            self.operation_code = m.get('OperationCode')
        if m.get('OperationRange') is not None:
            self.operation_range = m.get('OperationRange')
        return self


class ConfirmVirusEventsResponseBody(TeaModel):
    def __init__(self, request_id=None, result=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # Indicates whether the request was successful. Valid values:
        # 
        # *   true: The request was successful.
        # *   false: The request failed.
        self.result = result  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(ConfirmVirusEventsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        return self


class ConfirmVirusEventsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ConfirmVirusEventsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ConfirmVirusEventsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ConfirmVirusEventsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAntiBruteForceRuleRequest(TeaModel):
    def __init__(self, default_rule=None, fail_count=None, forbidden_time=None, name=None, resource_owner_id=None,
                 source_ip=None, span=None, uuid_list=None):
        self.default_rule = default_rule  # type: bool
        self.fail_count = fail_count  # type: int
        self.forbidden_time = forbidden_time  # type: int
        self.name = name  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.source_ip = source_ip  # type: str
        self.span = span  # type: int
        self.uuid_list = uuid_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateAntiBruteForceRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.default_rule is not None:
            result['DefaultRule'] = self.default_rule
        if self.fail_count is not None:
            result['FailCount'] = self.fail_count
        if self.forbidden_time is not None:
            result['ForbiddenTime'] = self.forbidden_time
        if self.name is not None:
            result['Name'] = self.name
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.span is not None:
            result['Span'] = self.span
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DefaultRule') is not None:
            self.default_rule = m.get('DefaultRule')
        if m.get('FailCount') is not None:
            self.fail_count = m.get('FailCount')
        if m.get('ForbiddenTime') is not None:
            self.forbidden_time = m.get('ForbiddenTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Span') is not None:
            self.span = m.get('Span')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class CreateAntiBruteForceRuleResponseBodyCreateAntiBruteForceRule(TeaModel):
    def __init__(self, rule_id=None):
        self.rule_id = rule_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateAntiBruteForceRuleResponseBodyCreateAntiBruteForceRule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class CreateAntiBruteForceRuleResponseBody(TeaModel):
    def __init__(self, create_anti_brute_force_rule=None, request_id=None):
        self.create_anti_brute_force_rule = create_anti_brute_force_rule  # type: CreateAntiBruteForceRuleResponseBodyCreateAntiBruteForceRule
        self.request_id = request_id  # type: str

    def validate(self):
        if self.create_anti_brute_force_rule:
            self.create_anti_brute_force_rule.validate()

    def to_map(self):
        _map = super(CreateAntiBruteForceRuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_anti_brute_force_rule is not None:
            result['CreateAntiBruteForceRule'] = self.create_anti_brute_force_rule.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateAntiBruteForceRule') is not None:
            temp_model = CreateAntiBruteForceRuleResponseBodyCreateAntiBruteForceRule()
            self.create_anti_brute_force_rule = temp_model.from_map(m['CreateAntiBruteForceRule'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateAntiBruteForceRuleResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateAntiBruteForceRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateAntiBruteForceRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateAntiBruteForceRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateBackupPolicyRequest(TeaModel):
    def __init__(self, name=None, policy=None, policy_region_id=None, policy_version=None, uuid_list=None):
        # The name of the anti-ransomware policy.
        self.name = name  # type: str
        # *   **IsDefault**: the type of the anti-ransomware policy. Valid values:
        # 
        #     *   **1**: recommended policy
        #     *   **0**: custom policy
        # 
        # *   **Include**: the format of the files that you want to protect. If you want to protect the files in all formats, set this field to \[].
        # 
        # *   **Source**: the directory that you want to protect. If you want to protect all directories, set this field to \[].
        # 
        # *   **ExcludeSystemPath**: specifies whether to exclude a specific directory from the anti-ransomware policy. If you want to exclude a directory, set this field to **true**. If you do not want to exclude a directory, leave this field empty.
        # 
        # *   **Exclude**: the directory that you want to exclude from the anti-ransomware policy. If you do not want to exclude a directory, set this field to \[].
        # 
        # *   **Schedule**: the start time and interval of a data backup task. We recommend that you specify a start time that begins during off-peak hours but does not start on the hour. Examples:
        # 
        #     *   If you set this field to I|1583216092|P21D, the data backup task starts from 2020-03-03 14:14:52, and the task is run at an interval of three weeks.
        #     *   If you set this field to I|1583216092|PT24H, the data backup task starts from 2020-03-03 14:14:52, and the task is run at an interval of 24 hours.
        # 
        # *   **Retention**: the period during which backup data is retained. Unit: days. If you set this field to 7, backup data is retained for a week. If you set this field to 365, backup data is retained for a year. If you set this field to -1, backup data is permanently retained.
        # 
        # *   **SpeedLimiter**: the limit on the network bandwidth for data backup tasks. If you set this field to 0:24:30720, the maximum bandwidth for a data backup task is 30 MB/s from 00:00 to 24:00.
        # 
        # *   **UseVss**: specifies whether to enable the VSS feature. The feature is available only for Windows servers. Valid values:
        # 
        #     *   **true**: yes
        #     *   **false**: no
        # 
        # >  The VSS feature is available only if you create the anti-ransomware policy for Windows servers. After you enable the feature, the number of backup failures due to running processes is significantly reduced. We recommend that you enable the VSS feature. After you enable the feature, the data of disks that are in the exFAT and FAT32 formats cannot be backed up.
        self.policy = policy  # type: dict[str, any]
        # The region ID of the server that is not deployed on Alibaba Cloud.
        # 
        # >  We recommend that you specify the ID of the supported region that is the nearest to the location of the server. You can call the [DescribeSupportRegion](~~DescribeSupportRegion~~) operation to query the supported regions of the anti-ransomware feature.
        self.policy_region_id = policy_region_id  # type: str
        # The version of the anti-ransomware policy. Set the value to **2.0.0**.
        self.policy_version = policy_version  # type: str
        # The UUIDs of the servers that you want to protect.
        self.uuid_list = uuid_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateBackupPolicyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.policy_region_id is not None:
            result['PolicyRegionId'] = self.policy_region_id
        if self.policy_version is not None:
            result['PolicyVersion'] = self.policy_version
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('PolicyRegionId') is not None:
            self.policy_region_id = m.get('PolicyRegionId')
        if m.get('PolicyVersion') is not None:
            self.policy_version = m.get('PolicyVersion')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class CreateBackupPolicyShrinkRequest(TeaModel):
    def __init__(self, name=None, policy_shrink=None, policy_region_id=None, policy_version=None, uuid_list=None):
        # The name of the anti-ransomware policy.
        self.name = name  # type: str
        # *   **IsDefault**: the type of the anti-ransomware policy. Valid values:
        # 
        #     *   **1**: recommended policy
        #     *   **0**: custom policy
        # 
        # *   **Include**: the format of the files that you want to protect. If you want to protect the files in all formats, set this field to \[].
        # 
        # *   **Source**: the directory that you want to protect. If you want to protect all directories, set this field to \[].
        # 
        # *   **ExcludeSystemPath**: specifies whether to exclude a specific directory from the anti-ransomware policy. If you want to exclude a directory, set this field to **true**. If you do not want to exclude a directory, leave this field empty.
        # 
        # *   **Exclude**: the directory that you want to exclude from the anti-ransomware policy. If you do not want to exclude a directory, set this field to \[].
        # 
        # *   **Schedule**: the start time and interval of a data backup task. We recommend that you specify a start time that begins during off-peak hours but does not start on the hour. Examples:
        # 
        #     *   If you set this field to I|1583216092|P21D, the data backup task starts from 2020-03-03 14:14:52, and the task is run at an interval of three weeks.
        #     *   If you set this field to I|1583216092|PT24H, the data backup task starts from 2020-03-03 14:14:52, and the task is run at an interval of 24 hours.
        # 
        # *   **Retention**: the period during which backup data is retained. Unit: days. If you set this field to 7, backup data is retained for a week. If you set this field to 365, backup data is retained for a year. If you set this field to -1, backup data is permanently retained.
        # 
        # *   **SpeedLimiter**: the limit on the network bandwidth for data backup tasks. If you set this field to 0:24:30720, the maximum bandwidth for a data backup task is 30 MB/s from 00:00 to 24:00.
        # 
        # *   **UseVss**: specifies whether to enable the VSS feature. The feature is available only for Windows servers. Valid values:
        # 
        #     *   **true**: yes
        #     *   **false**: no
        # 
        # >  The VSS feature is available only if you create the anti-ransomware policy for Windows servers. After you enable the feature, the number of backup failures due to running processes is significantly reduced. We recommend that you enable the VSS feature. After you enable the feature, the data of disks that are in the exFAT and FAT32 formats cannot be backed up.
        self.policy_shrink = policy_shrink  # type: str
        # The region ID of the server that is not deployed on Alibaba Cloud.
        # 
        # >  We recommend that you specify the ID of the supported region that is the nearest to the location of the server. You can call the [DescribeSupportRegion](~~DescribeSupportRegion~~) operation to query the supported regions of the anti-ransomware feature.
        self.policy_region_id = policy_region_id  # type: str
        # The version of the anti-ransomware policy. Set the value to **2.0.0**.
        self.policy_version = policy_version  # type: str
        # The UUIDs of the servers that you want to protect.
        self.uuid_list = uuid_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateBackupPolicyShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.policy_shrink is not None:
            result['Policy'] = self.policy_shrink
        if self.policy_region_id is not None:
            result['PolicyRegionId'] = self.policy_region_id
        if self.policy_version is not None:
            result['PolicyVersion'] = self.policy_version
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Policy') is not None:
            self.policy_shrink = m.get('Policy')
        if m.get('PolicyRegionId') is not None:
            self.policy_region_id = m.get('PolicyRegionId')
        if m.get('PolicyVersion') is not None:
            self.policy_version = m.get('PolicyVersion')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class CreateBackupPolicyResponseBodyBackupPolicy(TeaModel):
    def __init__(self, id=None, status=None):
        # The ID of the anti-ransomware policy.
        self.id = id  # type: str
        # The status of the anti-ransomware policy. Valid values:
        # 
        # *   **enabled**\
        # *   **disabled**\
        # 
        # >  After you create an anti-ransomware policy, the policy is enabled by default.
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateBackupPolicyResponseBodyBackupPolicy, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class CreateBackupPolicyResponseBody(TeaModel):
    def __init__(self, backup_policy=None, request_id=None):
        # The information about the anti-ransomware policy.
        self.backup_policy = backup_policy  # type: CreateBackupPolicyResponseBodyBackupPolicy
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.backup_policy:
            self.backup_policy.validate()

    def to_map(self):
        _map = super(CreateBackupPolicyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_policy is not None:
            result['BackupPolicy'] = self.backup_policy.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BackupPolicy') is not None:
            temp_model = CreateBackupPolicyResponseBodyBackupPolicy()
            self.backup_policy = temp_model.from_map(m['BackupPolicy'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateBackupPolicyResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateBackupPolicyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateBackupPolicyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateBackupPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateContainerScanTaskRequest(TeaModel):
    def __init__(self, cluster_id=None, container_ids=None, lang=None):
        self.cluster_id = cluster_id  # type: str
        self.container_ids = container_ids  # type: str
        self.lang = lang  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateContainerScanTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.container_ids is not None:
            result['ContainerIds'] = self.container_ids
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ContainerIds') is not None:
            self.container_ids = m.get('ContainerIds')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class CreateContainerScanTaskResponseBodyData(TeaModel):
    def __init__(self, can_create=None, collect_time=None, exec_time=None, finish_count=None, progress=None,
                 result=None, status=None, task_id=None, total_count=None):
        self.can_create = can_create  # type: bool
        self.collect_time = collect_time  # type: long
        self.exec_time = exec_time  # type: long
        self.finish_count = finish_count  # type: int
        self.progress = progress  # type: int
        self.result = result  # type: str
        self.status = status  # type: str
        self.task_id = task_id  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateContainerScanTaskResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.can_create is not None:
            result['CanCreate'] = self.can_create
        if self.collect_time is not None:
            result['CollectTime'] = self.collect_time
        if self.exec_time is not None:
            result['ExecTime'] = self.exec_time
        if self.finish_count is not None:
            result['FinishCount'] = self.finish_count
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.result is not None:
            result['Result'] = self.result
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CanCreate') is not None:
            self.can_create = m.get('CanCreate')
        if m.get('CollectTime') is not None:
            self.collect_time = m.get('CollectTime')
        if m.get('ExecTime') is not None:
            self.exec_time = m.get('ExecTime')
        if m.get('FinishCount') is not None:
            self.finish_count = m.get('FinishCount')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class CreateContainerScanTaskResponseBody(TeaModel):
    def __init__(self, data=None, http_status_code=None, request_id=None):
        self.data = data  # type: CreateContainerScanTaskResponseBodyData
        self.http_status_code = http_status_code  # type: int
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateContainerScanTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = CreateContainerScanTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateContainerScanTaskResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateContainerScanTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateContainerScanTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateContainerScanTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCustomBlockRecordRequest(TeaModel):
    def __init__(self, block_ip=None, bound=None, expire_time=None, resource_owner_id=None, uuids=None):
        self.block_ip = block_ip  # type: str
        self.bound = bound  # type: str
        self.expire_time = expire_time  # type: long
        self.resource_owner_id = resource_owner_id  # type: long
        self.uuids = uuids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCustomBlockRecordRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.block_ip is not None:
            result['BlockIp'] = self.block_ip
        if self.bound is not None:
            result['Bound'] = self.bound
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BlockIp') is not None:
            self.block_ip = m.get('BlockIp')
        if m.get('Bound') is not None:
            self.bound = m.get('Bound')
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        return self


class CreateCustomBlockRecordResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCustomBlockRecordResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateCustomBlockRecordResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateCustomBlockRecordResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateCustomBlockRecordResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCustomBlockRecordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCycleTaskRequest(TeaModel):
    def __init__(self, enable=None, first_date_str=None, interval_period=None, param=None, period_unit=None,
                 source=None, target_end_time=None, target_start_time=None, task_name=None, task_type=None):
        self.enable = enable  # type: int
        self.first_date_str = first_date_str  # type: long
        self.interval_period = interval_period  # type: int
        self.param = param  # type: str
        self.period_unit = period_unit  # type: str
        self.source = source  # type: str
        self.target_end_time = target_end_time  # type: int
        self.target_start_time = target_start_time  # type: int
        self.task_name = task_name  # type: str
        self.task_type = task_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCycleTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enable is not None:
            result['Enable'] = self.enable
        if self.first_date_str is not None:
            result['FirstDateStr'] = self.first_date_str
        if self.interval_period is not None:
            result['IntervalPeriod'] = self.interval_period
        if self.param is not None:
            result['Param'] = self.param
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.source is not None:
            result['Source'] = self.source
        if self.target_end_time is not None:
            result['TargetEndTime'] = self.target_end_time
        if self.target_start_time is not None:
            result['TargetStartTime'] = self.target_start_time
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Enable') is not None:
            self.enable = m.get('Enable')
        if m.get('FirstDateStr') is not None:
            self.first_date_str = m.get('FirstDateStr')
        if m.get('IntervalPeriod') is not None:
            self.interval_period = m.get('IntervalPeriod')
        if m.get('Param') is not None:
            self.param = m.get('Param')
        if m.get('PeriodUnit') is not None:
            self.period_unit = m.get('PeriodUnit')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('TargetEndTime') is not None:
            self.target_end_time = m.get('TargetEndTime')
        if m.get('TargetStartTime') is not None:
            self.target_start_time = m.get('TargetStartTime')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class CreateCycleTaskResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCycleTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateCycleTaskResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateCycleTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateCycleTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCycleTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateFileDetectRequest(TeaModel):
    def __init__(self, hash_key=None, oss_key=None, source_ip=None, type=None):
        # The identifier of the file. Only MD5 hash values are supported.
        self.hash_key = hash_key  # type: str
        # The key of the file that is stored in the Object Storage Service (OSS) bucket. You can call the [CreateFileDetectUploadUrl](~~CreateFileDetectUploadUrl~~) operation to query the keys of files.
        self.oss_key = oss_key  # type: str
        # The source IP address of the request.
        self.source_ip = source_ip  # type: str
        # The type of the file. Valid values:
        # 
        # *   **0**: unknown files
        # *   **1**: binary files
        # *   **2**: webshell files
        # *   **4**: script files
        # 
        # >  If you do not know the type of the file, set this parameter to 0.
        self.type = type  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateFileDetectRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hash_key is not None:
            result['HashKey'] = self.hash_key
        if self.oss_key is not None:
            result['OssKey'] = self.oss_key
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HashKey') is not None:
            self.hash_key = m.get('HashKey')
        if m.get('OssKey') is not None:
            self.oss_key = m.get('OssKey')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateFileDetectResponseBody(TeaModel):
    def __init__(self, hash_key=None, request_id=None):
        # The identifier of the file.
        self.hash_key = hash_key  # type: str
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateFileDetectResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hash_key is not None:
            result['HashKey'] = self.hash_key
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HashKey') is not None:
            self.hash_key = m.get('HashKey')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateFileDetectResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateFileDetectResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateFileDetectResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateFileDetectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateFileDetectUploadUrlRequestHashKeyContextList(TeaModel):
    def __init__(self, file_size=None, hash_key=None):
        # The size of the file. Unit: bytes.
        self.file_size = file_size  # type: int
        # The hash value of the file.
        self.hash_key = hash_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateFileDetectUploadUrlRequestHashKeyContextList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        if self.hash_key is not None:
            result['HashKey'] = self.hash_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        if m.get('HashKey') is not None:
            self.hash_key = m.get('HashKey')
        return self


class CreateFileDetectUploadUrlRequest(TeaModel):
    def __init__(self, hash_key_context_list=None, hash_key_list=None, type=None):
        # The hash values of files.
        # 
        # > You must specify at least one of the **HashKeyList** and **HashKeyContextList** parameters.
        self.hash_key_context_list = hash_key_context_list  # type: list[CreateFileDetectUploadUrlRequestHashKeyContextList]
        # The identifiers of files. Only MD5 hash values are supported.
        # 
        # > You must specify at least one of the **HashKeyList** and **HashKeyContextList** parameters.
        self.hash_key_list = hash_key_list  # type: list[str]
        # The type of the file. Valid values:
        # 
        # *   **0**: unknown file
        # *   **1**: binary file
        # *   **2**: webshell file
        # *   **4**: script file
        # 
        # > If you do not know the type of the file, set this parameter to **0**.
        self.type = type  # type: int

    def validate(self):
        if self.hash_key_context_list:
            for k in self.hash_key_context_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateFileDetectUploadUrlRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['HashKeyContextList'] = []
        if self.hash_key_context_list is not None:
            for k in self.hash_key_context_list:
                result['HashKeyContextList'].append(k.to_map() if k else None)
        if self.hash_key_list is not None:
            result['HashKeyList'] = self.hash_key_list
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.hash_key_context_list = []
        if m.get('HashKeyContextList') is not None:
            for k in m.get('HashKeyContextList'):
                temp_model = CreateFileDetectUploadUrlRequestHashKeyContextList()
                self.hash_key_context_list.append(temp_model.from_map(k))
        if m.get('HashKeyList') is not None:
            self.hash_key_list = m.get('HashKeyList')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateFileDetectUploadUrlResponseBodyUploadUrlListContext(TeaModel):
    def __init__(self, access_id=None, oss_key=None, policy=None, signature=None):
        # The AccessKey ID that is used to access the OSS bucket.
        self.access_id = access_id  # type: str
        # The key of the file that is used after the file is uploaded to the OSS bucket.
        self.oss_key = oss_key  # type: str
        # The policy that poses limits on file upload. For example, the policy can limit the size of the file.
        self.policy = policy  # type: str
        # The signature that is used to upload the file.
        self.signature = signature  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateFileDetectUploadUrlResponseBodyUploadUrlListContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_id is not None:
            result['AccessId'] = self.access_id
        if self.oss_key is not None:
            result['OssKey'] = self.oss_key
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.signature is not None:
            result['Signature'] = self.signature
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccessId') is not None:
            self.access_id = m.get('AccessId')
        if m.get('OssKey') is not None:
            self.oss_key = m.get('OssKey')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('Signature') is not None:
            self.signature = m.get('Signature')
        return self


class CreateFileDetectUploadUrlResponseBodyUploadUrlList(TeaModel):
    def __init__(self, code=None, context=None, expire=None, file_exist=None, hash_key=None, internal_url=None,
                 message=None, public_url=None):
        # The status code returned. The status code **200** indicates that the request was successful. Other status codes indicate that the request failed. You can identify the cause of the failure based on the status code.
        self.code = code  # type: str
        # The signature information.
        self.context = context  # type: CreateFileDetectUploadUrlResponseBodyUploadUrlListContext
        # The timestamp when the values of the parameters expire. Unit: milliseconds.
        self.expire = expire  # type: str
        # Indicates whether the file exists in the cloud. Valid values:
        # 
        # *   **true**: The file exists in the cloud. You do not need to upload the file.
        # *   **false**: The file does not exist in the cloud. You must upload the file.
        self.file_exist = file_exist  # type: bool
        # The identifier of the file.
        self.hash_key = hash_key  # type: str
        # The internal endpoint of the URL to which the file is uploaded.
        self.internal_url = internal_url  # type: str
        # The error message returned.
        self.message = message  # type: str
        # The public endpoint of the URL to which the file is uploaded.
        self.public_url = public_url  # type: str

    def validate(self):
        if self.context:
            self.context.validate()

    def to_map(self):
        _map = super(CreateFileDetectUploadUrlResponseBodyUploadUrlList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.context is not None:
            result['Context'] = self.context.to_map()
        if self.expire is not None:
            result['Expire'] = self.expire
        if self.file_exist is not None:
            result['FileExist'] = self.file_exist
        if self.hash_key is not None:
            result['HashKey'] = self.hash_key
        if self.internal_url is not None:
            result['InternalUrl'] = self.internal_url
        if self.message is not None:
            result['Message'] = self.message
        if self.public_url is not None:
            result['PublicUrl'] = self.public_url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Context') is not None:
            temp_model = CreateFileDetectUploadUrlResponseBodyUploadUrlListContext()
            self.context = temp_model.from_map(m['Context'])
        if m.get('Expire') is not None:
            self.expire = m.get('Expire')
        if m.get('FileExist') is not None:
            self.file_exist = m.get('FileExist')
        if m.get('HashKey') is not None:
            self.hash_key = m.get('HashKey')
        if m.get('InternalUrl') is not None:
            self.internal_url = m.get('InternalUrl')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PublicUrl') is not None:
            self.public_url = m.get('PublicUrl')
        return self


class CreateFileDetectUploadUrlResponseBody(TeaModel):
    def __init__(self, request_id=None, upload_url_list=None):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id  # type: str
        # An array consisting of the parameters that are required to upload a file.
        self.upload_url_list = upload_url_list  # type: list[CreateFileDetectUploadUrlResponseBodyUploadUrlList]

    def validate(self):
        if self.upload_url_list:
            for k in self.upload_url_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateFileDetectUploadUrlResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['UploadUrlList'] = []
        if self.upload_url_list is not None:
            for k in self.upload_url_list:
                result['UploadUrlList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.upload_url_list = []
        if m.get('UploadUrlList') is not None:
            for k in m.get('UploadUrlList'):
                temp_model = CreateFileDetectUploadUrlResponseBodyUploadUrlList()
                self.upload_url_list.append(temp_model.from_map(k))
        return self


class CreateFileDetectUploadUrlResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateFileDetectUploadUrlResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateFileDetectUploadUrlResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateFileDetectUploadUrlResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateHoneypotRequest(TeaModel):
    def __init__(self, honeypot_image_id=None, honeypot_image_name=None, honeypot_name=None, meta=None,
                 node_id=None):
        # The ID of the image that is used for the honeypot.
        # 
        # >  You can call the [ListAvailableHoneypot](~~ListAvailableHoneypot~~) operation to obtain the IDs of images from the **HoneypotImageId** response parameter.
        self.honeypot_image_id = honeypot_image_id  # type: str
        # The name of the image that is used for the honeypot.
        # 
        # >  You can call the [ListAvailableHoneypot](~~ListAvailableHoneypot~~) operation to obtain the names of images from the **HoneypotImageName** response parameter.
        self.honeypot_image_name = honeypot_image_name  # type: str
        # The custom name of the honeypot.
        self.honeypot_name = honeypot_name  # type: str
        # The custom configuration of the honeypot in the JSON format. The value contains the following fields:
        # 
        # *   **trojan_git**: Git-specific Defense. Valid values:
        # 
        #     *   **zip**: Git Source Code Package
        #     *   **web**: Git Directory Leak
        #     *   **close**: Disabled
        # 
        # *   **trojan\_git_addr**: Git Trojan Address.
        # 
        # *   **trojan_git.zip**: Git Trojan.
        # 
        # *   **burp**: Burp-specific Defense. Valid values:
        # 
        #     *   **open**: Enabled
        #     *   **close**: Disabled
        # 
        # *   **portrait_option**: Source Tracing Configuration. Valid values:
        # 
        #     *   **false**: Disable
        #     *   **true**: Enable
        self.meta = meta  # type: str
        # The ID of the management node to which you want to deploy the honeypot.
        # 
        # >  You can call the [ListHoneypotNode](~~ListHoneypotNode~~) operation to obtain the IDs of management nodes.
        self.node_id = node_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateHoneypotRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.honeypot_image_id is not None:
            result['HoneypotImageId'] = self.honeypot_image_id
        if self.honeypot_image_name is not None:
            result['HoneypotImageName'] = self.honeypot_image_name
        if self.honeypot_name is not None:
            result['HoneypotName'] = self.honeypot_name
        if self.meta is not None:
            result['Meta'] = self.meta
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HoneypotImageId') is not None:
            self.honeypot_image_id = m.get('HoneypotImageId')
        if m.get('HoneypotImageName') is not None:
            self.honeypot_image_name = m.get('HoneypotImageName')
        if m.get('HoneypotName') is not None:
            self.honeypot_name = m.get('HoneypotName')
        if m.get('Meta') is not None:
            self.meta = m.get('Meta')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        return self


class CreateHoneypotResponseBodyData(TeaModel):
    def __init__(self, control_node_name=None, honeypot_id=None, honeypot_image_display_name=None,
                 honeypot_image_name=None, honeypot_name=None, node_id=None, preset_id=None, state=None):
        # The name of the management node to which the honeypot is deployed.
        self.control_node_name = control_node_name  # type: str
        # The ID of the honeypot.
        self.honeypot_id = honeypot_id  # type: str
        # The display name of the image that is used for the honeypot.
        self.honeypot_image_display_name = honeypot_image_display_name  # type: str
        # The name of the image that is used for the honeypot.
        self.honeypot_image_name = honeypot_image_name  # type: str
        # The custom name of the honeypot.
        self.honeypot_name = honeypot_name  # type: str
        # The ID of the management node.
        self.node_id = node_id  # type: str
        # The ID of the custom configuration for the honeypot.
        self.preset_id = preset_id  # type: str
        # The status of the honeypot.
        self.state = state  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateHoneypotResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.control_node_name is not None:
            result['ControlNodeName'] = self.control_node_name
        if self.honeypot_id is not None:
            result['HoneypotId'] = self.honeypot_id
        if self.honeypot_image_display_name is not None:
            result['HoneypotImageDisplayName'] = self.honeypot_image_display_name
        if self.honeypot_image_name is not None:
            result['HoneypotImageName'] = self.honeypot_image_name
        if self.honeypot_name is not None:
            result['HoneypotName'] = self.honeypot_name
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.preset_id is not None:
            result['PresetId'] = self.preset_id
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ControlNodeName') is not None:
            self.control_node_name = m.get('ControlNodeName')
        if m.get('HoneypotId') is not None:
            self.honeypot_id = m.get('HoneypotId')
        if m.get('HoneypotImageDisplayName') is not None:
            self.honeypot_image_display_name = m.get('HoneypotImageDisplayName')
        if m.get('HoneypotImageName') is not None:
            self.honeypot_image_name = m.get('HoneypotImageName')
        if m.get('HoneypotName') is not None:
            self.honeypot_name = m.get('HoneypotName')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('PresetId') is not None:
            self.preset_id = m.get('PresetId')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class CreateHoneypotResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None, success=None):
        # The status code returned. The status code **200** indicates that the request was is successful. Other status codes indicate that the request failed. You can identify the cause of the failure based on the status code.
        self.code = code  # type: str
        # The information about the honeypot.
        self.data = data  # type: CreateHoneypotResponseBodyData
        # The HTTP status code returned.
        self.http_status_code = http_status_code  # type: int
        # The error message returned.
        self.message = message  # type: str
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id  # type: str
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**: The request was successful.
        # *   **false**: The request failed.
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateHoneypotResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateHoneypotResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateHoneypotResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateHoneypotResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateHoneypotResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateHoneypotResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateHoneypotNodeRequest(TeaModel):
    def __init__(self, allow_honeypot_access_internet=None, available_probe_num=None, node_name=None,
                 security_group_probe_ip_list=None):
        # Specifies whether to allow the honeypots to access the Internet. Valid values:
        # 
        # *   **true**: allows the honeypots to access the Internet.
        # *   **false**: does not allow the honeypots to access the Internet.
        self.allow_honeypot_access_internet = allow_honeypot_access_internet  # type: bool
        # The number of probes that you want to allocate for the management node.
        self.available_probe_num = available_probe_num  # type: int
        # The name of the management node.
        self.node_name = node_name  # type: str
        # The CIDR blocks that are allowed to access the management node.
        self.security_group_probe_ip_list = security_group_probe_ip_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateHoneypotNodeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.allow_honeypot_access_internet is not None:
            result['AllowHoneypotAccessInternet'] = self.allow_honeypot_access_internet
        if self.available_probe_num is not None:
            result['AvailableProbeNum'] = self.available_probe_num
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.security_group_probe_ip_list is not None:
            result['SecurityGroupProbeIpList'] = self.security_group_probe_ip_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AllowHoneypotAccessInternet') is not None:
            self.allow_honeypot_access_internet = m.get('AllowHoneypotAccessInternet')
        if m.get('AvailableProbeNum') is not None:
            self.available_probe_num = m.get('AvailableProbeNum')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('SecurityGroupProbeIpList') is not None:
            self.security_group_probe_ip_list = m.get('SecurityGroupProbeIpList')
        return self


class CreateHoneypotNodeResponseBodyHoneypotNode(TeaModel):
    def __init__(self, node_id=None):
        self.node_id = node_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateHoneypotNodeResponseBodyHoneypotNode, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        return self


class CreateHoneypotNodeResponseBody(TeaModel):
    def __init__(self, code=None, honeypot_node=None, http_status_code=None, message=None, request_id=None,
                 success=None):
        # The status code returned. The status code **200** indicates that the request was successful. Other status codes indicate that the request failed. You can identify the cause of the failure based on the status code.
        self.code = code  # type: str
        self.honeypot_node = honeypot_node  # type: CreateHoneypotNodeResponseBodyHoneypotNode
        # The HTTP status code returned.
        self.http_status_code = http_status_code  # type: int
        # The error message returned.
        self.message = message  # type: str
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id  # type: str
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**: The request was successful.
        # *   **false**: The request failed.
        self.success = success  # type: bool

    def validate(self):
        if self.honeypot_node:
            self.honeypot_node.validate()

    def to_map(self):
        _map = super(CreateHoneypotNodeResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.honeypot_node is not None:
            result['HoneypotNode'] = self.honeypot_node.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HoneypotNode') is not None:
            temp_model = CreateHoneypotNodeResponseBodyHoneypotNode()
            self.honeypot_node = temp_model.from_map(m['HoneypotNode'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateHoneypotNodeResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateHoneypotNodeResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateHoneypotNodeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateHoneypotNodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateHoneypotPresetRequest(TeaModel):
    def __init__(self, honeypot_image_name=None, lang=None, meta=None, node_id=None, preset_name=None):
        # The name of the honeypot image.
        self.honeypot_image_name = honeypot_image_name  # type: str
        self.lang = lang  # type: str
        # The custom configurations of the honeypot template. The value is a JSON string that contains the following fields:
        # 
        # *   **portrait_option**: Social Source Tracing
        # *   **burp**: Burp-specific Defense
        # *   **trojan_git**: Git-specific Defense
        self.meta = meta  # type: str
        # The ID of the management node to which you want to deploy honeypots.
        # 
        # >  You can call the [ListHoneypotNode](~~ListHoneypotNode~~) operation to obtain the IDs of management nodes.
        self.node_id = node_id  # type: str
        # The custom name of the honeypot template.
        self.preset_name = preset_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateHoneypotPresetRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.honeypot_image_name is not None:
            result['HoneypotImageName'] = self.honeypot_image_name
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.meta is not None:
            result['Meta'] = self.meta
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.preset_name is not None:
            result['PresetName'] = self.preset_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HoneypotImageName') is not None:
            self.honeypot_image_name = m.get('HoneypotImageName')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Meta') is not None:
            self.meta = m.get('Meta')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('PresetName') is not None:
            self.preset_name = m.get('PresetName')
        return self


class CreateHoneypotPresetResponseBodyHoneypotPreset(TeaModel):
    def __init__(self, honeypot_preset_id=None):
        # The ID of the honeypot template.
        self.honeypot_preset_id = honeypot_preset_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateHoneypotPresetResponseBodyHoneypotPreset, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.honeypot_preset_id is not None:
            result['HoneypotPresetId'] = self.honeypot_preset_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HoneypotPresetId') is not None:
            self.honeypot_preset_id = m.get('HoneypotPresetId')
        return self


class CreateHoneypotPresetResponseBody(TeaModel):
    def __init__(self, code=None, honeypot_preset=None, http_status_code=None, message=None, request_id=None,
                 success=None):
        # The status code returned. The status code **200** indicates that the request was successful. Other status codes indicate that the request failed. You can identify the cause of the failure based on the status code.
        self.code = code  # type: str
        # The creation result.
        self.honeypot_preset = honeypot_preset  # type: CreateHoneypotPresetResponseBodyHoneypotPreset
        # The HTTP status code returned.
        self.http_status_code = http_status_code  # type: int
        # The message returned.
        self.message = message  # type: str
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id  # type: str
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**: The request was successful.
        # *   **false**: The request failed.
        self.success = success  # type: bool

    def validate(self):
        if self.honeypot_preset:
            self.honeypot_preset.validate()

    def to_map(self):
        _map = super(CreateHoneypotPresetResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.honeypot_preset is not None:
            result['HoneypotPreset'] = self.honeypot_preset.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HoneypotPreset') is not None:
            temp_model = CreateHoneypotPresetResponseBodyHoneypotPreset()
            self.honeypot_preset = temp_model.from_map(m['HoneypotPreset'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateHoneypotPresetResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateHoneypotPresetResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateHoneypotPresetResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateHoneypotPresetResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateHoneypotProbeRequestHoneypotBindListBindPortList(TeaModel):
    def __init__(self, bind_port=None, end_port=None, fixed=None, start_port=None, target_port=None):
        # Specifies whether to bind a port. Valid values:
        # 
        # *   **true**: yes
        # *   **false**: no
        self.bind_port = bind_port  # type: bool
        # The end of the port range.
        self.end_port = end_port  # type: int
        # Specifies whether the port is fixed. Valid values:
        # 
        # *   **0**: no
        # *   **1**: yes
        self.fixed = fixed  # type: bool
        # The start of the port range.
        self.start_port = start_port  # type: int
        # The destination port.
        # 
        # >  If **HoneypotId** is specified, this parameter is required.
        self.target_port = target_port  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateHoneypotProbeRequestHoneypotBindListBindPortList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bind_port is not None:
            result['BindPort'] = self.bind_port
        if self.end_port is not None:
            result['EndPort'] = self.end_port
        if self.fixed is not None:
            result['Fixed'] = self.fixed
        if self.start_port is not None:
            result['StartPort'] = self.start_port
        if self.target_port is not None:
            result['TargetPort'] = self.target_port
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BindPort') is not None:
            self.bind_port = m.get('BindPort')
        if m.get('EndPort') is not None:
            self.end_port = m.get('EndPort')
        if m.get('Fixed') is not None:
            self.fixed = m.get('Fixed')
        if m.get('StartPort') is not None:
            self.start_port = m.get('StartPort')
        if m.get('TargetPort') is not None:
            self.target_port = m.get('TargetPort')
        return self


class CreateHoneypotProbeRequestHoneypotBindList(TeaModel):
    def __init__(self, bind_port_list=None, honeypot_id=None):
        # The listener ports.
        self.bind_port_list = bind_port_list  # type: list[CreateHoneypotProbeRequestHoneypotBindListBindPortList]
        # The ID of the honeypot.
        # 
        # >  You can call the [ListHoneypot](~~ListHoneypot~~) operation to query the IDs of honeypots.
        self.honeypot_id = honeypot_id  # type: str

    def validate(self):
        if self.bind_port_list:
            for k in self.bind_port_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateHoneypotProbeRequestHoneypotBindList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BindPortList'] = []
        if self.bind_port_list is not None:
            for k in self.bind_port_list:
                result['BindPortList'].append(k.to_map() if k else None)
        if self.honeypot_id is not None:
            result['HoneypotId'] = self.honeypot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.bind_port_list = []
        if m.get('BindPortList') is not None:
            for k in m.get('BindPortList'):
                temp_model = CreateHoneypotProbeRequestHoneypotBindListBindPortList()
                self.bind_port_list.append(temp_model.from_map(k))
        if m.get('HoneypotId') is not None:
            self.honeypot_id = m.get('HoneypotId')
        return self


class CreateHoneypotProbeRequest(TeaModel):
    def __init__(self, arp=None, business_group_id=None, control_node_id=None, display_name=None,
                 honeypot_bind_list=None, ping=None, probe_type=None, probe_version=None, proxy_ip=None, uuid=None, vpc_id=None):
        # Specifies whether to enable Address Resolution Protocol (ARP) spoofing. Valid values:
        # 
        # *   **true**: yes
        # *   **false**: no
        self.arp = arp  # type: bool
        # The ID of the business group.
        self.business_group_id = business_group_id  # type: str
        # The ID of the management node.
        # 
        # >  You can call the [ListHoneypotNode](~~ListHoneypotNode~~) operation to query the IDs of management nodes.
        self.control_node_id = control_node_id  # type: str
        # The name of the probe.
        self.display_name = display_name  # type: str
        # The honeypot configurations.
        self.honeypot_bind_list = honeypot_bind_list  # type: list[CreateHoneypotProbeRequestHoneypotBindList]
        # Specifies whether to enable ping scan. Valid values:
        # 
        # *   **false**: yes
        # *   **false**: no
        self.ping = ping  # type: bool
        # The type of the probe. Valid values:
        # 
        # *   **host_probe**: host probe
        # *   **vpc_black_hole_probe**: virtual private cloud (VPC) probe
        self.probe_type = probe_type  # type: str
        # The version of the probe.
        self.probe_version = probe_version  # type: str
        # The IP address of the proxy.
        self.proxy_ip = proxy_ip  # type: str
        # The UUID of the instance.
        # 
        # >  If **ProbeType** is set to **host_probe**, this parameter is required.
        self.uuid = uuid  # type: str
        # The ID of the VPC.
        # 
        # >  If **ProbeType** is set to **vpc_black_hole_probe**, this parameter is required. You can call the DescribeVpcHoneyPotList operation to query the IDs of VPCs.
        self.vpc_id = vpc_id  # type: str

    def validate(self):
        if self.honeypot_bind_list:
            for k in self.honeypot_bind_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateHoneypotProbeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arp is not None:
            result['Arp'] = self.arp
        if self.business_group_id is not None:
            result['BusinessGroupId'] = self.business_group_id
        if self.control_node_id is not None:
            result['ControlNodeId'] = self.control_node_id
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        result['HoneypotBindList'] = []
        if self.honeypot_bind_list is not None:
            for k in self.honeypot_bind_list:
                result['HoneypotBindList'].append(k.to_map() if k else None)
        if self.ping is not None:
            result['Ping'] = self.ping
        if self.probe_type is not None:
            result['ProbeType'] = self.probe_type
        if self.probe_version is not None:
            result['ProbeVersion'] = self.probe_version
        if self.proxy_ip is not None:
            result['ProxyIp'] = self.proxy_ip
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Arp') is not None:
            self.arp = m.get('Arp')
        if m.get('BusinessGroupId') is not None:
            self.business_group_id = m.get('BusinessGroupId')
        if m.get('ControlNodeId') is not None:
            self.control_node_id = m.get('ControlNodeId')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        self.honeypot_bind_list = []
        if m.get('HoneypotBindList') is not None:
            for k in m.get('HoneypotBindList'):
                temp_model = CreateHoneypotProbeRequestHoneypotBindList()
                self.honeypot_bind_list.append(temp_model.from_map(k))
        if m.get('Ping') is not None:
            self.ping = m.get('Ping')
        if m.get('ProbeType') is not None:
            self.probe_type = m.get('ProbeType')
        if m.get('ProbeVersion') is not None:
            self.probe_version = m.get('ProbeVersion')
        if m.get('ProxyIp') is not None:
            self.proxy_ip = m.get('ProxyIp')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class CreateHoneypotProbeResponseBodyHoneypotProbe(TeaModel):
    def __init__(self, probe_id=None):
        self.probe_id = probe_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateHoneypotProbeResponseBodyHoneypotProbe, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.probe_id is not None:
            result['ProbeId'] = self.probe_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProbeId') is not None:
            self.probe_id = m.get('ProbeId')
        return self


class CreateHoneypotProbeResponseBody(TeaModel):
    def __init__(self, code=None, honeypot_probe=None, http_status_code=None, message=None, request_id=None,
                 success=None):
        # The status code returned. The status code **200** indicates that the request was successful. Other status codes indicate that the request failed. You can identify the cause of the failure based on the status code.
        self.code = code  # type: str
        self.honeypot_probe = honeypot_probe  # type: CreateHoneypotProbeResponseBodyHoneypotProbe
        # The HTTP status code returned.
        self.http_status_code = http_status_code  # type: int
        # The error message returned.
        self.message = message  # type: str
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id  # type: str
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**: The request was successful.
        # *   **false**: The request failed.
        self.success = success  # type: bool

    def validate(self):
        if self.honeypot_probe:
            self.honeypot_probe.validate()

    def to_map(self):
        _map = super(CreateHoneypotProbeResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.honeypot_probe is not None:
            result['HoneypotProbe'] = self.honeypot_probe.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HoneypotProbe') is not None:
            temp_model = CreateHoneypotProbeResponseBodyHoneypotProbe()
            self.honeypot_probe = temp_model.from_map(m['HoneypotProbe'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateHoneypotProbeResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateHoneypotProbeResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateHoneypotProbeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateHoneypotProbeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateInterceptionRuleRequest(TeaModel):
    def __init__(self, cluster_id=None, cluster_name=None, dst_target_list=None, intercept_type=None,
                 order_index=None, rule_name=None, rule_switch=None, rule_type=None, src_target=None):
        self.cluster_id = cluster_id  # type: str
        self.cluster_name = cluster_name  # type: str
        self.dst_target_list = dst_target_list  # type: dict[str, any]
        self.intercept_type = intercept_type  # type: long
        self.order_index = order_index  # type: long
        self.rule_name = rule_name  # type: str
        self.rule_switch = rule_switch  # type: int
        self.rule_type = rule_type  # type: str
        self.src_target = src_target  # type: dict[str, any]

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateInterceptionRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.dst_target_list is not None:
            result['DstTargetList'] = self.dst_target_list
        if self.intercept_type is not None:
            result['InterceptType'] = self.intercept_type
        if self.order_index is not None:
            result['OrderIndex'] = self.order_index
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.rule_switch is not None:
            result['RuleSwitch'] = self.rule_switch
        if self.rule_type is not None:
            result['RuleType'] = self.rule_type
        if self.src_target is not None:
            result['SrcTarget'] = self.src_target
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('DstTargetList') is not None:
            self.dst_target_list = m.get('DstTargetList')
        if m.get('InterceptType') is not None:
            self.intercept_type = m.get('InterceptType')
        if m.get('OrderIndex') is not None:
            self.order_index = m.get('OrderIndex')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('RuleSwitch') is not None:
            self.rule_switch = m.get('RuleSwitch')
        if m.get('RuleType') is not None:
            self.rule_type = m.get('RuleType')
        if m.get('SrcTarget') is not None:
            self.src_target = m.get('SrcTarget')
        return self


class CreateInterceptionRuleShrinkRequest(TeaModel):
    def __init__(self, cluster_id=None, cluster_name=None, dst_target_list_shrink=None, intercept_type=None,
                 order_index=None, rule_name=None, rule_switch=None, rule_type=None, src_target_shrink=None):
        self.cluster_id = cluster_id  # type: str
        self.cluster_name = cluster_name  # type: str
        self.dst_target_list_shrink = dst_target_list_shrink  # type: str
        self.intercept_type = intercept_type  # type: long
        self.order_index = order_index  # type: long
        self.rule_name = rule_name  # type: str
        self.rule_switch = rule_switch  # type: int
        self.rule_type = rule_type  # type: str
        self.src_target_shrink = src_target_shrink  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateInterceptionRuleShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.dst_target_list_shrink is not None:
            result['DstTargetList'] = self.dst_target_list_shrink
        if self.intercept_type is not None:
            result['InterceptType'] = self.intercept_type
        if self.order_index is not None:
            result['OrderIndex'] = self.order_index
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.rule_switch is not None:
            result['RuleSwitch'] = self.rule_switch
        if self.rule_type is not None:
            result['RuleType'] = self.rule_type
        if self.src_target_shrink is not None:
            result['SrcTarget'] = self.src_target_shrink
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('DstTargetList') is not None:
            self.dst_target_list_shrink = m.get('DstTargetList')
        if m.get('InterceptType') is not None:
            self.intercept_type = m.get('InterceptType')
        if m.get('OrderIndex') is not None:
            self.order_index = m.get('OrderIndex')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('RuleSwitch') is not None:
            self.rule_switch = m.get('RuleSwitch')
        if m.get('RuleType') is not None:
            self.rule_type = m.get('RuleType')
        if m.get('SrcTarget') is not None:
            self.src_target_shrink = m.get('SrcTarget')
        return self


class CreateInterceptionRuleResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateInterceptionRuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateInterceptionRuleResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateInterceptionRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateInterceptionRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateInterceptionRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateInterceptionTargetRequest(TeaModel):
    def __init__(self, app_name=None, cluster_id=None, cluster_name=None, image_list=None, namespace=None,
                 tag_list=None, target_name=None, target_type=None):
        self.app_name = app_name  # type: str
        self.cluster_id = cluster_id  # type: str
        self.cluster_name = cluster_name  # type: str
        self.image_list = image_list  # type: list[str]
        self.namespace = namespace  # type: str
        self.tag_list = tag_list  # type: list[str]
        self.target_name = target_name  # type: str
        self.target_type = target_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateInterceptionTargetRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.image_list is not None:
            result['ImageList'] = self.image_list
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.tag_list is not None:
            result['TagList'] = self.tag_list
        if self.target_name is not None:
            result['TargetName'] = self.target_name
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('ImageList') is not None:
            self.image_list = m.get('ImageList')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('TagList') is not None:
            self.tag_list = m.get('TagList')
        if m.get('TargetName') is not None:
            self.target_name = m.get('TargetName')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        return self


class CreateInterceptionTargetResponseBody(TeaModel):
    def __init__(self, request_id=None, result=None):
        self.request_id = request_id  # type: str
        self.result = result  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateInterceptionTargetResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        return self


class CreateInterceptionTargetResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateInterceptionTargetResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateInterceptionTargetResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateInterceptionTargetResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateJenkinsImageRegistryRequest(TeaModel):
    def __init__(self, domain_name=None, extra_param=None, net_type=None, password=None, persistence_day=None,
                 protocol_type=None, region_id=None, registry_host_ip=None, registry_name=None, registry_type=None,
                 registry_version=None, source_ip=None, trans_per_hour=None, user_name=None, vpc_id=None, white_list=None):
        # The domain name of the image repository.
        self.domain_name = domain_name  # type: str
        # The additional parameters of the image repository. The value of this parameter contains the following fields:
        # 
        # *   **namespace**: the namespace
        # *   **authToken**: the authorization token
        self.extra_param = extra_param  # type: str
        # The network type. Valid values:
        # 
        # *   **1**: Internet
        # *   **2**: Virtual Private Cloud (VPC)
        self.net_type = net_type  # type: int
        # The password.
        self.password = password  # type: str
        # The number of days during which assets can be retained.
        self.persistence_day = persistence_day  # type: int
        # The type of the protocol. Valid values:
        # 
        # *   **1**: HTTP
        # *   **2**: HTTPS
        self.protocol_type = protocol_type  # type: int
        # The region ID of the image repository.
        self.region_id = region_id  # type: str
        # The IP address of the image repository.
        self.registry_host_ip = registry_host_ip  # type: str
        # The alias of the image repository.
        self.registry_name = registry_name  # type: str
        # The type of the image repository. Valid values:
        # 
        # *   **CI/CD**: Jenkins
        self.registry_type = registry_type  # type: str
        # The version of the image repository. Default value: -. Valid values:
        # 
        # *   **-**: the default version
        # *   **V1**: V1.0
        # *   **V2**: V2.0
        self.registry_version = registry_version  # type: str
        # The source IP address of the request.
        self.source_ip = source_ip  # type: str
        # The number of images that can be scanned per hour.
        self.trans_per_hour = trans_per_hour  # type: int
        # The username.
        self.user_name = user_name  # type: str
        # The ID of the VPC.
        self.vpc_id = vpc_id  # type: str
        # The whitelist of IP addresses.
        self.white_list = white_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateJenkinsImageRegistryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.extra_param is not None:
            result['ExtraParam'] = self.extra_param
        if self.net_type is not None:
            result['NetType'] = self.net_type
        if self.password is not None:
            result['Password'] = self.password
        if self.persistence_day is not None:
            result['PersistenceDay'] = self.persistence_day
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.registry_host_ip is not None:
            result['RegistryHostIp'] = self.registry_host_ip
        if self.registry_name is not None:
            result['RegistryName'] = self.registry_name
        if self.registry_type is not None:
            result['RegistryType'] = self.registry_type
        if self.registry_version is not None:
            result['RegistryVersion'] = self.registry_version
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.trans_per_hour is not None:
            result['TransPerHour'] = self.trans_per_hour
        if self.user_name is not None:
            result['UserName'] = self.user_name
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.white_list is not None:
            result['WhiteList'] = self.white_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('ExtraParam') is not None:
            self.extra_param = m.get('ExtraParam')
        if m.get('NetType') is not None:
            self.net_type = m.get('NetType')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('PersistenceDay') is not None:
            self.persistence_day = m.get('PersistenceDay')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RegistryHostIp') is not None:
            self.registry_host_ip = m.get('RegistryHostIp')
        if m.get('RegistryName') is not None:
            self.registry_name = m.get('RegistryName')
        if m.get('RegistryType') is not None:
            self.registry_type = m.get('RegistryType')
        if m.get('RegistryVersion') is not None:
            self.registry_version = m.get('RegistryVersion')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('TransPerHour') is not None:
            self.trans_per_hour = m.get('TransPerHour')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('WhiteList') is not None:
            self.white_list = m.get('WhiteList')
        return self


class CreateJenkinsImageRegistryResponseBodyData(TeaModel):
    def __init__(self, black_list=None, domain_name=None, gmt_create=None, gmt_modified=None, id=None, net_type=None,
                 password=None, persistence_day=None, protocol_type=None, region_id=None, registry_host_ip=None,
                 registry_name=None, registry_type=None, token=None, trans_per_hour=None, user_name=None, vpc_id=None,
                 white_list=None):
        # The blacklist.
        self.black_list = black_list  # type: str
        # The domain name of the image repository.
        self.domain_name = domain_name  # type: str
        # The creation time. The time is in the yyyy-MM-dd HH:mm:ss format.
        self.gmt_create = gmt_create  # type: str
        # The update time. The time is in the yyyy-MM-dd HH:mm:ss format.
        self.gmt_modified = gmt_modified  # type: str
        # The ID of the image repository.
        self.id = id  # type: long
        # The network type. Valid values:
        # 
        # *   **1**: Internet
        # *   **2**: VPC
        self.net_type = net_type  # type: int
        # The password.
        self.password = password  # type: str
        # The number of days during which assets can be retained.
        self.persistence_day = persistence_day  # type: int
        # The type of the protocol. Valid values:
        # 
        # *   **1**: HTTP
        # *   **2**: HTTPS
        self.protocol_type = protocol_type  # type: int
        # The region ID of the image repository.
        self.region_id = region_id  # type: str
        # The IP address of the image repository.
        self.registry_host_ip = registry_host_ip  # type: str
        # The alias of the image repository.
        self.registry_name = registry_name  # type: str
        # The type of the image repository. Valid values:
        # 
        # *   **CI/CD**: Jenkins
        self.registry_type = registry_type  # type: str
        # The authentication token of the user.
        self.token = token  # type: str
        # The number of images that can be scanned per hour.
        self.trans_per_hour = trans_per_hour  # type: int
        # The username.
        self.user_name = user_name  # type: str
        # The ID of the VPC.
        self.vpc_id = vpc_id  # type: str
        # The whitelist.
        self.white_list = white_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateJenkinsImageRegistryResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.black_list is not None:
            result['BlackList'] = self.black_list
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.id is not None:
            result['Id'] = self.id
        if self.net_type is not None:
            result['NetType'] = self.net_type
        if self.password is not None:
            result['Password'] = self.password
        if self.persistence_day is not None:
            result['PersistenceDay'] = self.persistence_day
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.registry_host_ip is not None:
            result['RegistryHostIp'] = self.registry_host_ip
        if self.registry_name is not None:
            result['RegistryName'] = self.registry_name
        if self.registry_type is not None:
            result['RegistryType'] = self.registry_type
        if self.token is not None:
            result['Token'] = self.token
        if self.trans_per_hour is not None:
            result['TransPerHour'] = self.trans_per_hour
        if self.user_name is not None:
            result['UserName'] = self.user_name
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.white_list is not None:
            result['WhiteList'] = self.white_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BlackList') is not None:
            self.black_list = m.get('BlackList')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('NetType') is not None:
            self.net_type = m.get('NetType')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('PersistenceDay') is not None:
            self.persistence_day = m.get('PersistenceDay')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RegistryHostIp') is not None:
            self.registry_host_ip = m.get('RegistryHostIp')
        if m.get('RegistryName') is not None:
            self.registry_name = m.get('RegistryName')
        if m.get('RegistryType') is not None:
            self.registry_type = m.get('RegistryType')
        if m.get('Token') is not None:
            self.token = m.get('Token')
        if m.get('TransPerHour') is not None:
            self.trans_per_hour = m.get('TransPerHour')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('WhiteList') is not None:
            self.white_list = m.get('WhiteList')
        return self


class CreateJenkinsImageRegistryResponseBody(TeaModel):
    def __init__(self, data=None, http_status_code=None, request_id=None, time_cost=None):
        # The result of creating the image repository.
        self.data = data  # type: CreateJenkinsImageRegistryResponseBodyData
        # The HTTP status code returned.
        self.http_status_code = http_status_code  # type: int
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The time consumed. Unit: seconds.
        self.time_cost = time_cost  # type: long

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateJenkinsImageRegistryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.time_cost is not None:
            result['TimeCost'] = self.time_cost
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = CreateJenkinsImageRegistryResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TimeCost') is not None:
            self.time_cost = m.get('TimeCost')
        return self


class CreateJenkinsImageRegistryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateJenkinsImageRegistryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateJenkinsImageRegistryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateJenkinsImageRegistryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOrUpdateAssetGroupRequest(TeaModel):
    def __init__(self, group_id=None, group_name=None, uuids=None):
        self.group_id = group_id  # type: long
        self.group_name = group_name  # type: str
        self.uuids = uuids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOrUpdateAssetGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        return self


class CreateOrUpdateAssetGroupResponseBody(TeaModel):
    def __init__(self, group_id=None, request_id=None):
        self.group_id = group_id  # type: long
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOrUpdateAssetGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateOrUpdateAssetGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateOrUpdateAssetGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateOrUpdateAssetGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateOrUpdateAssetGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRestoreJobRequest(TeaModel):
    def __init__(self, includes=None, snapshot_hash=None, snapshot_id=None, snapshot_version=None, source_type=None,
                 target=None, uuid=None, vault_id=None):
        # The directory in which the files included in the restoration task are located. This parameter is specified when you create the anti-ransomware policy. The value is a directory that requires protection.
        self.includes = includes  # type: str
        # The hash value of the snapshot.
        # 
        # > You can call the [DescribeSnapshots](~~DescribeSnapshots~~) operation to obtain the value of this parameter.
        self.snapshot_hash = snapshot_hash  # type: str
        # The ID of the snapshot that you want to use for restoration.
        # 
        # > You can call the [DescribeSnapshots](~~DescribeSnapshots~~) operation to obtain the value of this parameter.
        self.snapshot_id = snapshot_id  # type: str
        # The version of the backup data.
        # 
        # > You can call the [DescribeSnapshots](~~DescribeSnapshots~~) operation to obtain the value of this parameter.
        self.snapshot_version = snapshot_version  # type: str
        # The type of the data source. Valid values:
        # 
        # *   **ECS_FILE**: backup snapshots for Elastic Compute Service (ECS) files
        # *   **File**: backup snapshots for on-premises servers
        self.source_type = source_type  # type: str
        # The path to which you want to restore data.
        self.target = target  # type: str
        # The UUID of the server whose data you want to restore.
        self.uuid = uuid  # type: str
        # The ID of the backup vault that is used in the restoration task.
        # 
        # > You can call the [DescribeSnapshots](~~DescribeSnapshots~~) operation to obtain the value of this parameter.
        self.vault_id = vault_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateRestoreJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.includes is not None:
            result['Includes'] = self.includes
        if self.snapshot_hash is not None:
            result['SnapshotHash'] = self.snapshot_hash
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        if self.snapshot_version is not None:
            result['SnapshotVersion'] = self.snapshot_version
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.target is not None:
            result['Target'] = self.target
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.vault_id is not None:
            result['VaultId'] = self.vault_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Includes') is not None:
            self.includes = m.get('Includes')
        if m.get('SnapshotHash') is not None:
            self.snapshot_hash = m.get('SnapshotHash')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        if m.get('SnapshotVersion') is not None:
            self.snapshot_version = m.get('SnapshotVersion')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('Target') is not None:
            self.target = m.get('Target')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('VaultId') is not None:
            self.vault_id = m.get('VaultId')
        return self


class CreateRestoreJobResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateRestoreJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateRestoreJobResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateRestoreJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateRestoreJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateRestoreJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateServiceLinkedRoleRequest(TeaModel):
    def __init__(self, service_linked_role=None):
        # The service-linked role. Default value: **AliyunServiceRoleForSas**. Valid values:
        # 
        # *   **AliyunServiceRoleForSas**: the service-linked role of Security Center. Security Center assumes this role to access the resources of other cloud services within your account.
        # *   **AliyunServiceRoleForSasCspm**: the service-linked role of Security Center-CSPM. Security Center-CSPM assumes this role to access the resources of other cloud services within your account.
        self.service_linked_role = service_linked_role  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateServiceLinkedRoleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_linked_role is not None:
            result['ServiceLinkedRole'] = self.service_linked_role
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ServiceLinkedRole') is not None:
            self.service_linked_role = m.get('ServiceLinkedRole')
        return self


class CreateServiceLinkedRoleResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateServiceLinkedRoleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateServiceLinkedRoleResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateServiceLinkedRoleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateServiceLinkedRoleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateServiceLinkedRoleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSimilarSecurityEventsQueryTaskRequest(TeaModel):
    def __init__(self, resource_owner_id=None, security_event_id=None, similar_event_scenario_code=None,
                 source_ip=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.security_event_id = security_event_id  # type: long
        self.similar_event_scenario_code = similar_event_scenario_code  # type: str
        self.source_ip = source_ip  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSimilarSecurityEventsQueryTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.security_event_id is not None:
            result['SecurityEventId'] = self.security_event_id
        if self.similar_event_scenario_code is not None:
            result['SimilarEventScenarioCode'] = self.similar_event_scenario_code
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SecurityEventId') is not None:
            self.security_event_id = m.get('SecurityEventId')
        if m.get('SimilarEventScenarioCode') is not None:
            self.similar_event_scenario_code = m.get('SimilarEventScenarioCode')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class CreateSimilarSecurityEventsQueryTaskResponseBodyCreateSimilarSecurityEventsQueryTaskResponse(TeaModel):
    def __init__(self, status=None, task_id=None):
        self.status = status  # type: str
        self.task_id = task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSimilarSecurityEventsQueryTaskResponseBodyCreateSimilarSecurityEventsQueryTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class CreateSimilarSecurityEventsQueryTaskResponseBody(TeaModel):
    def __init__(self, create_similar_security_events_query_task_response=None, request_id=None):
        self.create_similar_security_events_query_task_response = create_similar_security_events_query_task_response  # type: CreateSimilarSecurityEventsQueryTaskResponseBodyCreateSimilarSecurityEventsQueryTaskResponse
        self.request_id = request_id  # type: str

    def validate(self):
        if self.create_similar_security_events_query_task_response:
            self.create_similar_security_events_query_task_response.validate()

    def to_map(self):
        _map = super(CreateSimilarSecurityEventsQueryTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_similar_security_events_query_task_response is not None:
            result['CreateSimilarSecurityEventsQueryTaskResponse'] = self.create_similar_security_events_query_task_response.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateSimilarSecurityEventsQueryTaskResponse') is not None:
            temp_model = CreateSimilarSecurityEventsQueryTaskResponseBodyCreateSimilarSecurityEventsQueryTaskResponse()
            self.create_similar_security_events_query_task_response = temp_model.from_map(m['CreateSimilarSecurityEventsQueryTaskResponse'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateSimilarSecurityEventsQueryTaskResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateSimilarSecurityEventsQueryTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateSimilarSecurityEventsQueryTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSimilarSecurityEventsQueryTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSuspEventNoteRequest(TeaModel):
    def __init__(self, event_id=None, note=None):
        # The ID of the alert event to which you want to add remarks. You can call the [DescribeSuspEvents](~~251497~~) operation to query the IDs of alert events.
        self.event_id = event_id  # type: long
        # The remarks that you want to add.
        self.note = note  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSuspEventNoteRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_id is not None:
            result['EventId'] = self.event_id
        if self.note is not None:
            result['Note'] = self.note
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EventId') is not None:
            self.event_id = m.get('EventId')
        if m.get('Note') is not None:
            self.note = m.get('Note')
        return self


class CreateSuspEventNoteResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, success=None):
        # The status code returned. The status code **200** indicates that the request was successful. Other status codes indicate that the request failed. You can identify the cause of the failure based on the status code.
        self.code = code  # type: str
        # The HTTP status code returned.
        self.http_status_code = http_status_code  # type: int
        # The error message returned.
        self.message = message  # type: str
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id  # type: str
        # Indicates whether exceptions are handled. Valid values:
        # 
        # *   **true**: yes
        # *   **false**: no
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSuspEventNoteResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateSuspEventNoteResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateSuspEventNoteResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateSuspEventNoteResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSuspEventNoteResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateUniBackupPolicyRequest(TeaModel):
    def __init__(self, account_name=None, account_password=None, database_add_by_user=None, database_type=None,
                 full_plan=None, inc_plan=None, instance_id=None, policy_name=None, retention=None, speed_limiter=None,
                 uni_region_id=None, uuid=None):
        # The name of the database account.
        self.account_name = account_name  # type: str
        # The password of the database account.
        self.account_password = account_password  # type: str
        # Specifies whether the database is manually added. Valid values:
        # 
        # *   **true**: yes
        # *   **false**: no
        self.database_add_by_user = database_add_by_user  # type: str
        # The type of the database. Valid values:
        # 
        # *   **MYSQL**\
        # *   **ORACLE**\
        # *   **MSSQL**\
        self.database_type = database_type  # type: str
        # The policy for full backup. The value of this parameter is a JSON string that contains the following fields:
        # 
        # *   **start**: the start time of a backup task
        # *   **interval**: the interval of backup tasks
        # *   **type**: the unit of the interval
        # *   **days**: the days of a week on which a backup task is performed
        self.full_plan = full_plan  # type: dict[str, any]
        # The policy for incremental backup. The value of this parameter is a JSON string that contains the following fields:
        # 
        # *   **start**: the start time of a backup task
        # *   **interval**: the interval of backup tasks
        # *   **type**: the unit of the interval
        # *   **days**: the days of a week on which a backup task is performed
        self.inc_plan = inc_plan  # type: dict[str, any]
        # The ID of the Elastic Compute Service (ECS) instance.
        # 
        # >  You can call the [DescribeUniBackupDatabase](~~DescribeUniBackupDatabase~~) operation to query the IDs of ECS instances.
        self.instance_id = instance_id  # type: str
        # The name of the anti-ransomware policy.
        self.policy_name = policy_name  # type: str
        # The retention period of backup data.
        self.retention = retention  # type: int
        # The maximum network bandwidth that is allowed during data backup. Unit: bytes.
        self.speed_limiter = speed_limiter  # type: long
        # The region in which the server resides.
        self.uni_region_id = uni_region_id  # type: str
        # The UUID of the server whose data is backed up based on the anti-ransomware policy.
        # 
        # >  You can call the [DescribeCloudCenterInstances](~~141932~~) operation to query the UUIDs of servers.
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateUniBackupPolicyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.account_password is not None:
            result['AccountPassword'] = self.account_password
        if self.database_add_by_user is not None:
            result['DatabaseAddByUser'] = self.database_add_by_user
        if self.database_type is not None:
            result['DatabaseType'] = self.database_type
        if self.full_plan is not None:
            result['FullPlan'] = self.full_plan
        if self.inc_plan is not None:
            result['IncPlan'] = self.inc_plan
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.policy_name is not None:
            result['PolicyName'] = self.policy_name
        if self.retention is not None:
            result['Retention'] = self.retention
        if self.speed_limiter is not None:
            result['SpeedLimiter'] = self.speed_limiter
        if self.uni_region_id is not None:
            result['UniRegionId'] = self.uni_region_id
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('AccountPassword') is not None:
            self.account_password = m.get('AccountPassword')
        if m.get('DatabaseAddByUser') is not None:
            self.database_add_by_user = m.get('DatabaseAddByUser')
        if m.get('DatabaseType') is not None:
            self.database_type = m.get('DatabaseType')
        if m.get('FullPlan') is not None:
            self.full_plan = m.get('FullPlan')
        if m.get('IncPlan') is not None:
            self.inc_plan = m.get('IncPlan')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PolicyName') is not None:
            self.policy_name = m.get('PolicyName')
        if m.get('Retention') is not None:
            self.retention = m.get('Retention')
        if m.get('SpeedLimiter') is not None:
            self.speed_limiter = m.get('SpeedLimiter')
        if m.get('UniRegionId') is not None:
            self.uni_region_id = m.get('UniRegionId')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class CreateUniBackupPolicyShrinkRequest(TeaModel):
    def __init__(self, account_name=None, account_password=None, database_add_by_user=None, database_type=None,
                 full_plan_shrink=None, inc_plan_shrink=None, instance_id=None, policy_name=None, retention=None, speed_limiter=None,
                 uni_region_id=None, uuid=None):
        # The name of the database account.
        self.account_name = account_name  # type: str
        # The password of the database account.
        self.account_password = account_password  # type: str
        # Specifies whether the database is manually added. Valid values:
        # 
        # *   **true**: yes
        # *   **false**: no
        self.database_add_by_user = database_add_by_user  # type: str
        # The type of the database. Valid values:
        # 
        # *   **MYSQL**\
        # *   **ORACLE**\
        # *   **MSSQL**\
        self.database_type = database_type  # type: str
        # The policy for full backup. The value of this parameter is a JSON string that contains the following fields:
        # 
        # *   **start**: the start time of a backup task
        # *   **interval**: the interval of backup tasks
        # *   **type**: the unit of the interval
        # *   **days**: the days of a week on which a backup task is performed
        self.full_plan_shrink = full_plan_shrink  # type: str
        # The policy for incremental backup. The value of this parameter is a JSON string that contains the following fields:
        # 
        # *   **start**: the start time of a backup task
        # *   **interval**: the interval of backup tasks
        # *   **type**: the unit of the interval
        # *   **days**: the days of a week on which a backup task is performed
        self.inc_plan_shrink = inc_plan_shrink  # type: str
        # The ID of the Elastic Compute Service (ECS) instance.
        # 
        # >  You can call the [DescribeUniBackupDatabase](~~DescribeUniBackupDatabase~~) operation to query the IDs of ECS instances.
        self.instance_id = instance_id  # type: str
        # The name of the anti-ransomware policy.
        self.policy_name = policy_name  # type: str
        # The retention period of backup data.
        self.retention = retention  # type: int
        # The maximum network bandwidth that is allowed during data backup. Unit: bytes.
        self.speed_limiter = speed_limiter  # type: long
        # The region in which the server resides.
        self.uni_region_id = uni_region_id  # type: str
        # The UUID of the server whose data is backed up based on the anti-ransomware policy.
        # 
        # >  You can call the [DescribeCloudCenterInstances](~~141932~~) operation to query the UUIDs of servers.
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateUniBackupPolicyShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.account_password is not None:
            result['AccountPassword'] = self.account_password
        if self.database_add_by_user is not None:
            result['DatabaseAddByUser'] = self.database_add_by_user
        if self.database_type is not None:
            result['DatabaseType'] = self.database_type
        if self.full_plan_shrink is not None:
            result['FullPlan'] = self.full_plan_shrink
        if self.inc_plan_shrink is not None:
            result['IncPlan'] = self.inc_plan_shrink
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.policy_name is not None:
            result['PolicyName'] = self.policy_name
        if self.retention is not None:
            result['Retention'] = self.retention
        if self.speed_limiter is not None:
            result['SpeedLimiter'] = self.speed_limiter
        if self.uni_region_id is not None:
            result['UniRegionId'] = self.uni_region_id
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('AccountPassword') is not None:
            self.account_password = m.get('AccountPassword')
        if m.get('DatabaseAddByUser') is not None:
            self.database_add_by_user = m.get('DatabaseAddByUser')
        if m.get('DatabaseType') is not None:
            self.database_type = m.get('DatabaseType')
        if m.get('FullPlan') is not None:
            self.full_plan_shrink = m.get('FullPlan')
        if m.get('IncPlan') is not None:
            self.inc_plan_shrink = m.get('IncPlan')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PolicyName') is not None:
            self.policy_name = m.get('PolicyName')
        if m.get('Retention') is not None:
            self.retention = m.get('Retention')
        if m.get('SpeedLimiter') is not None:
            self.speed_limiter = m.get('SpeedLimiter')
        if m.get('UniRegionId') is not None:
            self.uni_region_id = m.get('UniRegionId')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class CreateUniBackupPolicyResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateUniBackupPolicyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateUniBackupPolicyResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateUniBackupPolicyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateUniBackupPolicyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateUniBackupPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateUniRestorePlanRequest(TeaModel):
    def __init__(self, database=None, instance_uuid=None, policy_id=None, reset_scn=None, reset_time=None,
                 restore_info=None, time_point=None):
        self.database = database  # type: str
        self.instance_uuid = instance_uuid  # type: str
        self.policy_id = policy_id  # type: long
        self.reset_scn = reset_scn  # type: str
        self.reset_time = reset_time  # type: str
        self.restore_info = restore_info  # type: str
        self.time_point = time_point  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateUniRestorePlanRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.database is not None:
            result['Database'] = self.database
        if self.instance_uuid is not None:
            result['InstanceUuid'] = self.instance_uuid
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.reset_scn is not None:
            result['ResetScn'] = self.reset_scn
        if self.reset_time is not None:
            result['ResetTime'] = self.reset_time
        if self.restore_info is not None:
            result['RestoreInfo'] = self.restore_info
        if self.time_point is not None:
            result['TimePoint'] = self.time_point
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Database') is not None:
            self.database = m.get('Database')
        if m.get('InstanceUuid') is not None:
            self.instance_uuid = m.get('InstanceUuid')
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('ResetScn') is not None:
            self.reset_scn = m.get('ResetScn')
        if m.get('ResetTime') is not None:
            self.reset_time = m.get('ResetTime')
        if m.get('RestoreInfo') is not None:
            self.restore_info = m.get('RestoreInfo')
        if m.get('TimePoint') is not None:
            self.time_point = m.get('TimePoint')
        return self


class CreateUniRestorePlanResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateUniRestorePlanResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateUniRestorePlanResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateUniRestorePlanResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateUniRestorePlanResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateUniRestorePlanResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateVulAutoRepairConfigRequestVulAutoRepairConfigList(TeaModel):
    def __init__(self, alias_name=None, name=None):
        # The alias of the vulnerability.
        self.alias_name = alias_name  # type: str
        # The name of the vulnerability.
        self.name = name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateVulAutoRepairConfigRequestVulAutoRepairConfigList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreateVulAutoRepairConfigRequest(TeaModel):
    def __init__(self, reason=None, type=None, vul_auto_repair_config_list=None):
        # The reason why the vulnerability can be automatically fixed.
        self.reason = reason  # type: str
        # The type of the vulnerability. Valid values: 
        # - **cve**: Linux software vulnerability 
        # - **sys**: Windows system vulnerability
        self.type = type  # type: str
        # The vulnerabilities that can be automatically fixed.
        self.vul_auto_repair_config_list = vul_auto_repair_config_list  # type: list[CreateVulAutoRepairConfigRequestVulAutoRepairConfigList]

    def validate(self):
        if self.vul_auto_repair_config_list:
            for k in self.vul_auto_repair_config_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateVulAutoRepairConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.reason is not None:
            result['Reason'] = self.reason
        if self.type is not None:
            result['Type'] = self.type
        result['VulAutoRepairConfigList'] = []
        if self.vul_auto_repair_config_list is not None:
            for k in self.vul_auto_repair_config_list:
                result['VulAutoRepairConfigList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        self.vul_auto_repair_config_list = []
        if m.get('VulAutoRepairConfigList') is not None:
            for k in m.get('VulAutoRepairConfigList'):
                temp_model = CreateVulAutoRepairConfigRequestVulAutoRepairConfigList()
                self.vul_auto_repair_config_list.append(temp_model.from_map(k))
        return self


class CreateVulAutoRepairConfigResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, success=None):
        # The status code returned. The status code **200** indicates that the request was successful. Other status codes indicate that the request failed. You can identify the cause of the failure based on the status code.
        self.code = code  # type: str
        # The HTTP status code returned.
        self.http_status_code = http_status_code  # type: int
        # The error message returned.
        self.message = message  # type: str
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id  # type: str
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**: The request was successful.
        # *   **false**: The request failed.
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateVulAutoRepairConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateVulAutoRepairConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateVulAutoRepairConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateVulAutoRepairConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateVulAutoRepairConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAntiBruteForceRuleRequest(TeaModel):
    def __init__(self, ids=None):
        # An array that consists of the IDs of the defense rules against brute-force attacks to delete.
        self.ids = ids  # type: list[long]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteAntiBruteForceRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ids is not None:
            result['Ids'] = self.ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Ids') is not None:
            self.ids = m.get('Ids')
        return self


class DeleteAntiBruteForceRuleResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteAntiBruteForceRuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteAntiBruteForceRuleResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteAntiBruteForceRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteAntiBruteForceRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteAntiBruteForceRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteBackupPolicyRequest(TeaModel):
    def __init__(self, id=None, policy_version=None):
        # The ID of the anti-ransomware policy that you want to delete.
        # 
        # >  You can call the [DescribeBackupPolicies](~~DescribeBackupPolicies~~) operation to query the IDs of anti-ransomware policies.
        self.id = id  # type: long
        # The version of the anti-ransomware policy that you want to delete. You can call the [DescribeBackupPolicies](~~DescribeBackupPolicies~~) operation to query the versions of anti-ransomware policies. Valid values:
        # 
        # *   **1.0.0**\
        # *   **2.0.0**\
        self.policy_version = policy_version  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteBackupPolicyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.policy_version is not None:
            result['PolicyVersion'] = self.policy_version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('PolicyVersion') is not None:
            self.policy_version = m.get('PolicyVersion')
        return self


class DeleteBackupPolicyResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteBackupPolicyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteBackupPolicyResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteBackupPolicyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteBackupPolicyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteBackupPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteBackupPolicyMachineRequest(TeaModel):
    def __init__(self, policy_id=None, policy_version=None, uuid=None, uuid_list=None):
        # The ID of the anti-ransomware policy.
        # >  You can call the [DescribeBackupPolicies](~~DescribeBackupPolicies~~) operation to query the **Id** of anti-ransomware policies.
        self.policy_id = policy_id  # type: long
        # The version of the anti-ransomware policy. Valid values:
        # 
        # *   **1.0.0**\
        # *   **2.0.0**\
        # 
        # >  You can call the [DescribeBackupPolicies](~~DescribeBackupPolicies~~) operation to query the versions of anti-ransomware policies.
        self.policy_version = policy_version  # type: str
        # The UUID of the server to which the anti-ransomware policy is applied.
        # 
        # >  You must specify at least one of the `UuidList` and `Uuid` parameters.
        self.uuid = uuid  # type: str
        # The UUIDs of the servers to which the anti-ransomware policy is applied.
        # 
        # >  You must specify at least one of the `UuidList` and `Uuid` parameters.
        self.uuid_list = uuid_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteBackupPolicyMachineRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.policy_version is not None:
            result['PolicyVersion'] = self.policy_version
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('PolicyVersion') is not None:
            self.policy_version = m.get('PolicyVersion')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class DeleteBackupPolicyMachineResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteBackupPolicyMachineResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteBackupPolicyMachineResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteBackupPolicyMachineResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteBackupPolicyMachineResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteBackupPolicyMachineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteClientUserDefineRuleRequest(TeaModel):
    def __init__(self, id_list=None):
        # The IDs of the custom defense rules.
        self.id_list = id_list  # type: list[long]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteClientUserDefineRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id_list is not None:
            result['IdList'] = self.id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IdList') is not None:
            self.id_list = m.get('IdList')
        return self


class DeleteClientUserDefineRuleResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteClientUserDefineRuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteClientUserDefineRuleResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteClientUserDefineRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteClientUserDefineRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteClientUserDefineRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCustomBlockRecordRequest(TeaModel):
    def __init__(self, id=None, resource_owner_id=None):
        self.id = id  # type: long
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCustomBlockRecordRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteCustomBlockRecordResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCustomBlockRecordResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCustomBlockRecordResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteCustomBlockRecordResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteCustomBlockRecordResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCustomBlockRecordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCycleTaskRequest(TeaModel):
    def __init__(self, config_id=None):
        # The ID of the task configuration.
        # 
        # >  You can call the [DescribeCycleTaskList](~~DescribeCycleTaskList~~) operation to query the IDs of task configurations.
        self.config_id = config_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCycleTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_id is not None:
            result['ConfigId'] = self.config_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConfigId') is not None:
            self.config_id = m.get('ConfigId')
        return self


class DeleteCycleTaskResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCycleTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCycleTaskResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteCycleTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteCycleTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCycleTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteGroupRequest(TeaModel):
    def __init__(self, group_id=None, source_ip=None):
        # The ID of the server group that you want to delete.
        # 
        # >  To delete a server group, you must provide the ID of the server group. You can call the [DescribeAllGroups](~~DescribeAllGroups~~) operation to query the ID.
        self.group_id = group_id  # type: long
        # The source IP address of the request.
        self.source_ip = source_ip  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DeleteGroupResponseBody(TeaModel):
    def __init__(self, code=None, request_id=None):
        # The status code returned. The status code **200** indicates that the request was successful. Other status codes indicate that the request failed. You can identify the cause of the failure based on the status code.
        self.code = code  # type: str
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteHoneypotRequest(TeaModel):
    def __init__(self, honeypot_id=None, lang=None):
        # The ID of the honeypot.
        # 
        # >  You can call the [ListHoneypot](~~ListHoneypot~~) operation to query the IDs of honeypots.
        self.honeypot_id = honeypot_id  # type: str
        self.lang = lang  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteHoneypotRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.honeypot_id is not None:
            result['HoneypotId'] = self.honeypot_id
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HoneypotId') is not None:
            self.honeypot_id = m.get('HoneypotId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DeleteHoneypotResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, success=None):
        # The status code returned. The status code **200** indicates that the request was successful. Other status codes indicate that the request failed. You can identify the cause of the failure based on the status code.
        self.code = code  # type: str
        # The HTTP status code returned.
        self.http_status_code = http_status_code  # type: int
        # The message returned.
        self.message = message  # type: str
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id  # type: str
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**: The request was successful.
        # *   **false**: The request failed.
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteHoneypotResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteHoneypotResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteHoneypotResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteHoneypotResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteHoneypotResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteHoneypotNodeRequest(TeaModel):
    def __init__(self, lang=None, node_id=None):
        self.lang = lang  # type: str
        self.node_id = node_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteHoneypotNodeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        return self


class DeleteHoneypotNodeResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteHoneypotNodeResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteHoneypotNodeResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteHoneypotNodeResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteHoneypotNodeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteHoneypotNodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteHoneypotPresetRequest(TeaModel):
    def __init__(self, honeypot_preset_id=None, lang=None):
        self.honeypot_preset_id = honeypot_preset_id  # type: str
        self.lang = lang  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteHoneypotPresetRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.honeypot_preset_id is not None:
            result['HoneypotPresetId'] = self.honeypot_preset_id
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HoneypotPresetId') is not None:
            self.honeypot_preset_id = m.get('HoneypotPresetId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DeleteHoneypotPresetResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteHoneypotPresetResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteHoneypotPresetResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteHoneypotPresetResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteHoneypotPresetResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteHoneypotPresetResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteHoneypotProbeRequest(TeaModel):
    def __init__(self, lang=None, probe_id=None):
        self.lang = lang  # type: str
        self.probe_id = probe_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteHoneypotProbeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.probe_id is not None:
            result['ProbeId'] = self.probe_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('ProbeId') is not None:
            self.probe_id = m.get('ProbeId')
        return self


class DeleteHoneypotProbeResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteHoneypotProbeResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteHoneypotProbeResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteHoneypotProbeResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteHoneypotProbeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteHoneypotProbeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteInstallCodeRequest(TeaModel):
    def __init__(self, captcha_code=None):
        self.captcha_code = captcha_code  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteInstallCodeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.captcha_code is not None:
            result['CaptchaCode'] = self.captcha_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CaptchaCode') is not None:
            self.captcha_code = m.get('CaptchaCode')
        return self


class DeleteInstallCodeResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteInstallCodeResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteInstallCodeResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteInstallCodeResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteInstallCodeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteInstallCodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteInterceptionRuleRequest(TeaModel):
    def __init__(self, cluster_id=None, rule_ids=None):
        self.cluster_id = cluster_id  # type: str
        self.rule_ids = rule_ids  # type: list[long]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteInterceptionRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.rule_ids is not None:
            result['RuleIds'] = self.rule_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('RuleIds') is not None:
            self.rule_ids = m.get('RuleIds')
        return self


class DeleteInterceptionRuleResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteInterceptionRuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteInterceptionRuleResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteInterceptionRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteInterceptionRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteInterceptionRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteInterceptionTargetRequest(TeaModel):
    def __init__(self, target_ids=None):
        self.target_ids = target_ids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteInterceptionTargetRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.target_ids is not None:
            result['TargetIds'] = self.target_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TargetIds') is not None:
            self.target_ids = m.get('TargetIds')
        return self


class DeleteInterceptionTargetResponseBody(TeaModel):
    def __init__(self, request_id=None, result=None):
        self.request_id = request_id  # type: str
        self.result = result  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteInterceptionTargetResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        return self


class DeleteInterceptionTargetResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteInterceptionTargetResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteInterceptionTargetResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteInterceptionTargetResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLoginBaseConfigRequest(TeaModel):
    def __init__(self, config=None, target=None, type=None):
        self.config = config  # type: str
        self.target = target  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLoginBaseConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config is not None:
            result['Config'] = self.config
        if self.target is not None:
            result['Target'] = self.target
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Config') is not None:
            self.config = m.get('Config')
        if m.get('Target') is not None:
            self.target = m.get('Target')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DeleteLoginBaseConfigResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLoginBaseConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLoginBaseConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteLoginBaseConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteLoginBaseConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLoginBaseConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeletePrivateRegistryRequest(TeaModel):
    def __init__(self, registry_id=None):
        # The ID of the image repository.
        # 
        # > You can call the [PageImageRegistry](~~PageImageRegistry~~) operation to query the IDs of image repositories.
        self.registry_id = registry_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeletePrivateRegistryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.registry_id is not None:
            result['RegistryId'] = self.registry_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegistryId') is not None:
            self.registry_id = m.get('RegistryId')
        return self


class DeletePrivateRegistryResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**: The request was successful.
        # *   **false**: The request failed.
        self.data = data  # type: bool
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeletePrivateRegistryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeletePrivateRegistryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeletePrivateRegistryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeletePrivateRegistryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeletePrivateRegistryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSecurityEventMarkMissListRequest(TeaModel):
    def __init__(self, ids=None, resource_owner_id=None):
        self.ids = ids  # type: list[long]
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSecurityEventMarkMissListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ids is not None:
            result['Ids'] = self.ids
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Ids') is not None:
            self.ids = m.get('Ids')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteSecurityEventMarkMissListResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSecurityEventMarkMissListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteSecurityEventMarkMissListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteSecurityEventMarkMissListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteSecurityEventMarkMissListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSecurityEventMarkMissListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteStrategyRequest(TeaModel):
    def __init__(self, id=None, lang=None, source_ip=None):
        self.id = id  # type: str
        self.lang = lang  # type: str
        self.source_ip = source_ip  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteStrategyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DeleteStrategyResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteStrategyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteStrategyResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteStrategyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteStrategyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteStrategyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSuspEventNodeRequest(TeaModel):
    def __init__(self, note_id=None):
        self.note_id = note_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSuspEventNodeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.note_id is not None:
            result['NoteId'] = self.note_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NoteId') is not None:
            self.note_id = m.get('NoteId')
        return self


class DeleteSuspEventNodeResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSuspEventNodeResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteSuspEventNodeResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteSuspEventNodeResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteSuspEventNodeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSuspEventNodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTagWithUuidRequest(TeaModel):
    def __init__(self, tag_name=None, uuid_list=None):
        self.tag_name = tag_name  # type: str
        self.uuid_list = uuid_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteTagWithUuidRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_name is not None:
            result['TagName'] = self.tag_name
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagName') is not None:
            self.tag_name = m.get('TagName')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class DeleteTagWithUuidResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteTagWithUuidResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteTagWithUuidResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteTagWithUuidResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteTagWithUuidResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteTagWithUuidResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteUniBackupPolicyRequest(TeaModel):
    def __init__(self, policy_id=None, policy_ids=None):
        self.policy_id = policy_id  # type: long
        self.policy_ids = policy_ids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteUniBackupPolicyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.policy_ids is not None:
            result['PolicyIds'] = self.policy_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('PolicyIds') is not None:
            self.policy_ids = m.get('PolicyIds')
        return self


class DeleteUniBackupPolicyResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteUniBackupPolicyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteUniBackupPolicyResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteUniBackupPolicyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteUniBackupPolicyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteUniBackupPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteVpcHoneyPotRequest(TeaModel):
    def __init__(self, vpc_id=None):
        # The ID of the virtual private cloud (VPC) on which the honeypot is deployed.
        # 
        # > You can call the [DescribeVpcHoneyPotList](~~DescribeVpcHoneyPotList~~) operation to query the IDs of VPCs.
        self.vpc_id = vpc_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteVpcHoneyPotRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class DeleteVpcHoneyPotResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteVpcHoneyPotResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteVpcHoneyPotResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteVpcHoneyPotResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteVpcHoneyPotResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteVpcHoneyPotResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteVulWhitelistRequest(TeaModel):
    def __init__(self, id=None, whitelist=None):
        # The ID of the whitelist.
        # 
        # >  To delete a vulnerability whitelist, you must provide the ID of the whitelist. You can call the [DescribeVulWhitelist](~~DescribeVulWhitelist~~) operation to query the IDs of whitelists.
        self.id = id  # type: str
        # The information about the whitelist. The value is a JSON string that contains the following fields:
        # 
        # *   **Name**: the name of the vulnerability.
        # 
        # *   **Type**: the type of the vulnerability. Valid values:
        # 
        #     *   **cve**: Linux software vulnerability
        #     *   **sys**: Windows system vulnerability
        #     *   **cms**: Web-CMS vulnerability
        #     *   **app**: application vulnerability
        #     *   **emg**: urgent vulnerability
        # 
        # *   **AliasName**: the alias of the vulnerability.
        self.whitelist = whitelist  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteVulWhitelistRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.whitelist is not None:
            result['Whitelist'] = self.whitelist
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Whitelist') is not None:
            self.whitelist = m.get('Whitelist')
        return self


class DeleteVulWhitelistResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteVulWhitelistResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteVulWhitelistResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteVulWhitelistResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteVulWhitelistResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteVulWhitelistResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAccessKeyLeakDetailRequest(TeaModel):
    def __init__(self, id=None):
        # The ID of the AccessKey pair leak.
        self.id = id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAccessKeyLeakDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class DescribeAccessKeyLeakDetailResponseBody(TeaModel):
    def __init__(self, accesskey_id=None, asset=None, code=None, deal_time=None, deal_type=None,
                 github_file_name=None, github_file_type=None, github_file_update_time=None, github_file_url=None,
                 github_repo_name=None, github_repo_url=None, github_user=None, github_user_pic_url=None, gmt_create=None,
                 gmt_modified=None, remark=None, request_id=None, source=None, type=None, whitelist_status=None):
        # The ID of the AccessKey pair that is leaked.
        self.accesskey_id = accesskey_id  # type: str
        # The platform to which the asset belongs. The value is fixed as **Cloud platform**.
        self.asset = asset  # type: str
        # The code snippet that is leaked.
        self.code = code  # type: str
        # The time when the AccessKey pair leak was handled.
        self.deal_time = deal_time  # type: str
        # The solution to the AccessKey pair leak. Valid values:
        # 
        # *   **manual**: manually deleted
        # *   **disable**: manually disabled
        # *   **add-whitelist**: added to the whitelist
        # *   **pending**: unhandled
        self.deal_type = deal_type  # type: str
        # The name of the GitHub file.
        self.github_file_name = github_file_name  # type: str
        # The type of the GitHub file. Valid values:
        # 
        # *   Python
        # *   XML
        # *   GO
        # *   Javascript
        # *   INI
        # *   JSON
        # *   C++\
        self.github_file_type = github_file_type  # type: str
        # The time when the GitHub file was updated.
        self.github_file_update_time = github_file_update_time  # type: str
        # The URL of the GitHub file.
        self.github_file_url = github_file_url  # type: str
        # The name of the GitHub repository.
        self.github_repo_name = github_repo_name  # type: str
        # The URL of the GitHub repository.
        self.github_repo_url = github_repo_url  # type: str
        # The username of the GitHub user.
        self.github_user = github_user  # type: str
        # The URL of the profile picture for the GitHub user.
        self.github_user_pic_url = github_user_pic_url  # type: str
        # The first time when the AccessKey pair leak was detected.
        self.gmt_create = gmt_create  # type: str
        # The last time when the AccessKey pair leak was detected.
        self.gmt_modified = gmt_modified  # type: str
        # The remarks of the AccessKey pair leak.
        self.remark = remark  # type: str
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id  # type: str
        # The platform on which the AccessKey pair leak is detected.
        self.source = source  # type: str
        # The type of the leak. The value is fixed as **AccessKey**.
        self.type = type  # type: str
        # Indicates whether the AccessKey pair leak is added to the whitelist. Valid values:
        # 
        # *   **no**: The AccessKey pair leak is not added to the whitelist.
        # *   **yes**: The AccessKey pair leak is added to the whitelist.
        self.whitelist_status = whitelist_status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAccessKeyLeakDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accesskey_id is not None:
            result['AccesskeyId'] = self.accesskey_id
        if self.asset is not None:
            result['Asset'] = self.asset
        if self.code is not None:
            result['Code'] = self.code
        if self.deal_time is not None:
            result['DealTime'] = self.deal_time
        if self.deal_type is not None:
            result['DealType'] = self.deal_type
        if self.github_file_name is not None:
            result['GithubFileName'] = self.github_file_name
        if self.github_file_type is not None:
            result['GithubFileType'] = self.github_file_type
        if self.github_file_update_time is not None:
            result['GithubFileUpdateTime'] = self.github_file_update_time
        if self.github_file_url is not None:
            result['GithubFileUrl'] = self.github_file_url
        if self.github_repo_name is not None:
            result['GithubRepoName'] = self.github_repo_name
        if self.github_repo_url is not None:
            result['GithubRepoUrl'] = self.github_repo_url
        if self.github_user is not None:
            result['GithubUser'] = self.github_user
        if self.github_user_pic_url is not None:
            result['GithubUserPicUrl'] = self.github_user_pic_url
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.source is not None:
            result['Source'] = self.source
        if self.type is not None:
            result['Type'] = self.type
        if self.whitelist_status is not None:
            result['WhitelistStatus'] = self.whitelist_status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccesskeyId') is not None:
            self.accesskey_id = m.get('AccesskeyId')
        if m.get('Asset') is not None:
            self.asset = m.get('Asset')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('DealTime') is not None:
            self.deal_time = m.get('DealTime')
        if m.get('DealType') is not None:
            self.deal_type = m.get('DealType')
        if m.get('GithubFileName') is not None:
            self.github_file_name = m.get('GithubFileName')
        if m.get('GithubFileType') is not None:
            self.github_file_type = m.get('GithubFileType')
        if m.get('GithubFileUpdateTime') is not None:
            self.github_file_update_time = m.get('GithubFileUpdateTime')
        if m.get('GithubFileUrl') is not None:
            self.github_file_url = m.get('GithubFileUrl')
        if m.get('GithubRepoName') is not None:
            self.github_repo_name = m.get('GithubRepoName')
        if m.get('GithubRepoUrl') is not None:
            self.github_repo_url = m.get('GithubRepoUrl')
        if m.get('GithubUser') is not None:
            self.github_user = m.get('GithubUser')
        if m.get('GithubUserPicUrl') is not None:
            self.github_user_pic_url = m.get('GithubUserPicUrl')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('WhitelistStatus') is not None:
            self.whitelist_status = m.get('WhitelistStatus')
        return self


class DescribeAccessKeyLeakDetailResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeAccessKeyLeakDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAccessKeyLeakDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAccessKeyLeakDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAccesskeyLeakListRequest(TeaModel):
    def __init__(self, current_page=None, page_size=None, query=None, start_ts=None, status=None):
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.query = query  # type: str
        self.start_ts = start_ts  # type: long
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAccesskeyLeakListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.query is not None:
            result['Query'] = self.query
        if self.start_ts is not None:
            result['StartTs'] = self.start_ts
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Query') is not None:
            self.query = m.get('Query')
        if m.get('StartTs') is not None:
            self.start_ts = m.get('StartTs')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeAccesskeyLeakListResponseBodyAccessKeyLeakList(TeaModel):
    def __init__(self, accesskey_id=None, ali_user_name=None, asset=None, deal_time=None, deal_type=None,
                 gmt_modified=None, id=None, status=None, type=None, url=None, user_type=None):
        self.accesskey_id = accesskey_id  # type: str
        self.ali_user_name = ali_user_name  # type: str
        self.asset = asset  # type: str
        self.deal_time = deal_time  # type: str
        self.deal_type = deal_type  # type: str
        self.gmt_modified = gmt_modified  # type: long
        self.id = id  # type: long
        self.status = status  # type: str
        self.type = type  # type: str
        self.url = url  # type: str
        self.user_type = user_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAccesskeyLeakListResponseBodyAccessKeyLeakList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accesskey_id is not None:
            result['AccesskeyId'] = self.accesskey_id
        if self.ali_user_name is not None:
            result['AliUserName'] = self.ali_user_name
        if self.asset is not None:
            result['Asset'] = self.asset
        if self.deal_time is not None:
            result['DealTime'] = self.deal_time
        if self.deal_type is not None:
            result['DealType'] = self.deal_type
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.id is not None:
            result['Id'] = self.id
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.url is not None:
            result['Url'] = self.url
        if self.user_type is not None:
            result['UserType'] = self.user_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccesskeyId') is not None:
            self.accesskey_id = m.get('AccesskeyId')
        if m.get('AliUserName') is not None:
            self.ali_user_name = m.get('AliUserName')
        if m.get('Asset') is not None:
            self.asset = m.get('Asset')
        if m.get('DealTime') is not None:
            self.deal_time = m.get('DealTime')
        if m.get('DealType') is not None:
            self.deal_type = m.get('DealType')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        if m.get('UserType') is not None:
            self.user_type = m.get('UserType')
        return self


class DescribeAccesskeyLeakListResponseBody(TeaModel):
    def __init__(self, access_key_leak_list=None, ak_leak_count=None, current_page=None, gmt_last=None,
                 page_size=None, request_id=None, total_count=None):
        self.access_key_leak_list = access_key_leak_list  # type: list[DescribeAccesskeyLeakListResponseBodyAccessKeyLeakList]
        self.ak_leak_count = ak_leak_count  # type: int
        self.current_page = current_page  # type: int
        self.gmt_last = gmt_last  # type: long
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        if self.access_key_leak_list:
            for k in self.access_key_leak_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAccesskeyLeakListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AccessKeyLeakList'] = []
        if self.access_key_leak_list is not None:
            for k in self.access_key_leak_list:
                result['AccessKeyLeakList'].append(k.to_map() if k else None)
        if self.ak_leak_count is not None:
            result['AkLeakCount'] = self.ak_leak_count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.gmt_last is not None:
            result['GmtLast'] = self.gmt_last
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.access_key_leak_list = []
        if m.get('AccessKeyLeakList') is not None:
            for k in m.get('AccessKeyLeakList'):
                temp_model = DescribeAccesskeyLeakListResponseBodyAccessKeyLeakList()
                self.access_key_leak_list.append(temp_model.from_map(k))
        if m.get('AkLeakCount') is not None:
            self.ak_leak_count = m.get('AkLeakCount')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('GmtLast') is not None:
            self.gmt_last = m.get('GmtLast')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeAccesskeyLeakListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeAccesskeyLeakListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAccesskeyLeakListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAccesskeyLeakListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAffectedAssetsRequest(TeaModel):
    def __init__(self, current=None, levels=None, page_size=None):
        self.current = current  # type: str
        self.levels = levels  # type: str
        self.page_size = page_size  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAffectedAssetsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current is not None:
            result['Current'] = self.current
        if self.levels is not None:
            result['Levels'] = self.levels
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Current') is not None:
            self.current = m.get('Current')
        if m.get('Levels') is not None:
            self.levels = m.get('Levels')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeAffectedAssetsResponseBodyAssetList(TeaModel):
    def __init__(self, instance_id=None, instance_name=None, internet_ip=None, intranet_ip=None, risk_num=None,
                 uuid=None):
        self.instance_id = instance_id  # type: str
        self.instance_name = instance_name  # type: str
        self.internet_ip = internet_ip  # type: str
        self.intranet_ip = intranet_ip  # type: str
        self.risk_num = risk_num  # type: int
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAffectedAssetsResponseBodyAssetList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.risk_num is not None:
            result['RiskNum'] = self.risk_num
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('RiskNum') is not None:
            self.risk_num = m.get('RiskNum')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeAffectedAssetsResponseBodyPageInfo(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, total_count=None):
        self.count = count  # type: int
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAffectedAssetsResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeAffectedAssetsResponseBody(TeaModel):
    def __init__(self, asset_list=None, page_info=None, request_id=None):
        self.asset_list = asset_list  # type: list[DescribeAffectedAssetsResponseBodyAssetList]
        self.page_info = page_info  # type: DescribeAffectedAssetsResponseBodyPageInfo
        self.request_id = request_id  # type: str

    def validate(self):
        if self.asset_list:
            for k in self.asset_list:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super(DescribeAffectedAssetsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AssetList'] = []
        if self.asset_list is not None:
            for k in self.asset_list:
                result['AssetList'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.asset_list = []
        if m.get('AssetList') is not None:
            for k in m.get('AssetList'):
                temp_model = DescribeAffectedAssetsResponseBodyAssetList()
                self.asset_list.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeAffectedAssetsResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAffectedAssetsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeAffectedAssetsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAffectedAssetsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAffectedAssetsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAffectedMaliciousFileImagesRequest(TeaModel):
    def __init__(self, cluster_id=None, cluster_name=None, container_id=None, current_page=None, image=None,
                 image_digest=None, image_layer=None, image_tag=None, lang=None, levels=None, malicious_md_5=None, namespace=None,
                 page_size=None, pod=None, repo_id=None, repo_instance_id=None, repo_name=None, repo_namespace=None,
                 repo_region_id=None, scan_range=None):
        self.cluster_id = cluster_id  # type: str
        self.cluster_name = cluster_name  # type: str
        self.container_id = container_id  # type: str
        self.current_page = current_page  # type: int
        self.image = image  # type: str
        self.image_digest = image_digest  # type: str
        self.image_layer = image_layer  # type: str
        self.image_tag = image_tag  # type: str
        self.lang = lang  # type: str
        self.levels = levels  # type: str
        self.malicious_md_5 = malicious_md_5  # type: str
        self.namespace = namespace  # type: str
        self.page_size = page_size  # type: str
        self.pod = pod  # type: str
        self.repo_id = repo_id  # type: str
        self.repo_instance_id = repo_instance_id  # type: str
        self.repo_name = repo_name  # type: str
        self.repo_namespace = repo_namespace  # type: str
        self.repo_region_id = repo_region_id  # type: str
        self.scan_range = scan_range  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAffectedMaliciousFileImagesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.container_id is not None:
            result['ContainerId'] = self.container_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.image is not None:
            result['Image'] = self.image
        if self.image_digest is not None:
            result['ImageDigest'] = self.image_digest
        if self.image_layer is not None:
            result['ImageLayer'] = self.image_layer
        if self.image_tag is not None:
            result['ImageTag'] = self.image_tag
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.levels is not None:
            result['Levels'] = self.levels
        if self.malicious_md_5 is not None:
            result['MaliciousMd5'] = self.malicious_md_5
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.pod is not None:
            result['Pod'] = self.pod
        if self.repo_id is not None:
            result['RepoId'] = self.repo_id
        if self.repo_instance_id is not None:
            result['RepoInstanceId'] = self.repo_instance_id
        if self.repo_name is not None:
            result['RepoName'] = self.repo_name
        if self.repo_namespace is not None:
            result['RepoNamespace'] = self.repo_namespace
        if self.repo_region_id is not None:
            result['RepoRegionId'] = self.repo_region_id
        if self.scan_range is not None:
            result['ScanRange'] = self.scan_range
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('ContainerId') is not None:
            self.container_id = m.get('ContainerId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Image') is not None:
            self.image = m.get('Image')
        if m.get('ImageDigest') is not None:
            self.image_digest = m.get('ImageDigest')
        if m.get('ImageLayer') is not None:
            self.image_layer = m.get('ImageLayer')
        if m.get('ImageTag') is not None:
            self.image_tag = m.get('ImageTag')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Levels') is not None:
            self.levels = m.get('Levels')
        if m.get('MaliciousMd5') is not None:
            self.malicious_md_5 = m.get('MaliciousMd5')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Pod') is not None:
            self.pod = m.get('Pod')
        if m.get('RepoId') is not None:
            self.repo_id = m.get('RepoId')
        if m.get('RepoInstanceId') is not None:
            self.repo_instance_id = m.get('RepoInstanceId')
        if m.get('RepoName') is not None:
            self.repo_name = m.get('RepoName')
        if m.get('RepoNamespace') is not None:
            self.repo_namespace = m.get('RepoNamespace')
        if m.get('RepoRegionId') is not None:
            self.repo_region_id = m.get('RepoRegionId')
        if m.get('ScanRange') is not None:
            self.scan_range = m.get('ScanRange')
        return self


class DescribeAffectedMaliciousFileImagesResponseBodyAffectedMaliciousFileImagesResponse(TeaModel):
    def __init__(self, cluster_id=None, cluster_name=None, container_id=None, digest=None, download_url=None,
                 file_path=None, first_scan_timestamp=None, high_light=None, image=None, image_uuid=None, instance_name=None,
                 internet_ip=None, intranet_ip=None, latest_scan_timestamp=None, latest_verify_timestamp=None, layer=None,
                 level=None, malicious_md_5=None, namespace=None, pod=None, repo_id=None, repo_instance_id=None,
                 repo_name=None, repo_region_id=None, status=None, tag=None, target_id=None, target_name=None,
                 target_type=None, uuid=None):
        self.cluster_id = cluster_id  # type: str
        self.cluster_name = cluster_name  # type: str
        self.container_id = container_id  # type: str
        self.digest = digest  # type: str
        self.download_url = download_url  # type: str
        self.file_path = file_path  # type: str
        self.first_scan_timestamp = first_scan_timestamp  # type: long
        self.high_light = high_light  # type: str
        self.image = image  # type: str
        self.image_uuid = image_uuid  # type: str
        self.instance_name = instance_name  # type: str
        self.internet_ip = internet_ip  # type: str
        self.intranet_ip = intranet_ip  # type: str
        self.latest_scan_timestamp = latest_scan_timestamp  # type: long
        self.latest_verify_timestamp = latest_verify_timestamp  # type: long
        self.layer = layer  # type: str
        self.level = level  # type: str
        self.malicious_md_5 = malicious_md_5  # type: str
        self.namespace = namespace  # type: str
        self.pod = pod  # type: str
        self.repo_id = repo_id  # type: str
        self.repo_instance_id = repo_instance_id  # type: str
        self.repo_name = repo_name  # type: str
        self.repo_region_id = repo_region_id  # type: str
        self.status = status  # type: int
        self.tag = tag  # type: str
        self.target_id = target_id  # type: str
        self.target_name = target_name  # type: str
        self.target_type = target_type  # type: str
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAffectedMaliciousFileImagesResponseBodyAffectedMaliciousFileImagesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.container_id is not None:
            result['ContainerId'] = self.container_id
        if self.digest is not None:
            result['Digest'] = self.digest
        if self.download_url is not None:
            result['DownloadUrl'] = self.download_url
        if self.file_path is not None:
            result['FilePath'] = self.file_path
        if self.first_scan_timestamp is not None:
            result['FirstScanTimestamp'] = self.first_scan_timestamp
        if self.high_light is not None:
            result['HighLight'] = self.high_light
        if self.image is not None:
            result['Image'] = self.image
        if self.image_uuid is not None:
            result['ImageUuid'] = self.image_uuid
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.latest_scan_timestamp is not None:
            result['LatestScanTimestamp'] = self.latest_scan_timestamp
        if self.latest_verify_timestamp is not None:
            result['LatestVerifyTimestamp'] = self.latest_verify_timestamp
        if self.layer is not None:
            result['Layer'] = self.layer
        if self.level is not None:
            result['Level'] = self.level
        if self.malicious_md_5 is not None:
            result['MaliciousMd5'] = self.malicious_md_5
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.pod is not None:
            result['Pod'] = self.pod
        if self.repo_id is not None:
            result['RepoId'] = self.repo_id
        if self.repo_instance_id is not None:
            result['RepoInstanceId'] = self.repo_instance_id
        if self.repo_name is not None:
            result['RepoName'] = self.repo_name
        if self.repo_region_id is not None:
            result['RepoRegionId'] = self.repo_region_id
        if self.status is not None:
            result['Status'] = self.status
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.target_id is not None:
            result['TargetId'] = self.target_id
        if self.target_name is not None:
            result['TargetName'] = self.target_name
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('ContainerId') is not None:
            self.container_id = m.get('ContainerId')
        if m.get('Digest') is not None:
            self.digest = m.get('Digest')
        if m.get('DownloadUrl') is not None:
            self.download_url = m.get('DownloadUrl')
        if m.get('FilePath') is not None:
            self.file_path = m.get('FilePath')
        if m.get('FirstScanTimestamp') is not None:
            self.first_scan_timestamp = m.get('FirstScanTimestamp')
        if m.get('HighLight') is not None:
            self.high_light = m.get('HighLight')
        if m.get('Image') is not None:
            self.image = m.get('Image')
        if m.get('ImageUuid') is not None:
            self.image_uuid = m.get('ImageUuid')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('LatestScanTimestamp') is not None:
            self.latest_scan_timestamp = m.get('LatestScanTimestamp')
        if m.get('LatestVerifyTimestamp') is not None:
            self.latest_verify_timestamp = m.get('LatestVerifyTimestamp')
        if m.get('Layer') is not None:
            self.layer = m.get('Layer')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('MaliciousMd5') is not None:
            self.malicious_md_5 = m.get('MaliciousMd5')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Pod') is not None:
            self.pod = m.get('Pod')
        if m.get('RepoId') is not None:
            self.repo_id = m.get('RepoId')
        if m.get('RepoInstanceId') is not None:
            self.repo_instance_id = m.get('RepoInstanceId')
        if m.get('RepoName') is not None:
            self.repo_name = m.get('RepoName')
        if m.get('RepoRegionId') is not None:
            self.repo_region_id = m.get('RepoRegionId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('TargetId') is not None:
            self.target_id = m.get('TargetId')
        if m.get('TargetName') is not None:
            self.target_name = m.get('TargetName')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeAffectedMaliciousFileImagesResponseBodyPageInfo(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, total_count=None):
        self.count = count  # type: int
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAffectedMaliciousFileImagesResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeAffectedMaliciousFileImagesResponseBody(TeaModel):
    def __init__(self, affected_malicious_file_images_response=None, page_info=None, request_id=None):
        self.affected_malicious_file_images_response = affected_malicious_file_images_response  # type: list[DescribeAffectedMaliciousFileImagesResponseBodyAffectedMaliciousFileImagesResponse]
        self.page_info = page_info  # type: DescribeAffectedMaliciousFileImagesResponseBodyPageInfo
        self.request_id = request_id  # type: str

    def validate(self):
        if self.affected_malicious_file_images_response:
            for k in self.affected_malicious_file_images_response:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super(DescribeAffectedMaliciousFileImagesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AffectedMaliciousFileImagesResponse'] = []
        if self.affected_malicious_file_images_response is not None:
            for k in self.affected_malicious_file_images_response:
                result['AffectedMaliciousFileImagesResponse'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.affected_malicious_file_images_response = []
        if m.get('AffectedMaliciousFileImagesResponse') is not None:
            for k in m.get('AffectedMaliciousFileImagesResponse'):
                temp_model = DescribeAffectedMaliciousFileImagesResponseBodyAffectedMaliciousFileImagesResponse()
                self.affected_malicious_file_images_response.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeAffectedMaliciousFileImagesResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAffectedMaliciousFileImagesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeAffectedMaliciousFileImagesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAffectedMaliciousFileImagesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAffectedMaliciousFileImagesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAgentInstallStatusRequest(TeaModel):
    def __init__(self, lang=None, source_ip=None, uuids=None):
        # The language of the content within the request and response. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang  # type: str
        # The source IP address of the request.
        self.source_ip = source_ip  # type: str
        # The UUIDs of the servers. Separate multiple UUIDs with commas (,).
        self.uuids = uuids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAgentInstallStatusRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        return self


class DescribeAgentInstallStatusResponseBodyAegisClientInvokeStatusResponseList(TeaModel):
    def __init__(self, message=None, resule_code=None, result=None, uuid=None):
        # The message returned.
        self.message = message  # type: str
        # The result code returned. Valid values:
        # 
        # *   **-1**: The agent is not installed.
        # *   **0**: The agent is installed.
        # *   **1**: The directory of the agent failed to be created.
        # *   **2**: The installation package failed to be downloaded.
        # *   **3**: The installation file does not exist.
        # *   **4**: The verification information about the installation file does not exist.
        # *   **5**: The installation file failed to pass the verification.
        # *   **6**: The installation file failed to be executed.
        # *   **7**: The agent failed to be installed because the required permissions are not granted.
        # *   **8**: No process of the agent was detected.
        # *   **100**: The agent failed to be installed because an unknown error occurred.
        # *   **1001**: The agent failed to be installed because the automatic installation of the agent is not supported in the region.
        # *   **1002**: The agent failed to be installed because the agent cannot be installed on servers outside the cloud. You can install the agent only on supported servers.
        # *   **1003**: The agent failed to be installed because the operating system type of the server is not supported.
        # *   **1004**: An internal error occurred. Try again later.
        # *   **1005**: The Elastic Compute Service (ECS) instance is not running. Start the ECS instance and try again.
        # *   **1006**: The automatic installation of the agent is not supported on an ECS instance that resides in the classic network.
        # *   **1007**: The process of the installation command is manually stopped.
        # *   **1008**: The agent failed to be installed because Cloud Assistant is not installed.
        # *   **1009**: The execution of the installation command timed out. Try again later.
        # *   **1010**: The agent on the server is already online. You do not need to install the agent.
        self.resule_code = resule_code  # type: str
        # The installation result. Valid values:
        # 
        # *   **-1**: not installed
        # *   **0**: being installed
        # *   **1**: installed
        # *   **2**: installation failed
        self.result = result  # type: int
        # The UUID of the server.
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAgentInstallStatusResponseBodyAegisClientInvokeStatusResponseList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.resule_code is not None:
            result['ResuleCode'] = self.resule_code
        if self.result is not None:
            result['Result'] = self.result
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('ResuleCode') is not None:
            self.resule_code = m.get('ResuleCode')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeAgentInstallStatusResponseBody(TeaModel):
    def __init__(self, aegis_client_invoke_status_response_list=None, request_id=None):
        # An array that consists of the installation results for the servers.
        self.aegis_client_invoke_status_response_list = aegis_client_invoke_status_response_list  # type: list[DescribeAgentInstallStatusResponseBodyAegisClientInvokeStatusResponseList]
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.aegis_client_invoke_status_response_list:
            for k in self.aegis_client_invoke_status_response_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAgentInstallStatusResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AegisClientInvokeStatusResponseList'] = []
        if self.aegis_client_invoke_status_response_list is not None:
            for k in self.aegis_client_invoke_status_response_list:
                result['AegisClientInvokeStatusResponseList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.aegis_client_invoke_status_response_list = []
        if m.get('AegisClientInvokeStatusResponseList') is not None:
            for k in m.get('AegisClientInvokeStatusResponseList'):
                temp_model = DescribeAgentInstallStatusResponseBodyAegisClientInvokeStatusResponseList()
                self.aegis_client_invoke_status_response_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAgentInstallStatusResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeAgentInstallStatusResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAgentInstallStatusResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAgentInstallStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAlarmEventDetailRequest(TeaModel):
    def __init__(self, alarm_unique_info=None, from_=None, lang=None, source_ip=None):
        self.alarm_unique_info = alarm_unique_info  # type: str
        self.from_ = from_  # type: str
        self.lang = lang  # type: str
        self.source_ip = source_ip  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAlarmEventDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_unique_info is not None:
            result['AlarmUniqueInfo'] = self.alarm_unique_info
        if self.from_ is not None:
            result['From'] = self.from_
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlarmUniqueInfo') is not None:
            self.alarm_unique_info = m.get('AlarmUniqueInfo')
        if m.get('From') is not None:
            self.from_ = m.get('From')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeAlarmEventDetailResponseBodyDataCauseDetailsValue(TeaModel):
    def __init__(self, name=None, type=None, value=None):
        self.name = name  # type: str
        self.type = type  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAlarmEventDetailResponseBodyDataCauseDetailsValue, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeAlarmEventDetailResponseBodyDataCauseDetails(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: list[DescribeAlarmEventDetailResponseBodyDataCauseDetailsValue]

    def validate(self):
        if self.value:
            for k in self.value:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAlarmEventDetailResponseBodyDataCauseDetails, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        result['Value'] = []
        if self.value is not None:
            for k in self.value:
                result['Value'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        self.value = []
        if m.get('Value') is not None:
            for k in m.get('Value'):
                temp_model = DescribeAlarmEventDetailResponseBodyDataCauseDetailsValue()
                self.value.append(temp_model.from_map(k))
        return self


class DescribeAlarmEventDetailResponseBodyData(TeaModel):
    def __init__(self, alarm_event_alias_name=None, alarm_event_desc=None, alarm_unique_info=None, app_name=None,
                 can_be_deal_on_line=None, can_cancel_fault=None, cause_details=None, contain_hw_mode=None, container_id=None,
                 container_image_id=None, container_image_name=None, data_source=None, end_time=None, instance_name=None,
                 internet_ip=None, intranet_ip=None, k_8s_cluster_id=None, k_8s_cluster_name=None, k_8s_namespace=None,
                 k_8s_node_id=None, k_8s_node_name=None, k_8s_pod_name=None, level=None, solution=None, start_time=None,
                 type=None, uuid=None):
        self.alarm_event_alias_name = alarm_event_alias_name  # type: str
        self.alarm_event_desc = alarm_event_desc  # type: str
        self.alarm_unique_info = alarm_unique_info  # type: str
        self.app_name = app_name  # type: str
        self.can_be_deal_on_line = can_be_deal_on_line  # type: bool
        self.can_cancel_fault = can_cancel_fault  # type: bool
        self.cause_details = cause_details  # type: list[DescribeAlarmEventDetailResponseBodyDataCauseDetails]
        self.contain_hw_mode = contain_hw_mode  # type: bool
        self.container_id = container_id  # type: str
        self.container_image_id = container_image_id  # type: str
        self.container_image_name = container_image_name  # type: str
        self.data_source = data_source  # type: str
        self.end_time = end_time  # type: long
        self.instance_name = instance_name  # type: str
        self.internet_ip = internet_ip  # type: str
        self.intranet_ip = intranet_ip  # type: str
        self.k_8s_cluster_id = k_8s_cluster_id  # type: str
        self.k_8s_cluster_name = k_8s_cluster_name  # type: str
        self.k_8s_namespace = k_8s_namespace  # type: str
        self.k_8s_node_id = k_8s_node_id  # type: str
        self.k_8s_node_name = k_8s_node_name  # type: str
        self.k_8s_pod_name = k_8s_pod_name  # type: str
        self.level = level  # type: str
        self.solution = solution  # type: str
        self.start_time = start_time  # type: long
        self.type = type  # type: str
        self.uuid = uuid  # type: str

    def validate(self):
        if self.cause_details:
            for k in self.cause_details:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAlarmEventDetailResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_event_alias_name is not None:
            result['AlarmEventAliasName'] = self.alarm_event_alias_name
        if self.alarm_event_desc is not None:
            result['AlarmEventDesc'] = self.alarm_event_desc
        if self.alarm_unique_info is not None:
            result['AlarmUniqueInfo'] = self.alarm_unique_info
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.can_be_deal_on_line is not None:
            result['CanBeDealOnLine'] = self.can_be_deal_on_line
        if self.can_cancel_fault is not None:
            result['CanCancelFault'] = self.can_cancel_fault
        result['CauseDetails'] = []
        if self.cause_details is not None:
            for k in self.cause_details:
                result['CauseDetails'].append(k.to_map() if k else None)
        if self.contain_hw_mode is not None:
            result['ContainHwMode'] = self.contain_hw_mode
        if self.container_id is not None:
            result['ContainerId'] = self.container_id
        if self.container_image_id is not None:
            result['ContainerImageId'] = self.container_image_id
        if self.container_image_name is not None:
            result['ContainerImageName'] = self.container_image_name
        if self.data_source is not None:
            result['DataSource'] = self.data_source
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.k_8s_cluster_id is not None:
            result['K8sClusterId'] = self.k_8s_cluster_id
        if self.k_8s_cluster_name is not None:
            result['K8sClusterName'] = self.k_8s_cluster_name
        if self.k_8s_namespace is not None:
            result['K8sNamespace'] = self.k_8s_namespace
        if self.k_8s_node_id is not None:
            result['K8sNodeId'] = self.k_8s_node_id
        if self.k_8s_node_name is not None:
            result['K8sNodeName'] = self.k_8s_node_name
        if self.k_8s_pod_name is not None:
            result['K8sPodName'] = self.k_8s_pod_name
        if self.level is not None:
            result['Level'] = self.level
        if self.solution is not None:
            result['Solution'] = self.solution
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.type is not None:
            result['Type'] = self.type
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlarmEventAliasName') is not None:
            self.alarm_event_alias_name = m.get('AlarmEventAliasName')
        if m.get('AlarmEventDesc') is not None:
            self.alarm_event_desc = m.get('AlarmEventDesc')
        if m.get('AlarmUniqueInfo') is not None:
            self.alarm_unique_info = m.get('AlarmUniqueInfo')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('CanBeDealOnLine') is not None:
            self.can_be_deal_on_line = m.get('CanBeDealOnLine')
        if m.get('CanCancelFault') is not None:
            self.can_cancel_fault = m.get('CanCancelFault')
        self.cause_details = []
        if m.get('CauseDetails') is not None:
            for k in m.get('CauseDetails'):
                temp_model = DescribeAlarmEventDetailResponseBodyDataCauseDetails()
                self.cause_details.append(temp_model.from_map(k))
        if m.get('ContainHwMode') is not None:
            self.contain_hw_mode = m.get('ContainHwMode')
        if m.get('ContainerId') is not None:
            self.container_id = m.get('ContainerId')
        if m.get('ContainerImageId') is not None:
            self.container_image_id = m.get('ContainerImageId')
        if m.get('ContainerImageName') is not None:
            self.container_image_name = m.get('ContainerImageName')
        if m.get('DataSource') is not None:
            self.data_source = m.get('DataSource')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('K8sClusterId') is not None:
            self.k_8s_cluster_id = m.get('K8sClusterId')
        if m.get('K8sClusterName') is not None:
            self.k_8s_cluster_name = m.get('K8sClusterName')
        if m.get('K8sNamespace') is not None:
            self.k_8s_namespace = m.get('K8sNamespace')
        if m.get('K8sNodeId') is not None:
            self.k_8s_node_id = m.get('K8sNodeId')
        if m.get('K8sNodeName') is not None:
            self.k_8s_node_name = m.get('K8sNodeName')
        if m.get('K8sPodName') is not None:
            self.k_8s_pod_name = m.get('K8sPodName')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Solution') is not None:
            self.solution = m.get('Solution')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeAlarmEventDetailResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: DescribeAlarmEventDetailResponseBodyData
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DescribeAlarmEventDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DescribeAlarmEventDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAlarmEventDetailResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeAlarmEventDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAlarmEventDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAlarmEventDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAlarmEventStackInfoRequest(TeaModel):
    def __init__(self, event_name=None, lang=None, source_ip=None, unique_info=None, uuid=None):
        self.event_name = event_name  # type: str
        self.lang = lang  # type: str
        self.source_ip = source_ip  # type: str
        self.unique_info = unique_info  # type: str
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAlarmEventStackInfoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_name is not None:
            result['EventName'] = self.event_name
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.unique_info is not None:
            result['UniqueInfo'] = self.unique_info
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EventName') is not None:
            self.event_name = m.get('EventName')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('UniqueInfo') is not None:
            self.unique_info = m.get('UniqueInfo')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeAlarmEventStackInfoResponseBody(TeaModel):
    def __init__(self, request_id=None, stack_info=None):
        self.request_id = request_id  # type: str
        self.stack_info = stack_info  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAlarmEventStackInfoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.stack_info is not None:
            result['StackInfo'] = self.stack_info
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StackInfo') is not None:
            self.stack_info = m.get('StackInfo')
        return self


class DescribeAlarmEventStackInfoResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeAlarmEventStackInfoResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAlarmEventStackInfoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAlarmEventStackInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAllEntityResponseBodyEntityList(TeaModel):
    def __init__(self, group_id=None, instance_name=None, internet_ip=None, intranet_ip=None, ip=None, os=None,
                 uuid=None):
        self.group_id = group_id  # type: int
        self.instance_name = instance_name  # type: str
        self.internet_ip = internet_ip  # type: str
        self.intranet_ip = intranet_ip  # type: str
        self.ip = ip  # type: str
        self.os = os  # type: str
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAllEntityResponseBodyEntityList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.os is not None:
            result['Os'] = self.os
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeAllEntityResponseBody(TeaModel):
    def __init__(self, entity_list=None, request_id=None):
        self.entity_list = entity_list  # type: list[DescribeAllEntityResponseBodyEntityList]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.entity_list:
            for k in self.entity_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAllEntityResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EntityList'] = []
        if self.entity_list is not None:
            for k in self.entity_list:
                result['EntityList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.entity_list = []
        if m.get('EntityList') is not None:
            for k in m.get('EntityList'):
                temp_model = DescribeAllEntityResponseBodyEntityList()
                self.entity_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAllEntityResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeAllEntityResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAllEntityResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAllEntityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAllGroupsRequest(TeaModel):
    def __init__(self, lang=None):
        # The language of the content within the request and the response. Default value: **zh**. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAllGroupsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeAllGroupsResponseBodyGroups(TeaModel):
    def __init__(self, group_flag=None, group_id=None, group_name=None):
        # The type of the server group. Valid values:
        # 
        # *   **0**: the default group
        # *   **1**: other groups
        self.group_flag = group_flag  # type: int
        # The ID of the server group.
        self.group_id = group_id  # type: int
        # The name of the server group.
        self.group_name = group_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAllGroupsResponseBodyGroups, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_flag is not None:
            result['GroupFlag'] = self.group_flag
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupFlag') is not None:
            self.group_flag = m.get('GroupFlag')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        return self


class DescribeAllGroupsResponseBody(TeaModel):
    def __init__(self, count=None, groups=None, request_id=None):
        # The total number of server groups.
        self.count = count  # type: int
        # An array that consists of the information about server groups.
        self.groups = groups  # type: list[DescribeAllGroupsResponseBodyGroups]
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.groups:
            for k in self.groups:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAllGroupsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        result['Groups'] = []
        if self.groups is not None:
            for k in self.groups:
                result['Groups'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        self.groups = []
        if m.get('Groups') is not None:
            for k in m.get('Groups'):
                temp_model = DescribeAllGroupsResponseBodyGroups()
                self.groups.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAllGroupsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeAllGroupsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAllGroupsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAllGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAllImageBaselineRequest(TeaModel):
    def __init__(self, lang=None):
        # The language of the content within the request and response. Default value: **zh**. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAllImageBaselineRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeAllImageBaselineResponseBodyImageBaselinesBaselineClassListBaselineNameListBaselineItemList(TeaModel):
    def __init__(self, alias=None, class_key=None, item_key=None, name_key=None):
        # The alias of the baseline check item.
        self.alias = alias  # type: str
        # The key of the type for the baseline.
        self.class_key = class_key  # type: str
        # The key of the name for the baseline check item.
        self.item_key = item_key  # type: str
        # The key of the name for the baseline.
        self.name_key = name_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAllImageBaselineResponseBodyImageBaselinesBaselineClassListBaselineNameListBaselineItemList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias is not None:
            result['Alias'] = self.alias
        if self.class_key is not None:
            result['ClassKey'] = self.class_key
        if self.item_key is not None:
            result['ItemKey'] = self.item_key
        if self.name_key is not None:
            result['NameKey'] = self.name_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Alias') is not None:
            self.alias = m.get('Alias')
        if m.get('ClassKey') is not None:
            self.class_key = m.get('ClassKey')
        if m.get('ItemKey') is not None:
            self.item_key = m.get('ItemKey')
        if m.get('NameKey') is not None:
            self.name_key = m.get('NameKey')
        return self


class DescribeAllImageBaselineResponseBodyImageBaselinesBaselineClassListBaselineNameList(TeaModel):
    def __init__(self, alias=None, baseline_item_list=None, class_key=None, name_key=None):
        # The alias of the baseline.
        self.alias = alias  # type: str
        # An array that consists of baseline check items.
        self.baseline_item_list = baseline_item_list  # type: list[DescribeAllImageBaselineResponseBodyImageBaselinesBaselineClassListBaselineNameListBaselineItemList]
        # The key of the type for the baseline.
        self.class_key = class_key  # type: str
        # The key of the name for the baseline.
        self.name_key = name_key  # type: str

    def validate(self):
        if self.baseline_item_list:
            for k in self.baseline_item_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAllImageBaselineResponseBodyImageBaselinesBaselineClassListBaselineNameList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias is not None:
            result['Alias'] = self.alias
        result['BaselineItemList'] = []
        if self.baseline_item_list is not None:
            for k in self.baseline_item_list:
                result['BaselineItemList'].append(k.to_map() if k else None)
        if self.class_key is not None:
            result['ClassKey'] = self.class_key
        if self.name_key is not None:
            result['NameKey'] = self.name_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Alias') is not None:
            self.alias = m.get('Alias')
        self.baseline_item_list = []
        if m.get('BaselineItemList') is not None:
            for k in m.get('BaselineItemList'):
                temp_model = DescribeAllImageBaselineResponseBodyImageBaselinesBaselineClassListBaselineNameListBaselineItemList()
                self.baseline_item_list.append(temp_model.from_map(k))
        if m.get('ClassKey') is not None:
            self.class_key = m.get('ClassKey')
        if m.get('NameKey') is not None:
            self.name_key = m.get('NameKey')
        return self


class DescribeAllImageBaselineResponseBodyImageBaselinesBaselineClassList(TeaModel):
    def __init__(self, alias=None, baseline_name_list=None, class_key=None):
        # The alias of the baseline type.
        self.alias = alias  # type: str
        # An array that consists of baselines.
        self.baseline_name_list = baseline_name_list  # type: list[DescribeAllImageBaselineResponseBodyImageBaselinesBaselineClassListBaselineNameList]
        # The key of the baseline type.
        self.class_key = class_key  # type: str

    def validate(self):
        if self.baseline_name_list:
            for k in self.baseline_name_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAllImageBaselineResponseBodyImageBaselinesBaselineClassList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias is not None:
            result['Alias'] = self.alias
        result['BaselineNameList'] = []
        if self.baseline_name_list is not None:
            for k in self.baseline_name_list:
                result['BaselineNameList'].append(k.to_map() if k else None)
        if self.class_key is not None:
            result['ClassKey'] = self.class_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Alias') is not None:
            self.alias = m.get('Alias')
        self.baseline_name_list = []
        if m.get('BaselineNameList') is not None:
            for k in m.get('BaselineNameList'):
                temp_model = DescribeAllImageBaselineResponseBodyImageBaselinesBaselineClassListBaselineNameList()
                self.baseline_name_list.append(temp_model.from_map(k))
        if m.get('ClassKey') is not None:
            self.class_key = m.get('ClassKey')
        return self


class DescribeAllImageBaselineResponseBodyImageBaselines(TeaModel):
    def __init__(self, baseline_class_list=None):
        # An array that consists of baseline types.
        self.baseline_class_list = baseline_class_list  # type: list[DescribeAllImageBaselineResponseBodyImageBaselinesBaselineClassList]

    def validate(self):
        if self.baseline_class_list:
            for k in self.baseline_class_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAllImageBaselineResponseBodyImageBaselines, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BaselineClassList'] = []
        if self.baseline_class_list is not None:
            for k in self.baseline_class_list:
                result['BaselineClassList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.baseline_class_list = []
        if m.get('BaselineClassList') is not None:
            for k in m.get('BaselineClassList'):
                temp_model = DescribeAllImageBaselineResponseBodyImageBaselinesBaselineClassList()
                self.baseline_class_list.append(temp_model.from_map(k))
        return self


class DescribeAllImageBaselineResponseBody(TeaModel):
    def __init__(self, image_baselines=None, request_id=None):
        # The baselines that are used in image baseline checks.
        self.image_baselines = image_baselines  # type: DescribeAllImageBaselineResponseBodyImageBaselines
        # The ID of the request, which is used to query logs and troubleshoot issues.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.image_baselines:
            self.image_baselines.validate()

    def to_map(self):
        _map = super(DescribeAllImageBaselineResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_baselines is not None:
            result['ImageBaselines'] = self.image_baselines.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ImageBaselines') is not None:
            temp_model = DescribeAllImageBaselineResponseBodyImageBaselines()
            self.image_baselines = temp_model.from_map(m['ImageBaselines'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAllImageBaselineResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeAllImageBaselineResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAllImageBaselineResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAllImageBaselineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAntiBruteForceRulesRequest(TeaModel):
    def __init__(self, current_page=None, id=None, page_size=None, resource_owner_id=None, source_ip=None):
        self.current_page = current_page  # type: int
        self.id = id  # type: long
        self.page_size = page_size  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.source_ip = source_ip  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAntiBruteForceRulesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.id is not None:
            result['Id'] = self.id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeAntiBruteForceRulesResponseBodyPageInfo(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, total_count=None):
        self.count = count  # type: int
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAntiBruteForceRulesResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeAntiBruteForceRulesResponseBodyRules(TeaModel):
    def __init__(self, default_rule=None, enable_smart_rule=None, fail_count=None, forbidden_time=None, id=None,
                 machine_count=None, name=None, span=None, uuid_list=None):
        self.default_rule = default_rule  # type: bool
        self.enable_smart_rule = enable_smart_rule  # type: bool
        self.fail_count = fail_count  # type: int
        self.forbidden_time = forbidden_time  # type: int
        self.id = id  # type: long
        self.machine_count = machine_count  # type: int
        self.name = name  # type: str
        self.span = span  # type: int
        self.uuid_list = uuid_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAntiBruteForceRulesResponseBodyRules, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.default_rule is not None:
            result['DefaultRule'] = self.default_rule
        if self.enable_smart_rule is not None:
            result['EnableSmartRule'] = self.enable_smart_rule
        if self.fail_count is not None:
            result['FailCount'] = self.fail_count
        if self.forbidden_time is not None:
            result['ForbiddenTime'] = self.forbidden_time
        if self.id is not None:
            result['Id'] = self.id
        if self.machine_count is not None:
            result['MachineCount'] = self.machine_count
        if self.name is not None:
            result['Name'] = self.name
        if self.span is not None:
            result['Span'] = self.span
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DefaultRule') is not None:
            self.default_rule = m.get('DefaultRule')
        if m.get('EnableSmartRule') is not None:
            self.enable_smart_rule = m.get('EnableSmartRule')
        if m.get('FailCount') is not None:
            self.fail_count = m.get('FailCount')
        if m.get('ForbiddenTime') is not None:
            self.forbidden_time = m.get('ForbiddenTime')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MachineCount') is not None:
            self.machine_count = m.get('MachineCount')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Span') is not None:
            self.span = m.get('Span')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class DescribeAntiBruteForceRulesResponseBody(TeaModel):
    def __init__(self, page_info=None, request_id=None, rules=None):
        self.page_info = page_info  # type: DescribeAntiBruteForceRulesResponseBodyPageInfo
        self.request_id = request_id  # type: str
        self.rules = rules  # type: list[DescribeAntiBruteForceRulesResponseBodyRules]

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.rules:
            for k in self.rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAntiBruteForceRulesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Rules'] = []
        if self.rules is not None:
            for k in self.rules:
                result['Rules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageInfo') is not None:
            temp_model = DescribeAntiBruteForceRulesResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.rules = []
        if m.get('Rules') is not None:
            for k in m.get('Rules'):
                temp_model = DescribeAntiBruteForceRulesResponseBodyRules()
                self.rules.append(temp_model.from_map(k))
        return self


class DescribeAntiBruteForceRulesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeAntiBruteForceRulesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAntiBruteForceRulesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAntiBruteForceRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAppVulScanCycleResponseBody(TeaModel):
    def __init__(self, cycle=None, request_id=None):
        # The scan cycle for application vulnerabilities.
        # 
        # *   1week
        # *   2weeks
        # *   3days
        self.cycle = cycle  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAppVulScanCycleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cycle is not None:
            result['Cycle'] = self.cycle
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Cycle') is not None:
            self.cycle = m.get('Cycle')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAppVulScanCycleResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeAppVulScanCycleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAppVulScanCycleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAppVulScanCycleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAssetDetailByUuidRequest(TeaModel):
    def __init__(self, lang=None, source_ip=None, uuid=None):
        self.lang = lang  # type: str
        self.source_ip = source_ip  # type: str
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAssetDetailByUuidRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeAssetDetailByUuidResponseBodyAssetDetail(TeaModel):
    def __init__(self, asset_type=None, auth_modify_time=None, auth_version=None, bind=None, client_status=None,
                 client_version=None, cpu=None, cpu_info=None, create_time=None, disk_info_list=None, flag=None, group_trace=None,
                 host_name=None, instance_id=None, instance_name=None, internet_ip=None, intranet_ip=None, ip=None,
                 ip_list=None, kernel=None, mac_list=None, mem=None, memory=None, os=None, os_detail=None, os_name=None,
                 region=None, region_id=None, region_name=None, sys_info=None, tag=None, uuid=None, vpc_instance_id=None):
        self.asset_type = asset_type  # type: str
        self.auth_modify_time = auth_modify_time  # type: long
        self.auth_version = auth_version  # type: int
        self.bind = bind  # type: bool
        self.client_status = client_status  # type: str
        self.client_version = client_version  # type: str
        self.cpu = cpu  # type: int
        self.cpu_info = cpu_info  # type: str
        self.create_time = create_time  # type: long
        self.disk_info_list = disk_info_list  # type: list[str]
        self.flag = flag  # type: int
        self.group_trace = group_trace  # type: str
        self.host_name = host_name  # type: str
        self.instance_id = instance_id  # type: str
        self.instance_name = instance_name  # type: str
        self.internet_ip = internet_ip  # type: str
        self.intranet_ip = intranet_ip  # type: str
        self.ip = ip  # type: str
        self.ip_list = ip_list  # type: list[str]
        self.kernel = kernel  # type: str
        self.mac_list = mac_list  # type: list[str]
        self.mem = mem  # type: int
        self.memory = memory  # type: long
        self.os = os  # type: str
        self.os_detail = os_detail  # type: str
        self.os_name = os_name  # type: str
        self.region = region  # type: str
        self.region_id = region_id  # type: str
        self.region_name = region_name  # type: str
        self.sys_info = sys_info  # type: str
        self.tag = tag  # type: str
        self.uuid = uuid  # type: str
        self.vpc_instance_id = vpc_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAssetDetailByUuidResponseBodyAssetDetail, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asset_type is not None:
            result['AssetType'] = self.asset_type
        if self.auth_modify_time is not None:
            result['AuthModifyTime'] = self.auth_modify_time
        if self.auth_version is not None:
            result['AuthVersion'] = self.auth_version
        if self.bind is not None:
            result['Bind'] = self.bind
        if self.client_status is not None:
            result['ClientStatus'] = self.client_status
        if self.client_version is not None:
            result['ClientVersion'] = self.client_version
        if self.cpu is not None:
            result['Cpu'] = self.cpu
        if self.cpu_info is not None:
            result['CpuInfo'] = self.cpu_info
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.disk_info_list is not None:
            result['DiskInfoList'] = self.disk_info_list
        if self.flag is not None:
            result['Flag'] = self.flag
        if self.group_trace is not None:
            result['GroupTrace'] = self.group_trace
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.ip_list is not None:
            result['IpList'] = self.ip_list
        if self.kernel is not None:
            result['Kernel'] = self.kernel
        if self.mac_list is not None:
            result['MacList'] = self.mac_list
        if self.mem is not None:
            result['Mem'] = self.mem
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.os is not None:
            result['Os'] = self.os
        if self.os_detail is not None:
            result['OsDetail'] = self.os_detail
        if self.os_name is not None:
            result['OsName'] = self.os_name
        if self.region is not None:
            result['Region'] = self.region
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.region_name is not None:
            result['RegionName'] = self.region_name
        if self.sys_info is not None:
            result['SysInfo'] = self.sys_info
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.vpc_instance_id is not None:
            result['VpcInstanceId'] = self.vpc_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AssetType') is not None:
            self.asset_type = m.get('AssetType')
        if m.get('AuthModifyTime') is not None:
            self.auth_modify_time = m.get('AuthModifyTime')
        if m.get('AuthVersion') is not None:
            self.auth_version = m.get('AuthVersion')
        if m.get('Bind') is not None:
            self.bind = m.get('Bind')
        if m.get('ClientStatus') is not None:
            self.client_status = m.get('ClientStatus')
        if m.get('ClientVersion') is not None:
            self.client_version = m.get('ClientVersion')
        if m.get('Cpu') is not None:
            self.cpu = m.get('Cpu')
        if m.get('CpuInfo') is not None:
            self.cpu_info = m.get('CpuInfo')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DiskInfoList') is not None:
            self.disk_info_list = m.get('DiskInfoList')
        if m.get('Flag') is not None:
            self.flag = m.get('Flag')
        if m.get('GroupTrace') is not None:
            self.group_trace = m.get('GroupTrace')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('IpList') is not None:
            self.ip_list = m.get('IpList')
        if m.get('Kernel') is not None:
            self.kernel = m.get('Kernel')
        if m.get('MacList') is not None:
            self.mac_list = m.get('MacList')
        if m.get('Mem') is not None:
            self.mem = m.get('Mem')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('OsDetail') is not None:
            self.os_detail = m.get('OsDetail')
        if m.get('OsName') is not None:
            self.os_name = m.get('OsName')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RegionName') is not None:
            self.region_name = m.get('RegionName')
        if m.get('SysInfo') is not None:
            self.sys_info = m.get('SysInfo')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('VpcInstanceId') is not None:
            self.vpc_instance_id = m.get('VpcInstanceId')
        return self


class DescribeAssetDetailByUuidResponseBody(TeaModel):
    def __init__(self, asset_detail=None, request_id=None):
        self.asset_detail = asset_detail  # type: DescribeAssetDetailByUuidResponseBodyAssetDetail
        self.request_id = request_id  # type: str

    def validate(self):
        if self.asset_detail:
            self.asset_detail.validate()

    def to_map(self):
        _map = super(DescribeAssetDetailByUuidResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asset_detail is not None:
            result['AssetDetail'] = self.asset_detail.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AssetDetail') is not None:
            temp_model = DescribeAssetDetailByUuidResponseBodyAssetDetail()
            self.asset_detail = temp_model.from_map(m['AssetDetail'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAssetDetailByUuidResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeAssetDetailByUuidResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAssetDetailByUuidResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAssetDetailByUuidResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAssetDetailByUuidsRequest(TeaModel):
    def __init__(self, lang=None, uuids=None):
        self.lang = lang  # type: str
        self.uuids = uuids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAssetDetailByUuidsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        return self


class DescribeAssetDetailByUuidsResponseBodyAssetList(TeaModel):
    def __init__(self, asset_type=None, client_status=None, flag=None, instance_id=None, instance_name=None,
                 internet_ip=None, intranet_ip=None, ip=None, os=None, os_name=None, region=None, region_id=None,
                 region_name=None, uuid=None, vpc_instance_id=None):
        self.asset_type = asset_type  # type: str
        self.client_status = client_status  # type: str
        self.flag = flag  # type: int
        self.instance_id = instance_id  # type: str
        self.instance_name = instance_name  # type: str
        self.internet_ip = internet_ip  # type: str
        self.intranet_ip = intranet_ip  # type: str
        self.ip = ip  # type: str
        self.os = os  # type: str
        self.os_name = os_name  # type: str
        self.region = region  # type: str
        self.region_id = region_id  # type: str
        self.region_name = region_name  # type: str
        self.uuid = uuid  # type: str
        self.vpc_instance_id = vpc_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAssetDetailByUuidsResponseBodyAssetList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asset_type is not None:
            result['AssetType'] = self.asset_type
        if self.client_status is not None:
            result['ClientStatus'] = self.client_status
        if self.flag is not None:
            result['Flag'] = self.flag
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.os is not None:
            result['Os'] = self.os
        if self.os_name is not None:
            result['OsName'] = self.os_name
        if self.region is not None:
            result['Region'] = self.region
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.region_name is not None:
            result['RegionName'] = self.region_name
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.vpc_instance_id is not None:
            result['VpcInstanceId'] = self.vpc_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AssetType') is not None:
            self.asset_type = m.get('AssetType')
        if m.get('ClientStatus') is not None:
            self.client_status = m.get('ClientStatus')
        if m.get('Flag') is not None:
            self.flag = m.get('Flag')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('OsName') is not None:
            self.os_name = m.get('OsName')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RegionName') is not None:
            self.region_name = m.get('RegionName')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('VpcInstanceId') is not None:
            self.vpc_instance_id = m.get('VpcInstanceId')
        return self


class DescribeAssetDetailByUuidsResponseBody(TeaModel):
    def __init__(self, asset_list=None, request_id=None):
        self.asset_list = asset_list  # type: list[DescribeAssetDetailByUuidsResponseBodyAssetList]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.asset_list:
            for k in self.asset_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAssetDetailByUuidsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AssetList'] = []
        if self.asset_list is not None:
            for k in self.asset_list:
                result['AssetList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.asset_list = []
        if m.get('AssetList') is not None:
            for k in m.get('AssetList'):
                temp_model = DescribeAssetDetailByUuidsResponseBodyAssetList()
                self.asset_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAssetDetailByUuidsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeAssetDetailByUuidsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAssetDetailByUuidsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAssetDetailByUuidsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAssetSummaryResponseBodyAssetsSummary(TeaModel):
    def __init__(self, total_asset_all_region=None, total_core_all_region=None, total_core_num=None):
        # The total number of protected assets in all regions.
        self.total_asset_all_region = total_asset_all_region  # type: int
        # The total number of cores of protected assets in all regions.
        self.total_core_all_region = total_core_all_region  # type: int
        # The total number of cores of protected assets in the current region.
        self.total_core_num = total_core_num  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAssetSummaryResponseBodyAssetsSummary, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_asset_all_region is not None:
            result['TotalAssetAllRegion'] = self.total_asset_all_region
        if self.total_core_all_region is not None:
            result['TotalCoreAllRegion'] = self.total_core_all_region
        if self.total_core_num is not None:
            result['TotalCoreNum'] = self.total_core_num
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TotalAssetAllRegion') is not None:
            self.total_asset_all_region = m.get('TotalAssetAllRegion')
        if m.get('TotalCoreAllRegion') is not None:
            self.total_core_all_region = m.get('TotalCoreAllRegion')
        if m.get('TotalCoreNum') is not None:
            self.total_core_num = m.get('TotalCoreNum')
        return self


class DescribeAssetSummaryResponseBody(TeaModel):
    def __init__(self, assets_summary=None, request_id=None):
        # The statistical information about the assets.
        self.assets_summary = assets_summary  # type: DescribeAssetSummaryResponseBodyAssetsSummary
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.assets_summary:
            self.assets_summary.validate()

    def to_map(self):
        _map = super(DescribeAssetSummaryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.assets_summary is not None:
            result['AssetsSummary'] = self.assets_summary.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AssetsSummary') is not None:
            temp_model = DescribeAssetSummaryResponseBodyAssetsSummary()
            self.assets_summary = temp_model.from_map(m['AssetsSummary'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAssetSummaryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeAssetSummaryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAssetSummaryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAssetSummaryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAssetsSecurityEventSummaryRequest(TeaModel):
    def __init__(self, cluster_id=None, container_field_name=None, container_field_value=None,
                 resource_owner_id=None, source_ip=None):
        # The ID of the cluster to which the container belongs.
        # 
        # > You can call the [DescribeGroupedContainerInstances](~~DescribeGroupedContainerInstances~~) operation to query the IDs of clusters.
        self.cluster_id = cluster_id  # type: str
        # The key of the condition that is used to query on containers. Valid values:
        # 
        # *   **instanceId**: the ID of the container instance
        # *   **clusterId**: the ID of the cluster
        # *   **regionId**: the region ID of the container
        # *   **clusterName**: the name of the cluster
        # *   **image**: the name of the image
        # *   **imageRepoName**: the name of the image repository
        # *   **imageRepoNamespace**: the namespace to which the image repository belongs
        # *   **imageRepoTag**: the tag that is added to the image repository
        # *   **imageDigest**: the digest of the image
        # *   **ClusterType**: the type of the cluster
        # *   **hostIp**: the public IP address
        # *   **pod**: the pod
        # *   **podIp**: the IP address of the pod
        # *   **containerId**: the ID of the container
        # *   **vulStatus**: whether vulnerabilities are detected on the container
        # *   **alarmStatus**: whether alerts are generated for the container
        # *   **riskStatus**: whether risks are detected on the container
        # *   **riskLevel**: the risk level of the container
        # *   **containerScope**: the type of the container
        self.container_field_name = container_field_name  # type: str
        # The value of the condition that is used to query on containers.
        self.container_field_value = container_field_value  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The source IP address of the request.
        self.source_ip = source_ip  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAssetsSecurityEventSummaryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.container_field_name is not None:
            result['ContainerFieldName'] = self.container_field_name
        if self.container_field_value is not None:
            result['ContainerFieldValue'] = self.container_field_value
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ContainerFieldName') is not None:
            self.container_field_name = m.get('ContainerFieldName')
        if m.get('ContainerFieldValue') is not None:
            self.container_field_value = m.get('ContainerFieldValue')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeAssetsSecurityEventSummaryResponseBodyAssets(TeaModel):
    def __init__(self, asset_type=None, risk_count=None, total_count=None):
        # The type of the asset. Valid values:
        # 
        # *   **namespace**: namespace
        # *   **clusters**: cluster
        # *   **applications**: application
        # *   **pods**: container group
        # *   **containers**: container
        # *   **images**: image
        # *   **hosts**: node
        self.asset_type = asset_type  # type: str
        # The number of assets that are at risk.
        self.risk_count = risk_count  # type: long
        # The total number of assets.
        self.total_count = total_count  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAssetsSecurityEventSummaryResponseBodyAssets, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asset_type is not None:
            result['AssetType'] = self.asset_type
        if self.risk_count is not None:
            result['RiskCount'] = self.risk_count
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AssetType') is not None:
            self.asset_type = m.get('AssetType')
        if m.get('RiskCount') is not None:
            self.risk_count = m.get('RiskCount')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeAssetsSecurityEventSummaryResponseBody(TeaModel):
    def __init__(self, assets=None, request_id=None):
        # An array that consists of risk information about containers.
        self.assets = assets  # type: list[DescribeAssetsSecurityEventSummaryResponseBodyAssets]
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.assets:
            for k in self.assets:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAssetsSecurityEventSummaryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Assets'] = []
        if self.assets is not None:
            for k in self.assets:
                result['Assets'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.assets = []
        if m.get('Assets') is not None:
            for k in m.get('Assets'):
                temp_model = DescribeAssetsSecurityEventSummaryResponseBodyAssets()
                self.assets.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAssetsSecurityEventSummaryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeAssetsSecurityEventSummaryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAssetsSecurityEventSummaryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAssetsSecurityEventSummaryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAttackAnalysisDataRequest(TeaModel):
    def __init__(self, base_64=None, current_page=None, data=None, end_time=None, lang=None, page_size=None,
                 start_time=None, type=None):
        self.base_64 = base_64  # type: str
        self.current_page = current_page  # type: int
        self.data = data  # type: str
        self.end_time = end_time  # type: long
        self.lang = lang  # type: str
        self.page_size = page_size  # type: int
        self.start_time = start_time  # type: long
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAttackAnalysisDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.base_64 is not None:
            result['Base64'] = self.base_64
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.data is not None:
            result['Data'] = self.data
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Base64') is not None:
            self.base_64 = m.get('Base64')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeAttackAnalysisDataResponseBody(TeaModel):
    def __init__(self, data=None, page=None, page_size=None, request_id=None, total=None):
        self.data = data  # type: str
        self.page = page  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.total = total  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAttackAnalysisDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.page is not None:
            result['Page'] = self.page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeAttackAnalysisDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeAttackAnalysisDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAttackAnalysisDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAttackAnalysisDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAutoDelConfigResponseBody(TeaModel):
    def __init__(self, days=None, request_id=None):
        self.days = days  # type: int
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAutoDelConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.days is not None:
            result['Days'] = self.days
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Days') is not None:
            self.days = m.get('Days')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAutoDelConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeAutoDelConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAutoDelConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAutoDelConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBackUpExportInfoRequest(TeaModel):
    def __init__(self, current_page=None, export_type=None, lang=None, page_size=None):
        # The number of the page to return.
        self.current_page = current_page  # type: int
        # The type of archived information. Valid values:
        # 
        # *   **suspiciousExport**: alert event
        self.export_type = export_type  # type: str
        # The language of the content within the request and response. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang  # type: str
        # The number of entries to return on each page. Default value: 20.
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBackUpExportInfoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.export_type is not None:
            result['ExportType'] = self.export_type
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('ExportType') is not None:
            self.export_type = m.get('ExportType')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeBackUpExportInfoResponseBodyData(TeaModel):
    def __init__(self, current_count=None, file_name=None, gmt_create=None, id=None, link=None, message=None,
                 progress=None, status=None, total_count=None):
        # The number of exported entries.
        self.current_count = current_count  # type: int
        # The name of the file.
        self.file_name = file_name  # type: str
        # The time when the export task was created.
        self.gmt_create = gmt_create  # type: long
        # The ID of the export task.
        self.id = id  # type: long
        # The URL at which you can download the archived information.
        self.link = link  # type: str
        # The error message that is returned when the export task fails.
        self.message = message  # type: str
        # The progress percentage of the export task.
        self.progress = progress  # type: int
        # The status of the export task. Valid values:
        # 
        # *   **init**: The task is being initialized.
        # *   **exporting**: The task is in progress.
        # *   **success**: The task is complete.
        self.status = status  # type: str
        # The total number of entries in the file.
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBackUpExportInfoResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_count is not None:
            result['CurrentCount'] = self.current_count
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.id is not None:
            result['Id'] = self.id
        if self.link is not None:
            result['Link'] = self.link
        if self.message is not None:
            result['Message'] = self.message
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.status is not None:
            result['Status'] = self.status
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentCount') is not None:
            self.current_count = m.get('CurrentCount')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Link') is not None:
            self.link = m.get('Link')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeBackUpExportInfoResponseBodyPageInfo(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, total_count=None):
        # The number of entries returned on the current page.
        self.count = count  # type: int
        # The page number of the returned page.
        self.current_page = current_page  # type: int
        # The number of entries returned per page.
        self.page_size = page_size  # type: int
        # The total number of entries returned.
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBackUpExportInfoResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeBackUpExportInfoResponseBody(TeaModel):
    def __init__(self, data=None, page_info=None, request_id=None):
        # The data returned.
        self.data = data  # type: list[DescribeBackUpExportInfoResponseBodyData]
        # The pagination information.
        self.page_info = page_info  # type: DescribeBackUpExportInfoResponseBodyPageInfo
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super(DescribeBackUpExportInfoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeBackUpExportInfoResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeBackUpExportInfoResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeBackUpExportInfoResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeBackUpExportInfoResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeBackUpExportInfoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeBackUpExportInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBackupClientsRequest(TeaModel):
    def __init__(self, support_region_id=None):
        # The region in which the anti-ransomware feature is supported.
        # > You can call the [DescribeSupportRegion](~~DescribeSupportRegion~~) operation to query the regions in which the anti-ransomware feature is supported.
        self.support_region_id = support_region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBackupClientsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.support_region_id is not None:
            result['SupportRegionId'] = self.support_region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SupportRegionId') is not None:
            self.support_region_id = m.get('SupportRegionId')
        return self


class DescribeBackupClientsResponseBodyClients(TeaModel):
    def __init__(self, client_id=None, client_status=None, client_version=None, instance_id=None, uuid=None):
        # The ID of the anti-ransomware agent.
        self.client_id = client_id  # type: str
        # The status of the anti-ransomware agent.
        # 
        # Valid values:
        # 
        # *   **INSTALLING**: The agent is being installed.
        # *   **ONLINE**: The agent is online.
        # *   **UNINSTALLING**: The agent is being uninstalled.
        # *   **NOT_INSTALLED**: The agent is not installed.
        # *   **ACTIVATED**: The agent is enabled.
        # *   **CLIENT\_CONNECTION_ERROR**: A connection error occurs on the agent.
        self.client_status = client_status  # type: str
        # The version of the anti-ransomware agent.
        self.client_version = client_version  # type: str
        # The ID of the ECS instance on which the anti-ransomware agent is installed.
        self.instance_id = instance_id  # type: str
        # The UUID of the Elastic Compute Service (ECS) instance on which the anti-ransomware agent is installed.
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBackupClientsResponseBodyClients, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_id is not None:
            result['ClientId'] = self.client_id
        if self.client_status is not None:
            result['ClientStatus'] = self.client_status
        if self.client_version is not None:
            result['ClientVersion'] = self.client_version
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientId') is not None:
            self.client_id = m.get('ClientId')
        if m.get('ClientStatus') is not None:
            self.client_status = m.get('ClientStatus')
        if m.get('ClientVersion') is not None:
            self.client_version = m.get('ClientVersion')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeBackupClientsResponseBody(TeaModel):
    def __init__(self, clients=None, request_id=None):
        # An array that consists of the information about the anti-ransomware agent.
        self.clients = clients  # type: list[DescribeBackupClientsResponseBodyClients]
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.clients:
            for k in self.clients:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeBackupClientsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Clients'] = []
        if self.clients is not None:
            for k in self.clients:
                result['Clients'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.clients = []
        if m.get('Clients') is not None:
            for k in m.get('Clients'):
                temp_model = DescribeBackupClientsResponseBodyClients()
                self.clients.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeBackupClientsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeBackupClientsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeBackupClientsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeBackupClientsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBackupFilesRequest(TeaModel):
    def __init__(self, current_page=None, page_size=None, path=None, snapshot_hash=None, uuid=None):
        self.current_page = current_page  # type: str
        self.page_size = page_size  # type: str
        self.path = path  # type: str
        self.snapshot_hash = snapshot_hash  # type: str
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBackupFilesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.path is not None:
            result['Path'] = self.path
        if self.snapshot_hash is not None:
            result['SnapshotHash'] = self.snapshot_hash
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('SnapshotHash') is not None:
            self.snapshot_hash = m.get('SnapshotHash')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeBackupFilesResponseBodyBackupFiles(TeaModel):
    def __init__(self, name=None, size=None, subtree=None, type=None):
        self.name = name  # type: str
        self.size = size  # type: long
        self.subtree = subtree  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBackupFilesResponseBodyBackupFiles, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.size is not None:
            result['Size'] = self.size
        if self.subtree is not None:
            result['Subtree'] = self.subtree
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Subtree') is not None:
            self.subtree = m.get('Subtree')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeBackupFilesResponseBodyPageInfo(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, total_count=None):
        self.count = count  # type: int
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBackupFilesResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeBackupFilesResponseBody(TeaModel):
    def __init__(self, backup_files=None, page_info=None, request_id=None):
        self.backup_files = backup_files  # type: list[DescribeBackupFilesResponseBodyBackupFiles]
        self.page_info = page_info  # type: DescribeBackupFilesResponseBodyPageInfo
        self.request_id = request_id  # type: str

    def validate(self):
        if self.backup_files:
            for k in self.backup_files:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super(DescribeBackupFilesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BackupFiles'] = []
        if self.backup_files is not None:
            for k in self.backup_files:
                result['BackupFiles'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.backup_files = []
        if m.get('BackupFiles') is not None:
            for k in m.get('BackupFiles'):
                temp_model = DescribeBackupFilesResponseBodyBackupFiles()
                self.backup_files.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeBackupFilesResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeBackupFilesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeBackupFilesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeBackupFilesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeBackupFilesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBackupMachineStatusRequest(TeaModel):
    def __init__(self, policy_id=None, policy_version=None, uuid=None):
        # The ID of the anti-ransomware policy.
        # 
        # >  You can call the [DescribeBackupPolicies](~~DescribeBackupPolicies~~) operation to query the IDs of anti-ransomware policies.
        self.policy_id = policy_id  # type: long
        # The version of the anti-ransomware policy. Valid values:
        # 
        # *   **1.0.0**\
        # *   **2.0.0**\
        self.policy_version = policy_version  # type: str
        # The UUID of the server.
        # 
        # >  You can call the [DescribeBackupPolicy](~~DescribeBackupPolicy~~) operation to query the UUIDs of servers.
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBackupMachineStatusRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.policy_version is not None:
            result['PolicyVersion'] = self.policy_version
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('PolicyVersion') is not None:
            self.policy_version = m.get('PolicyVersion')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeBackupMachineStatusResponseBodyBackupMachineStatusErrorList(TeaModel):
    def __init__(self, error_code=None, error_status=None):
        # The error code returned.
        self.error_code = error_code  # type: str
        # The error message returned.
        self.error_status = error_status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBackupMachineStatusResponseBodyBackupMachineStatusErrorList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_status is not None:
            result['ErrorStatus'] = self.error_status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorStatus') is not None:
            self.error_status = m.get('ErrorStatus')
        return self


class DescribeBackupMachineStatusResponseBodyBackupMachineStatus(TeaModel):
    def __init__(self, client_id=None, client_status=None, client_version=None, error_code=None, error_list=None,
                 instance_id=None, region_id=None, saved_backup_count=None, status=None, uuid=None, vault_id=None):
        # The ID of the anti-ransomware agent.
        self.client_id = client_id  # type: str
        # The status of the anti-ransomware agent. Valid values:
        # 
        # *   **ONLINE**: normal
        # *   **CLIENT_CONNECTION_ERROR**: abnormal
        # *   **UNINSTALLING**: being uninstalled
        # *   **UNINSTALL_FAILED**: failed to be uninstalled
        # *   **UPGRADING**: being upgraded
        # *   **UPGRADE_FAILED**: failed to be upgraded
        self.client_status = client_status  # type: str
        # The version of the anti-ransomware agent.
        self.client_version = client_version  # type: str
        # The error code returned.
        self.error_code = error_code  # type: str
        # An array that consists of the error information reported by the backup server.
        self.error_list = error_list  # type: list[DescribeBackupMachineStatusResponseBodyBackupMachineStatusErrorList]
        # The ID of the server.
        self.instance_id = instance_id  # type: str
        # The ID of the region in which the server resides.
        self.region_id = region_id  # type: str
        # The number of backup versions.
        self.saved_backup_count = saved_backup_count  # type: int
        # The status of the anti-ransomware agent. Valid values:
        # 
        # *   **NOT_INSTALLED**: not installed
        # *   **CLIENT_CONNECTION_ERROR**: abnormal
        # *   **ACTIVATED**: normal
        self.status = status  # type: str
        # The UUID of the server.
        self.uuid = uuid  # type: str
        # The ID of the backup vault in which the backup data is stored.
        self.vault_id = vault_id  # type: str

    def validate(self):
        if self.error_list:
            for k in self.error_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeBackupMachineStatusResponseBodyBackupMachineStatus, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_id is not None:
            result['ClientId'] = self.client_id
        if self.client_status is not None:
            result['ClientStatus'] = self.client_status
        if self.client_version is not None:
            result['ClientVersion'] = self.client_version
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        result['ErrorList'] = []
        if self.error_list is not None:
            for k in self.error_list:
                result['ErrorList'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.saved_backup_count is not None:
            result['SavedBackupCount'] = self.saved_backup_count
        if self.status is not None:
            result['Status'] = self.status
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.vault_id is not None:
            result['VaultId'] = self.vault_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientId') is not None:
            self.client_id = m.get('ClientId')
        if m.get('ClientStatus') is not None:
            self.client_status = m.get('ClientStatus')
        if m.get('ClientVersion') is not None:
            self.client_version = m.get('ClientVersion')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        self.error_list = []
        if m.get('ErrorList') is not None:
            for k in m.get('ErrorList'):
                temp_model = DescribeBackupMachineStatusResponseBodyBackupMachineStatusErrorList()
                self.error_list.append(temp_model.from_map(k))
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SavedBackupCount') is not None:
            self.saved_backup_count = m.get('SavedBackupCount')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('VaultId') is not None:
            self.vault_id = m.get('VaultId')
        return self


class DescribeBackupMachineStatusResponseBody(TeaModel):
    def __init__(self, backup_machine_status=None, request_id=None):
        # The backup status of the server.
        self.backup_machine_status = backup_machine_status  # type: DescribeBackupMachineStatusResponseBodyBackupMachineStatus
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.backup_machine_status:
            self.backup_machine_status.validate()

    def to_map(self):
        _map = super(DescribeBackupMachineStatusResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_machine_status is not None:
            result['BackupMachineStatus'] = self.backup_machine_status.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BackupMachineStatus') is not None:
            temp_model = DescribeBackupMachineStatusResponseBodyBackupMachineStatus()
            self.backup_machine_status = temp_model.from_map(m['BackupMachineStatus'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeBackupMachineStatusResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeBackupMachineStatusResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeBackupMachineStatusResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeBackupMachineStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBackupPoliciesRequest(TeaModel):
    def __init__(self, current_page=None, machine_remark=None, name=None, page_size=None, status=None):
        # The number of the page to return. Default value: 1.
        self.current_page = current_page  # type: int
        # The information that you want to use to identify the servers protected by the anti-ransomware policy. You can enter the IP address or ID of a server.
        self.machine_remark = machine_remark  # type: str
        # The name of the anti-ransomware policy that you want to query.
        self.name = name  # type: str
        # The number of entries to return on each page. Default value: 10.
        self.page_size = page_size  # type: int
        # The status of the anti-ransomware policy. Valid values:
        # 
        # *   **enabled**: The anti-ransomware policy is manually enabled.
        # *   **disabled**: The anti-ransomware policy is manually disabled. After an anti-ransomware policy is disabled, the data backup task that is running based on the policy stops.
        # *   **closed**: The anti-ransomware policy automatically stops because the anti-ransomware capacity is insufficient.
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBackupPoliciesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.machine_remark is not None:
            result['MachineRemark'] = self.machine_remark
        if self.name is not None:
            result['Name'] = self.name
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('MachineRemark') is not None:
            self.machine_remark = m.get('MachineRemark')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeBackupPoliciesResponseBodyPageInfo(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, total_count=None):
        # The number of entries returned on the current page.
        self.count = count  # type: int
        # The page number of the returned page.
        self.current_page = current_page  # type: int
        # The number of entries returned per page. Default value: 10.
        self.page_size = page_size  # type: int
        # The total number of anti-ransomware policies returned.
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBackupPoliciesResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeBackupPoliciesResponseBodyPolicies(TeaModel):
    def __init__(self, client_error_count=None, client_error_uuid_list=None, client_status=None,
                 health_client_count=None, health_client_uuid_list=None, id=None, name=None, policy=None, policy_region_id=None,
                 policy_version=None, remarked_uuid_list=None, server_type=None, service_error_count=None,
                 service_error_uuid_list=None, status=None, upgrade_status=None, uuid_list=None):
        # The number of the servers on which the anti-ransomware agent is in an abnormal state.
        self.client_error_count = client_error_count  # type: int
        # The UUIDs of the servers on which the anti-ransomware agent is in an **abnormal** state.
        self.client_error_uuid_list = client_error_uuid_list  # type: list[str]
        # The status of the anti-ransomware agent. Valid values:
        # 
        # *   **running**: normal
        # *   **exception**: abnormal
        self.client_status = client_status  # type: str
        # The number of the servers on which the anti-ransomware agent is in a normal state.
        self.health_client_count = health_client_count  # type: int
        # The UUIDs of the servers on which the anti-ransomware agent is in a **normal** state.
        self.health_client_uuid_list = health_client_uuid_list  # type: list[str]
        # The ID of the anti-ransomware policy.
        self.id = id  # type: long
        # The name of the anti-ransomware policy.
        self.name = name  # type: str
        # The configurations of the anti-ransomware policy. The value of this parameter is in the JSON format and contains the following fields:
        # 
        # *   **IsDefault**: the type of the anti-ransomware policy. Valid values:
        # 
        #     *   **1**: recommended policy
        #     *   **0**: custom policy
        # 
        # *   **Include**: the format of the files that are protected. If the value of this field is \[], all formats of files are protected.
        # 
        # *   **Source**: the directory that is protected. If the value of this field is \[], all directories are protected.
        # 
        # *   **ExcludeSystemPath**: indicates whether a specified directory is excluded from the anti-ransomware policy. If the value of this field is **true**, the directory is excluded. If this field is left empty, no directories are excluded.
        # 
        # *   **Exclude**: the directory that is excluded from the anti-ransomware policy. If no directory is specified, the value of this field is \[].
        # 
        # *   **Schedule**: the start time and interval of a data backup task. A start time that begins during off-peak hours but does not start on the hour is recommended. Examples:
        # 
        #     *   If the value of this field is I|1583216092|P21D, the data backup task starts from 2020-03-03 14:14:52, and the task is run at an interval of three weeks.
        #     *   If the value of this field is I|1583216092|PT24H, the data backup task starts from 2020-03-03 14:14:52, and the task is run at an interval of 24 hours.
        # 
        # *   **Retention**: the period during which backup data is retained. Unit: days. If the value of this field is 7, backup data is retained for a week. If the value of this field is 365, backup data is retained for a year. If the value of this field is -1, backup data is permanently retained.
        # 
        # *   **SpeedLimiter**: the limit on the network bandwidth for data backup tasks. If the value of this field is 0:24:30720, the maximum bandwidth for a data backup task is 30 MB/s from 00:00 to 24:00.
        # 
        # *   **UseVss**: indicates whether the VSS feature is enabled. The feature is available only for Windows servers. Valid values:
        # 
        #     *   **true**: yes
        #     *   **false**: no
        # 
        # >  The VSS feature is available only if you create the anti-ransomware policy for Windows servers. After you enable the feature, the number of backup failures due to running processes is significantly reduced. We recommend that you enable the VSS feature. After you enable the feature, the data of disks that are in the exFAT and FAT32 formats cannot be backed up.
        self.policy = policy  # type: str
        # The ID of the region that you specified for data backup when you installed the anti-ransomware agent for the server not deployed on Alibaba Cloud.
        self.policy_region_id = policy_region_id  # type: str
        # The version of the anti-ransomware policy. Valid values:
        # 
        # *   1.0.0
        # *   2.0.0
        self.policy_version = policy_version  # type: str
        # The UUIDs that are returned based on the value of the MachineRemark request parameter.
        self.remarked_uuid_list = remarked_uuid_list  # type: list[str]
        # The type of the server. Valid values:
        # 
        # *   **OUT_CLOUD**: server not deployed on Alibaba Cloud
        # *   **ALIYUN**: Elastic Compute Service (ECS) instance
        # *   **TRIPARTITE**: simple application server
        self.server_type = server_type  # type: str
        # The number of servers on which data backup is exceptional.
        self.service_error_count = service_error_count  # type: int
        # The UUIDs of the servers on which data backup is exceptional.
        self.service_error_uuid_list = service_error_uuid_list  # type: list[str]
        # The status of the anti-ransomware policy. Valid values:
        # 
        # *   **enabled**: The anti-ransomware policy is manually enabled.
        # *   **disabled**: The anti-ransomware policy is manually disabled. After an anti-ransomware policy is disabled, the data backup task that is running based on the policy stops.
        # *   **closed**: The anti-ransomware policy automatically stops because the anti-ransomware capacity is insufficient.
        self.status = status  # type: str
        # The upgrade status of the anti-ransomware policy. Valid values:
        # 
        # *   **NotUpgraded**\
        # *   **Upgrading**\
        # *   **UpgradeFailed**\
        # *   **UpgradeSuccess**\
        self.upgrade_status = upgrade_status  # type: str
        # The UUIDs of the servers to which the anti-ransomware policy is applied.
        self.uuid_list = uuid_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBackupPoliciesResponseBodyPolicies, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_error_count is not None:
            result['ClientErrorCount'] = self.client_error_count
        if self.client_error_uuid_list is not None:
            result['ClientErrorUuidList'] = self.client_error_uuid_list
        if self.client_status is not None:
            result['ClientStatus'] = self.client_status
        if self.health_client_count is not None:
            result['HealthClientCount'] = self.health_client_count
        if self.health_client_uuid_list is not None:
            result['HealthClientUuidList'] = self.health_client_uuid_list
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.policy_region_id is not None:
            result['PolicyRegionId'] = self.policy_region_id
        if self.policy_version is not None:
            result['PolicyVersion'] = self.policy_version
        if self.remarked_uuid_list is not None:
            result['RemarkedUuidList'] = self.remarked_uuid_list
        if self.server_type is not None:
            result['ServerType'] = self.server_type
        if self.service_error_count is not None:
            result['ServiceErrorCount'] = self.service_error_count
        if self.service_error_uuid_list is not None:
            result['ServiceErrorUuidList'] = self.service_error_uuid_list
        if self.status is not None:
            result['Status'] = self.status
        if self.upgrade_status is not None:
            result['UpgradeStatus'] = self.upgrade_status
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientErrorCount') is not None:
            self.client_error_count = m.get('ClientErrorCount')
        if m.get('ClientErrorUuidList') is not None:
            self.client_error_uuid_list = m.get('ClientErrorUuidList')
        if m.get('ClientStatus') is not None:
            self.client_status = m.get('ClientStatus')
        if m.get('HealthClientCount') is not None:
            self.health_client_count = m.get('HealthClientCount')
        if m.get('HealthClientUuidList') is not None:
            self.health_client_uuid_list = m.get('HealthClientUuidList')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('PolicyRegionId') is not None:
            self.policy_region_id = m.get('PolicyRegionId')
        if m.get('PolicyVersion') is not None:
            self.policy_version = m.get('PolicyVersion')
        if m.get('RemarkedUuidList') is not None:
            self.remarked_uuid_list = m.get('RemarkedUuidList')
        if m.get('ServerType') is not None:
            self.server_type = m.get('ServerType')
        if m.get('ServiceErrorCount') is not None:
            self.service_error_count = m.get('ServiceErrorCount')
        if m.get('ServiceErrorUuidList') is not None:
            self.service_error_uuid_list = m.get('ServiceErrorUuidList')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UpgradeStatus') is not None:
            self.upgrade_status = m.get('UpgradeStatus')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class DescribeBackupPoliciesResponseBody(TeaModel):
    def __init__(self, page_info=None, policies=None, request_id=None):
        # The pagination information.
        self.page_info = page_info  # type: DescribeBackupPoliciesResponseBodyPageInfo
        # An array that consists of the anti-ransomware policies returned.
        self.policies = policies  # type: list[DescribeBackupPoliciesResponseBodyPolicies]
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.policies:
            for k in self.policies:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeBackupPoliciesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['Policies'] = []
        if self.policies is not None:
            for k in self.policies:
                result['Policies'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageInfo') is not None:
            temp_model = DescribeBackupPoliciesResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.policies = []
        if m.get('Policies') is not None:
            for k in m.get('Policies'):
                temp_model = DescribeBackupPoliciesResponseBodyPolicies()
                self.policies.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeBackupPoliciesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeBackupPoliciesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeBackupPoliciesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeBackupPoliciesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBackupPolicyRequest(TeaModel):
    def __init__(self, id=None):
        self.id = id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBackupPolicyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class DescribeBackupPolicyResponseBodyBackupPolicyDetail(TeaModel):
    def __init__(self, client_status=None, id=None, name=None, policy=None, policy_version=None, region_id=None,
                 status=None, uuid_list=None):
        self.client_status = client_status  # type: str
        self.id = id  # type: long
        self.name = name  # type: str
        self.policy = policy  # type: str
        self.policy_version = policy_version  # type: str
        self.region_id = region_id  # type: str
        self.status = status  # type: str
        self.uuid_list = uuid_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBackupPolicyResponseBodyBackupPolicyDetail, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_status is not None:
            result['ClientStatus'] = self.client_status
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.policy_version is not None:
            result['PolicyVersion'] = self.policy_version
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.status is not None:
            result['Status'] = self.status
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientStatus') is not None:
            self.client_status = m.get('ClientStatus')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('PolicyVersion') is not None:
            self.policy_version = m.get('PolicyVersion')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class DescribeBackupPolicyResponseBody(TeaModel):
    def __init__(self, backup_policy_detail=None, request_id=None):
        self.backup_policy_detail = backup_policy_detail  # type: DescribeBackupPolicyResponseBodyBackupPolicyDetail
        self.request_id = request_id  # type: str

    def validate(self):
        if self.backup_policy_detail:
            self.backup_policy_detail.validate()

    def to_map(self):
        _map = super(DescribeBackupPolicyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_policy_detail is not None:
            result['BackupPolicyDetail'] = self.backup_policy_detail.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BackupPolicyDetail') is not None:
            temp_model = DescribeBackupPolicyResponseBodyBackupPolicyDetail()
            self.backup_policy_detail = temp_model.from_map(m['BackupPolicyDetail'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeBackupPolicyResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeBackupPolicyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeBackupPolicyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeBackupPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBackupRestoreCountResponseBodyBackupRestoreCount(TeaModel):
    def __init__(self, recovering=None, total=None):
        self.recovering = recovering  # type: int
        self.total = total  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBackupRestoreCountResponseBodyBackupRestoreCount, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.recovering is not None:
            result['Recovering'] = self.recovering
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Recovering') is not None:
            self.recovering = m.get('Recovering')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeBackupRestoreCountResponseBody(TeaModel):
    def __init__(self, backup_restore_count=None, request_id=None):
        self.backup_restore_count = backup_restore_count  # type: DescribeBackupRestoreCountResponseBodyBackupRestoreCount
        self.request_id = request_id  # type: str

    def validate(self):
        if self.backup_restore_count:
            self.backup_restore_count.validate()

    def to_map(self):
        _map = super(DescribeBackupRestoreCountResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_restore_count is not None:
            result['BackupRestoreCount'] = self.backup_restore_count.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BackupRestoreCount') is not None:
            temp_model = DescribeBackupRestoreCountResponseBodyBackupRestoreCount()
            self.backup_restore_count = temp_model.from_map(m['BackupRestoreCount'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeBackupRestoreCountResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeBackupRestoreCountResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeBackupRestoreCountResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeBackupRestoreCountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBruteForceRecordsRequest(TeaModel):
    def __init__(self, block_ip=None, current_page=None, page_size=None, resource_owner_id=None, status=None):
        # The IP address that is blocked.
        self.block_ip = block_ip  # type: str
        # The number of the page to return.
        self.current_page = current_page  # type: int
        # The number of entries to return on each page. Default value: 20. If you leave this parameter empty, 20 entries are returned on each page. We recommend that you do not leave this parameter empty.
        self.page_size = page_size  # type: int
        self.resource_owner_id = resource_owner_id  # type: long
        # The status of the defense rule. Valid values:
        # 
        # *   **0**: invalid
        # *   **1**: enabled
        # *   **2**: failed
        self.status = status  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBruteForceRecordsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.block_ip is not None:
            result['BlockIp'] = self.block_ip
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BlockIp') is not None:
            self.block_ip = m.get('BlockIp')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeBruteForceRecordsResponseBodyMachineList(TeaModel):
    def __init__(self, block_expire_date=None, block_ip=None, error_code=None, id=None, instance_name=None,
                 internet_ip=None, intranet_ip=None, port=None, rule_name=None, source=None, status=None, uuid=None):
        # The timestamp when the block action on the IP address becomes invalid.
        self.block_expire_date = block_expire_date  # type: long
        # The blocked IP address.
        self.block_ip = block_ip  # type: str
        # The error code returned when the defense rule fails to block the IP address.
        self.error_code = error_code  # type: str
        # The ID of the primary key in the table of records on the blocked IP address.
        self.id = id  # type: long
        # The name of the server.
        self.instance_name = instance_name  # type: str
        # The public IP address.
        self.internet_ip = internet_ip  # type: str
        # The private IP address.
        self.intranet_ip = intranet_ip  # type: str
        # The port that is attacked.
        self.port = port  # type: str
        # The name of the defense rule.
        self.rule_name = rule_name  # type: str
        # The type of the defense rule. Valid values:
        # 
        # *   **userRule**: custom rule
        # *   **blinkRule**: system rule
        self.source = source  # type: str
        # The status of the defense rule. Valid values:
        # 
        # *   **0**: invalid
        # *   **1**: enabled
        # *   **2**: failed
        self.status = status  # type: int
        # The UUID of the server on which access from the IP address is blocked.
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBruteForceRecordsResponseBodyMachineList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.block_expire_date is not None:
            result['BlockExpireDate'] = self.block_expire_date
        if self.block_ip is not None:
            result['BlockIp'] = self.block_ip
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.id is not None:
            result['Id'] = self.id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.port is not None:
            result['Port'] = self.port
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.source is not None:
            result['Source'] = self.source
        if self.status is not None:
            result['Status'] = self.status
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BlockExpireDate') is not None:
            self.block_expire_date = m.get('BlockExpireDate')
        if m.get('BlockIp') is not None:
            self.block_ip = m.get('BlockIp')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeBruteForceRecordsResponseBodyPageInfo(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, total_count=None):
        # The number of entries returned on the current page.
        self.count = count  # type: int
        # The page number of the returned page.
        self.current_page = current_page  # type: int
        # The number of entries returned per page. Default value: **20**.
        self.page_size = page_size  # type: int
        # The total number of entries returned.
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBruteForceRecordsResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeBruteForceRecordsResponseBody(TeaModel):
    def __init__(self, machine_list=None, page_info=None, request_id=None):
        # An array that consists of the IP addresses.
        self.machine_list = machine_list  # type: list[DescribeBruteForceRecordsResponseBodyMachineList]
        # The pagination information.
        self.page_info = page_info  # type: DescribeBruteForceRecordsResponseBodyPageInfo
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.machine_list:
            for k in self.machine_list:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super(DescribeBruteForceRecordsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MachineList'] = []
        if self.machine_list is not None:
            for k in self.machine_list:
                result['MachineList'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.machine_list = []
        if m.get('MachineList') is not None:
            for k in m.get('MachineList'):
                temp_model = DescribeBruteForceRecordsResponseBodyMachineList()
                self.machine_list.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeBruteForceRecordsResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeBruteForceRecordsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeBruteForceRecordsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeBruteForceRecordsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeBruteForceRecordsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBruteForceSummaryRequest(TeaModel):
    def __init__(self, resource_owner_id=None, source_ip=None):
        self.resource_owner_id = resource_owner_id  # type: long
        self.source_ip = source_ip  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBruteForceSummaryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeBruteForceSummaryResponseBodyBruteForceSummary(TeaModel):
    def __init__(self, all_strategy_count=None, effective_count=None):
        self.all_strategy_count = all_strategy_count  # type: int
        self.effective_count = effective_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBruteForceSummaryResponseBodyBruteForceSummary, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.all_strategy_count is not None:
            result['AllStrategyCount'] = self.all_strategy_count
        if self.effective_count is not None:
            result['EffectiveCount'] = self.effective_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AllStrategyCount') is not None:
            self.all_strategy_count = m.get('AllStrategyCount')
        if m.get('EffectiveCount') is not None:
            self.effective_count = m.get('EffectiveCount')
        return self


class DescribeBruteForceSummaryResponseBody(TeaModel):
    def __init__(self, brute_force_summary=None, request_id=None):
        self.brute_force_summary = brute_force_summary  # type: DescribeBruteForceSummaryResponseBodyBruteForceSummary
        self.request_id = request_id  # type: str

    def validate(self):
        if self.brute_force_summary:
            self.brute_force_summary.validate()

    def to_map(self):
        _map = super(DescribeBruteForceSummaryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.brute_force_summary is not None:
            result['BruteForceSummary'] = self.brute_force_summary.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BruteForceSummary') is not None:
            temp_model = DescribeBruteForceSummaryResponseBodyBruteForceSummary()
            self.brute_force_summary = temp_model.from_map(m['BruteForceSummary'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeBruteForceSummaryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeBruteForceSummaryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeBruteForceSummaryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeBruteForceSummaryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCheckEcsWarningsRequest(TeaModel):
    def __init__(self, source_ip=None):
        self.source_ip = source_ip  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCheckEcsWarningsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeCheckEcsWarningsResponseBody(TeaModel):
    def __init__(self, can_try=None, request_id=None, sas_version=None, weak_password_count=None):
        self.can_try = can_try  # type: str
        self.request_id = request_id  # type: str
        self.sas_version = sas_version  # type: str
        self.weak_password_count = weak_password_count  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCheckEcsWarningsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.can_try is not None:
            result['CanTry'] = self.can_try
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sas_version is not None:
            result['SasVersion'] = self.sas_version
        if self.weak_password_count is not None:
            result['WeakPasswordCount'] = self.weak_password_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CanTry') is not None:
            self.can_try = m.get('CanTry')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SasVersion') is not None:
            self.sas_version = m.get('SasVersion')
        if m.get('WeakPasswordCount') is not None:
            self.weak_password_count = m.get('WeakPasswordCount')
        return self


class DescribeCheckEcsWarningsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCheckEcsWarningsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCheckEcsWarningsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCheckEcsWarningsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCheckFixDetailsRequest(TeaModel):
    def __init__(self, check_ids=None, lang=None, risk_id=None):
        # The ID of the risk item.
        # 
        # >  You can call the [DescribeRiskType](~~DescribeRiskType~~) operation to query the IDs of risk items.
        self.check_ids = check_ids  # type: str
        # The language of the content within the request and response. Default value: **zh**. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang  # type: str
        # The ID of the baseline.
        # 
        # >  You can call the [DescribeCheckWarningSummary](~~116179~~) operation to query the IDs of baselines.
        self.risk_id = risk_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCheckFixDetailsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_ids is not None:
            result['CheckIds'] = self.check_ids
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.risk_id is not None:
            result['RiskId'] = self.risk_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CheckIds') is not None:
            self.check_ids = m.get('CheckIds')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('RiskId') is not None:
            self.risk_id = m.get('RiskId')
        return self


class DescribeCheckFixDetailsResponseBodyCheckFixDetailsRulesParamList(TeaModel):
    def __init__(self, enum_value=None, max_value=None, min_value=None, param_default_value=None, param_desc=None,
                 param_name=None, param_type=None, rule_id=None, value=None):
        # The options that can be selected for the rule parameter if the value of the ParamType parameter is 2.
        self.enum_value = enum_value  # type: str
        # The maximum value of the rule parameter.
        self.max_value = max_value  # type: int
        # The minimum value of the rule parameter.
        self.min_value = min_value  # type: int
        # The default value of the rule parameter.
        self.param_default_value = param_default_value  # type: str
        # The description of the rule parameter.
        self.param_desc = param_desc  # type: str
        # The name of the rule parameter.
        self.param_name = param_name  # type: str
        # The type of the rule parameter. Valid values:
        # 
        # *   **1**: input
        # *   **2**: selection
        self.param_type = param_type  # type: int
        # The ID of the rule.
        self.rule_id = rule_id  # type: str
        # The specified value of the rule parameter.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCheckFixDetailsResponseBodyCheckFixDetailsRulesParamList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enum_value is not None:
            result['EnumValue'] = self.enum_value
        if self.max_value is not None:
            result['MaxValue'] = self.max_value
        if self.min_value is not None:
            result['MinValue'] = self.min_value
        if self.param_default_value is not None:
            result['ParamDefaultValue'] = self.param_default_value
        if self.param_desc is not None:
            result['ParamDesc'] = self.param_desc
        if self.param_name is not None:
            result['ParamName'] = self.param_name
        if self.param_type is not None:
            result['ParamType'] = self.param_type
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EnumValue') is not None:
            self.enum_value = m.get('EnumValue')
        if m.get('MaxValue') is not None:
            self.max_value = m.get('MaxValue')
        if m.get('MinValue') is not None:
            self.min_value = m.get('MinValue')
        if m.get('ParamDefaultValue') is not None:
            self.param_default_value = m.get('ParamDefaultValue')
        if m.get('ParamDesc') is not None:
            self.param_desc = m.get('ParamDesc')
        if m.get('ParamName') is not None:
            self.param_name = m.get('ParamName')
        if m.get('ParamType') is not None:
            self.param_type = m.get('ParamType')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeCheckFixDetailsResponseBodyCheckFixDetailsRules(TeaModel):
    def __init__(self, check_id=None, default_value=None, optional=None, param_list=None, rule_desc=None,
                 rule_id=None, value=None, var_name=None):
        # The ID of the risk item.
        self.check_id = check_id  # type: long
        # The default value of the rule.
        self.default_value = default_value  # type: int
        # Indicates whether the rule is optional. Valid values:
        # 
        # *   **1**: yes
        # *   **0**: no
        self.optional = optional  # type: int
        # An array that consists of the rule parameters.
        self.param_list = param_list  # type: list[DescribeCheckFixDetailsResponseBodyCheckFixDetailsRulesParamList]
        # The description of the rule.
        self.rule_desc = rule_desc  # type: str
        # The ID of the rule.
        self.rule_id = rule_id  # type: str
        # The specified value of the rule parameter.
        self.value = value  # type: int
        # The name of the variable.
        self.var_name = var_name  # type: str

    def validate(self):
        if self.param_list:
            for k in self.param_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCheckFixDetailsResponseBodyCheckFixDetailsRules, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_id is not None:
            result['CheckId'] = self.check_id
        if self.default_value is not None:
            result['DefaultValue'] = self.default_value
        if self.optional is not None:
            result['Optional'] = self.optional
        result['ParamList'] = []
        if self.param_list is not None:
            for k in self.param_list:
                result['ParamList'].append(k.to_map() if k else None)
        if self.rule_desc is not None:
            result['RuleDesc'] = self.rule_desc
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.value is not None:
            result['Value'] = self.value
        if self.var_name is not None:
            result['VarName'] = self.var_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CheckId') is not None:
            self.check_id = m.get('CheckId')
        if m.get('DefaultValue') is not None:
            self.default_value = m.get('DefaultValue')
        if m.get('Optional') is not None:
            self.optional = m.get('Optional')
        self.param_list = []
        if m.get('ParamList') is not None:
            for k in m.get('ParamList'):
                temp_model = DescribeCheckFixDetailsResponseBodyCheckFixDetailsRulesParamList()
                self.param_list.append(temp_model.from_map(k))
        if m.get('RuleDesc') is not None:
            self.rule_desc = m.get('RuleDesc')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('VarName') is not None:
            self.var_name = m.get('VarName')
        return self


class DescribeCheckFixDetailsResponseBodyCheckFixDetails(TeaModel):
    def __init__(self, check_desc=None, check_id=None, check_item=None, rules=None):
        # The detailed description of the risk item.
        self.check_desc = check_desc  # type: str
        # The ID of the risk item.
        self.check_id = check_id  # type: long
        # The description of the risk item.
        self.check_item = check_item  # type: str
        # An array consisting of the rules that are supported by the risk item.
        self.rules = rules  # type: list[DescribeCheckFixDetailsResponseBodyCheckFixDetailsRules]

    def validate(self):
        if self.rules:
            for k in self.rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCheckFixDetailsResponseBodyCheckFixDetails, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_desc is not None:
            result['CheckDesc'] = self.check_desc
        if self.check_id is not None:
            result['CheckId'] = self.check_id
        if self.check_item is not None:
            result['CheckItem'] = self.check_item
        result['Rules'] = []
        if self.rules is not None:
            for k in self.rules:
                result['Rules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CheckDesc') is not None:
            self.check_desc = m.get('CheckDesc')
        if m.get('CheckId') is not None:
            self.check_id = m.get('CheckId')
        if m.get('CheckItem') is not None:
            self.check_item = m.get('CheckItem')
        self.rules = []
        if m.get('Rules') is not None:
            for k in m.get('Rules'):
                temp_model = DescribeCheckFixDetailsResponseBodyCheckFixDetailsRules()
                self.rules.append(temp_model.from_map(k))
        return self


class DescribeCheckFixDetailsResponseBody(TeaModel):
    def __init__(self, check_fix_details=None, count=None, request_id=None):
        # An array that consists of the parameters.
        self.check_fix_details = check_fix_details  # type: list[DescribeCheckFixDetailsResponseBodyCheckFixDetails]
        # The number of risk items that can be fixed.
        self.count = count  # type: int
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.check_fix_details:
            for k in self.check_fix_details:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCheckFixDetailsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CheckFixDetails'] = []
        if self.check_fix_details is not None:
            for k in self.check_fix_details:
                result['CheckFixDetails'].append(k.to_map() if k else None)
        if self.count is not None:
            result['Count'] = self.count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.check_fix_details = []
        if m.get('CheckFixDetails') is not None:
            for k in m.get('CheckFixDetails'):
                temp_model = DescribeCheckFixDetailsResponseBodyCheckFixDetails()
                self.check_fix_details.append(temp_model.from_map(k))
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeCheckFixDetailsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCheckFixDetailsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCheckFixDetailsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCheckFixDetailsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCheckWarningDetailRequest(TeaModel):
    def __init__(self, check_warning_id=None, lang=None, source_ip=None):
        self.check_warning_id = check_warning_id  # type: long
        self.lang = lang  # type: str
        self.source_ip = source_ip  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCheckWarningDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_warning_id is not None:
            result['CheckWarningId'] = self.check_warning_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CheckWarningId') is not None:
            self.check_warning_id = m.get('CheckWarningId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeCheckWarningDetailResponseBody(TeaModel):
    def __init__(self, advice=None, check_id=None, description=None, item=None, level=None, prompt=None,
                 request_id=None, type=None):
        self.advice = advice  # type: str
        self.check_id = check_id  # type: long
        self.description = description  # type: str
        self.item = item  # type: str
        self.level = level  # type: str
        self.prompt = prompt  # type: str
        self.request_id = request_id  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCheckWarningDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.advice is not None:
            result['Advice'] = self.advice
        if self.check_id is not None:
            result['CheckId'] = self.check_id
        if self.description is not None:
            result['Description'] = self.description
        if self.item is not None:
            result['Item'] = self.item
        if self.level is not None:
            result['Level'] = self.level
        if self.prompt is not None:
            result['Prompt'] = self.prompt
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Advice') is not None:
            self.advice = m.get('Advice')
        if m.get('CheckId') is not None:
            self.check_id = m.get('CheckId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Item') is not None:
            self.item = m.get('Item')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Prompt') is not None:
            self.prompt = m.get('Prompt')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeCheckWarningDetailResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCheckWarningDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCheckWarningDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCheckWarningDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCheckWarningMachinesRequest(TeaModel):
    def __init__(self, check_id=None, lang=None, risk_id=None, status=None):
        self.check_id = check_id  # type: long
        self.lang = lang  # type: str
        self.risk_id = risk_id  # type: long
        self.status = status  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCheckWarningMachinesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_id is not None:
            result['CheckId'] = self.check_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.risk_id is not None:
            result['RiskId'] = self.risk_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CheckId') is not None:
            self.check_id = m.get('CheckId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('RiskId') is not None:
            self.risk_id = m.get('RiskId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeCheckWarningMachinesResponseBodyMachines(TeaModel):
    def __init__(self, bind=None, instance_id=None, instance_name=None, internet_ip=None, intranet_ip=None,
                 region_id=None, uuid=None):
        self.bind = bind  # type: bool
        self.instance_id = instance_id  # type: str
        self.instance_name = instance_name  # type: str
        self.internet_ip = internet_ip  # type: str
        self.intranet_ip = intranet_ip  # type: str
        self.region_id = region_id  # type: str
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCheckWarningMachinesResponseBodyMachines, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bind is not None:
            result['Bind'] = self.bind
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bind') is not None:
            self.bind = m.get('Bind')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeCheckWarningMachinesResponseBody(TeaModel):
    def __init__(self, count=None, machines=None, request_id=None):
        self.count = count  # type: int
        self.machines = machines  # type: list[DescribeCheckWarningMachinesResponseBodyMachines]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.machines:
            for k in self.machines:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCheckWarningMachinesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        result['Machines'] = []
        if self.machines is not None:
            for k in self.machines:
                result['Machines'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        self.machines = []
        if m.get('Machines') is not None:
            for k in m.get('Machines'):
                temp_model = DescribeCheckWarningMachinesResponseBodyMachines()
                self.machines.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeCheckWarningMachinesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCheckWarningMachinesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCheckWarningMachinesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCheckWarningMachinesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCheckWarningSummaryRequest(TeaModel):
    def __init__(self, cluster_id=None, container_field_name=None, container_field_value=None, current_page=None,
                 group_id=None, lang=None, page_size=None, risk_name=None, risk_status=None, source_ip=None, status=None,
                 strategy_id=None, target_type=None, type_name=None, uuids=None):
        self.cluster_id = cluster_id  # type: str
        self.container_field_name = container_field_name  # type: str
        self.container_field_value = container_field_value  # type: str
        self.current_page = current_page  # type: int
        self.group_id = group_id  # type: long
        self.lang = lang  # type: str
        self.page_size = page_size  # type: int
        self.risk_name = risk_name  # type: str
        self.risk_status = risk_status  # type: int
        self.source_ip = source_ip  # type: str
        self.status = status  # type: str
        self.strategy_id = strategy_id  # type: long
        self.target_type = target_type  # type: str
        self.type_name = type_name  # type: str
        self.uuids = uuids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCheckWarningSummaryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.container_field_name is not None:
            result['ContainerFieldName'] = self.container_field_name
        if self.container_field_value is not None:
            result['ContainerFieldValue'] = self.container_field_value
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.risk_name is not None:
            result['RiskName'] = self.risk_name
        if self.risk_status is not None:
            result['RiskStatus'] = self.risk_status
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.status is not None:
            result['Status'] = self.status
        if self.strategy_id is not None:
            result['StrategyId'] = self.strategy_id
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        if self.type_name is not None:
            result['TypeName'] = self.type_name
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ContainerFieldName') is not None:
            self.container_field_name = m.get('ContainerFieldName')
        if m.get('ContainerFieldValue') is not None:
            self.container_field_value = m.get('ContainerFieldValue')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RiskName') is not None:
            self.risk_name = m.get('RiskName')
        if m.get('RiskStatus') is not None:
            self.risk_status = m.get('RiskStatus')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StrategyId') is not None:
            self.strategy_id = m.get('StrategyId')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        if m.get('TypeName') is not None:
            self.type_name = m.get('TypeName')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        return self


class DescribeCheckWarningSummaryResponseBodyWarningSummarys(TeaModel):
    def __init__(self, check_count=None, check_exploit=None, database_risk=None, high_warning_count=None,
                 last_found_time=None, level=None, low_warning_count=None, medium_warning_count=None, risk_id=None, risk_name=None,
                 sub_type_alias=None, type_alias=None, warning_machine_count=None):
        self.check_count = check_count  # type: int
        self.check_exploit = check_exploit  # type: bool
        self.database_risk = database_risk  # type: bool
        self.high_warning_count = high_warning_count  # type: int
        self.last_found_time = last_found_time  # type: str
        self.level = level  # type: str
        self.low_warning_count = low_warning_count  # type: int
        self.medium_warning_count = medium_warning_count  # type: int
        self.risk_id = risk_id  # type: long
        self.risk_name = risk_name  # type: str
        self.sub_type_alias = sub_type_alias  # type: str
        self.type_alias = type_alias  # type: str
        self.warning_machine_count = warning_machine_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCheckWarningSummaryResponseBodyWarningSummarys, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_count is not None:
            result['CheckCount'] = self.check_count
        if self.check_exploit is not None:
            result['CheckExploit'] = self.check_exploit
        if self.database_risk is not None:
            result['DatabaseRisk'] = self.database_risk
        if self.high_warning_count is not None:
            result['HighWarningCount'] = self.high_warning_count
        if self.last_found_time is not None:
            result['LastFoundTime'] = self.last_found_time
        if self.level is not None:
            result['Level'] = self.level
        if self.low_warning_count is not None:
            result['LowWarningCount'] = self.low_warning_count
        if self.medium_warning_count is not None:
            result['MediumWarningCount'] = self.medium_warning_count
        if self.risk_id is not None:
            result['RiskId'] = self.risk_id
        if self.risk_name is not None:
            result['RiskName'] = self.risk_name
        if self.sub_type_alias is not None:
            result['SubTypeAlias'] = self.sub_type_alias
        if self.type_alias is not None:
            result['TypeAlias'] = self.type_alias
        if self.warning_machine_count is not None:
            result['WarningMachineCount'] = self.warning_machine_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CheckCount') is not None:
            self.check_count = m.get('CheckCount')
        if m.get('CheckExploit') is not None:
            self.check_exploit = m.get('CheckExploit')
        if m.get('DatabaseRisk') is not None:
            self.database_risk = m.get('DatabaseRisk')
        if m.get('HighWarningCount') is not None:
            self.high_warning_count = m.get('HighWarningCount')
        if m.get('LastFoundTime') is not None:
            self.last_found_time = m.get('LastFoundTime')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('LowWarningCount') is not None:
            self.low_warning_count = m.get('LowWarningCount')
        if m.get('MediumWarningCount') is not None:
            self.medium_warning_count = m.get('MediumWarningCount')
        if m.get('RiskId') is not None:
            self.risk_id = m.get('RiskId')
        if m.get('RiskName') is not None:
            self.risk_name = m.get('RiskName')
        if m.get('SubTypeAlias') is not None:
            self.sub_type_alias = m.get('SubTypeAlias')
        if m.get('TypeAlias') is not None:
            self.type_alias = m.get('TypeAlias')
        if m.get('WarningMachineCount') is not None:
            self.warning_machine_count = m.get('WarningMachineCount')
        return self


class DescribeCheckWarningSummaryResponseBody(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, request_id=None, total_count=None,
                 warning_summarys=None):
        self.count = count  # type: int
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int
        self.warning_summarys = warning_summarys  # type: list[DescribeCheckWarningSummaryResponseBodyWarningSummarys]

    def validate(self):
        if self.warning_summarys:
            for k in self.warning_summarys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCheckWarningSummaryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['WarningSummarys'] = []
        if self.warning_summarys is not None:
            for k in self.warning_summarys:
                result['WarningSummarys'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.warning_summarys = []
        if m.get('WarningSummarys') is not None:
            for k in m.get('WarningSummarys'):
                temp_model = DescribeCheckWarningSummaryResponseBodyWarningSummarys()
                self.warning_summarys.append(temp_model.from_map(k))
        return self


class DescribeCheckWarningSummaryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCheckWarningSummaryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCheckWarningSummaryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCheckWarningSummaryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCheckWarningsRequest(TeaModel):
    def __init__(self, check_id=None, check_type=None, current_page=None, lang=None, page_size=None, risk_id=None,
                 risk_status=None, source_ip=None, uuid=None):
        self.check_id = check_id  # type: long
        self.check_type = check_type  # type: str
        self.current_page = current_page  # type: int
        self.lang = lang  # type: str
        self.page_size = page_size  # type: int
        self.risk_id = risk_id  # type: long
        self.risk_status = risk_status  # type: int
        self.source_ip = source_ip  # type: str
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCheckWarningsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_id is not None:
            result['CheckId'] = self.check_id
        if self.check_type is not None:
            result['CheckType'] = self.check_type
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.risk_id is not None:
            result['RiskId'] = self.risk_id
        if self.risk_status is not None:
            result['RiskStatus'] = self.risk_status
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CheckId') is not None:
            self.check_id = m.get('CheckId')
        if m.get('CheckType') is not None:
            self.check_type = m.get('CheckType')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RiskId') is not None:
            self.risk_id = m.get('RiskId')
        if m.get('RiskStatus') is not None:
            self.risk_status = m.get('RiskStatus')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeCheckWarningsResponseBodyCheckWarnings(TeaModel):
    def __init__(self, check_id=None, check_warning_id=None, exec_error_message=None, fix_status=None, item=None,
                 level=None, reason=None, status=None, type=None, uuid=None):
        self.check_id = check_id  # type: long
        self.check_warning_id = check_warning_id  # type: long
        self.exec_error_message = exec_error_message  # type: str
        self.fix_status = fix_status  # type: int
        self.item = item  # type: str
        self.level = level  # type: str
        self.reason = reason  # type: str
        self.status = status  # type: int
        self.type = type  # type: str
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCheckWarningsResponseBodyCheckWarnings, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_id is not None:
            result['CheckId'] = self.check_id
        if self.check_warning_id is not None:
            result['CheckWarningId'] = self.check_warning_id
        if self.exec_error_message is not None:
            result['ExecErrorMessage'] = self.exec_error_message
        if self.fix_status is not None:
            result['FixStatus'] = self.fix_status
        if self.item is not None:
            result['Item'] = self.item
        if self.level is not None:
            result['Level'] = self.level
        if self.reason is not None:
            result['Reason'] = self.reason
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CheckId') is not None:
            self.check_id = m.get('CheckId')
        if m.get('CheckWarningId') is not None:
            self.check_warning_id = m.get('CheckWarningId')
        if m.get('ExecErrorMessage') is not None:
            self.exec_error_message = m.get('ExecErrorMessage')
        if m.get('FixStatus') is not None:
            self.fix_status = m.get('FixStatus')
        if m.get('Item') is not None:
            self.item = m.get('Item')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeCheckWarningsResponseBody(TeaModel):
    def __init__(self, check_warnings=None, count=None, current_page=None, page_size=None, request_id=None,
                 total_count=None):
        self.check_warnings = check_warnings  # type: list[DescribeCheckWarningsResponseBodyCheckWarnings]
        self.count = count  # type: int
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        if self.check_warnings:
            for k in self.check_warnings:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCheckWarningsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CheckWarnings'] = []
        if self.check_warnings is not None:
            for k in self.check_warnings:
                result['CheckWarnings'].append(k.to_map() if k else None)
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.check_warnings = []
        if m.get('CheckWarnings') is not None:
            for k in m.get('CheckWarnings'):
                temp_model = DescribeCheckWarningsResponseBodyCheckWarnings()
                self.check_warnings.append(temp_model.from_map(k))
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeCheckWarningsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCheckWarningsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCheckWarningsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCheckWarningsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeClientConfSetupRequest(TeaModel):
    def __init__(self, strategy_tag=None, strategy_tag_value=None):
        self.strategy_tag = strategy_tag  # type: str
        self.strategy_tag_value = strategy_tag_value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeClientConfSetupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.strategy_tag is not None:
            result['StrategyTag'] = self.strategy_tag
        if self.strategy_tag_value is not None:
            result['StrategyTagValue'] = self.strategy_tag_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('StrategyTag') is not None:
            self.strategy_tag = m.get('StrategyTag')
        if m.get('StrategyTagValue') is not None:
            self.strategy_tag_value = m.get('StrategyTagValue')
        return self


class DescribeClientConfSetupResponseBodyClientConf(TeaModel):
    def __init__(self, config=None, strategy_tag=None, strategy_tag_value=None):
        self.config = config  # type: str
        self.strategy_tag = strategy_tag  # type: str
        self.strategy_tag_value = strategy_tag_value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeClientConfSetupResponseBodyClientConf, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config is not None:
            result['Config'] = self.config
        if self.strategy_tag is not None:
            result['StrategyTag'] = self.strategy_tag
        if self.strategy_tag_value is not None:
            result['StrategyTagValue'] = self.strategy_tag_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Config') is not None:
            self.config = m.get('Config')
        if m.get('StrategyTag') is not None:
            self.strategy_tag = m.get('StrategyTag')
        if m.get('StrategyTagValue') is not None:
            self.strategy_tag_value = m.get('StrategyTagValue')
        return self


class DescribeClientConfSetupResponseBody(TeaModel):
    def __init__(self, client_conf=None, request_id=None):
        self.client_conf = client_conf  # type: DescribeClientConfSetupResponseBodyClientConf
        self.request_id = request_id  # type: str

    def validate(self):
        if self.client_conf:
            self.client_conf.validate()

    def to_map(self):
        _map = super(DescribeClientConfSetupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_conf is not None:
            result['ClientConf'] = self.client_conf.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientConf') is not None:
            temp_model = DescribeClientConfSetupResponseBodyClientConf()
            self.client_conf = temp_model.from_map(m['ClientConf'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeClientConfSetupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeClientConfSetupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeClientConfSetupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeClientConfSetupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeClientConfStrategyRequest(TeaModel):
    def __init__(self, tag=None, tag_value=None):
        self.tag = tag  # type: str
        self.tag_value = tag_value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeClientConfStrategyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class DescribeClientConfStrategyResponseBodyTargetList(TeaModel):
    def __init__(self, uuid=None):
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeClientConfStrategyResponseBodyTargetList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeClientConfStrategyResponseBody(TeaModel):
    def __init__(self, request_id=None, target_list=None, total_count=None):
        self.request_id = request_id  # type: str
        self.target_list = target_list  # type: list[DescribeClientConfStrategyResponseBodyTargetList]
        self.total_count = total_count  # type: int

    def validate(self):
        if self.target_list:
            for k in self.target_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeClientConfStrategyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['TargetList'] = []
        if self.target_list is not None:
            for k in self.target_list:
                result['TargetList'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.target_list = []
        if m.get('TargetList') is not None:
            for k in m.get('TargetList'):
                temp_model = DescribeClientConfStrategyResponseBodyTargetList()
                self.target_list.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeClientConfStrategyResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeClientConfStrategyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeClientConfStrategyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeClientConfStrategyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCloudCenterInstancesRequest(TeaModel):
    def __init__(self, criteria=None, current_page=None, importance=None, lang=None, logical_exp=None,
                 machine_types=None, no_group_trace=None, page_size=None, region_id=None):
        self.criteria = criteria  # type: str
        self.current_page = current_page  # type: int
        self.importance = importance  # type: int
        self.lang = lang  # type: str
        self.logical_exp = logical_exp  # type: str
        self.machine_types = machine_types  # type: str
        self.no_group_trace = no_group_trace  # type: bool
        self.page_size = page_size  # type: int
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCloudCenterInstancesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.criteria is not None:
            result['Criteria'] = self.criteria
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.importance is not None:
            result['Importance'] = self.importance
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.logical_exp is not None:
            result['LogicalExp'] = self.logical_exp
        if self.machine_types is not None:
            result['MachineTypes'] = self.machine_types
        if self.no_group_trace is not None:
            result['NoGroupTrace'] = self.no_group_trace
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Criteria') is not None:
            self.criteria = m.get('Criteria')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Importance') is not None:
            self.importance = m.get('Importance')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('LogicalExp') is not None:
            self.logical_exp = m.get('LogicalExp')
        if m.get('MachineTypes') is not None:
            self.machine_types = m.get('MachineTypes')
        if m.get('NoGroupTrace') is not None:
            self.no_group_trace = m.get('NoGroupTrace')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeCloudCenterInstancesResponseBodyInstances(TeaModel):
    def __init__(self, alarm_status=None, asset_type=None, auth_modify_time=None, auth_version=None,
                 auth_version_name=None, bind=None, client_status=None, cluster_id=None, cluster_name=None, cores=None, cpu_info=None,
                 created_time=None, exposed_status=None, flag=None, group_id=None, group_trace=None, hc_status=None,
                 health_check_count=None, importance=None, instance_id=None, instance_name=None, internet_ip=None, intranet_ip=None,
                 ip=None, ip_list_string=None, kernel=None, last_login_timestamp=None, mac_list_string=None, mem=None,
                 os=None, os_name=None, pod_count=None, region=None, region_id=None, region_name=None, risk_count=None,
                 risk_status=None, safe_event_count=None, status=None, tag=None, tag_id=None, uuid=None, vendor=None,
                 vendor_name=None, vpc_instance_id=None, vul_count=None, vul_status=None):
        self.alarm_status = alarm_status  # type: str
        self.asset_type = asset_type  # type: str
        self.auth_modify_time = auth_modify_time  # type: long
        self.auth_version = auth_version  # type: int
        self.auth_version_name = auth_version_name  # type: str
        self.bind = bind  # type: bool
        self.client_status = client_status  # type: str
        self.cluster_id = cluster_id  # type: str
        self.cluster_name = cluster_name  # type: str
        self.cores = cores  # type: int
        self.cpu_info = cpu_info  # type: str
        self.created_time = created_time  # type: long
        self.exposed_status = exposed_status  # type: int
        self.flag = flag  # type: int
        self.group_id = group_id  # type: long
        self.group_trace = group_trace  # type: str
        self.hc_status = hc_status  # type: str
        self.health_check_count = health_check_count  # type: int
        self.importance = importance  # type: int
        self.instance_id = instance_id  # type: str
        self.instance_name = instance_name  # type: str
        self.internet_ip = internet_ip  # type: str
        self.intranet_ip = intranet_ip  # type: str
        self.ip = ip  # type: str
        self.ip_list_string = ip_list_string  # type: str
        self.kernel = kernel  # type: str
        self.last_login_timestamp = last_login_timestamp  # type: long
        self.mac_list_string = mac_list_string  # type: str
        self.mem = mem  # type: int
        self.os = os  # type: str
        self.os_name = os_name  # type: str
        self.pod_count = pod_count  # type: int
        self.region = region  # type: str
        self.region_id = region_id  # type: str
        self.region_name = region_name  # type: str
        self.risk_count = risk_count  # type: str
        self.risk_status = risk_status  # type: str
        self.safe_event_count = safe_event_count  # type: int
        self.status = status  # type: str
        self.tag = tag  # type: str
        self.tag_id = tag_id  # type: str
        self.uuid = uuid  # type: str
        self.vendor = vendor  # type: int
        self.vendor_name = vendor_name  # type: str
        self.vpc_instance_id = vpc_instance_id  # type: str
        self.vul_count = vul_count  # type: int
        self.vul_status = vul_status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCloudCenterInstancesResponseBodyInstances, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_status is not None:
            result['AlarmStatus'] = self.alarm_status
        if self.asset_type is not None:
            result['AssetType'] = self.asset_type
        if self.auth_modify_time is not None:
            result['AuthModifyTime'] = self.auth_modify_time
        if self.auth_version is not None:
            result['AuthVersion'] = self.auth_version
        if self.auth_version_name is not None:
            result['AuthVersionName'] = self.auth_version_name
        if self.bind is not None:
            result['Bind'] = self.bind
        if self.client_status is not None:
            result['ClientStatus'] = self.client_status
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.cores is not None:
            result['Cores'] = self.cores
        if self.cpu_info is not None:
            result['CpuInfo'] = self.cpu_info
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.exposed_status is not None:
            result['ExposedStatus'] = self.exposed_status
        if self.flag is not None:
            result['Flag'] = self.flag
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_trace is not None:
            result['GroupTrace'] = self.group_trace
        if self.hc_status is not None:
            result['HcStatus'] = self.hc_status
        if self.health_check_count is not None:
            result['HealthCheckCount'] = self.health_check_count
        if self.importance is not None:
            result['Importance'] = self.importance
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.ip_list_string is not None:
            result['IpListString'] = self.ip_list_string
        if self.kernel is not None:
            result['Kernel'] = self.kernel
        if self.last_login_timestamp is not None:
            result['LastLoginTimestamp'] = self.last_login_timestamp
        if self.mac_list_string is not None:
            result['MacListString'] = self.mac_list_string
        if self.mem is not None:
            result['Mem'] = self.mem
        if self.os is not None:
            result['Os'] = self.os
        if self.os_name is not None:
            result['OsName'] = self.os_name
        if self.pod_count is not None:
            result['PodCount'] = self.pod_count
        if self.region is not None:
            result['Region'] = self.region
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.region_name is not None:
            result['RegionName'] = self.region_name
        if self.risk_count is not None:
            result['RiskCount'] = self.risk_count
        if self.risk_status is not None:
            result['RiskStatus'] = self.risk_status
        if self.safe_event_count is not None:
            result['SafeEventCount'] = self.safe_event_count
        if self.status is not None:
            result['Status'] = self.status
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.tag_id is not None:
            result['TagId'] = self.tag_id
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        if self.vendor_name is not None:
            result['VendorName'] = self.vendor_name
        if self.vpc_instance_id is not None:
            result['VpcInstanceId'] = self.vpc_instance_id
        if self.vul_count is not None:
            result['VulCount'] = self.vul_count
        if self.vul_status is not None:
            result['VulStatus'] = self.vul_status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlarmStatus') is not None:
            self.alarm_status = m.get('AlarmStatus')
        if m.get('AssetType') is not None:
            self.asset_type = m.get('AssetType')
        if m.get('AuthModifyTime') is not None:
            self.auth_modify_time = m.get('AuthModifyTime')
        if m.get('AuthVersion') is not None:
            self.auth_version = m.get('AuthVersion')
        if m.get('AuthVersionName') is not None:
            self.auth_version_name = m.get('AuthVersionName')
        if m.get('Bind') is not None:
            self.bind = m.get('Bind')
        if m.get('ClientStatus') is not None:
            self.client_status = m.get('ClientStatus')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('Cores') is not None:
            self.cores = m.get('Cores')
        if m.get('CpuInfo') is not None:
            self.cpu_info = m.get('CpuInfo')
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('ExposedStatus') is not None:
            self.exposed_status = m.get('ExposedStatus')
        if m.get('Flag') is not None:
            self.flag = m.get('Flag')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupTrace') is not None:
            self.group_trace = m.get('GroupTrace')
        if m.get('HcStatus') is not None:
            self.hc_status = m.get('HcStatus')
        if m.get('HealthCheckCount') is not None:
            self.health_check_count = m.get('HealthCheckCount')
        if m.get('Importance') is not None:
            self.importance = m.get('Importance')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('IpListString') is not None:
            self.ip_list_string = m.get('IpListString')
        if m.get('Kernel') is not None:
            self.kernel = m.get('Kernel')
        if m.get('LastLoginTimestamp') is not None:
            self.last_login_timestamp = m.get('LastLoginTimestamp')
        if m.get('MacListString') is not None:
            self.mac_list_string = m.get('MacListString')
        if m.get('Mem') is not None:
            self.mem = m.get('Mem')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('OsName') is not None:
            self.os_name = m.get('OsName')
        if m.get('PodCount') is not None:
            self.pod_count = m.get('PodCount')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RegionName') is not None:
            self.region_name = m.get('RegionName')
        if m.get('RiskCount') is not None:
            self.risk_count = m.get('RiskCount')
        if m.get('RiskStatus') is not None:
            self.risk_status = m.get('RiskStatus')
        if m.get('SafeEventCount') is not None:
            self.safe_event_count = m.get('SafeEventCount')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('TagId') is not None:
            self.tag_id = m.get('TagId')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        if m.get('VendorName') is not None:
            self.vendor_name = m.get('VendorName')
        if m.get('VpcInstanceId') is not None:
            self.vpc_instance_id = m.get('VpcInstanceId')
        if m.get('VulCount') is not None:
            self.vul_count = m.get('VulCount')
        if m.get('VulStatus') is not None:
            self.vul_status = m.get('VulStatus')
        return self


class DescribeCloudCenterInstancesResponseBodyPageInfo(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, total_count=None):
        self.count = count  # type: int
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCloudCenterInstancesResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeCloudCenterInstancesResponseBody(TeaModel):
    def __init__(self, instances=None, page_info=None, request_id=None, success=None):
        self.instances = instances  # type: list[DescribeCloudCenterInstancesResponseBodyInstances]
        self.page_info = page_info  # type: DescribeCloudCenterInstancesResponseBodyPageInfo
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.instances:
            for k in self.instances:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super(DescribeCloudCenterInstancesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Instances'] = []
        if self.instances is not None:
            for k in self.instances:
                result['Instances'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.instances = []
        if m.get('Instances') is not None:
            for k in m.get('Instances'):
                temp_model = DescribeCloudCenterInstancesResponseBodyInstances()
                self.instances.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeCloudCenterInstancesResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeCloudCenterInstancesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCloudCenterInstancesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCloudCenterInstancesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCloudCenterInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCloudProductFieldStatisticsResponseBodyGroupedFields(TeaModel):
    def __init__(self, category_count=None, instance_count=None, risk_instance_count=None):
        self.category_count = category_count  # type: str
        self.instance_count = instance_count  # type: int
        self.risk_instance_count = risk_instance_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCloudProductFieldStatisticsResponseBodyGroupedFields, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_count is not None:
            result['CategoryCount'] = self.category_count
        if self.instance_count is not None:
            result['InstanceCount'] = self.instance_count
        if self.risk_instance_count is not None:
            result['RiskInstanceCount'] = self.risk_instance_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CategoryCount') is not None:
            self.category_count = m.get('CategoryCount')
        if m.get('InstanceCount') is not None:
            self.instance_count = m.get('InstanceCount')
        if m.get('RiskInstanceCount') is not None:
            self.risk_instance_count = m.get('RiskInstanceCount')
        return self


class DescribeCloudProductFieldStatisticsResponseBody(TeaModel):
    def __init__(self, grouped_fields=None, request_id=None):
        self.grouped_fields = grouped_fields  # type: DescribeCloudProductFieldStatisticsResponseBodyGroupedFields
        self.request_id = request_id  # type: str

    def validate(self):
        if self.grouped_fields:
            self.grouped_fields.validate()

    def to_map(self):
        _map = super(DescribeCloudProductFieldStatisticsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.grouped_fields is not None:
            result['GroupedFields'] = self.grouped_fields.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupedFields') is not None:
            temp_model = DescribeCloudProductFieldStatisticsResponseBodyGroupedFields()
            self.grouped_fields = temp_model.from_map(m['GroupedFields'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeCloudProductFieldStatisticsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCloudProductFieldStatisticsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCloudProductFieldStatisticsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCloudProductFieldStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeClusterBasicInfoRequest(TeaModel):
    def __init__(self, cluster_id=None, target_type=None, type=None):
        self.cluster_id = cluster_id  # type: str
        self.target_type = target_type  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeClusterBasicInfoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeClusterBasicInfoResponseBodyClusterInfo(TeaModel):
    def __init__(self, cluster_id=None, cluster_name=None, cluster_type=None, create_time=None,
                 current_version=None, instance_count=None, region_id=None, state=None, target_result=None):
        self.cluster_id = cluster_id  # type: str
        self.cluster_name = cluster_name  # type: str
        self.cluster_type = cluster_type  # type: str
        self.create_time = create_time  # type: long
        self.current_version = current_version  # type: str
        self.instance_count = instance_count  # type: int
        self.region_id = region_id  # type: str
        self.state = state  # type: str
        self.target_result = target_result  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeClusterBasicInfoResponseBodyClusterInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.cluster_type is not None:
            result['ClusterType'] = self.cluster_type
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.current_version is not None:
            result['CurrentVersion'] = self.current_version
        if self.instance_count is not None:
            result['InstanceCount'] = self.instance_count
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.state is not None:
            result['State'] = self.state
        if self.target_result is not None:
            result['TargetResult'] = self.target_result
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('ClusterType') is not None:
            self.cluster_type = m.get('ClusterType')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CurrentVersion') is not None:
            self.current_version = m.get('CurrentVersion')
        if m.get('InstanceCount') is not None:
            self.instance_count = m.get('InstanceCount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('TargetResult') is not None:
            self.target_result = m.get('TargetResult')
        return self


class DescribeClusterBasicInfoResponseBody(TeaModel):
    def __init__(self, cluster_info=None, request_id=None):
        self.cluster_info = cluster_info  # type: DescribeClusterBasicInfoResponseBodyClusterInfo
        self.request_id = request_id  # type: str

    def validate(self):
        if self.cluster_info:
            self.cluster_info.validate()

    def to_map(self):
        _map = super(DescribeClusterBasicInfoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_info is not None:
            result['ClusterInfo'] = self.cluster_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterInfo') is not None:
            temp_model = DescribeClusterBasicInfoResponseBodyClusterInfo()
            self.cluster_info = temp_model.from_map(m['ClusterInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeClusterBasicInfoResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeClusterBasicInfoResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeClusterBasicInfoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeClusterBasicInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeClusterInfoListRequest(TeaModel):
    def __init__(self, target=None, target_type=None, type=None):
        # The operation value. The value specifies the ID of the cluster.
        self.target = target  # type: str
        # The dimension based on which you want to configure the feature. Valid values:
        # 
        # *   **Cluster**: the ID of the cluster
        self.target_type = target_type  # type: str
        # The type of the feature. Valid values:
        # 
        # *   **containerNetwork**: container network
        # *   **interceptionSwitch**: cluster microsegmentation
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeClusterInfoListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.target is not None:
            result['Target'] = self.target
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Target') is not None:
            self.target = m.get('Target')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeClusterInfoListResponseBodyClusterList(TeaModel):
    def __init__(self, cluster_id=None, cluster_name=None, cluster_type=None, region_id=None, state=None,
                 target_result=None):
        # The ID of the container cluster.
        self.cluster_id = cluster_id  # type: str
        # The name of the container cluster.
        self.cluster_name = cluster_name  # type: str
        # The type of the cluster. Valid values:
        # 
        # *   **ManagedKubernetes**: managed Kubernetes cluster
        # *   **NotManagedKubernetes**: non-managed Kubernetes cluster
        # *   **PrivateKubernetes**: private cluster
        # *   **kubernetes**: dedicated Kubernetes cluster
        # *   **ask**: dedicated ASK cluster
        self.cluster_type = cluster_type  # type: str
        # The region of the container cluster.
        self.region_id = region_id  # type: str
        # The status of the cluster. Valid values:
        # 
        # *   **unavailable**\
        # *   **Available**\
        # *   **Creating**\
        # *   **CreateFailed**\
        self.state = state  # type: str
        # Indicates whether the cluster is enabled. Valid values:
        # 
        # *   **true**: yes
        # *   **false**: no
        self.target_result = target_result  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeClusterInfoListResponseBodyClusterList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.cluster_type is not None:
            result['ClusterType'] = self.cluster_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.state is not None:
            result['State'] = self.state
        if self.target_result is not None:
            result['TargetResult'] = self.target_result
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('ClusterType') is not None:
            self.cluster_type = m.get('ClusterType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('TargetResult') is not None:
            self.target_result = m.get('TargetResult')
        return self


class DescribeClusterInfoListResponseBody(TeaModel):
    def __init__(self, cluster_list=None, request_id=None):
        # An array that consists of the information about clusters.
        self.cluster_list = cluster_list  # type: list[DescribeClusterInfoListResponseBodyClusterList]
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.cluster_list:
            for k in self.cluster_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeClusterInfoListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ClusterList'] = []
        if self.cluster_list is not None:
            for k in self.cluster_list:
                result['ClusterList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.cluster_list = []
        if m.get('ClusterList') is not None:
            for k in m.get('ClusterList'):
                temp_model = DescribeClusterInfoListResponseBodyClusterList()
                self.cluster_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeClusterInfoListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeClusterInfoListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeClusterInfoListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeClusterInfoListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeClusterNetworkRequest(TeaModel):
    def __init__(self, end_time=None, start_time=None):
        self.end_time = end_time  # type: long
        self.start_time = start_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeClusterNetworkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeClusterNetworkResponseBodyClusterNetworkEdge(TeaModel):
    def __init__(self, dst_node_id=None, dst_node_type=None, id=None, port=None, src_node_id=None,
                 src_node_type=None):
        self.dst_node_id = dst_node_id  # type: str
        self.dst_node_type = dst_node_type  # type: str
        self.id = id  # type: str
        self.port = port  # type: str
        self.src_node_id = src_node_id  # type: str
        self.src_node_type = src_node_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeClusterNetworkResponseBodyClusterNetworkEdge, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dst_node_id is not None:
            result['DstNodeId'] = self.dst_node_id
        if self.dst_node_type is not None:
            result['DstNodeType'] = self.dst_node_type
        if self.id is not None:
            result['Id'] = self.id
        if self.port is not None:
            result['Port'] = self.port
        if self.src_node_id is not None:
            result['SrcNodeId'] = self.src_node_id
        if self.src_node_type is not None:
            result['SrcNodeType'] = self.src_node_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DstNodeId') is not None:
            self.dst_node_id = m.get('DstNodeId')
        if m.get('DstNodeType') is not None:
            self.dst_node_type = m.get('DstNodeType')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('SrcNodeId') is not None:
            self.src_node_id = m.get('SrcNodeId')
        if m.get('SrcNodeType') is not None:
            self.src_node_type = m.get('SrcNodeType')
        return self


class DescribeClusterNetworkResponseBodyClusterNetworkNode(TeaModel):
    def __init__(self, cnnf_switch=None, id=None, interception_type=None, name=None, net_topo_switch=None,
                 risk_level=None, type=None):
        self.cnnf_switch = cnnf_switch  # type: int
        self.id = id  # type: str
        self.interception_type = interception_type  # type: int
        self.name = name  # type: str
        self.net_topo_switch = net_topo_switch  # type: str
        self.risk_level = risk_level  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeClusterNetworkResponseBodyClusterNetworkNode, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cnnf_switch is not None:
            result['CnnfSwitch'] = self.cnnf_switch
        if self.id is not None:
            result['Id'] = self.id
        if self.interception_type is not None:
            result['InterceptionType'] = self.interception_type
        if self.name is not None:
            result['Name'] = self.name
        if self.net_topo_switch is not None:
            result['NetTopoSwitch'] = self.net_topo_switch
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CnnfSwitch') is not None:
            self.cnnf_switch = m.get('CnnfSwitch')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('InterceptionType') is not None:
            self.interception_type = m.get('InterceptionType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NetTopoSwitch') is not None:
            self.net_topo_switch = m.get('NetTopoSwitch')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeClusterNetworkResponseBodyClusterNetwork(TeaModel):
    def __init__(self, edge=None, node=None):
        self.edge = edge  # type: list[DescribeClusterNetworkResponseBodyClusterNetworkEdge]
        self.node = node  # type: list[DescribeClusterNetworkResponseBodyClusterNetworkNode]

    def validate(self):
        if self.edge:
            for k in self.edge:
                if k:
                    k.validate()
        if self.node:
            for k in self.node:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeClusterNetworkResponseBodyClusterNetwork, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Edge'] = []
        if self.edge is not None:
            for k in self.edge:
                result['Edge'].append(k.to_map() if k else None)
        result['Node'] = []
        if self.node is not None:
            for k in self.node:
                result['Node'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.edge = []
        if m.get('Edge') is not None:
            for k in m.get('Edge'):
                temp_model = DescribeClusterNetworkResponseBodyClusterNetworkEdge()
                self.edge.append(temp_model.from_map(k))
        self.node = []
        if m.get('Node') is not None:
            for k in m.get('Node'):
                temp_model = DescribeClusterNetworkResponseBodyClusterNetworkNode()
                self.node.append(temp_model.from_map(k))
        return self


class DescribeClusterNetworkResponseBody(TeaModel):
    def __init__(self, cluster_network=None, request_id=None):
        self.cluster_network = cluster_network  # type: DescribeClusterNetworkResponseBodyClusterNetwork
        self.request_id = request_id  # type: str

    def validate(self):
        if self.cluster_network:
            self.cluster_network.validate()

    def to_map(self):
        _map = super(DescribeClusterNetworkResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_network is not None:
            result['ClusterNetwork'] = self.cluster_network.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterNetwork') is not None:
            temp_model = DescribeClusterNetworkResponseBodyClusterNetwork()
            self.cluster_network = temp_model.from_map(m['ClusterNetwork'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeClusterNetworkResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeClusterNetworkResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeClusterNetworkResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeClusterNetworkResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeClusterVulStatisticsRequest(TeaModel):
    def __init__(self, cluster_id=None, types=None):
        self.cluster_id = cluster_id  # type: str
        self.types = types  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeClusterVulStatisticsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.types is not None:
            result['Types'] = self.types
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('Types') is not None:
            self.types = m.get('Types')
        return self


class DescribeClusterVulStatisticsResponseBodyVulStat(TeaModel):
    def __init__(self, asap_count=None, later_count=None, nntf_count=None):
        self.asap_count = asap_count  # type: str
        self.later_count = later_count  # type: str
        self.nntf_count = nntf_count  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeClusterVulStatisticsResponseBodyVulStat, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asap_count is not None:
            result['AsapCount'] = self.asap_count
        if self.later_count is not None:
            result['LaterCount'] = self.later_count
        if self.nntf_count is not None:
            result['NntfCount'] = self.nntf_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AsapCount') is not None:
            self.asap_count = m.get('AsapCount')
        if m.get('LaterCount') is not None:
            self.later_count = m.get('LaterCount')
        if m.get('NntfCount') is not None:
            self.nntf_count = m.get('NntfCount')
        return self


class DescribeClusterVulStatisticsResponseBody(TeaModel):
    def __init__(self, request_id=None, vul_stat=None):
        self.request_id = request_id  # type: str
        self.vul_stat = vul_stat  # type: DescribeClusterVulStatisticsResponseBodyVulStat

    def validate(self):
        if self.vul_stat:
            self.vul_stat.validate()

    def to_map(self):
        _map = super(DescribeClusterVulStatisticsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.vul_stat is not None:
            result['VulStat'] = self.vul_stat.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('VulStat') is not None:
            temp_model = DescribeClusterVulStatisticsResponseBodyVulStat()
            self.vul_stat = temp_model.from_map(m['VulStat'])
        return self


class DescribeClusterVulStatisticsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeClusterVulStatisticsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeClusterVulStatisticsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeClusterVulStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCommonOverallConfigRequest(TeaModel):
    def __init__(self, source_ip=None, type=None):
        # The source IP address of the request.
        self.source_ip = source_ip  # type: str
        # The type of the feature. Valid values:
        # 
        # *   **kdump_switch**: Active defense experience optimization
        # *   **threat_detect**: Dynamic adaptive threat detection capability
        # *   **suspicious_aggregation**: Alert Association
        # *   **alidetect**: File Test
        # *   **USER-ENABLE-SWITCH-TYPE\_3277**: Suspicious process startup
        # *   **USER-ENABLE-SWITCH-TYPE\_5507**: malicious drivers
        # *   **USER-ENABLE-SWITCH-TYPE\_38857**: Entrance service execution high-risk operation
        # *   **USER-ENABLE-SWITCH-TYPE\_50858**: Web service performs high-risk operations
        # *   **USER-ENABLE-SWITCH-TYPE\_50859**: Entrance service execution suspicious operation
        # *   **USER-ENABLE-SWITCH-TYPE\_50861**: Information detection
        # *   **USER-ENABLE-SWITCH-TYPE\_50862**: Cloud Assistant Advanced Protection
        # *   **USER-ENABLE-SWITCH-TYPE\_50867**: Create malicious files
        # *   **USER-ENABLE-SWITCH-TYPE\_50868**: Create suspicious files
        # *   **USER-ENABLE-SWITCH-TYPE\_50869**: Unauthorized execution of high-risk orders
        # *   **USER-ENABLE-SWITCH-TYPE\_50870**: Rebound Shell
        # *   **USER-ENABLE-SWITCH-TYPE\_50873**: WebShell execute command
        # *   **USER-ENABLE-SWITCH-TYPE\_50876**: Against security software
        # *   **USER-ENABLE-SWITCH-TYPE\_50877**: Malicious soft communication
        # *   **USER-ENABLE-SWITCH-TYPE\_50884**: Suspicious worm script behavior
        # *   **USER-ENABLE-SWITCH-TYPE\_50885**: malicious script behavior
        # *   **USER-ENABLE-SWITCH-TYPE\_50983**: obfuscated command
        # *   **USER-ENABLE-SWITCH-TYPE\_51200**: Command line download and run malicious files
        # *   **USER-ENABLE-SWITCH-TYPE\_51201**: ransomware
        # *   **USER-ENABLE-SWITCH-TYPE\_51202**: Suspected Extortion
        # *   **USER-ENABLE-SWITCH-TYPE\_53168**: process debugging
        # *   **USER-ENABLE-SWITCH-TYPE\_53272**: Exploiting Kernel Vulnerabilities to Elevate Privileges
        # *   **USER-ENABLE-SWITCH-TYPE\_54034**: Intranet scan
        # *   **USER-ENABLE-SWITCH-TYPE\_54265**: Hijacking the PAM Module
        # *   **USER-ENABLE-SWITCH-TYPE\_54395**: Unauthorized reading and writing of sensitive files
        # *   **USER-ENABLE-SWITCH-TYPE\_54699**: Hijack dynamic link library
        # *   **USER-ENABLE-SWITCH-TYPE\_54953**: Hashdump Attack
        # *   **USER-ENABLE-SWITCH-TYPE\_57897**: suspected privilege escalation
        # *   **USER-ENABLE-SWITCH-TYPE\_62981**: Bypassing security monitoring
        # *   **USER-ENABLE-SWITCH-TYPE\_64025**: Ingress service execute command \[enhanced mode]
        # *   **USER-ENABLE-SWITCH-TYPE\_39659**: Sensitive Registry Key Protection
        # *   **USER-ENABLE-SWITCH-TYPE\_51225**: Powershell executes high-risk commands
        # *   **USER-ENABLE-SWITCH-TYPE\_51226**: Powershell execute suspicious command
        # *   **USER-ENABLE-SWITCH-TYPE\_51228**: High-risk lateral penetration tools
        # *   **USER-ENABLE-SWITCH-TYPE\_51229**: Browser service execution a high-risk operation
        # *   **USER-ENABLE-SWITCH-TYPE\_51230**: Entrance service execution suspicious operation
        # *   **USER-ENABLE-SWITCH-TYPE\_51232**: System processes execution high-risk operations
        # *   **USER-ENABLE-SWITCH-TYPE\_51233**: Java service execution high-risk operations
        # *   **USER-ENABLE-SWITCH-TYPE\_51234**: Office components execution high-risk operations
        # *   **USER-ENABLE-SWITCH-TYPE\_51235**: Web service performs high-risk operations
        # *   **USER-ENABLE-SWITCH-TYPE\_51236**: Rebound shells
        # *   **USER-ENABLE-SWITCH-TYPE\_52815**: Load high-risk drivers
        # *   **USER-ENABLE-SWITCH-TYPE\_52816**: high-risk account manipulation behavior
        # *   **USER-ENABLE-SWITCH-TYPE\_52818**: Information detection
        # *   **USER-ENABLE-SWITCH-TYPE\_52820**: Create malicious files
        # *   **USER-ENABLE-SWITCH-TYPE\_52821**: Suspicious process startup
        # *   **USER-ENABLE-SWITCH-TYPE\_52823**: Running high-risk ARK tools
        # *   **USER-ENABLE-SWITCH-TYPE\_52825**: Unauthorized execution of high-risk orders
        # *   **USER-ENABLE-SWITCH-TYPE\_52826**: Entrance service execution high-risk operation
        # *   **USER-ENABLE-SWITCH-TYPE\_52827**: Ransomware
        # *   **USER-ENABLE-SWITCH-TYPE\_52828**: Suspected Extortion
        # *   **USER-ENABLE-SWITCH-TYPE\_52829**: delete system backup behavior
        # *   **USER-ENABLE-SWITCH-TYPE\_54168**: LSA security permission service protection
        # *   **USER-ENABLE-SWITCH-TYPE\_54365**: Create service autorun item
        # *   **USER-ENABLE-SWITCH-TYPE\_54366**: Create high-risk autorun item
        # *   **USER-ENABLE-SWITCH-TYPE\_54367**: Create scheduled task autorun item
        # *   **USER-ENABLE-SWITCH-TYPE\_54368**: Create registry autorun item
        # *   **USER-ENABLE-SWITCH-TYPE\_54369**: Create WMI autorun item
        # *   **USER-ENABLE-SWITCH-TYPE\_54373**: Against security software
        # *   **USER-ENABLE-SWITCH-TYPE\_54374**: Intrusion trace cleanup
        # *   **USER-ENABLE-SWITCH-TYPE\_54384**: Hashdump Attack
        # *   **USER-ENABLE-SWITCH-TYPE\_55251**: Database services execution high-risk operations
        # *   **USER-ENABLE-SWITCH-TYPE\_57242**: Malicious command execution
        # *   **USER-ENABLE-SWITCH-TYPE\_57340**: Command line download and run malicious files
        # *   **USER-ENABLE-SWITCH-TYPE\_62357**: Cloud Assistant service information detection
        # *   **USER-ENABLE-SWITCH-TYPE\_63725**: Ingress service implants suspicious script/binary file
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCommonOverallConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeCommonOverallConfigResponseBodyOverallConfig(TeaModel):
    def __init__(self, config=None, type=None):
        # The status of the feature. Valid values:
        # 
        # *   **on**: enabled
        # *   **off**: disabled
        self.config = config  # type: str
        # The type of the feature. Valid values:
        # 
        # *   **kdump_switch**: Active defense experience optimization
        # *   **threat_detect**: Dynamic adaptive threat detection capability
        # *   **suspicious_aggregation**: Alert Association
        # *   **alidetect**: File Test
        # *   **USER-ENABLE-SWITCH-TYPE\_3277**: Suspicious process startup
        # *   **USER-ENABLE-SWITCH-TYPE\_5507**: malicious drivers
        # *   **USER-ENABLE-SWITCH-TYPE\_38857**: Entrance service execution high-risk operation
        # *   **USER-ENABLE-SWITCH-TYPE\_50858**: Web service performs high-risk operations
        # *   **USER-ENABLE-SWITCH-TYPE\_50859**: Entrance service execution suspicious operation
        # *   **USER-ENABLE-SWITCH-TYPE\_50861**: Information detection
        # *   **USER-ENABLE-SWITCH-TYPE\_50862**: Cloud Assistant Advanced Protection
        # *   **USER-ENABLE-SWITCH-TYPE\_50867**: Create malicious files
        # *   **USER-ENABLE-SWITCH-TYPE\_50868**: Create suspicious files
        # *   **USER-ENABLE-SWITCH-TYPE\_50869**: Unauthorized execution of high-risk orders
        # *   **USER-ENABLE-SWITCH-TYPE\_50870**: Rebound Shell
        # *   **USER-ENABLE-SWITCH-TYPE\_50873**: WebShell execute command
        # *   **USER-ENABLE-SWITCH-TYPE\_50876**: Against security software
        # *   **USER-ENABLE-SWITCH-TYPE\_50877**: Malicious soft communication
        # *   **USER-ENABLE-SWITCH-TYPE\_50884**: Suspicious worm script behavior
        # *   **USER-ENABLE-SWITCH-TYPE\_50885**: malicious script behavior
        # *   **USER-ENABLE-SWITCH-TYPE\_50983**: obfuscated command
        # *   **USER-ENABLE-SWITCH-TYPE\_51200**: Command line download and run malicious files
        # *   **USER-ENABLE-SWITCH-TYPE\_51201**: ransomware
        # *   **USER-ENABLE-SWITCH-TYPE\_51202**: Suspected Extortion
        # *   **USER-ENABLE-SWITCH-TYPE\_53168**: process debugging
        # *   **USER-ENABLE-SWITCH-TYPE\_53272**: Exploiting Kernel Vulnerabilities to Elevate Privileges
        # *   **USER-ENABLE-SWITCH-TYPE\_54034**: Intranet scan
        # *   **USER-ENABLE-SWITCH-TYPE\_54265**: Hijacking the PAM Module
        # *   **USER-ENABLE-SWITCH-TYPE\_54395**: Unauthorized reading and writing of sensitive files
        # *   **USER-ENABLE-SWITCH-TYPE\_54699**: Hijack dynamic link library
        # *   **USER-ENABLE-SWITCH-TYPE\_54953**: Hashdump Attack
        # *   **USER-ENABLE-SWITCH-TYPE\_57897**: suspected privilege escalation
        # *   **USER-ENABLE-SWITCH-TYPE\_62981**: Bypassing security monitoring
        # *   **USER-ENABLE-SWITCH-TYPE\_64025**: Ingress service execute command \[enhanced mode]
        # *   **USER-ENABLE-SWITCH-TYPE\_39659**: Sensitive Registry Key Protection
        # *   **USER-ENABLE-SWITCH-TYPE\_51225**: Powershell executes high-risk commands
        # *   **USER-ENABLE-SWITCH-TYPE\_51226**: Powershell execute suspicious command
        # *   **USER-ENABLE-SWITCH-TYPE\_51228**: High-risk lateral penetration tools
        # *   **USER-ENABLE-SWITCH-TYPE\_51229**: Browser service execution a high-risk operation
        # *   **USER-ENABLE-SWITCH-TYPE\_51230**: Entrance service execution suspicious operation
        # *   **USER-ENABLE-SWITCH-TYPE\_51232**: System processes execution high-risk operations
        # *   **USER-ENABLE-SWITCH-TYPE\_51233**: Java service execution high-risk operations
        # *   **USER-ENABLE-SWITCH-TYPE\_51234**: Office components execution high-risk operations
        # *   **USER-ENABLE-SWITCH-TYPE\_51235**: Web service performs high-risk operations
        # *   **USER-ENABLE-SWITCH-TYPE\_51236**: Rebound shells
        # *   **USER-ENABLE-SWITCH-TYPE\_52815**: Load high-risk drivers
        # *   **USER-ENABLE-SWITCH-TYPE\_52816**: high-risk account manipulation behavior
        # *   **USER-ENABLE-SWITCH-TYPE\_52818**: Information detection
        # *   **USER-ENABLE-SWITCH-TYPE\_52820**: Create malicious files
        # *   **USER-ENABLE-SWITCH-TYPE\_52821**: Suspicious process startup
        # *   **USER-ENABLE-SWITCH-TYPE\_52823**: Running high-risk ARK tools
        # *   **USER-ENABLE-SWITCH-TYPE\_52825**: Unauthorized execution of high-risk orders
        # *   **USER-ENABLE-SWITCH-TYPE\_52826**: Entrance service execution high-risk operation
        # *   **USER-ENABLE-SWITCH-TYPE\_52827**: Ransomware
        # *   **USER-ENABLE-SWITCH-TYPE\_52828**: Suspected Extortion
        # *   **USER-ENABLE-SWITCH-TYPE\_52829**: delete system backup behavior
        # *   **USER-ENABLE-SWITCH-TYPE\_54168**: LSA security permission service protection
        # *   **USER-ENABLE-SWITCH-TYPE\_54365**: Create service autorun item
        # *   **USER-ENABLE-SWITCH-TYPE\_54366**: Create high-risk autorun item
        # *   **USER-ENABLE-SWITCH-TYPE\_54367**: Create scheduled task autorun item
        # *   **USER-ENABLE-SWITCH-TYPE\_54368**: Create registry autorun item
        # *   **USER-ENABLE-SWITCH-TYPE\_54369**: Create WMI autorun item
        # *   **USER-ENABLE-SWITCH-TYPE\_54373**: Against security software
        # *   **USER-ENABLE-SWITCH-TYPE\_54374**: Intrusion trace cleanup
        # *   **USER-ENABLE-SWITCH-TYPE\_54384**: Hashdump Attack
        # *   **USER-ENABLE-SWITCH-TYPE\_55251**: Database services execution high-risk operations
        # *   **USER-ENABLE-SWITCH-TYPE\_57242**: Malicious command execution
        # *   **USER-ENABLE-SWITCH-TYPE\_57340**: Command line download and run malicious files
        # *   **USER-ENABLE-SWITCH-TYPE\_62357**: Cloud Assistant service information detection
        # *   **USER-ENABLE-SWITCH-TYPE\_63725**: Ingress service implants suspicious script/binary file
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCommonOverallConfigResponseBodyOverallConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config is not None:
            result['Config'] = self.config
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Config') is not None:
            self.config = m.get('Config')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeCommonOverallConfigResponseBody(TeaModel):
    def __init__(self, overall_config=None, request_id=None):
        # The information about the feature.
        self.overall_config = overall_config  # type: DescribeCommonOverallConfigResponseBodyOverallConfig
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.overall_config:
            self.overall_config.validate()

    def to_map(self):
        _map = super(DescribeCommonOverallConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.overall_config is not None:
            result['OverallConfig'] = self.overall_config.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OverallConfig') is not None:
            temp_model = DescribeCommonOverallConfigResponseBodyOverallConfig()
            self.overall_config = temp_model.from_map(m['OverallConfig'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeCommonOverallConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCommonOverallConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCommonOverallConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCommonOverallConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCommonOverallConfigListRequest(TeaModel):
    def __init__(self, source_ip=None, type_list=None):
        self.source_ip = source_ip  # type: str
        self.type_list = type_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCommonOverallConfigListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.type_list is not None:
            result['TypeList'] = self.type_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('TypeList') is not None:
            self.type_list = m.get('TypeList')
        return self


class DescribeCommonOverallConfigListResponseBodyOverallList(TeaModel):
    def __init__(self, config=None, total_count=None, type=None):
        self.config = config  # type: str
        self.total_count = total_count  # type: int
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCommonOverallConfigListResponseBodyOverallList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config is not None:
            result['Config'] = self.config
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Config') is not None:
            self.config = m.get('Config')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeCommonOverallConfigListResponseBody(TeaModel):
    def __init__(self, overall_list=None, request_id=None):
        self.overall_list = overall_list  # type: list[DescribeCommonOverallConfigListResponseBodyOverallList]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.overall_list:
            for k in self.overall_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCommonOverallConfigListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['OverallList'] = []
        if self.overall_list is not None:
            for k in self.overall_list:
                result['OverallList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.overall_list = []
        if m.get('OverallList') is not None:
            for k in m.get('OverallList'):
                temp_model = DescribeCommonOverallConfigListResponseBodyOverallList()
                self.overall_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeCommonOverallConfigListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCommonOverallConfigListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCommonOverallConfigListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCommonOverallConfigListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCommonTargetConfigRequest(TeaModel):
    def __init__(self, type=None):
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCommonTargetConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeCommonTargetConfigResponseBodyTargetList(TeaModel):
    def __init__(self, flag=None, target=None, target_type=None):
        self.flag = flag  # type: str
        self.target = target  # type: str
        self.target_type = target_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCommonTargetConfigResponseBodyTargetList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flag is not None:
            result['Flag'] = self.flag
        if self.target is not None:
            result['Target'] = self.target
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Flag') is not None:
            self.flag = m.get('Flag')
        if m.get('Target') is not None:
            self.target = m.get('Target')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        return self


class DescribeCommonTargetConfigResponseBody(TeaModel):
    def __init__(self, request_id=None, target_list=None):
        self.request_id = request_id  # type: str
        self.target_list = target_list  # type: list[DescribeCommonTargetConfigResponseBodyTargetList]

    def validate(self):
        if self.target_list:
            for k in self.target_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCommonTargetConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['TargetList'] = []
        if self.target_list is not None:
            for k in self.target_list:
                result['TargetList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.target_list = []
        if m.get('TargetList') is not None:
            for k in m.get('TargetList'):
                temp_model = DescribeCommonTargetConfigResponseBodyTargetList()
                self.target_list.append(temp_model.from_map(k))
        return self


class DescribeCommonTargetConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCommonTargetConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCommonTargetConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCommonTargetConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCommonTargetResultListRequest(TeaModel):
    def __init__(self, source_ip=None, type=None):
        self.source_ip = source_ip  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCommonTargetResultListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeCommonTargetResultListResponseBodyTargetConfig(TeaModel):
    def __init__(self, flag=None, target_default=None, target_list=None, target_type=None, total_count=None,
                 type=None):
        self.flag = flag  # type: str
        self.target_default = target_default  # type: str
        self.target_list = target_list  # type: list[str]
        self.target_type = target_type  # type: str
        self.total_count = total_count  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCommonTargetResultListResponseBodyTargetConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flag is not None:
            result['Flag'] = self.flag
        if self.target_default is not None:
            result['TargetDefault'] = self.target_default
        if self.target_list is not None:
            result['TargetList'] = self.target_list
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Flag') is not None:
            self.flag = m.get('Flag')
        if m.get('TargetDefault') is not None:
            self.target_default = m.get('TargetDefault')
        if m.get('TargetList') is not None:
            self.target_list = m.get('TargetList')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeCommonTargetResultListResponseBody(TeaModel):
    def __init__(self, request_id=None, target_config=None):
        self.request_id = request_id  # type: str
        self.target_config = target_config  # type: DescribeCommonTargetResultListResponseBodyTargetConfig

    def validate(self):
        if self.target_config:
            self.target_config.validate()

    def to_map(self):
        _map = super(DescribeCommonTargetResultListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.target_config is not None:
            result['TargetConfig'] = self.target_config.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TargetConfig') is not None:
            temp_model = DescribeCommonTargetResultListResponseBodyTargetConfig()
            self.target_config = temp_model.from_map(m['TargetConfig'])
        return self


class DescribeCommonTargetResultListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCommonTargetResultListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCommonTargetResultListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCommonTargetResultListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeConcernNecessityRequest(TeaModel):
    def __init__(self, lang=None):
        self.lang = lang  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeConcernNecessityRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeConcernNecessityResponseBody(TeaModel):
    def __init__(self, concern_necessity=None, request_id=None):
        self.concern_necessity = concern_necessity  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeConcernNecessityResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.concern_necessity is not None:
            result['ConcernNecessity'] = self.concern_necessity
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConcernNecessity') is not None:
            self.concern_necessity = m.get('ConcernNecessity')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeConcernNecessityResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeConcernNecessityResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeConcernNecessityResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeConcernNecessityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeContainerCriteriaRequest(TeaModel):
    def __init__(self, group_field=None, value=None):
        self.group_field = group_field  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeContainerCriteriaRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_field is not None:
            result['GroupField'] = self.group_field
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupField') is not None:
            self.group_field = m.get('GroupField')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeContainerCriteriaResponseBodyCriteriaList(TeaModel):
    def __init__(self, name=None, type=None, values=None):
        self.name = name  # type: str
        self.type = type  # type: str
        self.values = values  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeContainerCriteriaResponseBodyCriteriaList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.values is not None:
            result['Values'] = self.values
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Values') is not None:
            self.values = m.get('Values')
        return self


class DescribeContainerCriteriaResponseBody(TeaModel):
    def __init__(self, criteria_list=None, request_id=None):
        self.criteria_list = criteria_list  # type: list[DescribeContainerCriteriaResponseBodyCriteriaList]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.criteria_list:
            for k in self.criteria_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeContainerCriteriaResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CriteriaList'] = []
        if self.criteria_list is not None:
            for k in self.criteria_list:
                result['CriteriaList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.criteria_list = []
        if m.get('CriteriaList') is not None:
            for k in m.get('CriteriaList'):
                temp_model = DescribeContainerCriteriaResponseBodyCriteriaList()
                self.criteria_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeContainerCriteriaResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeContainerCriteriaResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeContainerCriteriaResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeContainerCriteriaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeContainerInstancesRequest(TeaModel):
    def __init__(self, criteria=None, current_page=None, logical_exp=None, page_size=None):
        # The search conditions that are used to filter containers. The value of this parameter is in the JSON format and is case-sensitive. The value contains the following fields:
        # 
        # *   **name**: the search condition.
        # 
        # *   **name**: the value of the search condition.
        # 
        # *   **logicalExp**: the logical relationship among multiple search conditions. Valid values:
        # 
        #     *   **OR**: Search conditions are evaluated by using a logical **OR**.
        #     *   **AND**: Search conditions are evaluated by using a logical **AND**.
        # 
        # > You can use search conditions such as the container ID, cluster ID, cluster name, cluster type, risk level, and region. You can call the [DescribeContainerCriteria](~~DescribeContainerCriteria~~) operation to query the supported search conditions.
        self.criteria = criteria  # type: str
        # The number of the page to return. Default value: **1**.
        self.current_page = current_page  # type: int
        # The logical operator that you want to use to evaluate multiple search conditions. Valid values:
        # 
        # *   **OR**: Search conditions are evaluated by using a logical **OR**.
        # *   **AND**: Search conditions are evaluated by using a logical **AND**.
        self.logical_exp = logical_exp  # type: str
        # The number of entries to return on each page. Default value: 20. If you leave this parameter empty, 20 entries are returned on each page.
        # 
        # > We recommend that you do not leave this parameter empty.
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeContainerInstancesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.criteria is not None:
            result['Criteria'] = self.criteria
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.logical_exp is not None:
            result['LogicalExp'] = self.logical_exp
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Criteria') is not None:
            self.criteria = m.get('Criteria')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('LogicalExp') is not None:
            self.logical_exp = m.get('LogicalExp')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeContainerInstancesResponseBodyContainerInstanceList(TeaModel):
    def __init__(self, alarm_count=None, alarm_status=None, app_name=None, cluster_id=None, cluster_name=None,
                 container_id=None, create_timestamp=None, hc_count=None, hc_status=None, host_ip=None, image=None,
                 image_digest=None, image_id=None, image_repo_name=None, image_repo_namespace=None, image_repo_tag=None,
                 image_uuid=None, instance_id=None, namespace=None, node_info=None, node_name=None, pod=None, pod_ip=None,
                 region_id=None, risk_count=None, risk_status=None, update_mark=None, vul_count=None, vul_status=None):
        # The number of alerts.
        self.alarm_count = alarm_count  # type: int
        # Indicates whether alerts are generated for the container. Valid values:
        # 
        # *   **YES**\
        # *   **NO**\
        self.alarm_status = alarm_status  # type: str
        # The name of the application.
        self.app_name = app_name  # type: str
        # The ID of cluster.
        self.cluster_id = cluster_id  # type: str
        # The name of the cluster.
        self.cluster_name = cluster_name  # type: str
        # The ID of the container.
        self.container_id = container_id  # type: str
        # The timestamp when the cluster was created. Unit: milliseconds.
        self.create_timestamp = create_timestamp  # type: long
        # The number of baseline risks.
        self.hc_count = hc_count  # type: int
        # Indicates whether baseline risks are detected. Valid values:
        # 
        # *   **NO**\
        # *   **YES**\
        self.hc_status = hc_status  # type: str
        # The IP address of the server.
        self.host_ip = host_ip  # type: str
        # The image of the container.
        self.image = image  # type: str
        # The digest value of the image.
        self.image_digest = image_digest  # type: str
        # The ID of the image.
        self.image_id = image_id  # type: str
        # The name of the image repository.
        self.image_repo_name = image_repo_name  # type: str
        # The namespace to which the image repository belongs.
        self.image_repo_namespace = image_repo_namespace  # type: str
        # The tag that is added to the image.
        self.image_repo_tag = image_repo_tag  # type: str
        # The UUID of the image.
        self.image_uuid = image_uuid  # type: str
        # The instance ID of the asset.
        self.instance_id = instance_id  # type: str
        # The namespace.
        self.namespace = namespace  # type: str
        # The node information.
        self.node_info = node_info  # type: str
        # The name of the node.
        self.node_name = node_name  # type: str
        # The pod.
        self.pod = pod  # type: str
        # The IP address of the pod.
        self.pod_ip = pod_ip  # type: str
        # The region ID of the container.
        self.region_id = region_id  # type: str
        # The number of risks.
        self.risk_count = risk_count  # type: str
        # Indicates whether risks exist. Valid values:
        # 
        # *   **NO**\
        # *   **YES**\
        self.risk_status = risk_status  # type: str
        # The update identifier of the container.
        self.update_mark = update_mark  # type: str
        # The number of vulnerabilities that are detected in the container cluster.
        self.vul_count = vul_count  # type: int
        # Indicates whether vulnerabilities are detected in the container. Valid values:
        # 
        # *   **YES**\
        # *   **NO**\
        self.vul_status = vul_status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeContainerInstancesResponseBodyContainerInstanceList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_count is not None:
            result['AlarmCount'] = self.alarm_count
        if self.alarm_status is not None:
            result['AlarmStatus'] = self.alarm_status
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.container_id is not None:
            result['ContainerId'] = self.container_id
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        if self.hc_count is not None:
            result['HcCount'] = self.hc_count
        if self.hc_status is not None:
            result['HcStatus'] = self.hc_status
        if self.host_ip is not None:
            result['HostIp'] = self.host_ip
        if self.image is not None:
            result['Image'] = self.image
        if self.image_digest is not None:
            result['ImageDigest'] = self.image_digest
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.image_repo_name is not None:
            result['ImageRepoName'] = self.image_repo_name
        if self.image_repo_namespace is not None:
            result['ImageRepoNamespace'] = self.image_repo_namespace
        if self.image_repo_tag is not None:
            result['ImageRepoTag'] = self.image_repo_tag
        if self.image_uuid is not None:
            result['ImageUuid'] = self.image_uuid
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.node_info is not None:
            result['NodeInfo'] = self.node_info
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.pod is not None:
            result['Pod'] = self.pod
        if self.pod_ip is not None:
            result['PodIp'] = self.pod_ip
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.risk_count is not None:
            result['RiskCount'] = self.risk_count
        if self.risk_status is not None:
            result['RiskStatus'] = self.risk_status
        if self.update_mark is not None:
            result['UpdateMark'] = self.update_mark
        if self.vul_count is not None:
            result['VulCount'] = self.vul_count
        if self.vul_status is not None:
            result['VulStatus'] = self.vul_status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlarmCount') is not None:
            self.alarm_count = m.get('AlarmCount')
        if m.get('AlarmStatus') is not None:
            self.alarm_status = m.get('AlarmStatus')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('ContainerId') is not None:
            self.container_id = m.get('ContainerId')
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        if m.get('HcCount') is not None:
            self.hc_count = m.get('HcCount')
        if m.get('HcStatus') is not None:
            self.hc_status = m.get('HcStatus')
        if m.get('HostIp') is not None:
            self.host_ip = m.get('HostIp')
        if m.get('Image') is not None:
            self.image = m.get('Image')
        if m.get('ImageDigest') is not None:
            self.image_digest = m.get('ImageDigest')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('ImageRepoName') is not None:
            self.image_repo_name = m.get('ImageRepoName')
        if m.get('ImageRepoNamespace') is not None:
            self.image_repo_namespace = m.get('ImageRepoNamespace')
        if m.get('ImageRepoTag') is not None:
            self.image_repo_tag = m.get('ImageRepoTag')
        if m.get('ImageUuid') is not None:
            self.image_uuid = m.get('ImageUuid')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('NodeInfo') is not None:
            self.node_info = m.get('NodeInfo')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('Pod') is not None:
            self.pod = m.get('Pod')
        if m.get('PodIp') is not None:
            self.pod_ip = m.get('PodIp')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RiskCount') is not None:
            self.risk_count = m.get('RiskCount')
        if m.get('RiskStatus') is not None:
            self.risk_status = m.get('RiskStatus')
        if m.get('UpdateMark') is not None:
            self.update_mark = m.get('UpdateMark')
        if m.get('VulCount') is not None:
            self.vul_count = m.get('VulCount')
        if m.get('VulStatus') is not None:
            self.vul_status = m.get('VulStatus')
        return self


class DescribeContainerInstancesResponseBodyPageInfo(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, total_count=None):
        # The number of entries returned on the current page.
        self.count = count  # type: int
        # The page number of the returned page.
        self.current_page = current_page  # type: int
        # The number of entries returned per page.
        self.page_size = page_size  # type: int
        # The total number of entries returned.
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeContainerInstancesResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeContainerInstancesResponseBody(TeaModel):
    def __init__(self, container_instance_list=None, page_info=None, request_id=None):
        # An array that consists of the information about containers.
        self.container_instance_list = container_instance_list  # type: list[DescribeContainerInstancesResponseBodyContainerInstanceList]
        # The pagination information.
        self.page_info = page_info  # type: DescribeContainerInstancesResponseBodyPageInfo
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.container_instance_list:
            for k in self.container_instance_list:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super(DescribeContainerInstancesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ContainerInstanceList'] = []
        if self.container_instance_list is not None:
            for k in self.container_instance_list:
                result['ContainerInstanceList'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.container_instance_list = []
        if m.get('ContainerInstanceList') is not None:
            for k in m.get('ContainerInstanceList'):
                temp_model = DescribeContainerInstancesResponseBodyContainerInstanceList()
                self.container_instance_list.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeContainerInstancesResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeContainerInstancesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeContainerInstancesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeContainerInstancesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeContainerInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeContainerStatisticsRequest(TeaModel):
    def __init__(self, cluster_id=None):
        # The ID of the container cluster.
        # 
        # >  You can call the [DescribeGroupedContainerInstances](~~DescribeGroupedContainerInstances~~) operation to query the IDs of container clusters.
        self.cluster_id = cluster_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeContainerStatisticsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class DescribeContainerStatisticsResponseBodyData(TeaModel):
    def __init__(self, remind_alarm_count=None, serious_alarm_count=None, suspicious_alarm_count=None,
                 total_alarm_count=None, total_node=None, has_risk_node=None):
        # The number of alerts whose risk level is **Reminder**.
        self.remind_alarm_count = remind_alarm_count  # type: int
        # The number of alerts whose risk level is **Urgent**.
        self.serious_alarm_count = serious_alarm_count  # type: int
        # The number of alerts whose risk level is **Suspicious**.
        self.suspicious_alarm_count = suspicious_alarm_count  # type: int
        # The total number of alerts that are generated in the current container cluster.
        self.total_alarm_count = total_alarm_count  # type: int
        # The total number of nodes in the current container cluster.
        self.total_node = total_node  # type: int
        # The number of nodes on which alerts are generated in the current container cluster.
        self.has_risk_node = has_risk_node  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeContainerStatisticsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.remind_alarm_count is not None:
            result['RemindAlarmCount'] = self.remind_alarm_count
        if self.serious_alarm_count is not None:
            result['SeriousAlarmCount'] = self.serious_alarm_count
        if self.suspicious_alarm_count is not None:
            result['SuspiciousAlarmCount'] = self.suspicious_alarm_count
        if self.total_alarm_count is not None:
            result['TotalAlarmCount'] = self.total_alarm_count
        if self.total_node is not None:
            result['TotalNode'] = self.total_node
        if self.has_risk_node is not None:
            result['hasRiskNode'] = self.has_risk_node
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RemindAlarmCount') is not None:
            self.remind_alarm_count = m.get('RemindAlarmCount')
        if m.get('SeriousAlarmCount') is not None:
            self.serious_alarm_count = m.get('SeriousAlarmCount')
        if m.get('SuspiciousAlarmCount') is not None:
            self.suspicious_alarm_count = m.get('SuspiciousAlarmCount')
        if m.get('TotalAlarmCount') is not None:
            self.total_alarm_count = m.get('TotalAlarmCount')
        if m.get('TotalNode') is not None:
            self.total_node = m.get('TotalNode')
        if m.get('hasRiskNode') is not None:
            self.has_risk_node = m.get('hasRiskNode')
        return self


class DescribeContainerStatisticsResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        # The alert statistics of container assets.
        self.data = data  # type: DescribeContainerStatisticsResponseBodyData
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DescribeContainerStatisticsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DescribeContainerStatisticsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeContainerStatisticsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeContainerStatisticsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeContainerStatisticsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeContainerStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeContainerTagsRequest(TeaModel):
    def __init__(self, app_name=None, cluster_id=None, current_page=None, field_name=None, field_value=None,
                 namespace=None, page_size=None):
        self.app_name = app_name  # type: str
        self.cluster_id = cluster_id  # type: str
        self.current_page = current_page  # type: int
        self.field_name = field_name  # type: str
        self.field_value = field_value  # type: str
        self.namespace = namespace  # type: str
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeContainerTagsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.field_name is not None:
            result['FieldName'] = self.field_name
        if self.field_value is not None:
            result['FieldValue'] = self.field_value
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('FieldName') is not None:
            self.field_name = m.get('FieldName')
        if m.get('FieldValue') is not None:
            self.field_value = m.get('FieldValue')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeContainerTagsResponseBody(TeaModel):
    def __init__(self, request_id=None, tag_values=None):
        self.request_id = request_id  # type: str
        self.tag_values = tag_values  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeContainerTagsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.tag_values is not None:
            result['TagValues'] = self.tag_values
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TagValues') is not None:
            self.tag_values = m.get('TagValues')
        return self


class DescribeContainerTagsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeContainerTagsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeContainerTagsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeContainerTagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCountNotScannedImageResponseBody(TeaModel):
    def __init__(self, not_scanned_cnt=None, request_id=None):
        self.not_scanned_cnt = not_scanned_cnt  # type: int
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCountNotScannedImageResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.not_scanned_cnt is not None:
            result['NotScannedCnt'] = self.not_scanned_cnt
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NotScannedCnt') is not None:
            self.not_scanned_cnt = m.get('NotScannedCnt')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeCountNotScannedImageResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCountNotScannedImageResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCountNotScannedImageResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCountNotScannedImageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCountScannedImageResponseBody(TeaModel):
    def __init__(self, request_id=None, scanned_count=None):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id  # type: str
        # The number of images that are scanned.
        self.scanned_count = scanned_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCountScannedImageResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.scanned_count is not None:
            result['ScannedCount'] = self.scanned_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ScannedCount') is not None:
            self.scanned_count = m.get('ScannedCount')
        return self


class DescribeCountScannedImageResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCountScannedImageResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCountScannedImageResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCountScannedImageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCriteriaRequest(TeaModel):
    def __init__(self, machine_types=None, support_auto_tag=None, value=None):
        self.machine_types = machine_types  # type: str
        self.support_auto_tag = support_auto_tag  # type: bool
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCriteriaRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.machine_types is not None:
            result['MachineTypes'] = self.machine_types
        if self.support_auto_tag is not None:
            result['SupportAutoTag'] = self.support_auto_tag
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MachineTypes') is not None:
            self.machine_types = m.get('MachineTypes')
        if m.get('SupportAutoTag') is not None:
            self.support_auto_tag = m.get('SupportAutoTag')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeCriteriaResponseBodyCriteriaList(TeaModel):
    def __init__(self, multi_values=None, name=None, type=None, values=None):
        self.multi_values = multi_values  # type: str
        self.name = name  # type: str
        self.type = type  # type: str
        self.values = values  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCriteriaResponseBodyCriteriaList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.multi_values is not None:
            result['MultiValues'] = self.multi_values
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.values is not None:
            result['Values'] = self.values
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MultiValues') is not None:
            self.multi_values = m.get('MultiValues')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Values') is not None:
            self.values = m.get('Values')
        return self


class DescribeCriteriaResponseBody(TeaModel):
    def __init__(self, criteria_list=None, request_id=None):
        self.criteria_list = criteria_list  # type: list[DescribeCriteriaResponseBodyCriteriaList]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.criteria_list:
            for k in self.criteria_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCriteriaResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CriteriaList'] = []
        if self.criteria_list is not None:
            for k in self.criteria_list:
                result['CriteriaList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.criteria_list = []
        if m.get('CriteriaList') is not None:
            for k in m.get('CriteriaList'):
                temp_model = DescribeCriteriaResponseBodyCriteriaList()
                self.criteria_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeCriteriaResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCriteriaResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCriteriaResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCriteriaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCustomBlockRecordsRequest(TeaModel):
    def __init__(self, block_ip=None, current_page=None, page_size=None, resource_owner_id=None, status=None):
        # The IP address that you want to block by using the defense rule.
        self.block_ip = block_ip  # type: str
        # The number of the page to return. Default value: **1**.
        self.current_page = current_page  # type: int
        # The number of entries to return on each page. Default value: **20**.
        self.page_size = page_size  # type: int
        self.resource_owner_id = resource_owner_id  # type: long
        # The status of the defense rule. Valid values:
        # 
        # *   **0**: invalid
        # *   **1**: enabled
        # *   **2**: failed
        self.status = status  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCustomBlockRecordsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.block_ip is not None:
            result['BlockIp'] = self.block_ip
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BlockIp') is not None:
            self.block_ip = m.get('BlockIp')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeCustomBlockRecordsResponseBodyPageInfo(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, total_count=None):
        # The number of entries returned on the current page.
        self.count = count  # type: int
        # The page number of the returned page.
        self.current_page = current_page  # type: int
        # The number of entries returned per page.
        self.page_size = page_size  # type: int
        # The total number of entries returned.
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCustomBlockRecordsResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeCustomBlockRecordsResponseBodyRecordListTargetList(TeaModel):
    def __init__(self, target=None, target_type=None):
        # The ID of the server.
        self.target = target  # type: str
        # The type of the query condition. Valid values:
        # 
        # *   **uuid**: the ID of an asset
        self.target_type = target_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCustomBlockRecordsResponseBodyRecordListTargetList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.target is not None:
            result['Target'] = self.target
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Target') is not None:
            self.target = m.get('Target')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        return self


class DescribeCustomBlockRecordsResponseBodyRecordList(TeaModel):
    def __init__(self, block_expire_date=None, block_ip=None, bound=None, enable_count=None, id=None,
                 server_count=None, source=None, status=None, target_list=None):
        # The timestamp when the defense rule expires.
        self.block_expire_date = block_expire_date  # type: long
        # The blocked IP address.
        self.block_ip = block_ip  # type: str
        # The direction of the traffic that is sent by the blocked IP address. Valid values:
        # 
        # *   **in**: inbound
        # *   **out**: outbound
        self.bound = bound  # type: str
        # The number of servers to which the defense rule is applied.
        self.enable_count = enable_count  # type: int
        # The ID of the defense rule.
        self.id = id  # type: long
        # The total number of servers on which the IP address is blocked.
        self.server_count = server_count  # type: int
        # The source of the defense rule. Valid values:
        self.source = source  # type: str
        # The status of the defense rule. Valid values:
        # 
        # *   **0**: invalid
        # *   **1**: enabled
        # *   **2**: failed
        self.status = status  # type: int
        # An array consisting of the servers to which the defense rule is applied.
        self.target_list = target_list  # type: list[DescribeCustomBlockRecordsResponseBodyRecordListTargetList]

    def validate(self):
        if self.target_list:
            for k in self.target_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCustomBlockRecordsResponseBodyRecordList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.block_expire_date is not None:
            result['BlockExpireDate'] = self.block_expire_date
        if self.block_ip is not None:
            result['BlockIp'] = self.block_ip
        if self.bound is not None:
            result['Bound'] = self.bound
        if self.enable_count is not None:
            result['EnableCount'] = self.enable_count
        if self.id is not None:
            result['Id'] = self.id
        if self.server_count is not None:
            result['ServerCount'] = self.server_count
        if self.source is not None:
            result['Source'] = self.source
        if self.status is not None:
            result['Status'] = self.status
        result['TargetList'] = []
        if self.target_list is not None:
            for k in self.target_list:
                result['TargetList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BlockExpireDate') is not None:
            self.block_expire_date = m.get('BlockExpireDate')
        if m.get('BlockIp') is not None:
            self.block_ip = m.get('BlockIp')
        if m.get('Bound') is not None:
            self.bound = m.get('Bound')
        if m.get('EnableCount') is not None:
            self.enable_count = m.get('EnableCount')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('ServerCount') is not None:
            self.server_count = m.get('ServerCount')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        self.target_list = []
        if m.get('TargetList') is not None:
            for k in m.get('TargetList'):
                temp_model = DescribeCustomBlockRecordsResponseBodyRecordListTargetList()
                self.target_list.append(temp_model.from_map(k))
        return self


class DescribeCustomBlockRecordsResponseBody(TeaModel):
    def __init__(self, page_info=None, record_list=None, request_id=None):
        # The pagination information.
        self.page_info = page_info  # type: DescribeCustomBlockRecordsResponseBodyPageInfo
        # An array that consists of the defense rules.
        self.record_list = record_list  # type: list[DescribeCustomBlockRecordsResponseBodyRecordList]
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.record_list:
            for k in self.record_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCustomBlockRecordsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['RecordList'] = []
        if self.record_list is not None:
            for k in self.record_list:
                result['RecordList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageInfo') is not None:
            temp_model = DescribeCustomBlockRecordsResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.record_list = []
        if m.get('RecordList') is not None:
            for k in m.get('RecordList'):
                temp_model = DescribeCustomBlockRecordsResponseBodyRecordList()
                self.record_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeCustomBlockRecordsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCustomBlockRecordsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCustomBlockRecordsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCustomBlockRecordsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCycleTaskListRequest(TeaModel):
    def __init__(self, current_page=None, page_size=None, task_name=None, task_type=None):
        # The number of the page to return.
        self.current_page = current_page  # type: int
        # The number of entries to return on each page.
        self.page_size = page_size  # type: int
        # The name of the task. Valid values:
        # 
        # *   **VIRUS\_VUL\_SCHEDULE_SCAN**: virus scan task
        # *   **IMAGE_SCAN**: image scan task
        # *   **EMG\_VUL\_SCHEDULE_SCAN**: urgent vulnerability scan task
        self.task_name = task_name  # type: str
        # The type of the task. Valid values:
        # 
        # *   **VIRUS\_VUL\_SCHEDULE_SCAN**: virus scan task
        # *   **IMAGE_SCAN**: image scan task
        # *   **EMG\_VUL\_SCHEDULE_SCAN**: urgent vulnerability scan task
        self.task_type = task_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCycleTaskListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class DescribeCycleTaskListResponseBodyCycleScheduleResponseList(TeaModel):
    def __init__(self, config_id=None, enable=None, first_date_str=None, interval_period=None, last_task_id=None,
                 next_start_time_str=None, param=None, period_unit=None, target_end_time=None, target_start_time=None, task_name=None,
                 task_type=None):
        # The ID of the task configuration.
        self.config_id = config_id  # type: str
        # Indicates whether the task is enabled. Valid values:
        # 
        # *   **1**: yes
        # *   **0**: no
        self.enable = enable  # type: int
        # The first time when the task starts.
        self.first_date_str = first_date_str  # type: long
        # The interval of the task.
        self.interval_period = interval_period  # type: int
        # The ID of the task when the task last runs.
        self.last_task_id = last_task_id  # type: str
        # The next time when the task starts. The value is a UNIX timestamp. Unit: milliseconds.
        self.next_start_time_str = next_start_time_str  # type: long
        # The additional information.
        self.param = param  # type: str
        # The unit of the scan interval. Valid values:
        # 
        # *   **day**: days
        # *   **hour**: hours
        self.period_unit = period_unit  # type: str
        # The period of time before the task ends. Unit: hours.
        self.target_end_time = target_end_time  # type: int
        # The period of time before the task starts for the next time. Unit: hours.
        self.target_start_time = target_start_time  # type: int
        # The name of the task.
        self.task_name = task_name  # type: str
        # The type of the task.
        self.task_type = task_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCycleTaskListResponseBodyCycleScheduleResponseList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_id is not None:
            result['ConfigId'] = self.config_id
        if self.enable is not None:
            result['Enable'] = self.enable
        if self.first_date_str is not None:
            result['FirstDateStr'] = self.first_date_str
        if self.interval_period is not None:
            result['IntervalPeriod'] = self.interval_period
        if self.last_task_id is not None:
            result['LastTaskId'] = self.last_task_id
        if self.next_start_time_str is not None:
            result['NextStartTimeStr'] = self.next_start_time_str
        if self.param is not None:
            result['Param'] = self.param
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.target_end_time is not None:
            result['TargetEndTime'] = self.target_end_time
        if self.target_start_time is not None:
            result['TargetStartTime'] = self.target_start_time
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConfigId') is not None:
            self.config_id = m.get('ConfigId')
        if m.get('Enable') is not None:
            self.enable = m.get('Enable')
        if m.get('FirstDateStr') is not None:
            self.first_date_str = m.get('FirstDateStr')
        if m.get('IntervalPeriod') is not None:
            self.interval_period = m.get('IntervalPeriod')
        if m.get('LastTaskId') is not None:
            self.last_task_id = m.get('LastTaskId')
        if m.get('NextStartTimeStr') is not None:
            self.next_start_time_str = m.get('NextStartTimeStr')
        if m.get('Param') is not None:
            self.param = m.get('Param')
        if m.get('PeriodUnit') is not None:
            self.period_unit = m.get('PeriodUnit')
        if m.get('TargetEndTime') is not None:
            self.target_end_time = m.get('TargetEndTime')
        if m.get('TargetStartTime') is not None:
            self.target_start_time = m.get('TargetStartTime')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class DescribeCycleTaskListResponseBodyPageInfo(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, total_count=None):
        # The number of entries returned on the current page.
        self.count = count  # type: int
        # The page number of the returned page.
        self.current_page = current_page  # type: int
        # The number of entries returned per page.
        self.page_size = page_size  # type: int
        # The total number of entries returned.
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCycleTaskListResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeCycleTaskListResponseBody(TeaModel):
    def __init__(self, cycle_schedule_response_list=None, page_info=None, request_id=None):
        # An array that consists of periodic scan tasks.
        self.cycle_schedule_response_list = cycle_schedule_response_list  # type: list[DescribeCycleTaskListResponseBodyCycleScheduleResponseList]
        # The pagination information.
        self.page_info = page_info  # type: DescribeCycleTaskListResponseBodyPageInfo
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.cycle_schedule_response_list:
            for k in self.cycle_schedule_response_list:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super(DescribeCycleTaskListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CycleScheduleResponseList'] = []
        if self.cycle_schedule_response_list is not None:
            for k in self.cycle_schedule_response_list:
                result['CycleScheduleResponseList'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.cycle_schedule_response_list = []
        if m.get('CycleScheduleResponseList') is not None:
            for k in m.get('CycleScheduleResponseList'):
                temp_model = DescribeCycleTaskListResponseBodyCycleScheduleResponseList()
                self.cycle_schedule_response_list.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeCycleTaskListResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeCycleTaskListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCycleTaskListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCycleTaskListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCycleTaskListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDingTalkRequest(TeaModel):
    def __init__(self, current_page=None, page_size=None, rule_action_name=None):
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.rule_action_name = rule_action_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDingTalkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.rule_action_name is not None:
            result['RuleActionName'] = self.rule_action_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RuleActionName') is not None:
            self.rule_action_name = m.get('RuleActionName')
        return self


class DescribeDingTalkResponseBodyActionList(TeaModel):
    def __init__(self, action_name=None, ali_uid=None, config_list=None, ding_talk_lang=None, gmt_create=None,
                 gmt_modified=None, group_id_list=None, id=None, interval_time=None, status=None, url=None):
        self.action_name = action_name  # type: str
        self.ali_uid = ali_uid  # type: long
        self.config_list = config_list  # type: str
        self.ding_talk_lang = ding_talk_lang  # type: str
        self.gmt_create = gmt_create  # type: long
        self.gmt_modified = gmt_modified  # type: long
        self.group_id_list = group_id_list  # type: str
        self.id = id  # type: int
        self.interval_time = interval_time  # type: int
        self.status = status  # type: int
        self.url = url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDingTalkResponseBodyActionList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action_name is not None:
            result['ActionName'] = self.action_name
        if self.ali_uid is not None:
            result['AliUid'] = self.ali_uid
        if self.config_list is not None:
            result['ConfigList'] = self.config_list
        if self.ding_talk_lang is not None:
            result['DingTalkLang'] = self.ding_talk_lang
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.group_id_list is not None:
            result['GroupIdList'] = self.group_id_list
        if self.id is not None:
            result['Id'] = self.id
        if self.interval_time is not None:
            result['IntervalTime'] = self.interval_time
        if self.status is not None:
            result['Status'] = self.status
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ActionName') is not None:
            self.action_name = m.get('ActionName')
        if m.get('AliUid') is not None:
            self.ali_uid = m.get('AliUid')
        if m.get('ConfigList') is not None:
            self.config_list = m.get('ConfigList')
        if m.get('DingTalkLang') is not None:
            self.ding_talk_lang = m.get('DingTalkLang')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('GroupIdList') is not None:
            self.group_id_list = m.get('GroupIdList')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('IntervalTime') is not None:
            self.interval_time = m.get('IntervalTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class DescribeDingTalkResponseBodyPageInfo(TeaModel):
    def __init__(self, current_page=None, page_size=None, total_count=None):
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDingTalkResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDingTalkResponseBody(TeaModel):
    def __init__(self, action_list=None, page_info=None, request_id=None):
        self.action_list = action_list  # type: list[DescribeDingTalkResponseBodyActionList]
        self.page_info = page_info  # type: DescribeDingTalkResponseBodyPageInfo
        self.request_id = request_id  # type: str

    def validate(self):
        if self.action_list:
            for k in self.action_list:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super(DescribeDingTalkResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ActionList'] = []
        if self.action_list is not None:
            for k in self.action_list:
                result['ActionList'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.action_list = []
        if m.get('ActionList') is not None:
            for k in m.get('ActionList'):
                temp_model = DescribeDingTalkResponseBodyActionList()
                self.action_list.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeDingTalkResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDingTalkResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDingTalkResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDingTalkResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDingTalkResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDomainCountRequest(TeaModel):
    def __init__(self, source_ip=None):
        self.source_ip = source_ip  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDomainCountRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeDomainCountResponseBody(TeaModel):
    def __init__(self, request_id=None, root_domains_count=None, sub_domains_count=None, total_domains_count=None):
        self.request_id = request_id  # type: str
        self.root_domains_count = root_domains_count  # type: int
        self.sub_domains_count = sub_domains_count  # type: int
        self.total_domains_count = total_domains_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDomainCountResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.root_domains_count is not None:
            result['RootDomainsCount'] = self.root_domains_count
        if self.sub_domains_count is not None:
            result['SubDomainsCount'] = self.sub_domains_count
        if self.total_domains_count is not None:
            result['TotalDomainsCount'] = self.total_domains_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RootDomainsCount') is not None:
            self.root_domains_count = m.get('RootDomainsCount')
        if m.get('SubDomainsCount') is not None:
            self.sub_domains_count = m.get('SubDomainsCount')
        if m.get('TotalDomainsCount') is not None:
            self.total_domains_count = m.get('TotalDomainsCount')
        return self


class DescribeDomainCountResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDomainCountResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDomainCountResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDomainCountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDomainDetailRequest(TeaModel):
    def __init__(self, domain_name=None, source_ip=None):
        self.domain_name = domain_name  # type: str
        self.source_ip = source_ip  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDomainDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeDomainDetailResponseBodyDomainDetailItems(TeaModel):
    def __init__(self, asset_type=None, instance_id=None, instance_name=None, internet_ip=None, intranet_ip=None,
                 uuid=None):
        self.asset_type = asset_type  # type: str
        self.instance_id = instance_id  # type: str
        self.instance_name = instance_name  # type: str
        self.internet_ip = internet_ip  # type: str
        self.intranet_ip = intranet_ip  # type: str
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDomainDetailResponseBodyDomainDetailItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asset_type is not None:
            result['AssetType'] = self.asset_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AssetType') is not None:
            self.asset_type = m.get('AssetType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeDomainDetailResponseBody(TeaModel):
    def __init__(self, alarm_count=None, domain=None, domain_detail_items=None, request_id=None, root_domain=None,
                 vul_count=None):
        self.alarm_count = alarm_count  # type: int
        self.domain = domain  # type: str
        self.domain_detail_items = domain_detail_items  # type: list[DescribeDomainDetailResponseBodyDomainDetailItems]
        self.request_id = request_id  # type: str
        self.root_domain = root_domain  # type: str
        self.vul_count = vul_count  # type: int

    def validate(self):
        if self.domain_detail_items:
            for k in self.domain_detail_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDomainDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_count is not None:
            result['AlarmCount'] = self.alarm_count
        if self.domain is not None:
            result['Domain'] = self.domain
        result['DomainDetailItems'] = []
        if self.domain_detail_items is not None:
            for k in self.domain_detail_items:
                result['DomainDetailItems'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.root_domain is not None:
            result['RootDomain'] = self.root_domain
        if self.vul_count is not None:
            result['VulCount'] = self.vul_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlarmCount') is not None:
            self.alarm_count = m.get('AlarmCount')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        self.domain_detail_items = []
        if m.get('DomainDetailItems') is not None:
            for k in m.get('DomainDetailItems'):
                temp_model = DescribeDomainDetailResponseBodyDomainDetailItems()
                self.domain_detail_items.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RootDomain') is not None:
            self.root_domain = m.get('RootDomain')
        if m.get('VulCount') is not None:
            self.vul_count = m.get('VulCount')
        return self


class DescribeDomainDetailResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDomainDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDomainDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDomainDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDomainListRequest(TeaModel):
    def __init__(self, current_page=None, domain_type=None, fuzzy_domain=None, page_size=None, source_ip=None):
        self.current_page = current_page  # type: int
        self.domain_type = domain_type  # type: str
        self.fuzzy_domain = fuzzy_domain  # type: str
        self.page_size = page_size  # type: int
        self.source_ip = source_ip  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDomainListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.domain_type is not None:
            result['DomainType'] = self.domain_type
        if self.fuzzy_domain is not None:
            result['FuzzyDomain'] = self.fuzzy_domain
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DomainType') is not None:
            self.domain_type = m.get('DomainType')
        if m.get('FuzzyDomain') is not None:
            self.fuzzy_domain = m.get('FuzzyDomain')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeDomainListResponseBodyDomainListResponseList(TeaModel):
    def __init__(self, domain=None, ip_list=None):
        self.domain = domain  # type: str
        self.ip_list = ip_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDomainListResponseBodyDomainListResponseList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.ip_list is not None:
            result['IpList'] = self.ip_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('IpList') is not None:
            self.ip_list = m.get('IpList')
        return self


class DescribeDomainListResponseBodyPageInfo(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, total_count=None):
        self.count = count  # type: int
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDomainListResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDomainListResponseBody(TeaModel):
    def __init__(self, domain_list_response_list=None, page_info=None, request_id=None):
        self.domain_list_response_list = domain_list_response_list  # type: list[DescribeDomainListResponseBodyDomainListResponseList]
        self.page_info = page_info  # type: DescribeDomainListResponseBodyPageInfo
        self.request_id = request_id  # type: str

    def validate(self):
        if self.domain_list_response_list:
            for k in self.domain_list_response_list:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super(DescribeDomainListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DomainListResponseList'] = []
        if self.domain_list_response_list is not None:
            for k in self.domain_list_response_list:
                result['DomainListResponseList'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.domain_list_response_list = []
        if m.get('DomainListResponseList') is not None:
            for k in m.get('DomainListResponseList'):
                temp_model = DescribeDomainListResponseBodyDomainListResponseList()
                self.domain_list_response_list.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeDomainListResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDomainListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDomainListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDomainListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDomainListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEmgUserAgreementResponseBody(TeaModel):
    def __init__(self, auth=None, request_id=None):
        self.auth = auth  # type: bool
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeEmgUserAgreementResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth is not None:
            result['Auth'] = self.auth
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Auth') is not None:
            self.auth = m.get('Auth')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeEmgUserAgreementResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeEmgUserAgreementResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeEmgUserAgreementResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeEmgUserAgreementResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEmgVulItemRequest(TeaModel):
    def __init__(self, check_type=None, current_page=None, lang=None, page_size=None, risk_status=None,
                 scan_type=None, vul_name=None):
        self.check_type = check_type  # type: int
        self.current_page = current_page  # type: int
        self.lang = lang  # type: str
        self.page_size = page_size  # type: int
        self.risk_status = risk_status  # type: str
        self.scan_type = scan_type  # type: str
        self.vul_name = vul_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeEmgVulItemRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_type is not None:
            result['CheckType'] = self.check_type
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.risk_status is not None:
            result['RiskStatus'] = self.risk_status
        if self.scan_type is not None:
            result['ScanType'] = self.scan_type
        if self.vul_name is not None:
            result['VulName'] = self.vul_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CheckType') is not None:
            self.check_type = m.get('CheckType')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RiskStatus') is not None:
            self.risk_status = m.get('RiskStatus')
        if m.get('ScanType') is not None:
            self.scan_type = m.get('ScanType')
        if m.get('VulName') is not None:
            self.vul_name = m.get('VulName')
        return self


class DescribeEmgVulItemResponseBodyGroupedVulItems(TeaModel):
    def __init__(self, alias_name=None, check_type=None, gmt_last_check=None, gmt_publish=None, name=None,
                 pending_count=None, progress=None, status=None, type=None):
        self.alias_name = alias_name  # type: str
        self.check_type = check_type  # type: int
        self.gmt_last_check = gmt_last_check  # type: long
        self.gmt_publish = gmt_publish  # type: long
        self.name = name  # type: str
        self.pending_count = pending_count  # type: int
        self.progress = progress  # type: int
        self.status = status  # type: int
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeEmgVulItemResponseBodyGroupedVulItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.check_type is not None:
            result['CheckType'] = self.check_type
        if self.gmt_last_check is not None:
            result['GmtLastCheck'] = self.gmt_last_check
        if self.gmt_publish is not None:
            result['GmtPublish'] = self.gmt_publish
        if self.name is not None:
            result['Name'] = self.name
        if self.pending_count is not None:
            result['PendingCount'] = self.pending_count
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('CheckType') is not None:
            self.check_type = m.get('CheckType')
        if m.get('GmtLastCheck') is not None:
            self.gmt_last_check = m.get('GmtLastCheck')
        if m.get('GmtPublish') is not None:
            self.gmt_publish = m.get('GmtPublish')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PendingCount') is not None:
            self.pending_count = m.get('PendingCount')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeEmgVulItemResponseBody(TeaModel):
    def __init__(self, current_page=None, grouped_vul_items=None, page_size=None, request_id=None, total_count=None):
        self.current_page = current_page  # type: int
        self.grouped_vul_items = grouped_vul_items  # type: list[DescribeEmgVulItemResponseBodyGroupedVulItems]
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        if self.grouped_vul_items:
            for k in self.grouped_vul_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeEmgVulItemResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['GroupedVulItems'] = []
        if self.grouped_vul_items is not None:
            for k in self.grouped_vul_items:
                result['GroupedVulItems'].append(k.to_map() if k else None)
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.grouped_vul_items = []
        if m.get('GroupedVulItems') is not None:
            for k in m.get('GroupedVulItems'):
                temp_model = DescribeEmgVulItemResponseBodyGroupedVulItems()
                self.grouped_vul_items.append(temp_model.from_map(k))
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeEmgVulItemResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeEmgVulItemResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeEmgVulItemResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeEmgVulItemResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEventLevelCountRequest(TeaModel):
    def __init__(self, cluster_id=None, container_field_name=None, container_field_value=None, container_ids=None,
                 from_=None, target_type=None):
        # The ID of the container cluster.
        # 
        # > You can call the [DescribeGroupedContainerInstances](~~DescribeGroupedContainerInstances~~) operation to query the IDs of container clusters.
        self.cluster_id = cluster_id  # type: str
        # The key of the condition that is used to query alert events on containers. Valid values:
        # 
        # *   **instanceId**: the ID of the asset
        # *   **appName**: the name of the application
        # *   **clusterId**: the ID of the cluster
        # *   **regionId**: the ID of the region
        # *   **nodeName**: the name of the node
        # *   **namespace**: the namespace
        # *   **clusterName**: the name of the cluster
        # *   **image**: the name of the image
        # *   **imageRepoName**: the name of the image repository
        # *   **imageRepoNamespace**: the namespace to which the image repository belongs
        # *   **imageRepoTag**: the tag that is added to the image
        # *   **imageDigest**: the digest of the image
        self.container_field_name = container_field_name  # type: str
        # The value of the condition that is used to query alert events on containers. If you specify multiple values, separate them with commas (,).
        self.container_field_value = container_field_value  # type: str
        # The ID of the container.
        self.container_ids = container_ids  # type: str
        # The ID of the request source. Set the value to **sas**.
        self.from_ = from_  # type: str
        # The type of the query condition. Valid values:
        # 
        # *   **containerId**: the ID of the container
        # *   **uuid**: the UUID of the asset
        self.target_type = target_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeEventLevelCountRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.container_field_name is not None:
            result['ContainerFieldName'] = self.container_field_name
        if self.container_field_value is not None:
            result['ContainerFieldValue'] = self.container_field_value
        if self.container_ids is not None:
            result['ContainerIds'] = self.container_ids
        if self.from_ is not None:
            result['From'] = self.from_
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ContainerFieldName') is not None:
            self.container_field_name = m.get('ContainerFieldName')
        if m.get('ContainerFieldValue') is not None:
            self.container_field_value = m.get('ContainerFieldValue')
        if m.get('ContainerIds') is not None:
            self.container_ids = m.get('ContainerIds')
        if m.get('From') is not None:
            self.from_ = m.get('From')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        return self


class DescribeEventLevelCountResponseBodyEventLevels(TeaModel):
    def __init__(self, remind=None, serious=None, suspicious=None):
        # The number of alerts whose Emergency level is Reminder.
        self.remind = remind  # type: int
        # The number of alerts whose Emergency level is Urgent.
        self.serious = serious  # type: int
        # The number of alerts whose Emergency level is Suspicious.
        self.suspicious = suspicious  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeEventLevelCountResponseBodyEventLevels, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.remind is not None:
            result['Remind'] = self.remind
        if self.serious is not None:
            result['Serious'] = self.serious
        if self.suspicious is not None:
            result['Suspicious'] = self.suspicious
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Remind') is not None:
            self.remind = m.get('Remind')
        if m.get('Serious') is not None:
            self.serious = m.get('Serious')
        if m.get('Suspicious') is not None:
            self.suspicious = m.get('Suspicious')
        return self


class DescribeEventLevelCountResponseBody(TeaModel):
    def __init__(self, code=None, event_levels=None, message=None, request_id=None, success=None):
        # The status code returned. The status code **200** indicates that the request was successful. Other status codes indicate that the request failed. You can identify the cause of the failure based on the status code.
        self.code = code  # type: str
        # The statistics of alerts by risk level.
        self.event_levels = event_levels  # type: DescribeEventLevelCountResponseBodyEventLevels
        # The error message returned.
        self.message = message  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**: The request was successful.
        # *   **false**: The request failed.
        self.success = success  # type: bool

    def validate(self):
        if self.event_levels:
            self.event_levels.validate()

    def to_map(self):
        _map = super(DescribeEventLevelCountResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.event_levels is not None:
            result['EventLevels'] = self.event_levels.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('EventLevels') is not None:
            temp_model = DescribeEventLevelCountResponseBodyEventLevels()
            self.event_levels = temp_model.from_map(m['EventLevels'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeEventLevelCountResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeEventLevelCountResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeEventLevelCountResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeEventLevelCountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEventOnStageRequest(TeaModel):
    def __init__(self, lang=None):
        self.lang = lang  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeEventOnStageRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeEventOnStageResponseBodySecurityEventStageResponse(TeaModel):
    def __init__(self, security_event_on_stag=None):
        self.security_event_on_stag = security_event_on_stag  # type: dict[str, any]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeEventOnStageResponseBodySecurityEventStageResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.security_event_on_stag is not None:
            result['SecurityEventOnStag'] = self.security_event_on_stag
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SecurityEventOnStag') is not None:
            self.security_event_on_stag = m.get('SecurityEventOnStag')
        return self


class DescribeEventOnStageResponseBody(TeaModel):
    def __init__(self, request_id=None, security_event_stage_response=None):
        self.request_id = request_id  # type: str
        self.security_event_stage_response = security_event_stage_response  # type: DescribeEventOnStageResponseBodySecurityEventStageResponse

    def validate(self):
        if self.security_event_stage_response:
            self.security_event_stage_response.validate()

    def to_map(self):
        _map = super(DescribeEventOnStageResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.security_event_stage_response is not None:
            result['SecurityEventStageResponse'] = self.security_event_stage_response.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SecurityEventStageResponse') is not None:
            temp_model = DescribeEventOnStageResponseBodySecurityEventStageResponse()
            self.security_event_stage_response = temp_model.from_map(m['SecurityEventStageResponse'])
        return self


class DescribeEventOnStageResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeEventOnStageResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeEventOnStageResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeEventOnStageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeExcludeSystemPathRequest(TeaModel):
    def __init__(self, current_page=None, page_size=None):
        # The number of the page to return. Default value: 1.
        self.current_page = current_page  # type: int
        # The number of entries to return on each page.
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeExcludeSystemPathRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeExcludeSystemPathResponseBodyExcludePaths(TeaModel):
    def __init__(self, os=None, path=None):
        # The operating system of the server. Valid values:
        # 
        # *   **linux**: Linux
        # *   **windows**: Windows
        self.os = os  # type: str
        # The absolute path to the directory.
        self.path = path  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeExcludeSystemPathResponseBodyExcludePaths, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.os is not None:
            result['Os'] = self.os
        if self.path is not None:
            result['Path'] = self.path
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        return self


class DescribeExcludeSystemPathResponseBodyPageInfo(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, total_count=None):
        # The number of entries returned on the current page.
        self.count = count  # type: int
        # The page number of the returned page.
        self.current_page = current_page  # type: int
        # The number of entries returned per page.
        self.page_size = page_size  # type: int
        # The total number of entries returned.
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeExcludeSystemPathResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeExcludeSystemPathResponseBody(TeaModel):
    def __init__(self, exclude_paths=None, page_info=None, request_id=None):
        # An array consisting of the directories that are excluded.
        self.exclude_paths = exclude_paths  # type: list[DescribeExcludeSystemPathResponseBodyExcludePaths]
        # The pagination information.
        self.page_info = page_info  # type: DescribeExcludeSystemPathResponseBodyPageInfo
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.exclude_paths:
            for k in self.exclude_paths:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super(DescribeExcludeSystemPathResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ExcludePaths'] = []
        if self.exclude_paths is not None:
            for k in self.exclude_paths:
                result['ExcludePaths'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.exclude_paths = []
        if m.get('ExcludePaths') is not None:
            for k in m.get('ExcludePaths'):
                temp_model = DescribeExcludeSystemPathResponseBodyExcludePaths()
                self.exclude_paths.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeExcludeSystemPathResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeExcludeSystemPathResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeExcludeSystemPathResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeExcludeSystemPathResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeExcludeSystemPathResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeExportInfoRequest(TeaModel):
    def __init__(self, export_id=None):
        self.export_id = export_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeExportInfoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.export_id is not None:
            result['ExportId'] = self.export_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ExportId') is not None:
            self.export_id = m.get('ExportId')
        return self


class DescribeExportInfoResponseBody(TeaModel):
    def __init__(self, current_count=None, export_status=None, file_name=None, id=None, link=None, message=None,
                 progress=None, request_id=None, total_count=None):
        self.current_count = current_count  # type: int
        self.export_status = export_status  # type: str
        self.file_name = file_name  # type: str
        self.id = id  # type: long
        self.link = link  # type: str
        self.message = message  # type: str
        self.progress = progress  # type: int
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeExportInfoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_count is not None:
            result['CurrentCount'] = self.current_count
        if self.export_status is not None:
            result['ExportStatus'] = self.export_status
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.id is not None:
            result['Id'] = self.id
        if self.link is not None:
            result['Link'] = self.link
        if self.message is not None:
            result['Message'] = self.message
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentCount') is not None:
            self.current_count = m.get('CurrentCount')
        if m.get('ExportStatus') is not None:
            self.export_status = m.get('ExportStatus')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Link') is not None:
            self.link = m.get('Link')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeExportInfoResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeExportInfoResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeExportInfoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeExportInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeExposedCheckWarningRequest(TeaModel):
    def __init__(self, lang=None, type_name=None, uuids=None):
        self.lang = lang  # type: str
        self.type_name = type_name  # type: str
        self.uuids = uuids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeExposedCheckWarningRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.type_name is not None:
            result['TypeName'] = self.type_name
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('TypeName') is not None:
            self.type_name = m.get('TypeName')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        return self


class DescribeExposedCheckWarningResponseBodyWarningList(TeaModel):
    def __init__(self, risk_id=None, risk_name=None, sub_type_alias=None, type_alias=None, uuid=None):
        self.risk_id = risk_id  # type: long
        self.risk_name = risk_name  # type: str
        self.sub_type_alias = sub_type_alias  # type: str
        self.type_alias = type_alias  # type: str
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeExposedCheckWarningResponseBodyWarningList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.risk_id is not None:
            result['RiskId'] = self.risk_id
        if self.risk_name is not None:
            result['RiskName'] = self.risk_name
        if self.sub_type_alias is not None:
            result['SubTypeAlias'] = self.sub_type_alias
        if self.type_alias is not None:
            result['TypeAlias'] = self.type_alias
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RiskId') is not None:
            self.risk_id = m.get('RiskId')
        if m.get('RiskName') is not None:
            self.risk_name = m.get('RiskName')
        if m.get('SubTypeAlias') is not None:
            self.sub_type_alias = m.get('SubTypeAlias')
        if m.get('TypeAlias') is not None:
            self.type_alias = m.get('TypeAlias')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeExposedCheckWarningResponseBody(TeaModel):
    def __init__(self, count=None, request_id=None, warning_list=None):
        self.count = count  # type: int
        self.request_id = request_id  # type: str
        self.warning_list = warning_list  # type: list[DescribeExposedCheckWarningResponseBodyWarningList]

    def validate(self):
        if self.warning_list:
            for k in self.warning_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeExposedCheckWarningResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['WarningList'] = []
        if self.warning_list is not None:
            for k in self.warning_list:
                result['WarningList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.warning_list = []
        if m.get('WarningList') is not None:
            for k in m.get('WarningList'):
                temp_model = DescribeExposedCheckWarningResponseBodyWarningList()
                self.warning_list.append(temp_model.from_map(k))
        return self


class DescribeExposedCheckWarningResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeExposedCheckWarningResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeExposedCheckWarningResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeExposedCheckWarningResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeExposedInstanceCriteriaRequest(TeaModel):
    def __init__(self, value=None):
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeExposedInstanceCriteriaRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeExposedInstanceCriteriaResponseBodyCriteriaList(TeaModel):
    def __init__(self, name=None, type=None, values=None):
        self.name = name  # type: str
        self.type = type  # type: str
        self.values = values  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeExposedInstanceCriteriaResponseBodyCriteriaList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.values is not None:
            result['Values'] = self.values
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Values') is not None:
            self.values = m.get('Values')
        return self


class DescribeExposedInstanceCriteriaResponseBody(TeaModel):
    def __init__(self, criteria_list=None, request_id=None):
        self.criteria_list = criteria_list  # type: list[DescribeExposedInstanceCriteriaResponseBodyCriteriaList]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.criteria_list:
            for k in self.criteria_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeExposedInstanceCriteriaResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CriteriaList'] = []
        if self.criteria_list is not None:
            for k in self.criteria_list:
                result['CriteriaList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.criteria_list = []
        if m.get('CriteriaList') is not None:
            for k in m.get('CriteriaList'):
                temp_model = DescribeExposedInstanceCriteriaResponseBodyCriteriaList()
                self.criteria_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeExposedInstanceCriteriaResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeExposedInstanceCriteriaResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeExposedInstanceCriteriaResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeExposedInstanceCriteriaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeExposedInstanceDetailRequest(TeaModel):
    def __init__(self, uuid=None):
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeExposedInstanceDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeExposedInstanceDetailResponseBodyExposedChainsAllVulList(TeaModel):
    def __init__(self, alias_name=None, name=None, necessity=None, type=None, uuid=None):
        self.alias_name = alias_name  # type: str
        self.name = name  # type: str
        self.necessity = necessity  # type: str
        self.type = type  # type: str
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeExposedInstanceDetailResponseBodyExposedChainsAllVulList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.name is not None:
            result['Name'] = self.name
        if self.necessity is not None:
            result['Necessity'] = self.necessity
        if self.type is not None:
            result['Type'] = self.type
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Necessity') is not None:
            self.necessity = m.get('Necessity')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeExposedInstanceDetailResponseBodyExposedChainsRealVulList(TeaModel):
    def __init__(self, alias_name=None, name=None, necessity=None, type=None, uuid=None):
        self.alias_name = alias_name  # type: str
        self.name = name  # type: str
        self.necessity = necessity  # type: str
        self.type = type  # type: str
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeExposedInstanceDetailResponseBodyExposedChainsRealVulList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.name is not None:
            result['Name'] = self.name
        if self.necessity is not None:
            result['Necessity'] = self.necessity
        if self.type is not None:
            result['Type'] = self.type
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Necessity') is not None:
            self.necessity = m.get('Necessity')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeExposedInstanceDetailResponseBodyExposedChains(TeaModel):
    def __init__(self, all_vul_list=None, exposure_component=None, exposure_ip=None, exposure_port=None,
                 exposure_type=None, exposure_type_id=None, group_no=None, instance_id=None, instance_name=None, internet_ip=None,
                 intranet_ip=None, real_vul_list=None, region_id=None, uuid=None):
        self.all_vul_list = all_vul_list  # type: list[DescribeExposedInstanceDetailResponseBodyExposedChainsAllVulList]
        self.exposure_component = exposure_component  # type: str
        self.exposure_ip = exposure_ip  # type: str
        self.exposure_port = exposure_port  # type: str
        self.exposure_type = exposure_type  # type: str
        self.exposure_type_id = exposure_type_id  # type: str
        self.group_no = group_no  # type: str
        self.instance_id = instance_id  # type: str
        self.instance_name = instance_name  # type: str
        self.internet_ip = internet_ip  # type: str
        self.intranet_ip = intranet_ip  # type: str
        self.real_vul_list = real_vul_list  # type: list[DescribeExposedInstanceDetailResponseBodyExposedChainsRealVulList]
        self.region_id = region_id  # type: str
        self.uuid = uuid  # type: str

    def validate(self):
        if self.all_vul_list:
            for k in self.all_vul_list:
                if k:
                    k.validate()
        if self.real_vul_list:
            for k in self.real_vul_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeExposedInstanceDetailResponseBodyExposedChains, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AllVulList'] = []
        if self.all_vul_list is not None:
            for k in self.all_vul_list:
                result['AllVulList'].append(k.to_map() if k else None)
        if self.exposure_component is not None:
            result['ExposureComponent'] = self.exposure_component
        if self.exposure_ip is not None:
            result['ExposureIp'] = self.exposure_ip
        if self.exposure_port is not None:
            result['ExposurePort'] = self.exposure_port
        if self.exposure_type is not None:
            result['ExposureType'] = self.exposure_type
        if self.exposure_type_id is not None:
            result['ExposureTypeId'] = self.exposure_type_id
        if self.group_no is not None:
            result['GroupNo'] = self.group_no
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        result['RealVulList'] = []
        if self.real_vul_list is not None:
            for k in self.real_vul_list:
                result['RealVulList'].append(k.to_map() if k else None)
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.all_vul_list = []
        if m.get('AllVulList') is not None:
            for k in m.get('AllVulList'):
                temp_model = DescribeExposedInstanceDetailResponseBodyExposedChainsAllVulList()
                self.all_vul_list.append(temp_model.from_map(k))
        if m.get('ExposureComponent') is not None:
            self.exposure_component = m.get('ExposureComponent')
        if m.get('ExposureIp') is not None:
            self.exposure_ip = m.get('ExposureIp')
        if m.get('ExposurePort') is not None:
            self.exposure_port = m.get('ExposurePort')
        if m.get('ExposureType') is not None:
            self.exposure_type = m.get('ExposureType')
        if m.get('ExposureTypeId') is not None:
            self.exposure_type_id = m.get('ExposureTypeId')
        if m.get('GroupNo') is not None:
            self.group_no = m.get('GroupNo')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        self.real_vul_list = []
        if m.get('RealVulList') is not None:
            for k in m.get('RealVulList'):
                temp_model = DescribeExposedInstanceDetailResponseBodyExposedChainsRealVulList()
                self.real_vul_list.append(temp_model.from_map(k))
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeExposedInstanceDetailResponseBody(TeaModel):
    def __init__(self, exposed_chains=None, request_id=None):
        self.exposed_chains = exposed_chains  # type: list[DescribeExposedInstanceDetailResponseBodyExposedChains]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.exposed_chains:
            for k in self.exposed_chains:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeExposedInstanceDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ExposedChains'] = []
        if self.exposed_chains is not None:
            for k in self.exposed_chains:
                result['ExposedChains'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.exposed_chains = []
        if m.get('ExposedChains') is not None:
            for k in m.get('ExposedChains'):
                temp_model = DescribeExposedInstanceDetailResponseBodyExposedChains()
                self.exposed_chains.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeExposedInstanceDetailResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeExposedInstanceDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeExposedInstanceDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeExposedInstanceDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeExposedInstanceListRequest(TeaModel):
    def __init__(self, current_page=None, exposure_component=None, exposure_ip=None, exposure_port=None,
                 group_id=None, health_status=None, instance_id=None, instance_name=None, page_size=None, vul_status=None):
        self.current_page = current_page  # type: int
        self.exposure_component = exposure_component  # type: str
        self.exposure_ip = exposure_ip  # type: str
        self.exposure_port = exposure_port  # type: str
        self.group_id = group_id  # type: long
        self.health_status = health_status  # type: bool
        self.instance_id = instance_id  # type: str
        self.instance_name = instance_name  # type: str
        self.page_size = page_size  # type: int
        self.vul_status = vul_status  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeExposedInstanceListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.exposure_component is not None:
            result['ExposureComponent'] = self.exposure_component
        if self.exposure_ip is not None:
            result['ExposureIp'] = self.exposure_ip
        if self.exposure_port is not None:
            result['ExposurePort'] = self.exposure_port
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.health_status is not None:
            result['HealthStatus'] = self.health_status
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.vul_status is not None:
            result['VulStatus'] = self.vul_status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('ExposureComponent') is not None:
            self.exposure_component = m.get('ExposureComponent')
        if m.get('ExposureIp') is not None:
            self.exposure_ip = m.get('ExposureIp')
        if m.get('ExposurePort') is not None:
            self.exposure_port = m.get('ExposurePort')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('HealthStatus') is not None:
            self.health_status = m.get('HealthStatus')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('VulStatus') is not None:
            self.vul_status = m.get('VulStatus')
        return self


class DescribeExposedInstanceListResponseBodyExposedInstances(TeaModel):
    def __init__(self, asap_vul_count=None, exploit_health_count=None, exposure_component=None, exposure_ip=None,
                 exposure_port=None, exposure_type=None, exposure_type_id=None, group_id=None, group_name=None, instance_id=None,
                 instance_name=None, internet_ip=None, intranet_ip=None, later_vul_count=None, nntf_vul_count=None,
                 region_id=None, total_vul_count=None, uuid=None):
        self.asap_vul_count = asap_vul_count  # type: int
        self.exploit_health_count = exploit_health_count  # type: int
        self.exposure_component = exposure_component  # type: str
        self.exposure_ip = exposure_ip  # type: str
        self.exposure_port = exposure_port  # type: str
        self.exposure_type = exposure_type  # type: str
        self.exposure_type_id = exposure_type_id  # type: str
        self.group_id = group_id  # type: long
        self.group_name = group_name  # type: str
        self.instance_id = instance_id  # type: str
        self.instance_name = instance_name  # type: str
        self.internet_ip = internet_ip  # type: str
        self.intranet_ip = intranet_ip  # type: str
        self.later_vul_count = later_vul_count  # type: int
        self.nntf_vul_count = nntf_vul_count  # type: int
        self.region_id = region_id  # type: str
        self.total_vul_count = total_vul_count  # type: int
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeExposedInstanceListResponseBodyExposedInstances, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asap_vul_count is not None:
            result['AsapVulCount'] = self.asap_vul_count
        if self.exploit_health_count is not None:
            result['ExploitHealthCount'] = self.exploit_health_count
        if self.exposure_component is not None:
            result['ExposureComponent'] = self.exposure_component
        if self.exposure_ip is not None:
            result['ExposureIp'] = self.exposure_ip
        if self.exposure_port is not None:
            result['ExposurePort'] = self.exposure_port
        if self.exposure_type is not None:
            result['ExposureType'] = self.exposure_type
        if self.exposure_type_id is not None:
            result['ExposureTypeId'] = self.exposure_type_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.later_vul_count is not None:
            result['LaterVulCount'] = self.later_vul_count
        if self.nntf_vul_count is not None:
            result['NntfVulCount'] = self.nntf_vul_count
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.total_vul_count is not None:
            result['TotalVulCount'] = self.total_vul_count
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AsapVulCount') is not None:
            self.asap_vul_count = m.get('AsapVulCount')
        if m.get('ExploitHealthCount') is not None:
            self.exploit_health_count = m.get('ExploitHealthCount')
        if m.get('ExposureComponent') is not None:
            self.exposure_component = m.get('ExposureComponent')
        if m.get('ExposureIp') is not None:
            self.exposure_ip = m.get('ExposureIp')
        if m.get('ExposurePort') is not None:
            self.exposure_port = m.get('ExposurePort')
        if m.get('ExposureType') is not None:
            self.exposure_type = m.get('ExposureType')
        if m.get('ExposureTypeId') is not None:
            self.exposure_type_id = m.get('ExposureTypeId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('LaterVulCount') is not None:
            self.later_vul_count = m.get('LaterVulCount')
        if m.get('NntfVulCount') is not None:
            self.nntf_vul_count = m.get('NntfVulCount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TotalVulCount') is not None:
            self.total_vul_count = m.get('TotalVulCount')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeExposedInstanceListResponseBodyPageInfo(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, total_count=None):
        self.count = count  # type: int
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeExposedInstanceListResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeExposedInstanceListResponseBody(TeaModel):
    def __init__(self, exposed_instances=None, page_info=None, request_id=None):
        self.exposed_instances = exposed_instances  # type: list[DescribeExposedInstanceListResponseBodyExposedInstances]
        self.page_info = page_info  # type: DescribeExposedInstanceListResponseBodyPageInfo
        self.request_id = request_id  # type: str

    def validate(self):
        if self.exposed_instances:
            for k in self.exposed_instances:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super(DescribeExposedInstanceListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ExposedInstances'] = []
        if self.exposed_instances is not None:
            for k in self.exposed_instances:
                result['ExposedInstances'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.exposed_instances = []
        if m.get('ExposedInstances') is not None:
            for k in m.get('ExposedInstances'):
                temp_model = DescribeExposedInstanceListResponseBodyExposedInstances()
                self.exposed_instances.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeExposedInstanceListResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeExposedInstanceListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeExposedInstanceListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeExposedInstanceListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeExposedInstanceListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeExposedStatisticsResponseBody(TeaModel):
    def __init__(self, exposed_asap_vul_count=None, exposed_component_count=None, exposed_instance_count=None,
                 exposed_ip_count=None, exposed_later_vul_count=None, exposed_nntf_vul_count=None, exposed_port_count=None,
                 exposed_week_password_machine_count=None, gateway_asset_count=None, request_id=None):
        self.exposed_asap_vul_count = exposed_asap_vul_count  # type: int
        self.exposed_component_count = exposed_component_count  # type: int
        self.exposed_instance_count = exposed_instance_count  # type: int
        self.exposed_ip_count = exposed_ip_count  # type: int
        self.exposed_later_vul_count = exposed_later_vul_count  # type: int
        self.exposed_nntf_vul_count = exposed_nntf_vul_count  # type: int
        self.exposed_port_count = exposed_port_count  # type: int
        self.exposed_week_password_machine_count = exposed_week_password_machine_count  # type: int
        self.gateway_asset_count = gateway_asset_count  # type: int
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeExposedStatisticsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.exposed_asap_vul_count is not None:
            result['ExposedAsapVulCount'] = self.exposed_asap_vul_count
        if self.exposed_component_count is not None:
            result['ExposedComponentCount'] = self.exposed_component_count
        if self.exposed_instance_count is not None:
            result['ExposedInstanceCount'] = self.exposed_instance_count
        if self.exposed_ip_count is not None:
            result['ExposedIpCount'] = self.exposed_ip_count
        if self.exposed_later_vul_count is not None:
            result['ExposedLaterVulCount'] = self.exposed_later_vul_count
        if self.exposed_nntf_vul_count is not None:
            result['ExposedNntfVulCount'] = self.exposed_nntf_vul_count
        if self.exposed_port_count is not None:
            result['ExposedPortCount'] = self.exposed_port_count
        if self.exposed_week_password_machine_count is not None:
            result['ExposedWeekPasswordMachineCount'] = self.exposed_week_password_machine_count
        if self.gateway_asset_count is not None:
            result['GatewayAssetCount'] = self.gateway_asset_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ExposedAsapVulCount') is not None:
            self.exposed_asap_vul_count = m.get('ExposedAsapVulCount')
        if m.get('ExposedComponentCount') is not None:
            self.exposed_component_count = m.get('ExposedComponentCount')
        if m.get('ExposedInstanceCount') is not None:
            self.exposed_instance_count = m.get('ExposedInstanceCount')
        if m.get('ExposedIpCount') is not None:
            self.exposed_ip_count = m.get('ExposedIpCount')
        if m.get('ExposedLaterVulCount') is not None:
            self.exposed_later_vul_count = m.get('ExposedLaterVulCount')
        if m.get('ExposedNntfVulCount') is not None:
            self.exposed_nntf_vul_count = m.get('ExposedNntfVulCount')
        if m.get('ExposedPortCount') is not None:
            self.exposed_port_count = m.get('ExposedPortCount')
        if m.get('ExposedWeekPasswordMachineCount') is not None:
            self.exposed_week_password_machine_count = m.get('ExposedWeekPasswordMachineCount')
        if m.get('GatewayAssetCount') is not None:
            self.gateway_asset_count = m.get('GatewayAssetCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeExposedStatisticsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeExposedStatisticsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeExposedStatisticsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeExposedStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeExposedStatisticsDetailRequest(TeaModel):
    def __init__(self, current_page=None, page_size=None, statistics_type=None, statistics_type_gateway_type=None,
                 statistics_type_instance_value=None):
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.statistics_type = statistics_type  # type: str
        self.statistics_type_gateway_type = statistics_type_gateway_type  # type: str
        self.statistics_type_instance_value = statistics_type_instance_value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeExposedStatisticsDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.statistics_type is not None:
            result['StatisticsType'] = self.statistics_type
        if self.statistics_type_gateway_type is not None:
            result['StatisticsTypeGatewayType'] = self.statistics_type_gateway_type
        if self.statistics_type_instance_value is not None:
            result['StatisticsTypeInstanceValue'] = self.statistics_type_instance_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StatisticsType') is not None:
            self.statistics_type = m.get('StatisticsType')
        if m.get('StatisticsTypeGatewayType') is not None:
            self.statistics_type_gateway_type = m.get('StatisticsTypeGatewayType')
        if m.get('StatisticsTypeInstanceValue') is not None:
            self.statistics_type_instance_value = m.get('StatisticsTypeInstanceValue')
        return self


class DescribeExposedStatisticsDetailResponseBodyPageInfo(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, total_count=None):
        self.count = count  # type: int
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeExposedStatisticsDetailResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeExposedStatisticsDetailResponseBodyStatisticsDetails(TeaModel):
    def __init__(self, exposed_count=None, exposure_component=None, exposure_ip=None, exposure_port=None,
                 exposure_type=None, exposure_type_id=None, exposure_type_instance_name=None, region_id=None):
        self.exposed_count = exposed_count  # type: int
        self.exposure_component = exposure_component  # type: str
        self.exposure_ip = exposure_ip  # type: str
        self.exposure_port = exposure_port  # type: str
        self.exposure_type = exposure_type  # type: str
        self.exposure_type_id = exposure_type_id  # type: str
        self.exposure_type_instance_name = exposure_type_instance_name  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeExposedStatisticsDetailResponseBodyStatisticsDetails, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.exposed_count is not None:
            result['ExposedCount'] = self.exposed_count
        if self.exposure_component is not None:
            result['ExposureComponent'] = self.exposure_component
        if self.exposure_ip is not None:
            result['ExposureIp'] = self.exposure_ip
        if self.exposure_port is not None:
            result['ExposurePort'] = self.exposure_port
        if self.exposure_type is not None:
            result['ExposureType'] = self.exposure_type
        if self.exposure_type_id is not None:
            result['ExposureTypeId'] = self.exposure_type_id
        if self.exposure_type_instance_name is not None:
            result['ExposureTypeInstanceName'] = self.exposure_type_instance_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ExposedCount') is not None:
            self.exposed_count = m.get('ExposedCount')
        if m.get('ExposureComponent') is not None:
            self.exposure_component = m.get('ExposureComponent')
        if m.get('ExposureIp') is not None:
            self.exposure_ip = m.get('ExposureIp')
        if m.get('ExposurePort') is not None:
            self.exposure_port = m.get('ExposurePort')
        if m.get('ExposureType') is not None:
            self.exposure_type = m.get('ExposureType')
        if m.get('ExposureTypeId') is not None:
            self.exposure_type_id = m.get('ExposureTypeId')
        if m.get('ExposureTypeInstanceName') is not None:
            self.exposure_type_instance_name = m.get('ExposureTypeInstanceName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeExposedStatisticsDetailResponseBody(TeaModel):
    def __init__(self, page_info=None, request_id=None, statistics_details=None):
        self.page_info = page_info  # type: DescribeExposedStatisticsDetailResponseBodyPageInfo
        self.request_id = request_id  # type: str
        self.statistics_details = statistics_details  # type: list[DescribeExposedStatisticsDetailResponseBodyStatisticsDetails]

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.statistics_details:
            for k in self.statistics_details:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeExposedStatisticsDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['StatisticsDetails'] = []
        if self.statistics_details is not None:
            for k in self.statistics_details:
                result['StatisticsDetails'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageInfo') is not None:
            temp_model = DescribeExposedStatisticsDetailResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.statistics_details = []
        if m.get('StatisticsDetails') is not None:
            for k in m.get('StatisticsDetails'):
                temp_model = DescribeExposedStatisticsDetailResponseBodyStatisticsDetails()
                self.statistics_details.append(temp_model.from_map(k))
        return self


class DescribeExposedStatisticsDetailResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeExposedStatisticsDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeExposedStatisticsDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeExposedStatisticsDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFieldStatisticsRequest(TeaModel):
    def __init__(self, machine_types=None, region_id=None):
        self.machine_types = machine_types  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeFieldStatisticsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.machine_types is not None:
            result['MachineTypes'] = self.machine_types
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MachineTypes') is not None:
            self.machine_types = m.get('MachineTypes')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeFieldStatisticsResponseBodyGroupedFields(TeaModel):
    def __init__(self, ali_yun_instance_count=None, aws_instance_count=None, exposed_instance_count=None,
                 general_asset_count=None, group_count=None, huawei_instance_count=None, idc_instance_count=None,
                 important_asset_count=None, instance_count=None, instance_sync_task_count=None, new_instance_count=None,
                 no_risk_instance_count=None, not_running_status_count=None, offline_instance_count=None,
                 out_machine_instance_count=None, pause_instance_count=None, region_count=None, risk_instance_count=None,
                 tencent_instance_count=None, test_asset_count=None, tripartite_instance_count=None, un_know_status_instance_count=None,
                 unprotected_instance_count=None, vpc_count=None):
        self.ali_yun_instance_count = ali_yun_instance_count  # type: int
        self.aws_instance_count = aws_instance_count  # type: int
        self.exposed_instance_count = exposed_instance_count  # type: int
        self.general_asset_count = general_asset_count  # type: int
        self.group_count = group_count  # type: int
        self.huawei_instance_count = huawei_instance_count  # type: int
        self.idc_instance_count = idc_instance_count  # type: int
        self.important_asset_count = important_asset_count  # type: int
        self.instance_count = instance_count  # type: int
        self.instance_sync_task_count = instance_sync_task_count  # type: int
        self.new_instance_count = new_instance_count  # type: int
        self.no_risk_instance_count = no_risk_instance_count  # type: int
        self.not_running_status_count = not_running_status_count  # type: int
        self.offline_instance_count = offline_instance_count  # type: int
        self.out_machine_instance_count = out_machine_instance_count  # type: int
        self.pause_instance_count = pause_instance_count  # type: int
        self.region_count = region_count  # type: int
        self.risk_instance_count = risk_instance_count  # type: int
        self.tencent_instance_count = tencent_instance_count  # type: int
        self.test_asset_count = test_asset_count  # type: int
        self.tripartite_instance_count = tripartite_instance_count  # type: int
        self.un_know_status_instance_count = un_know_status_instance_count  # type: int
        self.unprotected_instance_count = unprotected_instance_count  # type: int
        self.vpc_count = vpc_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeFieldStatisticsResponseBodyGroupedFields, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ali_yun_instance_count is not None:
            result['AliYunInstanceCount'] = self.ali_yun_instance_count
        if self.aws_instance_count is not None:
            result['AwsInstanceCount'] = self.aws_instance_count
        if self.exposed_instance_count is not None:
            result['ExposedInstanceCount'] = self.exposed_instance_count
        if self.general_asset_count is not None:
            result['GeneralAssetCount'] = self.general_asset_count
        if self.group_count is not None:
            result['GroupCount'] = self.group_count
        if self.huawei_instance_count is not None:
            result['HuaweiInstanceCount'] = self.huawei_instance_count
        if self.idc_instance_count is not None:
            result['IdcInstanceCount'] = self.idc_instance_count
        if self.important_asset_count is not None:
            result['ImportantAssetCount'] = self.important_asset_count
        if self.instance_count is not None:
            result['InstanceCount'] = self.instance_count
        if self.instance_sync_task_count is not None:
            result['InstanceSyncTaskCount'] = self.instance_sync_task_count
        if self.new_instance_count is not None:
            result['NewInstanceCount'] = self.new_instance_count
        if self.no_risk_instance_count is not None:
            result['NoRiskInstanceCount'] = self.no_risk_instance_count
        if self.not_running_status_count is not None:
            result['NotRunningStatusCount'] = self.not_running_status_count
        if self.offline_instance_count is not None:
            result['OfflineInstanceCount'] = self.offline_instance_count
        if self.out_machine_instance_count is not None:
            result['OutMachineInstanceCount'] = self.out_machine_instance_count
        if self.pause_instance_count is not None:
            result['PauseInstanceCount'] = self.pause_instance_count
        if self.region_count is not None:
            result['RegionCount'] = self.region_count
        if self.risk_instance_count is not None:
            result['RiskInstanceCount'] = self.risk_instance_count
        if self.tencent_instance_count is not None:
            result['TencentInstanceCount'] = self.tencent_instance_count
        if self.test_asset_count is not None:
            result['TestAssetCount'] = self.test_asset_count
        if self.tripartite_instance_count is not None:
            result['TripartiteInstanceCount'] = self.tripartite_instance_count
        if self.un_know_status_instance_count is not None:
            result['UnKnowStatusInstanceCount'] = self.un_know_status_instance_count
        if self.unprotected_instance_count is not None:
            result['UnprotectedInstanceCount'] = self.unprotected_instance_count
        if self.vpc_count is not None:
            result['VpcCount'] = self.vpc_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AliYunInstanceCount') is not None:
            self.ali_yun_instance_count = m.get('AliYunInstanceCount')
        if m.get('AwsInstanceCount') is not None:
            self.aws_instance_count = m.get('AwsInstanceCount')
        if m.get('ExposedInstanceCount') is not None:
            self.exposed_instance_count = m.get('ExposedInstanceCount')
        if m.get('GeneralAssetCount') is not None:
            self.general_asset_count = m.get('GeneralAssetCount')
        if m.get('GroupCount') is not None:
            self.group_count = m.get('GroupCount')
        if m.get('HuaweiInstanceCount') is not None:
            self.huawei_instance_count = m.get('HuaweiInstanceCount')
        if m.get('IdcInstanceCount') is not None:
            self.idc_instance_count = m.get('IdcInstanceCount')
        if m.get('ImportantAssetCount') is not None:
            self.important_asset_count = m.get('ImportantAssetCount')
        if m.get('InstanceCount') is not None:
            self.instance_count = m.get('InstanceCount')
        if m.get('InstanceSyncTaskCount') is not None:
            self.instance_sync_task_count = m.get('InstanceSyncTaskCount')
        if m.get('NewInstanceCount') is not None:
            self.new_instance_count = m.get('NewInstanceCount')
        if m.get('NoRiskInstanceCount') is not None:
            self.no_risk_instance_count = m.get('NoRiskInstanceCount')
        if m.get('NotRunningStatusCount') is not None:
            self.not_running_status_count = m.get('NotRunningStatusCount')
        if m.get('OfflineInstanceCount') is not None:
            self.offline_instance_count = m.get('OfflineInstanceCount')
        if m.get('OutMachineInstanceCount') is not None:
            self.out_machine_instance_count = m.get('OutMachineInstanceCount')
        if m.get('PauseInstanceCount') is not None:
            self.pause_instance_count = m.get('PauseInstanceCount')
        if m.get('RegionCount') is not None:
            self.region_count = m.get('RegionCount')
        if m.get('RiskInstanceCount') is not None:
            self.risk_instance_count = m.get('RiskInstanceCount')
        if m.get('TencentInstanceCount') is not None:
            self.tencent_instance_count = m.get('TencentInstanceCount')
        if m.get('TestAssetCount') is not None:
            self.test_asset_count = m.get('TestAssetCount')
        if m.get('TripartiteInstanceCount') is not None:
            self.tripartite_instance_count = m.get('TripartiteInstanceCount')
        if m.get('UnKnowStatusInstanceCount') is not None:
            self.un_know_status_instance_count = m.get('UnKnowStatusInstanceCount')
        if m.get('UnprotectedInstanceCount') is not None:
            self.unprotected_instance_count = m.get('UnprotectedInstanceCount')
        if m.get('VpcCount') is not None:
            self.vpc_count = m.get('VpcCount')
        return self


class DescribeFieldStatisticsResponseBody(TeaModel):
    def __init__(self, grouped_fields=None, request_id=None):
        self.grouped_fields = grouped_fields  # type: DescribeFieldStatisticsResponseBodyGroupedFields
        self.request_id = request_id  # type: str

    def validate(self):
        if self.grouped_fields:
            self.grouped_fields.validate()

    def to_map(self):
        _map = super(DescribeFieldStatisticsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.grouped_fields is not None:
            result['GroupedFields'] = self.grouped_fields.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupedFields') is not None:
            temp_model = DescribeFieldStatisticsResponseBodyGroupedFields()
            self.grouped_fields = temp_model.from_map(m['GroupedFields'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeFieldStatisticsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeFieldStatisticsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeFieldStatisticsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeFieldStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFrontVulPatchListRequest(TeaModel):
    def __init__(self, info=None, lang=None, operate_type=None, type=None):
        self.info = info  # type: str
        self.lang = lang  # type: str
        self.operate_type = operate_type  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeFrontVulPatchListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.info is not None:
            result['Info'] = self.info
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.operate_type is not None:
            result['OperateType'] = self.operate_type
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Info') is not None:
            self.info = m.get('Info')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('OperateType') is not None:
            self.operate_type = m.get('OperateType')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeFrontVulPatchListResponseBodyFrontPatchListPatchList(TeaModel):
    def __init__(self, alias_name=None, name=None):
        self.alias_name = alias_name  # type: str
        self.name = name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeFrontVulPatchListResponseBodyFrontPatchListPatchList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribeFrontVulPatchListResponseBodyFrontPatchList(TeaModel):
    def __init__(self, patch_list=None, uuid=None):
        self.patch_list = patch_list  # type: list[DescribeFrontVulPatchListResponseBodyFrontPatchListPatchList]
        self.uuid = uuid  # type: str

    def validate(self):
        if self.patch_list:
            for k in self.patch_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeFrontVulPatchListResponseBodyFrontPatchList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PatchList'] = []
        if self.patch_list is not None:
            for k in self.patch_list:
                result['PatchList'].append(k.to_map() if k else None)
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.patch_list = []
        if m.get('PatchList') is not None:
            for k in m.get('PatchList'):
                temp_model = DescribeFrontVulPatchListResponseBodyFrontPatchListPatchList()
                self.patch_list.append(temp_model.from_map(k))
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeFrontVulPatchListResponseBody(TeaModel):
    def __init__(self, front_patch_list=None, request_id=None):
        self.front_patch_list = front_patch_list  # type: list[DescribeFrontVulPatchListResponseBodyFrontPatchList]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.front_patch_list:
            for k in self.front_patch_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeFrontVulPatchListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FrontPatchList'] = []
        if self.front_patch_list is not None:
            for k in self.front_patch_list:
                result['FrontPatchList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.front_patch_list = []
        if m.get('FrontPatchList') is not None:
            for k in m.get('FrontPatchList'):
                temp_model = DescribeFrontVulPatchListResponseBodyFrontPatchList()
                self.front_patch_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeFrontVulPatchListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeFrontVulPatchListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeFrontVulPatchListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeFrontVulPatchListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGroupStructRequest(TeaModel):
    def __init__(self, lang=None):
        self.lang = lang  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeGroupStructRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeGroupStructResponseBody(TeaModel):
    def __init__(self, group_father=None, group_flag=None, group_id=None, group_index=None, group_level=None,
                 group_name=None, groups=None, machine_num=None, request_id=None):
        self.group_father = group_father  # type: int
        self.group_flag = group_flag  # type: int
        self.group_id = group_id  # type: long
        self.group_index = group_index  # type: int
        self.group_level = group_level  # type: int
        self.group_name = group_name  # type: str
        self.groups = groups  # type: list[str]
        self.machine_num = machine_num  # type: int
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeGroupStructResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_father is not None:
            result['GroupFather'] = self.group_father
        if self.group_flag is not None:
            result['GroupFlag'] = self.group_flag
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_index is not None:
            result['GroupIndex'] = self.group_index
        if self.group_level is not None:
            result['GroupLevel'] = self.group_level
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.groups is not None:
            result['Groups'] = self.groups
        if self.machine_num is not None:
            result['MachineNum'] = self.machine_num
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupFather') is not None:
            self.group_father = m.get('GroupFather')
        if m.get('GroupFlag') is not None:
            self.group_flag = m.get('GroupFlag')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupIndex') is not None:
            self.group_index = m.get('GroupIndex')
        if m.get('GroupLevel') is not None:
            self.group_level = m.get('GroupLevel')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('Groups') is not None:
            self.groups = m.get('Groups')
        if m.get('MachineNum') is not None:
            self.machine_num = m.get('MachineNum')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeGroupStructResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeGroupStructResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeGroupStructResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeGroupStructResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGroupedContainerInstancesRequest(TeaModel):
    def __init__(self, criteria=None, current_page=None, field_value=None, group_field=None, logical_exp=None,
                 page_size=None):
        self.criteria = criteria  # type: str
        self.current_page = current_page  # type: int
        self.field_value = field_value  # type: str
        self.group_field = group_field  # type: str
        self.logical_exp = logical_exp  # type: str
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeGroupedContainerInstancesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.criteria is not None:
            result['Criteria'] = self.criteria
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.field_value is not None:
            result['FieldValue'] = self.field_value
        if self.group_field is not None:
            result['GroupField'] = self.group_field
        if self.logical_exp is not None:
            result['LogicalExp'] = self.logical_exp
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Criteria') is not None:
            self.criteria = m.get('Criteria')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('FieldValue') is not None:
            self.field_value = m.get('FieldValue')
        if m.get('GroupField') is not None:
            self.group_field = m.get('GroupField')
        if m.get('LogicalExp') is not None:
            self.logical_exp = m.get('LogicalExp')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeGroupedContainerInstancesResponseBodyGroupedContainerInstanceList(TeaModel):
    def __init__(self, alarm_count=None, app_name=None, cluster_id=None, cluster_name=None, cluster_type=None,
                 create_time=None, custer_state=None, hc_count=None, host_ip=None, image=None, image_digest=None,
                 image_repo_name=None, image_repo_namespace=None, image_repo_tag=None, image_uuid=None, instance_count=None,
                 instance_id=None, namespace=None, pod=None, pod_ip=None, region_id=None, risk_instance_count=None,
                 risk_level=None, risk_status=None, vul_count=None):
        self.alarm_count = alarm_count  # type: int
        self.app_name = app_name  # type: str
        self.cluster_id = cluster_id  # type: str
        self.cluster_name = cluster_name  # type: str
        self.cluster_type = cluster_type  # type: str
        self.create_time = create_time  # type: long
        self.custer_state = custer_state  # type: str
        self.hc_count = hc_count  # type: int
        self.host_ip = host_ip  # type: str
        self.image = image  # type: str
        self.image_digest = image_digest  # type: str
        self.image_repo_name = image_repo_name  # type: str
        self.image_repo_namespace = image_repo_namespace  # type: str
        self.image_repo_tag = image_repo_tag  # type: str
        self.image_uuid = image_uuid  # type: str
        self.instance_count = instance_count  # type: int
        self.instance_id = instance_id  # type: str
        self.namespace = namespace  # type: str
        self.pod = pod  # type: str
        self.pod_ip = pod_ip  # type: str
        self.region_id = region_id  # type: str
        self.risk_instance_count = risk_instance_count  # type: int
        self.risk_level = risk_level  # type: str
        self.risk_status = risk_status  # type: str
        self.vul_count = vul_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeGroupedContainerInstancesResponseBodyGroupedContainerInstanceList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_count is not None:
            result['AlarmCount'] = self.alarm_count
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.cluster_type is not None:
            result['ClusterType'] = self.cluster_type
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.custer_state is not None:
            result['CusterState'] = self.custer_state
        if self.hc_count is not None:
            result['HcCount'] = self.hc_count
        if self.host_ip is not None:
            result['HostIp'] = self.host_ip
        if self.image is not None:
            result['Image'] = self.image
        if self.image_digest is not None:
            result['ImageDigest'] = self.image_digest
        if self.image_repo_name is not None:
            result['ImageRepoName'] = self.image_repo_name
        if self.image_repo_namespace is not None:
            result['ImageRepoNamespace'] = self.image_repo_namespace
        if self.image_repo_tag is not None:
            result['ImageRepoTag'] = self.image_repo_tag
        if self.image_uuid is not None:
            result['ImageUuid'] = self.image_uuid
        if self.instance_count is not None:
            result['InstanceCount'] = self.instance_count
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.pod is not None:
            result['Pod'] = self.pod
        if self.pod_ip is not None:
            result['PodIp'] = self.pod_ip
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.risk_instance_count is not None:
            result['RiskInstanceCount'] = self.risk_instance_count
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        if self.risk_status is not None:
            result['RiskStatus'] = self.risk_status
        if self.vul_count is not None:
            result['VulCount'] = self.vul_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlarmCount') is not None:
            self.alarm_count = m.get('AlarmCount')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('ClusterType') is not None:
            self.cluster_type = m.get('ClusterType')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CusterState') is not None:
            self.custer_state = m.get('CusterState')
        if m.get('HcCount') is not None:
            self.hc_count = m.get('HcCount')
        if m.get('HostIp') is not None:
            self.host_ip = m.get('HostIp')
        if m.get('Image') is not None:
            self.image = m.get('Image')
        if m.get('ImageDigest') is not None:
            self.image_digest = m.get('ImageDigest')
        if m.get('ImageRepoName') is not None:
            self.image_repo_name = m.get('ImageRepoName')
        if m.get('ImageRepoNamespace') is not None:
            self.image_repo_namespace = m.get('ImageRepoNamespace')
        if m.get('ImageRepoTag') is not None:
            self.image_repo_tag = m.get('ImageRepoTag')
        if m.get('ImageUuid') is not None:
            self.image_uuid = m.get('ImageUuid')
        if m.get('InstanceCount') is not None:
            self.instance_count = m.get('InstanceCount')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Pod') is not None:
            self.pod = m.get('Pod')
        if m.get('PodIp') is not None:
            self.pod_ip = m.get('PodIp')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RiskInstanceCount') is not None:
            self.risk_instance_count = m.get('RiskInstanceCount')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        if m.get('RiskStatus') is not None:
            self.risk_status = m.get('RiskStatus')
        if m.get('VulCount') is not None:
            self.vul_count = m.get('VulCount')
        return self


class DescribeGroupedContainerInstancesResponseBodyPageInfo(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, total_count=None):
        self.count = count  # type: int
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeGroupedContainerInstancesResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeGroupedContainerInstancesResponseBody(TeaModel):
    def __init__(self, grouped_container_instance_list=None, page_info=None, request_id=None):
        self.grouped_container_instance_list = grouped_container_instance_list  # type: list[DescribeGroupedContainerInstancesResponseBodyGroupedContainerInstanceList]
        self.page_info = page_info  # type: DescribeGroupedContainerInstancesResponseBodyPageInfo
        self.request_id = request_id  # type: str

    def validate(self):
        if self.grouped_container_instance_list:
            for k in self.grouped_container_instance_list:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super(DescribeGroupedContainerInstancesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['GroupedContainerInstanceList'] = []
        if self.grouped_container_instance_list is not None:
            for k in self.grouped_container_instance_list:
                result['GroupedContainerInstanceList'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.grouped_container_instance_list = []
        if m.get('GroupedContainerInstanceList') is not None:
            for k in m.get('GroupedContainerInstanceList'):
                temp_model = DescribeGroupedContainerInstancesResponseBodyGroupedContainerInstanceList()
                self.grouped_container_instance_list.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeGroupedContainerInstancesResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeGroupedContainerInstancesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeGroupedContainerInstancesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeGroupedContainerInstancesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeGroupedContainerInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGroupedInstancesRequest(TeaModel):
    def __init__(self, current_page=None, field_value=None, group_field=None, lang=None, machine_types=None,
                 no_page=None, page_size=None, vendor=None, vendors=None):
        self.current_page = current_page  # type: int
        self.field_value = field_value  # type: str
        self.group_field = group_field  # type: str
        self.lang = lang  # type: str
        self.machine_types = machine_types  # type: str
        self.no_page = no_page  # type: bool
        self.page_size = page_size  # type: int
        self.vendor = vendor  # type: int
        self.vendors = vendors  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeGroupedInstancesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.field_value is not None:
            result['FieldValue'] = self.field_value
        if self.group_field is not None:
            result['GroupField'] = self.group_field
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.machine_types is not None:
            result['MachineTypes'] = self.machine_types
        if self.no_page is not None:
            result['NoPage'] = self.no_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        if self.vendors is not None:
            result['Vendors'] = self.vendors
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('FieldValue') is not None:
            self.field_value = m.get('FieldValue')
        if m.get('GroupField') is not None:
            self.group_field = m.get('GroupField')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('MachineTypes') is not None:
            self.machine_types = m.get('MachineTypes')
        if m.get('NoPage') is not None:
            self.no_page = m.get('NoPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        if m.get('Vendors') is not None:
            self.vendors = m.get('Vendors')
        return self


class DescribeGroupedInstancesResponseBodyInstances(TeaModel):
    def __init__(self, asap_vul_instance_count=None, field_alias_name=None, group_flag=None, instance_count=None,
                 risk_instance_count=None, un_protected_instance_count=None):
        self.asap_vul_instance_count = asap_vul_instance_count  # type: long
        self.field_alias_name = field_alias_name  # type: str
        self.group_flag = group_flag  # type: int
        self.instance_count = instance_count  # type: str
        self.risk_instance_count = risk_instance_count  # type: str
        self.un_protected_instance_count = un_protected_instance_count  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeGroupedInstancesResponseBodyInstances, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asap_vul_instance_count is not None:
            result['AsapVulInstanceCount'] = self.asap_vul_instance_count
        if self.field_alias_name is not None:
            result['FieldAliasName'] = self.field_alias_name
        if self.group_flag is not None:
            result['GroupFlag'] = self.group_flag
        if self.instance_count is not None:
            result['InstanceCount'] = self.instance_count
        if self.risk_instance_count is not None:
            result['RiskInstanceCount'] = self.risk_instance_count
        if self.un_protected_instance_count is not None:
            result['UnProtectedInstanceCount'] = self.un_protected_instance_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AsapVulInstanceCount') is not None:
            self.asap_vul_instance_count = m.get('AsapVulInstanceCount')
        if m.get('FieldAliasName') is not None:
            self.field_alias_name = m.get('FieldAliasName')
        if m.get('GroupFlag') is not None:
            self.group_flag = m.get('GroupFlag')
        if m.get('InstanceCount') is not None:
            self.instance_count = m.get('InstanceCount')
        if m.get('RiskInstanceCount') is not None:
            self.risk_instance_count = m.get('RiskInstanceCount')
        if m.get('UnProtectedInstanceCount') is not None:
            self.un_protected_instance_count = m.get('UnProtectedInstanceCount')
        return self


class DescribeGroupedInstancesResponseBodyPageInfo(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, total_count=None):
        self.count = count  # type: int
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeGroupedInstancesResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeGroupedInstancesResponseBody(TeaModel):
    def __init__(self, instances=None, page_info=None, request_id=None):
        self.instances = instances  # type: list[DescribeGroupedInstancesResponseBodyInstances]
        self.page_info = page_info  # type: DescribeGroupedInstancesResponseBodyPageInfo
        self.request_id = request_id  # type: str

    def validate(self):
        if self.instances:
            for k in self.instances:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super(DescribeGroupedInstancesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Instances'] = []
        if self.instances is not None:
            for k in self.instances:
                result['Instances'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.instances = []
        if m.get('Instances') is not None:
            for k in m.get('Instances'):
                temp_model = DescribeGroupedInstancesResponseBodyInstances()
                self.instances.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeGroupedInstancesResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeGroupedInstancesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeGroupedInstancesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeGroupedInstancesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeGroupedInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGroupedMaliciousFilesRequest(TeaModel):
    def __init__(self, cluster_id=None, current_page=None, fuzzy_malicious_name=None, image_digest=None,
                 image_layer=None, image_tag=None, lang=None, levels=None, malicious_md_5=None, page_size=None, repo_id=None,
                 repo_instance_id=None, repo_name=None, repo_namespace=None, repo_region_id=None, scan_range=None):
        self.cluster_id = cluster_id  # type: str
        self.current_page = current_page  # type: int
        self.fuzzy_malicious_name = fuzzy_malicious_name  # type: str
        self.image_digest = image_digest  # type: str
        self.image_layer = image_layer  # type: str
        self.image_tag = image_tag  # type: str
        self.lang = lang  # type: str
        self.levels = levels  # type: str
        self.malicious_md_5 = malicious_md_5  # type: str
        self.page_size = page_size  # type: str
        self.repo_id = repo_id  # type: str
        self.repo_instance_id = repo_instance_id  # type: str
        self.repo_name = repo_name  # type: str
        self.repo_namespace = repo_namespace  # type: str
        self.repo_region_id = repo_region_id  # type: str
        self.scan_range = scan_range  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeGroupedMaliciousFilesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.fuzzy_malicious_name is not None:
            result['FuzzyMaliciousName'] = self.fuzzy_malicious_name
        if self.image_digest is not None:
            result['ImageDigest'] = self.image_digest
        if self.image_layer is not None:
            result['ImageLayer'] = self.image_layer
        if self.image_tag is not None:
            result['ImageTag'] = self.image_tag
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.levels is not None:
            result['Levels'] = self.levels
        if self.malicious_md_5 is not None:
            result['MaliciousMd5'] = self.malicious_md_5
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.repo_id is not None:
            result['RepoId'] = self.repo_id
        if self.repo_instance_id is not None:
            result['RepoInstanceId'] = self.repo_instance_id
        if self.repo_name is not None:
            result['RepoName'] = self.repo_name
        if self.repo_namespace is not None:
            result['RepoNamespace'] = self.repo_namespace
        if self.repo_region_id is not None:
            result['RepoRegionId'] = self.repo_region_id
        if self.scan_range is not None:
            result['ScanRange'] = self.scan_range
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('FuzzyMaliciousName') is not None:
            self.fuzzy_malicious_name = m.get('FuzzyMaliciousName')
        if m.get('ImageDigest') is not None:
            self.image_digest = m.get('ImageDigest')
        if m.get('ImageLayer') is not None:
            self.image_layer = m.get('ImageLayer')
        if m.get('ImageTag') is not None:
            self.image_tag = m.get('ImageTag')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Levels') is not None:
            self.levels = m.get('Levels')
        if m.get('MaliciousMd5') is not None:
            self.malicious_md_5 = m.get('MaliciousMd5')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RepoId') is not None:
            self.repo_id = m.get('RepoId')
        if m.get('RepoInstanceId') is not None:
            self.repo_instance_id = m.get('RepoInstanceId')
        if m.get('RepoName') is not None:
            self.repo_name = m.get('RepoName')
        if m.get('RepoNamespace') is not None:
            self.repo_namespace = m.get('RepoNamespace')
        if m.get('RepoRegionId') is not None:
            self.repo_region_id = m.get('RepoRegionId')
        if m.get('ScanRange') is not None:
            self.scan_range = m.get('ScanRange')
        return self


class DescribeGroupedMaliciousFilesResponseBodyGroupedMaliciousFileResponse(TeaModel):
    def __init__(self, first_scan_timestamp=None, image_count=None, latest_scan_timestamp=None, level=None,
                 malicious_md_5=None, malicious_name=None, status=None):
        self.first_scan_timestamp = first_scan_timestamp  # type: long
        self.image_count = image_count  # type: long
        self.latest_scan_timestamp = latest_scan_timestamp  # type: long
        self.level = level  # type: str
        self.malicious_md_5 = malicious_md_5  # type: str
        self.malicious_name = malicious_name  # type: str
        self.status = status  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeGroupedMaliciousFilesResponseBodyGroupedMaliciousFileResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.first_scan_timestamp is not None:
            result['FirstScanTimestamp'] = self.first_scan_timestamp
        if self.image_count is not None:
            result['ImageCount'] = self.image_count
        if self.latest_scan_timestamp is not None:
            result['LatestScanTimestamp'] = self.latest_scan_timestamp
        if self.level is not None:
            result['Level'] = self.level
        if self.malicious_md_5 is not None:
            result['MaliciousMd5'] = self.malicious_md_5
        if self.malicious_name is not None:
            result['MaliciousName'] = self.malicious_name
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FirstScanTimestamp') is not None:
            self.first_scan_timestamp = m.get('FirstScanTimestamp')
        if m.get('ImageCount') is not None:
            self.image_count = m.get('ImageCount')
        if m.get('LatestScanTimestamp') is not None:
            self.latest_scan_timestamp = m.get('LatestScanTimestamp')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('MaliciousMd5') is not None:
            self.malicious_md_5 = m.get('MaliciousMd5')
        if m.get('MaliciousName') is not None:
            self.malicious_name = m.get('MaliciousName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeGroupedMaliciousFilesResponseBodyPageInfo(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, total_count=None):
        self.count = count  # type: int
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeGroupedMaliciousFilesResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeGroupedMaliciousFilesResponseBody(TeaModel):
    def __init__(self, grouped_malicious_file_response=None, page_info=None, request_id=None):
        self.grouped_malicious_file_response = grouped_malicious_file_response  # type: list[DescribeGroupedMaliciousFilesResponseBodyGroupedMaliciousFileResponse]
        self.page_info = page_info  # type: DescribeGroupedMaliciousFilesResponseBodyPageInfo
        self.request_id = request_id  # type: str

    def validate(self):
        if self.grouped_malicious_file_response:
            for k in self.grouped_malicious_file_response:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super(DescribeGroupedMaliciousFilesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['GroupedMaliciousFileResponse'] = []
        if self.grouped_malicious_file_response is not None:
            for k in self.grouped_malicious_file_response:
                result['GroupedMaliciousFileResponse'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.grouped_malicious_file_response = []
        if m.get('GroupedMaliciousFileResponse') is not None:
            for k in m.get('GroupedMaliciousFileResponse'):
                temp_model = DescribeGroupedMaliciousFilesResponseBodyGroupedMaliciousFileResponse()
                self.grouped_malicious_file_response.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeGroupedMaliciousFilesResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeGroupedMaliciousFilesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeGroupedMaliciousFilesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeGroupedMaliciousFilesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeGroupedMaliciousFilesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGroupedTagsRequest(TeaModel):
    def __init__(self, machine_types=None):
        self.machine_types = machine_types  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeGroupedTagsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.machine_types is not None:
            result['MachineTypes'] = self.machine_types
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MachineTypes') is not None:
            self.machine_types = m.get('MachineTypes')
        return self


class DescribeGroupedTagsResponseBodyGroupedFileds(TeaModel):
    def __init__(self, count=None, name=None, tag_id=None):
        self.count = count  # type: str
        self.name = name  # type: str
        self.tag_id = tag_id  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeGroupedTagsResponseBodyGroupedFileds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.name is not None:
            result['Name'] = self.name
        if self.tag_id is not None:
            result['TagId'] = self.tag_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('TagId') is not None:
            self.tag_id = m.get('TagId')
        return self


class DescribeGroupedTagsResponseBody(TeaModel):
    def __init__(self, count=None, grouped_fileds=None, http_status_code=None, request_id=None, success=None):
        self.count = count  # type: int
        self.grouped_fileds = grouped_fileds  # type: list[DescribeGroupedTagsResponseBodyGroupedFileds]
        self.http_status_code = http_status_code  # type: int
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.grouped_fileds:
            for k in self.grouped_fileds:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeGroupedTagsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        result['GroupedFileds'] = []
        if self.grouped_fileds is not None:
            for k in self.grouped_fileds:
                result['GroupedFileds'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        self.grouped_fileds = []
        if m.get('GroupedFileds') is not None:
            for k in m.get('GroupedFileds'):
                temp_model = DescribeGroupedTagsResponseBodyGroupedFileds()
                self.grouped_fileds.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeGroupedTagsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeGroupedTagsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeGroupedTagsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeGroupedTagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGroupedVulRequest(TeaModel):
    def __init__(self, alias_name=None, asset_type=None, attach_types=None, container_field_name=None,
                 current_page=None, dealed=None, group_id=None, lang=None, necessity=None, page_size=None, search_tags=None,
                 target_type=None, type=None, uuids=None):
        self.alias_name = alias_name  # type: str
        self.asset_type = asset_type  # type: str
        self.attach_types = attach_types  # type: str
        self.container_field_name = container_field_name  # type: str
        self.current_page = current_page  # type: int
        self.dealed = dealed  # type: str
        self.group_id = group_id  # type: str
        self.lang = lang  # type: str
        self.necessity = necessity  # type: str
        self.page_size = page_size  # type: int
        self.search_tags = search_tags  # type: str
        self.target_type = target_type  # type: str
        self.type = type  # type: str
        self.uuids = uuids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeGroupedVulRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.asset_type is not None:
            result['AssetType'] = self.asset_type
        if self.attach_types is not None:
            result['AttachTypes'] = self.attach_types
        if self.container_field_name is not None:
            result['ContainerFieldName'] = self.container_field_name
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dealed is not None:
            result['Dealed'] = self.dealed
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.necessity is not None:
            result['Necessity'] = self.necessity
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.search_tags is not None:
            result['SearchTags'] = self.search_tags
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        if self.type is not None:
            result['Type'] = self.type
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('AssetType') is not None:
            self.asset_type = m.get('AssetType')
        if m.get('AttachTypes') is not None:
            self.attach_types = m.get('AttachTypes')
        if m.get('ContainerFieldName') is not None:
            self.container_field_name = m.get('ContainerFieldName')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Dealed') is not None:
            self.dealed = m.get('Dealed')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Necessity') is not None:
            self.necessity = m.get('Necessity')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SearchTags') is not None:
            self.search_tags = m.get('SearchTags')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        return self


class DescribeGroupedVulResponseBodyGroupedVulItems(TeaModel):
    def __init__(self, alias_name=None, asap_count=None, gmt_last=None, handled_count=None, later_count=None,
                 name=None, nntf_count=None, rasp_defend=None, tags=None, total_fix_count=None, type=None):
        self.alias_name = alias_name  # type: str
        self.asap_count = asap_count  # type: int
        self.gmt_last = gmt_last  # type: long
        self.handled_count = handled_count  # type: int
        self.later_count = later_count  # type: int
        self.name = name  # type: str
        self.nntf_count = nntf_count  # type: int
        self.rasp_defend = rasp_defend  # type: int
        self.tags = tags  # type: str
        self.total_fix_count = total_fix_count  # type: long
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeGroupedVulResponseBodyGroupedVulItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.asap_count is not None:
            result['AsapCount'] = self.asap_count
        if self.gmt_last is not None:
            result['GmtLast'] = self.gmt_last
        if self.handled_count is not None:
            result['HandledCount'] = self.handled_count
        if self.later_count is not None:
            result['LaterCount'] = self.later_count
        if self.name is not None:
            result['Name'] = self.name
        if self.nntf_count is not None:
            result['NntfCount'] = self.nntf_count
        if self.rasp_defend is not None:
            result['RaspDefend'] = self.rasp_defend
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.total_fix_count is not None:
            result['TotalFixCount'] = self.total_fix_count
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('AsapCount') is not None:
            self.asap_count = m.get('AsapCount')
        if m.get('GmtLast') is not None:
            self.gmt_last = m.get('GmtLast')
        if m.get('HandledCount') is not None:
            self.handled_count = m.get('HandledCount')
        if m.get('LaterCount') is not None:
            self.later_count = m.get('LaterCount')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NntfCount') is not None:
            self.nntf_count = m.get('NntfCount')
        if m.get('RaspDefend') is not None:
            self.rasp_defend = m.get('RaspDefend')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('TotalFixCount') is not None:
            self.total_fix_count = m.get('TotalFixCount')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeGroupedVulResponseBody(TeaModel):
    def __init__(self, current_page=None, grouped_vul_items=None, page_size=None, request_id=None, total_count=None):
        self.current_page = current_page  # type: int
        self.grouped_vul_items = grouped_vul_items  # type: list[DescribeGroupedVulResponseBodyGroupedVulItems]
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        if self.grouped_vul_items:
            for k in self.grouped_vul_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeGroupedVulResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['GroupedVulItems'] = []
        if self.grouped_vul_items is not None:
            for k in self.grouped_vul_items:
                result['GroupedVulItems'].append(k.to_map() if k else None)
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.grouped_vul_items = []
        if m.get('GroupedVulItems') is not None:
            for k in m.get('GroupedVulItems'):
                temp_model = DescribeGroupedVulResponseBodyGroupedVulItems()
                self.grouped_vul_items.append(temp_model.from_map(k))
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeGroupedVulResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeGroupedVulResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeGroupedVulResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeGroupedVulResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeHcExportInfoRequest(TeaModel):
    def __init__(self, export_id=None):
        self.export_id = export_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeHcExportInfoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.export_id is not None:
            result['ExportId'] = self.export_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ExportId') is not None:
            self.export_id = m.get('ExportId')
        return self


class DescribeHcExportInfoResponseBody(TeaModel):
    def __init__(self, current_count=None, file_name=None, gmt_create=None, id=None, link=None, progress=None,
                 request_id=None, result_status=None, total_count=None):
        self.current_count = current_count  # type: int
        self.file_name = file_name  # type: str
        self.gmt_create = gmt_create  # type: long
        self.id = id  # type: long
        self.link = link  # type: str
        self.progress = progress  # type: int
        self.request_id = request_id  # type: str
        self.result_status = result_status  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeHcExportInfoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_count is not None:
            result['CurrentCount'] = self.current_count
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.id is not None:
            result['Id'] = self.id
        if self.link is not None:
            result['Link'] = self.link
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result_status is not None:
            result['ResultStatus'] = self.result_status
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentCount') is not None:
            self.current_count = m.get('CurrentCount')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Link') is not None:
            self.link = m.get('Link')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResultStatus') is not None:
            self.result_status = m.get('ResultStatus')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeHcExportInfoResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeHcExportInfoResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeHcExportInfoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeHcExportInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeHoneyPotAuthRequest(TeaModel):
    def __init__(self, lang=None):
        self.lang = lang  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeHoneyPotAuthRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeHoneyPotAuthResponseBody(TeaModel):
    def __init__(self, honey_pot_auth_count=None, honey_pot_count=None, request_id=None):
        self.honey_pot_auth_count = honey_pot_auth_count  # type: long
        self.honey_pot_count = honey_pot_count  # type: int
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeHoneyPotAuthResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.honey_pot_auth_count is not None:
            result['HoneyPotAuthCount'] = self.honey_pot_auth_count
        if self.honey_pot_count is not None:
            result['HoneyPotCount'] = self.honey_pot_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HoneyPotAuthCount') is not None:
            self.honey_pot_auth_count = m.get('HoneyPotAuthCount')
        if m.get('HoneyPotCount') is not None:
            self.honey_pot_count = m.get('HoneyPotCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeHoneyPotAuthResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeHoneyPotAuthResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeHoneyPotAuthResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeHoneyPotAuthResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeHoneyPotSuspStatisticsRequest(TeaModel):
    def __init__(self, from_=None, lang=None, statistics_days=None, statistics_key_type=None):
        self.from_ = from_  # type: str
        self.lang = lang  # type: str
        self.statistics_days = statistics_days  # type: int
        self.statistics_key_type = statistics_key_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeHoneyPotSuspStatisticsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.from_ is not None:
            result['From'] = self.from_
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.statistics_days is not None:
            result['StatisticsDays'] = self.statistics_days
        if self.statistics_key_type is not None:
            result['StatisticsKeyType'] = self.statistics_key_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('From') is not None:
            self.from_ = m.get('From')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('StatisticsDays') is not None:
            self.statistics_days = m.get('StatisticsDays')
        if m.get('StatisticsKeyType') is not None:
            self.statistics_key_type = m.get('StatisticsKeyType')
        return self


class DescribeHoneyPotSuspStatisticsResponseBodySuspHoneyPotStatisticsResponse(TeaModel):
    def __init__(self, count=None, instance_id=None, instance_name=None, type=None, vpc_id=None, vpc_name=None):
        self.count = count  # type: int
        self.instance_id = instance_id  # type: str
        self.instance_name = instance_name  # type: str
        self.type = type  # type: str
        self.vpc_id = vpc_id  # type: str
        self.vpc_name = vpc_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeHoneyPotSuspStatisticsResponseBodySuspHoneyPotStatisticsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.type is not None:
            result['Type'] = self.type
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.vpc_name is not None:
            result['VpcName'] = self.vpc_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('VpcName') is not None:
            self.vpc_name = m.get('VpcName')
        return self


class DescribeHoneyPotSuspStatisticsResponseBody(TeaModel):
    def __init__(self, request_id=None, susp_honey_pot_statistics_response=None):
        self.request_id = request_id  # type: str
        self.susp_honey_pot_statistics_response = susp_honey_pot_statistics_response  # type: list[DescribeHoneyPotSuspStatisticsResponseBodySuspHoneyPotStatisticsResponse]

    def validate(self):
        if self.susp_honey_pot_statistics_response:
            for k in self.susp_honey_pot_statistics_response:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeHoneyPotSuspStatisticsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['SuspHoneyPotStatisticsResponse'] = []
        if self.susp_honey_pot_statistics_response is not None:
            for k in self.susp_honey_pot_statistics_response:
                result['SuspHoneyPotStatisticsResponse'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.susp_honey_pot_statistics_response = []
        if m.get('SuspHoneyPotStatisticsResponse') is not None:
            for k in m.get('SuspHoneyPotStatisticsResponse'):
                temp_model = DescribeHoneyPotSuspStatisticsResponseBodySuspHoneyPotStatisticsResponse()
                self.susp_honey_pot_statistics_response.append(temp_model.from_map(k))
        return self


class DescribeHoneyPotSuspStatisticsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeHoneyPotSuspStatisticsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeHoneyPotSuspStatisticsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeHoneyPotSuspStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeImageRequest(TeaModel):
    def __init__(self, image_instance_id=None, image_region_id=None, image_repo_id=None, image_tag=None):
        self.image_instance_id = image_instance_id  # type: str
        self.image_region_id = image_region_id  # type: str
        self.image_repo_id = image_repo_id  # type: str
        self.image_tag = image_tag  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeImageRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_instance_id is not None:
            result['ImageInstanceId'] = self.image_instance_id
        if self.image_region_id is not None:
            result['ImageRegionId'] = self.image_region_id
        if self.image_repo_id is not None:
            result['ImageRepoId'] = self.image_repo_id
        if self.image_tag is not None:
            result['ImageTag'] = self.image_tag
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ImageInstanceId') is not None:
            self.image_instance_id = m.get('ImageInstanceId')
        if m.get('ImageRegionId') is not None:
            self.image_region_id = m.get('ImageRegionId')
        if m.get('ImageRepoId') is not None:
            self.image_repo_id = m.get('ImageRepoId')
        if m.get('ImageTag') is not None:
            self.image_tag = m.get('ImageTag')
        return self


class DescribeImageResponseBodyData(TeaModel):
    def __init__(self, digest=None):
        self.digest = digest  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeImageResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.digest is not None:
            result['Digest'] = self.digest
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Digest') is not None:
            self.digest = m.get('Digest')
        return self


class DescribeImageResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: DescribeImageResponseBodyData
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DescribeImageResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DescribeImageResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeImageResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeImageResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeImageResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeImageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeImageBaselineCheckResultRequest(TeaModel):
    def __init__(self, criteria=None, criteria_type=None, current_page=None, image_uuid=None, lang=None,
                 page_size=None, risk_level=None, scan_range=None):
        self.criteria = criteria  # type: str
        self.criteria_type = criteria_type  # type: str
        self.current_page = current_page  # type: int
        self.image_uuid = image_uuid  # type: str
        self.lang = lang  # type: str
        self.page_size = page_size  # type: int
        self.risk_level = risk_level  # type: str
        self.scan_range = scan_range  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeImageBaselineCheckResultRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.criteria is not None:
            result['Criteria'] = self.criteria
        if self.criteria_type is not None:
            result['CriteriaType'] = self.criteria_type
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.image_uuid is not None:
            result['ImageUuid'] = self.image_uuid
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        if self.scan_range is not None:
            result['ScanRange'] = self.scan_range
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Criteria') is not None:
            self.criteria = m.get('Criteria')
        if m.get('CriteriaType') is not None:
            self.criteria_type = m.get('CriteriaType')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('ImageUuid') is not None:
            self.image_uuid = m.get('ImageUuid')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        if m.get('ScanRange') is not None:
            self.scan_range = m.get('ScanRange')
        return self


class DescribeImageBaselineCheckResultResponseBodyBaselineResult(TeaModel):
    def __init__(self, baseline_class_alias=None, baseline_item_count=None, baseline_name_alias=None,
                 baseline_name_key=None, baseline_name_level=None, first_scan_time=None, high_risk_item_count=None,
                 last_scan_time=None, low_risk_item_count=None, middle_risk_item_count=None, status=None):
        self.baseline_class_alias = baseline_class_alias  # type: str
        self.baseline_item_count = baseline_item_count  # type: int
        self.baseline_name_alias = baseline_name_alias  # type: str
        self.baseline_name_key = baseline_name_key  # type: str
        self.baseline_name_level = baseline_name_level  # type: str
        self.first_scan_time = first_scan_time  # type: long
        self.high_risk_item_count = high_risk_item_count  # type: int
        self.last_scan_time = last_scan_time  # type: long
        self.low_risk_item_count = low_risk_item_count  # type: int
        self.middle_risk_item_count = middle_risk_item_count  # type: int
        self.status = status  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeImageBaselineCheckResultResponseBodyBaselineResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_class_alias is not None:
            result['BaselineClassAlias'] = self.baseline_class_alias
        if self.baseline_item_count is not None:
            result['BaselineItemCount'] = self.baseline_item_count
        if self.baseline_name_alias is not None:
            result['BaselineNameAlias'] = self.baseline_name_alias
        if self.baseline_name_key is not None:
            result['BaselineNameKey'] = self.baseline_name_key
        if self.baseline_name_level is not None:
            result['BaselineNameLevel'] = self.baseline_name_level
        if self.first_scan_time is not None:
            result['FirstScanTime'] = self.first_scan_time
        if self.high_risk_item_count is not None:
            result['HighRiskItemCount'] = self.high_risk_item_count
        if self.last_scan_time is not None:
            result['LastScanTime'] = self.last_scan_time
        if self.low_risk_item_count is not None:
            result['LowRiskItemCount'] = self.low_risk_item_count
        if self.middle_risk_item_count is not None:
            result['MiddleRiskItemCount'] = self.middle_risk_item_count
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BaselineClassAlias') is not None:
            self.baseline_class_alias = m.get('BaselineClassAlias')
        if m.get('BaselineItemCount') is not None:
            self.baseline_item_count = m.get('BaselineItemCount')
        if m.get('BaselineNameAlias') is not None:
            self.baseline_name_alias = m.get('BaselineNameAlias')
        if m.get('BaselineNameKey') is not None:
            self.baseline_name_key = m.get('BaselineNameKey')
        if m.get('BaselineNameLevel') is not None:
            self.baseline_name_level = m.get('BaselineNameLevel')
        if m.get('FirstScanTime') is not None:
            self.first_scan_time = m.get('FirstScanTime')
        if m.get('HighRiskItemCount') is not None:
            self.high_risk_item_count = m.get('HighRiskItemCount')
        if m.get('LastScanTime') is not None:
            self.last_scan_time = m.get('LastScanTime')
        if m.get('LowRiskItemCount') is not None:
            self.low_risk_item_count = m.get('LowRiskItemCount')
        if m.get('MiddleRiskItemCount') is not None:
            self.middle_risk_item_count = m.get('MiddleRiskItemCount')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeImageBaselineCheckResultResponseBodyPageInfo(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, total_count=None):
        self.count = count  # type: int
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeImageBaselineCheckResultResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeImageBaselineCheckResultResponseBody(TeaModel):
    def __init__(self, baseline_result=None, page_info=None, request_id=None):
        self.baseline_result = baseline_result  # type: list[DescribeImageBaselineCheckResultResponseBodyBaselineResult]
        self.page_info = page_info  # type: DescribeImageBaselineCheckResultResponseBodyPageInfo
        self.request_id = request_id  # type: str

    def validate(self):
        if self.baseline_result:
            for k in self.baseline_result:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super(DescribeImageBaselineCheckResultResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BaselineResult'] = []
        if self.baseline_result is not None:
            for k in self.baseline_result:
                result['BaselineResult'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.baseline_result = []
        if m.get('BaselineResult') is not None:
            for k in m.get('BaselineResult'):
                temp_model = DescribeImageBaselineCheckResultResponseBodyBaselineResult()
                self.baseline_result.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeImageBaselineCheckResultResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeImageBaselineCheckResultResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeImageBaselineCheckResultResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeImageBaselineCheckResultResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeImageBaselineCheckResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeImageBaselineCheckSummaryRequest(TeaModel):
    def __init__(self, cluster_id=None, criteria=None, criteria_type=None, current_page=None, lang=None,
                 page_size=None, risk_level=None, scan_range=None):
        self.cluster_id = cluster_id  # type: str
        self.criteria = criteria  # type: str
        self.criteria_type = criteria_type  # type: str
        self.current_page = current_page  # type: int
        self.lang = lang  # type: str
        self.page_size = page_size  # type: int
        self.risk_level = risk_level  # type: str
        self.scan_range = scan_range  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeImageBaselineCheckSummaryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.criteria is not None:
            result['Criteria'] = self.criteria
        if self.criteria_type is not None:
            result['CriteriaType'] = self.criteria_type
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        if self.scan_range is not None:
            result['ScanRange'] = self.scan_range
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('Criteria') is not None:
            self.criteria = m.get('Criteria')
        if m.get('CriteriaType') is not None:
            self.criteria_type = m.get('CriteriaType')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        if m.get('ScanRange') is not None:
            self.scan_range = m.get('ScanRange')
        return self


class DescribeImageBaselineCheckSummaryResponseBodyBaselineResultSummary(TeaModel):
    def __init__(self, baseline_class_alias=None, baseline_class_key=None, baseline_name_alias=None,
                 baseline_name_key=None, baseline_name_level=None, first_scan_time=None, high_risk_image=None, last_scan_time=None,
                 low_risk_image=None, middle_risk_image=None, status=None):
        self.baseline_class_alias = baseline_class_alias  # type: str
        self.baseline_class_key = baseline_class_key  # type: str
        self.baseline_name_alias = baseline_name_alias  # type: str
        self.baseline_name_key = baseline_name_key  # type: str
        self.baseline_name_level = baseline_name_level  # type: str
        self.first_scan_time = first_scan_time  # type: long
        self.high_risk_image = high_risk_image  # type: int
        self.last_scan_time = last_scan_time  # type: long
        self.low_risk_image = low_risk_image  # type: int
        self.middle_risk_image = middle_risk_image  # type: int
        self.status = status  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeImageBaselineCheckSummaryResponseBodyBaselineResultSummary, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_class_alias is not None:
            result['BaselineClassAlias'] = self.baseline_class_alias
        if self.baseline_class_key is not None:
            result['BaselineClassKey'] = self.baseline_class_key
        if self.baseline_name_alias is not None:
            result['BaselineNameAlias'] = self.baseline_name_alias
        if self.baseline_name_key is not None:
            result['BaselineNameKey'] = self.baseline_name_key
        if self.baseline_name_level is not None:
            result['BaselineNameLevel'] = self.baseline_name_level
        if self.first_scan_time is not None:
            result['FirstScanTime'] = self.first_scan_time
        if self.high_risk_image is not None:
            result['HighRiskImage'] = self.high_risk_image
        if self.last_scan_time is not None:
            result['LastScanTime'] = self.last_scan_time
        if self.low_risk_image is not None:
            result['LowRiskImage'] = self.low_risk_image
        if self.middle_risk_image is not None:
            result['MiddleRiskImage'] = self.middle_risk_image
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BaselineClassAlias') is not None:
            self.baseline_class_alias = m.get('BaselineClassAlias')
        if m.get('BaselineClassKey') is not None:
            self.baseline_class_key = m.get('BaselineClassKey')
        if m.get('BaselineNameAlias') is not None:
            self.baseline_name_alias = m.get('BaselineNameAlias')
        if m.get('BaselineNameKey') is not None:
            self.baseline_name_key = m.get('BaselineNameKey')
        if m.get('BaselineNameLevel') is not None:
            self.baseline_name_level = m.get('BaselineNameLevel')
        if m.get('FirstScanTime') is not None:
            self.first_scan_time = m.get('FirstScanTime')
        if m.get('HighRiskImage') is not None:
            self.high_risk_image = m.get('HighRiskImage')
        if m.get('LastScanTime') is not None:
            self.last_scan_time = m.get('LastScanTime')
        if m.get('LowRiskImage') is not None:
            self.low_risk_image = m.get('LowRiskImage')
        if m.get('MiddleRiskImage') is not None:
            self.middle_risk_image = m.get('MiddleRiskImage')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeImageBaselineCheckSummaryResponseBodyPageInfo(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, total_count=None):
        self.count = count  # type: int
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeImageBaselineCheckSummaryResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeImageBaselineCheckSummaryResponseBody(TeaModel):
    def __init__(self, baseline_result_summary=None, page_info=None, request_id=None):
        self.baseline_result_summary = baseline_result_summary  # type: list[DescribeImageBaselineCheckSummaryResponseBodyBaselineResultSummary]
        self.page_info = page_info  # type: DescribeImageBaselineCheckSummaryResponseBodyPageInfo
        self.request_id = request_id  # type: str

    def validate(self):
        if self.baseline_result_summary:
            for k in self.baseline_result_summary:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super(DescribeImageBaselineCheckSummaryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BaselineResultSummary'] = []
        if self.baseline_result_summary is not None:
            for k in self.baseline_result_summary:
                result['BaselineResultSummary'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.baseline_result_summary = []
        if m.get('BaselineResultSummary') is not None:
            for k in m.get('BaselineResultSummary'):
                temp_model = DescribeImageBaselineCheckSummaryResponseBodyBaselineResultSummary()
                self.baseline_result_summary.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeImageBaselineCheckSummaryResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeImageBaselineCheckSummaryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeImageBaselineCheckSummaryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeImageBaselineCheckSummaryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeImageBaselineCheckSummaryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeImageBaselineDetailRequest(TeaModel):
    def __init__(self, baseline_item_key=None, image_uuid=None, lang=None):
        self.baseline_item_key = baseline_item_key  # type: str
        self.image_uuid = image_uuid  # type: str
        self.lang = lang  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeImageBaselineDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_item_key is not None:
            result['BaselineItemKey'] = self.baseline_item_key
        if self.image_uuid is not None:
            result['ImageUuid'] = self.image_uuid
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BaselineItemKey') is not None:
            self.baseline_item_key = m.get('BaselineItemKey')
        if m.get('ImageUuid') is not None:
            self.image_uuid = m.get('ImageUuid')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeImageBaselineDetailResponseBodyBaselineDetail(TeaModel):
    def __init__(self, advice=None, baseline_class_alias=None, baseline_item_alias=None, baseline_item_key=None,
                 baseline_name_alias=None, description=None, level=None, prompt=None, result_id=None):
        self.advice = advice  # type: str
        self.baseline_class_alias = baseline_class_alias  # type: str
        self.baseline_item_alias = baseline_item_alias  # type: str
        self.baseline_item_key = baseline_item_key  # type: str
        self.baseline_name_alias = baseline_name_alias  # type: str
        self.description = description  # type: str
        self.level = level  # type: str
        self.prompt = prompt  # type: str
        self.result_id = result_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeImageBaselineDetailResponseBodyBaselineDetail, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.advice is not None:
            result['Advice'] = self.advice
        if self.baseline_class_alias is not None:
            result['BaselineClassAlias'] = self.baseline_class_alias
        if self.baseline_item_alias is not None:
            result['BaselineItemAlias'] = self.baseline_item_alias
        if self.baseline_item_key is not None:
            result['BaselineItemKey'] = self.baseline_item_key
        if self.baseline_name_alias is not None:
            result['BaselineNameAlias'] = self.baseline_name_alias
        if self.description is not None:
            result['Description'] = self.description
        if self.level is not None:
            result['Level'] = self.level
        if self.prompt is not None:
            result['Prompt'] = self.prompt
        if self.result_id is not None:
            result['ResultId'] = self.result_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Advice') is not None:
            self.advice = m.get('Advice')
        if m.get('BaselineClassAlias') is not None:
            self.baseline_class_alias = m.get('BaselineClassAlias')
        if m.get('BaselineItemAlias') is not None:
            self.baseline_item_alias = m.get('BaselineItemAlias')
        if m.get('BaselineItemKey') is not None:
            self.baseline_item_key = m.get('BaselineItemKey')
        if m.get('BaselineNameAlias') is not None:
            self.baseline_name_alias = m.get('BaselineNameAlias')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Prompt') is not None:
            self.prompt = m.get('Prompt')
        if m.get('ResultId') is not None:
            self.result_id = m.get('ResultId')
        return self


class DescribeImageBaselineDetailResponseBody(TeaModel):
    def __init__(self, baseline_detail=None, request_id=None):
        self.baseline_detail = baseline_detail  # type: DescribeImageBaselineDetailResponseBodyBaselineDetail
        self.request_id = request_id  # type: str

    def validate(self):
        if self.baseline_detail:
            self.baseline_detail.validate()

    def to_map(self):
        _map = super(DescribeImageBaselineDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_detail is not None:
            result['BaselineDetail'] = self.baseline_detail.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BaselineDetail') is not None:
            temp_model = DescribeImageBaselineDetailResponseBodyBaselineDetail()
            self.baseline_detail = temp_model.from_map(m['BaselineDetail'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeImageBaselineDetailResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeImageBaselineDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeImageBaselineDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeImageBaselineDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeImageBaselineItemListRequest(TeaModel):
    def __init__(self, baseline_class_key=None, baseline_name_key=None, current_page=None, image_uuid=None,
                 lang=None, page_size=None, scan_range=None, status=None, uuids=None):
        # The key of the baseline type.
        self.baseline_class_key = baseline_class_key  # type: str
        # The key of the baseline name.
        self.baseline_name_key = baseline_name_key  # type: str
        # The number of the page to return.
        self.current_page = current_page  # type: int
        # The UUID of the image.
        self.image_uuid = image_uuid  # type: str
        # The language of the content within the request and response. Default value: **zh**. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang  # type: str
        # The number of entries to return on each page.
        self.page_size = page_size  # type: int
        # The types of the assets that are scanned.
        self.scan_range = scan_range  # type: list[str]
        # The status of the baseline risk item. Valid values:
        # 
        # *   **0**: unfixed
        # *   **1**: fixed
        # *   **2**: pending verification
        # *   **3**: fixing failed
        self.status = status  # type: str
        # The UUIDs of images.
        self.uuids = uuids  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeImageBaselineItemListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_class_key is not None:
            result['BaselineClassKey'] = self.baseline_class_key
        if self.baseline_name_key is not None:
            result['BaselineNameKey'] = self.baseline_name_key
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.image_uuid is not None:
            result['ImageUuid'] = self.image_uuid
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.scan_range is not None:
            result['ScanRange'] = self.scan_range
        if self.status is not None:
            result['Status'] = self.status
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BaselineClassKey') is not None:
            self.baseline_class_key = m.get('BaselineClassKey')
        if m.get('BaselineNameKey') is not None:
            self.baseline_name_key = m.get('BaselineNameKey')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('ImageUuid') is not None:
            self.image_uuid = m.get('ImageUuid')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ScanRange') is not None:
            self.scan_range = m.get('ScanRange')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        return self


class DescribeImageBaselineItemListResponseBodyBaselineItemInfos(TeaModel):
    def __init__(self, baseline_class_alias=None, baseline_class_key=None, baseline_item_alias=None,
                 baseline_item_key=None, baseline_name_alias=None, baseline_name_key=None, status=None, white_list=None):
        # The alias of the baseline type.
        self.baseline_class_alias = baseline_class_alias  # type: str
        # The key of the baseline type.
        self.baseline_class_key = baseline_class_key  # type: str
        # The alias of the baseline check item.
        self.baseline_item_alias = baseline_item_alias  # type: str
        # The key of the baseline check item.
        self.baseline_item_key = baseline_item_key  # type: str
        # The alias of the baseline.
        self.baseline_name_alias = baseline_name_alias  # type: str
        # The key of the baseline name.
        self.baseline_name_key = baseline_name_key  # type: str
        # The status of the baseline risk item. Valid values:
        # 
        # *   **0**: unfixed
        # *   **1**: fixed
        # *   **2**: pending verification
        # *   **3**: fixing failed
        self.status = status  # type: int
        # Indicates whether the baseline check item is added to the whitelist. Valid values:
        # 
        # *   **0**: no
        # *   **1**: yes
        self.white_list = white_list  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeImageBaselineItemListResponseBodyBaselineItemInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_class_alias is not None:
            result['BaselineClassAlias'] = self.baseline_class_alias
        if self.baseline_class_key is not None:
            result['BaselineClassKey'] = self.baseline_class_key
        if self.baseline_item_alias is not None:
            result['BaselineItemAlias'] = self.baseline_item_alias
        if self.baseline_item_key is not None:
            result['BaselineItemKey'] = self.baseline_item_key
        if self.baseline_name_alias is not None:
            result['BaselineNameAlias'] = self.baseline_name_alias
        if self.baseline_name_key is not None:
            result['BaselineNameKey'] = self.baseline_name_key
        if self.status is not None:
            result['Status'] = self.status
        if self.white_list is not None:
            result['WhiteList'] = self.white_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BaselineClassAlias') is not None:
            self.baseline_class_alias = m.get('BaselineClassAlias')
        if m.get('BaselineClassKey') is not None:
            self.baseline_class_key = m.get('BaselineClassKey')
        if m.get('BaselineItemAlias') is not None:
            self.baseline_item_alias = m.get('BaselineItemAlias')
        if m.get('BaselineItemKey') is not None:
            self.baseline_item_key = m.get('BaselineItemKey')
        if m.get('BaselineNameAlias') is not None:
            self.baseline_name_alias = m.get('BaselineNameAlias')
        if m.get('BaselineNameKey') is not None:
            self.baseline_name_key = m.get('BaselineNameKey')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('WhiteList') is not None:
            self.white_list = m.get('WhiteList')
        return self


class DescribeImageBaselineItemListResponseBodyPageInfo(TeaModel):
    def __init__(self, count=None, current_page=None, page_size=None, total_count=None):
        # The number of entries returned on the current page.
        self.count = count  # type: int
        # The page number of the returned page.
        self.current_page = current_page  # type: int
        # The number of entries returned per page.
        self.page_size = page_size  # type: int
        # The total number of entries returned.
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeImageBaselineItemListResponseBodyPageInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeImageBaselineItemListResponseBody(TeaModel):
    def __init__(self, baseline_item_infos=None, page_info=None, request_id=None):
        # An array that consists of baseline check items.
        self.baseline_item_infos = baseline_item_infos  # type: list[DescribeImageBaselineItemListResponseBodyBaselineItemInfos]
        # The pagination information.
        self.page_info = page_info  # type: DescribeImageBaselineItemListResponseBodyPageInfo
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.baseline_item_infos:
            for k in self.baseline_item_infos:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super(DescribeImageBaselineItemListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BaselineItemInfos'] = []
        if self.baseline_item_infos is not None:
            for k in self.baseline_item_infos:
                result['BaselineItemInfos'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.baseline_item_infos = []
        if m.get('BaselineItemInfos') is not None:
            for k in m.get('BaselineItemInfos'):
                temp_model = DescribeImageBaselineItemListResponseBodyBaselineItemInfos()
                self.baseline_item_infos.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeImageBaselineItemListResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeImageBaselineItemListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeImageBaselineItemListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeImageBaselineItemListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.header