# <Copyright 2022, Argo AI, LLC. Released under the MIT license.>

"""Splits for the Argoverse 2 sensor dataset."""

from typing import Final, Tuple

TRAIN: Final[Tuple[str, ...]] = (
    "00a6ffc1-6ce9-3bc3-a060-6006e9893a1a",
    "01bb304d-7bd8-35f8-bbef-7086b688e35e",
    "022af476-9937-3e70-be52-f65420d52703",
    "0322b098-7e42-34db-bcec-9a4d072191e9",
    "03b2cf2d-fb61-36fe-936f-36bbf197a8ac",
    "03fba633-8085-30bc-b675-687a715536ac",
    "04973bcf-fc64-367c-9642-6d6c5f363b61",
    "0526e68e-2ff1-3e53-b0f8-45df02e45a93",
    "05853f69-f948-3d04-8d64-d4e721c0e1a5",
    "05fb81ab-5e46-3f63-a59f-82fc66d5a477",
    "067b1c50-6567-3840-ab56-1ca2a0ed9c30",
    "06852209-b868-306b-b492-ee6dbc914cf8",
    "069cc46d-38bb-309d-88cf-296a3d0c0820",
    "06e5ac08-f4cb-34ae-9406-3496f7cadc62",
    "072c8e90-a51c-3429-9cdf-4dababb4e9d8",
    "0749e9e0-ca52-3546-b324-d704138b11b5",
    "074d2237-ed1b-34d7-a2fc-68edbce50bb2",
    "07e4fccb-eb2d-31e5-bbcb-6550d0860f64",
    "080b1ce2-9477-39ee-8233-b7f33e1dfe56",
    "08734a1b-0289-3aa3-a6ba-8c7121521e26",
    "087695bd-c662-3e86-83b4-aedc3b8eec36",
    "087fec73-1a0c-399a-9292-cc2cf99dc97f",
    "08bcc06e-3adf-3651-aa4d-d791004418ca",
    "094c4119-eb33-3dfb-a18d-492cbdc8413a",
    "098fe60e-bab0-32e2-89bc-bedced881911",
    "0a132537-3aec-35bb-af13-7faa0811000d",
    "0a524e66-ee33-3b6c-89ef-eac1985316db",
    "0a8a4cfa-4902-3a76-8301-08698d6290a2",
    "0ab21841-0c08-3bae-8424-daa9b336683f",
    "0b1b993a-68b3-3232-9afa-fc9942b5b79b",
    "0b324587-6097-3f92-a07a-a44f48c85d9e",
    "0b9321c1-9bc2-4727-beb8-8046aa4bb6c4",
    "0b97f5dd-c396-3c02-b07d-b7fdbcb6c3d0",
    "0c143226-9c39-387c-a935-1391bed6dc75",
    "0c61aea3-3cba-35f3-8971-df42cd5b9b1a",
    "0d37aee4-6508-33a2-998d-724834e80030",
    "0d8aab9f-4edf-3fb3-895a-ba64e8f2cfb2",
    "0d9e4cff-73ff-33eb-9981-795475e62faf",
    "0f257dcc-8606-3ef9-b17e-b022a3fc72c7",
    "0fc6aa34-323a-33bb-9804-2004599bcd06",
    "105f47eb-491c-3cab-91af-83c5bc1f6c48",
    "106d962b-911d-354d-961d-9abe93119b9c",
    "108d2060-8bef-3d1c-88c5-c8295f596595",
    "11420316-aec9-3ad9-8b4a-d618bcd180e9",
    "118a1e87-aff4-35f5-aa38-01504a63ddce",
    "11995cbe-e076-3a35-910d-1e56ecf2c3c8",
    "12071817-ba53-35a4-bf6c-a8e8e7ad8969",
    "120d7ac7-cce3-359e-a19c-1b9c0abd6be2",
    "121007f3-a0cc-3795-9606-85108b800772",
    "12c3c14b-9cf2-3434-9a5d-e0bfa332f6ce",
    "13209193-55c7-3827-917e-e04460b8f49b",
    "133e2e0b-b0fe-3bb0-b1f9-c846fcfd29e8",
    "134bb8e9-9080-3bc5-948d-88d8cc034550",
    "14bf638b-8f0d-35b2-a369-6d846b5b3892",
    "14c8d182-9586-3f21-ad20-c4e19ec03e2c",
    "14f5485e-7417-3a5b-9be3-ec88461d03d4",
    "150ae964-5091-3681-b738-88715052c792",
    "156a412d-3699-3c1c-9ada-6ab587347996",
    "1579b300-e7f5-3318-97c2-2c827b0c411e",
    "16af3863-0d31-3cd1-8fa2-58053ffb953a",
    "1842383a-1577-3b7a-90db-41a9a6668ee2",
    "1844c439-b94c-332a-bb94-600818350eb4",
    "1886b0d1-9c5e-326f-99df-30b64044638f",
    "189c8512-b034-3d58-a372-cf48eacf02dd",
    "18bdf01b-6ba6-30a8-a707-1f1458529d3d",
    "194b6c89-8060-3174-b402-308f72cb1c15",
    "19711b73-c43b-3922-be61-8c44df707a7d",
    "1992ed13-948e-34e6-8d9b-a3416e545a95",
    "1a10b0e6-569f-32db-95e8-10c074e353e8",
    "1a4e2d86-23d4-3a0d-a9ac-8b0936ae94ce",
    "1a6487dd-8bc6-3762-bd8a-2e50e15dbe75",
    "1a7e18b5-d8dc-371d-be5f-03a37b113e81",
    "1ab241cf-f9c5-3f8a-88bd-4e14baad8ede",
    "1b8fc962-7036-4d7f-885e-40b631cbdeaf",
    "1bf2bf1c-64d1-308f-afd1-220de9d30290",
    "1c7d3b85-6cec-373c-a4eb-5137d7cc6a7c",
    "1c8f1189-c4fe-3303-bf2a-f88f5751b81e",
    "1d43ed4e-e705-308a-bdfa-49d99285c42a",
    "1d950a38-5c2f-39ce-9cd3-61249bc85194",
    "1e51a567-b416-3c46-9424-05688ff851f7",
    "1e6f21fd-5c8a-3526-ac50-72adae89d6a8",
    "20b00c37-4fe4-31dc-a258-dae253ae6992",
    "20f785b0-e11a-3757-be79-b0731286c998",
    "21f6ebe1-09c9-3a71-bdd9-58f45fbe9000",
    "226199ab-c791-32a7-8bab-ab92878eb199",
    "22dcf96c-ef5e-376b-9db5-dc9f91040f5e",
    "23808d42-e4df-3a0d-b713-fe20e09a4f39",
    "2451c219-3002-3b2e-8fa9-2b7fea168b3b",
    "247f91e7-3177-33ad-b99e-0e0a4dc76751",
    "2501c6d0-071c-3a7a-b51f-c8cbd37abe25",
    "256c185c-284a-343e-93f4-894eed474edd",
    "2583a8ee-867d-3db6-b039-35b913fb8f70",
    "26daba71-ca0a-37e9-9dc6-0f81f02c0afd",
    "2716d83e-8c4f-39a3-a2a3-d5e255fe8a03",
    "271f4204-dd77-350b-b9db-5dabc4191985",
    "2772dd5f-bc0a-47ea-ae19-a5e0dbef8f41",
    "27fba275-0b37-3033-b20d-8f9848f78b1c",
    "285ac213-8caf-31a4-b0fa-c240580f7f69",
    "285dcef7-9f00-3c9c-baca-6c8269210ac4",
    "28617035-7557-3cb9-99c2-754f72fd34b4",
    "286790ed-9dec-305b-bcad-4f8153301e7c",
    "29080565-8133-3274-80cf-6ea98078e50d",
    "298715e3-b204-3bf5-b8c2-fe3be9e310e8",
    "2a9b2658-097e-3f8b-a817-22f2553c5de8",
    "2aea7bd1-432a-43c5-9445-651102487f65",
    "2b044433-ddc1-3580-b560-d46474934089",
    "2b443c95-d55f-3cc4-a2a1-ae4af293d8d9",
    "2b6d18dc-4c95-3301-a498-3ed152798d5b",
    "2ec904db-41aa-397c-a1e3-2e2ca0c8e8fb",
    "2fff4135-98ec-3b82-a330-b73d8afdf36c",
    "3153b5b3-d381-3664-8f82-1d3c5ca841d2",
    "31f062b7-dd17-3e7e-945d-198e91597de9",
    "32edd7c7-8a8f-360d-bcda-83ecf431e3e6",
    "332b278a-a6b9-3bc3-b88c-241e4b03b4ef",
    "334f7360-727f-3689-a5b7-b553322aece5",
    "349c4c1c-9561-360f-9ae7-59772335d54b",
    "34fe8fbd-2b1a-3552-94c4-e80d1e85e5c2",
    "3576c0f5-c1b5-35bb-a0c4-ee95cba5c754",
    "35a15c5c-fa4a-3838-a724-396e112ec95c",
    "35d5649b-f311-3177-8374-f9adf68781f3",
    "35f32393-e82f-3b20-b214-1f6a43d60f23",
    "366ceb72-9f11-385a-8bc9-a26a18dbdd22",
    "36b38cbf-f6c5-3a12-8e7a-eb281cc9c2fc",
    "36d7f8fb-6d47-3e1d-a1f7-b2c67ddf1f44",
    "37fcd8ac-c148-3c4a-92ac-a10f355451b7",
    "380e5bf0-1c68-36a4-ac64-09a03b60bebf",
    "382cf8af-6c8d-3ed9-907b-12214d2c7cb0",
    "382dfbe0-836e-385c-86f2-f1afcf57a402",
    "3844f8a9-b7d4-4919-8e9b-a0370ad29ec0",
    "38609ed6-2445-3df3-bd92-849d3963510e",
    "389069d7-e6db-3d22-9328-e228c002bf75",
    "38f30522-2d43-3ff3-a94b-84887ab1671d",
    "3933d1a2-f121-3c8a-8b01-7738e58c045f",
    "3a1b3424-700b-3b65-9e89-90772a8e24ea",
    "3a789fb0-5cd2-3710-b8ea-f32fce38e3ca",
    "3b2994cb-5f82-4835-9212-0cac8fb3d164",
    "3b2e6033-f37f-3a73-9fab-88317b9b6095",
    "3b60751b-7a71-3a47-a743-96b96f0d9b2b",
    "3b68c074-1680-3a93-92e5-5b711406f2fe",
    "3c27dfaf-1624-39d2-9075-158824ed8e8c",
    "3c3ed78e-1fcf-30ec-9e19-9bf142e2621d",
    "3c51357e-f6e9-3cda-9036-fe6e6cd442fe",
    "3c56f1ef-d4df-30ae-80f3-0a5b22d4d3a6",
    "3c58172c-7a07-3ad4-bdf6-7cae60928c56",
    "3ca11a5e-50b2-3cc3-af7a-ce7ab02b9954",
    "3cd2847c-604e-32b4-af19-6cd0da0dcdc5",
    "3d7743c1-c0a5-3ab2-976e-84af93270f30",
    "3dd173a6-8b21-3189-bd53-132919b96a48",
    "3e707e96-ad84-3e68-bea5-2f9ac502a2d9",
    "3e7c4d87-dba1-3e22-a303-4f402f89cd20",
    "3ea6b5a0-510a-3157-ba88-5124d61280b0",
    "3f9796e9-c892-3915-b719-3292df878ece",
    "3fa8c20e-a4b4-3af6-b9c4-6cb96f83916d",
    "3fbdfb6c-927f-4aaa-81b1-21b02efd4c01",
    "4058d838-75cb-35e2-af7e-a51aaa833271",
    "40870b19-3356-3e8e-a4a4-9f34eef8ea30",
    "40bfcbec-ec59-3731-8e75-67f0bddc3b01",
    "41b6f7d7-e431-3992-b783-74b9edf42215",
    "41c3597a-aab1-3123-85a1-dd5d459af461",
    "41d69427-364c-366e-94a5-8e556bcac39f",
    "41e31361-569b-3ed8-bafd-2308b7a9377e",
    "4207ef92-0b3b-4708-8868-4ffcaef308e0",
    "422dd53b-6010-4eb9-8902-de3d134c5a70",
    "429dedd9-2d51-385d-9661-b15f4027e34d",
    "42c8449f-6e6d-3980-b54a-805eba6621c4",
    "43efcbe2-fe24-35b0-9e69-b07c1b0725d3",
    "441871a2-a9c5-3048-b7e9-d88af5acb8f1",
    "44200521-4cad-3a5d-8568-e0f3f1ca24d4",
    "444cce44-cc82-4620-b630-1b5849284ac7",
    "4487b659-692e-3b35-9d1e-a230279ed646",
    "453e5558-6363-38e3-bf9b-42b5ba0a6f1d",
    "45433055-2b69-3cff-8135-67b3bfa04034",
    "460324ea-c769-38db-bba9-044643c8780e",
    "4619e709-c9c0-3b26-923f-23a78e231136",
    "4667e48c-4d16-38be-b277-6b0013d6588c",
    "4690ea1e-224a-35e9-a984-8332295f2b00",
    "46d917cd-531c-330b-8d7b-979b51a8927f",
    "47167c79-2ba4-369c-8db8-760a30b4c38a",
    "47358aac-2ec0-3d45-a837-f2069ca7cee3",
    "4766da89-ca13-3e92-b53e-00bc710e9bba",
    "47972731-b0ea-3c38-a10f-5ffdd42329fc",
    "48a52b7b-9391-3728-84f1-9aa6ca336214",
    "490f13c4-4c1f-3e3b-8a9f-0f27c6906b4e",
    "4935629c-fd9e-3b2f-b68e-9489c89585df",
    "4977e8a8-4e1f-3ca2-a44e-454cd3756a5f",
    "49a9df80-ab0a-31fb-9341-a79f7b0258dd",
    "49d76058-b4f0-3931-86fa-de160b4c1b88",
    "49e970c4-7364-33cb-a298-ead218e9a705",
    "4a789b07-7578-36ec-89cd-68b01e0737fb",
    "4aae26d1-aa71-30ae-b838-2a25d1f317f5",
    "4bab74cd-aba9-4752-9e1f-006cc639d63e",
    "4c18ef76-84ba-4a78-8275-7663101fffcf",
    "4d324eb4-39f1-3837-9b97-c10db5d2b61d",
    "4d7b84b9-0a03-3aa1-83f0-4766013c3fb1",
    "4d9e3bdf-7216-3161-8281-72863f3c2bf6",
    "4e1ac476-80a2-3612-bfd7-1abd24d2b644",
    "4e302e79-1cb9-358f-a3fb-e133a655af4f",
    "4e391f98-31a6-330d-9252-d02aab82f5db",
    "4eb237d9-9f8c-3426-9da6-4aad349ff8aa",
    "4f1b4bb2-b30b-3537-8fed-dd8f843f5adb",
    "4f363f6a-e51c-4d22-b232-cf78f1520966",
    "5037a27d-95f5-352f-9c64-5b8e75f574b2",
    "50d508e2-6753-4519-a8c3-ad94a76ee948",
    "511b93af-f16e-3195-8628-fbb972a17f74",
    "51e6b881-e5a1-30c8-ae2b-02891d5a54ce",
    "52c9e613-61b3-3d17-9f6d-b28de8a14829",
    "539b7a79-54c6-30ef-8e06-210d42c79125",
    "53a8391f-b2d7-341f-95ce-b9174d48e040",
    "53f5011b-2a8f-3a73-9d86-805462bb542d",
    "5426cd2f-f4b9-3660-99d2-6617bb0f1b26",
    "545ea917-a910-3013-a3f1-52a86dd6c8b1",
    "5481321f-d317-3e80-8061-6e9c635c4ca9",
    "54bc6dbc-ebfb-3fba-b5b3-57f88b4b79ca",
    "555a7659-ffce-39df-ba06-d9fcb2f812f0",
    "56c24ed8-68c5-3a08-8e3c-19646ac670e5",
    "57356998-297c-330a-af4e-c6a1ad64f923",
    "575d8d24-ba88-3b18-84c0-df5b29dccfde",
    "57636c80-9335-3aae-af70-11755db93854",
    "58a6bfcf-071e-3a6d-90f4-0e4cbdc298eb",
    "58d01358-5927-36fa-9e11-d18d1dc1f4f0",
    "595acd37-183c-489f-bb8a-c299a86b74c0",
    "595ec33e-a1aa-3aaf-8821-8d1780db354c",
    "59a668bc-5caf-3ccc-8335-e9cff4c61d0e",
    "5aed7fcd-651c-38a7-9523-9d48bf92aeaa",
    "5b1d8b11-4f90-3577-be0b-193e102fda82",
    "5bc5e7b0-4d90-3ac8-8ca8-f6037e1cf75c",
    "5bd6bd4d-3c89-3794-9935-2d044ce6ef37",
    "5c1db299-e2a2-35e5-84dd-acda8fb393bc",
    "5c7ee953-d8b0-33ef-a491-0bb716763cfe",
    "5ccb359a-2986-466c-88b2-a16f51774a8f",
    "5cf52bbe-f7f4-30c9-a4c2-a1fbb93513e4",
    "5d062611-5417-3405-997c-1d1aefe4d85f",
    "5d333477-796b-3e49-bf41-0cdbed39c8dd",
    "5d391e54-adec-3584-adf0-5025d7564e1b",
    "5d40499f-c9be-38b9-a0cb-cd234850ba85",
    "5d55a63a-3146-32d9-89ec-e207e95ecbde",
    "5d8f4b0a-27f8-3889-925f-e9a146a395eb",
    "5d9c1080-e6e9-3222-96a2-37ca7286a874",
    "5e9fc665-2353-34da-a2e7-2094ab17e790",
    "5f2b8881-3447-3905-99f8-def9d72aae42",
    "5f5a25ff-ea07-3133-b5c6-26fada93f90f",
    "5fe10166-ab1e-36d5-aa2b-c0d6f680f2c7",
    "614812d4-3344-3975-a1c8-4131910c4a10",
    "6180bbb1-95ce-381b-ba17-5411c5712824",
    "61e56102-4d85-3a40-bbba-1a007c816f68",
    "62879808-1586-4d49-80fe-2f547e355191",
    "62a1e53b-b55c-36c2-bc5b-e216d494875a",
    "633addf9-441c-35e7-868a-738aa612d51c",
    "639d4834-f922-3e27-9913-20aa649f815d",
    "63a006b5-07c8-375d-98e3-21466f5b9c6a",
    "63f32613-2856-4ab0-898d-f881d74eb8bf",
    "64037371-4aa4-3fed-97f4-bafc1674caee",
    "6419dcfd-8777-35fa-924c-ebefccde0a9b",
    "648e8393-f46f-384b-9bd1-c25a2285077d",
    "64b24fd1-f639-4f7e-a535-dbfe9fd737a1",
    "65732efc-1564-3ff8-8c7c-4239a08c0d70",
    "65d3f43d-1969-35d4-bf86-bd5e4b1ac803",
    "66a40dcc-4de0-3f72-bff0-ca543ac5019d",
    "67d00dd9-fd33-3518-85f5-e26353373c33",
    "67d5fb0a-baf8-32f4-9316-18ce755f3e8b",
    "6937b4e5-b5b4-3970-b5dd-9ad194e6c338",
    "69c0ec7c-e289-3c4d-ade3-d2287ec34026",
    "6aa2ac89-6b25-3af6-ad59-221351189f4b",
    "6aae7f38-21de-31bf-8761-29d458338958",
    "6b0cc3b0-2802-33a7-b885-f1f1409345ac",
    "6b14d7c0-20f9-390b-af38-507a5de5998c",
    "6bae6c0c-5296-376d-96bc-6c8dbe6693a5",
    "6c26dd11-e4a9-3d85-b118-09f65c6f0f2a",
    "6cc0bb26-5afb-3688-b237-b9c64c2800e5",
    "6d3bfbc9-45dc-316e-a94c-a441371d0571",
    "6dadba1d-0f67-345b-bc5e-407ab8f7654c",
    "6dc6e668-549e-33b8-b952-ed8e807b1d48",
    "6e106cf8-f6dd-38f6-89c8-9be7a71e7275",
    "6ee06433-4820-3211-999a-95b79b2c692e",
    "6ee14358-31cb-3c6d-82f5-54d6a20444de",
    "6f2f7d1e-8ded-35c5-ba83-3ca906b05127",
    "6fdd8d39-7b04-365a-9941-e9e805b05ecf",
    "6ff3a51a-e0ab-32be-beb5-4079e56933c6",
    "70e92418-e4e6-32a2-98c8-9844b1c24f92",
    "71283e26-905b-3811-b9e0-c10c0253769b",
    "713ac3dd-8777-373d-b87d-f3dd9820320e",
    "7186d7d2-453e-4193-b327-72b66bbe3fd0",
    "718a2f8d-954a-3cd8-89e6-43898cf21fee",
    "71d1938d-536e-39eb-beb4-bb4f5b607427",
    "71d95611-9032-3787-a66e-e26313b08d46",
    "723147da-6beb-34cc-b1d7-2d4d3abc4d33",
    "72ad5f22-3a9c-3758-81af-abda8181a622",
    "72c31859-3676-3cbb-a773-0591d8d5799e",
    "73539e96-eef2-3302-bdf4-a39e9d95b6e7",
    "737314f0-997a-3cd1-a652-78453bfe2b57",
    "73d86f1c-5e5c-3842-b671-7f29c78ccc55",
    "74648e09-358d-3183-9b40-278620befa40",
    "74a3e9ae-6811-4d11-a112-4c4963773cfe",
    "74dd5c1d-7a9a-32d1-903a-fc57e07109b9",
    "74ec2f62-9d57-39a9-bf88-97006f64ee5c",
    "74f15437-b85e-314a-9d86-7294b98bf07f",
    "75449af9-61a5-3a4f-95ec-3a3dc35b4cbb",
    "756f4ed0-5352-31e4-b3c6-2841b9e779d7",
    "75a9cbdf-0bec-39f9-b536-5b37aacadf96",
    "75e8adad-50a6-3245-8726-5e612db3d165",
    "76038978-47aa-30ed-bfa1-2d63753a866c",
    "768cf7e2-eb6c-3468-969e-e3b0fd87b34e",
    "76c3f58f-9003-3bdb-90a3-b87cfbfa1c3b",
    "770a58e6-eff6-39b7-a265-fe7f202fe8b2",
    "78cbd619-8ded-35b8-87a1-38c4f4aeb82d",
    "790d3c83-f6bf-348e-80e7-12f29240e598",
    "79cb0109-4c92-3ede-8849-76cc6824b95a",
    "79f3de22-c643-3e97-96d5-f77274a458c0",
    "7a1412d3-5a53-378f-85df-ba58b2408f46",
    "7a17d467-9f29-3706-8e40-32bb7fb033de",
    "7ad46cf0-aa12-4050-ac2d-cf34b5f64d41",
    "7b0bf9d6-084a-31d4-9e52-d9b582a0ec84",
    "7c30c3fc-ea17-38d8-9c52-c75ccb112253",
    "7c539ecc-658a-3956-a9a4-6e7f5bd67373",
    "7c5e3704-33c8-3a4e-b032-9187a6f90206",
    "7c696d35-e34f-38b0-b4b4-e88803ad1f6a",
    "7ca43466-7107-33ae-95d6-26d7af132e87",
    "7cb4b11f-3872-3825-83b5-622e1a2cdb28",
    "7ccdda39-69b1-36d1-89c8-2acc3823264b",
    "7cd08674-1787-37d9-9365-988df023724b",
    "7ce2a2ce-eed6-36d7-ba62-dda9acddb070",
    "7ce85124-312b-35f0-a1a2-32206f75a947",
    "7d1d720d-6708-3148-917a-b8dc78f1dcd9",
    "7d3f2f76-2f4f-3762-bf0f-f94f79eb0404",
    "7da33189-2698-3a98-b038-b0e5a271ee96",
    "7df1f32e-f059-3ac4-9d57-213f2f69b8b4",
    "7e3d8631-3b7d-38c1-b833-ee7cfa7235ca",
    "7ebbdbeb-a8de-3612-8f22-6ce91980841d",
    "7ef4a6cc-7266-3a31-8dd4-01c3d3c58dcb",
    "7f40c022-9f9d-3805-abf8-7533175b3f25",
    "7f7e4709-7596-35f9-89ac-d808178b1533",
    "8066e267-a653-3b43-8fce-a5a780912c82",
    "806d3ab3-4c53-30d6-ba6a-09ef6df5af5a",
    "80da8956-f418-319c-9f49-3d47d9002546",
    "80f31501-6533-3257-9870-b0c4dbf61967",
    "812a45e8-b5d9-389b-9151-09c57ce969df",
    "81700b3c-2db4-3f72-935c-274d3607d6d2",
    "8184872e-4203-3ff1-b716-af5fad9233ec",
    "81d2b40a-c579-3e9c-b520-bee26cda947d",
    "8223c3d0-3b08-3889-9cdc-a88592c4bd4a",
    "823371b1-3197-35d6-a6b7-bfd432e10440",
    "828ddef2-7609-3683-8e32-c21e7c07d6a6",
    "8346e544-4a73-3c88-9339-c7a21fbd3a2f",
    "83faae69-e37e-4804-b7a9-684d4a900320",
    "841fe537-5e76-3b3a-8298-75fa1a41a14b",
    "84bb4b17-e7f2-3a1b-8c2b-6d6ec9a23e31",
    "85026edc-5fdf-308e-a8ef-a1aad1151c50",
    "855908a6-a848-3b7b-a4a3-bbab78a423cd",
    "855ba280-cd69-348d-9107-69e28cb8ad99",
    "8606d399-57d4-3ae9-938b-db7b8fb7ef8c",
    "86519a39-4ce9-3d0b-a3f9-dd9aa26a2b25",
    "87918291-e9ba-3759-be1a-4c874ca40997",
    "87ce1d90-ca77-363b-a885-ec0ef6783847",
    "8858428d-8fd5-3c3f-8ca4-d01f6e25e63c",
    "88ebed6a-e9a4-3d60-9011-ec1df75cc8d6",
    "890cf3b7-3385-390c-8b2e-132c744b5d2d",
    "8911207d-fc3d-3009-bb35-18138197724f",
    "8934694e-8085-3673-96dd-eacebe691ed1",
    "8940f5f1-13e0-3094-99ba-da2d17639774",
    "89f79c55-6698-3037-bd2e-d40c81af169a",
    "8a0ff1a2-9045-3be3-b67f-3914d88178ec",
    "8a11791c-1d8f-3b12-bacc-38aa982b0003",
    "8aaa2fac-59f9-3a3d-98ee-f3dde8b4d781",
    "8aad8778-73ce-3fa0-93c7-804ac998667d",
    "8aeeeeca-6a79-34ef-b667-835d53536a8f",
    "8bc34c99-1b8f-3463-b0e7-12bf1eb222b3",
    "8beeb8db-28f9-396c-b752-17f906505948",
    "8c019de9-7043-37bc-9498-b5858e7240af",
    "8c52d911-fe34-3424-9864-d3fdfac38064",
    "8c54e429-a3de-3eb3-96f3-d3127e2cc18f",
    "8ca98d88-67b5-385e-80f7-b32758668fab",
    "8d8b550e-d0be-3cbb-a371-49ec36fa619f",
    "8de6abb6-6589-3da7-8e21-6ecc80004a36",
    "8e02e2db-2836-37ec-af33-a1cc2e6e49dc",
    "8e5022ed-87a9-4480-b2a7-a7c0494f5c7b",
    "8e5442cf-8882-3b94-bc47-18fcad84bb20",
    "8ee606e6-4cbd-3c07-8419-fbda836ccaac",
    "8f317f00-f8b4-325e-a5c7-e4045427a610",
    "8feb3dbe-4450-3aeb-b22b-e65128aa696b",
    "902d5e72-b665-3615-af2d-a2b6164864b2",
    "90f360d8-35f7-3c54-b2da-e99b354bc4cb",
    "9158b740-6527-3194-9953-6b7b3b28d544",
    "91923e20-9a05-32e0-ac53-8c09b0b60341",
    "919f13de-857f-3b1c-9f8e-7cbe500a60ae",
    "91cded81-9f72-3930-bab7-5d3e3fa0a220",
    "9239d493-31d7-3dd0-a05f-03d50a242392",
    "924116d9-0a48-3d97-b8c9-0d16b087c16a",
    "928e282f-d1a0-3e85-9582-0b33664c49e8",
    "931b76ee-63df-36f6-9f2e-7fb16f2ee721",
    "93582b51-5be1-30cd-abb0-3eac16dd6dbc",
    "937093d8-7966-3df3-b334-0835595412b6",
    "93b755f1-f865-44dc-a98d-cae5eb1a25d0",
    "93c97162-a834-3331-b15c-e4ab278b1c6d",
    "9441ffdd-f06e-36e0-839e-b836b0f19bc9",
    "945f3b20-778a-3581-adef-544de4a089ef",
    "953087a4-f704-37fe-a60f-82877e84a413",
    "95312039-73b9-35a2-9aec-905494a4f7f0",
    "956dd277-e000-4c6c-af4a-aee4d86971c9",
    "95a47a36-1041-3924-bbd0-4dcad52c323a",
    "95acebfe-c694-3dab-9e6d-01cb501ff426",
    "96284bbc-6b58-330f-a5a6-76cd518543f0",
    "968e77fb-9ab1-3427-8984-9e3028b186e2",
    "97738d01-b24f-365e-8818-2463149154d2",
    "9807c577-0dc0-3116-864b-cf46a1276389",
    "982bcae9-1840-37f4-9278-3dbb63031aac",
    "988ab841-c422-3d08-bb52-a09f8fdb6ab2",
    "98fd128c-4f32-40fc-a23c-7feb50c4478a",
    "991d11df-0265-3e41-b942-5b0c615d21e2",
    "9946b521-ea55-3c52-9fd1-71afc3abf3c6",
    "99a3270d-c5c5-3df7-9a2d-a612c8104d0e",
    "9a25fd14-783b-35c3-ab2d-df4687f82b5e",
    "9a372faa-e598-30e2-999f-99f90a0b099e",
    "9a8aea4b-9b61-3884-9f3c-84c3c36e6373",
    "9afab336-dbae-3f70-a669-46813f4570d7",
    "9b1da4e7-03a9-3277-91f3-ef6e610a6320",
    "9bdb4139-173f-33d3-8730-e29752d737d3",
    "9caf211e-3e6e-3996-8518-f617b9454e67",
    "9cdbe6f4-938f-4ac5-88f7-94a82bea715b",
    "9d65b03d-b59d-3a45-ba66-e313d3cdab40",
    "9e684390-4af3-3ec5-b163-855bbd026ff1",
    "9eb87a0b-2457-359d-b958-81e8583d8e44",
    "9ec8f3a2-59ba-3ce2-827d-656ea5bc1f1f",
    "9ecbfef8-29c6-334a-b4ff-aa8201439826",
    "9efe1171-6faf-3427-8451-8f6469f7678e",
    "9f6d282e-f573-31d5-80e6-9a193e80cd7d",
    "9fd55542-e982-361f-814f-61ad4ad07adf",
    "a059b6b9-ca26-4881-bcf7-d202433de0c2",
    "a0cb0614-ee71-3cf3-b891-a4274883362f",
    "a146ab19-f4f3-334f-b830-fc68de83e26c",
    "a1537c1c-775b-3969-ae13-2e83e5a4728a",
    "a160c635-aa67-352c-a5e6-03b113493090",
    "a1c1d559-0480-39d2-94f0-1a89f0226c4f",
    "a2f568b5-060f-33f0-9175-7e2062d86b6c",
    "a3001373-ae03-3827-8e25-3da1720074ca",
    "a359e053-a350-36cf-ab1d-a7980afaffa2",
    "a36f80a5-5edc-3842-80af-292ae639ee74",
    "a3876690-9d49-3c98-9421-02cfe0ccb551",
    "a3e09a66-a921-3c4a-89e6-7fecf6854a3a",
    "a3f59292-ad1d-370a-afde-64a9e16b341c",
    "a4087bac-8194-4c9e-8b2d-4bda58773a3c",
    "a47ba6a9-ffa1-3979-bb40-512339284b8b",
    "a4e62775-131f-37c4-9239-c38e3b254dad",
    "a4f240a0-12d4-3542-a11f-0c592e90e4da",
    "a4f72852-c2ff-35d3-8375-e52055508240",
    "a50b198c-4de2-3f8c-a2b9-ab280605b350",
    "a6817756-af01-32ec-829f-d9e56ef7b6e8",
    "a783b484-437b-3569-bd44-4f83ad9e05cf",
    "a7a2236e-8f8e-34aa-9343-722f9b3bb829",
    "a7bcdabb-f9b7-3c16-806d-3ddf1c2d49a2",
    "a7c9bb12-322e-3f8e-8798-cf57a4a72f99",
    "a88da814-ecc6-39c0-93ba-8a81f403a7e4",
    "a8a2fbc2-8e77-35a0-9208-f882c3cb2a5c",
    "a8a3297d-62f3-31ac-8db7-95ef53ce0d31",
    "a98c14bf-bf01-3ae5-992d-ea9f0a18e3c7",
    "a9a24c80-600f-3f85-b4d9-a70ceccad385",
    "aa105408-2974-35e7-ae76-35060cfde21a",
    "aa539866-29e4-353e-95a9-b6d321b53b33",
    "aa630060-2eda-37bd-ae88-a513fd9fc8e3",
    "aa82b61f-7156-3c68-95a4-b79cebd120eb",
    "ab3d8387-8e07-37f6-a74c-cf100fb6a612",
    "ab83611b-436e-3de7-aad1-f0c9ad254196",
    "ab8c747b-b9cb-3835-a275-54c56cb9a469",
    "abd4fe8d-7520-3b35-b8ac-4de367141b6f",
    "ac1b1697-42b9-4225-a666-d17f72204fa8",
    "ac3e33eb-5a53-369d-9e5a-7950392bfe99",
    "ad319b98-6faa-3648-98bd-43afdbd20020",
    "ad870270-f3d8-3790-866a-78d61b5b76ee",
    "adbb2a17-a503-32cd-a9ed-b523b3e4da0b",
    "adc1fad7-de31-371f-810b-140576d9accc",
    "adcf7d18-0510-35b0-a2fa-b4cea13a6d76",
    "aed1b616-9d9a-36d3-a047-07ad3955fbb7",
    "aedbd525-e6df-4c0c-8be6-61c27fe58fd6",
    "af170aac-8465-3d7b-82c5-64147e94af7d",
    "afbdd2e0-696a-3222-a20a-2023baf8e5af",
    "b0663029-8f8d-398a-8a28-81ba29224696",
    "b09ba294-96b3-3c45-aeed-c40a309e5f4e",
    "b1527e96-5a5d-3adc-a893-314ab3a6012e",
    "b1a98ad6-9b3e-35fb-afae-70b279fcbfc0",
    "b21b7285-2199-3264-b10a-524e9b23502a",
    "b275d09d-9da2-380b-a748-528ee28bc9af",
    "b28a3715-4624-3a54-9652-b8f0b293a5a8",
    "b29b43d7-3af9-363e-aaeb-8805d958f982",
    "b2a8a9aa-19cd-3ffd-b02c-0f2a47d1d0eb",
    "b403f8a3-4cad-333e-8557-d7da2e163f4b",
    "b436606f-daa4-337f-8103-4360bf4704d9",
    "b43d449e-daaf-33a1-bb7f-3f7a0b5f056c",
    "b48d6d4b-f0dd-35da-850d-36a715691e2f",
    "b4d5e738-b937-33fd-8131-bf1df36f598a",
    "b4fc7eef-819c-35a6-b937-358ffb5c2aa0",
    "b51561d9-08b0-3599-bc78-016f1441bb91",
    "b56e3f47-72a6-34e8-9ada-b4169e28e5b9",
    "b5a1b0b0-a7fc-3a47-af82-9b25a81a8c0b",
    "b5e6e498-54b3-37bb-b2a3-cdac33a18363",
    "b5ea60b0-2540-4efe-b60e-f421ade3c128",
    "b5f3900c-b421-3032-aef2-2e91a69d1163",
    "b6642e23-d100-3680-8882-9f3b753b2eef",
    "b66a9b8e-8fa8-3409-907f-a70ebd7051e1",
    "b6c04ab6-1c07-3e17-97d5-e870db090e52",
    "b6c86134-d7e6-3af6-9db5-8aba3df4f7a7",
    "b7843066-abbd-3275-ac52-90a8363f65f7",
    "b7fbc13b-47ff-3e3f-a363-86d60ba664b8",
    "b81922e7-092f-3052-8cd1-fec6a6763295",
    "b8a5a7a9-1c4f-4f2e-96a6-565e727b24d0",
    "b8ce75e5-c1d2-3447-9249-70ab3d42389f",
    "b8d83d8e-1574-3efd-b067-a3ed422a259e",
    "b98a7838-ac1f-339f-93c5-fe7f98ea8657",
    "b9b1564c-66d0-4597-a664-2735cf2ffd04",
    "b9f73e2a-292a-3876-b363-3ebb94584c7a",
    "b9fcb487-363e-30a7-a316-a42dd81d8fe5",
    "ba66bb3c-5437-4bc6-afe3-299109e5ced4",
    "ba737c78-2ef2-3643-a5b2-4804dfff9d93",
    "bb110668-5037-3c04-bd34-34cf1ace8d0f",
    "bb25d7d0-9146-46a0-8ff1-ebfc25d63417",
    "bb533c69-1e0b-341c-bedd-ff25fe9b84bf",
    "bb9be2e6-8f0e-3bb3-8bb9-5d9aa9df384d",
    "bba89165-0e5d-3052-abb6-6a61e37861a3",
    "bbdb1e21-62eb-3230-8cef-a3b091c5edad",
    "bd4a7d9d-14e1-3c17-873d-a74d0cd6a5d7",
    "bd73bd15-8a42-3aa9-8eb7-cff9f894d43b",
    "bd9636d2-7220-3585-9c7d-4acaea167b71",
    "bdd7e8ba-f7fa-38d1-b6bf-9dc77334fec5",
    "be94abe3-f84c-34d6-8461-3105bcfcedb7",
    "bec0f69b-832c-3898-b589-0127ddc282f3",
    "bee1146d-2e80-37e3-b08a-6ac8858e8973",
    "bffb0c9e-5e3a-3251-ab5e-299491b53cbf",
    "c049334b-5568-3ca0-9b28-0c09d00b7bb3",
    "c062ba0f-7591-3225-a57d-8181622dc2da",
    "c08279c0-10b4-3d21-b13f-a1c1a0b87f8b",
    "c0d36fde-5672-430a-9dd1-3e2a5d4f6cab",
    "c1a6c20c-e336-3efa-81b6-7c1242d70bd2",
    "c2c0e6bc-05e5-30dd-8e5e-0e7b6106ad30",
    "c2ec8955-1797-338f-9486-d7c41926f791",
    "c2f301b6-5d19-3296-a8ac-418ff48e052b",
    "c453a8e7-d3da-317a-946b-f8e9678a8582",
    "c4ea1b05-c7d5-3b59-aed1-9f3d2621ac00",
    "c556f8e0-a001-3586-b2cf-d3256685c39f",
    "c654b457-11d4-393c-a638-188855c8f2e5",
    "c67a748c-1e93-3a6d-be38-daedf175f911",
    "c67f439a-f945-33cb-8517-40c9fdf60d59",
    "c6940de1-dccf-3b42-9c39-bbb9feb2d638",
    "c69e348a-8e10-31dc-b71b-dd8e5cfd7211",
    "c6c55112-0078-3867-a63f-1861a0125b8d",
    "c70b2c64-7a9a-37c5-b974-709fa0536675",
    "c71cd96c-8e3f-3861-9ece-fcbabebc63a8",
    "c730e199-fb8d-3abf-b7aa-bbc81bf8c08f",
    "c780d53a-2d37-3cd8-9e89-530966aef53e",
    "c7f5e5c1-dc52-3619-8998-420b2e280d8a",
    "c858bd6a-81ab-3f54-b46d-ffc091ef6945",
    "c85ebc24-0934-3423-9c14-f0fdbee64b68",
    "c8cdffb0-7942-3ff5-9f71-210e095e1d31",
    "c93a30c8-168c-386c-a25a-cbd8d8410fbe",
    "c94991c0-3662-3936-972c-1af63db486d8",
    "c96a09c8-46ed-391f-8a66-c46fa8b76029",
    "c990cafc-f96c-3107-b213-01d217b11272",
    "ca4144fb-10e5-3895-836f-87001f59ac65",
    "caabc342-aed4-3104-8195-7461a4add481",
    "ccb4e29d-e88f-3fbe-8958-67cfd62350a3",
    "cd2353c2-0fb6-3e18-8281-4c0df1d3189a",
    "cd822baf-4aa1-33fa-bfe5-d91386598edb",
    "cd83b7cd-e2e7-34f6-bee7-1ff5ca3ed665",
    "cdd752d0-caee-3d95-b1db-7fc20cbbc783",
    "ce0575bf-c2fc-38bd-9947-ea7494a799f9",
    "ce0e814a-d9df-3975-a521-d8ae9a091e96",
    "ce34ff64-0faa-3fae-a79e-985f7a5172c9",
    "ce5033ee-e74e-354a-9299-8aaefbd03f59",
    "cea5f5c2-e786-30f5-8305-baead8923063",
    "cf6a99cb-b8bc-34d7-bdca-30e50e66cd74",
    "d0828f48-3e67-3136-9c70-1f99968c8280",
    "d0ba7a1b-f5ca-39d6-98d0-29c671baec65",
    "d0cc23f4-f4ab-3755-8e63-2e3940f68d89",
    "d1695c5e-08a9-44fd-8f45-93c23f700c8b",
    "d201af7e-48c8-34ad-be1c-e649af2cb5c2",
    "d20c3612-a64d-3aa8-bd4a-58890413afbb",
    "d26b95e4-d200-34e2-92c9-c16fda4cd9dd",
    "d2901fe5-4b64-3144-98e1-67ef5ef83fa7",
    "d2c6775c-e0a0-3460-b1b8-8d0ce2e0ae4e",
    "d33f667d-7b6c-39aa-9ba9-eac2fa615ae1",
    "d37be0e2-8223-3eeb-a0e2-c4b75d5ff87b",
    "d3dc783e-663a-31b1-bd85-46e04ca693db",
    "d3efe9ba-f10a-35e7-b17e-6850c66693fe",
    "d47507ce-b079-395e-8761-8e70818ea69a",
    "d551b8f9-feab-3946-9524-219e07988341",
    "d58d55ea-f30c-3622-8303-1574616b9865",
    "d5d40b4c-48d9-3b68-903a-025eb0fa334d",
    "d6ba4898-1369-3521-981c-b9ac57420418",
    "d72c43a5-95bf-3a3e-9019-cf25cc0a61c0",
    "d78b78a0-2322-32c2-833a-e42ddc132d30",
    "d842ce41-8d9c-3c0f-9c04-595d97be5140",
    "d8bd6071-f3ae-31fd-866a-9e6e4d6519e2",
    "d9530d0a-b83e-44a3-910a-2b5bb8f1fb80",
    "d97ae2c0-b8d1-341c-94b7-f19d5fd2982a",
    "d9c267be-f19a-3183-afe0-f0625a375743",
    "d9fd666a-8f55-38bb-8387-80fa44c29348",
    "da30abcf-652b-38df-a128-10942b225ec5",
    "dad3e145-2f70-357f-813e-703936927fe2",
    "db17141d-4d35-381d-9949-36ce767d6641",
    "db447b86-8103-3ee4-93de-2c838ba061dc",
    "dbe19bf6-93ad-372e-b96d-f7b652cdba93",
    "dc3d4b79-6cd8-324b-bc70-cbd0e2a066da",
    "dc4d148d-f84c-307c-b2b7-f0cd7c267f57",
    "dc9c2d63-083f-32c3-90ff-943ca823a245",
    "dd251cc5-736d-3b76-8ad3-3f6cb138178e",
    "de43d0b6-d6a7-38de-9709-883e10320267",
    "de586ff4-3413-367d-befc-ad022b73592b",
    "debbba6b-8cb8-3ab6-adfe-54fcc6b02839",
    "df1935dc-1e5f-3f4d-bdcb-e6c2bcb07667",
    "df321672-461c-361b-aac9-e81cc9a88b9f",
    "df5d0b0e-5bcb-304a-a167-18b92d0f1d45",
    "df738339-958b-31fb-8e48-a4380f4c538a",
    "e033cc8e-b23d-3fc6-8954-d90c5e98550e",
    "e0ba7664-d287-39df-8193-00d60cae1417",
    "e0cfd042-ae29-3d21-bb47-81eb8f933ec8",
    "e0d2fe70-8f98-3ce2-8d8f-4268a81f7169",
    "e10475f7-0d56-3a75-870d-d4206fa165d7",
    "e123ba3f-99bd-3039-b6e7-8c62eaebf9c2",
    "e125bb91-dcaf-3013-9cc7-da653d7e11e1",
    "e1450d07-faed-3d97-b674-c6f8d2498d80",
    "e1e9d341-716f-3613-9ec2-2201c72361af",
    "e1f37027-6a39-3eb1-b38a-3f2836b84735",
    "e2043284-6122-3cc9-a7e7-f091a16361b7",
    "e28c16d0-084a-3dc4-aad4-9d157ca528de",
    "e2de16b1-0ae9-39ad-82fd-edcabb26feca",
    "e331aa95-3660-3c71-be9e-030bab0b8ee2",
    "e38c1e1d-f0e9-3d73-8193-29cbea481b4c",
    "e3a935bf-1428-32a4-8d53-caa71ee3de8f",
    "e40d67c5-3749-397e-aa2a-7dfe576a31b0",
    "e424d4f7-4b28-322f-b630-31d42ae528eb",
    "e4279e3e-b7e1-3f43-aeef-2bfa2836dab6",
    "e453f164-dd36-3f1a-9471-05c2627cbaa5",
    "e4d53680-f7ef-364b-91a4-00e5aa91ab9b",
    "e4f6dbab-f2eb-3bd2-9dbc-88640e3b4a5f",
    "e5178032-d260-3bc8-968e-a5cb98b6ae5a",
    "e574050e-f787-3186-9686-2e9aca8102a0",
    "e65e405c-8aea-30f5-a926-1e0fbbeefb9f",
    "e66d1403-755b-3f63-938b-a2a69446a48a",
    "e68d1f0d-eb44-3751-975d-f80609f695ae",
    "e743b441-ea8a-36d7-8124-f14dfa13a0e6",
    "e7547e4c-1ebc-3428-8964-a5b91e81098e",
    "e757cddd-5ff5-305a-af11-d7c6747d3979",
    "e7e178aa-931a-4674-9bff-9278a54e6aae",
    "e7e7ebad-79d2-3ae1-95ce-f3035bc8f719",
    "e88132d0-4512-3d6f-a1c8-f60972332af5",
    "e94f58d9-177b-31be-aa05-e6dd10d04124",
    "ea6895f2-504b-37b5-bfd0-cbf7017f22c3",
    "eaaf5ad3-2cec-3369-b3d1-97c737ecaf19",
    "eb142141-683a-3a6d-a207-0302b1ff260d",
    "eb222d5d-0052-3ce7-9b87-19e09054a2c0",
    "eb69a196-fb43-3ddf-9bbe-9d55fa1e8200",
    "eb777faa-5b76-387e-a408-90524c6f2848",
    "ebece6dc-ec92-326f-97ed-f66b2970e358",
    "ec02cf7e-36d3-3e9d-8835-3b6c27975bea",
    "ec3133b4-2b17-3d49-b78a-4bc480ac5137",
    "ed6ad297-ee09-3532-bcfc-c16ad5a05c49",
    "ed93e1bb-7bbc-3444-8fc8-08a271438fc8",
    "ede387f4-f390-3f0e-a071-eb543b73ed73",
    "edf3a727-664e-38be-b990-65d34012d926",
    "ee27a871-85cf-494c-8519-f54815040af5",
    "eec8ae97-8de4-354a-b11a-d3a14b276479",
    "eed8593d-60e3-3e41-9fea-55f544b01749",
    "ef4a46c4-138e-3478-b94e-3e60a567ec7d",
    "ef625e46-d0d4-38b9-9403-5614e7b39ec8",
    "f03bfd11-5ba2-3bc6-ad76-4166b06491f5",
    "f110598d-7e01-3ed7-a227-4e958987a31f",
    "f150d98f-0109-3380-8480-c6846fb8e9c8",
    "f2b0585b-ada3-3123-963e-14df7d96ca9e",
    "f303e577-a888-30db-97f7-ed36c90227e1",
    "f3cc42c7-84a8-35c5-8683-13878bb9beeb",
    "f3d1e3c3-2770-3504-a592-b62619598812",
    "f3f8f680-e471-3662-a06a-0c00e6d88f43",
    "f41d0e8f-856e-3f7d-a3f9-ff5ba7c8e06d",
    "f46707f9-435f-3a06-9017-deae11feab53",
    "f4c6ade0-7b9e-4ad7-8d86-13d2f4c91499",
    "f4cb6ba4-cd0f-30cc-9cc9-52bd14bfb3cc",
    "f4d1a3c3-5002-336b-a67f-775b3725237e",
    "f54c1d50-48a3-4651-bfb0-50b87f13dc9e",
    "f5a3ee79-a131-3f8a-91e9-a6475d778149",
    "f61bcee1-2964-3c4b-95a5-697df5f42f47",
    "f6350a4f-eee8-31bd-8520-28f9c81c98a8",
    "f648b945-6c70-3105-bd23-9502894e37d4",
    "f64ed43e-417a-31ad-a322-b6108bf99a71",
    "f7cdc2d1-f59a-30a2-aae8-8bb81c769e6e",
    "f7cf93d8-f7bd-3799-8500-fbe842a96f63",
    "f8412dbd-48b9-39f3-b534-08950f6e633b",
    "f84b4941-8e99-3957-b6f6-db1590338cf6",
    "f8825b65-5631-3417-8309-bd5677d694aa",
    "f9f6a7e9-4f79-3fdf-b1a7-ba300622f116",
    "fa708289-f2b2-399e-989e-53f83fa379c5",
    "fa9ec72a-cbcf-35dc-be20-4d0d9e7215ef",
    "fac8a63c-6b75-39d0-9f57-4344fde0f794",
    "fb0c5970-dbf7-4c77-b3b6-2c8cc41b9d6f",
    "fb149ce0-7706-3bb5-9860-8c63d1c77592",
    "fb2cce69-655d-3203-990a-74301895408d",
    "fb720691-1736-3fa2-940b-07b97603efc6",
    "fd4e2c4c-f7e9-3110-8e32-28d3add3937d",
    "fd5c6932-2ee2-3cfb-9bdc-0b30bfb33a91",
    "fdb0578d-4fa7-37a7-b60d-5472b4d39136",
    "fdc0f552-4976-36a6-8691-9a8c6a5ba389",
    "ff52c01e-3d7b-32b1-b6a1-bcff3459ccdd",
    "ff6adc87-5f47-32f7-b36a-546453c0e332",
    "ff8e7fdb-1073-3592-ba5e-8111bc3ce48b",
)
VAL: Final[Tuple[str, ...]] = (
    "02678d04-cc9f-3148-9f95-1ba66347dff9",
    "02a00399-3857-444e-8db3-a8f58489c394",
    "04994d08-156c-3018-9717-ba0e29be8153",
    "05fa5048-f355-3274-b565-c0ddc547b315",
    "070bbf42-31d3-3aa9-aca4-c262afc9077d",
    "0aa4e8f5-2f9a-39a1-8f80-c2fdde4405a2",
    "0b5142c1-420b-3fea-9e98-b87327ae22c6",
    "0b86f508-5df9-4a46-bc59-5b9536dbde9f",
    "0bae3b5e-417d-3b03-abaa-806b433233b8",
    "0c3bad78-9f1e-395d-a376-2eb7499229fd",
    "0fb7276f-ecb5-3e5b-87a8-cc74c709c715",
    "11ba4e81-c26f-3cd1-827d-b6913bcef64e",
    "15ec0778-826e-3ed7-9775-54fbf66997f4",
    "182ba3f7-b89a-36cc-ae40-32a341b0d3e9",
    "185d3943-dd15-397a-8b2e-69cd86628fb7",
    "19350c96-623d-4d77-af96-f8c23f00c358",
    "19f53e16-9f99-3035-9672-7e860f3b0048",
    "1da4a0aa-22ae-3958-856d-05303de1f576",
    "1f434d15-8745-3fba-9c3e-ccb026688397",
    "201fe83b-7dd7-38f4-9d26-7b4a668638a9",
    "20bcd747-ef60-391a-9f4a-ae99f049c260",
    "20d47f81-46e8-3adf-a0ca-564fbb5c599d",
    "20dd185d-b4eb-3024-a17a-b4e5d8b15b65",
    "214e388e-cbd7-3dde-a204-d2ec42298808",
    "22052525-4f85-3fe8-9d7d-000a9fffce36",
    "24642607-2a51-384a-90a7-228067956d05",
    "25e5c600-36fe-3245-9cc0-40ef91620c22",
    "27be7d34-ecb4-377b-8477-ccfd7cf4d0bc",
    "27c03d98-6ac3-38a3-ba5e-102b184d01ef",
    "280269f9-6111-311d-b351-ce9f63f88c81",
    "29a00842-ead2-3050-b587-c5ef507e4125",
    "2c652f9e-8db8-3572-aa49-fae1344a875b",
    "2e3f2ae7-9ab9-3aef-a3ce-a0a97a0cb1ab",
    "2f2321d2-7912-3567-a789-25e46a145bda",
    "2ff4f798-78d9-3384-87e9-61928aa4cb6d",
    "335aabef-269e-3211-a99d-2c3a3a8f8475",
    "36aec72e-5086-376c-b109-295b128e77e1",
    "3b3570b4-7b0b-3268-a571-b0889dbf40b6",
    "3bffdcff-c3a7-38b6-a0f2-64196d130958",
    "3de5b5d6-68c4-3c95-84ed-be7c83d829f8",
    "42f92807-0c5e-3397-bd45-9d5303b4db2a",
    "44adf4c4-6064-362f-94d3-323ed42cfda9",
    "47286726-5dd4-4e26-bd2d-5324f429e445",
    "472a240a-10cd-39cd-8681-558f7c7cf868",
    "4c33fc38-5e59-34f8-96ba-4e5a404d3988",
    "4e3fedbb-847c-3d5b-8a62-c9ff84550985",
    "51bbdd4d-3065-34ae-b369-b6e0444f34db",
    "52071780-5758-3ed4-8835-0d64ecdc5575",
    "52971a8a-ed62-3bfd-bcd4-ca3308b594e0",
    "544a8102-0ef5-3044-921e-dc0544370376",
    "5589de60-1727-3e3f-9423-33437fc5da4b",
    "58e82365-03bc-3b2f-b55a-a4ad0e3e792d",
    "58fed0d4-97d5-469b-89a4-4394838e10c7",
    "5c0584a3-52a6-3029-b6ff-ca45a19d8aa6",
    "5f278cdd-ca28-3c53-8f5c-04e62308811d",
    "5f8f4a26-59b1-3f70-bcab-b5e3e615d3bc",
    "65387aee-4490-38b9-8f4f-1fc43bd4ac06",
    "6803104a-bb06-402e-8471-e5af492db0a8",
    "6aaf5b08-9f84-3a2e-8a32-2e50e5e11a3c",
    "6c932547-4c11-31d7-b8ef-0c16a13dbfc3",
    "6f128f23-ee40-3ea9-8c50-c9cdb9d3e8b6",
    "7039e410-b5ab-35aa-96bc-2c4b89d3c5e3",
    "72cf3ca1-1a9e-3254-bca0-29c62521e454",
    "7606de8d-486c-4916-9cbb-002ee966f834",
    "76916359-96f4-3274-81fe-bb145d497c11",
    "77574006-881f-3bc8-bbb6-81d79cf02d83",
    "78683234-e6f1-3e4e-af52-6f839254e4c0",
    "78da7b7e-8ddf-3c7d-8716-eaa890106dd3",
    "78f7cb5c-9d51-34f0-b356-9b3d83263c75",
    "7a2c222d-addc-30b2-aac6-596cb65a22e3",
    "7dbc2eac-5871-3480-b322-246e03d954d2",
    "7de2e535-81df-3d5f-a5ca-62e4b940eb54",
    "7e4d67b3-c3cc-3288-afe5-043602ea3c70",
    "7fab2350-7eaf-3b7e-a39d-6937a4c1bede",
    "858d739b-a0ba-35aa-bafc-4f7988bcad17",
    "8749f79f-a30b-3c3f-8a44-dbfa682bbef1",
    "87ca3d9f-f317-3efb-b1cb-aaaf525227e5",
    "88f47a10-87b4-3ea8-a0c7-a07d825b647d",
    "91aab547-1912-3b8e-8e7f-df3b202147bf",
    "92b900b1-ac4a-3d41-b118-e42c66382c91",
    "95bf6003-7068-3a78-a0c0-9e470a06e60f",
    "96dd6923-994c-3afe-9830-b15bdfd60f64",
    "9a448a80-0e9a-3bf0-90f3-21750dfef55a",
    "9bb1f857-8b61-369f-a537-484c1323ae32",
    "9e9bcfb7-601d-3d80-bc12-ef7025174beb",
    "9f871fb4-3b8e-34b3-9161-ed961e71a6da",
    "a060c4c1-b9fc-39c1-9d30-d93a124c9066",
    "a1589ae2-2678-310e-91cc-c4b512cd7fa5",
    "a33a44fb-6008-3dc2-b7c5-2d27b70741e8",
    "a7636fca-4d9e-3052-bef2-af0ce5d1df74",
    "a91d4c7b-bf55-3a0e-9eba-1a43577bcca8",
    "adf9a841-e0db-30ab-b5b3-bf0b61658e1e",
    "b19f3c1a-a84a-3a2d-8d1b-8a4ae201020b",
    "b2053fdc-0b94-30bc-aee7-5bc6fb7e9f52",
    "b213af37-7d89-342d-ae39-8a3c72159a01",
    "b50c4763-5d1e-37f4-a009-2244aeebabcd",
    "b5a7ff7e-d74a-3be6-b95d-3fc0042215f6",
    "b6500255-eba3-3f77-acfd-626c07aa8621",
    "b6e967f6-92bc-3bf5-99c9-1b0c4649fd67",
    "b8489c02-60d0-3f44-a3b4-9de62830d666",
    "b87683ae-14c5-321f-8af3-623e7bafc3a7",
    "ba67827f-6b99-3d2a-96ab-7c829eb999bb",
    "bbd19ca1-805a-3c22-8df3-cd7501aa06f3",
    "bd90cd1a-38b6-33b7-adec-ba7d4207a8c0",
    "bdb9d309-f14b-3ff6-ad1f-5d3f3f95a13e",
    "bf360aeb-1bbd-3c1e-b143-09cf83e4f2e4",
    "bf382949-3515-3c16-b505-319442937a43",
    "c222c78d-b574-4b9d-82e1-96a4f3f8bb27",
    "c2d44a70-9fd4-3298-ad0a-c4c9712e6f1e",
    "c85a88a8-c916-30a7-923c-0c66bd3ebbd3",
    "c865c156-0f26-411c-a16c-be985333f675",
    "c8ec7be0-92aa-3222-946e-fbcf398c841e",
    "cae56e40-8470-3c9c-af75-6e444189488f",
    "cd22abca-9150-3279-87a4-cb00ba517372",
    "cf5aaa11-4f92-3377-a7a2-861f305023eb",
    "d1395998-7e8a-417d-91e9-5ca6ec045ee1",
    "d3ca0450-2167-38fb-b34b-449741cb38f3",
    "d46ff5df-95e8-32da-a0d7-87f7b976a959",
    "d5d6f11c-3026-3e0e-9d67-c111233e22de",
    "d5fa4d54-74ba-369c-a758-636441ad7f07",
    "d770f926-bca8-31de-9790-73fbb7b6a890",
    "d89f80be-76d0-3853-8daa-76605cf4ce5e",
    "da036982-92bf-36a8-b880-4ccf4e20b74e",
    "dafe14f5-825c-4e7a-9009-6dfdfdd5b030",
    "dc9077b9-2fe0-3d18-9b97-8067ff090874",
    "de56b100-508b-3479-81fe-735349f8e8de",
    "de9cf513-a0cd-3389-bc79-3f9f6f261317",
    "ded5ef6e-46ea-3a66-9180-18a6fa0a2db4",
    "dfc32963-1524-34f4-9f5e-0292f0f223ae",
    "dfc6d65f-20f5-389d-a5cd-81c1c7ecb11f",
    "e0ea281b-6956-3605-b720-71b54ec87d25",
    "e13c06cb-cd01-380e-946f-6d92ac1af49d",
    "e1d68dde-22a9-3918-a526-0850b21ff2eb",
    "e2e921fe-e489-3656-a0a2-5e17bd399ddf",
    "e42aa296-0e5d-4733-87ec-131a82f917bc",
    "e50e7698-de3d-355f-aca2-eddd09c09533",
    "e72ef05c-8b94-3885-a34f-fff3b2b954b4",
    "e8c9fd64-fdd2-422d-a2a2-6f47500d1d12",
    "ecbe6def-7560-352c-8822-b2b92613e1e4",
    "eec284b2-840a-3c75-aa42-04d2e309bbe1",
    "f1275002-842e-3571-8f7d-05816bc7cf56",
    "f2576c8a-da9b-450e-88cf-a70af1b0eadf",
    "f292cc5c-7a90-360d-b62a-074c643bdf59",
    "f3cd0d0d-8b71-3266-9732-d9f0d5778eb6",
    "f4c94798-4d77-36ab-bdc5-c1194e5e7aff",
    "f668074d-d6c6-3ea7-a7b5-aad0a1203b03",
    "f6cc0ebf-fc6a-3bf2-8bcb-76d8c43f194e",
    "fbd62533-2d32-3c95-8590-7fd81bd68c87",
    "fbee355f-8878-31fa-8ac8-b9a45a3f130a",
    "ff0dbfc5-8a7b-3a6e-8936-e5e812e45408",
)
TEST: Final[Tuple[str, ...]] = (
    "0c6e62d7-bdfa-3061-8d3d-03b13aa21f68",
    "0f0cdd79-bc6c-35cd-9d99-7ae2fc7e165c",
    "0fdbd56a-1ff7-3624-81f9-03cd68fd5616",
    "11a84740-18a3-3798-91c5-21dc9c765350",
    "131bd3d9-4f85-3ba3-b569-eb88308d79d5",
    "14896a70-a440-34d0-b68e-fd9882557da6",
    "1613c3d4-6350-37dc-9633-17125d9b6083",
    "1ad57a00-cc61-3f5f-9e2a-9981a57e9856",
    "1bd7db3a-0b42-31cf-ac1a-de88fd9fa721",
    "1c8648f9-e7a1-3056-a2c0-19c8827a6a50",
    "1ca5291b-3178-3a93-a117-001497899b79",
    "1eb3360f-4c34-3310-9ce6-845ea9272c56",
    "21c0472c-5ba2-3276-aad4-b9aa66cb5fa3",
    "28bd43de-e2b7-3c60-a626-0e525f639357",
    "295c7cd1-afe3-3dc3-be31-c63f3e9d65dc",
    "2a930061-3d8c-3915-8aac-f81199db95d8",
    "2d403b7b-06e8-320c-b013-4f684ad53be2",
    "2ddc4ec4-99ea-35a4-9f5a-e036df1c0b25",
    "2e95b33b-8ea1-3b48-875b-2f35f3092059",
    "2ee0eda7-151a-3957-bab5-1e5370192122",
    "307e27f2-6442-39a2-b62c-1e3d000cebaf",
    "30e94a6b-ca9e-3d2c-9099-86700ce845f9",
    "32835bfa-e53b-3526-9ec0-b0efcd11cbdf",
    "34c79495-dbdf-393d-bcc6-e6f92f797628",
    "3503b283-fbcd-3835-8779-0cb2b7ef55b0",
    "386c34fc-ff56-371c-9288-6ba42620f23a",
    "399064b4-6df3-3de8-8793-2738f8723ee3",
    "3fca5366-2b2c-387b-b63c-7ae8f9e0cec1",
    "412ccada-28df-3de2-b394-9cba3fca5bdf",
    "416f2e1c-0ffd-3089-97d2-0514b818f8d1",
    "418da7f6-88e4-388b-a69f-44cabd24ed55",
    "44e49f1b-17e1-3da6-9b8b-97e754d58f7a",
    "45488531-3648-3e2d-8f9c-3c287032112d",
    "4612f4a4-59b0-37d4-b3d1-400a1324920c",
    "48c9cd36-68bf-3bb9-ab95-5e0a6fee61ab",
    "4a60c567-f167-3890-aa7e-01e75ccc40e0",
    "4a78c5db-041b-347b-9821-ceb82f99e3f8",
    "4abe4fc9-183a-3ec1-9434-bc74fb724c0f",
    "4b6fd841-5e08-30cd-b61b-d51aa36d71dd",
    "4bf8e9ff-e1a1-3a22-a9d1-80f3846c0263",
    "4d73c4eb-5de9-300c-b34f-ff5d0af89653",
    "4e6d6bcd-8718-3e71-b9c1-7c352c991a56",
    "4fae2ef6-7112-309a-b926-448a5a3e1802",
    "4fcdebe7-b52f-39e7-a5bc-c664eeba5e7b",
    "5133fc11-ecb7-318d-8338-6502d2390f24",
    "51428934-b0a7-3507-94e3-31d37bba38a3",
    "5546df9c-9310-3ed5-929a-d7da19e18bf8",
    "557dd6a4-2b80-3264-9c13-f70094526174",
    "5677a441-abd2-3b29-9f0b-333e181cc907",
    "5b614cfd-21c2-3b03-94c8-2a6c6bee166c",
    "5c0afbc0-a6ee-37c2-aebd-c1927caf7340",
    "5ea3cd9c-15d0-3b80-9cc4-02c8b5ad523a",
    "5f016e44-0f38-3837-9111-58ec18d1a5e6",
    "613558a1-6a8e-3fda-8fa6-1045a064a0f9",
    "65f1eefa-cbc3-3d53-9991-dc0500ae9183",
    "6626b7b2-bcc8-4497-ae92-307ceacd5010",
    "677c7bcc-f29b-34ae-a91d-74cb863117c8",
    "6784f175-e69d-3802-99df-d21ec2081878",
    "67be173f-28a9-3bcc-b110-4b81dfe3bf5e",
    "6a6e93f0-a130-3340-975b-b2c88b16d343",
    "6b012ed3-c322-3522-b52c-b4f24f894d4c",
    "6b6b2e8b-3f4d-3b7d-acaa-8f970cb12adb",
    "6da5d01e-54a7-3d7a-b86b-e0d6f8d3971d",
    "6ef553eb-6dbb-3a2a-ae3e-ed7090b8826a",
    "6f3dbf4b-9559-340c-a3e4-cbe655bf2059",
    "6fa5051b-0220-3e04-8ae3-7a199c2f5877",
    "7905533a-694b-35db-b39f-aec9e33fb3de",
    "798354fc-30ee-36f4-83b4-f49c3b307db5",
    "7a8ec82c-1149-308b-8a12-477460843f35",
    "7b7f86ca-b430-3872-a131-ff5b4a6b5dcf",
    "7c4e5ad1-d604-3e44-81ae-68f7bfe21d27",
    "7e48bba5-438c-3813-9ce2-97c98868afed",
    "803c44cc-e1de-3797-9b5f-15324a1604f8",
    "840b2b3f-5f52-32ae-b833-ad030063533d",
    "84c98474-28d8-309e-91c7-9cf9539825ab",
    "84ed050c-635f-36ec-9c28-8a0c10f5cf11",
    "87621780-827a-3df5-8fa5-a94267d2d807",
    "87e61f5a-083c-305e-9ff4-5f699e85900a",
    "91ac892f-d2c1-3143-b5c5-f0d4640cfc0d",
    "9282db22-c361-3456-a7b5-414959f5f25e",
    "9320afa3-ed05-3364-a017-ae7ddc5d26c7",
    "97ae6596-a903-3045-836b-34f8206c6cfe",
    "98e7f0eb-4676-3120-94f1-8a790581e6a4",
    "9a82e3c8-1738-3f85-9245-1d3717171d2f",
    "9ad6d7f8-0173-302a-a1ac-de99ef600dd2",
    "9d16e76e-46ae-38c6-8399-99218514afde",
    "9da07440-1001-3b00-a29f-c8bdc2f2b7d4",
    "a1358c59-b28d-3ddb-af1c-3a5d1c394ef5",
    "a315b370-623a-3e19-8ffb-ba62661286ae",
    "a4400a38-bc38-391c-b102-ba385d7e475e",
    "a674e2e5-3dfd-3dd5-8503-192357b0e96c",
    "a69fa035-5121-3a39-a3ce-e33e9f54b506",
    "a7f532a3-87de-3129-8864-258396fd0b50",
    "a86ee261-b86b-34f7-92ab-be8367d1fc4c",
    "a89557fc-1268-36e5-9cce-335f2da27bc8",
    "a9a3d5d7-e0c6-3f24-af35-2acadc1aa2d9",
    "aaed41a5-47f2-3e0a-9645-2dbd871f744f",
    "ae908cc4-7301-3390-8940-eb9b679a8a39",
    "af8471e6-6780-3df2-bc6a-1982a4b1b437",
    "b0116f1c-f88f-3c09-b4bf-fc3c8ebeda56",
    "b248d26b-9c48-3d5f-bda1-a05ec99c2d97",
    "b2d9d8a5-847b-3c3b-aed1-c414319d20af",
    "b40c0cbf-5d35-30df-9f63-de088ada278e",
    "b42dc943-8b33-3b79-a260-14eb9f58a991",
    "b48a15fb-2e84-34df-946f-ad72b3d7296f",
    "b4c0dac8-09d8-3f4b-be7b-9f89473c250c",
    "b6c4361a-7dd8-32a0-83d4-7f9d2beaed08",
    "b7cbdba9-18ac-393a-8352-4841ffee722e",
    "b869e2cb-3804-389a-a3c7-b80f57c7d2ac",
    "bc073372-a582-4c57-a579-a7fcf15b49de",
    "bc20a6d3-2db2-3849-8843-1e1b8c93e5db",
    "be0615bc-1d82-334b-9c98-6adf40406955",
    "c0e93b69-158e-3f05-931b-999bdf9d753a",
    "c19d4b20-814d-3b2e-94e5-5d3003631496",
    "c2bbb391-a453-36af-b987-9d15f46b8589",
    "c3388791-4fef-3278-a085-26121cf5f513",
    "c42d34f3-78d5-35be-9c47-77d297caebfe",
    "c45888cf-30f5-3e27-abeb-4f55caecc1f0",
    "c6b7a5fb-8cd8-3ee2-8e99-b788eb02e731",
    "c83da752-b12f-3fbd-b728-4abb9551723b",
    "c91f95de-d041-32f6-8b18-628a220be100",
    "c9fc62c5-a289-36e3-a900-7e7807eb2716",
    "cf79d751-5d2a-3d5c-96a2-bb8d603f21e0",
    "d029a394-7118-33c9-896d-eabb894f58c4",
    "d4c7aa45-dfd6-3d71-bb8a-40efd5110d3b",
    "d67d020a-4d28-3bfd-891d-d6aa7dcf0a69",
    "d70660da-4250-3ad1-a2d0-6a2d97b5379f",
    "d70bc0a2-9d7f-36bd-bf37-ed798b10b71b",
    "d70dae33-b4b2-36da-a4eb-345ef1c484cc",
    "d8192bbb-3b00-3c68-a79a-65872ea4276f",
    "de23dfe1-c0b1-441b-810b-324090dc171b",
    "deec57d0-d31b-31ec-aa75-88db5d9dadf5",
    "e35a6aae-3608-38a7-b6e9-b5d6108b921d",
    "e368d49a-e02a-3374-876e-8325f66c3574",
    "e4221cc6-a19d-31ca-bf94-031adb0ea390",
    "e596b305-c951-3081-ae02-85406a473840",
    "e858fb96-6b1f-3025-b40a-f71fd8d28c32",
    "e95c8cc2-ddb3-3e7b-b8c3-e7584a778464",
    "e95e20d1-7f04-34b9-9105-4333f11bf6b9",
    "ed5fc860-c172-39c5-91c0-d712957fb1cd",
    "f2325996-961e-3f63-bbc0-44b7e76aeac9",
    "f3887a09-2881-3de6-bdb9-55b62a0d15f5",
    "f554d503-4901-3b97-9516-a16398c66631",
    "f6107596-76e0-3064-a4a6-86332a90e539",
    "f77889f6-ef5a-4eed-a4cd-5d67d4a6e9c5",
    "f7c4cf87-6bab-3723-bd74-1c9ac5add9cb",
    "f7d568d4-0836-3f47-b330-f8d204c4b96e",
    "f849731b-d288-3bec-8f35-6bea979f7dd8",
    "fb207d3b-d2d5-3100-94c0-9145aebc770b",
    "fee0f78c-cf00-35c5-975b-72724f53fd64",
)
