Longleding Push Service SDK

# Supported Python Versions

Python >= 3.6

# Installation

longleding-push-service-sdk is available for Linux, macOS, and Windows.

```shell script
$ pip install longleding-push-service-sdk
```

# Basic Usage

```python
# -*- coding: utf-8 -*-
from sdk import push_service

push_service_endpoint = "localhost:80"
source_name = "demo"

push_service.init_service(endpoint=push_service_endpoint, source=source_name)


def send_sms_register_code():
    push_service.send_sms_register_code("xxxxxxxxxxx", "xxxxxx")


def send_sms_login_code():
    push_service.send_sms_login_code("xxxxxxxxxxx", "xxxxxx")


def send_sms_change_password_code():
    push_service.send_sms_change_password_code("xxxxxxxxxxx", "xxxxxx")


def send_sms_follow_up_login_code():
    push_service.send_sms_follow_up_login_code("xxxxxxxxxxx", "xxxxxx")


def send_sms_follow_up_login_notification():
    push_service.send_sms_follow_up_login_notification("xxxxxxxxxxx", "xxx", "xxx", "xxxxxxx")


def send_sms_follow_up_login_notification_wechat():
    push_service.send_sms_follow_up_login_notification_wechat("xxxxxxxxxxx", "xxx", "xxx", "xxxxxxx", "xxxxxxx")


def send_sms_general_verification_code():
    push_service.send_sms_general_verification_code("xxxxxxxxxxx", "xxxxxx")


def send_email_register_code():
    push_service.send_email_register_code("xxxxxxxxxxx", "xxxxxx")


def send_email_login_code():
    push_service.send_email_login_code("xxxxxxxxxxx", "xxxxxx")


def send_email_change_password_code():
    push_service.send_email_change_password_code("xxxxxxxxxxx", "xxxxxx")


def send_email_general_verification_code():
    push_service.send_email_general_verification_code("xxxxxxxxxxx", "xxxxxx")


if __name__ == '__main__':
    send_sms_register_code()

```

# Troubleshoot

If you encounter error messages similar to the following:

```shell script
...
TypeError: Couldn't build proto file into descriptor pool!
Invalid proto descriptor for file "common.proto":
  common.proto: A file with this name is already in the pool.
```

Setting an environment variable the following before running:

```shell script
export PROTOCOL_BUFFERS_PYTHON_IMPLEMENTATION='python'
```

See also
- [[Python] A file with this name is already in the pool.](#https://github.com/protocolbuffers/protobuf/issues/3002)
- [Python Generated Code](#https://developers.google.com/protocol-buffers/docs/reference/python-generated)
