#! usr/bin/python3.6
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-06-11 12:40:47.360445

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""

from pycatia.system_interfaces.any_object import AnyObject
from pycatia.product_structure_interfaces.product import Product


class AssemblyConvertor(AnyObject):
    """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     AssemblyConvertor
                | 
                | Product conversion object.
                | The AssemblyConvertor is the object that allows saving an
                | assembly to a specified format. Two objects exist from now on
                | : BillOfMaterial, which creates a bill of material (every
                | sub-assembly is represented, with all the one level depth
                | components), and ListingReport, which creates a listing report
                | (shows the product structure as it appears in the graph)
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.assembly_convertor = com_object

    def print(self, i_file_type: str, i_file: str, i_product: Product) -> None:
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Sub Print(CATBSTR iFileType,
                | CATBSTR iFile,
                | Product iProduct)
                | 
                |     Extracts the product's contents as a specified format. Saves it in a txt,
                |     html or xls file (depends of the object).
                | 
                |     Parameters:
                | 
                |         iFileType
                |             Type of the resulting file : TXT (for text file),
                |             HTML (for html file), XLS (for xls file) or MOTIF
                |             (do not use).
                |         iFile
                |             Path of the resulting file 
                |         iProduct
                |             Product that will be converted

        :param str i_file_type:
        :param str i_file:
        :param Product i_product:
        :return: None
        :rtype: None
        """
        return self.assembly_convertor.Print(i_file_type, i_file, i_product.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'print'
        # # vba_code = """
        # # Public Function print(assembly_convertor)
        # #     Dim iFileType (2)
        # #     assembly_convertor.Print iFileType
        # #     print = iFileType
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def set_current_format(self, ilist_props: tuple) -> None:
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Sub SetCurrentFormat(CATSafeArrayVariant ilistProps)
                | 
                |     Defines the properties that will be used in the print
                |     method.
                | 
                |     Parameters:
                | 
                |         ilistProps
                |             list of properties to display

        :param tuple ilist_props:
        :return: None
        :rtype: None
        """
        return self.assembly_convertor.SetCurrentFormat(ilist_props)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_current_format'
        # # vba_code = """
        # # Public Function set_current_format(assembly_convertor)
        # #     Dim ilistProps (2)
        # #     assembly_convertor.SetCurrentFormat ilistProps
        # #     set_current_format = ilistProps
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def set_secondary_format(self, ilist_props: tuple) -> None:
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Sub SetSecondaryFormat(CATSafeArrayVariant ilistProps)
                | 
                |     Defines the secondary properties that will be used in the print
                |     method.
                | 
                |     Parameters:
                | 
                |         ilistProps
                |             secondary list of properties to display

        :param tuple ilist_props:
        :return: None
        :rtype: None
        """
        return self.assembly_convertor.SetSecondaryFormat(ilist_props)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_secondary_format'
        # # vba_code = """
        # # Public Function set_secondary_format(assembly_convertor)
        # #     Dim ilistProps (2)
        # #     assembly_convertor.SetSecondaryFormat ilistProps
        # #     set_secondary_format = ilistProps
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'AssemblyConvertor(name="{self.name}")'
