#! usr/bin/python3.6
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-06-11 12:40:47.360445

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""

from pycatia.system_interfaces.any_object import AnyObject


class HybridShape(AnyObject):
    """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     HybridShape
                | 
                | Represents the hybrid shape object.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.hybrid_shape = com_object

    @property
    def thickness(self) -> 'HybridShape':
        """
        .. note::
            CAA V5 Visual Basic Help (2020-07-06 14:02:20.222384)
                | o Property Thickness() As HybridShape (Read Only)
                | 
                |     Returns the thickness of the hybrid shape.
                |     The thickness is a CATIAHybridShapeThickness.
                | 
                |     Example:
                |         The following example returns the thickness ExtrudeThickness of the
                |         extrude Extrude.1 as the origin point of the axis system
                |         AxisSystem0:
                | 
                |          Dim Extrude1 As AnyObject
                |          Set Extrude1 = HybridBody1.HybridShapes.Item  ( "Extrude.1" ) 
                |          Dim Thickness1 As HybridShapeThickness
                |          Set Thickness1 = Extrude1.Thickness

        :return: HybridShape
        :rtype: HybridShape
        """

        return HybridShape(self.hybrid_shape.Thickness)

    def append_hybrid_shape(self, i_hybrid_shape: 'HybridShape') -> None:
        """
        .. note::
            CAA V5 Visual Basic Help (2020-07-06 14:02:20.222384))
                | o Sub AppendHybridShape(HybridShape iHybridShape)
                | 
                |     Appends a hybrid shape to another hybrid shape.
                | 
                |     Parameters:
                | 
                |         iHybridShape
                |             The hybrid shape to append. 
                | 
                |     Example:
                |         This example appends the hybrid shape newHybridShape to the hybrid
                |         shape oldHybridShape:
                | 
                |          oldHybridShape.AppendHybridShape (newHybridShape)

        :param HybridShape i_hybrid_shape:
        :return: None
        :rtype: None
        """
        return self.hybrid_shape.AppendHybridShape(i_hybrid_shape.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'append_hybrid_shape'
        # # vba_code = """
        # # Public Function append_hybrid_shape(hybrid_shape)
        # #     Dim iHybridShape (2)
        # #     hybrid_shape.AppendHybridShape iHybridShape
        # #     append_hybrid_shape = iHybridShape
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def compute(self) -> None:
        """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445))
                | o Sub Compute()
                | 
                |     Computes the result of the hybrid shape.

        :return: None
        :rtype: None
        """
        return self.hybrid_shape.Compute()

    def __repr__(self):
        return f'HybridShape(name="{self.name}")'
