#! usr/bin/python3.6
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-06-11 12:40:47.360445

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""

from pycatia.system_interfaces.any_object import AnyObject


class Viewpoint2D(AnyObject):
    """
        .. note::
            CAA V5 Visual Basic Help (2020-06-11 12:40:47.360445)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     Viewpoint2D
                | 
                | Represents the 2D viewpoint.
                | The 2D viewpoint is the object that stores data which defines how your objects
                | are seen to enable their display by a 2D viewer. This data includes namely the
                | origin of the scene, that is the center of the displayed area, and the zoom
                | factor.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.viewpoint_2d = com_object

    @property
    def zoom(self) -> float:
        """
        .. note::
            CAA V5 Visual Basic Help (2020-07-06 14:02:20.222384)
                | o Property Zoom() As double
                | 
                |     Returns or sets the zoom factor associated with the
                |     viewpoint.
                | 
                |     Example:
                |         This example retrieves in ZoomFactor the zoom factor associated with
                |         the NiceViewpoint viewpoint, tests if it is less than 1, and if so, sets it to
                |         one and applies it to the viewpoint.
                | 
                |          ZoomFactor = NiceViewpoint.Zoom
                |          If ZoomFactor < 1 Then
                |           ZoomFactor = 1
                |           NiceViewpoint.Zoom(ZoomFactor)
                |          End If

        :return: float
        :rtype: float
        """

        return self.viewpoint_2d.Zoom

    @zoom.setter
    def zoom(self, value: float):
        """
        :param float value:
        """

        self.viewpoint_2d.Zoom = value

    def get_origin(self, o_origin: tuple) -> None:
        """
        .. note::
            CAA V5 Visual Basic Help (2020-07-06 14:02:20.222384))
                | o Sub GetOrigin(CATSafeArrayVariant oOrigin)
                | 
                |     Gets the coordinates of the origin of the viewpoint.
                | 
                |     Example:
                |         This example Gets the origin of the NiceViewpoint
                |         viewpoint.
                | 
                |          Dim origin(1)
                |          NiceViewpoint.GetOrigin origin

        :param tuple o_origin:
        :return: None
        :rtype: None
        """
        return self.viewpoint_2d.GetOrigin(o_origin)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_origin'
        # # vba_code = """
        # # Public Function get_origin(viewpoint_2d)
        # #     Dim oOrigin (2)
        # #     viewpoint_2d.GetOrigin oOrigin
        # #     get_origin = oOrigin
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def put_origin(self, o_origin: tuple) -> None:
        """
        .. note::
            CAA V5 Visual Basic Help (2020-07-06 14:02:20.222384))
                | o Sub PutOrigin(CATSafeArrayVariant oOrigin)
                | 
                |     Sets the coordinates of the origin of the viewpoint.
                | 
                |     Example:
                |         This example sets the origin of the NiceViewpoint viewpoint to the
                |         point with coordinates (5, 8).
                | 
                |          NiceViewpoint.PutOrigin Array(5, 8)

        :param tuple o_origin:
        :return: None
        :rtype: None
        """
        return self.viewpoint_2d.PutOrigin(o_origin)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'put_origin'
        # # vba_code = """
        # # Public Function put_origin(viewpoint_2d)
        # #     Dim oOrigin (2)
        # #     viewpoint_2d.PutOrigin oOrigin
        # #     put_origin = oOrigin
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'Viewpoint2D(name="{self.name}")'
