/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.pgraphs.io;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.gavrog.box.collections.NiftyList;
import org.gavrog.jane.numbers.Whole;
import org.gavrog.joss.geometry.Vector;
import org.gavrog.joss.pgraphs.basic.IEdge;
import org.gavrog.joss.pgraphs.basic.INode;
import org.gavrog.joss.pgraphs.basic.PeriodicGraph;
import org.gavrog.joss.pgraphs.io.Net;
import org.gavrog.joss.pgraphs.io.NetParser;

public class Output {
    public static void writePGR(Writer writer, PeriodicGraph periodicGraph, String string) throws IOException {
        Comparable<Integer> comparable;
        writer.write("PERIODIC_GRAPH\n");
        if (string != null) {
            writer.write("  NAME " + string + "\n");
        }
        HashMap<INode, Integer> hashMap = new HashMap<INode, Integer>();
        int n = 0;
        for (INode iterator2 : periodicGraph.nodes()) {
            hashMap.put(iterator2, ++n);
        }
        LinkedList linkedList = new LinkedList();
        writer.write("  EDGES\n");
        for (IEdge iEdge : periodicGraph.edges()) {
            int n2;
            comparable = (Integer)hashMap.get(iEdge.source());
            Integer n3 = (Integer)hashMap.get(iEdge.target());
            Vector vector = periodicGraph.getShift(iEdge);
            LinkedList<Comparable<Integer>> linkedList2 = new LinkedList<Comparable<Integer>>();
            int n4 = ((Integer)comparable).compareTo(n3);
            if (n4 > 0 || n4 == 0 && vector.isNegative()) {
                linkedList2.add(n3);
                linkedList2.add(comparable);
                for (n2 = 0; n2 < vector.getDimension(); ++n2) {
                    linkedList2.add(Integer.valueOf(((Whole)vector.get(n2).negative()).intValue()));
                }
            } else {
                linkedList2.add(comparable);
                linkedList2.add(n3);
                for (n2 = 0; n2 < vector.getDimension(); ++n2) {
                    linkedList2.add(Integer.valueOf(((Whole)vector.get(n2)).intValue()));
                }
            }
            linkedList.add(new LinkedList(linkedList2));
        }
        Collections.sort(linkedList, NiftyList.lexicographicComparator());
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            List list = (List)iterator.next();
            comparable = new StringBuffer(20);
            ((StringBuffer)comparable).append("    ");
            ((StringBuffer)comparable).append(Output.format((Integer)list.get(0), true));
            ((StringBuffer)comparable).append(' ');
            ((StringBuffer)comparable).append(Output.format((Integer)list.get(1), true));
            ((StringBuffer)comparable).append("   ");
            for (int i = 2; i < list.size(); ++i) {
                ((StringBuffer)comparable).append(' ');
                ((StringBuffer)comparable).append(Output.format((Integer)list.get(i), false));
            }
            ((StringBuffer)comparable).append('\n');
            writer.write(((StringBuffer)comparable).toString());
        }
        writer.write("END\n");
    }

    private static String format(int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(5);
        if (bl) {
            if (n < 10) {
                stringBuffer.append(' ');
            }
            if (n < 100) {
                stringBuffer.append(' ');
            }
        } else if (n >= 0) {
            stringBuffer.append(' ');
        }
        stringBuffer.append(n);
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        try {
            InputStreamReader inputStreamReader = stringArray.length > 0 ? new FileReader(stringArray[0]) : new InputStreamReader(System.in);
            OutputStreamWriter outputStreamWriter = stringArray.length > 1 ? new FileWriter(stringArray[1]) : new OutputStreamWriter(System.out);
            NetParser netParser = new NetParser(inputStreamReader);
            while (true) {
                Net net;
                if ((net = netParser.parseNet()) == null) {
                    return;
                }
                Output.writePGR(outputStreamWriter, net.canonical(), net.getName());
                ((Writer)outputStreamWriter).write(10);
                ((Writer)outputStreamWriter).flush();
            }
        }
        catch (IOException iOException) {
            System.err.print(iOException);
            System.exit(1);
            return;
        }
    }
}

