/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.pgraphs.io;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gavrog.box.collections.Pair;
import org.gavrog.box.simple.DataFormatException;
import org.gavrog.joss.pgraphs.basic.PeriodicGraph;

public class Archive {
    final String keyVersion;
    private final Map<String, Entry> byKey;
    private final Map<String, Entry> byName;
    private boolean errorOnOverwrite = false;

    public Archive(String string) {
        this.keyVersion = string;
        this.byKey = new LinkedHashMap<String, Entry>();
        this.byName = new HashMap<String, Entry>();
    }

    public int size() {
        return this.byKey.size();
    }

    public String getKeyVersion() {
        return this.keyVersion;
    }

    public void clear() {
        this.byKey.clear();
        this.byName.clear();
    }

    public void add(Entry entry) {
        String string = entry.getKeyVersion();
        String string2 = entry.getKey();
        String string3 = entry.getName();
        if (!string.equals(this.getKeyVersion())) {
            throw new IllegalArgumentException("entry '" + string3 + "' has key of version " + string + ", but " + this.getKeyVersion() + " is required.");
        }
        if (this.errorOnOverwrite) {
            if (this.byKey.containsKey(string2)) {
                String string4 = this.byKey.get(string2).getName();
                if (!string4.equals(string3)) {
                    throw new IllegalArgumentException("identical keys for entries '" + string4 + "' and '" + string3 + "'");
                }
            } else if (this.byName.containsKey(string3)) {
                throw new IllegalArgumentException("multiple entries for id '" + string3 + "'");
            }
        }
        this.byKey.put(string2, entry);
        this.byName.put(string3, entry);
    }

    public Entry add(PeriodicGraph periodicGraph, String string) {
        Entry entry = new Entry(periodicGraph, string);
        this.add(entry);
        return entry;
    }

    public void delete(Entry entry) {
        if (entry == null) {
            throw new IllegalArgumentException("null argument");
        }
        String string = entry.getKey();
        String string2 = entry.getName();
        if (entry != this.getByKey(string)) {
            throw new IllegalArgumentException("no such entry");
        }
        this.byKey.remove(string);
        this.byName.remove(string2);
    }

    public Entry getByKey(String string) {
        return this.byKey.get(string);
    }

    public Entry getByName(String string) {
        return this.byName.get(string);
    }

    public Entry get(String string) {
        Entry entry = this.getByKey(string);
        if (entry != null) {
            return entry;
        }
        return this.getByName(string);
    }

    public void addAll(BufferedReader bufferedReader) {
        Entry entry;
        while ((entry = Entry.read(bufferedReader)) != null) {
            this.add(entry);
        }
        return;
    }

    public void addAll(Reader reader) {
        this.addAll(new BufferedReader(reader));
    }

    public Set<String> keySet() {
        return this.byKey.keySet();
    }

    public boolean getErrorOnOverwrite() {
        return this.errorOnOverwrite;
    }

    public void setErrorOnOverwrite(boolean bl) {
        this.errorOnOverwrite = bl;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.err.println("Usage: Archive command file arguments");
            return;
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        Archive archive = new Archive("1.0");
        if ("check".equalsIgnoreCase(string)) {
            archive.setErrorOnOverwrite(true);
        }
        try {
            archive.addAll(new FileReader(string2));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Could not find file \"" + string2 + "\".");
            return;
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage() + " - in archive \"" + string2 + "\".");
            return;
        }
        int n = archive.size();
        System.err.println("Read " + n + " entr" + (n == 1 ? "y" : "ies") + " from archive " + string2 + ".");
        if ("rename".equalsIgnoreCase(string)) {
            Entry entry;
            int n2;
            if (stringArray.length < 4) {
                System.err.println("Usage: Archive rename file old1 new1 ...");
                return;
            }
            for (n2 = 2; n2 < stringArray.length; n2 += 2) {
                String string3 = stringArray[n2];
                String string4 = stringArray[n2 + 1];
                entry = archive.getByName(string3);
                if (entry == null) {
                    System.err.println("Warning: could not find entry \"" + (String)string3 + "\".");
                    continue;
                }
                Entry entry2 = new Entry(entry.key, entry.keyVersion, string4);
                archive.delete(entry);
                archive.add(entry2);
            }
            n2 = 0;
            for (String string4 : archive.keySet()) {
                entry = archive.getByKey(string4);
                System.out.println(entry.toString());
                ++n2;
            }
            System.err.println("Wrote " + n2 + " entr" + (n2 == 1 ? "y" : "ies") + " to standard output.");
        } else if ("compare".equalsIgnoreCase(string)) {
            Entry entry;
            Entry entry3;
            if (stringArray.length < 3) {
                System.err.println("Usage: Archive compare oldfile newfile");
                return;
            }
            Archive archive2 = new Archive("1.0");
            String string5 = stringArray[2];
            try {
                archive2.addAll(new FileReader(string5));
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("Could not find file \"" + string5 + "\".");
                return;
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage() + " - in archive \"" + string5 + "\".");
                return;
            }
            int n3 = archive2.size();
            System.err.println("Read " + n3 + " entr" + (n3 == 1 ? "y" : "ies") + " from archive " + string5 + ".");
            LinkedList<String> linkedList = new LinkedList<String>();
            LinkedList<Pair<String, String>> linkedList2 = new LinkedList<Pair<String, String>>();
            LinkedList<String> linkedList3 = new LinkedList<String>();
            LinkedList<String> linkedList4 = new LinkedList<String>();
            for (String string6 : archive.keySet()) {
                Entry entry4;
                entry3 = archive.getByKey(string6);
                entry = archive2.getByKey(string6);
                String string7 = entry3.name;
                if (entry == null) {
                    linkedList.add(string7);
                } else if (!entry.name.equals(string7)) {
                    linkedList2.add(new Pair<String, String>(string7, entry.name));
                }
                if ((entry4 = archive2.getByName(string7)) == null || entry4.key.equals(string6)) continue;
                linkedList4.add(string7);
            }
            for (String string6 : archive2.keySet()) {
                entry3 = archive.getByKey(string6);
                entry = archive2.getByKey(string6);
                if (entry3 != null) continue;
                linkedList3.add(entry.name);
            }
            Archive.printList(linkedList4, "Changed");
            Archive.printList(linkedList2, "Renamed");
            Archive.printList(linkedList, "Deleted");
            Archive.printList(linkedList3, "Added");
        }
    }

    private static <T> void printList(List<T> list, String string) {
        if (list.size() > 0) {
            System.err.print(string + ": ");
            for (T t : list) {
                System.err.print(" " + t);
            }
        }
        System.err.println();
    }

    public static class Entry {
        static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        private final String key;
        private final String keyVersion;
        private final String name;
        private String description;
        private String reference;
        private String url;

        public Entry(String string, String string2, String string3) {
            this.key = string;
            this.keyVersion = string2;
            this.name = string3;
        }

        public Entry(PeriodicGraph periodicGraph, String string) {
            this(periodicGraph.getSystreKey(), periodicGraph.invariantVersion, string);
        }

        public String getKey() {
            return this.key;
        }

        public String getName() {
            return this.name;
        }

        public String getKeyVersion() {
            return this.keyVersion;
        }

        public String getDigestString() {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                StringBuffer stringBuffer = new StringBuffer(100);
                stringBuffer.append(this.key);
                stringBuffer.append("\n");
                stringBuffer.append(this.keyVersion);
                stringBuffer.append("\n");
                stringBuffer.append(this.name);
                messageDigest.update(stringBuffer.toString().getBytes());
                byte[] byArray = messageDigest.digest();
                StringBuffer stringBuffer2 = new StringBuffer(byArray.length * 2);
                for (int i = 0; i < byArray.length; ++i) {
                    stringBuffer2.append(hexDigit[(byArray[i] & 0xF0) >>> 4]);
                    stringBuffer2.append(hexDigit[byArray[i] & 0xF]);
                }
                return stringBuffer2.toString();
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new RuntimeException(generalSecurityException);
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(200);
            stringBuffer.append("key      ");
            stringBuffer.append(this.getKey());
            stringBuffer.append("\n");
            stringBuffer.append("version  ");
            stringBuffer.append(this.getKeyVersion());
            stringBuffer.append("\n");
            stringBuffer.append("id       ");
            stringBuffer.append(this.getName());
            stringBuffer.append("\n");
            stringBuffer.append("checksum ");
            stringBuffer.append(this.getDigestString());
            stringBuffer.append("\n");
            stringBuffer.append("ref      ");
            if (this.reference != null) {
                stringBuffer.append(this.getReference());
            }
            stringBuffer.append("\n");
            stringBuffer.append("desc     ");
            if (this.getDescription() != null) {
                stringBuffer.append(this.getDescription());
            }
            stringBuffer.append("\n");
            if (this.getURL() != null) {
                stringBuffer.append("url      ");
                stringBuffer.append(this.getURL());
                stringBuffer.append("\n");
            }
            stringBuffer.append("end\n");
            return stringBuffer.toString();
        }

        public static Entry read(BufferedReader bufferedReader) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            while (true) {
                String string;
                String string2;
                String string3;
                try {
                    string3 = bufferedReader.readLine();
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                if (string3 == null) break;
                if ((string3 = string3.trim().replaceAll("\\s+", " ")).length() == 0) continue;
                int n = string3.indexOf(" ");
                if (n < 0) {
                    string2 = string3;
                    string = null;
                } else {
                    string2 = string3.substring(0, n);
                    string = string3.substring(n + 1);
                }
                if (string2.equals("end")) {
                    String string4 = (String)hashMap.get("key");
                    String string5 = (String)hashMap.get("version");
                    String string6 = (String)hashMap.get("id");
                    String string7 = (String)hashMap.get("checksum");
                    Entry entry = new Entry(string4, string5, string6);
                    if (!entry.getDigestString().equals(string7)) {
                        throw new DataFormatException("checksum mismatch for entry '" + string6 + "'.");
                    }
                    entry.setDescription((String)hashMap.get("desc"));
                    entry.setReference((String)hashMap.get("ref"));
                    entry.setURL((String)hashMap.get("url"));
                    return entry;
                }
                hashMap.put(string2, string);
            }
            return null;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String string) {
            this.description = string;
        }

        public String getReference() {
            return this.reference;
        }

        public void setReference(String string) {
            this.reference = string;
        }

        public String getURL() {
            return this.url;
        }

        public void setURL(String string) {
            this.url = string;
        }
    }
}

