/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.pgraphs.embed;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gavrog.box.collections.Partition;
import org.gavrog.jane.algorithms.Amoeba;
import org.gavrog.jane.compounds.LinearAlgebra;
import org.gavrog.jane.compounds.Matrix;
import org.gavrog.jane.numbers.ArithmeticBase;
import org.gavrog.jane.numbers.FloatingPoint;
import org.gavrog.jane.numbers.Fraction;
import org.gavrog.jane.numbers.Real;
import org.gavrog.jane.numbers.Whole;
import org.gavrog.joss.geometry.Operator;
import org.gavrog.joss.geometry.Point;
import org.gavrog.joss.geometry.SpaceGroup;
import org.gavrog.joss.geometry.Vector;
import org.gavrog.joss.pgraphs.basic.IEdge;
import org.gavrog.joss.pgraphs.basic.INode;
import org.gavrog.joss.pgraphs.basic.Morphism;
import org.gavrog.joss.pgraphs.basic.PeriodicGraph;

public class Embedder {
    static final boolean DEBUG = false;
    private static final int EDGE = 1;
    private static final int ANGLE = 2;
    private final PeriodicGraph graph;
    private final int dimGraph;
    private final Map<INode, Operator> node2sym;
    private final Map<INode, Map<INode, Operator>> node2images;
    private final Map<INode, Integer> node2index;
    private final Map<INode, double[][]> node2mapping;
    private final int dimParSpace;
    private final Matrix gramSpace;
    private final int[][] gramIndex;
    private final Edge[] edges;
    double[] p;
    double volumeWeight;
    double penaltyFactor;
    private boolean _positionsRelaxed = false;
    private boolean _cellRelaxed = false;
    private int passes = 3;
    private boolean optimizePositions = true;
    private boolean checkPositions = false;
    private Map<INode, Point> initialPlacement;

    public Embedder(PeriodicGraph periodicGraph, Map<INode, Point> map, boolean bl) {
        Set<Object> set;
        ArithmeticBase arithmeticBase;
        ArithmeticBase arithmeticBase2;
        this.graph = periodicGraph;
        int n = this.dimGraph = periodicGraph.getDimension();
        this.checkPositions = bl;
        this.initialPlacement = map == null ? this.graph.barycentricPlacement() : map;
        this.node2sym = this.nodeSymmetrizations();
        this.node2images = new HashMap<INode, Map<INode, Operator>>();
        HashSet<Object> hashSet = new HashSet<Object>();
        for (INode iNode : this.graph.nodes()) {
            if (hashSet.contains(iNode)) continue;
            Point point = this.getGraph().barycentricPlacement().get(iNode);
            HashMap<Object, Operator> iterator2 = new HashMap<Object, Operator>();
            iterator2.put(iNode, new Operator(Matrix.one(n + 1)));
            hashSet.add(iNode);
            for (Morphism morphism : this.graph.symmetries()) {
                INode iNode2 = morphism.getImage(iNode);
                if (hashSet.contains(iNode2)) continue;
                Object object = this.getGraph().barycentricPlacement().get(iNode2);
                arithmeticBase2 = morphism.getAffineOperator();
                arithmeticBase = (Vector)((Point)object).minus(point.times(arithmeticBase2));
                Operator operator = (Operator)arithmeticBase2.times(arithmeticBase);
                iterator2.put(iNode2, operator);
                hashSet.add(iNode2);
                if (point.times(operator).equals(object)) continue;
                throw new RuntimeException("Bad operator for " + iNode + " --> " + iNode2 + ": image is " + point.times(operator) + ", but should be " + object);
            }
            this.node2images.put(iNode, iterator2);
        }
        this.gramIndex = new int[n][n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            this.gramIndex[i][i] = n2++;
            for (int j = i + 1; j < n; ++j) {
                int n3 = n2++;
                this.gramIndex[j][i] = n3;
                this.gramIndex[i][j] = n3;
            }
        }
        SpaceGroup spaceGroup = periodicGraph.getSpaceGroup();
        this.gramSpace = spaceGroup.configurationSpaceForGramMatrix();
        n2 = this.gramSpace.numberOfRows();
        this.node2index = new HashMap<INode, Integer>();
        this.node2mapping = new HashMap<INode, double[][]>();
        for (INode iNode : this.nodeOrbitReps()) {
            set = this.normalizedPositionSpace(iNode);
            this.node2index.put(iNode, new Integer(n2));
            this.node2mapping.put(iNode, ((Matrix)((Object)set)).asDoubleArray());
            Map<INode, Operator> map2 = this.images(iNode);
            for (Object object : map2.keySet()) {
                if (object == iNode) continue;
                arithmeticBase2 = map2.get(object).getCoordinates();
                this.node2index.put((INode)object, n2);
                arithmeticBase = (Matrix)((Matrix)((Object)set)).times(arithmeticBase2);
                this.node2mapping.put((INode)object, ((Matrix)arithmeticBase).asDoubleArray());
                if (((Matrix)arithmeticBase).times(this.symmetrizer((INode)object).getCoordinates()).equals(arithmeticBase)) continue;
                throw new RuntimeException("bad parameter space for " + object + ": " + arithmeticBase + " (gets 'symmetrized' to " + ((Matrix)arithmeticBase).times(this.symmetrizer((INode)object)));
            }
            n2 += ((Matrix)((Object)set)).numberOfRows() - 1;
        }
        this.dimParSpace = n2;
        ArrayList arrayList = new ArrayList();
        Iterator<Set<IEdge>> iterator = periodicGraph.edgeOrbits();
        while (iterator.hasNext()) {
            set = iterator.next();
            IEdge iEdge = set.iterator().next();
            arrayList.add(new Edge(iEdge.source(), iEdge.target(), periodicGraph.getShift(iEdge), 1, set.size()));
        }
        Iterator<Set<Angle>> iterator2 = this.angleOrbits();
        while (iterator2.hasNext()) {
            set = iterator2.next();
            Angle angle = (Angle)set.iterator().next();
            arrayList.add(new Edge(angle.v, angle.w, angle.s, 2, set.size()));
        }
        this.edges = new Edge[arrayList.size()];
        arrayList.toArray(this.edges);
        this.p = new double[this.dimParSpace];
        this.setPositions(this.initialPlacement);
        this.setGramMatrix(null);
    }

    public int degreesOfFreedom() {
        return this.dimParSpace - this.graph.getSpaceGroup().shiftSpace().length;
    }

    private Matrix normalizedPositionSpace(INode iNode) {
        Operator operator = this.symmetrizer(iNode);
        Matrix matrix = (Matrix)operator.getCoordinates().minus(Matrix.one(this.dimGraph + 1));
        Matrix matrix2 = LinearAlgebra.rowNullSpace(matrix, false);
        Matrix matrix3 = this.normalizedPositionSpace(matrix2, true);
        if (!matrix3.times(operator.getCoordinates()).equals(matrix3)) {
            throw new RuntimeException("bad parameter space for " + iNode + ": " + matrix3 + " (gets 'symmetrized' to " + matrix3.times(operator.getCoordinates()));
        }
        return matrix3;
    }

    private Matrix normalizedPositionSpace(Matrix matrix, boolean bl) {
        int n;
        int n2 = matrix.numberOfRows();
        int n3 = matrix.numberOfColumns();
        Matrix matrix2 = matrix.mutableClone();
        Matrix.triangulate(matrix2, null, false, true);
        if (bl) {
            for (n = 0; n < n2 - 1; ++n) {
                if (matrix2.get(n, n3 - 1).isZero()) continue;
                Matrix matrix3 = matrix2.getRow(n2 - 1);
                matrix2.setRow(n2 - 1, matrix2.getRow(n));
                matrix2.setRow(n, matrix3);
                break;
            }
        }
        matrix2.setRow(n2 - 1, (Matrix)matrix2.getRow(n2 - 1).dividedBy(matrix2.get(n2 - 1, n3 - 1)));
        for (n = 0; n < n2 - 1; ++n) {
            matrix2.setRow(n, (Matrix)matrix2.getRow(n).minus(matrix2.getRow(n2 - 1).times(matrix2.get(n, n3 - 1))));
        }
        return matrix2;
    }

    private Iterator<Set<Angle>> angleOrbits() {
        Object object;
        Object object2;
        Object object3;
        HashSet<Angle> hashSet = new HashSet<Angle>();
        for (INode object42 : this.graph.nodes()) {
            List<IEdge> list = this.graph.allIncidences(object42);
            int morphism = list.size();
            for (int i = 0; i < morphism - 1; ++i) {
                IEdge iEdge = (IEdge)list.get(i);
                INode iNode = iEdge.target();
                for (int j = i + 1; j < morphism; ++j) {
                    object3 = (IEdge)list.get(j);
                    object2 = object3.target();
                    object = (Vector)this.graph.getShift((IEdge)object3).minus(this.graph.getShift(iEdge));
                    hashSet.add(new Angle(iNode, (INode)object2, (Vector)object));
                }
            }
        }
        Partition partition = new Partition();
        Map<INode, Point> map = this.getGraph().barycentricPlacement();
        for (Morphism morphism : this.getGraph().symmetries()) {
            Operator operator = morphism.getAffineOperator();
            for (Angle angle : hashSet) {
                INode iNode = morphism.getImage(angle.v);
                object3 = map.get(angle.v);
                object2 = (Vector)((Point)object3).times(operator).minus(map.get(iNode));
                object = morphism.getImage(angle.w);
                Point point = map.get(angle.w);
                Vector vector = (Vector)point.times(operator).minus(map.get(object));
                Vector vector2 = (Vector)angle.s.times(operator).plus(vector).minus(object2);
                partition.unite(angle, new Angle(iNode, (INode)object, vector2));
            }
        }
        return partition.classes();
    }

    private void setPosition(INode iNode, Point point, double[] dArray) {
        Vector vector;
        Matrix matrix = new Matrix(this.node2mapping.get(iNode)).mutableClone();
        int n = matrix.numberOfRows();
        if (n > 1) {
            int n2 = this.dimGraph;
            Matrix matrix2 = new Matrix(1, n2 + 1);
            matrix2.setSubMatrix(0, 0, ((Point)point.times(this.symmetrizer(iNode))).getCoordinates());
            matrix2.set(0, n2, Whole.ONE);
            Matrix matrix3 = matrix.getRow(n - 1);
            matrix.setRow(n - 1, (Matrix)matrix3.minus(matrix3));
            Matrix matrix4 = LinearAlgebra.solutionInRows(matrix, (Matrix)matrix2.minus(matrix3), false);
            if (matrix4 == null) {
                throw new RuntimeException("Could not solve x * " + matrix + " = " + matrix2);
            }
            int n3 = this.node2index.get(iNode);
            for (int i = 0; i < n - 1; ++i) {
                dArray[n3 + i] = ((Real)matrix4.get(0, i)).doubleValue();
            }
        }
        if (this.checkPositions && ((Real)Vector.dot(vector = (Vector)this.getPosition(iNode).minus(point), vector)).sqrt().doubleValue() > 1.0E-12) {
            throw new RuntimeException("Position mismatch:" + iNode + " set to " + point + ", but turned up as " + this.getPosition(iNode));
        }
    }

    private double[] getPosition(INode iNode, double[] dArray) {
        int n = this.dimGraph;
        int n2 = this.node2index.get(iNode);
        double[][] dArray2 = this.node2mapping.get(iNode);
        int n3 = dArray2.length;
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray3[i] = dArray2[n3 - 1][i];
            for (int j = 0; j < n3 - 1; ++j) {
                int n4 = i;
                dArray3[n4] = dArray3[n4] + dArray[n2 + j] * dArray2[j][i];
            }
        }
        return dArray3;
    }

    private double[] gramToArray(Matrix matrix) {
        int n = this.dimGraph;
        double[] dArray = new double[n * (n + 1) / 2];
        for (int i = 0; i < n; ++i) {
            for (int j = i; j < n; ++j) {
                int n2 = this.gramIndex[i][j];
                dArray[n2] = ((Real)matrix.get(i, j)).doubleValue();
            }
        }
        return dArray;
    }

    private Matrix gramFromArray(double[] dArray) {
        int n = this.dimGraph;
        Matrix matrix = new Matrix(n, n);
        for (int i = 0; i < n; ++i) {
            for (int j = i; j < n; ++j) {
                int n2 = this.gramIndex[i][j];
                FloatingPoint floatingPoint = new FloatingPoint(dArray[n2]);
                matrix.set(i, j, floatingPoint);
                matrix.set(j, i, floatingPoint);
            }
        }
        return matrix;
    }

    private void setGramMatrix(Matrix matrix, double[] dArray) {
        Matrix matrix2 = this.gramSpace;
        int n = matrix2.numberOfRows();
        Matrix matrix3 = new Matrix(new double[][]{this.gramToArray(matrix)});
        Matrix matrix4 = LinearAlgebra.solutionInRows(matrix2, matrix3, false);
        for (int i = 0; i < n; ++i) {
            dArray[i] = ((Real)matrix4.get(0, i)).doubleValue();
        }
    }

    private Matrix getGramMatrix(double[] dArray) {
        int n;
        int n2 = this.dimGraph;
        int n3 = n2 * (n2 + 1) / 2;
        double[] dArray2 = new double[n3];
        Matrix matrix = this.gramSpace;
        int n4 = matrix.numberOfRows();
        for (int i = 0; i < n3; ++i) {
            dArray2[i] = 0.0;
            for (n = 0; n < n4; ++n) {
                int n5 = i;
                dArray2[n5] = dArray2[n5] + dArray[n] * ((Real)matrix.get(n, i)).doubleValue();
            }
        }
        Matrix matrix2 = this.gramFromArray(dArray2);
        for (n = 0; n < n2; ++n) {
            if (!matrix2.get(n, n).isNegative()) continue;
            matrix2.set(n, n, FloatingPoint.ZERO);
        }
        for (n = 0; n < n2; ++n) {
            for (int i = n + 1; i < n2; ++i) {
                Real real = ((Real)matrix2.get(n, n).times(matrix2.get(i, i))).sqrt();
                if (!matrix2.get(n, i).isGreaterThan(real)) continue;
                matrix2.set(n, i, real);
                matrix2.set(i, n, real);
            }
        }
        return matrix2;
    }

    private double energy(double[] dArray) {
        double d;
        int n = this.dimGraph;
        int n2 = this.getGraph().numberOfNodes();
        Matrix matrix = this.getGramMatrix(dArray);
        double[] dArray2 = this.gramToArray(matrix);
        double[] dArray3 = !this.getRelaxPositions() ? this.p : dArray;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = Double.MAX_VALUE;
        for (int i = 0; i < this.edges.length; ++i) {
            Edge edge = this.edges[i];
            double[] dArray4 = this.getPosition(edge.v, dArray3);
            double[] dArray5 = this.getPosition(edge.w, dArray3);
            double[] dArray6 = edge.shift;
            double[] dArray7 = new double[n];
            for (int j = 0; j < n; ++j) {
                dArray7[j] = dArray5[j] + dArray6[j] - dArray4[j];
            }
            d = 0.0;
            for (int j = 0; j < n; ++j) {
                d += dArray7[j] * dArray7[j] * dArray2[this.gramIndex[j][j]];
                for (int k = j + 1; k < n; ++k) {
                    d += 2.0 * dArray7[j] * dArray7[k] * dArray2[this.gramIndex[j][k]];
                }
            }
            edge.length = d = Math.sqrt(d);
            if (edge.type != 1) continue;
            d2 += d * edge.weight;
            d3 += edge.weight;
            d4 = Math.min(d, d4);
        }
        double d5 = d2 / d3;
        if (d3 != (double)this.getGraph().numberOfEdges()) {
            System.out.println("edgeWeightSum is " + d3 + ", but should be " + this.getGraph().numberOfEdges());
        }
        double d6 = d5 > 1.0E-12 ? 1.01 / d5 : 1.01;
        double d7 = 0.0;
        d = 0.0;
        double d8 = 0.0;
        for (int i = 0; i < this.edges.length; ++i) {
            double d9;
            double d10;
            Edge edge = this.edges[i];
            double d11 = edge.length * d6;
            if (d11 < 0.5) {
                d10 = Math.max(d11, 1.0E-12);
                d9 = Math.exp(Math.tan((0.25 - d10) * 2.0 * Math.PI)) * edge.weight;
            } else {
                d9 = 0.0;
            }
            if (edge.type == 1) {
                d10 = 1.0 - d11 * d11;
                d7 += d10 * d10 * edge.weight;
                d += d9;
                continue;
            }
            d8 += d9;
        }
        if ((d7 /= d3) < 0.0) {
            throw new RuntimeException("edge lengths variance got negative: " + d7);
        }
        Matrix matrix2 = (Matrix)matrix.times(d6 * d6);
        double d12 = Math.sqrt(((Real)matrix2.determinant()).doubleValue());
        double d13 = Math.exp(1.0 / Math.max(d12 / (double)n2, 1.0E-12)) - 1.0;
        return this.volumeWeight * d13 + d7 + this.penaltyFactor * (d + d8);
    }

    private Map<INode, Operator> nodeSymmetrizations() {
        HashMap<INode, Operator> hashMap = new HashMap<INode, Operator>();
        for (INode iNode : this.graph.nodes()) {
            List<Morphism> list = this.graph.nodeStabilizer(iNode);
            Point point = this.getGraph().barycentricPlacement().get(iNode);
            int n = point.getDimension();
            Matrix matrix = Matrix.zero(n + 1, n + 1);
            for (Morphism morphism : list) {
                Operator operator = morphism.getAffineOperator();
                Vector vector = (Vector)point.minus(point.times(operator));
                Operator operator2 = (Operator)operator.times(vector);
                matrix = (Matrix)matrix.plus(operator2.getCoordinates());
            }
            Operator operator = new Operator(matrix);
            if (!point.times(operator).equals(point)) {
                throw new RuntimeException("Bad symmetrizer for " + iNode + ": moves from " + point + " to " + point.times(operator));
            }
            hashMap.put(iNode, operator);
        }
        return hashMap;
    }

    private double length(IEdge iEdge) {
        Point point = this.getPosition(iEdge.source());
        Point point2 = this.getPosition(iEdge.target());
        Vector vector = this.graph.getShift(iEdge);
        return this.length((Vector)point2.plus(vector).minus(point));
    }

    private double length(Vector vector) {
        Real real = (Real)Vector.dot(vector, vector, this.getGramMatrix());
        return Math.sqrt(real.doubleValue());
    }

    private Set<INode> nodeOrbitReps() {
        return this.node2images.keySet();
    }

    private Map<INode, Operator> images(INode iNode) {
        return this.node2images.get(iNode);
    }

    private Operator symmetrizer(INode iNode) {
        return this.node2sym.get(iNode);
    }

    private static Matrix resymmetrized(Matrix matrix, PeriodicGraph periodicGraph) {
        int n = periodicGraph.getDimension();
        Set<Morphism> set = periodicGraph.symmetries();
        Matrix matrix2 = Matrix.zero(n, n);
        for (Morphism morphism : set) {
            Matrix matrix3 = morphism.getLinearOperator().getCoordinates().getSubMatrix(0, 0, n, n);
            matrix2 = (Matrix)matrix2.plus(matrix3.times(matrix).times(matrix3.transposed()));
        }
        matrix2 = ((Matrix)matrix2.times(new Fraction(1L, (long)set.size()))).mutableClone();
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                matrix2.set(j, i, matrix2.get(i, j));
            }
        }
        return matrix2;
    }

    public void normalize() {
        double d = this.averageEdgeLength();
        if (d < 0.001) {
            throw new RuntimeException("degenerate unit cell while relaxing");
        }
        this.setGramMatrix((Matrix)this.getGramMatrix().dividedBy(d * d));
    }

    public PeriodicGraph getGraph() {
        return this.graph;
    }

    public int getPasses() {
        return this.passes;
    }

    public void setPasses(int n) {
        this.passes = n;
    }

    public void setRelaxPositions(boolean bl) {
        this.optimizePositions = bl;
    }

    public boolean getRelaxPositions() {
        return this.optimizePositions;
    }

    public void setGramMatrix(Matrix matrix) {
        int n = this.graph.getDimension();
        Matrix matrix2 = matrix == null ? Matrix.one(n) : matrix;
        this.setGramMatrix(Embedder.resymmetrized(matrix2, this.graph), this.p);
    }

    public Matrix getGramMatrix() {
        return this.getGramMatrix(this.p);
    }

    public void setPosition(INode iNode, Point point) {
        this.setPosition(iNode, point, this.p);
    }

    public void setPositions(Map<INode, Point> map) {
        for (INode iNode : map.keySet()) {
            this.setPosition(iNode, map.get(iNode));
        }
    }

    public Point getPosition(INode iNode) {
        return new Point(this.getPosition(iNode, this.p));
    }

    public Map<INode, Point> getPositions() {
        HashMap<INode, Point> hashMap = new HashMap<INode, Point>();
        for (INode iNode : this.getGraph().nodes()) {
            hashMap.put(iNode, this.getPosition(iNode));
        }
        return hashMap;
    }

    public int go(int n) {
        if (this.dimParSpace == 0) {
            this._positionsRelaxed = this.getRelaxPositions();
            this._cellRelaxed = true;
            return 0;
        }
        Amoeba.Function function = new Amoeba.Function(){

            @Override
            public int dim() {
                if (Embedder.this.getRelaxPositions()) {
                    return Embedder.this.dimParSpace;
                }
                return Embedder.this.gramSpace.numberOfRows();
            }

            @Override
            public double evaluate(double[] dArray) {
                return Embedder.this.energy(dArray);
            }
        };
        double[] dArray = this.p;
        int n2 = Math.max(1, this.passes);
        for (int i = 0; i < n2; ++i) {
            this.volumeWeight = Math.pow(10.0, -i);
            this.penaltyFactor = i == n2 - 1 ? 1.0 : 0.0;
            dArray = new Amoeba(function, 1.0E-6, n, 10, 1.0).go(dArray);
            for (int j = 0; j < dArray.length; ++j) {
                this.p[j] = dArray[j];
            }
        }
        this._positionsRelaxed = this.getRelaxPositions();
        this._cellRelaxed = true;
        return n;
    }

    public void reset() {
        this.setPositions(this.initialPlacement);
        this.setGramMatrix(null);
        this._positionsRelaxed = false;
        this._cellRelaxed = false;
    }

    public boolean positionsRelaxed() {
        return this._positionsRelaxed;
    }

    public boolean cellRelaxed() {
        return this._cellRelaxed;
    }

    public double maximalEdgeLength() {
        double d = 0.0;
        for (IEdge iEdge : this.graph.edges()) {
            d = Math.max(d, this.length(iEdge));
        }
        return d;
    }

    public double minimalEdgeLength() {
        double d = Double.MAX_VALUE;
        for (IEdge iEdge : this.graph.edges()) {
            d = Math.min(d, this.length(iEdge));
        }
        return d;
    }

    public double averageEdgeLength() {
        double d = 0.0;
        int n = 0;
        for (IEdge iEdge : this.graph.edges()) {
            d += this.length(iEdge);
            ++n;
        }
        return d / (double)n;
    }

    private class Edge {
        public final INode v;
        public final INode w;
        public final double[] shift;
        public final int type;
        public final double weight;
        public double length;

        public Edge(INode iNode, INode iNode2, Vector vector, int n, double d) {
            this.v = iNode;
            this.w = iNode2;
            this.shift = vector.asDoubleArray();
            this.type = n;
            this.weight = d;
        }
    }

    private class Angle {
        public final INode v;
        public final INode w;
        public final Vector s;

        public Angle(INode iNode, INode iNode2, Vector vector) {
            this.v = iNode;
            this.w = iNode2;
            this.s = vector;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Angle)) {
                return false;
            }
            Angle angle = (Angle)object;
            return this.v.equals(angle.v) && this.w.equals(angle.w) && this.s.equals(angle.s) || this.v.equals(angle.w) && this.w.equals(angle.v) && this.s.equals(angle.s.negative());
        }

        public int hashCode() {
            int n;
            int n2 = this.v.hashCode();
            if (n2 <= (n = this.w.hashCode())) {
                return (n2 * 37 + n) * 37 + this.s.hashCode();
            }
            return (n * 37 + n2) * 37 + this.s.negative().hashCode();
        }
    }
}

