/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.pgraphs.basic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.gavrog.box.collections.FilteredIterator;
import org.gavrog.box.collections.IteratorAdapter;
import org.gavrog.box.collections.Pair;
import org.gavrog.joss.pgraphs.basic.IEdge;
import org.gavrog.joss.pgraphs.basic.IGraph;
import org.gavrog.joss.pgraphs.basic.IGraphElement;
import org.gavrog.joss.pgraphs.basic.INode;

public class UndirectedGraph
implements IGraph {
    private static long nextGraphId = 1L;
    private final Long id;
    private long nextNodeId = 1L;
    private long nextEdgeId = -1L;
    private Map<Long, Class<? extends IGraphElement>> idToType = new HashMap<Long, Class<? extends IGraphElement>>();
    private Map<Long, Set<Long>> nodeIdToIncidentEdgesIds = new LinkedHashMap<Long, Set<Long>>();
    private Map<Long, Integer> nodeIdToDegree = new HashMap<Long, Integer>();
    private Map<Long, Long> edgeIdToSourceNodeId = new HashMap<Long, Long>();
    private Map<Long, Long> edgeIdToTargetNodeId = new HashMap<Long, Long>();

    public UndirectedGraph() {
        this.id = new Long(nextGraphId++);
    }

    @Override
    public Object id() {
        return new Pair(this.getClass(), this.id);
    }

    @Override
    public int numberOfNodes() {
        return this.nodeIdToIncidentEdgesIds.size();
    }

    @Override
    public int numberOfEdges() {
        return this.edgeIdToSourceNodeId.size();
    }

    @Override
    public IteratorAdapter<INode> nodes() {
        return new FilteredIterator<INode, Long>(this.nodeIdToIncidentEdgesIds.keySet().iterator()){

            @Override
            public INode filter(Long l) {
                return new Node(l);
            }
        };
    }

    @Override
    public IteratorAdapter<IEdge> edges() {
        return new FilteredIterator<IEdge, Long>(this.edgeIdToSourceNodeId.keySet().iterator()){

            @Override
            public IEdge filter(Long l) {
                return new Edge(l, false);
            }
        };
    }

    @Override
    public INode getNode(long l) {
        return new Node(l);
    }

    @Override
    public IEdge getEdge(long l) {
        return new Edge(l, false);
    }

    @Override
    public boolean hasNode(INode iNode) {
        return iNode != null && iNode.owner() == this && this.nodeIdToDegree.get(iNode.id()) != null;
    }

    @Override
    public boolean hasEdge(IEdge iEdge) {
        return iEdge != null && iEdge.owner() == this && this.edgeIdToSourceNodeId.get(iEdge.id()) != null;
    }

    public IteratorAdapter<IEdge> connectingEdges(INode iNode, INode iNode2) {
        if (!this.hasNode(iNode)) {
            throw new IllegalArgumentException("source node not in graph");
        }
        if (!this.hasNode(iNode2)) {
            throw new IllegalArgumentException("source node not in graph");
        }
        final long l = iNode.id();
        final long l2 = iNode2.id();
        Set<Long> set = this.nodeIdToIncidentEdgesIds.get(l);
        return new FilteredIterator<IEdge, Long>(set.iterator()){

            @Override
            public Edge filter(Long l3) {
                Object v = UndirectedGraph.this.edgeIdToSourceNodeId.get(l3);
                Object v2 = UndirectedGraph.this.edgeIdToTargetNodeId.get(l3);
                if (v.equals(l) && v2.equals(l2)) {
                    return new Edge(l3, false);
                }
                if (v.equals(l2) && v2.equals(l)) {
                    return new Edge(l3, true);
                }
                return null;
            }
        };
    }

    @Override
    public INode newNode() {
        Long l = new Long(this.nextNodeId++);
        this.idToType.put(l, Node.class);
        this.nodeIdToIncidentEdgesIds.put(l, new LinkedHashSet());
        this.nodeIdToDegree.put(l, new Integer(0));
        return new Node(l);
    }

    @Override
    public IEdge newEdge(INode iNode, INode iNode2) {
        Long l = new Long(this.nextEdgeId--);
        if (!this.hasNode(iNode)) {
            throw new IllegalArgumentException("source node does not exist");
        }
        if (!this.hasNode(iNode2)) {
            throw new IllegalArgumentException("target node does not exist");
        }
        long l2 = iNode.id();
        long l3 = iNode2.id();
        this.idToType.put(l, Edge.class);
        this.edgeIdToSourceNodeId.put(l, l2);
        this.edgeIdToTargetNodeId.put(l, l3);
        this.nodeIdToIncidentEdgesIds.get(l2).add(l);
        this.nodeIdToIncidentEdgesIds.get(l3).add(l);
        this.nodeIdToDegree.put(l2, this.nodeIdToDegree.get(l2) + 1);
        this.nodeIdToDegree.put(l3, this.nodeIdToDegree.get(l3) + 1);
        return new Edge(l, false);
    }

    @Override
    public void delete(INode iNode) {
        if (iNode.degree() > 0) {
            throw new UnsupportedOperationException("node must be isolated");
        }
        this.nodeIdToIncidentEdgesIds.remove(iNode.id());
        this.nodeIdToDegree.remove(iNode.id());
        this.idToType.remove(iNode.id());
    }

    @Override
    public void delete(IEdge iEdge) {
        long l = iEdge.id();
        long l2 = iEdge.source().id();
        long l3 = iEdge.target().id();
        this.nodeIdToIncidentEdgesIds.get(l2).remove(l);
        this.nodeIdToIncidentEdgesIds.get(l3).remove(l);
        this.edgeIdToSourceNodeId.remove(l);
        this.edgeIdToTargetNodeId.remove(l);
        this.nodeIdToDegree.put(l2, this.nodeIdToDegree.get(l2) - 1);
        this.nodeIdToDegree.put(l3, this.nodeIdToDegree.get(l3) - 1);
        this.idToType.remove(l);
    }

    protected int compareIds(IGraphElement iGraphElement, IGraphElement iGraphElement2) {
        return Long.valueOf(iGraphElement.id()).compareTo(iGraphElement2.id());
    }

    protected IEdge normalizedEdge(IEdge iEdge) {
        if (this.compareIds(iEdge.source(), iEdge.target()) <= 0) {
            return iEdge;
        }
        return iEdge.reverse();
    }

    protected int compareEdges(IEdge iEdge, IEdge iEdge2) {
        int n = this.compareIds(iEdge.source(), iEdge2.source());
        if (n != 0) {
            return n;
        }
        n = this.compareIds(iEdge.target(), iEdge2.target());
        if (n != 0) {
            return n;
        }
        return -this.compareIds(iEdge, iEdge2);
    }

    protected String formatEdgeInfo(IEdge iEdge) {
        return null;
    }

    public String toString() {
        ArrayList<IEdge> arrayList = new ArrayList<IEdge>();
        for (IEdge object22 : this.edges()) {
            arrayList.add(this.normalizedEdge(object22));
        }
        Collections.sort(arrayList, new Comparator<IEdge>(){

            @Override
            public int compare(IEdge iEdge, IEdge iEdge2) {
                return UndirectedGraph.this.compareEdges(iEdge, iEdge2);
            }
        });
        ArrayList arrayList2 = new ArrayList();
        for (INode iNode : this.nodes()) {
            if (iNode.degree() != 0) continue;
            arrayList2.add((Node)iNode);
        }
        Collections.sort(arrayList2);
        StringBuffer stringBuffer = new StringBuffer(100);
        for (IEdge iEdge : arrayList) {
            stringBuffer.append("(");
            stringBuffer.append(iEdge.source().id());
            stringBuffer.append(",");
            stringBuffer.append(iEdge.target().id());
            String string = this.formatEdgeInfo(iEdge);
            if (string != null && string.length() > 0) {
                stringBuffer.append(",");
                stringBuffer.append(string);
            }
            stringBuffer.append(")");
        }
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            INode iNode = (INode)iterator.next();
            stringBuffer.append("(");
            stringBuffer.append(iNode.id());
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    protected class Edge
    implements IEdge {
        private final long id;
        private boolean compareAsOriented;
        protected final boolean isReverse;

        public Edge(long l, boolean bl, boolean bl2) {
            this.id = l;
            this.isReverse = bl;
            this.compareAsOriented = bl2;
        }

        public Edge(long l, boolean bl) {
            this(l, bl, false);
        }

        @Override
        public INode source() {
            if (this.isReverse) {
                return new Node((Long)UndirectedGraph.this.edgeIdToTargetNodeId.get(this.id()));
            }
            return new Node((Long)UndirectedGraph.this.edgeIdToSourceNodeId.get(this.id()));
        }

        @Override
        public INode target() {
            if (this.isReverse) {
                return new Node((Long)UndirectedGraph.this.edgeIdToSourceNodeId.get(this.id()));
            }
            return new Node((Long)UndirectedGraph.this.edgeIdToTargetNodeId.get(this.id()));
        }

        @Override
        public INode opposite(INode iNode) {
            if (this.source().equals(iNode)) {
                return this.target();
            }
            if (this.target().equals(iNode)) {
                return this.source();
            }
            throw new IllegalArgumentException("edge has no such vertex");
        }

        @Override
        public IEdge reverse() throws UnsupportedOperationException {
            return new Edge(this.id, !this.isReverse, this.compareAsOriented);
        }

        @Override
        public IGraph owner() {
            return UndirectedGraph.this;
        }

        @Override
        public long id() {
            return this.id;
        }

        public boolean equals(Object object) {
            if (object instanceof Edge) {
                Edge edge = (Edge)object;
                if (!this.owner().id().equals(edge.owner().id()) || this.id != edge.id) {
                    return false;
                }
                if (this.compareAsOriented != edge.compareAsOriented) {
                    return false;
                }
                if (this.compareAsOriented) {
                    return this.isReverse == edge.isReverse;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            int n = this.owner().id().hashCode() * 37 + (int)this.id;
            if (this.compareAsOriented) {
                return n * 37 + (this.isReverse ? 1 : 0);
            }
            return n;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(20);
            stringBuffer.append("(");
            stringBuffer.append(this.source().id());
            stringBuffer.append(",");
            stringBuffer.append(this.target().id());
            String string = UndirectedGraph.this.formatEdgeInfo(this);
            if (string != null && string.length() > 0) {
                stringBuffer.append(",");
                stringBuffer.append(string);
            }
            stringBuffer.append(")");
            return stringBuffer.toString();
        }

        @Override
        public IEdge oriented() {
            return new Edge(this.id(), this.isReverse, true);
        }

        @Override
        public IEdge unoriented() {
            return new Edge(this.id(), this.isReverse, false);
        }
    }

    protected class Node
    implements INode,
    Comparable<INode> {
        private final long id;

        public Node(long l) {
            this.id = l;
        }

        @Override
        public int degree() {
            return (Integer)UndirectedGraph.this.nodeIdToDegree.get(this.id);
        }

        @Override
        public IGraph owner() {
            return UndirectedGraph.this;
        }

        @Override
        public IteratorAdapter<IEdge> incidences() {
            Set set = (Set)UndirectedGraph.this.nodeIdToIncidentEdgesIds.get(this.id);
            return new FilteredIterator<IEdge, Long>(set.iterator()){

                @Override
                public IEdge filter(Long l) {
                    if (((Long)UndirectedGraph.this.edgeIdToSourceNodeId.get(l)).equals(Node.this.id())) {
                        return new Edge(l, false);
                    }
                    if (((Long)UndirectedGraph.this.edgeIdToTargetNodeId.get(l)).equals(Node.this.id())) {
                        return new Edge(l, true);
                    }
                    throw new RuntimeException("inconsistency in graph");
                }
            };
        }

        @Override
        public long id() {
            return this.id;
        }

        public boolean equals(Object object) {
            if (object instanceof Node) {
                Node node = (Node)object;
                return this.owner().id().equals(node.owner().id()) && this.id == node.id();
            }
            return false;
        }

        public int hashCode() {
            return this.owner().id().hashCode() * 37 + (int)this.id;
        }

        public String toString() {
            return "Node " + this.id;
        }

        @Override
        public int compareTo(INode iNode) {
            return (int)this.id() - (int)iNode.id();
        }
    }
}

