/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.pgraphs.basic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import org.gavrog.box.collections.Cache;
import org.gavrog.box.collections.CacheMissException;
import org.gavrog.box.collections.FilteredIterator;
import org.gavrog.box.collections.IteratorAdapter;
import org.gavrog.box.collections.Iterators;
import org.gavrog.box.collections.NiftyList;
import org.gavrog.box.collections.Pair;
import org.gavrog.box.collections.Partition;
import org.gavrog.box.simple.Tag;
import org.gavrog.box.simple.TaskController;
import org.gavrog.jane.compounds.LinearAlgebra;
import org.gavrog.jane.compounds.Matrix;
import org.gavrog.jane.numbers.ArithmeticBase;
import org.gavrog.jane.numbers.Fraction;
import org.gavrog.jane.numbers.IArithmetic;
import org.gavrog.jane.numbers.Real;
import org.gavrog.jane.numbers.Whole;
import org.gavrog.joss.geometry.CoordinateChange;
import org.gavrog.joss.geometry.Operator;
import org.gavrog.joss.geometry.Point;
import org.gavrog.joss.geometry.SpaceGroup;
import org.gavrog.joss.geometry.SpaceGroupFinder;
import org.gavrog.joss.geometry.Vector;
import org.gavrog.joss.pgraphs.basic.Cover;
import org.gavrog.joss.pgraphs.basic.IEdge;
import org.gavrog.joss.pgraphs.basic.IGraph;
import org.gavrog.joss.pgraphs.basic.INode;
import org.gavrog.joss.pgraphs.basic.Morphism;
import org.gavrog.joss.pgraphs.basic.UndirectedGraph;

public class PeriodicGraph
extends UndirectedGraph {
    protected static final boolean DEBUG = false;
    protected static final Tag CONNECTED_COMPONENTS = new Tag();
    protected static final Tag BARYCENTRIC_PLACEMENT = new Tag();
    protected static final Tag IS_LOCALLY_STABLE = new Tag();
    protected static final Tag IS_LADDER = new Tag();
    protected static final Tag CHARACTERISTIC_BASES = new Tag();
    protected static final Tag SYMMETRIES = new Tag();
    protected static final Tag INVARIANT = new Tag();
    protected static final Tag CONVENTIONAL_CELL = new Tag();
    protected static final Tag TRANSLATIONAL_EQUIVALENCE_CLASSES = new Tag();
    protected static final Tag MINIMAL_IMAGE_MAP = new Tag();
    protected static final Tag HAS_SECOND_ORDER_COLLISIONS = new Tag();
    private static final Tag TRANSLATIONAL_EQUIVALENCES = null;
    protected final Cache<Tag, Object> cache = new Cache();
    public final String invariantVersion = "1.0";
    protected final int dimension;
    protected final Map<Long, Vector> edgeIdToShift = new HashMap<Long, Vector>();

    public PeriodicGraph(int n) {
        this.dimension = n;
    }

    public PeriodicGraph(PeriodicGraph periodicGraph) {
        this(periodicGraph.getDimension());
        HashMap<INode, INode> hashMap = new HashMap<INode, INode>();
        for (INode iGraphElement : periodicGraph.nodes()) {
            hashMap.put(iGraphElement, this.newNode());
        }
        for (IEdge iEdge : periodicGraph.edges()) {
            INode iNode = (INode)hashMap.get(iEdge.source());
            INode iNode2 = (INode)hashMap.get(iEdge.target());
            this.newEdge(iNode, iNode2, periodicGraph.getShift(iEdge));
        }
    }

    public int getDimension() {
        return this.dimension;
    }

    public Vector getShift(IEdge iEdge) {
        if (this.hasEdge(iEdge)) {
            Vector vector = this.edgeIdToShift.get(iEdge.id());
            if (((UndirectedGraph.Edge)iEdge).isReverse) {
                return (Vector)vector.negative();
            }
            return vector;
        }
        throw new IllegalArgumentException("no such edge");
    }

    public IEdge getEdge(INode iNode, INode iNode2, Vector vector) {
        for (IEdge iEdge : this.connectingEdges(iNode, iNode2)) {
            if (this.getShift(iEdge).equals(vector)) {
                return iEdge;
            }
            if (!iNode.equals(iNode2) || !this.getShift(iEdge).equals(vector.negative())) continue;
            return iEdge.reverse();
        }
        return null;
    }

    @Override
    public IEdge newEdge(INode iNode, INode iNode2) {
        return this.newEdge(iNode, iNode2, Vector.zero(this.getDimension()));
    }

    public IEdge newEdge(INode iNode, INode iNode2, int[] nArray) {
        return this.newEdge(iNode, iNode2, new Vector(nArray));
    }

    public IEdge newEdge(INode iNode, INode iNode2, Vector vector) {
        return this.newEdge(iNode, iNode2, vector, true);
    }

    public IEdge newEdge(INode iNode, INode iNode2, Vector vector, boolean bl) {
        if (vector.getDimension() != this.dimension) {
            throw new IllegalArgumentException("bad shape for shift");
        }
        if (bl) {
            if (this.getEdge(iNode, iNode2, vector) != null) {
                throw new IllegalArgumentException("duplicate edge");
            }
            if (iNode.equals(iNode2) && vector.equals(vector.zero())) {
                throw new IllegalArgumentException("trivial loop");
            }
        }
        this.cache.clear();
        IEdge iEdge = super.newEdge(iNode, iNode2);
        this.edgeIdToShift.put(iEdge.id(), new Vector(vector));
        return iEdge;
    }

    @Override
    public INode newNode() {
        this.cache.clear();
        return super.newNode();
    }

    @Override
    public void delete(IEdge iEdge) {
        this.edgeIdToShift.remove(iEdge.id());
        super.delete(iEdge);
    }

    public void shiftNode(INode iNode, Vector vector) {
        if (!vector.isIntegral()) {
            throw new IllegalArgumentException("argument vector must be integral");
        }
        if (vector.getDimension() != this.getDimension()) {
            throw new IllegalArgumentException("argument vector has dimension " + vector.getDimension() + ", but should have " + this.getDimension());
        }
        for (IEdge object : iNode.incidences()) {
            long l;
            if (object.source().equals(object.target())) continue;
            if (((UndirectedGraph.Edge)object).isReverse) {
                l = object.reverse().id();
                this.edgeIdToShift.put(l, (Vector)this.edgeIdToShift.get(l).minus(vector));
                continue;
            }
            l = object.id();
            this.edgeIdToShift.put(l, (Vector)this.edgeIdToShift.get(l).plus(vector));
        }
        try {
            Map map = (Map)this.cache.get(BARYCENTRIC_PLACEMENT);
            HashMap<INode, Point> hashMap = new HashMap<INode, Point>();
            hashMap.putAll(map);
            hashMap.put(iNode, (Point)((Point)hashMap.get(iNode)).plus(vector));
            this.cache.put(BARYCENTRIC_PLACEMENT, Collections.unmodifiableMap(hashMap));
        }
        catch (CacheMissException cacheMissException) {
            // empty catch block
        }
    }

    @Override
    protected int compareEdges(IEdge iEdge, IEdge iEdge2) {
        int n = super.compareEdges(iEdge, iEdge2);
        if (n != 0) {
            return n;
        }
        return this.getShift(iEdge).compareTo(this.getShift(iEdge2));
    }

    @Override
    protected IEdge normalizedEdge(IEdge iEdge) {
        int n = this.compareIds(iEdge.source(), iEdge.target());
        if (n == 0) {
            n = this.getShift(iEdge).sign();
        }
        if (n > 0) {
            return iEdge.reverse();
        }
        return iEdge;
    }

    @Override
    protected String formatEdgeInfo(IEdge iEdge) {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("[");
        Vector vector = this.getShift(iEdge);
        for (int i = 0; i < this.dimension; ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(vector.get(i));
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public Iterator<Integer> coordinationSequence(final INode iNode) {
        final HashSet hashSet = new HashSet();
        final HashSet hashSet2 = new HashSet();
        return new IteratorAdapter<Integer>(){

            @Override
            protected Integer findNext() throws NoSuchElementException {
                if (hashSet2.size() == 0) {
                    hashSet2.add(new CoverNode(iNode));
                } else {
                    HashSet<CoverNode> hashSet3 = new HashSet<CoverNode>();
                    for (CoverNode coverNode : hashSet2) {
                        Iterator<CoverEdge> iterator = coverNode.incidences();
                        while (iterator.hasNext()) {
                            CoverEdge coverEdge = iterator.next();
                            CoverNode coverNode2 = coverEdge.target();
                            if (hashSet.contains(coverNode2) || hashSet2.contains(coverNode2) || hashSet3.contains(coverNode2)) continue;
                            hashSet3.add(coverNode2);
                        }
                    }
                    hashSet.clear();
                    hashSet.addAll(hashSet2);
                    hashSet2.clear();
                    hashSet2.addAll(hashSet3);
                }
                return hashSet2.size();
            }
        };
    }

    public List<CoverNode> shortestCycleAtAngle(CoverNode coverNode, CoverNode coverNode2, CoverNode coverNode3, int n) {
        if (coverNode == coverNode2 || coverNode == coverNode3 || coverNode2 == coverNode3) {
            throw new IllegalArgumentException("Must be pairwise distinct.");
        }
        HashMap<CoverNode, CoverNode> hashMap = new HashMap<CoverNode, CoverNode>();
        LinkedList<CoverNode> linkedList = new LinkedList<CoverNode>();
        hashMap.put(coverNode2, coverNode2);
        hashMap.put(coverNode3, coverNode2);
        linkedList.add(coverNode3);
        while (!linkedList.isEmpty() && hashMap.size() < n) {
            CoverNode coverNode4 = (CoverNode)linkedList.remove(0);
            Iterator<CoverEdge> iterator = coverNode4.incidences();
            while (iterator.hasNext()) {
                CoverEdge coverEdge = iterator.next();
                CoverNode coverNode5 = coverEdge.target();
                if (coverNode5.equals(coverNode)) {
                    ArrayList<CoverNode> arrayList = new ArrayList<CoverNode>();
                    arrayList.add(coverNode2);
                    arrayList.add(coverNode);
                    CoverNode coverNode6 = coverNode4;
                    while (coverNode6 != coverNode2) {
                        arrayList.add(coverNode6);
                        coverNode6 = (CoverNode)hashMap.get(coverNode6);
                    }
                    return arrayList;
                }
                if (hashMap.containsKey(coverNode5)) continue;
                hashMap.put(coverNode5, coverNode4);
                linkedList.add(coverNode5);
            }
        }
        return null;
    }

    public List<CoverNode> shortestCycleAtAngle(CoverNode coverNode, CoverNode coverNode2, CoverNode coverNode3) {
        return this.shortestCycleAtAngle(coverNode, coverNode2, coverNode3, 1000000);
    }

    public String pointSymbol(INode iNode, int n) {
        int n2;
        Object object;
        CoverNode coverNode = new CoverNode(iNode);
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
        ArrayList arrayList = new ArrayList();
        Iterators.addAll(arrayList, coverNode.incidences());
        for (int i = 0; i < arrayList.size(); ++i) {
            object = ((CoverEdge)arrayList.get(i)).target();
            for (n2 = i + 1; n2 < arrayList.size(); ++n2) {
                CoverNode coverNode2 = ((CoverEdge)arrayList.get(n2)).target();
                int n3 = this.shortestCycleAtAngle((CoverNode)object, coverNode, coverNode2, n).size();
                if (treeMap.containsKey(n3)) {
                    treeMap.put(n3, (Integer)treeMap.get(n3) + 1);
                    continue;
                }
                treeMap.put(n3, 1);
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        object = treeMap.keySet().iterator();
        while (object.hasNext()) {
            n2 = (Integer)object.next();
            int n4 = (Integer)treeMap.get(n2);
            if (stringBuffer.length() > 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append(n2);
            if (n4 <= 1) continue;
            stringBuffer.append('^');
            stringBuffer.append(n4);
        }
        return stringBuffer.toString();
    }

    public String pointSymbol(INode iNode) {
        return this.pointSymbol(iNode, 1000000);
    }

    public List<Component> connectedComponents() {
        try {
            List list = (List)this.cache.get(CONNECTED_COMPONENTS);
            return list;
        }
        catch (CacheMissException cacheMissException) {
            Object object;
            Object object2;
            Object object3;
            ArrayList<Vector> arrayList;
            List<Object> list;
            int n = this.getDimension();
            HashSet<Object> hashSet = new HashSet<Object>();
            HashMap<Object, Vector> hashMap = new HashMap<Object, Vector>();
            ArrayList arrayList2 = new ArrayList();
            for (INode object4 : this.nodes()) {
                if (hashSet.contains(object4)) continue;
                ArrayList<Vector> arrayList3 = new ArrayList<Vector>();
                list = new LinkedList();
                arrayList = new ArrayList();
                ((LinkedList)list).addLast(object4);
                hashSet.add(object4);
                arrayList.add((Vector)((Object)object4));
                hashMap.put(object4, Vector.zero(n));
                while (((LinkedList)list).size() > 0) {
                    object3 = (INode)((LinkedList)list).removeFirst();
                    Vector vector = (Vector)hashMap.get(object3);
                    for (IEdge iEdge : object3.incidences()) {
                        object2 = iEdge.target();
                        object = this.getShift(iEdge);
                        if (!hashSet.contains(object2)) {
                            ((LinkedList)list).addLast(object2);
                            hashSet.add(object2);
                            arrayList.add((Vector)object2);
                            hashMap.put(object2, (Vector)vector.minus(object));
                            continue;
                        }
                        Vector vector2 = (Vector)hashMap.get(object2);
                        arrayList3.add((Vector)((Vector)object).plus(vector2).minus(vector));
                    }
                }
                arrayList2.add(new Pair(arrayList, arrayList3));
            }
            ArrayList arrayList3 = new ArrayList();
            for (Pair pair : arrayList2) {
                list = (List)pair.getFirst();
                arrayList = (List)pair.getSecond();
                object3 = Vector.toMatrix(arrayList).mutableClone();
                Matrix.triangulate((Matrix)object3, null, true, true);
                int n2 = ((Matrix)object3).rank();
                Matrix matrix = ((Matrix)object3).getSubMatrix(0, 0, n2, n);
                CoordinateChange coordinateChange = new CoordinateChange(matrix);
                object2 = new PeriodicGraph(n2);
                object = new HashMap();
                for (INode iNode : list) {
                    object.put(iNode, ((PeriodicGraph)object2).newNode());
                }
                for (IEdge iEdge : this.edges()) {
                    INode iNode = (INode)object.get(iEdge.source());
                    INode iNode2 = (INode)object.get(iEdge.target());
                    if (iNode == null || iNode2 == null) continue;
                    Vector vector = this.getShift(iEdge);
                    Vector vector3 = (Vector)hashMap.get(iEdge.source());
                    Vector vector4 = (Vector)hashMap.get(iEdge.target());
                    Vector vector5 = (Vector)vector.plus(vector4).minus(vector3).times(coordinateChange);
                    Matrix matrix2 = vector5.getCoordinates().getSubMatrix(0, 0, 1, n2);
                    ((PeriodicGraph)object2).newEdge(iNode, iNode2, new Vector(matrix2));
                }
                arrayList3.add(new Component((PeriodicGraph)object2, matrix));
            }
            this.cache.put(CONNECTED_COMPONENTS, arrayList3);
            return arrayList3;
        }
    }

    public boolean isConnected() {
        List<Component> list = this.connectedComponents();
        int n = list.size();
        if (n == 0) {
            return true;
        }
        if (n == 1) {
            return list.get(0).getMultiplicity().equals(Whole.ONE);
        }
        return false;
    }

    public Map<INode, Point> barycentricPlacement() {
        if (!this.isConnected()) {
            throw new UnsupportedOperationException("graph must be connected");
        }
        try {
            Map map = (Map)this.cache.get(BARYCENTRIC_PLACEMENT);
            return map;
        }
        catch (CacheMissException cacheMissException) {
            Object object;
            HashMap<INode, Integer> hashMap = new HashMap<INode, Integer>();
            ArrayList<INode> arrayList = new ArrayList<INode>();
            for (INode object22 : this.nodes()) {
                hashMap.put(object22, new Integer(arrayList.size()));
                arrayList.add(object22);
            }
            int n = arrayList.size();
            int[][] nArray = new int[n + 1][n];
            Matrix matrix = Matrix.zero(n + 1, this.dimension);
            for (int matrix2 = 0; matrix2 < n; ++matrix2) {
                object = (INode)arrayList.get(matrix2);
                for (IEdge iEdge : object.incidences()) {
                    INode iNode = iEdge.target();
                    if (object.equals(iNode)) continue;
                    Vector vector = this.getShift(iEdge);
                    int n2 = (Integer)hashMap.get(iNode);
                    int[] nArray2 = nArray[matrix2];
                    int n3 = n2;
                    nArray2[n3] = nArray2[n3] - 1;
                    int[] nArray3 = nArray[matrix2];
                    int n4 = matrix2;
                    nArray3[n4] = nArray3[n4] + 1;
                    matrix.setRow(matrix2, (Matrix)matrix.getRow(matrix2).plus(vector.getCoordinates()));
                }
            }
            nArray[n][0] = 1;
            Matrix matrix2 = Matrix.solve(new Matrix(nArray), matrix);
            object = new HashMap();
            for (int map = 0; map < n; ++map) {
                object.put(arrayList.get(map), new Point(matrix2.getRow(map)));
            }
            Map<INode, Point> map = Collections.unmodifiableMap(object);
            this.cache.put(BARYCENTRIC_PLACEMENT, map);
            return map;
        }
    }

    public boolean isBarycentric(Map<INode, Point> map) {
        for (INode iNode : this.nodes()) {
            Point point = map.get(iNode);
            Vector vector = Vector.zero(this.getDimension());
            for (IEdge iEdge : iNode.incidences()) {
                INode iNode2 = iEdge.target();
                if (iNode2.equals(iNode)) continue;
                Vector vector2 = this.getShift(iEdge);
                Point point2 = map.get(iNode2);
                vector = (Vector)vector.plus(point2).plus(vector2).minus(point);
            }
            if (vector.isZero()) continue;
            return false;
        }
        return true;
    }

    public boolean isStable() {
        Map<INode, Point> map = this.barycentricPlacement();
        HashSet<Point> hashSet = new HashSet<Point>();
        for (INode iNode : this.nodes()) {
            Point point = map.get(iNode);
            IArithmetic[] iArithmeticArray = new Real[point.getDimension()];
            for (int i = 0; i < point.getDimension(); ++i) {
                iArithmeticArray[i] = (Real)point.get(i).mod(Whole.ONE);
            }
            Point point2 = new Point(iArithmeticArray);
            if (hashSet.contains(point2)) {
                return false;
            }
            hashSet.add(point2);
        }
        return true;
    }

    public boolean isLocallyStable() {
        try {
            return (Boolean)this.cache.get(IS_LOCALLY_STABLE);
        }
        catch (CacheMissException cacheMissException) {
            Map<INode, Point> map = this.barycentricPlacement();
            for (INode iNode : this.nodes()) {
                HashSet<Point> hashSet = new HashSet<Point>();
                for (IEdge iEdge : iNode.incidences()) {
                    Vector vector = this.getShift(iEdge);
                    Point point = map.get(iEdge.target());
                    Point point2 = (Point)point.plus(vector);
                    if (hashSet.contains(point2)) {
                        this.cache.put(IS_LOCALLY_STABLE, false);
                        return false;
                    }
                    hashSet.add(point2);
                }
            }
            this.cache.put(IS_LOCALLY_STABLE, true);
            return true;
        }
    }

    public boolean hasSecondOrderCollisions() {
        try {
            return (Boolean)this.cache.get(HAS_SECOND_ORDER_COLLISIONS);
        }
        catch (CacheMissException cacheMissException) {
            Map<INode, Point> map = this.barycentricPlacement();
            HashSet hashSet = new HashSet();
            for (INode iNode : this.nodes()) {
                Point point = map.get(iNode);
                IArithmetic[] iArithmeticArray = new Real[point.getDimension()];
                for (int i = 0; i < point.getDimension(); ++i) {
                    iArithmeticArray[i] = (Real)point.get(i).mod(Whole.ONE);
                }
                Point point2 = new Point(iArithmeticArray);
                LinkedList<Point> linkedList = new LinkedList<Point>();
                for (Vector vector : Morphism.neighborVectors(iNode).keySet()) {
                    linkedList.add((Point)vector.plus(point2));
                }
                Collections.sort(linkedList);
                linkedList.addFirst(point2);
                if (hashSet.contains(linkedList)) {
                    this.cache.put(HAS_SECOND_ORDER_COLLISIONS, true);
                    return true;
                }
                hashSet.add(linkedList);
            }
            this.cache.put(HAS_SECOND_ORDER_COLLISIONS, false);
            return false;
        }
    }

    public boolean isLadder() {
        try {
            return (Boolean)this.cache.get(IS_LADDER);
        }
        catch (CacheMissException cacheMissException) {
            if (!this.isConnected()) {
                throw new UnsupportedOperationException("graph must be connected");
            }
            if (this.isStable() || !this.isLocallyStable()) {
                this.cache.put(IS_LADDER, false);
                return false;
            }
            Operator operator = Operator.identity(this.getDimension());
            IteratorAdapter<INode> iteratorAdapter = this.nodes();
            INode iNode = (INode)iteratorAdapter.next();
            Map<INode, Point> map = this.barycentricPlacement();
            Point point = map.get(iNode);
            while (iteratorAdapter.hasNext()) {
                INode iNode2 = (INode)iteratorAdapter.next();
                Point point2 = map.get(iNode2);
                if (!((Vector)point2.minus(point)).modZ().isZero()) continue;
                try {
                    new Morphism(iNode, iNode2, operator);
                    this.cache.put(IS_LADDER, true);
                    return true;
                }
                catch (Morphism.NoSuchMorphismException noSuchMorphismException) {
                }
            }
            this.cache.put(IS_LADDER, false);
            return false;
        }
    }

    public Iterator<Set<INode>> translationalEquivalenceClasses() {
        return this.translationalEquivalences().classes();
    }

    public Partition<INode> translationalEquivalences() {
        if (!this.isConnected()) {
            throw new UnsupportedOperationException("graph must be connected");
        }
        if (!this.isLocallyStable()) {
            throw new UnsupportedOperationException("graph must be locally stable");
        }
        try {
            Partition partition = (Partition)this.cache.get(TRANSLATIONAL_EQUIVALENCES);
            return partition;
        }
        catch (CacheMissException cacheMissException) {
            Operator operator = Operator.identity(this.getDimension());
            Partition<INode> partition = new Partition<INode>();
            IteratorAdapter<INode> iteratorAdapter = this.nodes();
            INode iNode = (INode)iteratorAdapter.next();
            while (iteratorAdapter.hasNext()) {
                Morphism morphism;
                INode iNode2 = (INode)iteratorAdapter.next();
                if (partition.areEquivalent(iNode, iNode2)) continue;
                try {
                    morphism = new Morphism(iNode, iNode2, operator);
                }
                catch (Morphism.NoSuchMorphismException noSuchMorphismException) {
                    continue;
                }
                for (INode iNode3 : this.nodes()) {
                    partition.unite(iNode3, (INode)morphism.get(iNode3));
                }
            }
            this.cache.put(TRANSLATIONAL_EQUIVALENCES, partition);
            return partition;
        }
    }

    public boolean isMinimal() {
        return !this.translationalEquivalenceClasses().hasNext();
    }

    public Morphism minimalImageMap() {
        try {
            return (Morphism)this.cache.get(MINIMAL_IMAGE_MAP);
        }
        catch (CacheMissException cacheMissException) {
            Object object;
            Object object2;
            Object object5;
            int n = this.getDimension();
            Map<INode, Point> map = this.barycentricPlacement();
            List<Set<INode>> list = Iterators.asList(this.translationalEquivalenceClasses());
            if (list.size() == 0) {
                INode iNode = this.nodes().next();
                Morphism morphism = new Morphism(iNode, iNode, Operator.identity(n));
                this.cache.put(MINIMAL_IMAGE_MAP, morphism);
                return morphism;
            }
            ArrayList<Vector> arrayList = new ArrayList<Vector>();
            Object object6 = list.get(0).iterator();
            Object object7 = object6.next();
            Object object8 = map.get(object7);
            while (object6.hasNext()) {
                object5 = object6.next();
                Point object42 = map.get(object5);
                object2 = ((Vector)object42.minus(object8)).modZ();
                if (((ArithmeticBase)object2).isZero()) {
                    throw new UnsupportedOperationException("found translation of finite order");
                }
                arrayList.add((Vector)object2);
            }
            object6 = new PeriodicGraph(n);
            object7 = new HashMap();
            object8 = new HashMap();
            for (Set set : list) {
                object2 = ((PeriodicGraph)object6).newNode();
                for (INode iNode : set) {
                    object7.put(iNode, object2);
                    if (object8.containsKey(object2)) continue;
                    object8.put(object2, iNode);
                }
            }
            object5 = new Matrix(arrayList.size() + n, n);
            ((Matrix)object5).setSubMatrix(0, 0, Vector.toMatrix(arrayList));
            ((Matrix)object5).setSubMatrix(arrayList.size(), 0, Matrix.one(n));
            Matrix.triangulate((Matrix)object5, null, true, false);
            if (((Matrix)object5).rank() != n) {
                throw new RuntimeException("internal error - please contact author");
            }
            Matrix matrix = ((Matrix)object5).getSubMatrix(0, 0, n, n);
            object2 = new CoordinateChange(matrix);
            for (IEdge iEdge : this.edges()) {
                object = iEdge.source();
                INode iNode = iEdge.target();
                Vector vector = this.getShift(iEdge);
                INode iNode2 = (INode)object7.get(object);
                INode iNode3 = (INode)object7.get(iNode);
                INode iNode4 = (INode)object8.get(iNode2);
                INode iNode5 = (INode)object8.get(iNode3);
                Vector vector2 = (Vector)map.get(object).minus(map.get(iNode4));
                Vector vector3 = (Vector)map.get(iNode).minus(map.get(iNode5));
                Vector vector4 = (Vector)vector3.minus(vector2).plus(vector).times(object2);
                if (((PeriodicGraph)object6).getEdge(iNode2, iNode3, vector4) != null) continue;
                ((PeriodicGraph)object6).newEdge(iNode2, iNode3, vector4);
            }
            INode iNode = this.nodes().next();
            INode iNode6 = (INode)object7.get(iNode);
            object = new Morphism(iNode, iNode6, ((CoordinateChange)object2).getOperator());
            this.cache.put(MINIMAL_IMAGE_MAP, object);
            return object;
        }
    }

    public PeriodicGraph minimalImage() {
        return this.minimalImageMap().getImageGraph();
    }

    public List<List<IEdge>> characteristicBases() {
        try {
            List list = (List)this.cache.get(CHARACTERISTIC_BASES);
            return list;
        }
        catch (CacheMissException cacheMissException) {
            List<IEdge> list;
            LinkedList<List<IEdge>> linkedList = new LinkedList<List<IEdge>>();
            Map<INode, Point> map = this.barycentricPlacement();
            int n = this.getDimension();
            for (INode object : this.nodes()) {
                List<IEdge> list2 = this.allIncidences(object);
                for (List<IEdge> list3 : this.goodCombinations(list2, map)) {
                    linkedList.add(list3);
                }
            }
            if (linkedList.size() == 0) {
                for (INode iNode : this.nodes()) {
                    LinkedList<Iterator<IEdge>> linkedList2 = new LinkedList<Iterator<IEdge>>();
                    LinkedList linkedList3 = new LinkedList();
                    Matrix matrix = Matrix.zero(n, n).mutableClone();
                    linkedList2.addLast(this.allIncidences(iNode).iterator());
                    linkedList3.addLast(null);
                    while (linkedList2.size() > 0) {
                        int n2 = linkedList2.size();
                        Iterator iterator = (Iterator)linkedList2.getLast();
                        if (iterator.hasNext()) {
                            IEdge iEdge = (IEdge)iterator.next();
                            INode iNode2 = iEdge.source();
                            INode iNode3 = iEdge.target();
                            Point point = map.get(iNode2);
                            Point point2 = map.get(iNode3);
                            Vector vector = (Vector)point2.minus(point).plus(this.getShift(iEdge));
                            matrix.setRow(n2 - 1, vector.getCoordinates());
                            if (matrix.rank() != n2) continue;
                            linkedList3.removeLast();
                            linkedList3.addLast(iEdge.oriented());
                            if (n2 == n) {
                                linkedList.add(new LinkedList(linkedList3));
                                continue;
                            }
                            linkedList2.addLast(this.allIncidences(iNode3).iterator());
                            linkedList3.addLast(null);
                            continue;
                        }
                        linkedList2.removeLast();
                        linkedList3.removeLast();
                        matrix.setRow(n2 - 1, Matrix.zero(1, n));
                    }
                }
            }
            if (linkedList.size() == 0) {
                list = this.allDirectedEdges();
                for (List<IEdge> list4 : this.goodCombinations(list, map)) {
                    linkedList.add(list4);
                }
            }
            list = Collections.unmodifiableList(linkedList);
            this.cache.put(CHARACTERISTIC_BASES, list);
            return list;
        }
    }

    public List<IEdge> allIncidences(INode iNode) {
        ArrayList<IEdge> arrayList = new ArrayList<IEdge>();
        for (IEdge iEdge : iNode.incidences()) {
            IEdge iEdge2 = iEdge.oriented();
            arrayList.add(iEdge2);
            if (!iEdge2.source().equals(iEdge2.target())) continue;
            arrayList.add(iEdge2.reverse());
        }
        return arrayList;
    }

    private List<IEdge> allDirectedEdges() {
        ArrayList<IEdge> arrayList = new ArrayList<IEdge>();
        for (IEdge iEdge : this.edges()) {
            IEdge iEdge2 = iEdge.oriented();
            arrayList.add(iEdge2);
            arrayList.add(iEdge2.reverse());
        }
        return arrayList;
    }

    public IteratorAdapter<List<IEdge>> goodCombinations(final List<IEdge> list, final Map<INode, Point> map) {
        final int n = this.getDimension();
        final int n2 = list.size();
        if (n2 < n || n == 0) {
            return Iterators.empty();
        }
        if (n == 1) {
            return new FilteredIterator<List<IEdge>, IEdge>(list.iterator()){

                @Override
                public List<IEdge> filter(IEdge iEdge) {
                    ArrayList<IEdge> arrayList = new ArrayList<IEdge>();
                    arrayList.add(iEdge);
                    return arrayList;
                }
            };
        }
        return new IteratorAdapter<List<IEdge>>(){
            private Iterator<List<IEdge>> perms = Iterators.empty();
            private final int[] a = new int[n];

            @Override
            protected List<IEdge> findNext() throws NoSuchElementException {
                while (!this.perms.hasNext()) {
                    int n4;
                    int n22;
                    if (n > 1 && this.a[1] == 0) {
                        for (n22 = 0; n22 < n; ++n22) {
                            this.a[n22] = n22;
                        }
                        n4 = 0;
                    } else {
                        for (n4 = n - 1; n4 >= 0 && n2 - this.a[n4] <= n - n4; --n4) {
                        }
                        if (n4 < 0) {
                            throw new NoSuchElementException("at end");
                        }
                        int n3 = n4;
                        this.a[n3] = this.a[n3] + 1;
                        for (n22 = n4 + 1; n22 < n; ++n22) {
                            this.a[n22] = this.a[n4] + n22 - n4;
                        }
                    }
                    Matrix matrix = new Matrix(n, n);
                    for (int i = 0; i < n; ++i) {
                        IEdge iEdge = (IEdge)list.get(this.a[i]);
                        Point point = (Point)map.get(iEdge.source());
                        Point point2 = (Point)map.get(iEdge.target());
                        Vector vector = (Vector)point2.minus(point).plus(PeriodicGraph.this.getShift(iEdge));
                        matrix.setRow(i, vector.getCoordinates());
                    }
                    if (matrix.rank() != n) continue;
                    IEdge[] iEdgeArray = new IEdge[n];
                    for (int i = 0; i < n; ++i) {
                        iEdgeArray[i] = (IEdge)list.get(this.a[i]);
                    }
                    this.perms = Iterators.permutations(iEdgeArray);
                }
                return this.perms.next();
            }
        };
    }

    public Set<Morphism> symmetries() {
        try {
            Set set = (Set)this.cache.get(SYMMETRIES);
            return set;
        }
        catch (CacheMissException cacheMissException) {
            Object object;
            Object object2;
            List<IEdge> list;
            if (!this.isConnected()) {
                throw new UnsupportedOperationException("graph must be connected");
            }
            if (!this.isLocallyStable()) {
                throw new UnsupportedOperationException("graph must be locally stable");
            }
            TaskController taskController = TaskController.getInstance();
            LinkedList<Morphism> linkedList = new LinkedList<Morphism>();
            int n = this.getDimension();
            List<List<IEdge>> list2 = this.characteristicBases();
            List<IEdge> list3 = list2.get(0);
            INode iNode = list3.get(0).source();
            Matrix matrix = this.differenceMatrix(list3);
            for (int i = 0; i < list2.size(); ++i) {
                Morphism morphism;
                taskController.bailOutIfCancelled();
                list = list2.get(i);
                object2 = list.get(0).source();
                object = this.differenceMatrix(list);
                Matrix matrix2 = new Matrix(n + 1, n + 1);
                matrix2.setSubMatrix(0, 0, Matrix.solve(matrix, (Matrix)object));
                matrix2.set(n, n, Whole.ONE);
                matrix2.setSubMatrix(n, 0, Matrix.zero(1, n));
                matrix2.setSubMatrix(0, n, Matrix.zero(n, 1));
                if (!matrix2.isUnimodularIntegerMatrix()) continue;
                try {
                    morphism = new Morphism(iNode, (INode)object2, new Operator(matrix2));
                }
                catch (Morphism.NoSuchMorphismException noSuchMorphismException) {
                    continue;
                }
                linkedList.add(morphism);
            }
            HashSet<Object> hashSet = new HashSet<Object>();
            list = new LinkedList<IEdge>();
            object2 = new Morphism(iNode, iNode, Operator.identity(n));
            hashSet.add(object2);
            ((LinkedList)list).addLast((IEdge)object2);
            while (((LinkedList)list).size() > 0) {
                object = (Morphism)((LinkedList)list).removeFirst();
                for (Morphism morphism : linkedList) {
                    Morphism morphism2 = ((Morphism)object).times(morphism);
                    if (hashSet.contains(morphism2)) continue;
                    hashSet.add(morphism2);
                    ((LinkedList)list).addLast((IEdge)((Object)morphism2));
                }
            }
            object = Collections.unmodifiableSet(hashSet);
            this.cache.put(SYMMETRIES, object);
            return object;
        }
    }

    public List<Operator> symmetryOperators() {
        ArrayList<Operator> arrayList = new ArrayList<Operator>();
        for (Morphism morphism : this.symmetries()) {
            arrayList.add(morphism.getAffineOperator());
        }
        return arrayList;
    }

    public SpaceGroup getSpaceGroup() {
        return new SpaceGroup(this.getDimension(), this.symmetryOperators());
    }

    public Vector differenceVector(IEdge iEdge) {
        Map<INode, Point> map = this.barycentricPlacement();
        Point point = map.get(iEdge.source());
        Point point2 = map.get(iEdge.target());
        return (Vector)point2.minus(point).plus(this.getShift(iEdge));
    }

    public Matrix differenceMatrix(List<IEdge> list) {
        int n = list.size();
        Matrix matrix = new Matrix(n, this.getDimension());
        for (int i = 0; i < n; ++i) {
            matrix.setRow(i, this.differenceVector(list.get(i)).getCoordinates());
        }
        return matrix;
    }

    public Matrix symmetricBasis() {
        int n = this.getDimension();
        Set<Morphism> set = this.symmetries();
        Matrix matrix = Matrix.zero(n, n);
        for (Morphism morphism : set) {
            Matrix matrix2 = morphism.getLinearOperator().getCoordinates().getSubMatrix(0, 0, n, n);
            matrix = (Matrix)matrix.plus(matrix2.times(matrix2.transposed()));
        }
        matrix = (Matrix)matrix.times(new Fraction(1L, (long)set.size()));
        return LinearAlgebra.orthonormalRowBasis(matrix);
    }

    public Iterator<Set<INode>> nodeOrbits() {
        HashSet<INode> hashSet = new HashSet<INode>();
        ArrayList arrayList = new ArrayList();
        for (INode iNode : this.nodes()) {
            if (hashSet.contains(iNode)) continue;
            HashSet<INode> hashSet2 = new HashSet<INode>();
            hashSet2.add(iNode);
            hashSet.add(iNode);
            for (Morphism morphism : this.symmetries()) {
                INode iNode2 = morphism.getImage(iNode);
                hashSet2.add(iNode2);
                hashSet.add(iNode2);
            }
            arrayList.add(hashSet2);
        }
        return arrayList.iterator();
    }

    public List<Morphism> nodeStabilizer(INode iNode) {
        ArrayList<Morphism> arrayList = new ArrayList<Morphism>();
        for (Morphism morphism : this.symmetries()) {
            if (!morphism.get(iNode).equals(iNode)) continue;
            arrayList.add(morphism);
        }
        return arrayList;
    }

    public Iterator<Set<IEdge>> edgeOrbits() {
        Partition<IEdge> partition = new Partition<IEdge>();
        for (Morphism morphism : this.symmetries()) {
            for (IEdge iEdge : this.edges()) {
                IEdge iEdge2 = morphism.getImage(iEdge.oriented()).unoriented();
                partition.unite(iEdge, iEdge2);
            }
        }
        return partition.classes();
    }

    public NiftyList<Integer> invariant() {
        try {
            NiftyList niftyList = (NiftyList)this.cache.get(INVARIANT);
            return niftyList;
        }
        catch (CacheMissException cacheMissException) {
            int n;
            int n2;
            Object object;
            LinkedList<Integer> linkedList;
            Object object2;
            if (!this.isConnected()) {
                throw new UnsupportedOperationException("graph must be connected");
            }
            if (!this.isLocallyStable()) {
                throw new UnsupportedOperationException("graph must be locally stable");
            }
            TaskController taskController = TaskController.getInstance();
            int n3 = this.getDimension();
            int n4 = this.numberOfEdges();
            List<List<IEdge>> list = this.characteristicBases();
            Point point = Point.origin(n3);
            class EdgeCmd
            implements Comparable<EdgeCmd> {
                public int source;
                public int target;
                public Vector shift;

                public EdgeCmd(int n, int n2, Vector vector) {
                    this.source = n;
                    this.target = n2;
                    this.shift = vector;
                }

                @Override
                public int compareTo(EdgeCmd edgeCmd) {
                    if (edgeCmd.source != this.source) {
                        return this.source - edgeCmd.source;
                    }
                    if (edgeCmd.target != this.target) {
                        return this.target - edgeCmd.target;
                    }
                    return this.shift.minus(edgeCmd.shift).sign();
                }

                private String shiftAsString() {
                    StringBuffer stringBuffer = new StringBuffer(10);
                    stringBuffer.append("[");
                    Vector vector = this.shift;
                    for (int i = 0; i < vector.getDimension(); ++i) {
                        if (i > 0) {
                            stringBuffer.append(",");
                        }
                        stringBuffer.append(vector.get(i));
                    }
                    stringBuffer.append("]");
                    return stringBuffer.toString();
                }

                public String toString() {
                    return "(" + this.source + "," + this.target + "," + this.shiftAsString() + ")";
                }
            }
            Object[] objectArray = new EdgeCmd[n4];
            Matrix matrix = null;
            INode iNode = null;
            for (int i = 0; i < list.size(); ++i) {
                class Break
                extends Throwable {
                    private static final long serialVersionUID = -4765692704642559061L;

                    Break() {
                    }
                }
                taskController.bailOutIfCancelled();
                List<IEdge> list2 = list.get(i);
                object2 = list2.get(0).source();
                Matrix matrix2 = this.differenceMatrix(list2);
                linkedList = (Matrix)matrix2.inverse();
                object = new LinkedList<Pair<Object, Point>>();
                ((LinkedList)object).addLast(new Pair<Object, Point>(object2, point));
                HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
                hashMap.put(object2, 1);
                HashMap<Object, Point> hashMap2 = new HashMap<Object, Point>();
                hashMap2.put(object2, point);
                int n5 = 2;
                n2 = 0;
                boolean bl = matrix != null;
                CoordinateChange coordinateChange = null;
                Matrix matrix3 = Matrix.zero(n3, n3).mutableClone();
                int n6 = 0;
                try {
                    while (((LinkedList)object).size() > 0) {
                        Pair pair = (Pair)((LinkedList)object).removeFirst();
                        INode iNode2 = (INode)pair.getFirst();
                        int n7 = (Integer)hashMap.get(iNode2);
                        Point point2 = (Point)pair.getSecond();
                        List<IEdge> list3 = this.allIncidences(iNode2);
                        Matrix matrix4 = (Matrix)this.differenceMatrix(list3).times(linkedList);
                        final HashMap<IEdge, Vector> hashMap3 = new HashMap<IEdge, Vector>();
                        for (int j = 0; j < list3.size(); ++j) {
                            hashMap3.put(list3.get(j), new Vector(matrix4.getRow(j)));
                        }
                        Collections.sort(list3, new Comparator<IEdge>(){

                            @Override
                            public int compare(IEdge iEdge, IEdge iEdge2) {
                                Vector vector = (Vector)hashMap3.get(iEdge);
                                Vector vector2 = (Vector)hashMap3.get(iEdge2);
                                return vector.compareTo(vector2);
                            }
                        });
                        for (IEdge iEdge : list3) {
                            Vector vector;
                            int n8;
                            INode iNode3 = iEdge.target();
                            Point point3 = (Point)point2.plus(hashMap3.get(iEdge));
                            if (!hashMap.containsKey(iNode3)) {
                                ((LinkedList)object).addLast(new Pair<INode, Point>(iNode3, point3));
                                n8 = n5++;
                                hashMap.put(iNode3, n8);
                                hashMap2.put(iNode3, point3);
                                vector = Vector.zero(n3);
                            } else {
                                n8 = (Integer)hashMap.get(iNode3);
                                if (n8 < n7) continue;
                                vector = (Vector)point3.minus(hashMap2.get(iNode3));
                                if (coordinateChange != null) {
                                    vector = (Vector)vector.times(coordinateChange);
                                } else {
                                    matrix3.setRow(n6, vector.getCoordinates());
                                    if (matrix3.rank() > n6) {
                                        vector = Vector.unit(n3, n6);
                                        if (++n6 == n3) {
                                            coordinateChange = new CoordinateChange(matrix3);
                                        }
                                    } else {
                                        matrix3.setRow(n6, Matrix.zero(1, n3));
                                        vector = new Vector(LinearAlgebra.solutionInRows(matrix3, vector.getCoordinates(), false));
                                    }
                                }
                            }
                            if (n7 >= n8 && (n7 != n8 || vector.sign() >= 0)) continue;
                            EdgeCmd edgeCmd = new EdgeCmd(n7, n8, vector);
                            if (bl) {
                                int n9 = edgeCmd.compareTo((EdgeCmd)objectArray[n2]);
                                if (n9 < 0) {
                                    bl = false;
                                } else if (n9 > 0) {
                                    throw new Break();
                                }
                            }
                            if (!bl) {
                                objectArray[n2] = edgeCmd;
                            }
                            ++n2;
                        }
                    }
                    if (bl) {
                    }
                }
                catch (Break break_) {}
                continue;
                matrix = (Matrix)coordinateChange.getBasis().times(this.differenceMatrix(list2));
                iNode = list2.get(0).source();
            }
            Matrix matrix5 = Matrix.zero(n4, n3).mutableClone();
            for (int i = 0; i < n4; ++i) {
                matrix5.setRow(i, objectArray[i].shift.getCoordinates());
            }
            Matrix.triangulate(matrix5, null, true, false);
            Matrix matrix6 = matrix5.getSubMatrix(0, 0, n3, n3);
            object2 = new CoordinateChange(matrix6);
            for (int i = 0; i < n4; ++i) {
                linkedList = objectArray[i];
                object = (Vector)((EdgeCmd)((Object)linkedList)).shift.times(object2);
                for (int j = 0; j < n3; ++j) {
                    if (((Vector)object).get(j) instanceof Whole) continue;
                    throw new RuntimeException("internal error - please contact author");
                }
                if (((EdgeCmd)((Object)linkedList)).source == ((EdgeCmd)((Object)linkedList)).target && ((ArithmeticBase)object).sign() > 0) {
                    object = (Vector)((Vector)object).negative();
                }
                objectArray[i] = new EdgeCmd(((EdgeCmd)((Object)linkedList)).source, ((EdgeCmd)((Object)linkedList)).target, (Vector)object);
            }
            Arrays.sort(objectArray);
            PeriodicGraph periodicGraph = new PeriodicGraph(n3);
            linkedList = new LinkedList<Integer>();
            linkedList.add(this.getDimension());
            int n10 = this.numberOfNodes();
            INode[] iNodeArray = new INode[n10 + 1];
            for (n = 1; n <= n10; ++n) {
                iNodeArray[n] = periodicGraph.newNode();
            }
            for (n = 0; n < n4; ++n) {
                Object object3 = objectArray[n];
                periodicGraph.newEdge(iNodeArray[((EdgeCmd)object3).source], iNodeArray[((EdgeCmd)object3).target], ((EdgeCmd)object3).shift);
                linkedList.add(((EdgeCmd)object3).source);
                linkedList.add(((EdgeCmd)object3).target);
                for (n2 = 0; n2 < n3; ++n2) {
                    linkedList.add(((Whole)((EdgeCmd)object3).shift.get(n2)).intValue());
                }
            }
            if (matrix != null) {
                Matrix matrix7 = (Matrix)matrix.inverse().times(((CoordinateChange)object2).getBasis().inverse());
                try {
                    new Morphism(iNode, iNodeArray[1], matrix7);
                }
                catch (Morphism.NoSuchMorphismException noSuchMorphismException) {
                    throw new RuntimeException("internal error - please contact author");
                }
            }
            NiftyList<Integer> niftyList = new NiftyList<Integer>((List<Integer>)linkedList);
            this.cache.put(INVARIANT, niftyList);
            return niftyList;
        }
    }

    public String getSystreKey() {
        NiftyList<Integer> niftyList = this.invariant();
        StringBuffer stringBuffer = new StringBuffer(50);
        for (int i = 0; i < niftyList.size(); ++i) {
            if (i > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(niftyList.get(i));
        }
        return stringBuffer.toString();
    }

    public PeriodicGraph canonical() {
        return PeriodicGraph.fromInvariantString(this.getSystreKey());
    }

    public boolean equals(Object object) {
        if (object instanceof PeriodicGraph) {
            PeriodicGraph periodicGraph = (PeriodicGraph)object;
            return periodicGraph.getDimension() == this.getDimension() && periodicGraph.numberOfNodes() == this.numberOfNodes() && periodicGraph.numberOfEdges() == this.numberOfEdges() && this.invariant().equals(periodicGraph.invariant());
        }
        return false;
    }

    public int compareTo(Object object) {
        if (!(object instanceof PeriodicGraph)) {
            throw new IllegalArgumentException("argument must be a PeriodicGraph");
        }
        PeriodicGraph periodicGraph = (PeriodicGraph)object;
        if (this.getDimension() != periodicGraph.getDimension()) {
            return this.getDimension() - periodicGraph.getDimension();
        }
        if (this.numberOfNodes() != periodicGraph.numberOfNodes()) {
            return this.numberOfNodes() - periodicGraph.numberOfNodes();
        }
        if (this.numberOfEdges() != periodicGraph.numberOfEdges()) {
            return this.numberOfEdges() - periodicGraph.numberOfEdges();
        }
        return this.invariant().compareTo((List<Integer>)periodicGraph.invariant());
    }

    public static PeriodicGraph fromInvariantString(String string) {
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        String[] stringArray = string.split("\\s+");
        for (n = 0; n < stringArray.length; ++n) {
            arrayList.add(new Integer(stringArray[n]));
        }
        n = (Integer)arrayList.get(0);
        int n2 = (arrayList.size() - 1) / (n + 2);
        PeriodicGraph periodicGraph = new PeriodicGraph(n);
        ArrayList<INode> arrayList2 = new ArrayList<INode>();
        arrayList2.add(null);
        for (int i = 0; i < n2; ++i) {
            int n3 = 1 + i * (n + 2);
            int n4 = (Integer)arrayList.get(n3);
            int n5 = (Integer)arrayList.get(n3 + 1);
            if (n4 == arrayList2.size()) {
                arrayList2.add(periodicGraph.newNode());
            }
            if (n5 == arrayList2.size()) {
                arrayList2.add(periodicGraph.newNode());
            }
            if (n4 >= arrayList2.size() || n5 >= arrayList2.size()) {
                throw new RuntimeException("something's wrong here");
            }
            int[] nArray = new int[n];
            for (int j = 0; j < n; ++j) {
                nArray[j] = (Integer)arrayList.get(n3 + 2 + j);
            }
            periodicGraph.newEdge((INode)arrayList2.get(n4), (INode)arrayList2.get(n5), nArray);
        }
        return periodicGraph;
    }

    public Cover conventionalCellCover() {
        if (!this.isMinimal()) {
            throw new UnsupportedOperationException("graph not minimal");
        }
        try {
            return (Cover)this.cache.get(CONVENTIONAL_CELL);
        }
        catch (CacheMissException cacheMissException) {
            SpaceGroupFinder spaceGroupFinder = new SpaceGroupFinder(this.getSpaceGroup());
            CoordinateChange coordinateChange = spaceGroupFinder.getToStd();
            int n = this.getDimension();
            CoordinateChange coordinateChange2 = (CoordinateChange)coordinateChange.inverse();
            Vector[] vectorArray = new Vector[n];
            for (int i = 0; i < n; ++i) {
                vectorArray[i] = (Vector)Vector.unit(n, i).times(coordinateChange2);
            }
            Cover cover = new Cover(this, vectorArray);
            return (Cover)this.cache.put(CONVENTIONAL_CELL, cover);
        }
    }

    public int hashCode() {
        return this.invariant().hashCode();
    }

    public class Component {
        private final PeriodicGraph graph;
        private final Matrix basis;
        private final Whole multiplicity;

        public Component(PeriodicGraph periodicGraph2, Matrix matrix) {
            this.graph = periodicGraph2;
            this.basis = matrix;
            this.multiplicity = periodicGraph2.getDimension() == PeriodicGraph.this.getDimension() ? (periodicGraph2.getDimension() == 0 ? Whole.ONE : (Whole)matrix.determinant()) : Whole.ZERO;
        }

        public Matrix getBasis() {
            return this.basis;
        }

        public int getDimension() {
            return this.graph.getDimension();
        }

        public PeriodicGraph getGraph() {
            return this.graph;
        }

        public Whole getMultiplicity() {
            return this.multiplicity;
        }
    }

    public class CoverEdge {
        private IEdge e;
        private Vector shift;
        private boolean compareAsOriented;

        public CoverEdge(IEdge iEdge, Vector vector, boolean bl) {
            if (!PeriodicGraph.this.hasEdge(iEdge)) {
                throw new IllegalArgumentException("no such edge");
            }
            if (!vector.isIntegral()) {
                throw new IllegalArgumentException("vector must be integral");
            }
            this.e = iEdge.oriented();
            this.shift = vector;
            this.compareAsOriented = bl;
        }

        public CoverEdge(IEdge iEdge) {
            this(iEdge, Vector.zero(periodicGraph.getDimension()));
        }

        public CoverEdge(IEdge iEdge, Vector vector) {
            this(iEdge, vector, true);
        }

        public IEdge getOrbitNode() {
            return this.e;
        }

        public Vector getShift() {
            return this.shift;
        }

        public CoverNode source() {
            return new CoverNode(this.e.source(), this.shift);
        }

        public CoverNode target() {
            Vector vector = PeriodicGraph.this.getShift(this.e);
            return new CoverNode(this.e.target(), (Vector)this.shift.plus(vector));
        }

        public CoverNode opposite(CoverNode coverNode) {
            if (this.source().equals(coverNode)) {
                return this.target();
            }
            if (this.target().equals(coverNode)) {
                return this.source();
            }
            throw new IllegalArgumentException("edge has no such vertex");
        }

        public CoverEdge reverse() throws UnsupportedOperationException {
            Vector vector = PeriodicGraph.this.getShift(this.e);
            return new CoverEdge(this.e.reverse(), (Vector)this.shift.plus(vector), this.compareAsOriented);
        }

        public CoverEdge oriented() {
            return new CoverEdge(this.e, this.shift, true);
        }

        public CoverEdge unoriented() {
            return new CoverEdge(this.e, this.shift, false);
        }

        public IGraph owner() {
            return PeriodicGraph.this;
        }

        public boolean equals(Object object) {
            if (object instanceof CoverEdge) {
                CoverEdge coverEdge = (CoverEdge)object;
                if (!this.owner().id().equals(coverEdge.owner().id())) {
                    return false;
                }
                if (this.compareAsOriented != coverEdge.compareAsOriented) {
                    return false;
                }
                if (this.source().equals(coverEdge.source()) && this.target().equals(coverEdge.target())) {
                    return true;
                }
                return !this.compareAsOriented && this.source().equals(coverEdge.target()) && this.target().equals(coverEdge.source());
            }
            return false;
        }

        public int hashCode() {
            return this.source().hashCode() * 37 + this.target().hashCode();
        }

        public String toString() {
            return "(" + this.e + ", " + this.shift + ")";
        }
    }

    public class CoverNode {
        private INode v;
        private Vector shift;
        private int degree = -1;

        public CoverNode(INode iNode, Vector vector) {
            if (!PeriodicGraph.this.hasNode(iNode)) {
                throw new IllegalArgumentException("no such node");
            }
            if (!vector.isIntegral()) {
                throw new IllegalArgumentException("vector must be integral");
            }
            this.v = iNode;
            this.shift = vector;
        }

        public CoverNode(INode iNode) {
            this(iNode, Vector.zero(periodicGraph.getDimension()));
        }

        public INode getOrbitNode() {
            return this.v;
        }

        public Vector getShift() {
            return this.shift;
        }

        public int degree() {
            if (this.degree < 0) {
                this.incidences();
            }
            return this.degree;
        }

        public IGraph owner() {
            return PeriodicGraph.this;
        }

        public Iterator<CoverEdge> incidences() {
            ArrayList<CoverEdge> arrayList = new ArrayList<CoverEdge>();
            for (IEdge iEdge : this.v.incidences()) {
                arrayList.add(new CoverEdge(iEdge, this.shift));
                if (!iEdge.source().equals(iEdge.target())) continue;
                arrayList.add(new CoverEdge(iEdge.reverse(), this.shift));
            }
            this.degree = arrayList.size();
            return arrayList.iterator();
        }

        public boolean equals(Object object) {
            if (object instanceof CoverNode) {
                CoverNode coverNode = (CoverNode)object;
                return this.owner().id().equals(coverNode.owner().id()) && this.getOrbitNode().equals(coverNode.getOrbitNode()) && this.getShift().equals(coverNode.getShift());
            }
            return false;
        }

        public int hashCode() {
            return this.v.hashCode() * 37 + this.shift.hashCode();
        }

        public String toString() {
            return "(" + this.v.id() + ", " + this.shift + ")";
        }
    }
}

