/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.pgraphs.basic;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import org.gavrog.jane.compounds.Matrix;
import org.gavrog.jane.numbers.IArithmetic;
import org.gavrog.jane.numbers.Real;
import org.gavrog.joss.geometry.Operator;
import org.gavrog.joss.geometry.Point;
import org.gavrog.joss.geometry.Vector;
import org.gavrog.joss.pgraphs.basic.IEdge;
import org.gavrog.joss.pgraphs.basic.IGraphElement;
import org.gavrog.joss.pgraphs.basic.INode;
import org.gavrog.joss.pgraphs.basic.PeriodicGraph;

public class Morphism {
    private final Map<IGraphElement, IGraphElement> src2img;
    private final Map<IGraphElement, IGraphElement> img2src;
    private final Operator operator;
    private final boolean injective;
    private final PeriodicGraph sourceGraph;
    private final PeriodicGraph imageGraph;

    public Morphism(INode iNode, INode iNode2, Operator operator) {
        Object object;
        PeriodicGraph periodicGraph = (PeriodicGraph)iNode.owner();
        PeriodicGraph periodicGraph2 = (PeriodicGraph)iNode2.owner();
        int n = periodicGraph.getDimension();
        if (!periodicGraph.isLocallyStable()) {
            throw new UnsupportedOperationException("first graph is not locally stable");
        }
        if (!periodicGraph2.isLocallyStable()) {
            throw new UnsupportedOperationException("second graph is not locally stable");
        }
        if (!periodicGraph.isConnected()) {
            throw new UnsupportedOperationException("first graph is not connected");
        }
        if (!periodicGraph2.isConnected()) {
            throw new UnsupportedOperationException("second graph is not connected");
        }
        if (periodicGraph2.getDimension() != n) {
            throw new UnsupportedOperationException("graphs have different dimensions");
        }
        if (operator != null && operator.getDimension() != n) {
            throw new IllegalArgumentException("bad transformation matrix");
        }
        HashMap<IGraphElement, IGraphElement> hashMap = new HashMap<IGraphElement, IGraphElement>();
        HashMap<IGraphElement, IGraphElement> hashMap2 = new HashMap<IGraphElement, IGraphElement>();
        boolean bl = true;
        LinkedList<INode> linkedList = new LinkedList<INode>();
        hashMap.put(iNode, iNode2);
        linkedList.addLast(iNode);
        while (linkedList.size() > 0) {
            Iterator<IEdge> iterator = (INode)linkedList.removeFirst();
            INode iGraphElement = (INode)hashMap.get(iterator);
            object = Morphism.neighborVectors((INode)((Object)iterator));
            Map<Vector, IEdge> map = Morphism.neighborVectors(iGraphElement);
            for (Vector vector : object.keySet()) {
                IEdge iEdge = (IEdge)object.get(vector);
                IEdge iEdge2 = map.get(vector.times(operator));
                if (iEdge2 == null) {
                    throw new NoSuchMorphismException("no such morphism");
                }
                if (iEdge2.equals(hashMap.get(iEdge))) continue;
                if (hashMap.containsKey(iEdge)) {
                    throw new NoSuchMorphismException("no such morphism");
                }
                if (hashMap2.containsKey(iEdge2)) {
                    bl = false;
                }
                hashMap.put(iEdge, iEdge2);
                hashMap2.put(iEdge2, iEdge);
                INode iNode3 = iEdge.target();
                INode iNode4 = iEdge2.target();
                if (hashMap2.containsKey(iNode4)) {
                    if (!((IGraphElement)hashMap2.get(iNode4)).equals(iNode3)) {
                        bl = false;
                    }
                } else {
                    hashMap2.put(iNode4, iNode3);
                }
                if (!hashMap.containsKey(iNode3)) {
                    hashMap.put(iNode3, iNode4);
                    linkedList.addLast(iNode3);
                    continue;
                }
                if (((IGraphElement)hashMap.get(iNode3)).equals(iNode4)) continue;
                throw new NoSuchMorphismException("no such morphism");
            }
        }
        for (INode iNode5 : periodicGraph2.nodes()) {
            if (hashMap2.containsKey(iNode5)) continue;
            throw new NoSuchMorphismException("no preimage for " + iNode5);
        }
        for (IEdge iEdge : periodicGraph2.edges()) {
            object = iEdge.oriented();
            if (!hashMap2.containsKey(object)) {
                throw new NoSuchMorphismException("no preimage for " + object);
            }
            if (hashMap2.containsKey(object.reverse())) continue;
            throw new NoSuchMorphismException("no preimage for " + object.reverse());
        }
        this.src2img = hashMap;
        this.img2src = hashMap2;
        this.operator = operator;
        this.injective = bl;
        this.sourceGraph = periodicGraph;
        this.imageGraph = periodicGraph2;
    }

    public static Map<Vector, IEdge> neighborVectors(INode iNode) {
        PeriodicGraph periodicGraph = (PeriodicGraph)iNode.owner();
        TreeMap<Vector, IEdge> treeMap = new TreeMap<Vector, IEdge>();
        for (IEdge iEdge : iNode.incidences()) {
            IEdge iEdge2 = iEdge.oriented();
            Vector vector = periodicGraph.differenceVector(iEdge2);
            treeMap.put(vector, iEdge2);
            if (!iNode.equals(iEdge2.target())) continue;
            treeMap.put((Vector)vector.negative(), iEdge2.reverse());
        }
        return treeMap;
    }

    public Morphism(INode iNode, INode iNode2, Matrix matrix) {
        this(iNode, iNode2, Operator.fromLinear(matrix));
    }

    public Morphism(Map<IGraphElement, IGraphElement> map, Map<IGraphElement, IGraphElement> map2, Operator operator, boolean bl) {
        this.src2img = map;
        this.img2src = map2;
        this.operator = operator;
        this.injective = bl;
        IGraphElement iGraphElement = map.keySet().iterator().next();
        IGraphElement iGraphElement2 = map2.keySet().iterator().next();
        this.sourceGraph = (PeriodicGraph)iGraphElement.owner();
        this.imageGraph = (PeriodicGraph)iGraphElement2.owner();
    }

    public Morphism(Morphism morphism) {
        this(morphism.src2img, morphism.img2src, morphism.operator, morphism.injective);
    }

    public Morphism inverse() {
        if (!this.injective) {
            throw new IllegalArgumentException("not invertible");
        }
        return new Morphism(this.img2src, this.src2img, (Operator)this.operator.inverse(), true);
    }

    public boolean isIsomorphism() {
        return this.injective;
    }

    public Object getASource(Object object) {
        return this.img2src.get(object);
    }

    public Morphism times(Morphism morphism) {
        HashMap<IGraphElement, IGraphElement> hashMap = new HashMap<IGraphElement, IGraphElement>();
        for (IGraphElement object : this.src2img.keySet()) {
            IGraphElement iGraphElement = morphism.src2img.get(this.src2img.get(object));
            if (iGraphElement == null) {
                throw new IllegalArgumentException("morphisms do not compose");
            }
            hashMap.put(object, iGraphElement);
        }
        HashMap hashMap2 = new HashMap();
        for (IGraphElement iGraphElement : morphism.img2src.keySet()) {
            IGraphElement iGraphElement2 = this.img2src.get(morphism.img2src.get(iGraphElement));
            if (iGraphElement2 == null) {
                throw new IllegalArgumentException("morphisms do not compose");
            }
            hashMap2.put(iGraphElement, iGraphElement2);
        }
        return new Morphism(hashMap, hashMap2, (Operator)this.operator.times(morphism.operator), this.injective && morphism.injective);
    }

    public Operator getLinearOperator() {
        return this.operator;
    }

    public Vector getTranslation() {
        IGraphElement iGraphElement = this.src2img.keySet().iterator().next();
        INode iNode = iGraphElement instanceof INode ? (INode)iGraphElement : ((IEdge)iGraphElement).source();
        INode iNode2 = (INode)this.src2img.get(iNode);
        Map<INode, Point> map = ((PeriodicGraph)iNode.owner()).barycentricPlacement();
        Map<INode, Point> map2 = ((PeriodicGraph)iNode2.owner()).barycentricPlacement();
        Point point = map.get(iNode);
        Point point2 = map2.get(iNode2);
        Vector vector = (Vector)point2.minus(point.times(this.getLinearOperator()));
        int n = vector.getDimension();
        IArithmetic[] iArithmeticArray = new Real[n];
        for (int i = 0; i < n; ++i) {
            iArithmeticArray[i] = (Real)((Real)vector.get(i)).mod(1L);
        }
        return new Vector(iArithmeticArray);
    }

    public Operator getAffineOperator() {
        return (Operator)this.getLinearOperator().times(this.getTranslation());
    }

    public int size() {
        return this.src2img.size();
    }

    public boolean containsKey(Object object) {
        return this.src2img.containsKey(object);
    }

    public boolean containsValue(Object object) {
        return this.src2img.containsValue(object);
    }

    public Object get(Object object) {
        return this.src2img.get(object);
    }

    public INode getImage(INode iNode) {
        return (INode)this.get(iNode);
    }

    public IEdge getImage(IEdge iEdge) {
        return (IEdge)this.get(iEdge);
    }

    public boolean equals(Object object) {
        if (object instanceof Morphism) {
            return this.src2img.equals(((Morphism)object).src2img);
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(500);
        stringBuffer.append("(\n");
        for (IGraphElement iGraphElement : this.src2img.keySet()) {
            stringBuffer.append("  ");
            stringBuffer.append(iGraphElement);
            stringBuffer.append("==>");
            stringBuffer.append(this.get(iGraphElement));
            stringBuffer.append(",\n");
        }
        stringBuffer.append(")\n");
        return stringBuffer.toString();
    }

    public int hashCode() {
        return this.src2img.hashCode();
    }

    public PeriodicGraph getImageGraph() {
        return this.imageGraph;
    }

    public PeriodicGraph getSourceGraph() {
        return this.sourceGraph;
    }

    public class NoSuchMorphismException
    extends RuntimeException {
        private static final long serialVersionUID = 5112586471768016998L;

        public NoSuchMorphismException(String string) {
            super(string);
        }
    }
}

