/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.geometry;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gavrog.box.collections.Pair;
import org.gavrog.jane.compounds.LinearAlgebra;
import org.gavrog.jane.compounds.Matrix;
import org.gavrog.jane.numbers.ArithmeticBase;
import org.gavrog.jane.numbers.IArithmetic;
import org.gavrog.jane.numbers.Rational;
import org.gavrog.jane.numbers.Whole;
import org.gavrog.joss.geometry.CoordinateChange;
import org.gavrog.joss.geometry.CrystalSystem;
import org.gavrog.joss.geometry.Lattices;
import org.gavrog.joss.geometry.Operator;
import org.gavrog.joss.geometry.OperatorType;
import org.gavrog.joss.geometry.Point;
import org.gavrog.joss.geometry.SpaceGroup;
import org.gavrog.joss.geometry.SpaceGroupCatalogue;
import org.gavrog.joss.geometry.Vector;

public class SpaceGroupFinder {
    private static final int DEBUG = 0;
    private final SpaceGroup G;
    private final CrystalSystem crystalSystem;
    private final CoordinateChange toStd;
    private final CoordinateChange fromStd;
    private final String groupName;
    private final String extension;
    private final int dimension;

    public SpaceGroupFinder(SpaceGroup spaceGroup) {
        Object[] objectArray;
        int n = this.dimension = spaceGroup.getDimension();
        this.G = spaceGroup;
        switch (n) {
            case 0: {
                this.crystalSystem = CrystalSystem.ZERO_D;
                this.groupName = null;
                this.extension = null;
                this.toStd = null;
                this.fromStd = null;
                return;
            }
            case 1: {
                Map<OperatorType, Set<Operator>> map = spaceGroup.primitiveOperatorsByType();
                Set<Operator> set = map.get(new OperatorType(1, false, 2, true));
                this.crystalSystem = CrystalSystem.ONE_D;
                this.groupName = set.size() > 0 ? "opm" : "op1";
                this.extension = null;
                this.toStd = new CoordinateChange(Matrix.one(1));
                this.fromStd = new CoordinateChange(Matrix.one(1));
                return;
            }
            case 2: {
                objectArray = this.analyzePointGroup2D();
                break;
            }
            case 3: {
                objectArray = this.analyzePointGroup3D();
                break;
            }
            default: {
                String string = "group dimension is " + n + ", must be <= 3";
                throw new UnsupportedOperationException(string);
            }
        }
        this.crystalSystem = (CrystalSystem)objectArray[0];
        Matrix matrix = (Matrix)objectArray[1];
        CoordinateChange coordinateChange = new CoordinateChange(matrix);
        Vector[] vectorArray = Vector.fromMatrix(spaceGroup.primitiveCell());
        for (int i = 0; i < vectorArray.length; ++i) {
            vectorArray[i] = (Vector)vectorArray[i].times(coordinateChange);
        }
        objectArray = this.normalizedBasis(vectorArray);
        Matrix matrix2 = (Matrix)objectArray[0];
        char c = ((Character)objectArray[1]).charValue();
        CoordinateChange coordinateChange2 = new CoordinateChange(matrix2);
        CoordinateChange coordinateChange3 = (CoordinateChange)coordinateChange.times(coordinateChange2);
        List<Operator> list = coordinateChange3.applyTo(spaceGroup.primitiveOperators());
        CoordinateChange[] coordinateChangeArray = SpaceGroupFinder.makeVariations(this.dimension, this.crystalSystem, c);
        for (int i = 0; i < vectorArray.length; ++i) {
            vectorArray[i] = (Vector)vectorArray[i].times(coordinateChange2).abs();
        }
        Arrays.sort(vectorArray, new Comparator<Vector>(){

            @Override
            public int compare(Vector vector, Vector vector2) {
                return vector2.abs().compareTo(vector.abs());
            }
        });
        Matrix matrix3 = Vector.toMatrix(vectorArray);
        CoordinateChange coordinateChange4 = new CoordinateChange(matrix3);
        Pair<String, CoordinateChange> pair = this.matchOperators(list, coordinateChange4, c, coordinateChangeArray);
        if (pair == null) {
            this.groupName = null;
            this.extension = null;
            this.toStd = null;
            this.fromStd = null;
        } else {
            String[] stringArray = pair.getFirst().split(":");
            this.groupName = stringArray[0];
            this.extension = stringArray.length > 1 ? stringArray[1] : null;
            CoordinateChange coordinateChange5 = pair.getSecond();
            this.toStd = (CoordinateChange)coordinateChange3.times(coordinateChange5);
            this.fromStd = (CoordinateChange)this.toStd.inverse();
        }
    }

    private static void sortOps(List<Operator> list) {
        Collections.sort(list);
    }

    private static CoordinateChange[] makeVariations(int n, CrystalSystem crystalSystem, char c) {
        String[] stringArray = CrystalSystem.MONOCLINIC.equals(crystalSystem) ? (c == 'A' ? new String[]{"x,y,z", "-x,y-x,-z"} : new String[]{"x,y,z", "-y,x-y,z", "y-x,-x,z"}) : (CrystalSystem.ORTHORHOMBIC.equals(crystalSystem) ? (c == 'C' ? new String[]{"x,y,z", "y,x,-z"} : new String[]{"x,y,z", "z,x,y", "y,z,x", "y,x,-z", "x,z,-y", "z,y,-x"}) : (CrystalSystem.TRIGONAL.equals(crystalSystem) ? (c == 'P' ? new String[]{"x,y,z", "x-y,x,z"} : new String[]{"x,y,z"}) : (CrystalSystem.CUBIC.equals(crystalSystem) ? new String[]{"x,y,z", "-y,x,z"} : (CrystalSystem.RECTANGULAR.equals(crystalSystem) ? new String[]{"x,y", "y,-x"} : (n == 3 ? new String[]{"x,y,z"} : new String[]{"x,y"})))));
        CoordinateChange[] coordinateChangeArray = new CoordinateChange[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            coordinateChangeArray[i] = new CoordinateChange((Operator)new Operator(stringArray[i]).inverse());
        }
        return coordinateChangeArray;
    }

    private Object[] analyzePointGroup2D() {
        Object object;
        Object object2;
        Operator operator;
        ArithmeticBase arithmeticBase;
        CrystalSystem crystalSystem;
        Map<OperatorType, Set<Operator>> map = this.G.primitiveOperatorsByType();
        Set<Operator> set = map.get(new OperatorType(2, true, 3, true));
        Set<Operator> set2 = map.get(new OperatorType(2, true, 4, true));
        Set<Operator> set3 = map.get(new OperatorType(2, true, 6, true));
        Set<Operator> set4 = map.get(new OperatorType(2, false, 2, false));
        if (set3.size() > 0) {
            crystalSystem = CrystalSystem.HEXAGONAL_2D;
            arithmeticBase = set3.iterator().next();
            operator = (Operator)((Operator)arithmeticBase).times(arithmeticBase);
        } else if (set2.size() > 0) {
            crystalSystem = CrystalSystem.SQUARE;
            operator = set2.iterator().next();
        } else if (set.size() > 0) {
            crystalSystem = CrystalSystem.HEXAGONAL_2D;
            operator = set.iterator().next();
        } else if (set4.size() > 0) {
            crystalSystem = CrystalSystem.RECTANGULAR;
            operator = null;
        } else {
            crystalSystem = CrystalSystem.OBLIQUE;
            operator = null;
        }
        arithmeticBase = set4.size() > 0 ? set4.iterator().next().linearAxis() : new Vector(1, 0);
        if (operator == null) {
            if (set4.size() > 1) {
                object2 = set4.iterator();
                object2.next();
                object = ((Operator)object2.next()).linearAxis();
            } else {
                object2 = new Vector(0, 1);
                if (((Vector)object2).isCollinearTo((Vector)arithmeticBase)) {
                    object2 = new Vector(1, 0);
                }
                if (set4.size() > 0) {
                    Operator operator2 = set4.iterator().next();
                    object = (Vector)((ArithmeticBase)object2).minus(((Vector)object2).times(operator2));
                } else {
                    object = object2;
                }
            }
        } else {
            object = (Vector)((Vector)arithmeticBase).times(operator);
        }
        object2 = Vector.area2D((Vector)arithmeticBase, (Vector)object).isNegative() ? Vector.toMatrix(new Vector[]{arithmeticBase, (Vector)((Vector)object).negative()}) : Vector.toMatrix(new Vector[]{arithmeticBase, object});
        return new Object[]{crystalSystem, object2};
    }

    private Object[] analyzePointGroup3D() {
        ArithmeticBase arithmeticBase;
        Object object;
        CrystalSystem crystalSystem;
        Map<OperatorType, Set<Operator>> map = this.G.primitiveOperatorsByType();
        Set<Operator> set = map.get(new OperatorType(3, true, 2, true));
        Set<Operator> set2 = map.get(new OperatorType(3, true, 3, true));
        Set<Operator> set3 = map.get(new OperatorType(3, true, 4, true));
        Set<Operator> set4 = map.get(new OperatorType(3, true, 6, true));
        Set<Operator> set5 = map.get(new OperatorType(3, false, 1, true));
        HashSet hashSet = new HashSet();
        hashSet.addAll(map.get(new OperatorType(3, false, 2, true)));
        hashSet.addAll(map.get(new OperatorType(3, false, 3, true)));
        hashSet.addAll(map.get(new OperatorType(3, false, 4, true)));
        hashSet.addAll(map.get(new OperatorType(3, false, 6, true)));
        if (set5.size() == 0) {
            set.addAll((Collection<Operator>)map.get(new OperatorType(3, false, 2, true)));
            set3.addAll((Collection<Operator>)map.get(new OperatorType(3, false, 4, true)));
            set4.addAll((Collection<Operator>)map.get(new OperatorType(3, false, 6, true)));
        }
        ArithmeticBase arithmeticBase2 = null;
        Vector vector = null;
        Vector vector2 = null;
        Operator operator = null;
        if (set4.size() > 0) {
            crystalSystem = CrystalSystem.HEXAGONAL_3D;
            object = set4.iterator().next();
            vector2 = ((Operator)object).linearAxis();
            operator = (Operator)((Operator)object).times(object);
        } else if (set3.size() > 1) {
            crystalSystem = CrystalSystem.CUBIC;
            object = set3.iterator().next();
            vector2 = ((Operator)object).linearAxis();
            operator = set2.iterator().next();
            arithmeticBase2 = (Vector)vector2.times(operator);
            vector = (Vector)((Vector)arithmeticBase2).times(operator);
        } else if (set3.size() > 0) {
            crystalSystem = CrystalSystem.TETRAGONAL;
            object = set3.iterator().next();
            vector2 = ((Operator)object).linearAxis();
            operator = object;
        } else if (set2.size() > 1) {
            crystalSystem = CrystalSystem.CUBIC;
            object = set.iterator().next();
            vector2 = ((Operator)object).linearAxis();
            operator = set2.iterator().next();
            arithmeticBase2 = (Vector)vector2.times(operator);
            vector = (Vector)((Vector)arithmeticBase2).times(operator);
        } else if (set2.size() > 0) {
            crystalSystem = CrystalSystem.TRIGONAL;
            operator = set2.iterator().next();
            vector2 = operator.linearAxis();
        } else if (set.size() > 1) {
            crystalSystem = CrystalSystem.ORTHORHOMBIC;
            object = set.iterator();
            Operator operator2 = object.next();
            arithmeticBase = object.next();
            Operator operator3 = (Operator)object.next();
            arithmeticBase2 = operator2.linearAxis();
            vector = ((Operator)arithmeticBase).linearAxis();
            vector2 = operator3.linearAxis();
        } else if (set.size() > 0) {
            crystalSystem = CrystalSystem.MONOCLINIC;
            object = set.iterator().next();
            vector2 = ((Operator)object).linearAxis();
        } else {
            crystalSystem = CrystalSystem.TRICLINIC;
            vector2 = new Vector(0, 0, 1);
        }
        if (arithmeticBase2 == null) {
            for (Operator operator2 : set) {
                arithmeticBase = operator2.linearAxis();
                if (((Vector)arithmeticBase).isCollinearTo(vector2)) continue;
                arithmeticBase2 = arithmeticBase;
                break;
            }
            if (arithmeticBase2 == null) {
                arithmeticBase2 = new Vector(1, 0, 0);
                if (((Vector)arithmeticBase2).isCollinearTo(vector2)) {
                    arithmeticBase2 = new Vector(0, 1, 0);
                }
                if (hashSet.size() > 0) {
                    object = (Operator)hashSet.iterator().next();
                    arithmeticBase2 = (Vector)((Vector)arithmeticBase2).plus(((Vector)arithmeticBase2).times(object));
                } else if (set.size() > 0) {
                    object = set.iterator().next();
                    arithmeticBase2 = (Vector)arithmeticBase2.minus(((Vector)arithmeticBase2).times(object));
                } else if (crystalSystem == CrystalSystem.TRIGONAL) {
                    arithmeticBase2 = (Vector)arithmeticBase2.minus(((Vector)arithmeticBase2).times(operator));
                }
            }
        }
        if (vector == null) {
            if (operator != null) {
                vector = (Vector)((Vector)arithmeticBase2).times(operator);
            } else {
                vector = Vector.crossProduct3D(vector2, (Vector)arithmeticBase2);
                if (hashSet.size() > 0) {
                    object = (Operator)hashSet.iterator().next();
                    vector = (Vector)vector.plus(vector.times(object));
                } else if (set.size() > 0) {
                    object = set.iterator().next();
                    vector = (Vector)vector.minus(vector.times(object));
                }
            }
        }
        if (Vector.volume3D(arithmeticBase2, vector, vector2).isNegative()) {
            vector2 = (Vector)vector2.negative();
        }
        object = Vector.toMatrix(new Vector[]{arithmeticBase2, vector, vector2});
        return new Object[]{crystalSystem, object};
    }

    private Object[] normalizedBasis(Vector[] vectorArray) {
        Object[] objectArray;
        int n = this.dimension;
        Vector[] vectorArray2 = Lattices.reducedLatticeBasis(vectorArray, Matrix.one(n));
        CrystalSystem crystalSystem = this.crystalSystem;
        if (CrystalSystem.OBLIQUE.equals(crystalSystem)) {
            objectArray = this.normalizedBasisOblique(vectorArray2);
        } else if (CrystalSystem.RECTANGULAR.equals(crystalSystem)) {
            objectArray = this.normalizedBasisRectangular(vectorArray2);
        } else if (CrystalSystem.SQUARE.equals(crystalSystem)) {
            objectArray = this.normalizedBasisSquare(vectorArray2);
        } else if (CrystalSystem.HEXAGONAL_2D.equals(crystalSystem)) {
            objectArray = this.normalizedBasisHexagonal2D(vectorArray2);
        } else if (CrystalSystem.CUBIC.equals(crystalSystem)) {
            objectArray = this.normalizedBasisCubic(vectorArray2);
        } else if (CrystalSystem.HEXAGONAL_3D.equals(crystalSystem)) {
            objectArray = this.normalizedBasisHexagonal3D(vectorArray2);
        } else if (CrystalSystem.TRIGONAL.equals(crystalSystem)) {
            objectArray = this.normalizedBasisTrigonal(vectorArray2);
        } else if (CrystalSystem.TETRAGONAL.equals(crystalSystem)) {
            objectArray = this.normalizedBasisTetragonal(vectorArray2);
        } else if (CrystalSystem.ORTHORHOMBIC.equals(crystalSystem)) {
            objectArray = this.normalizedBasisOrthorhombic(vectorArray2);
        } else if (CrystalSystem.MONOCLINIC.equals(crystalSystem)) {
            objectArray = this.normalizedBasisMonoclinic(vectorArray2);
        } else if (CrystalSystem.TRICLINIC.equals(crystalSystem)) {
            objectArray = this.normalizedBasisTriclinic(vectorArray2);
        } else {
            throw new RuntimeException("unknown crystal system" + this.crystalSystem);
        }
        Vector[] vectorArray3 = (Vector[])objectArray[0];
        if (n == 3) {
            if (Vector.volume3D(vectorArray3[0], vectorArray3[1], vectorArray3[2]).isNegative()) {
                vectorArray3[2] = (Vector)vectorArray3[2].negative();
            }
        } else if (Vector.area2D(vectorArray3[0], vectorArray3[1]).isNegative()) {
            vectorArray3[1] = (Vector)vectorArray3[1].negative();
        }
        return new Object[]{Vector.toMatrix(vectorArray3), objectArray[1]};
    }

    private Object[] normalizedBasisOblique(Vector[] vectorArray) {
        return new Object[]{vectorArray, new Character('p')};
    }

    private Object[] normalizedBasisRectangular(Vector[] vectorArray) {
        Vector[] vectorArray2;
        char c;
        if (!vectorArray[0].get(0).isZero() && !vectorArray[0].get(1).isZero()) {
            c = 'c';
            vectorArray2 = new Vector[]{(Vector)vectorArray[0].times(new Operator("0, 2y")), (Vector)vectorArray[0].times(new Operator("2x, 0"))};
        } else if (!vectorArray[1].get(0).isZero() && !vectorArray[1].get(1).isZero()) {
            c = 'c';
            vectorArray2 = new Vector[]{(Vector)vectorArray[1].times(new Operator("0, 2y")), (Vector)vectorArray[1].times(new Operator("2x, 0"))};
        } else if (vectorArray[0].get(1).isZero()) {
            c = 'p';
            vectorArray2 = new Vector[]{vectorArray[1], (Vector)vectorArray[0].negative()};
        } else {
            c = 'p';
            vectorArray2 = new Vector[]{vectorArray[0], vectorArray[1]};
        }
        return new Object[]{vectorArray2, new Character(c)};
    }

    private Object[] normalizedBasisSquare(Vector[] vectorArray) {
        Vector[] vectorArray2 = new Vector[]{vectorArray[0], vectorArray[1]};
        vectorArray2[1] = (Vector)vectorArray2[0].times(new Operator("-y, x"));
        return new Object[]{vectorArray2, new Character('p')};
    }

    private Object[] normalizedBasisHexagonal2D(Vector[] vectorArray) {
        Vector[] vectorArray2 = new Vector[]{vectorArray[0], vectorArray[1]};
        vectorArray2[1] = (Vector)vectorArray2[0].times(new Operator("-y, x-y"));
        return new Object[]{vectorArray2, new Character('p')};
    }

    private Object[] normalizedBasisCubic(Vector[] vectorArray) {
        char c;
        Rational rational;
        int n = 0;
        int n2 = 3;
        for (int i = 2; i >= 0; --i) {
            if (vectorArray[0].get(i).isZero()) continue;
            ++n;
            n2 = i;
        }
        Rational rational2 = (Rational)vectorArray[0].get(n2).abs();
        if (n == 1) {
            rational = rational2;
            c = 'P';
        } else if (n == 2) {
            rational = (Rational)rational2.times(2L);
            c = 'F';
        } else if (n == 3) {
            rational = (Rational)rational2.times(2L);
            c = 'I';
        } else {
            throw new RuntimeException("this should not happen");
        }
        Whole whole = Whole.ZERO;
        Matrix matrix = new Matrix(new IArithmetic[][]{{rational, whole, whole}, {whole, rational, whole}, {whole, whole, rational}});
        return new Object[]{Vector.rowVectors(matrix), new Character(c)};
    }

    private Object[] normalizedBasisHexagonal3D(Vector[] vectorArray) {
        Vector vector = new Vector(0, 0, 1);
        Vector[] vectorArray2 = vector.isCollinearTo(vectorArray[0]) ? new Vector[]{vectorArray[2], vectorArray[1], vectorArray[0]} : (vector.isCollinearTo(vectorArray[1]) ? new Vector[]{vectorArray[0], vectorArray[2], vectorArray[1]} : new Vector[]{vectorArray[0], vectorArray[1], vectorArray[2]});
        vectorArray2[1] = (Vector)vectorArray2[0].times(new Operator("-y, x-y, z"));
        return new Object[]{vectorArray2, new Character('P')};
    }

    private Object[] normalizedBasisTrigonal(Vector[] vectorArray) {
        Vector vector = new Vector(0, 0, 1);
        Vector[] vectorArray2 = vector.isCollinearTo(vectorArray[0]) ? new Vector[]{vectorArray[1], vectorArray[2], vectorArray[0]} : (vector.isCollinearTo(vectorArray[1]) ? new Vector[]{vectorArray[0], vectorArray[2], vectorArray[1]} : new Vector[]{vectorArray[0], vectorArray[1], vectorArray[2]});
        char c = 'P';
        for (int i = 0; i < 3; ++i) {
            Vector vector2;
            if (vectorArray2[i].get(2).isZero() || vector.isCollinearTo(vector2 = vectorArray2[i])) continue;
            c = 'R';
            if (vector2.get(2).isNegative()) {
                vectorArray2[0] = (Vector)vector2.times(new Operator("2x-y,x+y, 0"));
                vectorArray2[2] = (Vector)vector2.times(new Operator("0, 0, -3z"));
                break;
            }
            vectorArray2[0] = (Vector)vector2.times(new Operator("x+y, 2y-x, 0"));
            vectorArray2[2] = (Vector)vector2.times(new Operator("0, 0, 3z"));
            break;
        }
        vectorArray2[1] = (Vector)vectorArray2[0].times(new Operator("-y, x-y, z"));
        return new Object[]{vectorArray2, new Character(c)};
    }

    private Object[] normalizedBasisTetragonal(Vector[] vectorArray) {
        char c = 'P';
        Vector vector = new Vector(0, 0, 1);
        Vector[] vectorArray2 = new Vector[]{vectorArray[0], vectorArray[1], vectorArray[2]};
        if (vector.isCollinearTo(vectorArray2[0])) {
            vectorArray2[2] = vectorArray2[0];
            vectorArray2[0] = vectorArray2[1];
            if (!vector.isOrthogonalTo(vectorArray2[0])) {
                c = 'I';
                vectorArray2[0] = (Vector)vectorArray2[0].times(new Operator("x-y, x+y, 0"));
            }
        } else if (vector.isOrthogonalTo(vectorArray2[0])) {
            if (!vector.isOrthogonalTo(vectorArray2[1])) {
                vectorArray2[2] = vectorArray2[1];
            }
            if (!vector.isCollinearTo(vectorArray2[2])) {
                vectorArray2[2] = (Vector)vectorArray2[2].times(new Operator("0, 0, 2z"));
                c = 'I';
            }
        } else {
            c = 'I';
            vectorArray2[2] = (Vector)vectorArray2[0].times(new Operator("0, 0, 2z"));
            vectorArray2[0] = (Vector)vectorArray2[0].times(new Operator("x-y, x+y, 0"));
        }
        vectorArray2[1] = (Vector)vectorArray2[0].times(new Operator("-y, x, z"));
        return new Object[]{vectorArray2, new Character(c)};
    }

    private Object[] normalizedBasisOrthorhombic(Vector[] vectorArray) {
        Matrix matrix;
        char c;
        IArithmetic iArithmetic;
        IArithmetic iArithmetic2;
        IArithmetic iArithmetic3;
        ArithmeticBase arithmeticBase;
        int[] nArray = new int[3];
        for (int i = 0; i < 3; ++i) {
            nArray[i] = 0;
            for (int j = 0; j < 3; ++j) {
                if (vectorArray[i].get(j).isZero()) continue;
                int n = i;
                nArray[n] = nArray[n] + 1;
            }
        }
        Vector vector = new Vector(1, 0, 0);
        Vector vector2 = new Vector(0, 1, 0);
        Vector vector3 = new Vector(0, 0, 1);
        Vector[] vectorArray2 = new Vector[]{vectorArray[0], vectorArray[1], vectorArray[2]};
        Vector[] vectorArray3 = new Vector[]{vectorArray[1], vectorArray[2], vectorArray[0]};
        Vector[] vectorArray4 = new Vector[]{vectorArray[2], vectorArray[0], vectorArray[1]};
        Vector[] vectorArray5 = nArray[0] == 3 ? vectorArray2 : (nArray[1] == 3 ? vectorArray3 : (nArray[2] == 3 ? vectorArray4 : (nArray[0] == 2 && vectorArray[0].isOrthogonalTo(vector3) ? vectorArray2 : (nArray[1] == 2 && vectorArray[1].isOrthogonalTo(vector3) ? vectorArray3 : (nArray[2] == 2 && vectorArray[2].isOrthogonalTo(vector3) ? vectorArray4 : (nArray[0] == 2 && vectorArray[0].isOrthogonalTo(vector2) ? vectorArray2 : (nArray[1] == 2 && vectorArray[1].isOrthogonalTo(vector2) ? vectorArray3 : (nArray[2] == 2 && vectorArray[2].isOrthogonalTo(vector2) ? vectorArray4 : (vectorArray[0].isCollinearTo(vector) ? vectorArray2 : (vectorArray[1].isCollinearTo(vector) ? vectorArray3 : (vectorArray[2].isCollinearTo(vector) ? vectorArray4 : vectorArray2)))))))))));
        int n = 0;
        for (int i = 0; i < 3; ++i) {
            if (vectorArray5[0].get(i).isZero()) continue;
            ++n;
        }
        block0 : switch (n) {
            case 3: {
                arithmeticBase = (Vector)vectorArray5[0].times(2L);
                iArithmetic3 = arithmeticBase.get(0);
                iArithmetic2 = arithmeticBase.get(1);
                iArithmetic = arithmeticBase.get(2);
                c = 'I';
                break;
            }
            case 2: {
                int n2;
                int n3;
                for (n3 = 0; n3 < 3 && !vectorArray5[0].get(n3).isZero(); ++n3) {
                }
                IArithmetic iArithmetic4 = vectorArray5[1].get(n3);
                IArithmetic iArithmetic5 = vectorArray5[2].get(n3);
                if (iArithmetic5.isZero() || !iArithmetic4.isZero() && iArithmetic5.abs().isGreaterThan(iArithmetic4.abs())) {
                    Vector vector4 = vectorArray5[1];
                    vectorArray5[1] = vectorArray5[2];
                    vectorArray5[2] = vector4;
                    n2 = nArray[1];
                } else {
                    n2 = nArray[2];
                }
                switch (n3) {
                    case 1: {
                        iArithmetic3 = vectorArray5[0].get(0).times(new Whole(2L));
                        iArithmetic2 = vectorArray5[2].get(1).times(new Whole(n2));
                        iArithmetic = vectorArray5[0].get(2).times(new Whole(2L));
                        c = n2 == 2 ? (char)'F' : 'B';
                        break block0;
                    }
                    case 2: {
                        iArithmetic3 = vectorArray5[0].get(0).times(new Whole(2L));
                        iArithmetic2 = vectorArray5[0].get(1).times(new Whole(2L));
                        iArithmetic = vectorArray5[2].get(2).times(new Whole(n2));
                        c = n2 == 2 ? (char)'F' : 'C';
                        break block0;
                    }
                }
                throw new RuntimeException("this should not happen");
            }
            case 1: {
                int n4;
                Vector vector5;
                if (!vectorArray5[0].isCollinearTo(vector)) {
                    throw new RuntimeException("this should not happen");
                }
                IArithmetic iArithmetic6 = vectorArray5[1].get(1);
                IArithmetic iArithmetic7 = vectorArray5[2].get(1);
                if (iArithmetic6.isZero() || !iArithmetic7.isZero() && iArithmetic6.abs().isGreaterThan(iArithmetic7.abs())) {
                    vector5 = vectorArray5[2];
                    vectorArray5[2] = vectorArray5[1];
                    vectorArray5[1] = vector5;
                    n4 = nArray[2];
                } else {
                    n4 = nArray[1];
                }
                iArithmetic3 = vectorArray5[0].get(0);
                if (n4 == 2) {
                    vector5 = (Vector)vectorArray5[1].times(2L);
                    iArithmetic2 = vector5.get(1);
                    iArithmetic = vector5.get(2);
                    c = 'A';
                    break;
                }
                if (!vectorArray5[1].get(1).isZero()) {
                    iArithmetic2 = vectorArray5[1].get(1);
                    iArithmetic = vectorArray5[2].get(2);
                } else {
                    iArithmetic2 = vectorArray5[2].get(1);
                    iArithmetic = vectorArray5[1].get(2);
                }
                c = 'P';
                break;
            }
            default: {
                throw new RuntimeException("this should not happen");
            }
        }
        arithmeticBase = Whole.ZERO;
        if (c == 'A') {
            matrix = new Matrix(new IArithmetic[][]{{arithmeticBase, iArithmetic2, arithmeticBase}, {arithmeticBase, arithmeticBase, iArithmetic}, {iArithmetic3, arithmeticBase, arithmeticBase}});
            c = 'C';
        } else if (c == 'B') {
            matrix = new Matrix(new IArithmetic[][]{{arithmeticBase, arithmeticBase, iArithmetic}, {iArithmetic3, arithmeticBase, arithmeticBase}, {arithmeticBase, iArithmetic2, arithmeticBase}});
            c = 'C';
        } else {
            matrix = new Matrix(new IArithmetic[][]{{iArithmetic3, arithmeticBase, arithmeticBase}, {arithmeticBase, iArithmetic2, arithmeticBase}, {arithmeticBase, arithmeticBase, iArithmetic}});
        }
        return new Object[]{Vector.rowVectors(matrix), new Character(c)};
    }

    private Object[] normalizedBasisMonoclinic(Vector[] vectorArray) {
        char c;
        Vector vector = new Vector(0, 0, 1);
        Vector[] vectorArray2 = vectorArray[0].isCollinearTo(vector) ? new Vector[]{vectorArray[1], vectorArray[2], vectorArray[0]} : (vectorArray[1].isCollinearTo(vector) ? new Vector[]{vectorArray[0], (Vector)vectorArray[2].negative(), vectorArray[1]} : new Vector[]{vectorArray[0], vectorArray[1], vectorArray[2]});
        if (vectorArray2[1].isOrthogonalTo(vector)) {
            vectorArray2 = new Vector[]{(Vector)vectorArray2[1].negative(), vectorArray2[0], vectorArray2[2]};
        } else if (vectorArray2[2].isOrthogonalTo(vector)) {
            vectorArray2 = new Vector[]{vectorArray2[2], vectorArray2[0], vectorArray2[1]};
        }
        if (!vectorArray2[0].isOrthogonalTo(vector)) {
            vectorArray2[0] = (Vector)vectorArray2[0].plus(vectorArray2[1]).times(new Operator("x,y,0"));
        }
        if (!vectorArray2[2].isCollinearTo(vector)) {
            if (vectorArray2[1].isOrthogonalTo(vector)) {
                if (((Vector)vectorArray2[2].times(new Operator("2x,2y,0"))).isCollinearTo(vectorArray2[0])) {
                    vectorArray2[0] = vectorArray2[1];
                }
                vectorArray2[1] = vectorArray2[2];
            }
            vectorArray2[2] = (Vector)vectorArray2[2].times(new Operator("0,0,2z"));
        }
        if (!vectorArray2[1].isOrthogonalTo(vector)) {
            vectorArray2[1] = (Vector)vectorArray2[1].times(new Operator("2x,2y,0"));
            c = 'A';
        } else {
            c = 'P';
        }
        return new Object[]{vectorArray2, new Character(c)};
    }

    private Object[] normalizedBasisTriclinic(Vector[] vectorArray) {
        return new Object[]{vectorArray, new Character('P')};
    }

    private Pair<String, CoordinateChange> matchOperators(List<Operator> list, CoordinateChange coordinateChange, char c, CoordinateChange[] coordinateChangeArray) {
        int n = this.G.getDimension();
        Matrix matrix = Matrix.one(n);
        int n2 = list.size();
        Iterator<SpaceGroupCatalogue.Lookup> iterator = SpaceGroupCatalogue.lookupInfo();
        while (iterator.hasNext()) {
            SpaceGroupCatalogue.Lookup lookup = iterator.next();
            if (lookup.centering != c || lookup.system != this.crystalSystem) continue;
            SpaceGroup spaceGroup = new SpaceGroup(n, lookup.name);
            List<Operator> list2 = spaceGroup.primitiveOperatorsSorted();
            List<Operator> list3 = lookup.fromStd.applyTo(list2);
            SpaceGroupFinder.sortOps(list3);
            if (list3.size() != n2) continue;
            for (int i = 0; i < coordinateChangeArray.length; ++i) {
                Object object;
                ArithmeticBase arithmeticBase;
                ArithmeticBase arithmeticBase2;
                ArithmeticBase arithmeticBase3;
                ArithmeticBase arithmeticBase4;
                ArithmeticBase arithmeticBase5;
                ArithmeticBase arithmeticBase6;
                List<Operator> list4 = coordinateChangeArray[i].applyTo(list);
                SpaceGroupFinder.sortOps(list4);
                boolean bl = true;
                for (int j = 0; j < n2; ++j) {
                    arithmeticBase6 = list4.get(j);
                    arithmeticBase5 = list3.get(j);
                    if (((Operator)arithmeticBase6).linearPart().equals(arithmeticBase5.linearPart())) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                Matrix matrix2 = new Matrix(n, n * n2);
                arithmeticBase6 = new Matrix(1, n * n2);
                for (int j = 0; j < n2; ++j) {
                    arithmeticBase4 = list4.get(j);
                    arithmeticBase3 = (Operator)arithmeticBase4.times(coordinateChange);
                    arithmeticBase2 = list3.get(j);
                    arithmeticBase = (Operator)arithmeticBase2.times(coordinateChange);
                    object = ((Operator)arithmeticBase3).getCoordinates().getSubMatrix(0, 0, n, n);
                    Matrix matrix3 = ((Operator)arithmeticBase3).translationalPart().getCoordinates();
                    Matrix matrix4 = ((Operator)arithmeticBase).translationalPart().getCoordinates();
                    matrix2.setSubMatrix(0, n * j, (Matrix)((Matrix)object).minus(matrix));
                    ((Matrix)arithmeticBase6).setSubMatrix(0, n * j, (Matrix)matrix4.minus(matrix3));
                }
                arithmeticBase5 = LinearAlgebra.solutionInRows(matrix2, (Matrix)arithmeticBase6, true);
                if (arithmeticBase5 == null) continue;
                arithmeticBase4 = (Point)new Point((Matrix)arithmeticBase5).times(coordinateChange.inverse());
                arithmeticBase3 = coordinateChangeArray[i];
                arithmeticBase2 = new CoordinateChange(matrix, (Point)arithmeticBase4);
                arithmeticBase = (CoordinateChange)lookup.fromStd.inverse();
                object = new Pair<String, CoordinateChange>(lookup.name, (CoordinateChange)((CoordinateChange)arithmeticBase3).times(arithmeticBase2).times(arithmeticBase));
                return object;
            }
        }
        return null;
    }

    public CrystalSystem getCrystalSystem() {
        return this.crystalSystem;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getExtendedGroupName() {
        String string = this.groupName;
        String string2 = this.extension == null ? "" : ":" + this.extension;
        return string + string2;
    }

    public CoordinateChange getToStd() {
        return this.toStd;
    }

    public CoordinateChange getFromStd() {
        return this.fromStd;
    }

    public String getExtension() {
        return this.extension;
    }
}

