/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.geometry;

import org.gavrog.jane.compounds.Matrix;
import org.gavrog.joss.geometry.Operator;
import org.gavrog.joss.geometry.Vector;

public class OperatorType {
    private final int dimension;
    private final boolean orientationPreserving;
    private final int order;
    private final boolean clockwise;

    public OperatorType(int n, boolean bl, int n2, boolean bl2) {
        this.dimension = n;
        this.orientationPreserving = bl;
        this.order = n2;
        this.clockwise = bl2;
    }

    public String toString() {
        return "OperatorType(" + this.dimension + ", " + this.orientationPreserving + ", " + this.order + ", " + this.clockwise + ")";
    }

    public OperatorType(Operator operator) {
        int n = this.dimension = operator.getDimension();
        Vector vector = operator.linearAxis();
        Matrix matrix = operator.getCoordinates().getSubMatrix(0, 0, n, n);
        this.orientationPreserving = matrix.determinant().isNonNegative();
        if (n == 3 && !this.orientationPreserving) {
            matrix = (Matrix)matrix.negative();
        }
        this.order = OperatorType.matrixOrder(matrix, 6);
        switch (n) {
            case 1: {
                this.clockwise = true;
                break;
            }
            case 2: {
                if (!this.isOrientationPreserving()) {
                    this.clockwise = false;
                    break;
                }
                if (this.order == 0 || this.order > 2) {
                    Matrix matrix2 = new Matrix(new int[][]{{1, 0}});
                    Matrix matrix3 = new Matrix(2, 2);
                    matrix3.setRow(0, matrix2);
                    matrix3.setRow(1, (Matrix)matrix2.times(matrix));
                    this.clockwise = matrix3.determinant().isPositive();
                    break;
                }
                this.clockwise = true;
                break;
            }
            case 3: {
                if ((this.order == 0 || this.order > 2) && vector != null) {
                    Matrix matrix4 = vector.getCoordinates();
                    Matrix matrix5 = matrix4.get(0, 1).isZero() && matrix4.get(0, 2).isZero() ? new Matrix(new int[][]{{0, 1, 0}}) : new Matrix(new int[][]{{1, 0, 0}});
                    Matrix matrix6 = new Matrix(3, 3);
                    matrix6.setRow(0, vector.getCoordinates());
                    matrix6.setRow(1, matrix5);
                    matrix6.setRow(2, (Matrix)matrix5.times(matrix));
                    this.clockwise = matrix6.determinant().isPositive();
                    break;
                }
                this.clockwise = true;
                break;
            }
            default: {
                String string = "operator dimension is " + n + ", must be <=3";
                throw new UnsupportedOperationException(string);
            }
        }
    }

    private static int matrixOrder(Matrix matrix, int n) {
        Matrix matrix2 = matrix;
        for (int i = 1; i <= n; ++i) {
            if (matrix2.isOne()) {
                return i;
            }
            matrix2 = (Matrix)matrix2.times(matrix);
        }
        return 0;
    }

    public int getDimension() {
        return this.dimension;
    }

    public boolean isClockwise() {
        return this.clockwise;
    }

    public int getOrder() {
        return this.order;
    }

    public boolean isOrientationPreserving() {
        return this.orientationPreserving;
    }

    public boolean equals(Object object) {
        if (object instanceof OperatorType) {
            OperatorType operatorType = (OperatorType)object;
            return this.dimension == operatorType.dimension && this.clockwise == operatorType.clockwise && this.order == operatorType.order && this.orientationPreserving == operatorType.orientationPreserving;
        }
        return false;
    }

    public int hashCode() {
        int n = this.dimension * 37 + this.order;
        n = n * 37 + (this.clockwise ? 37 : 0) + (this.orientationPreserving ? 1 : 0);
        return n;
    }
}

