/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.geometry;

import org.gavrog.box.simple.DataFormatException;
import org.gavrog.jane.compounds.LinearAlgebra;
import org.gavrog.jane.compounds.Matrix;
import org.gavrog.jane.numbers.ArithmeticBase;
import org.gavrog.jane.numbers.IArithmetic;
import org.gavrog.jane.numbers.Real;
import org.gavrog.jane.numbers.Whole;
import org.gavrog.joss.geometry.CoordinateChange;
import org.gavrog.joss.geometry.Point;
import org.gavrog.joss.geometry.Vector;

public class Operator
extends ArithmeticBase
implements IArithmetic {
    final Matrix coords;
    final int dimension;

    public Operator(Matrix matrix) {
        int n = matrix.numberOfRows() - 1;
        if (matrix.numberOfColumns() != n + 1) {
            throw new IllegalArgumentException("bad shape");
        }
        IArithmetic iArithmetic = matrix.get(n, n);
        this.coords = (Matrix)matrix.dividedBy(iArithmetic);
        this.dimension = n;
    }

    public Operator(IArithmetic[][] iArithmeticArray) {
        this(new Matrix(iArithmeticArray));
    }

    public Operator(int[][] nArray) {
        this(new Matrix(nArray));
    }

    public Operator(double[][] dArray) {
        this(new Matrix(dArray));
    }

    public Operator(String string) {
        this(Operator.parse(string));
    }

    public Operator(Vector vector) {
        int n;
        this.dimension = n = vector.getDimension();
        this.coords = Matrix.one(n + 1);
        this.coords.setSubMatrix(n, 0, vector.getCoordinates());
    }

    public static Operator identity(int n) {
        return new Operator(Matrix.one(n + 1));
    }

    public static Operator fromLinear(Matrix matrix) {
        int n = matrix.numberOfColumns();
        Matrix matrix2 = new Matrix(n + 1, n + 1);
        matrix2.setSubMatrix(0, 0, matrix);
        matrix2.setSubMatrix(n, 0, Matrix.zero(1, n));
        matrix2.setSubMatrix(0, n, Matrix.zero(n, 1));
        matrix2.set(n, n, Whole.ONE);
        return new Operator(matrix2);
    }

    public static Operator viewingRotation(Vector vector, Vector vector2) {
        Vector vector3 = Vector.crossProduct3D(vector, vector2);
        Matrix matrix = Vector.toMatrix(new Vector[]{vector, vector2, vector3});
        Matrix matrix2 = LinearAlgebra.rowOrthonormalized(matrix, Matrix.one(3));
        Matrix matrix3 = Matrix.one(4);
        matrix3.setSubMatrix(0, 0, matrix2);
        return (Operator)new Operator(matrix3).inverse().times(new Operator("-z,y,x"));
    }

    public int getDimension() {
        return this.dimension;
    }

    public IArithmetic get(int n, int n2) {
        if (n < 0 || n > this.getDimension() + 1) {
            throw new IllegalArgumentException("row index out of range");
        }
        if (n2 < 0 || n2 > this.getDimension() + 1) {
            throw new IllegalArgumentException("column index out of range");
        }
        return this.coords.get(n, n2);
    }

    public Matrix getCoordinates() {
        return this.coords;
    }

    public Operator linearPart() {
        int n = this.getDimension();
        Matrix matrix = this.coords.mutableClone();
        matrix.setSubMatrix(n, 0, Matrix.zero(1, n));
        matrix.setSubMatrix(0, n, Matrix.zero(n, 1));
        return new Operator(matrix);
    }

    public Matrix linearPartAsMatrix() {
        int n = this.getDimension();
        return this.coords.getSubMatrix(0, 0, n, n);
    }

    public Vector translationalPart() {
        int n = this.getDimension();
        return new Vector(this.coords.getSubMatrix(n, 0, 1, n));
    }

    public Vector linearAxis() {
        Matrix matrix;
        int n = this.getDimension();
        Matrix matrix2 = this.getCoordinates().getSubMatrix(0, 0, n, n);
        if (n % 2 != 0 && matrix2.determinant().isNegative()) {
            matrix2 = (Matrix)matrix2.negative();
        }
        if ((matrix = LinearAlgebra.rowNullSpace((Matrix)matrix2.minus(matrix2.one()), true)).numberOfRows() != 1) {
            return null;
        }
        Vector vector = new Vector(matrix.getRow(0));
        if (vector.isNegative()) {
            return (Vector)vector.negative();
        }
        return vector;
    }

    public IArithmetic applyTo(Point point) {
        return point.times(this);
    }

    @Override
    public int compareTo(Object object) {
        if (object instanceof Operator) {
            Operator operator = (Operator)object;
            int n = this.getDimension();
            if (n != operator.getDimension()) {
                throw new IllegalArgumentException("dimensions must be equal");
            }
            for (int i = 0; i < n + 1; ++i) {
                for (int j = 0; j < n + 1; ++j) {
                    int n2 = this.get(i, j).compareTo(operator.get(i, j));
                    if (n2 == 0) continue;
                    return n2;
                }
            }
            return 0;
        }
        throw new IllegalArgumentException("can only compare two operators");
    }

    @Override
    public IArithmetic floor() {
        throw new UnsupportedOperationException();
    }

    public Operator modZ() {
        int n = this.getDimension();
        Matrix matrix = this.coords.mutableClone();
        for (int i = 0; i < n; ++i) {
            matrix.set(n, i, ((Real)this.get(n, i)).mod(1L));
        }
        return new Operator(matrix);
    }

    public Vector floorZ() {
        int n = this.getDimension();
        IArithmetic[] iArithmeticArray = new IArithmetic[n];
        for (int i = 0; i < n; ++i) {
            iArithmeticArray[i] = ((Real)this.get(n, i)).div(1L);
        }
        return new Vector(iArithmeticArray);
    }

    @Override
    public int hashCode() {
        return this.getCoordinates().hashCode();
    }

    @Override
    public IArithmetic inverse() {
        return new Operator((Matrix)this.coords.inverse());
    }

    @Override
    public boolean isExact() {
        return this.coords.isExact();
    }

    @Override
    public IArithmetic negative() {
        throw new UnsupportedOperationException("operation not defined");
    }

    @Override
    public IArithmetic one() {
        return new Operator((Matrix)this.coords.one());
    }

    @Override
    public IArithmetic plus(Object object) {
        throw new UnsupportedOperationException("operation not defined");
    }

    @Override
    public IArithmetic times(Object object) {
        if (object instanceof Operator) {
            Matrix matrix = ((Operator)object).coords;
            return new Operator((Matrix)this.coords.times(matrix));
        }
        if (object instanceof Vector) {
            return this.times(new Operator((Vector)object));
        }
        if (object instanceof IArithmetic) {
            return ((IArithmetic)object).rtimes(this);
        }
        throw new UnsupportedOperationException("operation not defined");
    }

    @Override
    public String toString() {
        return this.coords.toString().replaceFirst("Matrix", "Operator");
    }

    @Override
    public IArithmetic zero() {
        throw new UnsupportedOperationException("operation not defined");
    }

    public static Operator orthogonalProjection(Matrix matrix, Matrix matrix2) {
        int n = matrix.numberOfColumns();
        int n2 = matrix.rank();
        Matrix matrix3 = matrix.mutableClone();
        Matrix.triangulate(matrix3, null, true, false);
        matrix3 = matrix3.getSubMatrix(0, 0, n2, n);
        Matrix matrix4 = LinearAlgebra.columnNullSpace(matrix3, true).transposed();
        Matrix matrix5 = new Matrix(n, n);
        matrix5.setSubMatrix(0, 0, matrix3);
        matrix5.setSubMatrix(n2, 0, matrix4);
        Matrix matrix6 = LinearAlgebra.rowOrthonormalized(matrix5, matrix2);
        Matrix matrix7 = Matrix.one(n + 1).mutableClone();
        for (int i = n2; i < n; ++i) {
            matrix7.set(i, i, Whole.ZERO);
        }
        Operator operator = new Operator(matrix7);
        return (Operator)operator.times(new CoordinateChange(matrix6).inverse());
    }

    public static Matrix parse(String string) {
        int n;
        String string2 = "Bad operator format for \"" + string + "\": ";
        String[] stringArray = string.replaceAll("\\s+", "").split(",");
        if (stringArray.length > 3) {
            throw new DataFormatException(string2 + "more than 3 coordinates.");
        }
        int n2 = stringArray.length;
        String string3 = "xyz".substring(0, n2) + "#";
        Matrix matrix = new Matrix(n2 + 1, n2 + 1);
        matrix.setColumn(n2, Matrix.zero(n2 + 1, 1));
        matrix.set(n2, n2, new Whole(1L));
        for (n = 0; n < n2; ++n) {
            String string4 = stringArray[n] + "#";
            int n3 = string4.length() - 1;
            int n4 = 0;
            while (n4 < n3) {
                char c;
                IArithmetic iArithmetic = new Whole(1L);
                if (string4.charAt(n4) == '-') {
                    iArithmetic = iArithmetic.negative();
                    ++n4;
                } else if (string4.charAt(n4) == '+') {
                    ++n4;
                }
                int n5 = n4;
                while (Character.isDigit(string4.charAt(n4))) {
                    ++n4;
                }
                if (n4 > n5) {
                    c = Integer.parseInt(string4.substring(n5, n4));
                    iArithmetic = iArithmetic.times(new Whole(c));
                }
                if (string4.charAt(n4) == '/') {
                    n5 = ++n4;
                    while (Character.isDigit(string4.charAt(n4))) {
                        ++n4;
                    }
                    if (n4 > n5) {
                        c = Integer.parseInt(string4.substring(n5, n4));
                        iArithmetic = iArithmetic.dividedBy(new Whole(c));
                    } else {
                        throw new DataFormatException(string2 + "fraction has no denominator");
                    }
                }
                if (string4.charAt(n4) == '*') {
                    ++n4;
                }
                if ((n5 = string3.indexOf(c = (char)string4.charAt(n4))) >= 0) {
                    ++n4;
                } else if (Character.isDigit(c) || "+-".indexOf(c) >= 0) {
                    n5 = n2;
                } else {
                    throw new DataFormatException(string2 + "illegal variable name " + c);
                }
                if (matrix.get(n5, n) != null) {
                    throw new DataFormatException(string2 + "variable used twice");
                }
                matrix.set(n5, n, iArithmetic);
            }
        }
        for (n = 0; n < n2 + 1; ++n) {
            for (int i = 0; i < n2 + 1; ++i) {
                if (matrix.get(n, i) != null) continue;
                matrix.set(n, i, Whole.ZERO);
            }
        }
        matrix.makeImmutable();
        return matrix;
    }
}

