/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.dsyms.io;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.gavrog.box.collections.Iterators;
import org.gavrog.jane.compounds.LinearAlgebra;
import org.gavrog.jane.compounds.Matrix;
import org.gavrog.jane.numbers.IArithmetic;
import org.gavrog.jane.numbers.Real;
import org.gavrog.jane.numbers.Whole;
import org.gavrog.joss.dsyms.basic.DSPair;
import org.gavrog.joss.dsyms.basic.DSymbol;
import org.gavrog.joss.dsyms.basic.IndexList;
import org.gavrog.joss.dsyms.derived.DSCover;
import org.gavrog.joss.dsyms.generators.InputIterator;
import org.gavrog.joss.geometry.CoordinateChange;
import org.gavrog.joss.geometry.Lattices;
import org.gavrog.joss.geometry.Point;
import org.gavrog.joss.geometry.Vector;
import org.gavrog.joss.pgraphs.basic.IEdge;
import org.gavrog.joss.pgraphs.basic.INode;
import org.gavrog.joss.pgraphs.embed.Embedder;
import org.gavrog.joss.tilings.Tiling;

public class EvolverExporter {
    private static final NumberFormat fmt;
    private final Tiling til;
    private final Tiling.Skeleton net;
    private final Embedder embedder;
    private final CoordinateChange embedderToWorld;
    private final Map<DSPair<Integer>, Point> pos;
    private final double[][] cell;
    private final CoordinateChange worldToCell;
    private String head = null;
    private String tail = null;
    private boolean skipPeriods = false;
    private boolean unitVolumes = false;

    static {
        Locale.setDefault(Locale.US);
        fmt = new DecimalFormat("##0.000000000");
    }

    public EvolverExporter(Tiling til) {
        this.til = til;
        this.net = til.getSkeleton();
        this.embedder = new Embedder(this.net, null, false);
        this.embedder.reset();
        this.embedder.setPasses(1);
        if (this.net.isStable()) {
            this.embedder.setRelaxPositions(false);
            this.embedder.go(500);
        }
        this.embedder.setRelaxPositions(true);
        this.embedder.go(10000);
        this.embedder.normalize();
        Matrix gram = this.embedder.getGramMatrix();
        this.embedderToWorld = new CoordinateChange(LinearAlgebra.orthonormalRowBasis(gram));
        this.pos = this.til.cornerPositions(this.embedder.getPositions());
        int dim = til.getSymbol().dim();
        Matrix I = Matrix.one(dim);
        Vector[] basis = new Vector[dim];
        int i = 0;
        while (i < dim) {
            basis[i] = (Vector)Vector.unit(dim, i).times(this.embedderToWorld);
            ++i;
        }
        Vector[] tvecs = Lattices.reducedLatticeBasis(basis, I);
        this.cell = new double[dim][dim];
        int i2 = 0;
        while (i2 < dim) {
            int j = 0;
            while (j < dim) {
                this.cell[i2][j] = ((Real)tvecs[i2].get(j)).doubleValue();
                ++j;
            }
            ++i2;
        }
        this.worldToCell = new CoordinateChange(Vector.toMatrix(tvecs));
    }

    private double[] vertexShift(double[] p) {
        int dim = p.length;
        CoordinateChange C = this.worldToCell;
        Point v = (Point)new Point(p).times(C);
        IArithmetic[] a = new Whole[dim];
        int i = 0;
        while (i < dim) {
            Real x = (Real)v.get(i);
            a[i] = (Whole)x.plus(0.001).mod(Whole.ONE).minus(x).round();
            ++i;
        }
        Vector w = (Vector)new Vector(a).times(C.inverse());
        return w.getCoordinates().asDoubleArray()[0];
    }

    private double volume(double[][] c) {
        return c[0][0] * c[1][1] * c[2][2] - c[0][2] * c[1][1] * c[2][0] + c[0][1] * c[1][2] * c[2][0] - c[0][0] * c[1][2] * c[2][1] + c[0][2] * c[1][0] * c[2][1] - c[0][1] * c[1][0] * c[2][2];
    }

    private double chamberVolume(int D) {
        double[] c = this.cornerPosition(3, D);
        double[][] v = new double[3][3];
        int i = 0;
        while (i < 3) {
            double[] p = this.cornerPosition(i, D);
            int j = 0;
            while (j < 3) {
                v[i][j] = p[j] - c[j];
                ++j;
            }
            ++i;
        }
        return this.volume(v);
    }

    public double[] cornerPosition(int i, int D) {
        Point p0 = this.pos.get(new DSPair<Integer>(i, D));
        Point p = (Point)p0.times(this.embedderToWorld);
        return p.getCoordinates().asDoubleArray()[0];
    }

    public void writeTo(Writer writer) throws IOException {
        BufferedWriter outf = new BufferedWriter(writer);
        List<Tiling.Tile> tiles = this.til.getTiles();
        double vol = this.volume(this.cell) / (double)tiles.size();
        double tvol = this.getUnitVolumes() ? 1.0 : 1.0 / (double)tiles.size();
        double scale = Math.pow(Math.abs(vol / tvol), -0.3333333333333333);
        outf.write("parameter p1x = " + fmt.format(this.cell[0][0] * scale) + '\n');
        outf.write("parameter p1y = " + fmt.format(this.cell[0][1] * scale) + '\n');
        outf.write("parameter p1z = " + fmt.format(this.cell[0][2] * scale) + '\n');
        outf.write("parameter p2x = " + fmt.format(this.cell[1][0] * scale) + '\n');
        outf.write("parameter p2y = " + fmt.format(this.cell[1][1] * scale) + '\n');
        outf.write("parameter p2z = " + fmt.format(this.cell[1][2] * scale) + '\n');
        outf.write("parameter p3x = " + fmt.format(this.cell[2][0] * scale) + '\n');
        outf.write("parameter p3y = " + fmt.format(this.cell[2][1] * scale) + '\n');
        outf.write("parameter p3z = " + fmt.format(this.cell[2][2] * scale) + '\n');
        outf.write(10);
        if (this.head != null) {
            outf.write("#include \"" + this.head + "\"\n");
            outf.write(10);
        }
        if (!this.getSkipPeriods()) {
            outf.write("torus_filled\n");
            outf.write(10);
            outf.write("periods\n");
            outf.write("p1x p1y p1z\n");
            outf.write("p2x p2y p2z\n");
            outf.write("p3x p3y p3z\n");
            outf.write(10);
        }
        outf.write("vertices\n");
        ArrayList nodes = new ArrayList();
        nodes.add(null);
        Iterators.addAll(nodes, this.net.nodes());
        double[][] shifts = new double[nodes.size()][];
        HashMap<INode, Integer> nodeNumbers = new HashMap<INode, Integer>();
        int i = 0;
        for (INode v : nodes) {
            if (v == null) continue;
            nodeNumbers.put(v, ++i);
            int D = this.net.chamberAtNode(v);
            double[] p = this.cornerPosition(0, D);
            double[] s = this.vertexShift(p);
            shifts[i] = s;
            outf.write(String.valueOf(i) + "  ");
            int k = 0;
            while (k < 3) {
                outf.write(" " + fmt.format((p[k] + s[k]) * scale));
                ++k;
            }
            outf.write(10);
        }
        outf.write(10);
        outf.write("edges\n");
        CoordinateChange e2w = this.embedderToWorld;
        CoordinateChange w2c = this.worldToCell;
        ArrayList edges = new ArrayList();
        edges.add(null);
        Iterators.addAll(edges, this.net.edges());
        HashMap<IEdge, Integer> edgeNumbers = new HashMap<IEdge, Integer>();
        i = 0;
        for (IEdge e : edges) {
            if (e == null) continue;
            edgeNumbers.put(e, ++i);
            int v = (Integer)nodeNumbers.get(e.source());
            int w = (Integer)nodeNumbers.get(e.target());
            outf.write(String.valueOf(i) + "  " + v + ' ' + w + ' ');
            Vector se = (Vector)this.net.getShift(e).times(e2w);
            Vector sv = new Vector(shifts[v]);
            Vector sw = new Vector(shifts[w]);
            Vector s = (Vector)se.plus(sv).minus(sw).times(w2c);
            int k = 0;
            while (k < 3) {
                Whole x = (Whole)s.get(k).round();
                if (x.isZero()) {
                    outf.write(" *");
                } else if (x.isOne()) {
                    outf.write(" +");
                } else if (x.negative().isOne()) {
                    outf.write(" -");
                } else {
                    outf.write(" " + x);
                }
                ++k;
            }
            outf.write(10);
        }
        outf.write(10);
        outf.write("faces\n");
        DSCover<Integer> cover = this.til.getCover();
        HashMap<Integer, Integer> ch2faceNr = new HashMap<Integer, Integer>();
        i = 0;
        Iterator<Object> iterator = cover.orbitReps(new IndexList(0, 1, 3)).iterator();
        while (iterator.hasNext()) {
            int D0;
            int entry = (Integer)iterator.next();
            if (this.chamberVolume(entry) > 0.001) {
                D0 = entry;
            } else if (this.chamberVolume(entry) < -0.001) {
                D0 = cover.op(0, (Integer)entry);
            } else {
                throw new RuntimeException("degenerate chamber found");
            }
            outf.write(String.valueOf(++i) + " ");
            int D = D0;
            do {
                IEdge e = this.net.edgeForChamber(D);
                int k = (Integer)edgeNumbers.get(e);
                if (e.oriented().equals(((IEdge)edges.get(k)).oriented())) {
                    outf.write(" " + k);
                } else {
                    outf.write(" " + -k);
                }
                ch2faceNr.put(D, i);
                ch2faceNr.put(cover.op(3, (Integer)D), -i);
                D = cover.op(0, (Integer)D);
                ch2faceNr.put(D, i);
                ch2faceNr.put(cover.op(3, (Integer)D), -i);
            } while (D0 != (D = cover.op(1, (Integer)D).intValue()));
            outf.write(10);
        }
        outf.write(10);
        outf.write("bodies\n");
        i = 0;
        for (Tiling.Tile t : this.til.getTiles()) {
            outf.write(String.valueOf(++i) + " ");
            int k = 0;
            while (k < t.size()) {
                int D = t.facet(k).getChamber();
                int n = (Integer)ch2faceNr.get(D);
                outf.write(" " + n);
                ++k;
            }
            outf.write("   volume " + fmt.format(tvol) + "\n");
        }
        outf.write(10);
        if (this.tail != null) {
            outf.write("#include \"" + this.tail + "\"\n");
            outf.write(10);
        }
        outf.flush();
    }

    public String getHead() {
        return this.head;
    }

    public void setHead(String head) {
        this.head = head;
    }

    public String getTail() {
        return this.tail;
    }

    public void setTail(String tail) {
        this.tail = tail;
    }

    public boolean getSkipPeriods() {
        return this.skipPeriods;
    }

    public void setSkipPeriods(boolean skipPeriods) {
        this.skipPeriods = skipPeriods;
    }

    public void toggleSkipPeriods() {
        this.skipPeriods = !this.skipPeriods;
    }

    public boolean getUnitVolumes() {
        return this.unitVolumes;
    }

    public void setUnitVolumes(boolean unitVolumes) {
        this.unitVolumes = unitVolumes;
    }

    public void toggleUnitVolumes() {
        this.unitVolumes = !this.unitVolumes;
    }

    public static void main(String[] args) {
        String head = null;
        String tail = null;
        boolean skipPeriods = false;
        boolean unitVolumes = false;
        int i = 0;
        while (i < args.length && args[i].startsWith("-")) {
            if (args[i].equals("-p")) {
                skipPeriods = !skipPeriods;
            } else if (args[i].equals("-u")) {
                unitVolumes = !unitVolumes;
            } else if (args[i].equals("-h")) {
                head = args[++i];
            } else if (args[i].equals("-t")) {
                tail = args[++i];
            } else {
                System.err.println("Unknown option '" + args[i] + "'");
            }
            ++i;
        }
        String name = args[i];
        String base = name.endsWith(".ds") ? name.substring(0, name.length() - 3) : name;
        DecimalFormat suffix = new DecimalFormat("-000.fe");
        int k = 0;
        for (DSymbol ds : new InputIterator(name)) {
            Tiling til = new Tiling(ds);
            EvolverExporter exporter = new EvolverExporter(til);
            exporter.setHead(head);
            exporter.setTail(tail);
            exporter.setSkipPeriods(skipPeriods);
            exporter.setUnitVolumes(unitVolumes);
            String outname = String.valueOf(base) + suffix.format(++k);
            try {
                FileWriter out = new FileWriter(outname);
                exporter.writeTo(out);
                out.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

