/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.dsyms.generators;

import buoy.event.EventProcessor;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.gavrog.box.collections.IteratorAdapter;
import org.gavrog.box.collections.Iterators;
import org.gavrog.box.collections.Pair;
import org.gavrog.box.simple.Stopwatch;
import org.gavrog.joss.algorithms.CheckpointEvent;
import org.gavrog.joss.algorithms.ResumableGenerator;
import org.gavrog.joss.dsyms.basic.DSymbol;
import org.gavrog.joss.dsyms.basic.DelaneySymbol;
import org.gavrog.joss.dsyms.basic.DynamicDSymbol;
import org.gavrog.joss.dsyms.basic.IndexList;
import org.gavrog.joss.dsyms.derived.Covers;
import org.gavrog.joss.dsyms.derived.DSCover;
import org.gavrog.joss.dsyms.derived.EuclidicityTester;
import org.gavrog.joss.dsyms.generators.CombineTiles;
import org.gavrog.joss.dsyms.generators.DefineBranching3d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TileKTransitiveDuo
extends ResumableGenerator<DSymbol> {
    private final boolean verbose;
    private final boolean simple;
    private final Iterator<Pair<List<DSymbol>, List<DSymbol>>> partLists;
    private ResumableGenerator<DSymbol> extended;
    private Iterator<DSymbol> symbols;
    private int count2dSymbols = 0;
    private int count3dSets = 0;
    private int count3dSymbols = 0;
    private int countMinimal = 0;
    private int[] checkpoint = new int[3];
    private int[] resume = new int[3];
    private String resume1 = null;

    public <A, B> TileKTransitiveDuo(DelaneySymbol<A> tileA, int nrA, DelaneySymbol<B> tileB, int nrB, boolean simple, boolean verbose) {
        this.verbose = verbose;
        this.simple = simple;
        List<DSCover<Integer>> coversA = Iterators.asList(Covers.allCovers(tileA.minimal()));
        List<DSCover<Integer>> coversB = Iterators.asList(Covers.allCovers(tileB.minimal()));
        DSymbol[] a = new DSymbol[coversA.size()];
        DSymbol[] b = new DSymbol[coversB.size()];
        IteratorAdapter<List<DSymbol>> listsA = Iterators.selections(coversA.toArray(a), nrA);
        IteratorAdapter<List<DSymbol>> listsB = Iterators.selections(coversB.toArray(b), nrB);
        this.partLists = Iterators.cantorProduct(listsA, listsB);
        this.extended = null;
        this.symbols = null;
    }

    @Override
    public void setResumePoint(String spec) {
        if (spec == null || spec.length() == 0) {
            return;
        }
        String[] fields = spec.trim().split("-");
        this.resume[0] = Integer.valueOf(fields[0]);
        if (fields[1].startsWith("[")) {
            this.resume1 = fields[1].substring(1, fields[1].length() - 1).replaceAll("\\.", "-");
        } else {
            this.resume[1] = Integer.valueOf(fields[2]);
            this.resume[2] = Integer.valueOf(fields[2]);
        }
    }

    private boolean tooEarly() {
        if (this.checkpoint[0] != this.resume[0]) {
            return this.checkpoint[0] < this.resume[0];
        }
        if (this.resume1 == null) {
            if (this.checkpoint[1] != this.resume[1]) {
                return this.checkpoint[1] < this.resume[1];
            }
            return this.checkpoint[2] < this.resume[2];
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected DSymbol findNext() throws NoSuchElementException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[DOLOOP]], but top level block is 3[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void postCheckpoint() {
        this.dispatchEvent(new CheckpointEvent(this, this.tooEarly(), null));
    }

    private void repostCheckpoint(Object ev) {
        CheckpointEvent ce = (CheckpointEvent)ev;
        this.dispatchEvent(new CheckpointEvent(this, ce.isOld(), ce.getMessage()));
    }

    @Override
    public String getCheckpoint() {
        if (this.extended != null && this.extended instanceof ResumableGenerator) {
            return String.format("%d-[%s]", this.checkpoint[0], this.extended.getCheckpoint().replaceAll("-", "."));
        }
        return String.format("%s-%s-%s", this.checkpoint[0], this.checkpoint[1], this.checkpoint[2]);
    }

    protected boolean partsListOkay(List<DSymbol> list) {
        return true;
    }

    protected Iterator<DSymbol> defineBranching(DSymbol ds) {
        if (this.simple) {
            DynamicDSymbol out = new DynamicDSymbol(ds);
            IndexList idx = new IndexList(2, 3);
            Iterator iterator = out.orbitReps(idx).iterator();
            while (iterator.hasNext()) {
                int D = (Integer)iterator.next();
                int r = out.r(2, 3, D);
                if (r == 3) {
                    out.redefineV(2, 3, D, 1);
                    continue;
                }
                if (r == 1) {
                    out.redefineV(2, 3, D, 3);
                    continue;
                }
                throw new RuntimeException("this should not happen: r = " + r + " at D = " + D);
            }
            if (out.isLocallyEuclidean3D()) {
                return Iterators.singleton(new DSymbol(out));
            }
            return Iterators.empty();
        }
        return new DefineBranching3d(ds);
    }

    protected ResumableGenerator<DSymbol> extendTo3d(DSymbol ds) {
        if (this.simple) {
            return new CombineTiles(ds){

                @Override
                protected List<CombineTiles.Move> getExtraDeductions(DelaneySymbol<Integer> ds, CombineTiles.Move move) {
                    int D;
                    ArrayList<CombineTiles.Move> out = new ArrayList<CombineTiles.Move>();
                    int E = D = move.element;
                    int r = 0;
                    ArrayList<Integer> cuts = new ArrayList<Integer>();
                    do {
                        if (ds.definesOp(3, E = ds.op(2, E).intValue())) {
                            E = ds.op(3, E);
                        } else {
                            cuts.add(E);
                        }
                        ++r;
                    } while (E != D);
                    switch (cuts.size()) {
                        case 0: {
                            if (r != 2 && r <= 3) break;
                            return null;
                        }
                        case 1: {
                            if (r > 3) {
                                return null;
                            }
                            if (r != 3) break;
                            int A = (Integer)cuts.get(0);
                            out.add(new CombineTiles.Move(this, A, A, -1, -1, false, 0));
                            break;
                        }
                        case 2: {
                            if (r > 6) {
                                return null;
                            }
                            if (r != 6) break;
                            int A = (Integer)cuts.get(0);
                            int B = (Integer)cuts.get(1);
                            out.add(new CombineTiles.Move(this, A, B, -1, -1, false, 0));
                            break;
                        }
                        default: {
                            throw new RuntimeException("this should not happen");
                        }
                    }
                    return out;
                }
            };
        }
        return new CombineTiles(ds);
    }

    public String statistics() {
        return "Constructed " + this.count2dSymbols + " spherical symbols, " + this.count3dSets + " partial spatial symbols and " + this.count3dSymbols + " complete spatial symbols, of which " + this.countMinimal + " were minimal.";
    }

    private static String setAsString(DSymbol ds) {
        String tmp = ds.toString();
        int i = tmp.lastIndexOf(58);
        return tmp.substring(0, i);
    }

    private static String branchingAsString(DSymbol ds) {
        String tmp = ds.toString();
        int i = tmp.lastIndexOf(58);
        return tmp.substring(i + 1);
    }

    public static void usage() {
        System.err.print("Usage: java [PATH] [OPTION]... ds1 k1 ds2 k2 [FILE]\n\nwhere  PATH = org.gavrog.joss.dsyms.generators.TileKTransitiveDuo\n  ds1, ds2: D-symbols for topological tile types 1 and 2  k1, k2:   numbers of tile orbits of types 1 and 2\nRecognized options:\n  -e        skip euclidicity test\n  -i N      interval in seconds between writing checkpoints\n  -r A-B-C  resume generation at a checkpoint\n  -s        generate only simple tilings\n  -v        run in verbose mode\n");
        System.exit(1);
    }

    public static void main(String[] args) {
        try {
            boolean verbose = false;
            boolean check = true;
            boolean simple = false;
            int checkpointInterval = 3600;
            String resume = null;
            int i = 0;
            while (i < args.length && args[i].startsWith("-")) {
                if (args[i].equals("-v")) {
                    verbose = !verbose;
                } else if (args[i].equals("-e")) {
                    check = !check;
                } else if (args[i].equals("-s")) {
                    simple = !simple;
                } else if (args[i].equals("-i")) {
                    checkpointInterval = Integer.parseInt(args[++i]);
                } else if (args[i].equals("-r")) {
                    resume = args[++i];
                } else {
                    TileKTransitiveDuo.usage();
                }
                ++i;
            }
            if (args.length < i + 4) {
                TileKTransitiveDuo.usage();
            }
            DSymbol dsA = new DSymbol(args[i]);
            int nrA = Integer.parseInt(args[i + 1]);
            DSymbol dsB = new DSymbol(args[i + 2]);
            int nrB = Integer.parseInt(args[i + 3]);
            final OutputStreamWriter output = args.length > (i += 4) + 1 ? new FileWriter(args[i + 1]) : new OutputStreamWriter(System.out);
            int countGood = 0;
            int countAmbiguous = 0;
            Stopwatch timer = new Stopwatch();
            Stopwatch eTestTimer = new Stopwatch();
            timer.start();
            output.write("# Program TileKTransitiveDuo.\n");
            output.write("# Arguments:\n");
            output.write("#     ds1 = " + dsA + "\n");
            output.write("#     k1  = " + nrA + "\n");
            output.write("#     ds2 = " + dsB + "\n");
            output.write("#     k2  = " + nrB + "\n");
            output.write("# Options:\n");
            output.write("#     simple tilings only:             ");
            output.write(String.valueOf(simple ? "on" : "off") + "\n");
            output.write("#     euclidicity test:                ");
            output.write(String.valueOf(check ? "on" : "off") + "\n");
            output.write("#     verbose mode:                    ");
            output.write(String.valueOf(verbose ? "on" : "off") + "\n");
            output.write("#     checkpoint interval:             ");
            output.write(String.valueOf(checkpointInterval) + "sec\n");
            if (resume != null) {
                output.write(String.format("# Resuming at %s.\n", resume));
            }
            output.write("\n");
            ((Writer)output).flush();
            TileKTransitiveDuo iter = new TileKTransitiveDuo(dsA, nrA, dsB, nrB, simple, verbose);
            final Stopwatch chkptTimer = new Stopwatch();
            final int interval = 1000 * checkpointInterval;
            iter.addEventLink(CheckpointEvent.class, new EventProcessor(){

                public void handleEvent(Object event) {
                    CheckpointEvent ce = (CheckpointEvent)event;
                    if (ce.getMessage() != null || chkptTimer.elapsed() > (long)interval) {
                        chkptTimer.reset();
                        try {
                            output.write(ce + "\n");
                            output.flush();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
            });
            chkptTimer.start();
            if (resume != null) {
                iter.setResumePoint(resume);
            }
            for (DSymbol out : iter) {
                if (check) {
                    eTestTimer.start();
                    EuclidicityTester tester = new EuclidicityTester(out);
                    boolean bad = tester.isBad();
                    boolean ambiguous = tester.isAmbiguous();
                    eTestTimer.stop();
                    if (!bad) {
                        if (ambiguous) {
                            output.write("#@ name euclidicity dubious\n");
                            ++countAmbiguous;
                        }
                        output.write(out + "\n");
                        ++countGood;
                    }
                } else {
                    output.write(out + "\n");
                }
                ((Writer)output).flush();
            }
            timer.stop();
            output.write("\n");
            output.write("# Total execution time in user mode was " + timer.format() + ".\n");
            if (check) {
                output.write("# Time for euclidicity tests was " + eTestTimer.format() + ".\n");
            }
            output.write("\n");
            output.write("# " + iter.statistics() + "\n");
            if (check) {
                output.write("# Of those, " + countGood + " were found euclidean.\n");
                if (countAmbiguous > 0) {
                    output.write("# For " + countAmbiguous + " symbols, euclidicity remains undetermined.\n");
                }
            }
            ((Writer)output).flush();
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }
}

