/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.dsyms.filters;

import org.gavrog.joss.dsyms.basic.DSymbol;
import org.gavrog.joss.dsyms.derived.Covers;
import org.gavrog.joss.dsyms.derived.DSCover;
import org.gavrog.joss.dsyms.generators.InputIterator;
import org.gavrog.joss.tilings.Tiling;

public class FilterUnstable {
    public static void main(String[] args) {
        String filename = args[0];
        int inCount = 0;
        int outCount = 0;
        for (DSymbol ds : new InputIterator(filename)) {
            ++inCount;
            if (!FilterUnstable.isUnstable(ds)) continue;
            ++outCount;
            System.out.println(ds);
        }
        System.err.println("Read " + inCount + " symbols, " + outCount + " of which had unstable graphs.");
    }

    private static boolean isUnstable(DSymbol ds) {
        DSCover<Integer> cov = Covers.pseudoToroidalCover3D(ds.minimal());
        try {
            return !new Tiling(cov).getSkeleton().isLocallyStable();
        }
        catch (Exception ex) {
            System.out.println("??? " + ds);
            return false;
        }
    }
}

