/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.dsyms.filters;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashSet;
import org.gavrog.box.collections.NiftyList;
import org.gavrog.box.simple.Misc;
import org.gavrog.joss.dsyms.basic.DSymbol;
import org.gavrog.joss.dsyms.derived.Covers;
import org.gavrog.joss.dsyms.generators.InputIterator;
import org.gavrog.joss.pgraphs.basic.PeriodicGraph;
import org.gavrog.joss.tilings.Tiling;

public class FilterProper {
    public static void main(String[] args) {
        try {
            boolean unique = false;
            boolean canonical = false;
            boolean dualize = false;
            boolean verbose = false;
            int i = 0;
            while (i < args.length && args[i].startsWith("-")) {
                if (args[i].equalsIgnoreCase("-c")) {
                    canonical = !canonical;
                } else if (args[i].equalsIgnoreCase("-u")) {
                    unique = !unique;
                } else if (args[i].equalsIgnoreCase("-d")) {
                    dualize = !dualize;
                } else if (args[i].equalsIgnoreCase("-v")) {
                    verbose = !verbose;
                } else {
                    System.err.println("Unknown option '" + args[i] + "'");
                }
                ++i;
            }
            InputStreamReader in = args.length > i ? new FileReader(args[i]) : new InputStreamReader(System.in);
            OutputStreamWriter out = args.length > i + 1 ? new FileWriter(args[i + 1]) : new OutputStreamWriter(System.out);
            int inCount = 0;
            int outCount = 0;
            HashSet<NiftyList<Integer>> seen = new HashSet<NiftyList<Integer>>();
            for (DSymbol symbol : new InputIterator(in)) {
                ++inCount;
                DSymbol ds = dualize ? symbol.dual() : symbol;
                try {
                    DSymbol min = new DSymbol(ds.minimal());
                    DSymbol cov = new DSymbol(Covers.pseudoToroidalCover3D(min));
                    Tiling t = new Tiling(cov);
                    PeriodicGraph gr = new PeriodicGraph(t.getSkeleton());
                    if (!gr.isStable()) {
                        if (!verbose) continue;
                        System.err.print("# --- Symbol " + inCount + " is not stable.\n");
                        continue;
                    }
                    if (!gr.isMinimal()) {
                        if (!verbose) continue;
                        System.err.print("# --- Symbol " + inCount + " is not proper - " + "graph has extra translations.\n");
                        continue;
                    }
                    if (unique && seen.contains(gr.invariant())) {
                        if (!verbose) continue;
                        System.err.print("# --- Symbol " + inCount + " is a duplicate.\n");
                        continue;
                    }
                    if (gr.symmetries().size() != cov.size() / min.size()) {
                        if (!verbose) continue;
                        System.err.print("# --- Symbol " + inCount + " is not proper - " + gr.symmetries().size() + " vs. " + cov.size() / min.size() + " point ops.\n");
                        continue;
                    }
                    if (verbose) {
                        System.err.print("# +++ Symbol " + inCount + " is proper.\n");
                    }
                    ++outCount;
                    if (canonical) {
                        out.write(ds.toString());
                    } else {
                        out.write(ds.canonical().flat().toString());
                    }
                    if (unique) {
                        seen.add(gr.invariant());
                    }
                }
                catch (Exception ex) {
                    out.write(Misc.stackTrace(ex, "# "));
                    out.write("# in symbol " + ds);
                }
                ((Writer)out).write(10);
                ((Writer)out).flush();
            }
            out.write("### Read " + inCount + " and wrote " + outCount + " symbols.\n");
            ((Writer)out).flush();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

