/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.dsyms.derived;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.gavrog.box.collections.Pair;
import org.gavrog.joss.dsyms.basic.DSymbol;
import org.gavrog.joss.dsyms.basic.DelaneySymbol;
import org.gavrog.joss.dsyms.derived.EuclidicityTester;
import org.gavrog.joss.dsyms.generators.InputIterator;

public class TestEuclidicityTester
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void test01() {
        EuclidicityTester tester = new EuclidicityTester(new DSymbol("2 3:1 2,1 2,1 2,2:3 3,3 4,4"));
        Assert.assertTrue((boolean)tester.isGood());
    }

    public void test02() {
        EuclidicityTester tester = new EuclidicityTester(new DSymbol("1 3:1,1,1,1:4,3,4"));
        Assert.assertTrue((boolean)tester.isGood());
    }

    public void test03() {
        EuclidicityTester tester = new EuclidicityTester(new DSymbol("20 3:2 4 6 8 10 12 14 16 18 20, 10 3 5 7 9 20 13 15 17 19,4 3 11 12 16 15 19 20 17 18,16 15 14 13 12 11 20 19 18 17:5 5,3 6 3 3,4 4 4"));
        Assert.assertTrue((boolean)tester.isBad());
        Assert.assertEquals((String)"orbifold invariants do not match", (String)tester.getCause());
    }

    public void test04() {
        EuclidicityTester tester = new EuclidicityTester(new DSymbol("48 3:2 4 6 8 10 12 14 16 18 20 22 24 26 28 30 32 34 36 38 40 42 44 46 48,8 3 5 7 16 11 13 15 24 19 21 23 32 27 29 31 40 35 37 39 48 43 45 47,9 10 17 18 25 26 33 34 24 23 41 42 36 35 32 31 47 48 40 39 45 46 43 44,2 8 7 6 10 16 15 14 18 24 23 22 33 34 35 36 37 38 39 40 42 48 47 46:4 4 4 4 4 4,3 3 3 3 3 3 3 3,4 6 4 4 12 6"));
        Assert.assertTrue((boolean)tester.isBad());
        Assert.assertEquals((String)"orbifold invariants do not match", (String)tester.getCause());
    }

    public void test05() {
        EuclidicityTester tester = new EuclidicityTester(new DSymbol("24 3:2 4 6 8 10 11 12 14 15 16 18 19 20 22 23 24,8 3 5 7 12 11 16 15 20 19 24 23,9 10 13 14 17 18 21 22 16 23 20 24,6 5 4 8 10 12 18 17 20 19 22 24:4 4 4 4 4,3 3 3 3,6 8 6 3"));
        Assert.assertTrue((boolean)tester.isBad());
        Assert.assertEquals((String)"orbifold invariants do not match", (String)tester.getCause());
    }

    public void test06() {
        EuclidicityTester tester = new EuclidicityTester(new DSymbol("48 3:2 4 6 8 10 12 14 16 18 20 22 24 26 28 30 32 34 36 38 40 42 44 46 48,8 3 5 7 16 11 13 15 24 19 21 23 32 27 29 31 40 35 37 39 48 43 45 47,9 10 17 18 25 26 33 34 24 23 41 42 36 35 32 31 47 48 40 39 45 46 43 44,2 8 7 6 13 14 15 16 18 24 23 22 34 33 40 39 38 37 36 35 46 45 44 48:4 4 4 4 4 4,3 3 3 3 3 3 3 3,8 6 6 4 3 3"));
        Assert.assertTrue((boolean)tester.isBad());
        Assert.assertEquals((String)"orbifold invariants do not match", (String)tester.getCause());
    }

    public void test07() {
        EuclidicityTester tester = new EuclidicityTester(new DSymbol("24 3:1 3 4 6 8 10 12 14 16 18 20 22 24,2 3 5 6 12 9 11 18 15 17 24 21 23,4 7 8 12 11 9 10 19 20 16 21 22 24,1 2 3 4 5 6 13 14 15 16 17 18 19 20 21 22 23 24:3 3 3 3 3,3 3 3 3 3,6 4 4 12 12 4 4"));
        Assert.assertTrue((boolean)tester.isBad());
        Assert.assertEquals((String)"orbifold invariants do not match", (String)tester.getCause());
    }

    public void test08() {
        EuclidicityTester tester = new EuclidicityTester(new DSymbol("60 3:2 4 6 8 10 12 14 16 18 20 22 24 26 28 30 32 34 36 38 40 42 44 46 48 50 52 54 56 58 60,6 3 5 12 9 11 18 15 17 24 21 23 30 27 29 36 33 35 42 39 41 48 45 47 54 51 53 60 57 59,2 7 8 11 12 10 19 20 25 26 31 32 30 29 34 33 36 35 43 44 49 50 55 56 54 53 58 57 60 59,13 14 15 16 17 18 37 38 39 40 41 42 22 21 24 32 31 36 35 34 33 56 55 60 59 58 57 49 50 51 52 53 54:3 3 3 3 3 3 3 3 3 3,3 3 3 3 3 3 3 3 3 3,7 6 6 6 3 3 8 8 3 3"));
        Assert.assertTrue((boolean)tester.isBad());
        Assert.assertEquals((String)"cover is a non-trivial connected sum", (String)tester.getCause());
    }

    public void test09() {
        EuclidicityTester tester = new EuclidicityTester(new DSymbol("60 3:2 4 6 8 10 12 14 16 18 20 22 24 26 28 30 32 34 36 38 40 42 44 46 48 50 52 54 56 58 60,6 3 5 12 9 11 18 15 17 24 21 23 30 27 29 36 33 35 42 39 41 48 45 47 54 51 53 60 57 59,2 7 8 11 12 10 19 20 25 26 31 32 30 29 34 33 36 35 43 44 49 50 55 56 54 53 58 57 60 59,13 14 15 16 17 18 37 38 39 40 41 42 22 21 24 32 31 36 35 34 33 56 55 60 59 58 57 50 54 53:3 3 3 3 3 3 3 3 3 3,3 3 3 3 3 3 3 3 3 3,7 6 6 6 3 3 8 8 3 3"));
        Assert.assertTrue((boolean)tester.isBad());
        Assert.assertEquals((String)"cover is a non-trivial connected sum", (String)tester.getCause());
    }

    public void test10() {
        EuclidicityTester tester = new EuclidicityTester(new DSymbol("72 3:2 4 6 8 10 12 14 16 18 20 22 24 26 28 30 32 34 36 38 40 42 44 46 48 50 52 54 56 58 60 62 64 66 68 70 72,6 3 5 12 9 11 18 15 17 24 21 23 30 27 29 36 33 35 42 39 41 48 45 47 54 51 53 60 57 59 66 63 65 72 69 71,7 8 13 14 19 20 18 17 22 21 24 23 31 32 37 38 43 44 42 41 46 45 48 47 55 56 61 62 67 68 66 65 70 69 72 71,2 6 5 25 26 27 28 29 30 49 50 51 52 53 54 63 64 65 66 61 62 34 33 36 44 43 48 47 46 45 71 72 67 68 69 70:3 3 3 3 3 3 3 3 3 3 3 3,3 3 3 3 3 3 3 3 3 3 3 3,8 4 4 6 6 12 3 3 6"));
        Assert.assertTrue((boolean)tester.isBad());
        Assert.assertEquals((String)"cover is a non-trivial connected sum", (String)tester.getCause());
    }

    public void testSmallList() {
        int[] good = new int[]{11, 65, 69, 71, 78, 89, 125};
        this.testMany("TestResources/ftmax.ds", 1, 1000, good, new int[0]);
    }

    /*
     * WARNING - void declaration
     */
    public void testMany(String filename, int start, int stop, int[] expectedGood, int[] expectedAmbiguous) {
        ArrayList<Integer> expected;
        InputStream in = ClassLoader.getSystemResourceAsStream(filename);
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        InputIterator input = new InputIterator(reader);
        LinkedList<Integer> good = new LinkedList<Integer>();
        LinkedList<Pair<Integer, DelaneySymbol<Integer>>> ambiguous = new LinkedList<Pair<Integer, DelaneySymbol<Integer>>>();
        boolean trace = expectedGood == null && expectedAmbiguous == null;
        int count = 0;
        while (input.hasNext() && count < stop) {
            if (++count < start) continue;
            DSymbol ds = (DSymbol)input.next();
            EuclidicityTester euclidicityTester = new EuclidicityTester(ds);
            if (trace) {
                String result = euclidicityTester.isGood() ? "good" : (euclidicityTester.isBad() ? "bad" : "ambiguous");
                System.out.println("Symbol " + count + " is " + result + ": " + euclidicityTester.getCause());
            }
            if (euclidicityTester.isGood()) {
                good.add(new Integer(count));
                continue;
            }
            if (euclidicityTester.isBad()) continue;
            ambiguous.add(new Pair<Integer, DelaneySymbol<Integer>>(new Integer(count), euclidicityTester.getOutcome()));
        }
        if (trace) {
            System.out.print(String.valueOf(good.size()) + " good symbols:");
            Iterator iter = good.iterator();
            while (iter.hasNext()) {
                System.out.print(" " + iter.next());
            }
            System.out.println();
            System.out.println(String.valueOf(ambiguous.size()) + " ambiguous symbols:");
            for (Pair pair : ambiguous) {
                System.out.println("  " + pair.getFirst() + " - " + pair.getSecond());
            }
            System.out.println();
        }
        if (expectedGood != null) {
            void var14_18;
            expected = new ArrayList<Integer>();
            boolean bl = false;
            while (var14_18 < expectedGood.length) {
                expected.add(new Integer(expectedGood[var14_18]));
                ++var14_18;
            }
            Collections.sort(expected);
            TestEuclidicityTester.assertEquals(good, expected);
        }
        if (expectedAmbiguous != null) {
            void var14_20;
            expected = new ArrayList();
            boolean bl = false;
            while (var14_20 < expectedAmbiguous.length) {
                expected.add(new Integer(expectedAmbiguous[var14_20]));
                ++var14_20;
            }
            Collections.sort(expected);
            TestEuclidicityTester.assertEquals(ambiguous, expected);
        }
    }
}

