/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.dsyms.derived;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.gavrog.box.collections.Iterators;
import org.gavrog.jane.fpgroups.FpGroup;
import org.gavrog.jane.numbers.Whole;
import org.gavrog.joss.dsyms.basic.DSymbol;
import org.gavrog.joss.dsyms.basic.DelaneySymbol;
import org.gavrog.joss.dsyms.derived.Covers;
import org.gavrog.joss.dsyms.derived.DSCover;
import org.gavrog.joss.dsyms.derived.FundamentalGroup;

public class TestCovers
extends TestCase {
    private List z2;
    private List z3;

    protected void setUp() throws Exception {
        super.setUp();
        this.z2 = new LinkedList();
        this.z2.add(Whole.ZERO);
        this.z2.add(Whole.ZERO);
        this.z3 = new LinkedList();
        this.z3.add(Whole.ZERO);
        this.z3.add(Whole.ZERO);
        this.z3.add(Whole.ZERO);
        super.setUp();
    }

    protected void tearDown() throws Exception {
        this.z2 = null;
        this.z3 = null;
        super.tearDown();
    }

    public void testFiniteUniversalCover1() {
        this.testFiniteUniversalCover(new DSymbol("1:1,1,1:3,5"), 120);
    }

    public void testFiniteUniversalCover2() {
        this.testFiniteUniversalCover(new DSymbol("1 3:1,1,1,1:3,3,3"), 120);
    }

    public void testFiniteUniversalCover3() {
        this.testFiniteUniversalCover(new DSymbol("1 4:1,1,1,1,1:3,3,3,3"), 720);
    }

    public void testAllCovers() {
        DSymbol ds = new DSymbol("1:1,1,1:3,3");
        HashSet<DSCover<Integer>> covers = new HashSet<DSCover<Integer>>(Iterators.asList(Covers.allCovers(ds)));
        TestCovers.assertEquals((int)11, (int)covers.size());
        TestCovers.assertTrue((boolean)covers.contains(ds));
        TestCovers.assertTrue((boolean)covers.contains(new DSymbol("2:2,2,2:3,3")));
        TestCovers.assertTrue((boolean)covers.contains(new DSymbol("3:1 3,2 3,1 3:3,3")));
        TestCovers.assertTrue((boolean)covers.contains(new DSymbol("4:2 3 4,1 3 4,1 2 4:3 3,3 3")));
        TestCovers.assertTrue((boolean)covers.contains(new DSymbol("6:2 4 6,6 3 5,2 4 6:3,3")));
        TestCovers.assertTrue((boolean)covers.contains(new DSymbol("6:2 4 6,6 3 5,2 5 6:3,3")));
        TestCovers.assertTrue((boolean)covers.contains(new DSymbol("6:1 3 5 6,2 3 4 6,1 4 5 6:3 3,3 3")));
        TestCovers.assertTrue((boolean)covers.contains(new DSymbol("8:2 4 6 8,6 3 5 8,4 3 7 8:3 3,3 3")));
        TestCovers.assertTrue((boolean)covers.contains(new DSymbol("12:2 4 6 8 12 11,6 3 5 9 10 12,7 8 4 10 11 12:3 3 3,3 3")));
        TestCovers.assertTrue((boolean)covers.contains(new DSymbol("12:2 4 6 8 9 11 12,6 3 5 9 8 10 12,7 8 3 4 10 11 12:3 3 3,3 3 3")));
        TestCovers.assertTrue((boolean)covers.contains(Covers.finiteUniversalCover(ds)));
    }

    public void testToroidalCover2D_1() {
        this.testToroidalCover2D(new DSymbol("1:1,1,1:3,6"), 12);
    }

    public void testToroidalCover2D_2() {
        this.testToroidalCover2D(new DSymbol("1:1,1,1:3,5"), 0);
    }

    public void testToroidalCover2D_3() {
        this.testToroidalCover2D(new DSymbol("3:1 2 3,2 3,1 3:8 4,3"), 24);
    }

    public void testPseudoToroidalCover3D_1() {
        this.testPseudoToroidalCover3D(new DSymbol("1 3:1,1,1,1:4,3,4"), 48);
    }

    public void testPseudoToroidalCover3D_2() {
        this.testPseudoToroidalCover3D(new DSymbol("1 3:1,1,1,1:4,3,3"), 0);
    }

    public void testPseudoToroidalCover3D_3() {
        this.testPseudoToroidalCover3D(new DSymbol("3 3:1 2 3,1 3,2 3,1 2 3:6 4,3,4 3"), 72);
    }

    private void testFiniteUniversalCover(DSymbol ds, int n) {
        DSCover<Integer> cov = Covers.finiteUniversalCover(ds);
        TestCovers.assertEquals((int)n, (int)cov.size());
        if (ds.dim() == 2 && ds.isSpherical2D()) {
            Assert.assertTrue((boolean)new Whole(4L).equals(cov.curvature2D()));
        }
        TestCovers.assertEquals((Object)ds, cov.minimal());
        FpGroup<String> G = new FundamentalGroup<Integer>(cov).getPresentation();
        TestCovers.assertEquals((int)0, (int)G.getGenerators().size());
        TestCovers.assertEquals((int)0, (int)G.getRelators().size());
        TestCovers.assertEquals(new LinkedList(), G.abelianInvariants());
        TestCovers.assertEquals((Object)ds.elements().next(), (Object)cov.image(cov.elements().next()));
    }

    private void testToroidalCover2D(DelaneySymbol ds, int n) {
        if (n == 0) {
            try {
                Covers.toroidalCover2D(ds);
                Assert.fail((String)"should throw an UnsupportedOperationException");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        } else {
            DSCover cov = Covers.toroidalCover2D(ds);
            TestCovers.assertEquals((int)n, (int)cov.size());
            TestCovers.assertTrue((boolean)cov.curvature2D().isZero());
            TestCovers.assertEquals((Object)ds, cov.minimal());
            FundamentalGroup<Integer> G = new FundamentalGroup<Integer>(cov);
            TestCovers.assertEquals((int)0, (int)G.getAxes().size());
            TestCovers.assertEquals((Object)this.z2, G.getPresentation().abelianInvariants());
            TestCovers.assertEquals(ds.elements().next(), cov.image(cov.elements().next()));
        }
    }

    private void testPseudoToroidalCover3D(DelaneySymbol ds, int n) {
        DSCover cov = Covers.pseudoToroidalCover3D(ds);
        if (n == 0) {
            TestCovers.assertNull(cov);
        } else {
            TestCovers.assertEquals((int)n, (int)cov.size());
            TestCovers.assertEquals((Object)ds, cov.minimal());
            FundamentalGroup<Integer> G = new FundamentalGroup<Integer>(cov);
            TestCovers.assertEquals((int)0, (int)G.getAxes().size());
            TestCovers.assertEquals((Object)this.z3, G.getPresentation().abelianInvariants());
            TestCovers.assertEquals(ds.elements().next(), cov.image(cov.elements().next()));
        }
    }
}

