/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.dsyms.derived;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.gavrog.joss.dsyms.basic.DSymbol;
import org.gavrog.joss.dsyms.basic.DelaneySymbol;
import org.gavrog.joss.dsyms.derived.Boundary;

public class TestBoundary
extends TestCase {
    private DelaneySymbol ds;

    protected void setUp() throws Exception {
        super.setUp();
        this.ds = new DSymbol("6:1 3 4 6,2 4 5 6,1 5 6 4:8 4,3 3");
    }

    protected void tearDown() throws Exception {
        this.ds = null;
        super.tearDown();
    }

    public void testBoundary() {
        Boundary<Integer> bound = new Boundary<Integer>(this.ds);
        Integer D1 = new Integer(1);
        Integer D2 = new Integer(2);
        Integer D3 = new Integer(3);
        Integer D5 = new Integer(5);
        Integer D6 = new Integer(6);
        Assert.assertTrue((boolean)bound.isOnBoundary(1, D1));
        Assert.assertEquals(new Boundary.Face<Integer>(0, D1), bound.neighbor(1, D1, 0));
        Assert.assertEquals((int)1, (int)bound.glueCountAtRidge(0, D1, 1));
        bound.glue(1, D1);
        Assert.assertFalse((boolean)bound.isOnBoundary(1, D1));
        Assert.assertEquals(new Boundary.Face<Integer>(0, D2), bound.neighbor(0, D1, 1));
        Assert.assertEquals(new Boundary.Face<Integer>(2, D2), bound.neighbor(2, D1, 1));
        Assert.assertEquals((int)2, (int)bound.glueCountAtRidge(0, D1, 1));
        try {
            bound.neighbor(1, D1, 0);
            Assert.fail((String)"should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            bound.glueCountAtRidge(1, D1, 0);
            Assert.fail((String)"should have thrown an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        bound.glue(0, D2);
        bound.glue(2, D2);
        bound.glue(2, D3);
        bound.glue(0, D5);
        Assert.assertEquals(new Boundary.Face<Integer>(1, D5), bound.neighbor(2, D1, 1));
        LinkedList Q = new LinkedList();
        bound.glueAndEnqueue(1, D3, Q);
        Assert.assertFalse((boolean)bound.isOnBoundary(1, D3));
        HashSet ridges = new HashSet();
        Iterator iter = Q.iterator();
        while (iter.hasNext()) {
            ridges.add(iter.next());
        }
        Assert.assertEquals((int)2, (int)ridges.size());
        Assert.assertTrue((boolean)ridges.contains(new Boundary.Face<Integer>(0, D1, 1)));
        Assert.assertTrue((boolean)ridges.contains(new Boundary.Face<Integer>(1, D6, 2)));
    }
}

