/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.dsyms.derived;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.gavrog.jane.fpgroups.ChoiceLimitExceededException;
import org.gavrog.jane.fpgroups.FpGroup;
import org.gavrog.jane.fpgroups.GroupAction;
import org.gavrog.jane.fpgroups.SmallActionsIterator;
import org.gavrog.jane.fpgroups.Stabilizer;
import org.gavrog.jane.numbers.Whole;
import org.gavrog.joss.dsyms.basic.DSymbol;
import org.gavrog.joss.dsyms.basic.DelaneySymbol;
import org.gavrog.joss.dsyms.basic.IndexList;
import org.gavrog.joss.dsyms.basic.Subsymbol;
import org.gavrog.joss.dsyms.derived.Covers;
import org.gavrog.joss.dsyms.derived.DSCover;
import org.gavrog.joss.dsyms.derived.FundamentalGroup;
import org.gavrog.joss.dsyms.derived.OrbifoldInvariant;
import org.gavrog.joss.dsyms.derived.Simplifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EuclidicityTester {
    private static final boolean LOGGING = false;
    private static final DSymbol[] goodlist = new DSymbol[]{new DSymbol("48 3:2 4 6 8 10 12 14 16 18 20 22 24 26 28 30 32 34 36 38 40 42 44 46 48,8 3 5 7 16 11 13 15 24 19 21 23 32 27 29 31 40 35 37 39 48 43 45 47,9 10 17 18 25 26 33 34 24 23 41 42 36 35 32 31 47 48 40 39 45 46 43 44,42 41 48 47 46 45 44 43 26 25 32 31 30 29 28 27 34 33 40 39 38 37 36 35:4 4 4 4 4 4,3 3 3 3 3 3 3 3,4 4 4 4 4 4"), new DSymbol("64 3:2 4 6 8 10 12 14 16 18 20 22 24 26 28 30 32 34 36 38 40 42 44 46 48 50 52 54 56 58 60 62 64,6 3 5 12 9 11 18 15 17 26 21 23 25 32 29 31 38 35 37 46 41 43 45 52 49 51 58 55 57 64 61 63,7 8 13 14 19 20 27 28 22 21 33 34 39 40 47 48 53 54 59 60 42 41 46 45 56 55 61 62 58 57 63 64,59 60 61 62 63 64 33 34 35 36 37 38 47 48 49 50 51 52 39 40 41 42 43 44 45 46 54 53 58 57 56 55:3 3 3 4 3 3 4 3 3 3,3 5 5 5 3 3 3 5,4 4 3 3 3 3 3 3 3 3")};
    private static final List<Whole> Z3 = Arrays.asList(Whole.ZERO, Whole.ZERO, Whole.ZERO);
    private static final List<Whole> empty = new LinkedList<Whole>();
    private static final Set<String> goodInvariants = new HashSet<String>();
    private final DSymbol ds;
    private final boolean useInvariant;
    private final int choicesFactor;
    private boolean done = false;
    private boolean good = false;
    private boolean bad = false;
    private DelaneySymbol<Integer> outcome = null;
    private String cause = null;

    static {
        Package pkg = EuclidicityTester.class.getPackage();
        String packagePath = pkg.getName().replaceAll("\\.", "/");
        String filePath = String.valueOf(packagePath) + "/euclideanInvariants.data";
        InputStream inStream = ClassLoader.getSystemResourceAsStream(filePath);
        BufferedReader reader = new BufferedReader(new InputStreamReader(inStream));
        while (true) {
            String line;
            try {
                line = reader.readLine();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            if (line == null) break;
            if (line.length() == 0 || line.trim().charAt(0) == '#') continue;
            goodInvariants.add(line.trim());
        }
    }

    public <T> EuclidicityTester(DelaneySymbol<T> ds, boolean useInvars, int factor) {
        if (ds.dim() != 3) {
            String s = "symbol must be 3-dimensional";
            throw new UnsupportedOperationException("symbol must be 3-dimensional");
        }
        this.ds = new DSymbol(ds);
        this.useInvariant = useInvars;
        this.choicesFactor = factor;
    }

    public <T> EuclidicityTester(DelaneySymbol<T> ds) {
        this(ds, true, 10000);
    }

    public boolean isGood() {
        this.compute();
        return this.good;
    }

    public boolean isBad() {
        this.compute();
        return this.bad;
    }

    public boolean isAmbiguous() {
        this.compute();
        return !this.good && !this.bad;
    }

    public String getCause() {
        return this.cause;
    }

    public DelaneySymbol<Integer> getOutcome() {
        return this.outcome;
    }

    public static <T> boolean invariantOkay(DelaneySymbol<T> ds) {
        return goodInvariants.contains(new OrbifoldInvariant<T>(ds).toString());
    }

    private void compute() {
        String invar;
        if (this.done) {
            return;
        }
        if (this.useInvariant && !goodInvariants.contains(invar = new OrbifoldInvariant<Integer>(this.ds).toString())) {
            this.decide(false, "orbifold invariants do not match");
            return;
        }
        DSCover<Integer> cover = Covers.pseudoToroidalCover3D(this.ds);
        if (cover == null) {
            this.decide(false, "no pseudo-toroidal cover");
            return;
        }
        DelaneySymbol<Integer> simpl = new Simplifier(cover).getSimplifiedSymbol();
        if (simpl.size() == 0) {
            this.decide(false, "cover is a lens space");
            return;
        }
        if (!simpl.isConnected()) {
            boolean bad = EuclidicityTester.badComponents(simpl);
            if (bad) {
                this.decide(false, "cover is a non-trivial connected sum");
                return;
            }
            this.giveUp("cover is a (potentially trivial) connected sum", simpl);
            return;
        }
        int i = 0;
        while (i < goodlist.length) {
            if (simpl.equals(goodlist[i])) {
                this.decide(true, "simplified cover recognized");
                return;
            }
            ++i;
        }
        FpGroup<String> G = new FundamentalGroup<Integer>(simpl).getPresentation();
        List<Whole> invariants = G.abelianInvariants();
        if (!invariants.equals(Z3)) {
            this.decide(false, "cover has at least one handle");
            return;
        }
        if (G.getRelators().size() == 0) {
            this.decide(false, "cover has free fundamental group");
            return;
        }
        boolean good = EuclidicityTester.checkAbelianInvariantsSubgroups(G, 2, Z3);
        if (!good) {
            this.decide(false, "bad subgroups for cover");
            return;
        }
        try {
            boolean index3Ok = this.checkSubgroupCount(G, 3, 21);
            if (!index3Ok) {
                this.decide(false, "bad subgroup count for cover");
                return;
            }
            boolean index4Ok = this.checkSubgroupCount(G, 4, 56);
            if (!index4Ok) {
                this.decide(false, "bad subgroup count for cover");
                return;
            }
        }
        catch (ChoiceLimitExceededException ex) {
            this.giveUp("runtime limits reached", simpl);
            return;
        }
        this.giveUp("no decision found", simpl);
    }

    private static <T> boolean badComponents(DelaneySymbol<T> ds) {
        IndexList idcs = new IndexList(ds);
        int countZ3 = 0;
        for (T D : ds.orbitReps(idcs)) {
            DSymbol component = new DSymbol(new Subsymbol<T>(ds, idcs, D));
            FpGroup<String> G = new FundamentalGroup<Integer>(component).getPresentation();
            List<Whole> invars = G.abelianInvariants();
            if (invars.equals(Z3)) {
                if (++countZ3 <= 1 && EuclidicityTester.checkAbelianInvariantsSubgroups(G, 2, Z3)) continue;
                return true;
            }
            if (invars.size() == 0) {
                if (EuclidicityTester.checkAbelianInvariantsSubgroups(G, 5, empty)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    private static boolean checkAbelianInvariantsSubgroups(FpGroup<String> G, int index, List<Whole> expected) {
        for (GroupAction groupAction : new SmallActionsIterator<String>(G, index, false)) {
            List<Whole> invar = new Stabilizer(groupAction, (Integer)groupAction.domain().next()).getPresentation().abelianInvariants();
            if (invar.equals(expected)) continue;
            return false;
        }
        return true;
    }

    private boolean checkSubgroupCount(FpGroup<String> G, int index, int expected) {
        int count;
        block4: {
            count = 0;
            SmallActionsIterator<String> actions = new SmallActionsIterator<String>(G, index, false);
            actions.setMaximalNumberOfChoices(expected * this.choicesFactor);
            do {
                try {
                    actions.next();
                }
                catch (NoSuchElementException ex) {
                    break block4;
                }
                catch (ChoiceLimitExceededException ex) {
                    throw ex;
                }
            } while (++count <= expected);
            return false;
        }
        return count == expected;
    }

    private String stats(SmallActionsIterator<String> actions) {
        return String.valueOf(actions.getChoicesSoFar()) + " choices performed in " + (double)actions.getTimeElapsed() / 1000.0 + " seconds.";
    }

    private void decide(boolean good, String cause) {
        if (good) {
            this.good = true;
        } else {
            this.bad = true;
        }
        this.cause = cause;
        this.done = true;
    }

    private void giveUp(String cause, DelaneySymbol<Integer> outcome) {
        this.outcome = outcome;
        this.cause = cause;
        this.done = true;
    }
}

